export interface RecommendationModel {
    lastUpdated: number;
    sessionId: string;
    sessionTimestamp: number;
    recommendations: Recommendation[];
    timelocked: string[];
}
export interface Recommendation {
    sourceId: string;
    extensionId: string;
    extensionDisplayName: string;
    description: string;
    shouldShowOnStartup: boolean;
    timestamp: number;
    userIgnored: boolean;
}
export declare enum Level {
    Info = "Info",
    Warn = "Warn",
    Error = "Error"
}
export declare enum UserChoice {
    Install = "Install",
    Never = "Never",
    Later = "Later"
}
/**
 * Telemetry Event
 */
export interface RecommendationTelemetryEvent {
    type?: string;
    name: string;
    properties?: any;
    measures?: any;
    traits?: any;
    context?: any;
}
/**
 * Service for sending Telemetry events
 */
export interface RecommendationsTelemetryService {
    /**
     * Sends the Telemetry event
     */
    send(event: RecommendationTelemetryEvent): Promise<void>;
}
//# sourceMappingURL=recommendationModel.d.ts.map