"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureParentExists = exports.deleteFile = exports.mkdir = exports.writeFile = exports.readFile = exports.exists = void 0;
/*-----------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the EPL v2.0 License. See LICENSE file in the project root for license information.
 *-----------------------------------------------------------------------------------------------*/
const vscode_1 = require("vscode");
//Hacky way to get Text(En|De)code work in both Node and Webworker environments
const globalObj = globalThis;
const decoder = new globalObj.TextDecoder();
const encoder = new globalObj.TextEncoder();
function exists(pathOrUri) {
    return __awaiter(this, void 0, void 0, function* () {
        const uri = getUri(pathOrUri);
        try {
            //    Logger.log('Checking ' + uri);
            yield vscode_1.workspace.fs.stat(uri);
            return true;
        }
        catch (e) {
            //    Logger.log(uri + ' doesn\'t exist');
            return false;
        }
    });
}
exports.exists = exists;
function readFile(pathOrUri) {
    return __awaiter(this, void 0, void 0, function* () {
        const uri = getUri(pathOrUri);
        //  Logger.log('Reading ' + uri);
        const read = yield vscode_1.workspace.fs.readFile(uri);
        return decoder.decode(read);
    });
}
exports.readFile = readFile;
function writeFile(pathOrUri, content) {
    return __awaiter(this, void 0, void 0, function* () {
        const uri = getUri(pathOrUri);
        yield ensureParentExists(uri);
        //  Logger.log('Writing ' + uri);
        const contentAsUint8Array = encoder.encode(content);
        return vscode_1.workspace.fs.writeFile(uri, contentAsUint8Array);
    });
}
exports.writeFile = writeFile;
function mkdir(pathOrUri) {
    return __awaiter(this, void 0, void 0, function* () {
        const uri = getUri(pathOrUri);
        //  Logger.log('Creating ' + uri);
        yield vscode_1.workspace.fs.createDirectory(uri);
    });
}
exports.mkdir = mkdir;
function deleteFile(pathOrUri) {
    return __awaiter(this, void 0, void 0, function* () {
        const uri = getUri(pathOrUri);
        //  Logger.log('Deleting ' + uri);
        return vscode_1.workspace.fs.delete(uri);
    });
}
exports.deleteFile = deleteFile;
function ensureParentExists(uri) {
    return __awaiter(this, void 0, void 0, function* () {
        const parent = vscode_1.Uri.joinPath(uri, '..');
        if (!(yield exists(parent))) {
            yield mkdir(parent);
        }
    });
}
exports.ensureParentExists = ensureParentExists;
function getUri(pathOrUri) {
    if (pathOrUri instanceof vscode_1.Uri) {
        return pathOrUri;
    }
    return vscode_1.Uri.file(pathOrUri);
}
//# sourceMappingURL=fsUtil.js.map