"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class StatusSeverity {
    static isOk(status) {
        return status
            && status.severity === 0;
    }
    static isInfo(status) {
        return StatusSeverity.testSeverity(1, status);
    }
    static isWarning(status) {
        return StatusSeverity.testSeverity(2, status);
    }
    static isError(status) {
        return StatusSeverity.testSeverity(4, status);
    }
    static isCancel(status) {
        return StatusSeverity.testSeverity(8, status);
    }
    static testSeverity(bitmask, status) {
        return status
            && (status.severity & bitmask) === bitmask;
    }
}
exports.StatusSeverity = StatusSeverity;
//# sourceMappingURL=statusSeverity.js.map