"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const messages_1 = require("../protocol/generated/messages");
const outgoing_1 = require("../protocol/generated/outgoing");
const common_1 = require("./common");
const serverState_1 = require("../protocol/generated/serverState");
/**
 * Server Outgoing async.
 * As of now this file is NOT auto-generated
 */
class OutgoingSynchronous {
    /**
    * Constructs a new discovery handler
    * @param connection message connection to the RSP
    * @param emitter event emitter to handle notification events
    */
    constructor(connection, emitter) {
        this.connection = connection;
        this.emitter = emitter;
    }
    /**
     * Synchronously adds discovery path to RSP by sending a notification and then waiting for
     * 'discoveryPathAdded' event to be fired
     * @param path path to the desired directory
     * @param timeout timeout in milliseconds
     */
    addDiscoveryPathSync(path, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        const discoveryPath = { filepath: path };
        const listener = (param) => {
            return param.filepath === discoveryPath.filepath;
        };
        return common_1.Common.sendRequestSync(this.connection, messages_1.Messages.Server.AddDiscoveryPathRequest.type, discoveryPath, this.emitter, 'discoveryPathAdded', listener, timeout, outgoing_1.ErrorMessages.ADDDISCOVERYPATH_TIMEOUT);
    }
    /**
     * Synchronously removes discovery path from RSP by sending a notification and then waiting for
     * 'discoveryPathRemoved' event to be fired
     * @param path path to the desired directory or a DiscoveryPath object containing the given filepath
     * @param timeout timeout in milliseconds
     */
    removeDiscoveryPathSync(path, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        let discoveryPath;
        if (typeof (path) === 'string') {
            discoveryPath = { filepath: path };
        }
        else {
            discoveryPath = path;
        }
        const listener = (param) => {
            return param.filepath === discoveryPath.filepath;
        };
        return common_1.Common.sendRequestSync(this.connection, messages_1.Messages.Server.RemoveDiscoveryPathRequest.type, discoveryPath, this.emitter, 'discoveryPathRemoved', listener, timeout, outgoing_1.ErrorMessages.REMOVEDISCOVERYPATH_TIMEOUT);
    }
    /**
     * Sends a request to start the given server and waits for 'serverStateChanged' event
     * until the server's state has changed to 'started'
     * @param launchParameters parameters to start the server with, see {@link Protocol.LaunchParameters}
     * @param timeout timeout in milliseconds
     */
    startServerSync(launchParameters, timeout = common_1.Common.VERY_LONG_TIMEOUT) {
        return new Promise((resolve, reject) => {
            const timer = setTimeout(() => {
                return reject(new Error(outgoing_1.ErrorMessages.STARTSERVERASYNC_TIMEOUT));
            }, timeout);
            let result;
            const listener = (state) => {
                if (state.server.id === launchParameters.params.id && state.state === serverState_1.ServerState.STARTED) {
                    result.then(() => {
                        clearTimeout(timer);
                        this.emitter.removeListener('serverStateChanged', listener);
                        resolve(state);
                    });
                }
            };
            this.emitter.prependListener('serverStateChanged', listener);
            result = this.connection.sendRequest(messages_1.Messages.Server.StartServerAsyncRequest.type, launchParameters);
        });
    }
    /**
     * Sends a request to stop the given server and waits for 'serverStateChanged' event
     * until the server's state has changed to 'stopped'
     * @param stopParameters server stopping parameters, set force to 'true' to force shutdown, see {@link Protocol.StopServerAttributes}
     * @param timeout timeout in milliseconds
     */
    stopServerSync(stopParameters, timeout = common_1.Common.VERY_LONG_TIMEOUT) {
        return new Promise((resolve, reject) => {
            const timer = setTimeout(() => {
                return reject(new Error(outgoing_1.ErrorMessages.STOPSERVERASYNC_TIMEOUT));
            }, timeout);
            let result;
            const listener = (state) => {
                if (state.server.id === stopParameters.id && state.state === serverState_1.ServerState.STOPPED) {
                    result.then(() => {
                        clearTimeout(timer);
                        this.emitter.removeListener('serverStateChanged', listener);
                        resolve(state);
                    });
                }
            };
            this.emitter.prependListener('serverStateChanged', listener);
            result = this.connection.sendRequest(messages_1.Messages.Server.StopServerAsyncRequest.type, stopParameters);
        });
    }
    /**
     * Sends notification to remove a server from RSP, then waits for the appropriate 'serverRemoved' event
     * @param serverHandle server handle containing the server id and type, see {@link Protocol.ServerHandle}
     * @param timeout timeout in milliseconds
     */
    deleteServerSync(serverHandle, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        const listener = (param) => {
            return param.id === serverHandle.id;
        };
        return common_1.Common.sendRequestSync(this.connection, messages_1.Messages.Server.DeleteServerRequest.type, serverHandle, this.emitter, 'serverRemoved', listener, timeout, outgoing_1.ErrorMessages.DELETESERVER_TIMEOUT);
    }
}
exports.OutgoingSynchronous = OutgoingSynchronous;
//# sourceMappingURL=outgoingsync.js.map