/// <reference types="node" />
import { Protocol } from '../protocol/generated/protocol';
import { MessageConnection } from 'vscode-jsonrpc';
import { EventEmitter } from 'events';
/**
 * Server Outgoing async.
 * As of now this file is NOT auto-generated
 */
export declare class OutgoingSynchronous {
    private connection;
    private emitter;
    /**
    * Constructs a new discovery handler
    * @param connection message connection to the RSP
    * @param emitter event emitter to handle notification events
    */
    constructor(connection: MessageConnection, emitter: EventEmitter);
    /**
     * Synchronously adds discovery path to RSP by sending a notification and then waiting for
     * 'discoveryPathAdded' event to be fired
     * @param path path to the desired directory
     * @param timeout timeout in milliseconds
     */
    addDiscoveryPathSync(path: string, timeout?: number): Promise<Protocol.DiscoveryPath>;
    /**
     * Synchronously removes discovery path from RSP by sending a notification and then waiting for
     * 'discoveryPathRemoved' event to be fired
     * @param path path to the desired directory or a DiscoveryPath object containing the given filepath
     * @param timeout timeout in milliseconds
     */
    removeDiscoveryPathSync(path: string | Protocol.DiscoveryPath, timeout?: number): Promise<Protocol.DiscoveryPath>;
    /**
     * Sends a request to start the given server and waits for 'serverStateChanged' event
     * until the server's state has changed to 'started'
     * @param launchParameters parameters to start the server with, see {@link Protocol.LaunchParameters}
     * @param timeout timeout in milliseconds
     */
    startServerSync(launchParameters: Protocol.LaunchParameters, timeout?: number): Promise<Protocol.ServerState>;
    /**
     * Sends a request to stop the given server and waits for 'serverStateChanged' event
     * until the server's state has changed to 'stopped'
     * @param stopParameters server stopping parameters, set force to 'true' to force shutdown, see {@link Protocol.StopServerAttributes}
     * @param timeout timeout in milliseconds
     */
    stopServerSync(stopParameters: Protocol.StopServerAttributes, timeout?: number): Promise<Protocol.ServerState>;
    /**
     * Sends notification to remove a server from RSP, then waits for the appropriate 'serverRemoved' event
     * @param serverHandle server handle containing the server id and type, see {@link Protocol.ServerHandle}
     * @param timeout timeout in milliseconds
     */
    deleteServerSync(serverHandle: Protocol.ServerHandle, timeout?: number): Promise<Protocol.ServerHandle>;
}
