/// <reference types="node" />
import { MessageConnection, RequestType, NotificationType } from 'vscode-jsonrpc';
import { EventEmitter } from 'events';
/**
 * Helper class for sending requests and notifications
 */
export declare class Common {
    static readonly SHORT_TIMEOUT: number;
    static readonly DEFAULT_TIMEOUT: number;
    static readonly LONG_TIMEOUT: number;
    static readonly VERY_LONG_TIMEOUT: number;
    /**
     * Template method for sending requests and receiving the response
     * @param connection the message connection to RSP server
     * @param messageType type of the message being sent
     * @param payload parameters of the message being sent
     * @param timeout timeout in milliseconds
     * @param timeoutMessage error message in case of timeout
     */
    static sendSimpleRequest<P, R>(connection: MessageConnection, messageType: RequestType<P, R, any, any>, payload: P, timeout: number, timeoutMessage: string): Promise<R>;
    /**

     * Template method for sending notifications and synchronously waiting for a response by subscribing to an event
     * @param connection the message connection to RSP server
     * @param messageType type of the message being sent
     * @param payload parameters of the message being sent
     * @param emitter event emitter used to subscribe for the response event
     * @param eventId id/name of the response event to wait for
     * @param listener callback to handle the response event parameters
     * @param timeout timeout in milliseconds
     * @param timeoutMessage error message in case of timeout
     */
    static sendRequestSync<P, R, E>(connection: MessageConnection, messageType: RequestType<P, R, any, any>, payload: P, emitter: EventEmitter, eventId: string, listener: (params: E) => boolean, timeout: number, timeoutMessage: string): Promise<E>;
    /**
     * Template method for sending simple notifications to the server
     * @param connection message connection to the server
     * @param messageType type of the notification being sent
     * @param payload payload (parameters) of the message being sent
     */
    static sendSimpleNotification<P>(connection: MessageConnection, messageType: NotificationType<P, any>, payload: P): void;
}
