import { Protocol } from './protocol';
import { MessageConnection } from 'vscode-jsonrpc';
/**
 * Server Outgoing
 */
export declare class Outgoing {
    private connection;
    /**
    * Constructs a new discovery handler
    * @param connection message connection to the RSP
    */
    constructor(connection: MessageConnection);
    registerClientCapabilities(param: Protocol.ClientCapabilitiesRequest, timeout?: number): Promise<Protocol.ServerCapabilitiesResponse>;
    shutdown(timeout?: number): void;
    disconnectClient(timeout?: number): void;
    getDiscoveryPaths(timeout?: number): Promise<Array<Protocol.DiscoveryPath>>;
    findServerBeans(param: Protocol.DiscoveryPath, timeout?: number): Promise<Array<Protocol.ServerBean>>;
    addDiscoveryPath(param: Protocol.DiscoveryPath, timeout?: number): Promise<Protocol.Status>;
    removeDiscoveryPath(param: Protocol.DiscoveryPath, timeout?: number): Promise<Protocol.Status>;
    getServerHandles(timeout?: number): Promise<Array<Protocol.ServerHandle>>;
    getServerTypes(timeout?: number): Promise<Array<Protocol.ServerType>>;
    deleteServer(param: Protocol.ServerHandle, timeout?: number): Promise<Protocol.Status>;
    getRequiredAttributes(param: Protocol.ServerType, timeout?: number): Promise<Protocol.Attributes>;
    getOptionalAttributes(param: Protocol.ServerType, timeout?: number): Promise<Protocol.Attributes>;
    createServer(param: Protocol.ServerAttributes, timeout?: number): Promise<Protocol.CreateServerResponse>;
    createServerWorkflow(param: Protocol.CreateServerWorkflowRequest, timeout?: number): Promise<Protocol.WorkflowResponse>;
    getServerAsJson(param: Protocol.ServerHandle, timeout?: number): Promise<Protocol.GetServerJsonResponse>;
    updateServer(param: Protocol.UpdateServerRequest, timeout?: number): Promise<Protocol.UpdateServerResponse>;
    getLaunchModes(param: Protocol.ServerType, timeout?: number): Promise<Array<Protocol.ServerLaunchMode>>;
    getRequiredLaunchAttributes(param: Protocol.LaunchAttributesRequest, timeout?: number): Promise<Protocol.Attributes>;
    getOptionalLaunchAttributes(param: Protocol.LaunchAttributesRequest, timeout?: number): Promise<Protocol.Attributes>;
    getLaunchCommand(param: Protocol.LaunchParameters, timeout?: number): Promise<Protocol.CommandLineDetails>;
    serverStartingByClient(param: Protocol.ServerStartingAttributes, timeout?: number): Promise<Protocol.Status>;
    serverStartedByClient(param: Protocol.LaunchParameters, timeout?: number): Promise<Protocol.Status>;
    getServerState(param: Protocol.ServerHandle, timeout?: number): Promise<Protocol.ServerState>;
    startServerAsync(param: Protocol.LaunchParameters, timeout?: number): Promise<Protocol.StartServerResponse>;
    stopServerAsync(param: Protocol.StopServerAttributes, timeout?: number): Promise<Protocol.Status>;
    getDeployables(param: Protocol.ServerHandle, timeout?: number): Promise<Protocol.ListDeployablesResponse>;
    listDeploymentOptions(param: Protocol.ServerHandle, timeout?: number): Promise<Protocol.ListDeploymentOptionsResponse>;
    addDeployable(param: Protocol.ServerDeployableReference, timeout?: number): Promise<Protocol.Status>;
    removeDeployable(param: Protocol.ServerDeployableReference, timeout?: number): Promise<Protocol.Status>;
    publish(param: Protocol.PublishServerRequest, timeout?: number): Promise<Protocol.Status>;
    publishAsync(param: Protocol.PublishServerRequest, timeout?: number): Promise<Protocol.Status>;
    listDownloadableRuntimes(timeout?: number): Promise<Protocol.ListDownloadRuntimeResponse>;
    downloadRuntime(param: Protocol.DownloadSingleRuntimeRequest, timeout?: number): Promise<Protocol.WorkflowResponse>;
    listServerActions(param: Protocol.ServerHandle, timeout?: number): Promise<Protocol.ListServerActionResponse>;
    executeServerAction(param: Protocol.ServerActionRequest, timeout?: number): Promise<Protocol.WorkflowResponse>;
    getJobs(timeout?: number): Promise<Array<Protocol.JobProgress>>;
    cancelJob(param: Protocol.JobHandle, timeout?: number): Promise<Protocol.Status>;
}
/**
 * Error messages
 */
export declare namespace ErrorMessages {
    const REGISTERCLIENTCAPABILITIES_TIMEOUT = "Failed to register client capabilities in time";
    const SHUTDOWN_TIMEOUT = "Failed to shutdown in time";
    const DISCONNECTCLIENT_TIMEOUT = "Failed to disconnect client in time";
    const GETDISCOVERYPATHS_TIMEOUT = "Failed to get discovery paths in time";
    const FINDSERVERBEANS_TIMEOUT = "Failed to find server beans in time";
    const ADDDISCOVERYPATH_TIMEOUT = "Failed to add discovery path in time";
    const REMOVEDISCOVERYPATH_TIMEOUT = "Failed to remove discovery path in time";
    const GETSERVERHANDLES_TIMEOUT = "Failed to get server handles in time";
    const GETSERVERTYPES_TIMEOUT = "Failed to get server types in time";
    const DELETESERVER_TIMEOUT = "Failed to delete server in time";
    const GETREQUIREDATTRIBUTES_TIMEOUT = "Failed to get required attributes in time";
    const GETOPTIONALATTRIBUTES_TIMEOUT = "Failed to get optional attributes in time";
    const CREATESERVER_TIMEOUT = "Failed to create server in time";
    const CREATESERVERWORKFLOW_TIMEOUT = "Failed to create server workflow in time";
    const GETSERVERASJSON_TIMEOUT = "Failed to get server as json in time";
    const UPDATESERVER_TIMEOUT = "Failed to update server in time";
    const GETLAUNCHMODES_TIMEOUT = "Failed to get launch modes in time";
    const GETREQUIREDLAUNCHATTRIBUTES_TIMEOUT = "Failed to get required launch attributes in time";
    const GETOPTIONALLAUNCHATTRIBUTES_TIMEOUT = "Failed to get optional launch attributes in time";
    const GETLAUNCHCOMMAND_TIMEOUT = "Failed to get launch command in time";
    const SERVERSTARTINGBYCLIENT_TIMEOUT = "Failed to server starting by client in time";
    const SERVERSTARTEDBYCLIENT_TIMEOUT = "Failed to server started by client in time";
    const GETSERVERSTATE_TIMEOUT = "Failed to get server state in time";
    const STARTSERVERASYNC_TIMEOUT = "Failed to start server async in time";
    const STOPSERVERASYNC_TIMEOUT = "Failed to stop server async in time";
    const GETDEPLOYABLES_TIMEOUT = "Failed to get deployables in time";
    const LISTDEPLOYMENTOPTIONS_TIMEOUT = "Failed to list deployment options in time";
    const ADDDEPLOYABLE_TIMEOUT = "Failed to add deployable in time";
    const REMOVEDEPLOYABLE_TIMEOUT = "Failed to remove deployable in time";
    const PUBLISH_TIMEOUT = "Failed to publish in time";
    const PUBLISHASYNC_TIMEOUT = "Failed to publish async in time";
    const LISTDOWNLOADABLERUNTIMES_TIMEOUT = "Failed to list downloadable runtimes in time";
    const DOWNLOADRUNTIME_TIMEOUT = "Failed to download runtime in time";
    const LISTSERVERACTIONS_TIMEOUT = "Failed to list server actions in time";
    const EXECUTESERVERACTION_TIMEOUT = "Failed to execute server action in time";
    const GETJOBS_TIMEOUT = "Failed to get jobs in time";
    const CANCELJOB_TIMEOUT = "Failed to cancel job in time";
}
