"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const messages_1 = require("./messages");
/**
 * Server incoming
 */
class Incoming {
    /**
     * Constructs a new discovery handler
     * @param connection message connection to the RSP
     * @param emitter event emitter to handle notification events
     */
    constructor(connection, emitter) {
        this.connection = connection;
        this.emitter = emitter;
        this.listen();
    }
    /**
     * Subscribes to notifications sent by the server
     */
    listen() {
        this.connection.onNotification(messages_1.Messages.Client.MessageBoxNotification.type, param => {
            this.emitter.emit('messageBox', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.DiscoveryPathAddedNotification.type, param => {
            this.emitter.emit('discoveryPathAdded', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.DiscoveryPathRemovedNotification.type, param => {
            this.emitter.emit('discoveryPathRemoved', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerAddedNotification.type, param => {
            this.emitter.emit('serverAdded', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerRemovedNotification.type, param => {
            this.emitter.emit('serverRemoved', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerAttributesChangedNotification.type, param => {
            this.emitter.emit('serverAttributesChanged', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerStateChangedNotification.type, param => {
            this.emitter.emit('serverStateChanged', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerProcessCreatedNotification.type, param => {
            this.emitter.emit('serverProcessCreated', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerProcessTerminatedNotification.type, param => {
            this.emitter.emit('serverProcessTerminated', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.ServerProcessOutputAppendedNotification.type, param => {
            this.emitter.emit('serverProcessOutputAppended', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.JobAddedNotification.type, param => {
            this.emitter.emit('jobAdded', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.JobRemovedNotification.type, param => {
            this.emitter.emit('jobRemoved', param);
        });
        this.connection.onNotification(messages_1.Messages.Client.JobChangedNotification.type, param => {
            this.emitter.emit('jobChanged', param);
        });
    }
    onPromptString(listener) {
        this.connection.onRequest(messages_1.Messages.Client.PromptStringRequest.type, listener);
    }
    onMessageBox(listener) {
        this.emitter.on('messageBox', listener);
    }
    removeOnMessageBox(listener) {
        this.emitter.removeListener('messageBox', listener);
    }
    onDiscoveryPathAdded(listener) {
        this.emitter.on('discoveryPathAdded', listener);
    }
    removeOnDiscoveryPathAdded(listener) {
        this.emitter.removeListener('discoveryPathAdded', listener);
    }
    onDiscoveryPathRemoved(listener) {
        this.emitter.on('discoveryPathRemoved', listener);
    }
    removeOnDiscoveryPathRemoved(listener) {
        this.emitter.removeListener('discoveryPathRemoved', listener);
    }
    onServerAdded(listener) {
        this.emitter.on('serverAdded', listener);
    }
    removeOnServerAdded(listener) {
        this.emitter.removeListener('serverAdded', listener);
    }
    onServerRemoved(listener) {
        this.emitter.on('serverRemoved', listener);
    }
    removeOnServerRemoved(listener) {
        this.emitter.removeListener('serverRemoved', listener);
    }
    onServerAttributesChanged(listener) {
        this.emitter.on('serverAttributesChanged', listener);
    }
    removeOnServerAttributesChanged(listener) {
        this.emitter.removeListener('serverAttributesChanged', listener);
    }
    onServerStateChanged(listener) {
        this.emitter.on('serverStateChanged', listener);
    }
    removeOnServerStateChanged(listener) {
        this.emitter.removeListener('serverStateChanged', listener);
    }
    onServerProcessCreated(listener) {
        this.emitter.on('serverProcessCreated', listener);
    }
    removeOnServerProcessCreated(listener) {
        this.emitter.removeListener('serverProcessCreated', listener);
    }
    onServerProcessTerminated(listener) {
        this.emitter.on('serverProcessTerminated', listener);
    }
    removeOnServerProcessTerminated(listener) {
        this.emitter.removeListener('serverProcessTerminated', listener);
    }
    onServerProcessOutputAppended(listener) {
        this.emitter.on('serverProcessOutputAppended', listener);
    }
    removeOnServerProcessOutputAppended(listener) {
        this.emitter.removeListener('serverProcessOutputAppended', listener);
    }
    onJobAdded(listener) {
        this.emitter.on('jobAdded', listener);
    }
    removeOnJobAdded(listener) {
        this.emitter.removeListener('jobAdded', listener);
    }
    onJobRemoved(listener) {
        this.emitter.on('jobRemoved', listener);
    }
    removeOnJobRemoved(listener) {
        this.emitter.removeListener('jobRemoved', listener);
    }
    onJobChanged(listener) {
        this.emitter.on('jobChanged', listener);
    }
    removeOnJobChanged(listener) {
        this.emitter.removeListener('jobChanged', listener);
    }
}
exports.Incoming = Incoming;
//# sourceMappingURL=incoming.js.map