"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wizard = void 0;
class Wizard {
    constructor() {
        this.pages = new Array();
    }
    addPages() {
    }
    addPage(page) {
        this.pages.push(page);
        page.setWizard(this);
    }
    canFinish() {
        for (let entry of this.pages) {
            if (!entry.isPageComplete()) {
                return false;
            }
        }
        return true;
    }
    getStartingPage() {
        if (this.pages.length > 0) {
            return this.pages[0];
        }
        return null;
    }
    getNextPage(page) {
        let index = this.pages.indexOf(page);
        if (index === this.pages.length - 1 || index === -1) {
            // last page or page not found
            return null;
        }
        return this.pages[index + 1];
    }
    getPreviousPage(page) {
        let index = this.pages.indexOf(page);
        if (index === 0 || index === -1) {
            // first page or page not found
            return null;
        }
        return this.pages[index - 1];
    }
    getPage(id) {
        for (let page of this.pages) {
            let pageId = page.getId();
            if (pageId === id) {
                return page;
            }
        }
        return null;
    }
    getPageCount() {
        return this.pages.length;
    }
    getPages() {
        return this.pages;
    }
    needsPreviousAndNextButtons() {
        throw new Error("Method not implemented.");
    }
    performCancel() {
    }
    performFinish() {
    }
    open() {
        this.addPages();
    }
    close() {
        throw new Error("Method not implemented.");
    }
}
exports.Wizard = Wizard;
//# sourceMappingURL=Wizard.js.map