import { IWizardPage } from './IWizardPage';
import { WizardPage } from './WizardPage';
import { WizardPageDefinition, FieldDefinitionState } from './WebviewWizard';
import { Template } from './pageImpl';
import { IWizardPageRenderer } from './IWizardPageRenderer';
import { WizardDefinition, WizardPageFieldDefinition } from '.';
export declare class WebviewWizardPage extends WizardPage implements IWizardPage {
    pageDefinition: WizardPageDefinition;
    wizardDefinition: WizardDefinition;
    fieldStateCache: Map<string, FieldDefinitionState>;
    constructor(pageDefinition: WizardPageDefinition, wizardDefinition: WizardDefinition);
    private initializeStateCache;
    private isWizardPageSectionDefinition;
    private findFocusedField;
    getPageDefinition(): WizardPageDefinition;
    /**
     * Validate the wizard page by updating the page complete flag only.
     *
     * @param parameters the current parameters.
     * @param previousParameters the previous parameters.
     */
    validateAndUpdatePageComplete(parameters: any, previousParameters: any): void;
    private getValidationStatus;
    private doValidate;
    /**
     * Validate the wizard page by updating the page complete flag and collect HTML content to update (as Template) for :
     *  - validation messages.
     *  - widget to redraw according a state (not enabled, not visible, etc)
     *
     * @param parameters the current parameters.
     * @param previousParameters the previous parameters.
     *
     * @returns Template collection
     */
    getValidationTemplates(parameters: any, previousParameters: any): Template[];
    private severityToImage;
    private severityToCSSClass;
    private validate;
    findFieldDefinition(id: string): WizardPageFieldDefinition | null;
    containsTemplate(id: string, templates: Template[]): boolean;
    getRenderer(): IWizardPageRenderer;
    getContentAsHTML(data: any): string;
}
//# sourceMappingURL=WebviewWizardPage.d.ts.map