import { WizardPageDefinition, WizardPageFieldDefinition, WizardPageSectionDefinition, WizardPageFieldOptionLabelProvider, FieldDefinitionState } from './WebviewWizard';
import { IWizardPageRenderer } from './IWizardPageRenderer';
interface ListComboGenerationCallback {
    generate(listId: string, value: string, label: string, selected: boolean): string;
}
export declare class StandardWizardPageRenderer implements IWizardPageRenderer {
    private stateMap;
    constructor(state: Map<string, FieldDefinitionState>);
    getContentAsHTML(definition: WizardPageDefinition, data: any): string;
    oneSectionAsString(section: WizardPageSectionDefinition, data: any): string;
    oneFieldAsString(field: WizardPageFieldDefinition, data: any): string;
    wrapOneFieldAsString(field: WizardPageFieldDefinition, data: any, contents: string): string;
    createHTMLField(field: WizardPageFieldDefinition, data: any): string;
    textBoxAsHTML(field: WizardPageFieldDefinition, data: any): string;
    numberAsHTML(field: WizardPageFieldDefinition, data: any): string;
    passwordAsHTML(field: WizardPageFieldDefinition, data: any): string;
    checkBoxAsHTML(field: WizardPageFieldDefinition, data: any): string;
    textAreaAsHTML(field: WizardPageFieldDefinition, data: any): string;
    radioGroupAsHTML(field: WizardPageFieldDefinition, data: any): string;
    selectAsHTML(field: WizardPageFieldDefinition, data: any): string;
    multiSelectAsHTML(field: WizardPageFieldDefinition, data: any): string;
    comboAsHTML(field: WizardPageFieldDefinition, data: any): string;
    filePickerAsHTML(field: WizardPageFieldDefinition, data: any): string;
    validationDiv(id: string): string;
    labelFor(fieldId: string, labelVal: string): string;
    labelForNoStyle(fieldId: string, labelVal: string): string;
    labelForInlineStyle(fieldId: string, style: string, labelVal: string): string;
    divClass(classname: string, inner: string, disabled?: boolean): string;
    divClassId(classname: string, id: string, inner: string): string;
    isFieldEnabled(oneField: WizardPageFieldDefinition, data: any): boolean;
    isFieldVisible(field: WizardPageFieldDefinition, data: any): boolean;
    getInitialValue(oneField: WizardPageFieldDefinition, data: any): string | undefined;
    getOnModificationJavascript(oneField: WizardPageFieldDefinition, defaultScript: string): string | undefined;
    getFieldPlaceHolder(field: WizardPageFieldDefinition): string | undefined;
    getFieldOptions(field: WizardPageFieldDefinition, data: any): any;
    getFieldOptionLabelProvider(field: WizardPageFieldDefinition): WizardPageFieldOptionLabelProvider | undefined;
    wrapHTMLField(oneField: WizardPageFieldDefinition, disabled: boolean, fieldContent: string, labelAfterField?: boolean, labelForNoStyle?: boolean): string;
    generateHTMLOptions(field: WizardPageFieldDefinition, data: any, callback: ListComboGenerationCallback): string;
    generateHTMLMultiOptions(field: WizardPageFieldDefinition, data: any): string;
}
export {};
//# sourceMappingURL=StandardWizardPageRenderer.d.ts.map