"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPreferenceOverridden = exports.getTelemetryConfiguration = exports.VSCodeSettings = void 0;
const vscode_1 = require("vscode");
const constants_1 = require("./constants");
class VSCodeSettings {
    isTelemetryEnabled() {
        return getTelemetryConfiguration().get('enabled', false);
    }
    isTelemetryConfigured() {
        return isPreferenceOverridden(constants_1.CONFIG_KEY + '.enabled');
    }
    updateTelemetryEnabledConfig(value) {
        return getTelemetryConfiguration().update('enabled', value, true);
    }
}
exports.VSCodeSettings = VSCodeSettings;
function getTelemetryConfiguration() {
    return vscode_1.workspace.getConfiguration(constants_1.CONFIG_KEY);
}
exports.getTelemetryConfiguration = getTelemetryConfiguration;
function isPreferenceOverridden(section) {
    const config = vscode_1.workspace.getConfiguration().inspect(section);
    return ((config === null || config === void 0 ? void 0 : config.workspaceFolderValue) !== undefined ||
        (config === null || config === void 0 ? void 0 : config.workspaceFolderLanguageValue) !== undefined ||
        (config === null || config === void 0 ? void 0 : config.workspaceValue) !== undefined ||
        (config === null || config === void 0 ? void 0 : config.workspaceLanguageValue) !== undefined ||
        (config === null || config === void 0 ? void 0 : config.globalValue) !== undefined ||
        (config === null || config === void 0 ? void 0 : config.globalLanguageValue) !== undefined);
}
exports.isPreferenceOverridden = isPreferenceOverridden;
//# sourceMappingURL=settings.js.map