"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.installExtensionUtil = exports.getInstalledExtensionName = exports.isExtensionInstalled = exports.promptUserUtil = void 0;
/*-----------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the EPL v2.0 License. See LICENSE file in the project root for license information.
 *-----------------------------------------------------------------------------------------------*/
const vscode_1 = require("vscode");
const recommendationModel_1 = require("../recommendationModel");
const promptUserUtil = (message, level, hideNever) => __awaiter(void 0, void 0, void 0, function* () {
    const actions = Object.keys(recommendationModel_1.UserChoice).filter((x) => x !== recommendationModel_1.UserChoice.Never || !hideNever);
    let choice = undefined;
    if (level === recommendationModel_1.Level.Info) {
        choice = yield vscode_1.window.showInformationMessage(message, ...actions);
    }
    else if (level === recommendationModel_1.Level.Warn) {
        choice = yield vscode_1.window.showWarningMessage(message, ...actions);
    }
    else if (level === recommendationModel_1.Level.Error) {
        choice = yield vscode_1.window.showErrorMessage(message, ...actions);
    }
    if (choice) {
        return choice;
    }
    return undefined;
});
exports.promptUserUtil = promptUserUtil;
const isExtensionInstalled = (id) => {
    return !!vscode_1.extensions.getExtension(id);
};
exports.isExtensionInstalled = isExtensionInstalled;
const getInstalledExtensionName = (id) => {
    if ((0, exports.isExtensionInstalled)(id)) {
        const e = vscode_1.extensions.getExtension(id);
        if (e) {
            return e.packageJSON.displayName || e.packageJSON.extensionDisplayName;
        }
    }
    return undefined;
};
exports.getInstalledExtensionName = getInstalledExtensionName;
/**
 * Install an extension
 *
 * @returns when the extension is installed
 * @throws if the user refuses to install the extension, or if the extension does not get installed within a timeout period
 */
const installExtensionUtil = (id, extensionDisplayName, timeout) => __awaiter(void 0, void 0, void 0, function* () {
    let installListenerDisposable;
    return new Promise((resolve, reject) => {
        installListenerDisposable = vscode_1.extensions.onDidChange(() => {
            if ((0, exports.isExtensionInstalled)(id)) {
                resolve();
            }
        });
        vscode_1.commands.executeCommand("workbench.extensions.installExtension", id)
            .then((_unused) => { }, reject);
        setTimeout(reject, timeout, new Error(`'${extensionDisplayName}' installation is taking a while, Cancelling!`));
    }).finally(() => {
        installListenerDisposable.dispose();
    });
});
exports.installExtensionUtil = installExtensionUtil;
//# sourceMappingURL=vscodeUtil.js.map