import { RecommendationModel } from '../recommendationModel';
import { IStorageService } from '../storageService';
export declare class StorageServiceImpl implements IStorageService {
    private static PERSISTENCE_FILENAME;
    private static LOCK_FILENAME;
    private storagePath;
    constructor(storagePath: string);
    private delay;
    /**
     * Run a given runnable while ensuring only 1 client can write to the data store at a time.
     * I am not convinced the lock mechanism is perfect.
     * @returns boolean - whether vscode is in a new session vs what the data store thought but only when a change to the model occurs. False otherwise
     */
    runWithLock(runnable: (model: RecommendationModel) => Promise<RecommendationModel | undefined>): Promise<boolean>;
    private acquireLock;
    private acquireLockOneTry;
    private getTimeFromLockFile;
    private getNonceFromLockFile;
    private deleteOldLockFile;
    private unlock;
    readRecommendationModel(): Promise<RecommendationModel | undefined>;
    private loadRecommendationModel;
    private loadOrDefaultRecommendationModel;
    writeKey(key: string, contents: string): Promise<string | undefined>;
    private resolvePath;
    private save;
    private readFromFile;
    private readFromFileOrUndefined;
    private writeToFile;
    private ensureStorageFolderExists;
}
export declare const generateNonce: () => string;
//# sourceMappingURL=storageServiceImpl.d.ts.map