import numpy as np

from ...app.canvas import Canvas
from ...util.event import EventEmitter
from ._util import TransformCache
from .chain import ChainTransform
from .linear import NullTransform, STTransform

# Copyright (c) Vispy Development Team. All Rights Reserved.
# Distributed under the (new) BSD License. See LICENSE.txt for more info.

class TransformSystem:
    def __init__(self, canvas: Canvas | None = None, dpi: float | None = None): ...
    def _update_if_maps_changed(self, transform, map_key, new_maps): ...
    def configure(
        self,
        viewport: tuple | None = None,
        fbo_size: tuple | None = None,
        fbo_rect: tuple | None = None,
        canvas: Canvas | None = None,
    ): ...
    @property
    def canvas(self): ...
    @canvas.setter
    def canvas(self, canvas): ...
    @property
    def dpi(self): ...
    @dpi.setter
    def dpi(self, dpi): ...
    @property
    def visual_transform(self): ...
    @visual_transform.setter
    def visual_transform(self, tr): ...
    @property
    def scene_transform(self): ...
    @scene_transform.setter
    def scene_transform(self, tr): ...
    @property
    def document_transform(self): ...
    @document_transform.setter
    def document_transform(self, tr): ...
    @property
    def canvas_transform(self): ...
    @canvas_transform.setter
    def canvas_transform(self, tr): ...
    @property
    def framebuffer_transform(self): ...
    @framebuffer_transform.setter
    def framebuffer_transform(self, tr): ...
    def get_transform(self, map_from: str = "visual", map_to: str = "render"): ...
    @property
    def pixel_scale(self): ...
