from collections import defaultdict
from typing import Any, Literal
from typing_extensions import Self

from sympy.core.cache import cacheit
from sympy.core.expr import Expr
from sympy.core.kind import Kind, _UndefinedKind
from sympy.core.operations import AssocOp

class NC_Marker:
    is_Order = ...
    is_Mul = ...
    is_Number = ...
    is_Poly = ...
    is_commutative = ...

_args_sortkey = ...

class Mul(Expr, AssocOp):
    __slots__ = ...
    args: tuple[Expr]
    is_Mul = ...
    _args_type = Expr
    _kind_dispatcher = ...
    @property
    def kind(self) -> Kind | _UndefinedKind: ...
    def could_extract_minus_sign(self) -> Literal[False]: ...
    def __neg__(self) -> Self: ...
    @classmethod
    def flatten(cls, seq): ...
    @classmethod
    def class_key(cls) -> tuple[Literal[3], Literal[0], str]: ...
    @cacheit
    def as_two_terms(self) -> tuple[Any, Self] | tuple[Any, Any | Self]: ...
    @cacheit
    def as_coeff_mul(
        self, *deps, rational=..., **kwargs
    ) -> tuple[Any | Self, tuple[Any, ...]] | tuple[Expr, tuple[()]] | tuple[Any, tuple[Any | Mul]] | tuple[Any, tuple[Expr]]: ...
    def as_coeff_Mul(
        self, rational=...
    ) -> tuple[Expr, Any] | tuple[Expr, Any | Self] | tuple[Any, Any | Self] | tuple[Any, Self]: ...
    def as_real_imag(self, deep=..., **hints) -> tuple[Self, Any] | tuple[Any, Any] | None: ...
    def matches(self, expr, repl_dict=..., old=...) -> dict[Any, Any] | None: ...
    def as_powers_dict(self) -> defaultdict[Any, int]: ...
    def as_numer_denom(self) -> tuple[Self, Self]: ...
    def as_base_exp(self) -> tuple[Self, Any] | tuple[Self, Expr | None]: ...

    _eval_is_commutative = ...
    def as_content_primitive(self, radical=..., clear=...) -> tuple[Any, Self]: ...
    def as_ordered_factors(self, order=...): ...

mul = ...

def prod(a, start=...) -> Any: ...
def expand_2arg(e): ...
