from typing import Callable, ClassVar
from typing_extensions import Self

from numpy import ndarray

from .._typing import ArrayLike, Float, MatrixLike
from ..base import BaseEstimator, ClassifierMixin

# Author: Robert Layton <robertlayton@gmail.com>
#         Olivier Grisel <olivier.grisel@ensta.org>
#
# License: BSD 3 clause

class NearestCentroid(ClassifierMixin, BaseEstimator):
    feature_names_in_: ndarray = ...
    n_features_in_: int = ...
    classes_: ndarray = ...
    centroids_: ArrayLike = ...

    _parameter_constraints: ClassVar[dict] = ...

    def __init__(self, metric: str | Callable = "euclidean", *, shrink_threshold: None | Float = None) -> None: ...
    def fit(self, X: MatrixLike | ArrayLike, y: ArrayLike) -> Self: ...
    def predict(self, X: MatrixLike | ArrayLike) -> ndarray: ...
