from typing import Any, Callable, ClassVar, Literal
from typing_extensions import Self

from numpy import ndarray
from numpy.random import RandomState

from .._typing import ArrayLike, Float, Int, MatrixLike
from ..base import BaseEstimator, ClassifierMixin
from .kernels import Kernel, Product

# Values required for approximating the logistic sigmoid by
# error functions. coefs are obtained via:
# x = np.array([0, 0.6, 2, 3.5, 4.5, np.inf])
# b = logistic(x)
# A = (erf(np.dot(x, self.lambdas)) + 1) / 2
# coefs = lstsq(A, b)[0]
LAMBDAS = ...
COEFS = ...

class _BinaryGaussianProcessClassifierLaplace(BaseEstimator):
    log_marginal_likelihood_value_: float = ...
    W_sr_: ArrayLike = ...
    pi_: ArrayLike = ...
    L_: ArrayLike = ...
    kernel_: Kernel = ...
    classes_: ArrayLike = ...
    y_train_: ArrayLike = ...
    X_train_: ArrayLike | list[Any] = ...

    def __init__(
        self,
        kernel: Product | None | Kernel = None,
        *,
        optimizer: Literal["fmin_l_bfgs_b"] | Callable = "fmin_l_bfgs_b",
        n_restarts_optimizer: Int = 0,
        max_iter_predict: Int = 100,
        warm_start: bool = False,
        copy_X_train: bool = True,
        random_state: RandomState | None | Int = None,
    ) -> None: ...
    def fit(
        self,
        X: MatrixLike | ArrayLike,
        y: ArrayLike,
    ) -> Self: ...
    def predict(self, X: MatrixLike | ArrayLike) -> ndarray: ...
    def predict_proba(self, X: MatrixLike | ArrayLike) -> ndarray: ...
    def log_marginal_likelihood(
        self,
        theta: None | ArrayLike = None,
        eval_gradient: bool = False,
        clone_kernel: bool = True,
    ) -> tuple[float, ndarray] | tuple[Float, ndarray] | Float: ...

class GaussianProcessClassifier(ClassifierMixin, BaseEstimator):
    feature_names_in_: ndarray = ...
    n_features_in_: int = ...
    n_classes_: int = ...
    classes_: ArrayLike = ...
    log_marginal_likelihood_value_: float = ...
    base_estimator_: BaseEstimator = ...

    _parameter_constraints: ClassVar[dict] = ...

    def __init__(
        self,
        kernel: Product | None | Kernel = None,
        *,
        optimizer: Literal["fmin_l_bfgs_b"] | None | Callable = "fmin_l_bfgs_b",
        n_restarts_optimizer: Int = 0,
        max_iter_predict: Int = 100,
        warm_start: bool = False,
        copy_X_train: bool = True,
        random_state: RandomState | None | Int = None,
        multi_class: Literal["one_vs_rest", "one_vs_one"] = "one_vs_rest",
        n_jobs: None | Int = None,
    ) -> None: ...
    def fit(self, X: MatrixLike | ArrayLike, y: ArrayLike) -> Self: ...
    def predict(self, X: MatrixLike | ArrayLike) -> ndarray: ...
    def predict_proba(self, X: MatrixLike | ArrayLike) -> ndarray: ...
    @property
    def kernel_(self) -> Product | Kernel: ...
    def log_marginal_likelihood(
        self,
        theta: None | ArrayLike = None,
        eval_gradient: bool = False,
        clone_kernel: bool = True,
    ) -> tuple[float, ndarray] | Float: ...
