from builtins import (
    bool as _bool,
    str as _str,
)
from collections.abc import (
    Callable,
    Hashable,
    Iterable,
    Iterator,
    KeysView,
    Mapping,
    MutableMapping,
    Sequence,
    ValuesView,
)
from datetime import (
    date,
    datetime,
    time,
    timedelta,
)
from pathlib import Path
from typing import (
    Any,
    ClassVar,
    Generic,
    Literal,
    NoReturn,
    Protocol,
    TypeAlias,
    TypeVar,
    final,
    overload,
    type_check_only,
)

from _typeshed import (
    SupportsAdd,
    SupportsGetItem,
    SupportsMul,
    SupportsRAdd,
    SupportsRMul,
    _T_contra,
)
from matplotlib.axes import (
    Axes as PlotAxes,
    SubplotBase,
)
import numpy as np
from pandas import (
    Index,
    Period,
    PeriodDtype,
    Timedelta,
    Timestamp,
)
from pandas.core.api import (
    Int8Dtype as Int8Dtype,
    Int16Dtype as Int16Dtype,
    Int32Dtype as Int32Dtype,
    Int64Dtype as Int64Dtype,
)
from pandas.core.arrays.boolean import BooleanDtype
from pandas.core.arrays.categorical import CategoricalAccessor
from pandas.core.arrays.datetimes import DatetimeArray
from pandas.core.arrays.timedeltas import TimedeltaArray
from pandas.core.base import (
    ArrayIndexSeriesTimedeltaNoSeq,
    ArrayIndexTimedeltaNoSeq,
    ElementOpsMixin,
    IndexOpsMixin,
    NumListLike,
    ScalarArrayIndexSeriesComplex,
    ScalarArrayIndexSeriesIntNoBool,
    ScalarArrayIndexSeriesJustComplex,
    ScalarArrayIndexSeriesJustFloat,
    ScalarArrayIndexSeriesJustInt,
    ScalarArrayIndexSeriesReal,
    ScalarArrayIndexSeriesTimedelta,
    SeriesComplex,
    SeriesReal,
    Supports_ProtoAdd,
    Supports_ProtoFloorDiv,
    Supports_ProtoMul,
    Supports_ProtoRAdd,
    Supports_ProtoRFloorDiv,
    Supports_ProtoRMul,
    Supports_ProtoRTrueDiv,
    Supports_ProtoTrueDiv,
)
from pandas.core.frame import DataFrame
from pandas.core.generic import NDFrame
from pandas.core.groupby.generic import SeriesGroupBy
from pandas.core.groupby.groupby import BaseGroupBy
from pandas.core.indexers import BaseIndexer
from pandas.core.indexes.accessors import DtDescriptor
from pandas.core.indexes.category import CategoricalIndex
from pandas.core.indexes.datetimes import DatetimeIndex
from pandas.core.indexes.interval import IntervalIndex
from pandas.core.indexes.multi import MultiIndex
from pandas.core.indexes.period import PeriodIndex
from pandas.core.indexes.timedeltas import TimedeltaIndex
from pandas.core.indexing import (
    _AtIndexer,
    _iAtIndexer,
    _iLocIndexer,
    _IndexSliceTuple,
    _LocIndexer,
)
from pandas.core.strings.accessor import StringMethods
from pandas.core.window import (
    Expanding,
    ExponentialMovingWindow,
)
from pandas.core.window.rolling import (
    Rolling,
    Window,
)
from typing_extensions import (
    Never,
    Self,
)
import xarray as xr

from pandas._libs.interval import (
    Interval,
    _OrderableT,
)
from pandas._libs.lib import _NoDefaultDoNotUse
from pandas._libs.missing import NAType
from pandas._libs.tslibs import BaseOffset
from pandas._libs.tslibs.nattype import NaTType
from pandas._typing import (
    S1,
    S2,
    S2_NSDT,
    T_COMPLEX,
    AggFuncTypeBase,
    AggFuncTypeDictFrame,
    AggFuncTypeSeriesToFrame,
    AnyAll,
    AnyArrayLike,
    ArrayLike,
    Axes,
    AxesData,
    Axis,
    AxisColumn,
    AxisIndex,
    BooleanDtypeArg,
    BytesDtypeArg,
    CalculationMethod,
    CategoryDtypeArg,
    ComplexDtypeArg,
    CompressionOptions,
    DropKeep,
    Dtype,
    DTypeLike,
    DtypeObj,
    FilePath,
    FillnaOptions,
    FloatDtypeArg,
    FloatFormatType,
    Frequency,
    GenericT,
    GenericT_co,
    GroupByObjectNonScalar,
    HashableT1,
    IgnoreRaise,
    IndexingInt,
    IndexKeyFunc,
    IndexLabel,
    IntDtypeArg,
    InterpolateOptions,
    IntervalClosedType,
    IntervalT,
    JoinHow,
    JSONSerializable,
    JsonSeriesOrient,
    Just,
    Label,
    Level,
    ListLike,
    ListLikeU,
    MaskType,
    NaPosition,
    NsmallestNlargestKeep,
    ObjectDtypeArg,
    PeriodFrequency,
    QuantileInterpolation,
    RandomState,
    ReindexMethod,
    Renamer,
    ReplaceValue,
    S2_contra,
    S2_NDT_contra,
    Scalar,
    ScalarT,
    SequenceNotStr,
    SeriesByT,
    SortKind,
    StrDtypeArg,
    StrLike,
    Suffixes,
    SupportsDType,
    T as _T,
    TimeAmbiguous,
    TimedeltaDtypeArg,
    TimestampDtypeArg,
    TimeUnit,
    TimeZones,
    ToTimestampHow,
    UIntDtypeArg,
    ValueKeyFunc,
    VoidDtypeArg,
    WriteBuffer,
    _T_co,
    np_1darray,
    np_ndarray,
    np_ndarray_anyint,
    np_ndarray_bool,
    np_ndarray_complex,
    np_ndarray_dt,
    np_ndarray_float,
    np_ndarray_num,
    np_ndarray_str,
    np_ndarray_td,
    npt,
    num,
)

from pandas.core.dtypes.base import ExtensionDtype
from pandas.core.dtypes.dtypes import CategoricalDtype

from pandas.plotting import PlotAccessor

_T_INTERVAL_NP = TypeVar("_T_INTERVAL_NP", bound=np.bytes_ | np.str_)

@type_check_only
class _SupportsAdd(Protocol[_T_co]):
    def __add__(self, value: Self, /) -> _T_co: ...

@type_check_only
class SupportsSelfSub(Protocol[_T_co]):
    def __sub__(self, x: Self, /) -> _T_co: ...

@type_check_only
class _SupportsMul(Protocol[_T_co]):
    def __mul__(self, value: Self, /) -> _T_co: ...

@type_check_only
class SupportsTruedivInt(Protocol[_T_co]):
    def __truediv__(self, value: int, /) -> _T_co: ...

class _iLocIndexerSeries(_iLocIndexer, Generic[S1]):
    # get item
    # Keep in sync with `Series.__getitem__`
    @overload
    def __getitem__(self, idx: IndexingInt) -> S1: ...
    @overload
    def __getitem__(
        self, idx: Index | Series | slice | np_ndarray_anyint
    ) -> Series[S1]: ...

    # set item
    # Keep in sync with `Series.__setitem__`
    @overload
    def __setitem__(self, idx: int, value: S1 | None) -> None: ...
    @overload
    def __setitem__(
        self,
        idx: Index | slice | np_ndarray_anyint | list[int],
        value: S1 | IndexOpsMixin[S1] | None,
    ) -> None: ...

class _LocIndexerSeries(_LocIndexer, Generic[S1]):
    # Keep in sync with `Series.__getitem__`
    # ignore needed because of mypy.  Overlapping, but we want to distinguish
    # having a tuple of just scalars, versus tuples that include slices or Index
    @overload
    def __getitem__(  # type: ignore[overload-overlap] # pyright: ignore[reportOverlappingOverload]
        self,
        idx: Scalar | tuple[Scalar, ...],
        # tuple case is for getting a specific element when using a MultiIndex
    ) -> S1: ...
    @overload
    def __getitem__(
        self,
        idx: (
            MaskType
            | Index
            | Series
            | SequenceNotStr[float | _str | Timestamp]
            | slice
            | _IndexSliceTuple
            | Sequence[_IndexSliceTuple]
            | Callable
        ),
        # _IndexSliceTuple is when having a tuple that includes a slice.  Could just
        # be s.loc[1, :], or s.loc[pd.IndexSlice[1, :]]
    ) -> Series[S1]: ...

    # Keep in sync with `Series.__setitem__`
    @overload
    def __setitem__(
        self,
        idx: IndexOpsMixin[S1] | MaskType | slice,
        value: S1 | ArrayLike | IndexOpsMixin[S1] | None,
    ) -> None: ...
    @overload
    def __setitem__(
        self,
        idx: _str,
        value: S1 | None,
    ) -> None: ...
    @overload
    def __setitem__(
        self,
        idx: MaskType | StrLike | _IndexSliceTuple | list[ScalarT],
        value: S1 | ArrayLike | IndexOpsMixin[S1] | None,
    ) -> None: ...

_DataLike: TypeAlias = ArrayLike | dict[str, np.ndarray] | SequenceNotStr[S1]
_DataLikeS1: TypeAlias = (
    ArrayLike | dict[_str, np.ndarray] | Sequence[S1] | IndexOpsMixin[S1]
)

class Series(IndexOpsMixin[S1], ElementOpsMixin[S1], NDFrame):
    # Define __index__ because mypy thinks Series follows protocol `SupportsIndex` https://github.com/pandas-dev/pandas-stubs/pull/1332#discussion_r2285648790
    __index__: ClassVar[None]
    __hash__: ClassVar[None]  # pyright: ignore[reportIncompatibleMethodOverride]

    @overload
    def __new__(
        cls,
        data: npt.NDArray[np.float64],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[float]: ...
    @overload
    def __new__(
        cls,
        data: Sequence[Never],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series: ...
    @overload
    def __new__(
        cls,
        data: Sequence[list[_str]],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[list[_str]]: ...
    @overload
    def __new__(
        cls,
        data: Sequence[_str],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[_str]: ...
    @overload
    def __new__(
        cls,
        data: (
            DatetimeIndex
            | Sequence[np.datetime64 | datetime | date]
            | dict[HashableT1, np.datetime64 | datetime | date]
            | np.datetime64
            | datetime
            | date
        ),
        index: AxesData | None = ...,
        dtype: TimestampDtypeArg = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[Timestamp]: ...
    @overload
    def __new__(
        cls,
        data: _DataLike,
        index: AxesData | None = ...,
        *,
        dtype: TimestampDtypeArg,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[Timestamp]: ...
    @overload
    def __new__(
        cls,
        data: _DataLike,
        index: AxesData | None = ...,
        *,
        dtype: CategoryDtypeArg,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[CategoricalDtype]: ...
    @overload
    def __new__(
        cls,
        data: PeriodIndex | Sequence[Period],
        index: AxesData | None = ...,
        dtype: PeriodDtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[Period]: ...
    @overload
    def __new__(
        cls,
        data: Sequence[BaseOffset],
        index: AxesData | None = ...,
        dtype: PeriodDtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[BaseOffset]: ...
    @overload
    def __new__(
        cls,
        data: (
            TimedeltaIndex
            | Sequence[np.timedelta64 | timedelta]
            | dict[HashableT1, np.timedelta64 | timedelta]
            | np.timedelta64
            | timedelta
        ),
        index: AxesData | None = ...,
        dtype: TimedeltaDtypeArg = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[Timedelta]: ...
    @overload
    def __new__(
        cls,
        data: (
            IntervalIndex[Interval[_OrderableT]]
            | Interval[_OrderableT]
            | Sequence[Interval[_OrderableT]]
            | dict[HashableT1, Interval[_OrderableT]]
        ),
        index: AxesData | None = ...,
        dtype: Literal["Interval"] = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[Interval[_OrderableT]]: ...
    @overload
    def __new__(  # type: ignore[overload-overlap]
        cls,
        data: Scalar | _DataLike | dict[HashableT1, Any] | None,
        index: AxesData | None = ...,
        *,
        dtype: type[S1],
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Self: ...
    @overload
    def __new__(  # type: ignore[overload-overlap] # pyright: ignore[reportOverlappingOverload]
        cls,
        data: Sequence[bool],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[bool]: ...
    @overload
    def __new__(  # type: ignore[overload-overlap]
        cls,
        data: Sequence[int],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[int]: ...
    @overload
    def __new__(
        cls,
        data: Sequence[float],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[float]: ...
    @overload
    def __new__(  # type: ignore[overload-cannot-match] # pyright: ignore[reportOverlappingOverload]
        cls,
        data: Sequence[int | float],
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series[float]: ...
    @overload
    def __new__(
        cls,
        data: (
            S1 | _DataLikeS1[S1] | dict[HashableT1, S1] | KeysView[S1] | ValuesView[S1]
        ),
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Self: ...
    @overload
    def __new__(
        cls,
        data: (
            Scalar
            | _DataLike
            | Mapping[HashableT1, Any]
            | BaseGroupBy
            | NaTType
            | NAType
            | None
        ) = ...,
        index: AxesData | None = ...,
        dtype: Dtype = ...,
        name: Hashable = ...,
        copy: bool = ...,
    ) -> Series: ...
    @property
    def hasnans(self) -> bool: ...
    @property
    def dtype(self) -> DtypeObj: ...
    @property
    def dtypes(self) -> DtypeObj: ...
    @property
    def name(self) -> Hashable | None: ...
    @name.setter
    def name(self, value: Hashable | None) -> None: ...
    @property
    def values(self) -> ArrayLike: ...
    def ravel(self, order: _str = ...) -> np.ndarray: ...
    def __len__(self) -> int: ...
    def view(self, dtype: Dtype | None = None) -> Series[S1]:
        """
Create a new view of the Series.

.. deprecated:: 2.2.0
    ``Series.view`` is deprecated and will be removed in a future version.
    Use :meth:`Series.astype` as an alternative to change the dtype.

This function will return a new Series with a view of the same
underlying values in memory, optionally reinterpreted with a new data
type. The new data type must preserve the same size in bytes as to not
cause index misalignment.

Parameters
----------
dtype : data type
    Data type object or one of their string representations.

Returns
-------
Series
    A new Series object as a view of the same data in memory.

See Also
--------
numpy.ndarray.view : Equivalent numpy function to create a new view of
    the same data in memory.

Notes
-----
Series are instantiated with ``dtype=float64`` by default. While
``numpy.ndarray.view()`` will return a view with the same data type as
the original array, ``Series.view()`` (without specified dtype)
will try using ``float64`` and may fail if the original data type size
in bytes is not the same.

Examples
--------
Use ``astype`` to change the dtype instead.
        """
        pass
    @final
    def __array_ufunc__(
        self, ufunc: Callable, method: _str, *inputs: Any, **kwargs: Any
    ) -> Any: ...
    def __array__(
        self, dtype: _str | np.dtype = ..., copy: bool | None = ...
    ) -> np_1darray: ...
    @property
    def axes(self) -> list: ...
    @final
    def __getattr__(self, name: _str) -> S1: ...

    # Keep in sync with `iLocIndexerSeries.__getitem__`
    @overload
    def __getitem__(self, idx: IndexingInt) -> S1: ...
    @overload
    def __getitem__(
        self, idx: Index | Series | slice | np_ndarray_anyint
    ) -> Series[S1]: ...
    # Keep in sync with `LocIndexerSeries.__getitem__`
    @overload
    def __getitem__(  # type: ignore[overload-overlap] # pyright: ignore[reportOverlappingOverload]
        self,
        idx: Scalar | tuple[Scalar, ...],
        # tuple case is for getting a specific element when using a MultiIndex
    ) -> S1: ...
    @overload
    def __getitem__(
        self,
        idx: (
            MaskType
            | Index
            | Series
            | SequenceNotStr[float | _str | Timestamp]
            | slice
            | _IndexSliceTuple
            | Sequence[_IndexSliceTuple]
            | Callable
        ),
        # _IndexSliceTuple is when having a tuple that includes a slice.  Could just
        # be s.loc[1, :], or s.loc[pd.IndexSlice[1, :]]
    ) -> Series[S1]: ...

    # Keep in sync with `_iLocIndexerSeries.__setitem__`
    @overload
    def __setitem__(self, idx: int, value: S1 | None) -> None: ...
    @overload
    def __setitem__(
        self,
        idx: Index | slice | np_ndarray_anyint | list[int],
        value: S1 | IndexOpsMixin[S1] | None,
    ) -> None: ...
    # Keep in sync with `_LocIndexerSeries.__setitem__`
    @overload
    def __setitem__(
        self,
        idx: Index | MaskType | slice,
        value: S1 | ArrayLike | IndexOpsMixin[S1] | None,
    ) -> None: ...
    @overload
    def __setitem__(
        self,
        idx: _str,
        value: S1 | None,
    ) -> None: ...
    @overload
    def __setitem__(
        self,
        idx: MaskType | StrLike | _IndexSliceTuple | list[ScalarT],
        value: S1 | ArrayLike | IndexOpsMixin[S1] | None,
    ) -> None: ...
    @overload
    def get(self, key: Hashable, default: None = None) -> S1 | None: ...
    @overload
    def get(self, key: Hashable, default: S1) -> S1: ...
    @overload
    def get(self, key: Hashable, default: _T) -> S1 | _T: ...
    def repeat(
        self, repeats: int | list[int], axis: AxisIndex | None = 0
    ) -> Series[S1]: ...
    @property
    def index(self) -> Index: ...
    @index.setter
    def index(
        self, idx: AnyArrayLike | SequenceNotStr[Hashable] | tuple[Hashable, ...]
    ) -> None: ...
    @overload
    def reset_index(
        self,
        level: Sequence[Level] | Level | None = ...,
        *,
        drop: Literal[False] = False,
        name: Level = ...,
        inplace: Literal[False] = False,
        allow_duplicates: bool = ...,
    ) -> DataFrame: ...
    @overload
    def reset_index(
        self,
        level: Sequence[Level] | Level | None = ...,
        *,
        drop: Literal[True],
        name: Level = ...,
        inplace: Literal[False] = False,
        allow_duplicates: bool = ...,
    ) -> Series[S1]: ...
    @overload
    def reset_index(
        self,
        level: Sequence[Level] | Level | None = ...,
        *,
        drop: bool = ...,
        name: Level = ...,
        inplace: Literal[True],
        allow_duplicates: bool = ...,
    ) -> None: ...
    @overload
    def to_string(
        self,
        buf: FilePath | WriteBuffer[_str],
        na_rep: _str = ...,
        float_format: FloatFormatType = ...,
        header: _bool = ...,
        index: _bool = ...,
        length: _bool = ...,
        dtype: _bool = ...,
        name: _bool = ...,
        max_rows: int | None = ...,
        min_rows: int | None = ...,
    ) -> None: ...
    @overload
    def to_string(
        self,
        buf: None = None,
        na_rep: _str = ...,
        float_format: FloatFormatType = ...,
        header: _bool = ...,
        index: _bool = ...,
        length: _bool = ...,
        dtype: _bool = ...,
        name: _bool = ...,
        max_rows: int | None = ...,
        min_rows: int | None = ...,
    ) -> _str: ...
    @overload
    def to_json(
        self,
        path_or_buf: FilePath | WriteBuffer[_str],
        *,
        orient: Literal["records"],
        date_format: Literal["epoch", "iso"] | None = ...,
        double_precision: int = ...,
        force_ascii: _bool = ...,
        date_unit: TimeUnit = ...,
        default_handler: Callable[[Any], JSONSerializable] | None = ...,
        lines: Literal[True],
        compression: CompressionOptions = ...,
        index: _bool = ...,
        indent: int | None = ...,
        mode: Literal["a"],
    ) -> None: ...
    @overload
    def to_json(
        self,
        path_or_buf: None = None,
        *,
        orient: Literal["records"],
        date_format: Literal["epoch", "iso"] | None = ...,
        double_precision: int = ...,
        force_ascii: _bool = ...,
        date_unit: TimeUnit = ...,
        default_handler: Callable[[Any], JSONSerializable] | None = ...,
        lines: Literal[True],
        compression: CompressionOptions = ...,
        index: _bool = ...,
        indent: int | None = ...,
        mode: Literal["a"],
    ) -> _str: ...
    @overload
    def to_json(
        self,
        path_or_buf: FilePath | WriteBuffer[_str] | WriteBuffer[bytes],
        *,
        orient: JsonSeriesOrient | None = ...,
        date_format: Literal["epoch", "iso"] | None = ...,
        double_precision: int = ...,
        force_ascii: _bool = ...,
        date_unit: TimeUnit = ...,
        default_handler: Callable[[Any], JSONSerializable] | None = ...,
        lines: _bool = ...,
        compression: CompressionOptions = ...,
        index: _bool = ...,
        indent: int | None = ...,
        mode: Literal["w"] = ...,
    ) -> None: ...
    @overload
    def to_json(
        self,
        path_or_buf: None = None,
        *,
        orient: JsonSeriesOrient | None = ...,
        date_format: Literal["epoch", "iso"] | None = ...,
        double_precision: int = ...,
        force_ascii: _bool = ...,
        date_unit: TimeUnit = ...,
        default_handler: Callable[[Any], JSONSerializable] | None = ...,
        lines: _bool = ...,
        compression: CompressionOptions = ...,
        index: _bool = ...,
        indent: int | None = ...,
        mode: Literal["w"] = ...,
    ) -> _str: ...
    @final
    def to_xarray(self) -> xr.DataArray: ...
    def items(self) -> Iterator[tuple[Hashable, S1]]: ...
    def keys(self) -> Index: ...
    @overload
    def to_dict(self, *, into: type[dict] = ...) -> dict[Any, S1]: ...
    @overload
    def to_dict(
        self, *, into: type[MutableMapping] | MutableMapping
    ) -> MutableMapping[Hashable, S1]: ...
    def to_frame(self, name: object | None = ...) -> DataFrame: ...
    @overload
    def groupby(
        self,
        by: Scalar,
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Scalar]:
        """
Group Series using a mapper or by a Series of columns.

A groupby operation involves some combination of splitting the
object, applying a function, and combining the results. This can be
used to group large amounts of data and compute operations on these
groups.

Parameters
----------
by : mapping, function, label, pd.Grouper or list of such
    Used to determine the groups for the groupby.
    If ``by`` is a function, it's called on each value of the object's
    index. If a dict or Series is passed, the Series or dict VALUES
    will be used to determine the groups (the Series' values are first
    aligned; see ``.align()`` method). If a list or ndarray of length
    equal to the selected axis is passed (see the `groupby user guide
    <https://pandas.pydata.org/pandas-docs/stable/user_guide/groupby.html#splitting-an-object-into-groups>`_),
    the values are used as-is to determine the groups. A label or list
    of labels may be passed to group by the columns in ``self``.
    Notice that a tuple is interpreted as a (single) key.
axis : {0 or 'index', 1 or 'columns'}, default 0
    Split along rows (0) or columns (1). For `Series` this parameter
    is unused and defaults to 0.

    .. deprecated:: 2.1.0

        Will be removed and behave like axis=0 in a future version.
        For ``axis=1``, do ``frame.T.groupby(...)`` instead.

level : int, level name, or sequence of such, default None
    If the axis is a MultiIndex (hierarchical), group by a particular
    level or levels. Do not specify both ``by`` and ``level``.
as_index : bool, default True
    Return object with group labels as the
    index. Only relevant for DataFrame input. as_index=False is
    effectively "SQL-style" grouped output. This argument has no effect
    on filtrations (see the `filtrations in the user guide
    <https://pandas.pydata.org/docs/dev/user_guide/groupby.html#filtration>`_),
    such as ``head()``, ``tail()``, ``nth()`` and in transformations
    (see the `transformations in the user guide
    <https://pandas.pydata.org/docs/dev/user_guide/groupby.html#transformation>`_).
sort : bool, default True
    Sort group keys. Get better performance by turning this off.
    Note this does not influence the order of observations within each
    group. Groupby preserves the order of rows within each group. If False,
    the groups will appear in the same order as they did in the original DataFrame.
    This argument has no effect on filtrations (see the `filtrations in the user guide
    <https://pandas.pydata.org/docs/dev/user_guide/groupby.html#filtration>`_),
    such as ``head()``, ``tail()``, ``nth()`` and in transformations
    (see the `transformations in the user guide
    <https://pandas.pydata.org/docs/dev/user_guide/groupby.html#transformation>`_).

    .. versionchanged:: 2.0.0

        Specifying ``sort=False`` with an ordered categorical grouper will no
        longer sort the values.

group_keys : bool, default True
    When calling apply and the ``by`` argument produces a like-indexed
    (i.e. :ref:`a transform <groupby.transform>`) result, add group keys to
    index to identify pieces. By default group keys are not included
    when the result's index (and column) labels match the inputs, and
    are included otherwise.

    .. versionchanged:: 1.5.0

       Warns that ``group_keys`` will no longer be ignored when the
       result from ``apply`` is a like-indexed Series or DataFrame.
       Specify ``group_keys`` explicitly to include the group keys or
       not.

    .. versionchanged:: 2.0.0

       ``group_keys`` now defaults to ``True``.

observed : bool, default False
    This only applies if any of the groupers are Categoricals.
    If True: only show observed values for categorical groupers.
    If False: show all values for categorical groupers.

    .. deprecated:: 2.1.0

        The default value will change to True in a future version of pandas.

dropna : bool, default True
    If True, and if group keys contain NA values, NA values together
    with row/column will be dropped.
    If False, NA values will also be treated as the key in groups.

Returns
-------
pandas.api.typing.SeriesGroupBy
    Returns a groupby object that contains information about the groups.

See Also
--------
resample : Convenience method for frequency conversion and resampling
    of time series.

Notes
-----
See the `user guide
<https://pandas.pydata.org/pandas-docs/stable/groupby.html>`__ for more
detailed usage and examples, including splitting an object into groups,
iterating through groups, selecting a group, aggregation, and more.

Examples
--------
>>> ser = pd.Series([390., 350., 30., 20.],
...                 index=['Falcon', 'Falcon', 'Parrot', 'Parrot'],
...                 name="Max Speed")
>>> ser
Falcon    390.0
Falcon    350.0
Parrot     30.0
Parrot     20.0
Name: Max Speed, dtype: float64
>>> ser.groupby(["a", "b", "a", "b"]).mean()
a    210.0
b    185.0
Name: Max Speed, dtype: float64
>>> ser.groupby(level=0).mean()
Falcon    370.0
Parrot     25.0
Name: Max Speed, dtype: float64
>>> ser.groupby(ser > 100).mean()
Max Speed
False     25.0
True     370.0
Name: Max Speed, dtype: float64

**Grouping by Indexes**

We can groupby different levels of a hierarchical index
using the `level` parameter:

>>> arrays = [['Falcon', 'Falcon', 'Parrot', 'Parrot'],
...           ['Captive', 'Wild', 'Captive', 'Wild']]
>>> index = pd.MultiIndex.from_arrays(arrays, names=('Animal', 'Type'))
>>> ser = pd.Series([390., 350., 30., 20.], index=index, name="Max Speed")
>>> ser
Animal  Type
Falcon  Captive    390.0
        Wild       350.0
Parrot  Captive     30.0
        Wild        20.0
Name: Max Speed, dtype: float64
>>> ser.groupby(level=0).mean()
Animal
Falcon    370.0
Parrot     25.0
Name: Max Speed, dtype: float64
>>> ser.groupby(level="Type").mean()
Type
Captive    210.0
Wild       185.0
Name: Max Speed, dtype: float64

We can also choose to include `NA` in group keys or not by defining
`dropna` parameter, the default setting is `True`.

>>> ser = pd.Series([1, 2, 3, 3], index=["a", 'a', 'b', np.nan])
>>> ser.groupby(level=0).sum()
a    3
b    3
dtype: int64

>>> ser.groupby(level=0, dropna=False).sum()
a    3
b    3
NaN  3
dtype: int64

>>> arrays = ['Falcon', 'Falcon', 'Parrot', 'Parrot']
>>> ser = pd.Series([390., 350., 30., 20.], index=arrays, name="Max Speed")
>>> ser.groupby(["a", "b", "a", np.nan]).mean()
a    210.0
b    350.0
Name: Max Speed, dtype: float64

>>> ser.groupby(["a", "b", "a", np.nan], dropna=False).mean()
a    210.0
b    350.0
NaN   20.0
Name: Max Speed, dtype: float64
        """
        pass
    @overload
    def groupby(
        self,
        by: DatetimeIndex,
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Timestamp]: ...
    @overload
    def groupby(
        self,
        by: TimedeltaIndex,
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Timedelta]: ...
    @overload
    def groupby(
        self,
        by: PeriodIndex,
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Period]: ...
    @overload
    def groupby(
        self,
        by: IntervalIndex[IntervalT],
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, IntervalT]: ...
    @overload
    def groupby(
        self,
        by: MultiIndex | GroupByObjectNonScalar,
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, tuple]: ...
    @overload
    def groupby(
        self,
        by: None,
        level: IndexLabel,  # level is required when by=None (passed as positional)
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Scalar]: ...
    @overload
    def groupby(
        self,
        by: None = None,
        *,
        level: IndexLabel,  # level is required when by=None (passed as keyword)
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Scalar]: ...
    @overload
    def groupby(
        self,
        by: Series[SeriesByT],
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, SeriesByT]: ...
    @overload
    def groupby(
        self,
        by: CategoricalIndex | Index | Series,
        level: IndexLabel | None = ...,
        as_index: _bool = ...,
        sort: _bool = ...,
        group_keys: _bool = ...,
        observed: _bool | _NoDefaultDoNotUse = ...,
        dropna: _bool = ...,
    ) -> SeriesGroupBy[S1, Any]: ...
    def count(self) -> int: ...
    def mode(self, dropna: bool = True) -> Series[S1]: ...
    @overload
    def unique(self: Series[Never]) -> np.ndarray: ...  # type: ignore[overload-overlap]
    @overload
    def unique(self: Series[Timestamp]) -> DatetimeArray: ...  # type: ignore[overload-overlap]
    @overload
    def unique(self: Series[Timedelta]) -> TimedeltaArray: ...  # type: ignore[overload-overlap]
    @overload
    def unique(self) -> np.ndarray: ...
    @overload
    def drop_duplicates(
        self,
        *,
        keep: DropKeep = ...,
        inplace: Literal[True],
        ignore_index: _bool = ...,
    ) -> None: ...
    @overload
    def drop_duplicates(
        self,
        *,
        keep: DropKeep = ...,
        inplace: Literal[False] = False,
        ignore_index: _bool = ...,
    ) -> Series[S1]: ...
    def duplicated(self, keep: DropKeep = "first") -> Series[_bool]: ...
    def idxmax(
        self,
        axis: AxisIndex = 0,
        skipna: _bool = True,
        *args: Any,
        **kwargs: Any,
    ) -> int | _str: ...
    def idxmin(
        self,
        axis: AxisIndex = 0,
        skipna: _bool = True,
        *args: Any,
        **kwargs: Any,
    ) -> int | _str: ...
    def round(self, decimals: int = 0, *args: Any, **kwargs: Any) -> Series[S1]: ...
    @overload
    def quantile(
        self,
        q: float = ...,
        interpolation: QuantileInterpolation = ...,
    ) -> float: ...
    @overload
    def quantile(
        self,
        q: ListLike,
        interpolation: QuantileInterpolation = ...,
    ) -> Series[S1]: ...
    def corr(
        self,
        other: Series[S1],
        method: Literal["pearson", "kendall", "spearman"] = ...,
        min_periods: int | None = ...,
    ) -> float: ...
    def cov(
        self, other: Series[S1], min_periods: int | None = None, ddof: int = 1
    ) -> float: ...
    @overload
    def diff(  # type: ignore[overload-overlap]
        self: Series[Never] | Series[int], periods: int = ...
    ) -> Series[float]:
        """
First discrete difference of element.

Calculates the difference of a Series element compared with another
element in the Series (default is element in previous row).

Parameters
----------
periods : int, default 1
    Periods to shift for calculating difference, accepts negative
    values.

Returns
-------
Series
    First differences of the Series.

See Also
--------
Series.pct_change: Percent change over given number of periods.
Series.shift: Shift index by desired number of periods with an
    optional time freq.
DataFrame.diff: First discrete difference of object.

Notes
-----
For boolean dtypes, this uses :meth:`operator.xor` rather than
:meth:`operator.sub`.
The result is calculated according to current dtype in Series,
however dtype of the result is always float64.

Examples
--------

Difference with previous row

>>> s = pd.Series([1, 1, 2, 3, 5, 8])
>>> s.diff()
0    NaN
1    0.0
2    1.0
3    1.0
4    2.0
5    3.0
dtype: float64

Difference with 3rd previous row

>>> s.diff(periods=3)
0    NaN
1    NaN
2    NaN
3    2.0
4    4.0
5    6.0
dtype: float64

Difference with following row

>>> s.diff(periods=-1)
0    0.0
1   -1.0
2   -1.0
3   -2.0
4   -3.0
5    NaN
dtype: float64

Overflow in input dtype

>>> s = pd.Series([1, 0], dtype=np.uint8)
>>> s.diff()
0      NaN
1    255.0
dtype: float64
        """
        pass
    @overload
    def diff(self: Series[_bool], periods: int = ...) -> Series: ...
    @overload
    def diff(
        self: Series[BooleanDtype], periods: int = ...
    ) -> Series[BooleanDtype]: ...
    @overload
    def diff(self: Series[Interval], periods: int = ...) -> Never: ...
    @overload
    def diff(
        self: SupportsGetItem[Scalar, SupportsSelfSub[S2]], periods: int = ...
    ) -> Series[S2]: ...
    def autocorr(self, lag: int = 1) -> float: ...
    @overload
    def dot(self, other: Series[S1]) -> Scalar: ...
    @overload
    def dot(self, other: DataFrame) -> Series[S1]: ...
    @overload
    def dot(
        self, other: ArrayLike | dict[_str, np.ndarray] | Sequence[S1] | Index[S1]
    ) -> np.ndarray: ...
    @overload
    def __matmul__(self, other: Series) -> Scalar: ...
    @overload
    def __matmul__(self, other: DataFrame) -> Series: ...
    @overload
    def __matmul__(self, other: np.ndarray) -> np.ndarray: ...
    @overload
    def __rmatmul__(self, other: Series) -> Scalar: ...
    @overload
    def __rmatmul__(self, other: DataFrame) -> Series: ...
    @overload
    def __rmatmul__(self, other: np.ndarray) -> np.ndarray: ...
    @overload
    def searchsorted(
        self,
        value: ListLike,
        side: Literal["left", "right"] = ...,
        sorter: ListLike | None = None,
    ) -> np_1darray[np.intp]: ...
    @overload
    def searchsorted(
        self,
        value: Scalar,
        side: Literal["left", "right"] = ...,
        sorter: ListLike | None = None,
    ) -> np.intp: ...
    @overload
    def compare(
        self,
        other: Series,
        align_axis: AxisIndex,
        keep_shape: bool = ...,
        keep_equal: bool = ...,
        result_names: Suffixes = ...,
    ) -> Series:
        """
Compare to another Series and show the differences.

Parameters
----------
other : Series
    Object to compare with.

align_axis : {0 or 'index', 1 or 'columns'}, default 1
    Determine which axis to align the comparison on.

    * 0, or 'index' : Resulting differences are stacked vertically
        with rows drawn alternately from self and other.
    * 1, or 'columns' : Resulting differences are aligned horizontally
        with columns drawn alternately from self and other.

keep_shape : bool, default False
    If true, all rows and columns are kept.
    Otherwise, only the ones with different values are kept.

keep_equal : bool, default False
    If true, the result keeps values that are equal.
    Otherwise, equal values are shown as NaNs.

result_names : tuple, default ('self', 'other')
    Set the dataframes names in the comparison.

    .. versionadded:: 1.5.0

Returns
-------
Series or DataFrame
    If axis is 0 or 'index' the result will be a Series.
    The resulting index will be a MultiIndex with 'self' and 'other'
    stacked alternately at the inner level.

    If axis is 1 or 'columns' the result will be a DataFrame.
    It will have two columns namely 'self' and 'other'.

See Also
--------
DataFrame.compare : Compare with another DataFrame and show differences.

Notes
-----
Matching NaNs will not appear as a difference.

Examples
--------
>>> s1 = pd.Series(["a", "b", "c", "d", "e"])
>>> s2 = pd.Series(["a", "a", "c", "b", "e"])

Align the differences on columns

>>> s1.compare(s2)
  self other
1    b     a
3    d     b

Stack the differences on indices

>>> s1.compare(s2, align_axis=0)
1  self     b
   other    a
3  self     d
   other    b
dtype: object

Keep all original rows

>>> s1.compare(s2, keep_shape=True)
  self other
0  NaN   NaN
1    b     a
2  NaN   NaN
3    d     b
4  NaN   NaN

Keep all original rows and also all original values

>>> s1.compare(s2, keep_shape=True, keep_equal=True)
  self other
0    a     a
1    b     a
2    c     c
3    d     b
4    e     e
        """
        pass
    @overload
    def compare(
        self,
        other: Series,
        align_axis: AxisColumn = ...,
        keep_shape: bool = ...,
        keep_equal: bool = ...,
        result_names: Suffixes = ...,
    ) -> DataFrame: ...
    def combine(
        self, other: Series[S1], func: Callable, fill_value: Scalar | None = ...
    ) -> Series[S1]: ...
    def combine_first(self, other: Series[S1]) -> Series[S1]: ...
    def update(self, other: Series[S1] | Sequence[S1] | Mapping[int, S1]) -> None: ...
    @overload
    def sort_values(
        self,
        *,
        axis: Axis = ...,
        ascending: _bool | Sequence[_bool] = ...,
        kind: SortKind = ...,
        na_position: NaPosition = ...,
        ignore_index: _bool = ...,
        inplace: Literal[True],
        key: ValueKeyFunc = ...,
    ) -> None: ...
    @overload
    def sort_values(
        self,
        *,
        axis: Axis = ...,
        ascending: _bool | Sequence[_bool] = ...,
        kind: SortKind = ...,
        na_position: NaPosition = ...,
        ignore_index: _bool = ...,
        inplace: Literal[False] = False,
        key: ValueKeyFunc = ...,
    ) -> Series[S1]: ...
    @overload
    def sort_index(
        self,
        *,
        axis: Axis = ...,
        level: Level | None = ...,
        ascending: _bool | Sequence[_bool] = ...,
        kind: SortKind = ...,
        na_position: NaPosition = ...,
        sort_remaining: _bool = ...,
        ignore_index: _bool = ...,
        inplace: Literal[True],
        key: IndexKeyFunc = ...,
    ) -> None: ...
    @overload
    def sort_index(
        self,
        *,
        axis: Axis = ...,
        level: Level | list[int] | list[_str] | None = ...,
        ascending: _bool | Sequence[_bool] = ...,
        kind: SortKind = ...,
        na_position: NaPosition = ...,
        sort_remaining: _bool = ...,
        ignore_index: _bool = ...,
        inplace: Literal[False] = False,
        key: IndexKeyFunc = ...,
    ) -> Series[S1]: ...
    def argsort(
        self,
        axis: AxisIndex = 0,
        kind: SortKind = "quicksort",
        order: None = None,
        stable: None = None,
    ) -> Series[int]: ...
    def nlargest(
        self, n: int = 5, keep: NsmallestNlargestKeep = "first"
    ) -> Series[S1]: ...
    def nsmallest(
        self, n: int = 5, keep: NsmallestNlargestKeep = "first"
    ) -> Series[S1]: ...
    def swaplevel(
        self, i: Level = -2, j: Level = -1, copy: _bool = True
    ) -> Series[S1]:
        """
Swap levels i and j in a :class:`MultiIndex`.

Default is to swap the two innermost levels of the index.

Parameters
----------
i, j : int or str
    Levels of the indices to be swapped. Can pass level name as string.
copy : bool, default True
            Whether to copy underlying data.

            .. note::
                The `copy` keyword will change behavior in pandas 3.0.
                `Copy-on-Write
                <https://pandas.pydata.org/docs/dev/user_guide/copy_on_write.html>`__
                will be enabled by default, which means that all methods with a
                `copy` keyword will use a lazy copy mechanism to defer the copy and
                ignore the `copy` keyword. The `copy` keyword will be removed in a
                future version of pandas.

                You can already get the future behavior and improvements through
                enabling copy on write ``pd.options.mode.copy_on_write = True``

Returns
-------
Series
    Series with levels swapped in MultiIndex.

Examples
--------
>>> s = pd.Series(
...     ["A", "B", "A", "C"],
...     index=[
...         ["Final exam", "Final exam", "Coursework", "Coursework"],
...         ["History", "Geography", "History", "Geography"],
...         ["January", "February", "March", "April"],
...     ],
... )
>>> s
Final exam  History     January      A
            Geography   February     B
Coursework  History     March        A
            Geography   April        C
dtype: object

In the following example, we will swap the levels of the indices.
Here, we will swap the levels column-wise, but levels can be swapped row-wise
in a similar manner. Note that column-wise is the default behaviour.
By not supplying any arguments for i and j, we swap the last and second to
last indices.

>>> s.swaplevel()
Final exam  January     History         A
            February    Geography       B
Coursework  March       History         A
            April       Geography       C
dtype: object

By supplying one argument, we can choose which index to swap the last
index with. We can for example swap the first index with the last one as
follows.

>>> s.swaplevel(0)
January     History     Final exam      A
February    Geography   Final exam      B
March       History     Coursework      A
April       Geography   Coursework      C
dtype: object

We can also define explicitly which indices we want to swap by supplying values
for both i and j. Here, we for example swap the first and second indices.

>>> s.swaplevel(0, 1)
History     Final exam  January         A
Geography   Final exam  February        B
History     Coursework  March           A
Geography   Coursework  April           C
dtype: object
        """
        pass
    def reorder_levels(self, order: list) -> Series[S1]: ...
    def explode(self, ignore_index: _bool = ...) -> Series[S1]: ...
    def unstack(
        self,
        level: IndexLabel = -1,
        fill_value: int | _str | dict | None = None,
        sort: _bool = True,
    ) -> DataFrame: ...
    @overload
    def map(
        self,
        arg: Callable[[S1], S2 | NAType] | Mapping[S1, S2] | Series[S2],
        na_action: Literal["ignore"] = ...,
    ) -> Series[S2]: ...
    @overload
    def map(
        self,
        arg: Callable[[S1 | NAType], S2 | NAType] | Mapping[S1, S2] | Series[S2],
        na_action: None = None,
    ) -> Series[S2]: ...
    @overload
    def map(
        self,
        arg: Callable[[Any], Any] | Mapping[Any, Any] | Series,
        na_action: Literal["ignore"] | None = ...,
    ) -> Series: ...
    @overload
    def aggregate(
        self: Series[int],
        func: Literal["mean"],
        axis: AxisIndex = ...,
        *args: Any,
        **kwargs: Any,
    ) -> float:
        """
Aggregate using one or more operations over the specified axis.

Parameters
----------
func : function, str, list or dict
    Function to use for aggregating the data. If a function, must either
    work when passed a Series or when passed to Series.apply.

    Accepted combinations are:

    - function
    - string function name
    - list of functions and/or function names, e.g. ``[np.sum, 'mean']``
    - dict of axis labels -> functions, function names or list of such.
axis : {0 or 'index'}
        Unused. Parameter needed for compatibility with DataFrame.
*args
    Positional arguments to pass to `func`.
**kwargs
    Keyword arguments to pass to `func`.

Returns
-------
scalar, Series or DataFrame

    The return can be:

    * scalar : when Series.agg is called with single function
    * Series : when DataFrame.agg is called with a single function
    * DataFrame : when DataFrame.agg is called with several functions

See Also
--------
Series.apply : Invoke function on a Series.
Series.transform : Transform function producing a Series with like indexes.

Notes
-----
The aggregation operations are always performed over an axis, either the
index (default) or the column axis. This behavior is different from
`numpy` aggregation functions (`mean`, `median`, `prod`, `sum`, `std`,
`var`), where the default is to compute the aggregation of the flattened
array, e.g., ``numpy.mean(arr_2d)`` as opposed to
``numpy.mean(arr_2d, axis=0)``.

`agg` is an alias for `aggregate`. Use the alias.

Functions that mutate the passed object can produce unexpected
behavior or errors and are not supported. See :ref:`gotchas.udf-mutation`
for more details.

A passed user-defined-function will be passed a Series for evaluation.

Examples
--------
>>> s = pd.Series([1, 2, 3, 4])
>>> s
0    1
1    2
2    3
3    4
dtype: int64

>>> s.agg('min')
1

>>> s.agg(['min', 'max'])
min   1
max   4
dtype: int64
        """
        pass
    @overload
    def aggregate(
        self,
        func: AggFuncTypeBase,
        axis: AxisIndex = ...,
        *args: Any,
        **kwargs: Any,
    ) -> S1: ...
    @overload
    def aggregate(
        self,
        func: AggFuncTypeSeriesToFrame = ...,
        axis: AxisIndex = ...,
        *args: Any,
        **kwargs: Any,
    ) -> Series: ...
    agg = aggregate
    @overload
    def transform(
        self,
        func: AggFuncTypeBase,
        axis: AxisIndex = ...,
        *args: Any,
        **kwargs: Any,
    ) -> Series[S1]:
        """
Call ``func`` on self producing a Series with the same axis shape as self.

Parameters
----------
func : function, str, list-like or dict-like
    Function to use for transforming the data. If a function, must either
    work when passed a Series or when passed to Series.apply. If func
    is both list-like and dict-like, dict-like behavior takes precedence.

    Accepted combinations are:

    - function
    - string function name
    - list-like of functions and/or function names, e.g. ``[np.exp, 'sqrt']``
    - dict-like of axis labels -> functions, function names or list-like of such.
axis : {0 or 'index'}
        Unused. Parameter needed for compatibility with DataFrame.
*args
    Positional arguments to pass to `func`.
**kwargs
    Keyword arguments to pass to `func`.

Returns
-------
Series
    A Series that must have the same length as self.

Raises
------
ValueError : If the returned Series has a different length than self.

See Also
--------
Series.agg : Only perform aggregating type operations.
Series.apply : Invoke function on a Series.

Notes
-----
Functions that mutate the passed object can produce unexpected
behavior or errors and are not supported. See :ref:`gotchas.udf-mutation`
for more details.

Examples
--------
>>> df = pd.DataFrame({'A': range(3), 'B': range(1, 4)})
>>> df
   A  B
0  0  1
1  1  2
2  2  3
>>> df.transform(lambda x: x + 1)
   A  B
0  1  2
1  2  3
2  3  4

Even though the resulting Series must have the same length as the
input Series, it is possible to provide several input functions:

>>> s = pd.Series(range(3))
>>> s
0    0
1    1
2    2
dtype: int64
>>> s.transform([np.sqrt, np.exp])
       sqrt        exp
0  0.000000   1.000000
1  1.000000   2.718282
2  1.414214   7.389056

You can call transform on a GroupBy object:

>>> df = pd.DataFrame({
...     "Date": [
...         "2015-05-08", "2015-05-07", "2015-05-06", "2015-05-05",
...         "2015-05-08", "2015-05-07", "2015-05-06", "2015-05-05"],
...     "Data": [5, 8, 6, 1, 50, 100, 60, 120],
... })
>>> df
         Date  Data
0  2015-05-08     5
1  2015-05-07     8
2  2015-05-06     6
3  2015-05-05     1
4  2015-05-08    50
5  2015-05-07   100
6  2015-05-06    60
7  2015-05-05   120
>>> df.groupby('Date')['Data'].transform('sum')
0     55
1    108
2     66
3    121
4     55
5    108
6     66
7    121
Name: Data, dtype: int64

>>> df = pd.DataFrame({
...     "c": [1, 1, 1, 2, 2, 2, 2],
...     "type": ["m", "n", "o", "m", "m", "n", "n"]
... })
>>> df
   c type
0  1    m
1  1    n
2  1    o
3  2    m
4  2    m
5  2    n
6  2    n
>>> df['size'] = df.groupby('c')['type'].transform(len)
>>> df
   c type size
0  1    m    3
1  1    n    3
2  1    o    3
3  2    m    4
4  2    m    4
5  2    n    4
6  2    n    4
        """
        pass
    @overload
    def transform(
        self,
        func: list[AggFuncTypeBase] | AggFuncTypeDictFrame,
        axis: AxisIndex = ...,
        *args: Any,
        **kwargs: Any,
    ) -> DataFrame: ...
    @overload
    def apply(
        self,
        func: Callable[
            ..., Scalar | Sequence | set | Mapping | NAType | frozenset | None
        ],
        convertDType: _bool = ...,
        args: tuple = ...,
        **kwargs: Any,
    ) -> Series: ...
    @overload
    def apply(
        self,
        func: Callable[..., BaseOffset],
        convertDType: _bool = ...,
        args: tuple = ...,
        **kwargs: Any,
    ) -> Series[BaseOffset]: ...
    @overload
    def apply(
        self,
        func: Callable[..., Series],
        convertDType: _bool = ...,
        args: tuple = ...,
        **kwargs: Any,
    ) -> DataFrame: ...
    @final
    def align(
        self,
        other: DataFrame | Series,
        join: JoinHow = "outer",
        axis: Axis | None = 0,
        level: Level | None = None,
        copy: _bool = True,
        fill_value: Scalar | NAType | None = None,
    ) -> tuple[Series, Series]: ...
    @overload
    def rename(
        self,
        index: Callable[[Any], Label],
        *,
        axis: Axis | None = ...,
        copy: bool = ...,
        inplace: Literal[True],
        level: Level | None = ...,
        errors: IgnoreRaise = ...,
    ) -> None: ...
    @overload
    def rename(
        self,
        index: Mapping[Any, Label],
        *,
        axis: Axis | None = ...,
        copy: bool = ...,
        inplace: Literal[True],
        level: Level | None = ...,
        errors: IgnoreRaise = ...,
    ) -> None: ...
    @overload
    def rename(
        self,
        index: Scalar | tuple[Hashable, ...] | None = None,
        *,
        axis: Axis | None = ...,
        copy: bool = ...,
        inplace: Literal[True],
        level: Level | None = ...,
        errors: IgnoreRaise = ...,
    ) -> Self: ...
    @overload
    def rename(
        self,
        index: Renamer | Scalar | tuple[Hashable, ...] | None = ...,
        *,
        axis: Axis | None = ...,
        copy: bool = ...,
        inplace: Literal[False] = False,
        level: Level | None = ...,
        errors: IgnoreRaise = ...,
    ) -> Self: ...
    @final
    def reindex_like(
        self,
        other: Series[S1],
        method: FillnaOptions | Literal["nearest"] | None = None,
        copy: _bool = True,
        limit: int | None = None,
        tolerance: Scalar | AnyArrayLike | Sequence[Scalar] | None = None,
    ) -> Self: ...
    @overload
    def fillna(
        self,
        value: Scalar | NAType | dict | Series[S1] | DataFrame | None = ...,
        *,
        axis: AxisIndex = ...,
        limit: int | None = ...,
        inplace: Literal[True],
    ) -> None: ...
    @overload
    def fillna(
        self,
        value: Scalar | NAType | dict | Series[S1] | DataFrame | None = ...,
        *,
        axis: AxisIndex = ...,
        limit: int | None = ...,
        inplace: Literal[False] = False,
    ) -> Series[S1]: ...
    @overload
    def replace(
        self,
        to_replace: ReplaceValue = ...,
        value: ReplaceValue = ...,
        *,
        regex: ReplaceValue = ...,
        inplace: Literal[True],
    ) -> None: ...
    @overload
    def replace(
        self,
        to_replace: ReplaceValue = ...,
        value: ReplaceValue = ...,
        *,
        regex: ReplaceValue = ...,
        inplace: Literal[False] = False,
    ) -> Series[S1]: ...
    def shift(
        self,
        periods: int | Sequence[int] = ...,
        freq: BaseOffset | timedelta | _str | None = None,
        axis: Axis = 0,
        fill_value: Scalar | NAType | None = ...,
    ) -> Series: ...
    def info(
        self,
        verbose: bool | None = ...,
        buf: WriteBuffer[_str] | None = ...,
        memory_usage: bool | Literal["deep"] | None = ...,
        show_counts: bool | None = ...,
    ) -> None:
        """
Print a concise summary of a Series.

This method prints information about a Series including
the index dtype, non-null values and memory usage.

.. versionadded:: 1.4.0

Parameters
----------
verbose : bool, optional
    Whether to print the full summary. By default, the setting in
    ``pandas.options.display.max_info_columns`` is followed.
buf : writable buffer, defaults to sys.stdout
    Where to send the output. By default, the output is printed to
    sys.stdout. Pass a writable buffer if you need to further process
    the output.

memory_usage : bool, str, optional
    Specifies whether total memory usage of the Series
    elements (including the index) should be displayed. By default,
    this follows the ``pandas.options.display.memory_usage`` setting.

    True always show memory usage. False never shows memory usage.
    A value of 'deep' is equivalent to "True with deep introspection".
    Memory usage is shown in human-readable units (base-2
    representation). Without deep introspection a memory estimation is
    made based in column dtype and number of rows assuming values
    consume the same memory amount for corresponding dtypes. With deep
    memory introspection, a real memory usage calculation is performed
    at the cost of computational resources. See the
    :ref:`Frequently Asked Questions <df-memory-usage>` for more
    details.
show_counts : bool, optional
    Whether to show the non-null counts. By default, this is shown
    only if the DataFrame is smaller than
    ``pandas.options.display.max_info_rows`` and
    ``pandas.options.display.max_info_columns``. A value of True always
    shows the counts, and False never shows the counts.

Returns
-------
None
    This method prints a summary of a Series and returns None.

See Also
--------
Series.describe: Generate descriptive statistics of Series.
Series.memory_usage: Memory usage of Series.

Examples
--------
>>> int_values = [1, 2, 3, 4, 5]
>>> text_values = ['alpha', 'beta', 'gamma', 'delta', 'epsilon']
>>> s = pd.Series(text_values, index=int_values)
>>> s.info()
<class 'pandas.core.series.Series'>
Index: 5 entries, 1 to 5
Series name: None
Non-Null Count  Dtype
--------------  -----
5 non-null      object
dtypes: object(1)
memory usage: 80.0+ bytes

Prints a summary excluding information about its values:

>>> s.info(verbose=False)
<class 'pandas.core.series.Series'>
Index: 5 entries, 1 to 5
dtypes: object(1)
memory usage: 80.0+ bytes

Pipe output of Series.info to buffer instead of sys.stdout, get
buffer content and writes to a text file:

>>> import io
>>> buffer = io.StringIO()
>>> s.info(buf=buffer)
>>> s = buffer.getvalue()
>>> with open("df_info.txt", "w",
...           encoding="utf-8") as f:  # doctest: +SKIP
...     f.write(s)
260

The `memory_usage` parameter allows deep introspection mode, specially
useful for big Series and fine-tune memory optimization:

>>> random_strings_array = np.random.choice(['a', 'b', 'c'], 10 ** 6)
>>> s = pd.Series(np.random.choice(['a', 'b', 'c'], 10 ** 6))
>>> s.info()
<class 'pandas.core.series.Series'>
RangeIndex: 1000000 entries, 0 to 999999
Series name: None
Non-Null Count    Dtype
--------------    -----
1000000 non-null  object
dtypes: object(1)
memory usage: 7.6+ MB

>>> s.info(memory_usage='deep')
<class 'pandas.core.series.Series'>
RangeIndex: 1000000 entries, 0 to 999999
Series name: None
Non-Null Count    Dtype
--------------    -----
1000000 non-null  object
dtypes: object(1)
memory usage: 55.3 MB
        """
        pass
    def memory_usage(self, index: _bool = True, deep: _bool = False) -> int: ...
    def isin(self, values: Iterable | Series[S1] | dict) -> Series[_bool]: ...
    def between(
        self,
        left: Scalar | ListLikeU,
        right: Scalar | ListLikeU,
        inclusive: Literal["both", "neither", "left", "right"] = ...,
    ) -> Series[_bool]: ...
    def isna(self) -> Series[_bool]: ...
    def isnull(self) -> Series[_bool]: ...
    def notna(self) -> Series[_bool]: ...
    def notnull(self) -> Series[_bool]: ...
    @overload
    def dropna(
        self,
        *,
        axis: AxisIndex = ...,
        inplace: Literal[True],
        how: AnyAll | None = ...,
        ignore_index: _bool = ...,
    ) -> None: ...
    @overload
    def dropna(
        self,
        *,
        axis: AxisIndex = ...,
        inplace: Literal[False] = False,
        how: AnyAll | None = ...,
        ignore_index: _bool = ...,
    ) -> Series[S1]: ...
    def to_timestamp(
        self,
        freq: PeriodFrequency | None = None,
        how: ToTimestampHow = "start",
        copy: _bool = True,
    ) -> Series[S1]: ...
    def to_period(
        self, freq: PeriodFrequency | None = None, copy: _bool = True
    ) -> DataFrame: ...
    @property
    def str(
        self,
    ) -> StringMethods[  # pyrefly: ignore[bad-specialization]
        Self,
        DataFrame,
        Series[bool],
        Series[list[_str]],
        Series[int],
        Series[bytes],
        Series[_str],
        Series,
    ]: ...
    dt = DtDescriptor()
    @property
    def plot(self) -> PlotAccessor: ...
    sparse = ...
    def hist(
        self,
        by: object | None = None,
        ax: PlotAxes | None = None,
        grid: _bool = True,
        xlabelsize: float | _str | None = None,
        xrot: float | None = None,
        ylabelsize: float | _str | None = None,
        yrot: float | None = None,
        figsize: tuple[float, float] | None = None,
        bins: int | Sequence = 10,
        backend: _str | None = None,
        legend: _bool = False,
        **kwargs: Any,
    ) -> SubplotBase: ...
    @final
    def swapaxes(
        self, axis1: AxisIndex, axis2: AxisIndex, copy: _bool = ...
    ) -> Series[S1]: ...
    @final
    def droplevel(self, level: Level | list[Level], axis: AxisIndex = 0) -> Self: ...
    def pop(self, item: Hashable) -> S1: ...
    @final
    def squeeze(self, axis: None = None) -> Series[S1] | Scalar: ...
    @final
    def __abs__(self) -> Series[S1]: ...
    @final
    def add_prefix(self, prefix: _str, axis: AxisIndex | None = None) -> Series[S1]: ...
    @final
    def add_suffix(self, suffix: _str, axis: AxisIndex | None = None) -> Series[S1]: ...
    def reindex(
        self,
        index: Axes | None = None,
        method: ReindexMethod | None = None,
        copy: bool = True,
        level: int | _str | None = None,
        fill_value: Scalar | None = None,
        limit: int | None = None,
        tolerance: float | Timedelta | None = None,
    ) -> Series[S1]:
        """
Conform Series to new index with optional filling logic.

Places NA/NaN in locations having no value in the previous index. A new object
is produced unless the new index is equivalent to the current one and
``copy=False``.

Parameters
----------

index : array-like, optional
    New labels for the index. Preferably an Index object to avoid
    duplicating data.
axis : int or str, optional
    Unused.
method : {None, 'backfill'/'bfill', 'pad'/'ffill', 'nearest'}
    Method to use for filling holes in reindexed DataFrame.
    Please note: this is only applicable to DataFrames/Series with a
    monotonically increasing/decreasing index.

    * None (default): don't fill gaps
    * pad / ffill: Propagate last valid observation forward to next
      valid.
    * backfill / bfill: Use next valid observation to fill gap.
    * nearest: Use nearest valid observations to fill gap.

copy : bool, default True
    Return a new object, even if the passed indexes are the same.

    .. note::
        The `copy` keyword will change behavior in pandas 3.0.
        `Copy-on-Write
        <https://pandas.pydata.org/docs/dev/user_guide/copy_on_write.html>`__
        will be enabled by default, which means that all methods with a
        `copy` keyword will use a lazy copy mechanism to defer the copy and
        ignore the `copy` keyword. The `copy` keyword will be removed in a
        future version of pandas.

        You can already get the future behavior and improvements through
        enabling copy on write ``pd.options.mode.copy_on_write = True``
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : scalar, default np.nan
    Value to use for missing values. Defaults to NaN, but can be any
    "compatible" value.
limit : int, default None
    Maximum number of consecutive elements to forward or backward fill.
tolerance : optional
    Maximum distance between original and new labels for inexact
    matches. The values of the index at the matching locations most
    satisfy the equation ``abs(index[indexer] - target) <= tolerance``.

    Tolerance may be a scalar value, which applies the same tolerance
    to all values, or list-like, which applies variable tolerance per
    element. List-like includes list, tuple, array, Series, and must be
    the same size as the index and its dtype must exactly match the
    index's type.

Returns
-------
Series with changed index.

See Also
--------
DataFrame.set_index : Set row labels.
DataFrame.reset_index : Remove row labels or move them to new columns.
DataFrame.reindex_like : Change to same indices as other DataFrame.

Examples
--------
``DataFrame.reindex`` supports two calling conventions

* ``(index=index_labels, columns=column_labels, ...)``
* ``(labels, axis={'index', 'columns'}, ...)``

We *highly* recommend using keyword arguments to clarify your
intent.

Create a dataframe with some fictional data.

>>> index = ['Firefox', 'Chrome', 'Safari', 'IE10', 'Konqueror']
>>> df = pd.DataFrame({'http_status': [200, 200, 404, 404, 301],
...                   'response_time': [0.04, 0.02, 0.07, 0.08, 1.0]},
...                   index=index)
>>> df
           http_status  response_time
Firefox            200           0.04
Chrome             200           0.02
Safari             404           0.07
IE10               404           0.08
Konqueror          301           1.00

Create a new index and reindex the dataframe. By default
values in the new index that do not have corresponding
records in the dataframe are assigned ``NaN``.

>>> new_index = ['Safari', 'Iceweasel', 'Comodo Dragon', 'IE10',
...              'Chrome']
>>> df.reindex(new_index)
               http_status  response_time
Safari               404.0           0.07
Iceweasel              NaN            NaN
Comodo Dragon          NaN            NaN
IE10                 404.0           0.08
Chrome               200.0           0.02

We can fill in the missing values by passing a value to
the keyword ``fill_value``. Because the index is not monotonically
increasing or decreasing, we cannot use arguments to the keyword
``method`` to fill the ``NaN`` values.

>>> df.reindex(new_index, fill_value=0)
               http_status  response_time
Safari                 404           0.07
Iceweasel                0           0.00
Comodo Dragon            0           0.00
IE10                   404           0.08
Chrome                 200           0.02

>>> df.reindex(new_index, fill_value='missing')
              http_status response_time
Safari                404          0.07
Iceweasel         missing       missing
Comodo Dragon     missing       missing
IE10                  404          0.08
Chrome                200          0.02

We can also reindex the columns.

>>> df.reindex(columns=['http_status', 'user_agent'])
           http_status  user_agent
Firefox            200         NaN
Chrome             200         NaN
Safari             404         NaN
IE10               404         NaN
Konqueror          301         NaN

Or we can use "axis-style" keyword arguments

>>> df.reindex(['http_status', 'user_agent'], axis="columns")
           http_status  user_agent
Firefox            200         NaN
Chrome             200         NaN
Safari             404         NaN
IE10               404         NaN
Konqueror          301         NaN

To further illustrate the filling functionality in
``reindex``, we will create a dataframe with a
monotonically increasing index (for example, a sequence
of dates).

>>> date_index = pd.date_range('1/1/2010', periods=6, freq='D')
>>> df2 = pd.DataFrame({"prices": [100, 101, np.nan, 100, 89, 88]},
...                    index=date_index)
>>> df2
            prices
2010-01-01   100.0
2010-01-02   101.0
2010-01-03     NaN
2010-01-04   100.0
2010-01-05    89.0
2010-01-06    88.0

Suppose we decide to expand the dataframe to cover a wider
date range.

>>> date_index2 = pd.date_range('12/29/2009', periods=10, freq='D')
>>> df2.reindex(date_index2)
            prices
2009-12-29     NaN
2009-12-30     NaN
2009-12-31     NaN
2010-01-01   100.0
2010-01-02   101.0
2010-01-03     NaN
2010-01-04   100.0
2010-01-05    89.0
2010-01-06    88.0
2010-01-07     NaN

The index entries that did not have a value in the original data frame
(for example, '2009-12-29') are by default filled with ``NaN``.
If desired, we can fill in the missing values using one of several
options.

For example, to back-propagate the last valid value to fill the ``NaN``
values, pass ``bfill`` as an argument to the ``method`` keyword.

>>> df2.reindex(date_index2, method='bfill')
            prices
2009-12-29   100.0
2009-12-30   100.0
2009-12-31   100.0
2010-01-01   100.0
2010-01-02   101.0
2010-01-03     NaN
2010-01-04   100.0
2010-01-05    89.0
2010-01-06    88.0
2010-01-07     NaN

Please note that the ``NaN`` value present in the original dataframe
(at index value 2010-01-03) will not be filled by any of the
value propagation schemes. This is because filling while reindexing
does not look at dataframe values, but only compares the original and
desired indexes. If you do want to fill in the ``NaN`` values present
in the original dataframe, use the ``fillna()`` method.

See the :ref:`user guide <basics.reindexing>` for more.
        """
        pass
    def filter(
        self,
        items: ListLike | None = None,
        like: _str | None = None,
        regex: _str | None = None,
        axis: AxisIndex | None = None,
    ) -> Series[S1]: ...
    @final
    def head(self, n: int = 5) -> Series[S1]: ...
    @final
    def tail(self, n: int = 5) -> Series[S1]: ...
    @final
    def sample(
        self,
        n: int | None = None,
        frac: float | None = None,
        replace: _bool = False,
        weights: _str | ListLike | np.ndarray | None = None,
        random_state: RandomState | None = None,
        axis: AxisIndex | None = None,
        ignore_index: _bool = False,
    ) -> Series[S1]: ...
    @overload
    def astype(
        self,
        dtype: BooleanDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[bool]: ...
    @overload
    def astype(
        self,
        dtype: IntDtypeArg | UIntDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[int]: ...
    @overload
    def astype(
        self,
        dtype: StrDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[_str]: ...
    @overload
    def astype(
        self,
        dtype: BytesDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[bytes]: ...
    @overload
    def astype(
        self,
        dtype: FloatDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[float]: ...
    @overload
    def astype(
        self,
        dtype: ComplexDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[complex]: ...
    @overload
    def astype(
        self,
        dtype: TimedeltaDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[Timedelta]: ...
    @overload
    def astype(
        self,
        dtype: TimestampDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[Timestamp]: ...
    @overload
    def astype(
        self,
        dtype: CategoryDtypeArg,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series[CategoricalDtype]: ...
    @overload
    def astype(
        self,
        dtype: ObjectDtypeArg | VoidDtypeArg | ExtensionDtype | DtypeObj,
        copy: _bool = ...,
        errors: IgnoreRaise = ...,
    ) -> Series: ...
    @final
    def copy(self, deep: _bool = True) -> Series[S1]: ...
    @final
    def infer_objects(self, copy: _bool = True) -> Series[S1]: ...
    @overload
    def ffill(
        self,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[True],
        limit: int | None = ...,
        limit_area: Literal["inside", "outside"] | None = ...,
    ) -> None: ...
    @overload
    def ffill(
        self,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[False] = False,
        limit: int | None = ...,
        limit_area: Literal["inside", "outside"] | None = ...,
    ) -> Series[S1]: ...
    @overload
    def bfill(
        self,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[True],
        limit: int | None = ...,
        limit_area: Literal["inside", "outside"] | None = ...,
    ) -> None: ...
    @overload
    def bfill(
        self,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[False] = False,
        limit: int | None = ...,
        limit_area: Literal["inside", "outside"] | None = ...,
    ) -> Series[S1]: ...
    @overload
    def interpolate(
        self,
        method: InterpolateOptions = ...,
        *,
        axis: AxisIndex | None = 0,
        limit: int | None = ...,
        inplace: Literal[True],
        limit_direction: Literal["forward", "backward", "both"] | None = ...,
        limit_area: Literal["inside", "outside"] | None = ...,
        **kwargs: Any,
    ) -> None: ...
    @overload
    def interpolate(
        self,
        method: InterpolateOptions = ...,
        *,
        axis: AxisIndex | None = 0,
        limit: int | None = ...,
        inplace: Literal[False] = False,
        limit_direction: Literal["forward", "backward", "both"] | None = ...,
        limit_area: Literal["inside", "outside"] | None = ...,
        **kwargs: Any,
    ) -> Series[S1]: ...
    @final
    def asof(
        self,
        where: Scalar | Sequence[Scalar],
        subset: _str | Sequence[_str] | None = None,
    ) -> Scalar | Series[S1]: ...
    @overload
    def clip(  # pyright: ignore[reportOverlappingOverload]
        self,
        lower: None = None,
        upper: None = None,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[True],
        **kwargs: Any,
    ) -> Self: ...
    @overload
    def clip(
        self,
        lower: AnyArrayLike | float | None = ...,
        upper: AnyArrayLike | float | None = ...,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[True],
        **kwargs: Any,
    ) -> None: ...
    @overload
    def clip(
        self,
        lower: AnyArrayLike | float | None = ...,
        upper: AnyArrayLike | float | None = ...,
        *,
        axis: AxisIndex | None = 0,
        inplace: Literal[False] = False,
        **kwargs: Any,
    ) -> Series[S1]: ...
    @final
    def asfreq(
        self,
        freq: Frequency,
        method: FillnaOptions | None = None,
        how: Literal["start", "end"] | None = None,
        normalize: _bool = False,
        fill_value: Scalar | None = None,
    ) -> Series[S1]: ...
    @final
    def at_time(
        self,
        time: _str | time,
        asof: _bool = False,
        axis: AxisIndex | None = 0,
    ) -> Series[S1]: ...
    @final
    def between_time(
        self,
        start_time: _str | time,
        end_time: _str | time,
        inclusive: IntervalClosedType = "both",
        axis: AxisIndex | None = 0,
    ) -> Series[S1]: ...
    @final
    def rank(
        self,
        axis: AxisIndex = 0,
        method: Literal["average", "min", "max", "first", "dense"] = "average",
        numeric_only: _bool = False,
        na_option: Literal["keep", "top", "bottom"] = "keep",
        ascending: _bool = True,
        pct: _bool = False,
    ) -> Series[float]: ...
    @overload
    def where(
        self,
        cond: (
            Series[S1]
            | Series[_bool]
            | np.ndarray
            | Callable[[Series[S1]], Series[bool]]
            | Callable[[S1], bool]
        ),
        other: S1 | Self | Callable[..., S1 | Self] = ...,
        *,
        inplace: Literal[True],
        axis: AxisIndex | None = 0,
        level: Level | None = ...,
    ) -> None: ...
    @overload
    def where(
        self,
        cond: (
            Series[S1]
            | Series[_bool]
            | np.ndarray
            | Callable[[Series[S1]], Series[bool]]
            | Callable[[S1], bool]
        ),
        other: Scalar | Self | Callable[..., Scalar | Self] = ...,
        *,
        inplace: Literal[False] = False,
        axis: AxisIndex | None = 0,
        level: Level | None = ...,
    ) -> Self: ...
    @overload
    def mask(
        self,
        cond: (
            Series[S1]
            | Series[_bool]
            | np.ndarray
            | Callable[[Series[S1]], Series[bool]]
            | Callable[[S1], bool]
        ),
        other: Scalar | Series[S1] | DataFrame | Callable | NAType | None = ...,
        *,
        inplace: Literal[True],
        axis: AxisIndex | None = 0,
        level: Level | None = ...,
    ) -> None: ...
    @overload
    def mask(
        self,
        cond: (
            Series[S1]
            | Series[_bool]
            | np.ndarray
            | Callable[[Series[S1]], Series[bool]]
            | Callable[[S1], bool]
        ),
        other: Scalar | Series[S1] | DataFrame | Callable | NAType | None = ...,
        *,
        inplace: Literal[False] = False,
        axis: AxisIndex | None = 0,
        level: Level | None = ...,
    ) -> Series[S1]: ...
    def case_when(
        self,
        caselist: list[
            tuple[
                Sequence[bool]
                | Series[bool]
                | Callable[[Series], Series | np.ndarray | Sequence[bool]],
                ListLikeU | Scalar | Callable[[Series], Series | np.ndarray],
            ],
        ],
    ) -> Series: ...
    @final
    def truncate(
        self,
        before: date | _str | int | None = ...,
        after: date | _str | int | None = ...,
        axis: AxisIndex | None = 0,
        copy: _bool = ...,
    ) -> Series[S1]: ...
    @final
    def tz_convert(
        self,
        tz: TimeZones,
        axis: AxisIndex = 0,
        level: Level | None = None,
        copy: _bool = True,
    ) -> Series[S1]: ...
    @final
    def tz_localize(
        self,
        tz: TimeZones,
        axis: AxisIndex = 0,
        level: Level | None = None,
        copy: _bool = True,
        ambiguous: TimeAmbiguous = "raise",
        nonexistent: _str = "raise",
    ) -> Series[S1]: ...
    @final
    def abs(self) -> Series[S1]: ...
    @final
    def describe(
        self,
        percentiles: list[float] | None = ...,
        include: Literal["all"] | list[S1] | None = ...,
        exclude: S1 | list[S1] | None = ...,
    ) -> Series[S1]: ...
    @final
    def pct_change(
        self,
        periods: int = 1,
        fill_method: None = None,
        freq: Frequency | timedelta | None = None,
    ) -> Series[float]: ...
    @final
    def first_valid_index(self) -> Scalar: ...
    @final
    def last_valid_index(self) -> Scalar: ...
    @overload
    def value_counts(  # pyrefly: ignore
        self,
        normalize: Literal[False] = False,
        sort: _bool = ...,
        ascending: _bool = ...,
        bins: int | None = ...,
        dropna: _bool = ...,
    ) -> Series[int]: ...
    @overload
    def value_counts(
        self,
        normalize: Literal[True],
        sort: _bool = ...,
        ascending: _bool = ...,
        bins: int | None = ...,
        dropna: _bool = ...,
    ) -> Series[float]: ...
    @final
    @property
    def T(self) -> Self: ...
    # The rest of these were left over from the old
    # stubs we shipped in preview. They may belong in
    # the base classes in some cases; I expect stubgen
    # just failed to generate these so I couldn't match
    # them up.
    @overload
    def __add__(self: Series[Never], other: complex | ListLike) -> Series: ...
    @overload
    def __add__(self, other: Index[Never] | Series[Never]) -> Series: ...
    @overload
    def __add__(self: Series[Timestamp], other: np_ndarray_dt) -> Never: ...
    @overload
    def __add__(
        self: Series[Timestamp],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
            | BaseOffset
        ),
    ) -> Series[Timestamp]: ...
    @overload
    def __add__(
        self: Series[Timedelta],
        other: (
            datetime | np.datetime64 | np_ndarray_dt | DatetimeIndex | Series[Timestamp]
        ),
    ) -> Series[Timestamp]: ...
    @overload
    def __add__(
        self: Series[Timedelta],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __add__(
        self: Supports_ProtoAdd[S2_contra, S2], other: S2_contra | Sequence[S2_contra]
    ) -> Series[S2]: ...
    @overload
    def __add__(
        self: Series[S2_contra], other: SupportsRAdd[S2_contra, S2]
    ) -> Series[S2]: ...
    # pandas-dev/pandas#62353
    @overload
    def __add__(
        self: Series[S2_NDT_contra], other: Sequence[SupportsRAdd[S2_NDT_contra, S2]]
    ) -> Series[S2]: ...
    @overload
    def __add__(
        self: Series[T_COMPLEX], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __add__(
        self: Series[bool], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[int]: ...
    @overload
    def __add__(
        self: Series[T_COMPLEX], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __add__(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
    ) -> Series[float]: ...
    @overload
    def __add__(
        self: Series[T_COMPLEX], other: np_ndarray_float | Index[float] | Series[float]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __add__(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
    ) -> Series[complex]: ...
    @overload
    def __add__(
        self: Series[_str],
        other: (
            np_ndarray_bool | np_ndarray_anyint | np_ndarray_float | np_ndarray_complex
        ),
    ) -> Never: ...
    @overload
    def __add__(
        self: Series[_str], other: np_ndarray_str | Index[_str] | Series[_str]
    ) -> Series[_str]: ...
    @overload
    def add(
        self: Series[Never],
        other: complex | ListLike,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series:
        """
Return Addition of series and other, element-wise (binary operator `add`).

Equivalent to ``series + other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.radd : Reverse of the Addition operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.add(b, fill_value=0)
a    2.0
b    1.0
c    1.0
d    1.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def add(
        self,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series: ...
    @overload
    def add(
        self: Series[Timestamp],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
            | BaseOffset
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timestamp]: ...
    @overload
    def add(
        self: Series[Timedelta],
        other: (
            datetime
            | Sequence[datetime]
            | np.datetime64
            | np_ndarray_dt
            | DatetimeIndex
            | Series[Timestamp]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timestamp]: ...
    @overload
    def add(
        self: Series[Timedelta],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def add(
        self: Supports_ProtoAdd[S2_contra, S2],
        other: S2_contra | Sequence[S2_contra],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2]: ...
    @overload
    def add(
        self: Series[S2_contra],
        other: SupportsRAdd[S2_contra, S2] | Sequence[SupportsRAdd[S2_contra, S2]],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2]: ...
    @overload
    def add(
        self: Series[T_COMPLEX],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def add(
        self: Series[bool],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def add(
        self: Series[T_COMPLEX],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def add(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def add(
        self: Series[T_COMPLEX],
        other: np_ndarray_float | Index[float] | Series[float],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def add(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def add(
        self: Series[_str],
        other: np_ndarray_str | Index[_str] | Series[_str],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[_str]: ...
    @overload
    def __radd__(self: Series[Never], other: complex | ListLike) -> Series: ...
    @overload
    def __radd__(self, other: Index[Never] | Series[Never]) -> Series: ...
    @overload
    def __radd__(self: Series[Timestamp], other: np_ndarray_dt) -> Never: ...
    @overload
    def __radd__(
        self: Series[Timestamp],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
            | BaseOffset
        ),
    ) -> Series[Timestamp]: ...
    @overload
    def __radd__(
        self: Series[Timedelta],
        other: (
            datetime | np.datetime64 | np_ndarray_dt | DatetimeIndex | Series[Timestamp]
        ),
    ) -> Series[Timestamp]: ...
    @overload
    def __radd__(
        self: Series[Timedelta],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
    ) -> Series[Timedelta]: ...
    # pyright is unhappy without the 3 overloads below
    @overload
    def __radd__(self: Series[bool], other: bool | Sequence[bool]) -> Series[bool]: ...
    @overload
    def __radd__(self: Series[float], other: int | Sequence[int]) -> Series[float]: ...
    @overload
    def __radd__(
        self: Series[complex], other: float | Sequence[float]
    ) -> Series[complex]: ...
    # pyright is unhappy without the above 3 overloads
    @overload
    def __radd__(
        self: Supports_ProtoRAdd[S2_contra, S2], other: S2_contra | Sequence[S2_contra]
    ) -> Series[S2]: ...
    @overload
    def __radd__(
        self: Series[S2_contra], other: SupportsAdd[S2_contra, S2]
    ) -> Series[S2]: ...
    # pandas-dev/pandas#62353
    @overload
    def __radd__(
        self: Series[S2_NDT_contra], other: Sequence[SupportsAdd[S2_NDT_contra, S2]]
    ) -> Series[S2]: ...
    @overload
    def __radd__(
        self: Series[T_COMPLEX], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __radd__(
        self: Series[bool], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[int]: ...
    @overload
    def __radd__(
        self: Series[T_COMPLEX], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __radd__(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
    ) -> Series[float]: ...
    @overload
    def __radd__(
        self: Series[T_COMPLEX], other: np_ndarray_float | Index[float] | Series[float]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __radd__(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
    ) -> Series[complex]: ...
    @overload
    def __radd__(
        self: Series[_str],
        other: (
            np_ndarray_bool | np_ndarray_anyint | np_ndarray_float | np_ndarray_complex
        ),
    ) -> Never: ...
    @overload
    def __radd__(
        self: Series[_str], other: np_ndarray_str | Index[_str] | Series[_str]
    ) -> Series[_str]: ...
    @overload
    def __radd__(self: Series[BaseOffset], other: Period) -> Series[Period]: ...
    @overload
    def __radd__(self: Series[BaseOffset], other: BaseOffset) -> Series[BaseOffset]: ...
    @overload
    def radd(
        self: Series[Never],
        other: complex | ListLike,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series:
        """
Return Addition of series and other, element-wise (binary operator `radd`).

Equivalent to ``other + series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.add : Element-wise Addition, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.add(b, fill_value=0)
a    2.0
b    1.0
c    1.0
d    1.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def radd(
        self,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series: ...
    @overload
    def radd(
        self: Series[Timestamp],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
            | BaseOffset
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timestamp]: ...
    @overload
    def radd(
        self: Series[Timedelta],
        other: (
            datetime
            | Sequence[datetime]
            | np.datetime64
            | np_ndarray_dt
            | DatetimeIndex
            | Series[Timestamp]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timestamp]: ...
    @overload
    def radd(
        self: Series[Timedelta],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def radd(
        self: Supports_ProtoRAdd[S2_contra, S2],
        other: S2_contra | Sequence[S2_contra],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2]: ...
    @overload
    def radd(
        self: Series[S2_contra],
        other: SupportsAdd[S2_contra, S2] | Sequence[SupportsAdd[S2_contra, S2]],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2]: ...
    @overload
    def radd(
        self: Series[T_COMPLEX],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def radd(
        self: Series[bool],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def radd(
        self: Series[T_COMPLEX],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def radd(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def radd(
        self: Series[T_COMPLEX],
        other: np_ndarray_float | Index[float] | Series[float],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def radd(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def radd(
        self: Series[_str],
        other: np_ndarray_str | Index[_str] | Series[_str],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[_str]: ...
    # ignore needed for mypy as we want different results based on the arguments
    @overload  # type: ignore[override]
    def __and__(  # pyright: ignore[reportOverlappingOverload] # pyrefly: ignore[bad-override]
        self, other: bool | list[int] | MaskType
    ) -> Series[bool]: ...
    @overload
    def __and__(self, other: int | np_ndarray_anyint | Series[int]) -> Series[int]: ...
    def __eq__(self, other: object) -> Series[_bool]: ...  # type: ignore[override] # pyright: ignore[reportIncompatibleMethodOverride]
    @overload
    def __floordiv__(self, other: np_ndarray_dt) -> Never: ...
    @overload
    def __floordiv__(
        self: Series[Never], other: np_ndarray_td | TimedeltaIndex
    ) -> Never: ...
    @overload
    def __floordiv__(
        self: Series[int] | Series[float], other: np_ndarray_complex | np_ndarray_td
    ) -> Never: ...
    @overload
    def __floordiv__(  # type: ignore[overload-overlap]
        self: Series[Never], other: ScalarArrayIndexSeriesReal
    ) -> Series: ...
    @overload
    def __floordiv__(
        self: SeriesReal | Series[Timedelta], other: Index[Never] | Series[Never]
    ) -> Series: ...
    @overload
    def __floordiv__(
        self: Series[bool] | Series[complex], other: np_ndarray
    ) -> Never: ...
    @overload
    def __floordiv__(
        self: Supports_ProtoFloorDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
    ) -> Series[S2]: ...
    @overload
    def __floordiv__(
        self: Series[int], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[int]: ...
    @overload
    def __floordiv__(
        self: Series[float], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[float]: ...
    @overload
    def __floordiv__(
        self: Series[bool] | Series[int],
        other: np_ndarray_anyint | Index[int] | Series[int],
    ) -> Series[int]: ...
    @overload
    def __floordiv__(
        self: Series[float], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[float]: ...
    @overload
    def __floordiv__(
        self: Series[int] | Series[float],
        other: (
            float | Sequence[float] | np_ndarray_float | Index[float] | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __floordiv__(
        self: Series[Timedelta], other: np_ndarray_bool | np_ndarray_complex
    ) -> Never: ...
    @overload
    def __floordiv__(
        self: Series[Timedelta],
        other: ScalarArrayIndexSeriesJustInt | ScalarArrayIndexSeriesJustFloat,
    ) -> Series[Timedelta]: ...
    @overload
    def __floordiv__(
        self: Series[Timedelta], other: ArrayIndexSeriesTimedeltaNoSeq
    ) -> Series[int]: ...
    @overload
    def floordiv(
        self: Series[Never],
        other: np_ndarray_td | TimedeltaIndex,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Never:
        """
Return Integer division of series and other, element-wise (binary operator `floordiv`).

Equivalent to ``series // other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.rfloordiv : Reverse of the Integer division operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.floordiv(b, fill_value=0)
a    1.0
b    inf
c    inf
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def floordiv(
        self: Series[Never],
        other: ScalarArrayIndexSeriesReal,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series: ...
    @overload
    def floordiv(
        self: SeriesReal | Series[Timedelta],
        other: Index[Never] | Series[Never],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series: ...
    @overload
    def floordiv(
        self: Supports_ProtoFloorDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[S2]: ...
    @overload
    def floordiv(
        self: Series[int],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[int]: ...
    @overload
    def floordiv(
        self: Series[float],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[float]: ...
    @overload
    def floordiv(
        self: Series[bool] | Series[int],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[int]: ...
    @overload
    def floordiv(
        self: Series[float],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[float]: ...
    @overload
    def floordiv(
        self: Series[int] | Series[float],
        other: (
            float | Sequence[float] | np_ndarray_float | Index[float] | Series[float]
        ),
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[float]: ...
    @overload
    def floordiv(
        self: Series[Timedelta],
        other: ScalarArrayIndexSeriesJustInt | ScalarArrayIndexSeriesJustFloat,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def floordiv(
        self: Series[Timedelta],
        other: ArrayIndexSeriesTimedeltaNoSeq,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[int]: ...
    @overload
    def __rfloordiv__(  # type: ignore[overload-overlap]
        self: Series[Never], other: ScalarArrayIndexSeriesReal
    ) -> Series: ...
    @overload
    def __rfloordiv__(self, other: np_ndarray_complex | np_ndarray_dt) -> Never: ...
    @overload
    def __rfloordiv__(
        self: Series[int] | Series[float], other: np_ndarray_td
    ) -> Never: ...
    @overload
    def __rfloordiv__(
        self: Series[bool] | Series[complex], other: np_ndarray
    ) -> Never: ...
    @overload
    def __rfloordiv__(
        self: SeriesReal | Series[Timedelta], other: Index[Never] | Series[Never]
    ) -> Series: ...
    @overload
    def __rfloordiv__(
        self: Supports_ProtoRFloorDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
    ) -> Series[S2]: ...
    @overload
    def __rfloordiv__(
        self: Series[int], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[int]: ...
    @overload
    def __rfloordiv__(
        self: Series[float], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[float]: ...
    @overload
    def __rfloordiv__(
        self: Series[bool] | Series[int],
        other: np_ndarray_anyint | Index[int] | Series[int],
    ) -> Series[int]: ...
    @overload
    def __rfloordiv__(
        self: Series[float], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[float]: ...
    @overload
    def __rfloordiv__(
        self: Series[int] | Series[float],
        other: (
            float | Sequence[float] | np_ndarray_float | Index[float] | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __rfloordiv__(self: Series[Timedelta], other: np_ndarray_num) -> Never: ...
    @overload
    def __rfloordiv__(
        self: Series[int] | Series[float],
        other: timedelta | np.timedelta64 | ArrayIndexSeriesTimedeltaNoSeq,
    ) -> Series[Timedelta]: ...
    @overload
    def __rfloordiv__(
        self: Series[int] | Series[float],
        other: Sequence[timedelta | np.timedelta64],
    ) -> Series: ...
    @overload
    def __rfloordiv__(
        self: Series[Timedelta], other: ArrayIndexSeriesTimedeltaNoSeq
    ) -> Series[int]: ...
    @overload
    def rfloordiv(
        self: Series[Never],
        other: ScalarArrayIndexSeriesReal,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series:
        """
Return Integer division of series and other, element-wise (binary operator `rfloordiv`).

Equivalent to ``other // series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.floordiv : Element-wise Integer division, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.floordiv(b, fill_value=0)
a    1.0
b    inf
c    inf
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def rfloordiv(
        self: SeriesReal | Series[Timedelta],
        other: Index[Never] | Series[Never],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series: ...
    @overload
    def rfloordiv(
        self: Supports_ProtoRFloorDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[S2]: ...
    @overload
    def rfloordiv(
        self: Series[int],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[int]: ...
    @overload
    def rfloordiv(
        self: Series[float],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[float]: ...
    @overload
    def rfloordiv(
        self: Series[bool] | Series[int],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[int]: ...
    @overload
    def rfloordiv(
        self: Series[float],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[float]: ...
    @overload
    def rfloordiv(
        self: Series[int] | Series[float],
        other: (
            float | Sequence[float] | np_ndarray_float | Index[float] | Series[float]
        ),
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[float]: ...
    @overload
    def rfloordiv(
        self: Series[int] | Series[float],
        other: ScalarArrayIndexSeriesTimedelta,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[Timedelta]: ...
    @overload
    def rfloordiv(
        self: Series[Timedelta],
        other: timedelta | np.timedelta64 | ArrayIndexSeriesTimedeltaNoSeq,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[int]: ...
    def __ge__(  # type: ignore[override]
        self, other: S1 | ListLike | Series[S1] | datetime | timedelta | date
    ) -> Series[_bool]: ...
    def __gt__(  # type: ignore[override]
        self, other: S1 | ListLike | Series[S1] | datetime | timedelta | date
    ) -> Series[_bool]: ...
    def __le__(  # type: ignore[override]
        self, other: S1 | ListLike | Series[S1] | datetime | timedelta | date
    ) -> Series[_bool]: ...
    def __lt__(  # type: ignore[override]
        self, other: S1 | ListLike | Series[S1] | datetime | timedelta | date
    ) -> Series[_bool]: ...
    @overload
    def __mul__(  # type: ignore[overload-overlap]
        self: Series[Never], other: complex | NumListLike | Index | Series
    ) -> Series: ...
    @overload
    def __mul__(self, other: Index[Never] | Series[Never]) -> Series: ...
    @overload
    def __mul__(self, other: np_ndarray_dt) -> Never: ...
    @overload
    def __mul__(
        self: Series[bool] | Series[complex], other: np_ndarray_td
    ) -> Never: ...
    @overload
    def __mul__(
        self: Series[int] | Series[float],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __mul__(self: Series[Timestamp], other: np_ndarray) -> Never: ...
    @overload
    def __mul__(
        self: Series[Timedelta], other: np_ndarray_bool | np_ndarray_complex
    ) -> Never: ...
    @overload
    def __mul__(
        self: Series[Timedelta],
        other: (
            np_ndarray_anyint
            | np_ndarray_float
            | Index[int]
            | Index[float]
            | Series[int]
            | Series[float]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __mul__(
        self: Series[_str],
        other: (
            np_ndarray_bool
            | np_ndarray_float
            | np_ndarray_complex
            | np_ndarray_dt
            | np_ndarray_td
        ),
    ) -> Never: ...
    @overload
    def __mul__(
        self: Series[_str], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[_str]: ...
    @overload
    def __mul__(
        self: Supports_ProtoMul[_T_contra, S2], other: _T_contra | Sequence[_T_contra]
    ) -> Series[S2]: ...
    @overload
    def __mul__(
        self: Series[S2_contra],
        other: (
            SupportsRMul[S2_contra, S2_NSDT]
            | Sequence[SupportsRMul[S2_contra, S2_NSDT]]
        ),
    ) -> Series[S2_NSDT]: ...
    @overload
    def __mul__(
        self: Series[T_COMPLEX], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __mul__(
        self: Series[bool], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[int]: ...
    @overload
    def __mul__(
        self: Series[T_COMPLEX], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __mul__(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
    ) -> Series[float]: ...
    @overload
    def __mul__(
        self: Series[T_COMPLEX], other: np_ndarray_float | Index[float] | Series[float]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __mul__(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
    ) -> Series[complex]: ...
    @overload
    def mul(
        self: Series[Never],
        other: complex | ListLike,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series:
        """
Return Multiplication of series and other, element-wise (binary operator `mul`).

Equivalent to ``series * other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.rmul : Reverse of the Multiplication operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.multiply(b, fill_value=0)
a    1.0
b    0.0
c    0.0
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def mul(
        self,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series: ...
    @overload
    def mul(
        self: Series[int] | Series[float],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def mul(
        self: Series[Timedelta],
        other: (
            np_ndarray_anyint
            | np_ndarray_float
            | Index[int]
            | Index[float]
            | Series[int]
            | Series[float]
        ),
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def mul(
        self: Series[_str],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[_str]: ...
    @overload
    def mul(
        self: Supports_ProtoMul[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2]: ...
    @overload
    def mul(
        self: Series[S2_contra],
        other: (
            SupportsRMul[S2_contra, S2_NSDT]
            | Sequence[SupportsRMul[S2_contra, S2_NSDT]]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2_NSDT]: ...
    @overload
    def mul(
        self: Series[T_COMPLEX],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def mul(
        self: Series[bool],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def mul(
        self: Series[T_COMPLEX],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def mul(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def mul(
        self: Series[T_COMPLEX],
        other: np_ndarray_float | Index[float] | Series[float],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def mul(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def __rmul__(  # type: ignore[overload-overlap]
        self: Series[Never], other: complex | NumListLike | Index | Series
    ) -> Series: ...
    @overload
    def __rmul__(self, other: Index[Never] | Series[Never]) -> Series: ...  # type: ignore[misc]
    @overload
    def __rmul__(self, other: np_ndarray_dt) -> Never: ...
    @overload
    def __rmul__(  # type: ignore[overload-overlap]
        self: Series[int] | Series[float],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __rmul__(self: Series[Timestamp], other: np_ndarray) -> Never: ...
    @overload
    def __rmul__(
        self: Series[bool] | Series[complex], other: np_ndarray_td
    ) -> Never: ...
    @overload
    def __rmul__(
        self: Series[Timedelta], other: np_ndarray_bool | np_ndarray_complex
    ) -> Never: ...
    @overload
    def __rmul__(
        self: Series[Timedelta],
        other: (
            np_ndarray_anyint
            | np_ndarray_float
            | Index[int]
            | Index[float]
            | Series[int]
            | Series[float]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __rmul__(
        self: Series[_str],
        other: (
            np_ndarray_bool
            | np_ndarray_float
            | np_ndarray_complex
            | np_ndarray_dt
            | np_ndarray_td
        ),
    ) -> Never: ...
    @overload
    def __rmul__(
        self: Series[_str], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[_str]: ...
    @overload
    def __rmul__(
        self: Supports_ProtoRMul[_T_contra, S2], other: _T_contra | Sequence[_T_contra]
    ) -> Series[S2]: ...
    @overload
    def __rmul__(
        self: Series[S2_contra],
        other: (
            SupportsMul[S2_contra, S2_NSDT] | Sequence[SupportsMul[S2_contra, S2_NSDT]]
        ),
    ) -> Series[S2_NSDT]: ...
    @overload
    def __rmul__(
        self: Series[T_COMPLEX], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __rmul__(
        self: Series[bool], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[int]: ...
    @overload
    def __rmul__(
        self: Series[T_COMPLEX], other: np_ndarray_anyint | Index[int] | Series[int]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __rmul__(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
    ) -> Series[float]: ...
    @overload
    def __rmul__(
        self: Series[T_COMPLEX], other: np_ndarray_float | Index[float] | Series[float]
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __rmul__(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
    ) -> Series[complex]: ...
    @overload
    def rmul(
        self: Series[Never],
        other: complex | ListLike,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series:
        """
Return Multiplication of series and other, element-wise (binary operator `rmul`).

Equivalent to ``other * series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.mul : Element-wise Multiplication, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.multiply(b, fill_value=0)
a    1.0
b    0.0
c    0.0
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def rmul(
        self,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series: ...
    @overload
    def rmul(
        self: Series[int] | Series[float],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def rmul(
        self: Series[Timedelta],
        other: (
            np_ndarray_anyint
            | np_ndarray_float
            | Index[int]
            | Index[float]
            | Series[int]
            | Series[float]
        ),
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def rmul(
        self: Series[_str],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[_str]: ...
    @overload
    def rmul(
        self: Supports_ProtoRMul[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2]: ...
    @overload
    def rmul(
        self: Series[S2_contra],
        other: (
            SupportsMul[S2_contra, S2_NSDT] | Sequence[SupportsMul[S2_contra, S2_NSDT]]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[S2_NSDT]: ...
    @overload
    def rmul(
        self: Series[T_COMPLEX],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def rmul(
        self: Series[bool],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def rmul(
        self: Series[T_COMPLEX],
        other: np_ndarray_anyint | Index[int] | Series[int],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def rmul(
        self: Series[bool] | Series[int],
        other: np_ndarray_float | Index[float] | Series[float],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def rmul(
        self: Series[T_COMPLEX],
        other: np_ndarray_float | Index[float] | Series[float],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def rmul(
        self: Series[T_COMPLEX],
        other: np_ndarray_complex | Index[complex] | Series[complex],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    def __mod__(self, other: num | ListLike | Series[S1]) -> Series[S1]: ...
    def __ne__(self, other: object) -> Series[_bool]: ...  # type: ignore[override] # pyright: ignore[reportIncompatibleMethodOverride]
    def __pow__(self, other: num | ListLike | Series[S1]) -> Series[S1]: ...
    # ignore needed for mypy as we want different results based on the arguments
    @overload  # type: ignore[override]
    def __or__(  # pyright: ignore[reportOverlappingOverload] # pyrefly: ignore[bad-override]
        self, other: bool | list[int] | MaskType
    ) -> Series[bool]: ...
    @overload
    def __or__(self, other: int | np_ndarray_anyint | Series[int]) -> Series[int]: ...
    # ignore needed for mypy as we want different results based on the arguments
    @overload  # type: ignore[override]
    def __rand__(  # pyright: ignore[reportOverlappingOverload] # pyrefly: ignore[bad-override]
        self, other: bool | MaskType | list[int]
    ) -> Series[bool]: ...
    @overload
    def __rand__(self, other: int | np_ndarray_anyint | Series[int]) -> Series[int]: ...
    def __rdivmod__(self, other: num | ListLike | Series[S1]) -> Series[S1]: ...  # type: ignore[override] # pyright: ignore[reportIncompatibleMethodOverride]
    def __rmod__(self, other: num | ListLike | Series[S1]) -> Series[S1]: ...
    def __rpow__(self, other: num | ListLike | Series[S1]) -> Series[S1]: ...
    # ignore needed for mypy as we want different results based on the arguments
    @overload  # type: ignore[override]
    def __ror__(  # pyright: ignore[reportOverlappingOverload] # pyrefly: ignore[bad-override]
        self, other: bool | MaskType | list[int]
    ) -> Series[bool]: ...
    @overload
    def __ror__(self, other: int | np_ndarray_anyint | Series[int]) -> Series[int]: ...
    # ignore needed for mypy as we want different results based on the arguments
    @overload  # type: ignore[override]
    def __rxor__(  # pyright: ignore[reportOverlappingOverload] # pyrefly: ignore[bad-override]
        self, other: bool | MaskType | list[int]
    ) -> Series[bool]: ...
    @overload
    def __rxor__(self, other: int | np_ndarray_anyint | Series[int]) -> Series[int]: ...
    @overload
    def __sub__(
        self: Series[Never],
        other: complex | NumListLike | Index[T_COMPLEX] | Series[T_COMPLEX],
    ) -> Series: ...
    @overload
    def __sub__(self, other: Index[Never] | Series[Never]) -> Series: ...
    @overload
    def __sub__(
        self: Series[bool],
        other: (
            Just[int]
            | Sequence[Just[int]]
            | np_ndarray_anyint
            | Index[int]
            | Series[int]
        ),
    ) -> Series[int]: ...
    @overload
    def __sub__(
        self: Series[bool],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __sub__(
        self: Series[int],
        other: (
            int
            | Sequence[int]
            | np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
        ),
    ) -> Series[int]: ...
    @overload
    def __sub__(
        self: Series[int],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __sub__(
        self: Series[float],
        other: (
            float
            | Sequence[float]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
            | Index[float]
            | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __sub__(
        self: Series[complex],
        other: (
            T_COMPLEX
            | Sequence[T_COMPLEX]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[T_COMPLEX]
            | Series[T_COMPLEX]
        ),
    ) -> Series[complex]: ...
    @overload
    def __sub__(
        self: Series[T_COMPLEX],
        other: (
            Just[complex]
            | Sequence[Just[complex]]
            | np_ndarray_complex
            | Index[complex]
            | Series[complex]
        ),
    ) -> Series[complex]: ...
    @overload
    def __sub__(
        self: Series[Timestamp],
        other: (
            datetime | np.datetime64 | np_ndarray_dt | DatetimeIndex | Series[Timestamp]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __sub__(
        self: Series[Timestamp],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
            | BaseOffset
        ),
    ) -> Series[Timestamp]: ...
    @overload
    def __sub__(self: Series[Timedelta], other: np_ndarray_dt) -> Never: ...
    @overload
    def __sub__(
        self: Series[Timedelta],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __sub__(
        self: Series[Period], other: Series[Period] | Period
    ) -> Series[BaseOffset]: ...
    @overload
    def sub(
        self: Series[Never],
        other: complex | NumListLike | Index[T_COMPLEX] | Series[T_COMPLEX],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series:
        """
Return Subtraction of series and other, element-wise (binary operator `sub`).

Equivalent to ``series - other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.rsub : Reverse of the Subtraction operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.subtract(b, fill_value=0)
a    0.0
b    1.0
c    1.0
d   -1.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def sub(
        self,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series: ...
    @overload
    def sub(
        self: Series[bool],
        other: (
            Just[int]
            | Sequence[Just[int]]
            | np_ndarray_anyint
            | Index[int]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def sub(
        self: Series[bool],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def sub(
        self: Series[int],
        other: (
            int
            | Sequence[int]
            | np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def sub(
        self: Series[int],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def sub(
        self: Series[float],
        other: (
            float
            | Sequence[float]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
            | Index[float]
            | Series[float]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def sub(
        self: Series[complex],
        other: (
            T_COMPLEX
            | Sequence[T_COMPLEX]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[T_COMPLEX]
            | Series[T_COMPLEX]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def sub(
        self: Series[T_COMPLEX],
        other: (
            Just[complex]
            | Sequence[Just[complex]]
            | np_ndarray_complex
            | Index[complex]
            | Series[complex]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def sub(
        self: Series[Timestamp],
        other: (
            datetime
            | Sequence[datetime]
            | np.datetime64
            | np_ndarray_dt
            | DatetimeIndex
            | Series[Timestamp]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def sub(
        self: Series[Timestamp],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
            | BaseOffset
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timestamp]: ...
    @overload
    def sub(
        self: Series[Timedelta],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def sub(
        self: Series[Period],
        other: Period | Sequence[Period] | PeriodIndex | Series[Period],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[BaseOffset]: ...
    @overload
    def __rsub__(
        self: Series[Never],
        other: (
            complex
            | datetime
            | np.datetime64
            | np_ndarray_dt
            | NumListLike
            | Index[T_COMPLEX]
            | Series[T_COMPLEX]
        ),
    ) -> Series: ...
    @overload
    def __rsub__(self, other: Index[Never] | Series[Never]) -> Series: ...
    @overload
    def __rsub__(
        self: Series[bool],
        other: (
            Just[int]
            | Sequence[Just[int]]
            | np_ndarray_anyint
            | Index[int]
            | Series[int]
        ),
    ) -> Series[int]: ...
    @overload
    def __rsub__(
        self: Series[bool],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __rsub__(
        self: Series[int],
        other: (
            int
            | Sequence[int]
            | np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
        ),
    ) -> Series[int]: ...
    @overload
    def __rsub__(
        self: Series[int],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __rsub__(
        self: Series[float],
        other: (
            float
            | Sequence[float]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
            | Index[float]
            | Series[float]
        ),
    ) -> Series[float]: ...
    @overload
    def __rsub__(
        self: Series[complex],
        other: (
            T_COMPLEX
            | Sequence[T_COMPLEX]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[T_COMPLEX]
            | Series[T_COMPLEX]
        ),
    ) -> Series[complex]: ...
    @overload
    def __rsub__(
        self: Series[T_COMPLEX],
        other: (
            Just[complex]
            | Sequence[Just[complex]]
            | np_ndarray_complex
            | Index[complex]
            | Series[complex]
        ),
    ) -> Series[complex]: ...
    @overload
    def __rsub__(self: Series[Timestamp], other: np_ndarray_td) -> Never: ...
    @overload
    def __rsub__(
        self: Series[Timestamp],
        other: (
            datetime | np.datetime64 | np_ndarray_dt | DatetimeIndex | Series[Timestamp]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __rsub__(
        self: Series[Timedelta],
        other: (
            datetime | np.datetime64 | np_ndarray_dt | DatetimeIndex | Series[Timestamp]
        ),
    ) -> Series[Timestamp]: ...
    @overload
    def __rsub__(
        self: Series[Timedelta],
        other: (
            timedelta
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
    ) -> Series[Timedelta]: ...
    @overload
    def __rsub__(
        self: Series[Period], other: Series[Period] | Period
    ) -> Series[BaseOffset]: ...
    @overload
    def rsub(
        self: Series[Never],
        other: (
            complex
            | datetime
            | Sequence[datetime]
            | np.datetime64
            | np_ndarray_dt
            | NumListLike
            | Index[T_COMPLEX]
            | Series[T_COMPLEX]
            | Series[Timestamp]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series:
        """
Return Subtraction of series and other, element-wise (binary operator `rsub`).

Equivalent to ``other - series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.sub : Element-wise Subtraction, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.subtract(b, fill_value=0)
a    0.0
b    1.0
c    1.0
d   -1.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def rsub(
        self,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series: ...
    @overload
    def rsub(
        self: Series[bool],
        other: (
            Just[int]
            | Sequence[Just[int]]
            | np_ndarray_anyint
            | Index[int]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def rsub(
        self: Series[bool],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def rsub(
        self: Series[int],
        other: (
            int
            | Sequence[int]
            | np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[int]: ...
    @overload
    def rsub(
        self: Series[int],
        other: (
            Just[float]
            | Sequence[Just[float]]
            | np_ndarray_float
            | Index[float]
            | Series[float]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def rsub(
        self: Series[float],
        other: (
            float
            | Sequence[float]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[bool]
            | Series[bool]
            | Index[int]
            | Series[int]
            | Index[float]
            | Series[float]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[float]: ...
    @overload
    def rsub(
        self: Series[complex],
        other: (
            T_COMPLEX
            | Sequence[T_COMPLEX]
            | np_ndarray_bool
            | np_ndarray_anyint
            | np_ndarray_float
            | Index[T_COMPLEX]
            | Series[T_COMPLEX]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def rsub(
        self: Series[T_COMPLEX],
        other: (
            Just[complex]
            | Sequence[Just[complex]]
            | np_ndarray_complex
            | Index[complex]
            | Series[complex]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[complex]: ...
    @overload
    def rsub(
        self: Series[Timestamp],
        other: (
            datetime
            | Sequence[datetime]
            | np.datetime64
            | np_ndarray_dt
            | DatetimeIndex
            | Series[Timestamp]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def rsub(
        self: Series[Timedelta],
        other: (
            datetime
            | Sequence[datetime]
            | np.datetime64
            | np_ndarray_dt
            | DatetimeIndex
            | Series[Timestamp]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timestamp]: ...
    @overload
    def rsub(
        self: Series[Timedelta],
        other: (
            timedelta
            | Sequence[timedelta]
            | np.timedelta64
            | np_ndarray_td
            | TimedeltaIndex
            | Series[Timedelta]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def rsub(
        self: Series[Period],
        other: Period | Sequence[Period] | PeriodIndex | Series[Period],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: int = 0,
    ) -> Series[BaseOffset]: ...
    @overload
    def __truediv__(self, other: np_ndarray_dt) -> Never: ...
    @overload
    def __truediv__(  # type: ignore[overload-overlap]
        self: Series[Never], other: ScalarArrayIndexSeriesComplex
    ) -> Series: ...
    @overload
    def __truediv__(self: Series[Never], other: ArrayIndexTimedeltaNoSeq) -> Never: ...
    @overload
    def __truediv__(self: Series[T_COMPLEX], other: np_ndarray_td) -> Never: ...
    @overload
    def __truediv__(self: Series[bool], other: np_ndarray_bool) -> Never: ...
    @overload
    def __truediv__(
        self: SeriesComplex | Series[Timedelta], other: Index[Never] | Series[Never]
    ) -> Series: ...
    @overload
    def __truediv__(
        self: Series[Timedelta],
        other: np_ndarray_bool | np_ndarray_complex | np_ndarray_dt,
    ) -> Never: ...
    @overload
    def __truediv__(
        self: Supports_ProtoTrueDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
    ) -> Series[S2]: ...
    @overload
    def __truediv__(
        self: Series[int],
        other: np_ndarray_bool | Index[bool] | Series[bool],
    ) -> Series[float]: ...
    @overload
    def __truediv__(
        self: Series[bool] | Series[int], other: ScalarArrayIndexSeriesIntNoBool
    ) -> Series[float]: ...
    @overload
    def __truediv__(
        self: Series[float],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
    ) -> Series[float]: ...
    @overload
    def __truediv__(
        self: Series[complex],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
    ) -> Series[complex]: ...
    @overload
    def __truediv__(
        self: Series[bool] | Series[int], other: ScalarArrayIndexSeriesJustFloat
    ) -> Series[float]: ...
    @overload
    def __truediv__(
        self: Series[T_COMPLEX], other: ScalarArrayIndexSeriesJustFloat
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __truediv__(
        self: SeriesComplex, other: ScalarArrayIndexSeriesJustComplex
    ) -> Series[complex]: ...
    @overload
    def __truediv__(
        self: Series[Timedelta],
        other: ScalarArrayIndexSeriesJustInt | ScalarArrayIndexSeriesJustFloat,
    ) -> Series[Timedelta]: ...
    @overload
    def __truediv__(
        self: Series[Timedelta], other: ArrayIndexSeriesTimedeltaNoSeq
    ) -> Series[float]: ...
    @overload
    def __truediv__(self: Series[_str], other: Path) -> Series: ...
    @overload
    def truediv(  # type: ignore[overload-overlap]
        self: Series[Never],
        other: ScalarArrayIndexSeriesComplex,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series:
        """
Return Floating division of series and other, element-wise (binary operator `truediv`).

Equivalent to ``series / other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.rtruediv : Reverse of the Floating division operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.divide(b, fill_value=0)
a    1.0
b    inf
c    inf
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def truediv(
        self: Series[Never],
        other: ArrayIndexTimedeltaNoSeq,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Never: ...
    @overload
    def truediv(
        self: SeriesComplex | Series[Timedelta],
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series: ...
    @overload
    def truediv(
        self: Supports_ProtoTrueDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[S2]: ...
    @overload
    def truediv(
        self: Series[int],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def truediv(
        self: Series[bool] | Series[int],
        other: ScalarArrayIndexSeriesIntNoBool,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def truediv(
        self: Series[float],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def truediv(
        self: Series[complex],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[complex]: ...
    @overload
    def truediv(
        self: Series[bool] | Series[int],
        other: ScalarArrayIndexSeriesJustFloat,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def truediv(
        self: Series[T_COMPLEX],
        other: ScalarArrayIndexSeriesJustFloat,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def truediv(
        self: SeriesComplex,
        other: ScalarArrayIndexSeriesJustComplex,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[complex]: ...
    @overload
    def truediv(
        self: Series[Timedelta],
        other: ScalarArrayIndexSeriesJustInt | ScalarArrayIndexSeriesJustFloat,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def truediv(
        self: Series[Timedelta],
        other: ArrayIndexSeriesTimedeltaNoSeq,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def truediv(
        self: Series[_str],
        other: Path,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series: ...
    div = truediv
    @overload
    def __rtruediv__(self, other: np_ndarray_dt) -> Never: ...
    @overload
    def __rtruediv__(
        self: Series[Never],
        other: ScalarArrayIndexSeriesComplex | ScalarArrayIndexSeriesTimedelta,
    ) -> Series: ...
    @overload
    def __rtruediv__(
        self: SeriesComplex, other: Index[Never] | Series[Never]
    ) -> Series: ...
    @overload
    def __rtruediv__(
        self: Series[int] | Series[float], other: Sequence[timedelta | np.timedelta64]
    ) -> Series: ...
    @overload
    def __rtruediv__(
        self: Supports_ProtoRTrueDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
    ) -> Series[S2]: ...
    @overload
    def __rtruediv__(
        self: Series[int], other: np_ndarray_bool | Index[bool] | Series[bool]
    ) -> Series[float]: ...
    @overload
    def __rtruediv__(
        self: Series[bool] | Series[int], other: ScalarArrayIndexSeriesIntNoBool
    ) -> Series[float]: ...
    @overload
    def __rtruediv__(  # type: ignore[misc]
        self: Series[float],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
    ) -> Series[float]: ...
    @overload
    def __rtruediv__(
        self: Series[complex],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
    ) -> Series[complex]: ...
    @overload
    def __rtruediv__(
        self: Series[bool] | Series[int], other: ScalarArrayIndexSeriesJustFloat
    ) -> Series[float]: ...
    @overload
    def __rtruediv__(
        self: Series[T_COMPLEX], other: ScalarArrayIndexSeriesJustFloat
    ) -> Series[T_COMPLEX]: ...
    @overload
    def __rtruediv__(
        self: SeriesComplex, other: ScalarArrayIndexSeriesJustComplex
    ) -> Series[complex]: ...
    @overload
    def __rtruediv__(
        self: Series[Timedelta], other: ArrayIndexSeriesTimedeltaNoSeq
    ) -> Series[float]: ...
    @overload
    def __rtruediv__(
        self: Series[int] | Series[float], other: ScalarArrayIndexSeriesTimedelta
    ) -> Series[Timedelta]: ...
    @overload
    def __rtruediv__(self: Series[_str], other: Path) -> Series: ...
    @overload
    def rtruediv(
        self: Series[Never],
        other: ScalarArrayIndexSeriesComplex | ScalarArrayIndexSeriesTimedelta,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series:
        """
Return Floating division of series and other, element-wise (binary operator `rtruediv`).

Equivalent to ``other / series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.truediv : Element-wise Floating division, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.divide(b, fill_value=0)
a    1.0
b    inf
c    inf
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def rtruediv(
        self: SeriesComplex,
        other: Index[Never] | Series[Never],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series: ...
    @overload
    def rtruediv(
        self: Supports_ProtoRTrueDiv[_T_contra, S2],
        other: _T_contra | Sequence[_T_contra],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[S2]: ...
    @overload
    def rtruediv(
        self: Series[int],
        other: np_ndarray_bool | Index[bool] | Series[bool],
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def rtruediv(
        self: Series[bool] | Series[int],
        other: ScalarArrayIndexSeriesIntNoBool,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def rtruediv(
        self: Series[float],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def rtruediv(
        self: Series[complex],
        other: (
            np_ndarray_bool
            | np_ndarray_anyint
            | Index[bool]
            | Index[int]
            | Series[bool]
            | Series[int]
        ),
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[complex]: ...
    @overload
    def rtruediv(
        self: Series[bool] | Series[int],
        other: ScalarArrayIndexSeriesJustFloat,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def rtruediv(
        self: Series[T_COMPLEX],
        other: ScalarArrayIndexSeriesJustFloat,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[T_COMPLEX]: ...
    @overload
    def rtruediv(
        self: SeriesComplex,
        other: ScalarArrayIndexSeriesJustComplex,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[complex]: ...
    @overload
    def rtruediv(
        self: Series[Timedelta],
        other: ArrayIndexSeriesTimedeltaNoSeq,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[float]: ...
    @overload
    def rtruediv(
        self: SeriesReal,
        other: ScalarArrayIndexSeriesTimedelta,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series[Timedelta]: ...
    @overload
    def rtruediv(
        self: Series[_str],
        other: Path,
        level: Level | None = None,
        fill_value: float | None = None,
        axis: AxisIndex = 0,
    ) -> Series: ...
    rdiv = rtruediv
    # ignore needed for mypy as we want different results based on the arguments
    @overload  # type: ignore[override]
    def __xor__(  # pyright: ignore[reportOverlappingOverload] # pyrefly: ignore[bad-override]
        self, other: bool | MaskType | list[int]
    ) -> Series[bool]: ...
    @overload
    def __xor__(self, other: int | np_ndarray_anyint | Series[int]) -> Series[int]: ...
    @final
    def __invert__(self) -> Series[bool]: ...
    @property
    def at(self) -> _AtIndexer: ...
    @property
    def cat(self) -> CategoricalAccessor: ...
    @property
    def iat(self) -> _iAtIndexer: ...
    @property
    def iloc(self) -> _iLocIndexerSeries[S1]: ...
    @property
    def loc(self) -> _LocIndexerSeries[S1]: ...
    def all(
        self,
        axis: AxisIndex = 0,
        bool_only: _bool | None = False,
        skipna: _bool = True,
        **kwargs: Any,
    ) -> np.bool:
        """
Return whether all elements are True, potentially over an axis.

Returns True unless there at least one element within a series or
along a Dataframe axis that is False or equivalent (e.g. zero or
empty).

Parameters
----------
axis : {0 or 'index', 1 or 'columns', None}, default 0
    Indicate which axis or axes should be reduced. For `Series` this parameter
    is unused and defaults to 0.

    * 0 / 'index' : reduce the index, return a Series whose index is the
      original column labels.
    * 1 / 'columns' : reduce the columns, return a Series whose index is the
      original index.
    * None : reduce all axes, return a scalar.

bool_only : bool, default False
    Include only boolean columns. Not implemented for Series.
skipna : bool, default True
    Exclude NA/null values. If the entire row/column is NA and skipna is
    True, then the result will be True, as for an empty row/column.
    If skipna is False, then NA are treated as True, because these are not
    equal to zero.
**kwargs : any, default None
    Additional keywords have no effect but might be accepted for
    compatibility with NumPy.

Returns
-------
scalar or Series
    If level is specified, then, Series is returned; otherwise, scalar
    is returned.

See Also
--------
Series.all : Return True if all elements are True.
DataFrame.any : Return True if one (or more) elements are True.

Examples
--------
**Series**

>>> pd.Series([True, True]).all()
True
>>> pd.Series([True, False]).all()
False
>>> pd.Series([], dtype="float64").all()
True
>>> pd.Series([np.nan]).all()
True
>>> pd.Series([np.nan]).all(skipna=False)
True

**DataFrames**

Create a dataframe from a dictionary.

>>> df = pd.DataFrame({'col1': [True, True], 'col2': [True, False]})
>>> df
   col1   col2
0  True   True
1  True  False

Default behaviour checks if values in each column all return True.

>>> df.all()
col1     True
col2    False
dtype: bool

Specify ``axis='columns'`` to check if values in each row all return True.

>>> df.all(axis='columns')
0     True
1    False
dtype: bool

Or ``axis=None`` for whether every value is True.

>>> df.all(axis=None)
False
        """
        pass
    def any(
        self,
        *,
        axis: AxisIndex = ...,
        bool_only: _bool | None = ...,
        skipna: _bool = ...,
        **kwargs: Any,
    ) -> np.bool: ...
    def cummax(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        *args: Any,
        **kwargs: Any,
    ) -> Series[S1]:
        """
Return cumulative maximum over a DataFrame or Series axis.

Returns a DataFrame or Series of the same size containing the cumulative
maximum.

Parameters
----------
axis : {0 or 'index', 1 or 'columns'}, default 0
    The index or the name of the axis. 0 is equivalent to None or 'index'.
    For `Series` this parameter is unused and defaults to 0.
skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
*args, **kwargs
    Additional keywords have no effect but might be accepted for
    compatibility with NumPy.

Returns
-------
scalar or Series
    Return cumulative maximum of scalar or Series.

See Also
--------
core.window.expanding.Expanding.max : Similar functionality
    but ignores ``NaN`` values.
Series.max : Return the maximum over
    Series axis.
Series.cummax : Return cumulative maximum over Series axis.
Series.cummin : Return cumulative minimum over Series axis.
Series.cumsum : Return cumulative sum over Series axis.
Series.cumprod : Return cumulative product over Series axis.

Examples
--------
**Series**

>>> s = pd.Series([2, np.nan, 5, -1, 0])
>>> s
0    2.0
1    NaN
2    5.0
3   -1.0
4    0.0
dtype: float64

By default, NA values are ignored.

>>> s.cummax()
0    2.0
1    NaN
2    5.0
3    5.0
4    5.0
dtype: float64

To include NA values in the operation, use ``skipna=False``

>>> s.cummax(skipna=False)
0    2.0
1    NaN
2    NaN
3    NaN
4    NaN
dtype: float64

**DataFrame**

>>> df = pd.DataFrame([[2.0, 1.0],
...                    [3.0, np.nan],
...                    [1.0, 0.0]],
...                   columns=list('AB'))
>>> df
     A    B
0  2.0  1.0
1  3.0  NaN
2  1.0  0.0

By default, iterates over rows and finds the maximum
in each column. This is equivalent to ``axis=None`` or ``axis='index'``.

>>> df.cummax()
     A    B
0  2.0  1.0
1  3.0  NaN
2  3.0  1.0

To iterate over columns and find the maximum in each row,
use ``axis=1``

>>> df.cummax(axis=1)
     A    B
0  2.0  2.0
1  3.0  NaN
2  1.0  1.0
        """
        pass
    def cummin(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        *args: Any,
        **kwargs: Any,
    ) -> Series[S1]:
        """
Return cumulative minimum over a DataFrame or Series axis.

Returns a DataFrame or Series of the same size containing the cumulative
minimum.

Parameters
----------
axis : {0 or 'index', 1 or 'columns'}, default 0
    The index or the name of the axis. 0 is equivalent to None or 'index'.
    For `Series` this parameter is unused and defaults to 0.
skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
*args, **kwargs
    Additional keywords have no effect but might be accepted for
    compatibility with NumPy.

Returns
-------
scalar or Series
    Return cumulative minimum of scalar or Series.

See Also
--------
core.window.expanding.Expanding.min : Similar functionality
    but ignores ``NaN`` values.
Series.min : Return the minimum over
    Series axis.
Series.cummax : Return cumulative maximum over Series axis.
Series.cummin : Return cumulative minimum over Series axis.
Series.cumsum : Return cumulative sum over Series axis.
Series.cumprod : Return cumulative product over Series axis.

Examples
--------
**Series**

>>> s = pd.Series([2, np.nan, 5, -1, 0])
>>> s
0    2.0
1    NaN
2    5.0
3   -1.0
4    0.0
dtype: float64

By default, NA values are ignored.

>>> s.cummin()
0    2.0
1    NaN
2    2.0
3   -1.0
4   -1.0
dtype: float64

To include NA values in the operation, use ``skipna=False``

>>> s.cummin(skipna=False)
0    2.0
1    NaN
2    NaN
3    NaN
4    NaN
dtype: float64

**DataFrame**

>>> df = pd.DataFrame([[2.0, 1.0],
...                    [3.0, np.nan],
...                    [1.0, 0.0]],
...                   columns=list('AB'))
>>> df
     A    B
0  2.0  1.0
1  3.0  NaN
2  1.0  0.0

By default, iterates over rows and finds the minimum
in each column. This is equivalent to ``axis=None`` or ``axis='index'``.

>>> df.cummin()
     A    B
0  2.0  1.0
1  2.0  NaN
2  1.0  0.0

To iterate over columns and find the minimum in each row,
use ``axis=1``

>>> df.cummin(axis=1)
     A    B
0  2.0  1.0
1  3.0  NaN
2  1.0  0.0
        """
        pass
    @overload
    def cumprod(
        self: Series[Never],
        axis: AxisIndex = ...,
        skipna: _bool = ...,
        *args: Any,
        **kwargs: Any,
    ) -> Series:
        """
Return cumulative product over a DataFrame or Series axis.

Returns a DataFrame or Series of the same size containing the cumulative
product.

Parameters
----------
axis : {0 or 'index', 1 or 'columns'}, default 0
    The index or the name of the axis. 0 is equivalent to None or 'index'.
    For `Series` this parameter is unused and defaults to 0.
skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
*args, **kwargs
    Additional keywords have no effect but might be accepted for
    compatibility with NumPy.

Returns
-------
scalar or Series
    Return cumulative product of scalar or Series.

See Also
--------
core.window.expanding.Expanding.prod : Similar functionality
    but ignores ``NaN`` values.
Series.prod : Return the product over
    Series axis.
Series.cummax : Return cumulative maximum over Series axis.
Series.cummin : Return cumulative minimum over Series axis.
Series.cumsum : Return cumulative sum over Series axis.
Series.cumprod : Return cumulative product over Series axis.

Examples
--------
**Series**

>>> s = pd.Series([2, np.nan, 5, -1, 0])
>>> s
0    2.0
1    NaN
2    5.0
3   -1.0
4    0.0
dtype: float64

By default, NA values are ignored.

>>> s.cumprod()
0     2.0
1     NaN
2    10.0
3   -10.0
4    -0.0
dtype: float64

To include NA values in the operation, use ``skipna=False``

>>> s.cumprod(skipna=False)
0    2.0
1    NaN
2    NaN
3    NaN
4    NaN
dtype: float64

**DataFrame**

>>> df = pd.DataFrame([[2.0, 1.0],
...                    [3.0, np.nan],
...                    [1.0, 0.0]],
...                   columns=list('AB'))
>>> df
     A    B
0  2.0  1.0
1  3.0  NaN
2  1.0  0.0

By default, iterates over rows and finds the product
in each column. This is equivalent to ``axis=None`` or ``axis='index'``.

>>> df.cumprod()
     A    B
0  2.0  1.0
1  6.0  NaN
2  6.0  0.0

To iterate over columns and find the product in each row,
use ``axis=1``

>>> df.cumprod(axis=1)
     A    B
0  2.0  2.0
1  3.0  NaN
2  1.0  0.0
        """
        pass
    @overload
    def cumprod(
        self: Series[bool],
        axis: AxisIndex = ...,
        skipna: _bool = ...,
        *args: Any,
        **kwargs: Any,
    ) -> Series[int]: ...
    @overload
    def cumprod(
        self: SupportsGetItem[Scalar, _SupportsMul[S1]],
        axis: AxisIndex = ...,
        skipna: _bool = ...,
        *args: Any,
        **kwargs: Any,
    ) -> Series[S1]: ...
    def cumsum(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        *args: Any,
        **kwargs: Any,
    ) -> Series[S1]:
        """
Return cumulative sum over a DataFrame or Series axis.

Returns a DataFrame or Series of the same size containing the cumulative
sum.

Parameters
----------
axis : {0 or 'index', 1 or 'columns'}, default 0
    The index or the name of the axis. 0 is equivalent to None or 'index'.
    For `Series` this parameter is unused and defaults to 0.
skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
*args, **kwargs
    Additional keywords have no effect but might be accepted for
    compatibility with NumPy.

Returns
-------
scalar or Series
    Return cumulative sum of scalar or Series.

See Also
--------
core.window.expanding.Expanding.sum : Similar functionality
    but ignores ``NaN`` values.
Series.sum : Return the sum over
    Series axis.
Series.cummax : Return cumulative maximum over Series axis.
Series.cummin : Return cumulative minimum over Series axis.
Series.cumsum : Return cumulative sum over Series axis.
Series.cumprod : Return cumulative product over Series axis.

Examples
--------
**Series**

>>> s = pd.Series([2, np.nan, 5, -1, 0])
>>> s
0    2.0
1    NaN
2    5.0
3   -1.0
4    0.0
dtype: float64

By default, NA values are ignored.

>>> s.cumsum()
0    2.0
1    NaN
2    7.0
3    6.0
4    6.0
dtype: float64

To include NA values in the operation, use ``skipna=False``

>>> s.cumsum(skipna=False)
0    2.0
1    NaN
2    NaN
3    NaN
4    NaN
dtype: float64

**DataFrame**

>>> df = pd.DataFrame([[2.0, 1.0],
...                    [3.0, np.nan],
...                    [1.0, 0.0]],
...                   columns=list('AB'))
>>> df
     A    B
0  2.0  1.0
1  3.0  NaN
2  1.0  0.0

By default, iterates over rows and finds the sum
in each column. This is equivalent to ``axis=None`` or ``axis='index'``.

>>> df.cumsum()
     A    B
0  2.0  1.0
1  5.0  NaN
2  6.0  1.0

To iterate over columns and find the sum in each row,
use ``axis=1``

>>> df.cumsum(axis=1)
     A    B
0  2.0  3.0
1  3.0  NaN
2  1.0  1.0
        """
        pass
    def divmod(
        self,
        other: num | ListLike | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[S1]:
        """
Return Integer division and modulo of series and other, element-wise (binary operator `divmod`).

Equivalent to ``divmod(series, other)``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
2-Tuple of Series
    The result of the operation.

See Also
--------
Series.rdivmod : Reverse of the Integer division and modulo operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.divmod(b, fill_value=0)
(a    1.0
 b    inf
 c    inf
 d    0.0
 e    NaN
 dtype: float64,
 a    0.0
 b    NaN
 c    NaN
 d    0.0
 e    NaN
 dtype: float64)
        """
        pass
    def eq(
        self,
        other: Scalar | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[_bool]:
        """
Return Equal to of series and other, element-wise (binary operator `eq`).

Equivalent to ``series == other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.eq(b, fill_value=0)
a     True
b    False
c    False
d    False
e    False
dtype: bool
        """
        pass
    @final
    def ewm(
        self,
        com: float | None = None,
        span: float | None = None,
        halflife: float | None = None,
        alpha: float | None = None,
        min_periods: int = 0,
        adjust: _bool = True,
        ignore_na: _bool = False,
        axis: Axis = 0,
        times: np.ndarray | Series | None = None,
        method: CalculationMethod = "single",
    ) -> ExponentialMovingWindow[Series]: ...
    @final
    def expanding(
        self,
        min_periods: int = 1,
        axis: Literal[0] = 0,
        method: CalculationMethod = "single",
    ) -> Expanding[Series]: ...
    def ge(
        self,
        other: Scalar | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[_bool]:
        """
Return Greater than or equal to of series and other, element-wise (binary operator `ge`).

Equivalent to ``series >= other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan, 1], index=['a', 'b', 'c', 'd', 'e'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
e    1.0
dtype: float64
>>> b = pd.Series([0, 1, 2, np.nan, 1], index=['a', 'b', 'c', 'd', 'f'])
>>> b
a    0.0
b    1.0
c    2.0
d    NaN
f    1.0
dtype: float64
>>> a.ge(b, fill_value=0)
a     True
b     True
c    False
d    False
e     True
f    False
dtype: bool
        """
        pass
    def gt(
        self,
        other: Scalar | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[_bool]:
        """
Return Greater than of series and other, element-wise (binary operator `gt`).

Equivalent to ``series > other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan, 1], index=['a', 'b', 'c', 'd', 'e'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
e    1.0
dtype: float64
>>> b = pd.Series([0, 1, 2, np.nan, 1], index=['a', 'b', 'c', 'd', 'f'])
>>> b
a    0.0
b    1.0
c    2.0
d    NaN
f    1.0
dtype: float64
>>> a.gt(b, fill_value=0)
a     True
b    False
c    False
d    False
e     True
f    False
dtype: bool
        """
        pass
    @final
    def item(self) -> S1: ...
    def kurt(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Scalar:
        """
Return unbiased kurtosis over requested axis.

Kurtosis obtained using Fisher's definition of
kurtosis (kurtosis of normal == 0.0). Normalized by N-1.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

            Examples
            --------
            >>> s = pd.Series([1, 2, 2, 3], index=['cat', 'dog', 'dog', 'mouse'])
            >>> s
            cat    1
            dog    2
            dog    2
            mouse  3
            dtype: int64
            >>> s.kurt()
            1.5

            With a DataFrame

            >>> df = pd.DataFrame({'a': [1, 2, 2, 3], 'b': [3, 4, 4, 4]},
            ...                   index=['cat', 'dog', 'dog', 'mouse'])
            >>> df
                   a   b
              cat  1   3
              dog  2   4
              dog  2   4
            mouse  3   4
            >>> df.kurt()
            a   1.5
            b   4.0
            dtype: float64

            With axis=None

            >>> df.kurt(axis=None).round(6)
            -0.988693

            Using axis=1

            >>> df = pd.DataFrame({'a': [1, 2], 'b': [3, 4], 'c': [3, 4], 'd': [1, 2]},
            ...                   index=['cat', 'dog'])
            >>> df.kurt(axis=1)
            cat   -6.0
            dog   -6.0
            dtype: float64
        """
        pass
    def kurtosis(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Scalar:
        """
Return unbiased kurtosis over requested axis.

Kurtosis obtained using Fisher's definition of
kurtosis (kurtosis of normal == 0.0). Normalized by N-1.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

            Examples
            --------
            >>> s = pd.Series([1, 2, 2, 3], index=['cat', 'dog', 'dog', 'mouse'])
            >>> s
            cat    1
            dog    2
            dog    2
            mouse  3
            dtype: int64
            >>> s.kurt()
            1.5

            With a DataFrame

            >>> df = pd.DataFrame({'a': [1, 2, 2, 3], 'b': [3, 4, 4, 4]},
            ...                   index=['cat', 'dog', 'dog', 'mouse'])
            >>> df
                   a   b
              cat  1   3
              dog  2   4
              dog  2   4
            mouse  3   4
            >>> df.kurt()
            a   1.5
            b   4.0
            dtype: float64

            With axis=None

            >>> df.kurt(axis=None).round(6)
            -0.988693

            Using axis=1

            >>> df = pd.DataFrame({'a': [1, 2], 'b': [3, 4], 'c': [3, 4], 'd': [1, 2]},
            ...                   index=['cat', 'dog'])
            >>> df.kurt(axis=1)
            cat   -6.0
            dog   -6.0
            dtype: float64
        """
        pass
    def le(
        self,
        other: Scalar | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[_bool]:
        """
Return Less than or equal to of series and other, element-wise (binary operator `le`).

Equivalent to ``series <= other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan, 1], index=['a', 'b', 'c', 'd', 'e'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
e    1.0
dtype: float64
>>> b = pd.Series([0, 1, 2, np.nan, 1], index=['a', 'b', 'c', 'd', 'f'])
>>> b
a    0.0
b    1.0
c    2.0
d    NaN
f    1.0
dtype: float64
>>> a.le(b, fill_value=0)
a    False
b     True
c     True
d    False
e    False
f     True
dtype: bool
        """
        pass
    def lt(
        self,
        other: Scalar | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[_bool]:
        """
Return Less than of series and other, element-wise (binary operator `lt`).

Equivalent to ``series < other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan, 1], index=['a', 'b', 'c', 'd', 'e'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
e    1.0
dtype: float64
>>> b = pd.Series([0, 1, 2, np.nan, 1], index=['a', 'b', 'c', 'd', 'f'])
>>> b
a    0.0
b    1.0
c    2.0
d    NaN
f    1.0
dtype: float64
>>> a.lt(b, fill_value=0)
a    False
b    False
c     True
d    False
e    False
f     True
dtype: bool
        """
        pass
    def max(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> S1:
        """
Return the maximum of the values over the requested axis.

If you want the *index* of the maximum, use ``idxmax``. This is the equivalent of the ``numpy.ndarray`` method ``argmax``.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

See Also
--------
Series.sum : Return the sum.
Series.min : Return the minimum.
Series.max : Return the maximum.
Series.idxmin : Return the index of the minimum.
Series.idxmax : Return the index of the maximum.
DataFrame.sum : Return the sum over the requested axis.
DataFrame.min : Return the minimum over the requested axis.
DataFrame.max : Return the maximum over the requested axis.
DataFrame.idxmin : Return the index of the minimum over the requested axis.
DataFrame.idxmax : Return the index of the maximum over the requested axis.

Examples
--------
>>> idx = pd.MultiIndex.from_arrays([
...     ['warm', 'warm', 'cold', 'cold'],
...     ['dog', 'falcon', 'fish', 'spider']],
...     names=['blooded', 'animal'])
>>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
>>> s
blooded  animal
warm     dog       4
         falcon    2
cold     fish      0
         spider    8
Name: legs, dtype: int64

>>> s.max()
8
        """
        pass
    @overload
    def mean(
        self: Series[Never],
        axis: AxisIndex | None = ...,
        skipna: _bool = ...,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> float:
        """
Return the mean of the values over the requested axis.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

            Examples
            --------
            >>> s = pd.Series([1, 2, 3])
            >>> s.mean()
            2.0

            With a DataFrame

            >>> df = pd.DataFrame({'a': [1, 2], 'b': [2, 3]}, index=['tiger', 'zebra'])
            >>> df
                   a   b
            tiger  1   2
            zebra  2   3
            >>> df.mean()
            a   1.5
            b   2.5
            dtype: float64

            Using axis=1

            >>> df.mean(axis=1)
            tiger   1.5
            zebra   2.5
            dtype: float64

            In this case, `numeric_only` should be set to `True` to avoid
            getting an error.

            >>> df = pd.DataFrame({'a': [1, 2], 'b': ['T', 'Z']},
            ...                   index=['tiger', 'zebra'])
            >>> df.mean(numeric_only=True)
            a   1.5
            dtype: float64
        """
        pass
    @overload
    def mean(
        self: Series[Timestamp],
        axis: AxisIndex | None = ...,
        skipna: _bool = ...,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Timestamp: ...
    @overload
    def mean(
        self: SupportsGetItem[Scalar, SupportsTruedivInt[S2]],
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> S2: ...
    @overload
    def median(
        self: Series[Never],
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> float:
        """
Return the median of the values over the requested axis.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

            Examples
            --------
            >>> s = pd.Series([1, 2, 3])
            >>> s.median()
            2.0

            With a DataFrame

            >>> df = pd.DataFrame({'a': [1, 2], 'b': [2, 3]}, index=['tiger', 'zebra'])
            >>> df
                   a   b
            tiger  1   2
            zebra  2   3
            >>> df.median()
            a   1.5
            b   2.5
            dtype: float64

            Using axis=1

            >>> df.median(axis=1)
            tiger   1.5
            zebra   2.5
            dtype: float64

            In this case, `numeric_only` should be set to `True`
            to avoid getting an error.

            >>> df = pd.DataFrame({'a': [1, 2], 'b': ['T', 'Z']},
            ...                   index=['tiger', 'zebra'])
            >>> df.median(numeric_only=True)
            a   1.5
            dtype: float64
        """
        pass
    @overload
    def median(
        self: Series[complex],
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> float: ...
    @overload
    def median(
        self: SupportsGetItem[Scalar, SupportsTruedivInt[S2]],
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> S2: ...
    @overload
    def median(
        self: Series[Timestamp],
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Timestamp: ...
    def min(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool = True,
        level: None = None,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> S1:
        """
Return the minimum of the values over the requested axis.

If you want the *index* of the minimum, use ``idxmin``. This is the equivalent of the ``numpy.ndarray`` method ``argmin``.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

See Also
--------
Series.sum : Return the sum.
Series.min : Return the minimum.
Series.max : Return the maximum.
Series.idxmin : Return the index of the minimum.
Series.idxmax : Return the index of the maximum.
DataFrame.sum : Return the sum over the requested axis.
DataFrame.min : Return the minimum over the requested axis.
DataFrame.max : Return the maximum over the requested axis.
DataFrame.idxmin : Return the index of the minimum over the requested axis.
DataFrame.idxmax : Return the index of the maximum over the requested axis.

Examples
--------
>>> idx = pd.MultiIndex.from_arrays([
...     ['warm', 'warm', 'cold', 'cold'],
...     ['dog', 'falcon', 'fish', 'spider']],
...     names=['blooded', 'animal'])
>>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
>>> s
blooded  animal
warm     dog       4
         falcon    2
cold     fish      0
         spider    8
Name: legs, dtype: int64

>>> s.min()
0
        """
        pass
    def mod(
        self,
        other: num | ListLike | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[S1]:
        """
Return Modulo of series and other, element-wise (binary operator `mod`).

Equivalent to ``series % other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.rmod : Reverse of the Modulo operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.mod(b, fill_value=0)
a    0.0
b    NaN
c    NaN
d    0.0
e    NaN
dtype: float64
        """
        pass
    def ne(
        self,
        other: Scalar | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[_bool]:
        """
Return Not equal to of series and other, element-wise (binary operator `ne`).

Equivalent to ``series != other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.ne(b, fill_value=0)
a    False
b     True
c     True
d     True
e     True
dtype: bool
        """
        pass
    @final
    def nunique(self, dropna: _bool = True) -> int: ...
    def pow(
        self,
        other: num | ListLike | Series[S1],
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex | None = 0,
    ) -> Series[S1]:
        """
Return Exponential power of series and other, element-wise (binary operator `pow`).

Equivalent to ``series ** other``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.rpow : Reverse of the Exponential power operator, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.pow(b, fill_value=0)
a    1.0
b    1.0
c    1.0
d    0.0
e    NaN
dtype: float64
        """
        pass
    def prod(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        numeric_only: _bool = False,
        min_count: int = 0,
        **kwargs: Any,
    ) -> Scalar:
        """
Return the product of the values over the requested axis.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    .. warning::

        The behavior of DataFrame.prod with ``axis=None`` is deprecated,
        in a future version this will reduce over both axes and return a scalar
        To retain the old behavior, pass axis=0 (or do not pass axis).

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

min_count : int, default 0
    The required number of valid values to perform the operation. If fewer than
    ``min_count`` non-NA values are present the result will be NA.
**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

See Also
--------
Series.sum : Return the sum.
Series.min : Return the minimum.
Series.max : Return the maximum.
Series.idxmin : Return the index of the minimum.
Series.idxmax : Return the index of the maximum.
DataFrame.sum : Return the sum over the requested axis.
DataFrame.min : Return the minimum over the requested axis.
DataFrame.max : Return the maximum over the requested axis.
DataFrame.idxmin : Return the index of the minimum over the requested axis.
DataFrame.idxmax : Return the index of the maximum over the requested axis.

Examples
--------
By default, the product of an empty or all-NA Series is ``1``

>>> pd.Series([], dtype="float64").prod()
1.0

This can be controlled with the ``min_count`` parameter

>>> pd.Series([], dtype="float64").prod(min_count=1)
nan

Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
empty series identically.

>>> pd.Series([np.nan]).prod()
1.0

>>> pd.Series([np.nan]).prod(min_count=1)
nan
        """
        pass
    def product(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        numeric_only: _bool = False,
        min_count: int = 0,
        **kwargs: Any,
    ) -> Scalar:
        """
Return the product of the values over the requested axis.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    .. warning::

        The behavior of DataFrame.prod with ``axis=None`` is deprecated,
        in a future version this will reduce over both axes and return a scalar
        To retain the old behavior, pass axis=0 (or do not pass axis).

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

min_count : int, default 0
    The required number of valid values to perform the operation. If fewer than
    ``min_count`` non-NA values are present the result will be NA.
**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

See Also
--------
Series.sum : Return the sum.
Series.min : Return the minimum.
Series.max : Return the maximum.
Series.idxmin : Return the index of the minimum.
Series.idxmax : Return the index of the maximum.
DataFrame.sum : Return the sum over the requested axis.
DataFrame.min : Return the minimum over the requested axis.
DataFrame.max : Return the maximum over the requested axis.
DataFrame.idxmin : Return the index of the minimum over the requested axis.
DataFrame.idxmax : Return the index of the maximum over the requested axis.

Examples
--------
By default, the product of an empty or all-NA Series is ``1``

>>> pd.Series([], dtype="float64").prod()
1.0

This can be controlled with the ``min_count`` parameter

>>> pd.Series([], dtype="float64").prod(min_count=1)
nan

Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
empty series identically.

>>> pd.Series([np.nan]).prod()
1.0

>>> pd.Series([np.nan]).prod(min_count=1)
nan
        """
        pass
    def rdivmod(
        self,
        other: Series[S1] | Scalar,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[S1]:
        """
Return Integer division and modulo of series and other, element-wise (binary operator `rdivmod`).

Equivalent to ``other divmod series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
2-Tuple of Series
    The result of the operation.

See Also
--------
Series.divmod : Element-wise Integer division and modulo, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.divmod(b, fill_value=0)
(a    1.0
 b    inf
 c    inf
 d    0.0
 e    NaN
 dtype: float64,
 a    0.0
 b    NaN
 c    NaN
 d    0.0
 e    NaN
 dtype: float64)
        """
        pass
    def rmod(
        self,
        other: Series[S1] | Scalar,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[S1]:
        """
Return Modulo of series and other, element-wise (binary operator `rmod`).

Equivalent to ``other % series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.mod : Element-wise Modulo, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.mod(b, fill_value=0)
a    0.0
b    NaN
c    NaN
d    0.0
e    NaN
dtype: float64
        """
        pass
    @overload
    def rolling(
        self,
        window: int | Frequency | timedelta | BaseIndexer,
        min_periods: int | None = ...,
        center: _bool = ...,
        on: _str | None = ...,
        closed: IntervalClosedType | None = ...,
        step: int | None = ...,
        method: CalculationMethod = ...,
        *,
        win_type: _str,
    ) -> Window[Series]: ...
    @overload
    def rolling(
        self,
        window: int | Frequency | timedelta | BaseIndexer,
        min_periods: int | None = ...,
        center: _bool = ...,
        on: _str | None = ...,
        closed: IntervalClosedType | None = ...,
        step: int | None = ...,
        method: CalculationMethod = ...,
        *,
        win_type: None = None,
    ) -> Rolling[Series]: ...
    def rpow(
        self,
        other: Series[S1] | Scalar,
        level: Level | None = ...,
        fill_value: float | None = None,
        axis: AxisIndex = ...,
    ) -> Series[S1]:
        """
Return Exponential power of series and other, element-wise (binary operator `rpow`).

Equivalent to ``other ** series``, but with support to substitute a fill_value for
missing data in either one of the inputs.

Parameters
----------
other : Series or scalar value
level : int or name
    Broadcast across a level, matching Index values on the
    passed MultiIndex level.
fill_value : None or float value, default None (NaN)
    Fill existing missing (NaN) values, and any new element needed for
    successful Series alignment, with this value before computation.
    If data in both corresponding Series locations is missing
    the result of filling (at that location) will be missing.
axis : {0 or 'index'}
    Unused. Parameter needed for compatibility with DataFrame.

Returns
-------
Series
    The result of the operation.

See Also
--------
Series.pow : Element-wise Exponential power, see
    `Python documentation
    <https://docs.python.org/3/reference/datamodel.html#emulating-numeric-types>`_
    for more details.

Examples
--------
>>> a = pd.Series([1, 1, 1, np.nan], index=['a', 'b', 'c', 'd'])
>>> a
a    1.0
b    1.0
c    1.0
d    NaN
dtype: float64
>>> b = pd.Series([1, np.nan, 1, np.nan], index=['a', 'b', 'd', 'e'])
>>> b
a    1.0
b    NaN
d    1.0
e    NaN
dtype: float64
>>> a.pow(b, fill_value=0)
a    1.0
b    1.0
c    1.0
d    0.0
e    NaN
dtype: float64
        """
        pass
    def sem(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        ddof: int = 1,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Scalar:
        """
Return unbiased standard error of the mean over requested axis.

Normalized by N-1 by default. This can be changed using the ddof argument

Parameters
----------
axis : {index (0)}
    For `Series` this parameter is unused and defaults to 0.

    .. warning::

        The behavior of DataFrame.sem with ``axis=None`` is deprecated,
        in a future version this will reduce over both axes and return a scalar
        To retain the old behavior, pass axis=0 (or do not pass axis).

skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
ddof : int, default 1
    Delta Degrees of Freedom. The divisor used in calculations is N - ddof,
    where N represents the number of elements.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

Returns
-------
scalar or Series (if level specified) 

            Examples
            --------
            >>> s = pd.Series([1, 2, 3])
            >>> s.sem().round(6)
            0.57735

            With a DataFrame

            >>> df = pd.DataFrame({'a': [1, 2], 'b': [2, 3]}, index=['tiger', 'zebra'])
            >>> df
                   a   b
            tiger  1   2
            zebra  2   3
            >>> df.sem()
            a   0.5
            b   0.5
            dtype: float64

            Using axis=1

            >>> df.sem(axis=1)
            tiger   0.5
            zebra   0.5
            dtype: float64

            In this case, `numeric_only` should be set to `True`
            to avoid getting an error.

            >>> df = pd.DataFrame({'a': [1, 2], 'b': ['T', 'Z']},
            ...                   index=['tiger', 'zebra'])
            >>> df.sem(numeric_only=True)
            a   0.5
            dtype: float64
        """
        pass
    def skew(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Scalar:
        """
Return unbiased skew over requested axis.

Normalized by N-1.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    For DataFrames, specifying ``axis=None`` will apply the aggregation
    across both axes.

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

            Examples
            --------
            >>> s = pd.Series([1, 2, 3])
            >>> s.skew()
            0.0

            With a DataFrame

            >>> df = pd.DataFrame({'a': [1, 2, 3], 'b': [2, 3, 4], 'c': [1, 3, 5]},
            ...                   index=['tiger', 'zebra', 'cow'])
            >>> df
                    a   b   c
            tiger   1   2   1
            zebra   2   3   3
            cow     3   4   5
            >>> df.skew()
            a   0.0
            b   0.0
            c   0.0
            dtype: float64

            Using axis=1

            >>> df.skew(axis=1)
            tiger   1.732051
            zebra  -1.732051
            cow     0.000000
            dtype: float64

            In this case, `numeric_only` should be set to `True` to avoid
            getting an error.

            >>> df = pd.DataFrame({'a': [1, 2, 3], 'b': ['T', 'Z', 'X']},
            ...                   index=['tiger', 'zebra', 'cow'])
            >>> df.skew(numeric_only=True)
            a   0.0
            dtype: float64
        """
        pass
    @overload
    def std(
        self: Series[Never],
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        ddof: int = 1,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> float:
        """
Return sample standard deviation over requested axis.

Normalized by N-1 by default. This can be changed using the ddof argument.

Parameters
----------
axis : {index (0)}
    For `Series` this parameter is unused and defaults to 0.

    .. warning::

        The behavior of DataFrame.std with ``axis=None`` is deprecated,
        in a future version this will reduce over both axes and return a scalar
        To retain the old behavior, pass axis=0 (or do not pass axis).

skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
ddof : int, default 1
    Delta Degrees of Freedom. The divisor used in calculations is N - ddof,
    where N represents the number of elements.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

Returns
-------
scalar or Series (if level specified) 

Notes
-----
To have the same behaviour as `numpy.std`, use `ddof=0` (instead of the
default `ddof=1`)

Examples
--------
>>> df = pd.DataFrame({'person_id': [0, 1, 2, 3],
...                    'age': [21, 25, 62, 43],
...                    'height': [1.61, 1.87, 1.49, 2.01]}
...                   ).set_index('person_id')
>>> df
           age  height
person_id
0           21    1.61
1           25    1.87
2           62    1.49
3           43    2.01

The standard deviation of the columns can be found as follows:

>>> df.std()
age       18.786076
height     0.237417
dtype: float64

Alternatively, `ddof=0` can be set to normalize by N instead of N-1:

>>> df.std(ddof=0)
age       16.269219
height     0.205609
dtype: float64
        """
        pass
    @overload
    def std(
        self: Series[complex],
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        level: None = None,
        ddof: int = ...,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> np.float64: ...
    @overload
    def std(
        self: Series[Timestamp],
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        level: None = None,
        ddof: int = ...,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Timedelta: ...
    @overload
    def std(
        self: SupportsGetItem[Scalar, SupportsTruedivInt[S2]],
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        ddof: int = 1,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> S2: ...
    def sum(
        self: SupportsGetItem[Scalar, _SupportsAdd[_T]],
        axis: AxisIndex | None = 0,
        skipna: _bool | None = ...,
        numeric_only: _bool = ...,
        min_count: int = ...,
        **kwargs: Any,
    ) -> _T:
        """
Return the sum of the values over the requested axis.

This is equivalent to the method ``numpy.sum``.

Parameters
----------
axis : {index (0)}
    Axis for the function to be applied on.
    For `Series` this parameter is unused and defaults to 0.

    .. warning::

        The behavior of DataFrame.sum with ``axis=None`` is deprecated,
        in a future version this will reduce over both axes and return a scalar
        To retain the old behavior, pass axis=0 (or do not pass axis).

    .. versionadded:: 2.0.0

skipna : bool, default True
    Exclude NA/null values when computing the result.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

min_count : int, default 0
    The required number of valid values to perform the operation. If fewer than
    ``min_count`` non-NA values are present the result will be NA.
**kwargs
    Additional keyword arguments to be passed to the function.

Returns
-------
scalar or scalar

See Also
--------
Series.sum : Return the sum.
Series.min : Return the minimum.
Series.max : Return the maximum.
Series.idxmin : Return the index of the minimum.
Series.idxmax : Return the index of the maximum.
DataFrame.sum : Return the sum over the requested axis.
DataFrame.min : Return the minimum over the requested axis.
DataFrame.max : Return the maximum over the requested axis.
DataFrame.idxmin : Return the index of the minimum over the requested axis.
DataFrame.idxmax : Return the index of the maximum over the requested axis.

Examples
--------
>>> idx = pd.MultiIndex.from_arrays([
...     ['warm', 'warm', 'cold', 'cold'],
...     ['dog', 'falcon', 'fish', 'spider']],
...     names=['blooded', 'animal'])
>>> s = pd.Series([4, 2, 0, 8], name='legs', index=idx)
>>> s
blooded  animal
warm     dog       4
         falcon    2
cold     fish      0
         spider    8
Name: legs, dtype: int64

>>> s.sum()
14

By default, the sum of an empty or all-NA Series is ``0``.

>>> pd.Series([], dtype="float64").sum()  # min_count=0 is the default
0.0

This can be controlled with the ``min_count`` parameter. For example, if
you'd like the sum of an empty series to be NaN, pass ``min_count=1``.

>>> pd.Series([], dtype="float64").sum(min_count=1)
nan

Thanks to the ``skipna`` parameter, ``min_count`` handles all-NA and
empty series identically.

>>> pd.Series([np.nan]).sum()
0.0

>>> pd.Series([np.nan]).sum(min_count=1)
nan
        """
        pass
    def to_list(self) -> list[S1]: ...
    @overload  # type: ignore[override]
    def to_numpy(
        self: Series[Never],
        dtype: DTypeLike | None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray: ...
    @overload
    def to_numpy(
        self: Series[Timestamp],
        dtype: type[np.datetime64] | None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.datetime64]: ...
    @overload
    def to_numpy(
        self: Series[Timestamp],
        dtype: np.dtype[GenericT] | SupportsDType[GenericT] | type[GenericT],
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[GenericT]: ...
    @overload
    def to_numpy(
        self: Series[Timedelta],
        dtype: type[np.timedelta64] | None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.timedelta64]: ...
    @overload
    def to_numpy(
        self: Series[Timedelta],
        dtype: np.dtype[GenericT] | SupportsDType[GenericT] | type[GenericT],
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[GenericT]: ...
    @overload
    def to_numpy(
        self: Series[Period],
        dtype: None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.object_]: ...
    @overload
    def to_numpy(
        self: Series[Period],
        dtype: type[np.int64],
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.int64]: ...
    @overload
    def to_numpy(
        self: Series[BaseOffset],
        dtype: None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.object_]: ...
    @overload
    def to_numpy(
        self: Series[BaseOffset],
        dtype: type[np.bytes_],
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.bytes_]: ...
    @overload
    def to_numpy(
        self: Series[Interval],
        dtype: type[np.object_] | None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[np.object_]: ...
    @overload
    def to_numpy(
        self: Series[Interval],
        dtype: type[_T_INTERVAL_NP],
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[_T_INTERVAL_NP]: ...
    @overload
    def to_numpy(  # pyright: ignore[reportIncompatibleMethodOverride]
        self,
        dtype: DTypeLike | None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray: ...
    def tolist(self) -> list[S1]: ...
    def var(
        self,
        axis: AxisIndex | None = 0,
        skipna: _bool | None = True,
        ddof: int = 1,
        numeric_only: _bool = False,
        **kwargs: Any,
    ) -> Scalar:
        """
Return unbiased variance over requested axis.

Normalized by N-1 by default. This can be changed using the ddof argument.

Parameters
----------
axis : {index (0)}
    For `Series` this parameter is unused and defaults to 0.

    .. warning::

        The behavior of DataFrame.var with ``axis=None`` is deprecated,
        in a future version this will reduce over both axes and return a scalar
        To retain the old behavior, pass axis=0 (or do not pass axis).

skipna : bool, default True
    Exclude NA/null values. If an entire row/column is NA, the result
    will be NA.
ddof : int, default 1
    Delta Degrees of Freedom. The divisor used in calculations is N - ddof,
    where N represents the number of elements.
numeric_only : bool, default False
    Include only float, int, boolean columns. Not implemented for Series.

Returns
-------
scalar or Series (if level specified) 

Examples
--------
>>> df = pd.DataFrame({'person_id': [0, 1, 2, 3],
...                    'age': [21, 25, 62, 43],
...                    'height': [1.61, 1.87, 1.49, 2.01]}
...                   ).set_index('person_id')
>>> df
           age  height
person_id
0           21    1.61
1           25    1.87
2           62    1.49
3           43    2.01

>>> df.var()
age       352.916667
height      0.056367
dtype: float64

Alternatively, ``ddof=0`` can be set to normalize by N instead of N-1:

>>> df.var(ddof=0)
age       264.687500
height      0.042275
dtype: float64
        """
        pass
    # Rename axis with `mapper`, `axis`, and `inplace=True`
    @overload
    def rename_axis(
        self,
        mapper: Scalar | ListLike | None = ...,
        *,
        axis: AxisIndex | None = 0,
        copy: _bool = ...,
        inplace: Literal[True],
    ) -> None:
        """
Set the name of the axis for the index or columns.

Parameters
----------
mapper : scalar, list-like, optional
    Value to set the axis name attribute.
index, columns : scalar, list-like, dict-like or function, optional
    A scalar, list-like, dict-like or functions transformations to
    apply to that axis' values.
    Note that the ``columns`` parameter is not allowed if the
    object is a Series. This parameter only apply for DataFrame
    type objects.

    Use either ``mapper`` and ``axis`` to
    specify the axis to target with ``mapper``, or ``index``
    and/or ``columns``.
axis : {0 or 'index', 1 or 'columns'}, default 0
    The axis to rename. For `Series` this parameter is unused and defaults to 0.
copy : bool, default None
    Also copy underlying data.

    .. note::
        The `copy` keyword will change behavior in pandas 3.0.
        `Copy-on-Write
        <https://pandas.pydata.org/docs/dev/user_guide/copy_on_write.html>`__
        will be enabled by default, which means that all methods with a
        `copy` keyword will use a lazy copy mechanism to defer the copy and
        ignore the `copy` keyword. The `copy` keyword will be removed in a
        future version of pandas.

        You can already get the future behavior and improvements through
        enabling copy on write ``pd.options.mode.copy_on_write = True``
inplace : bool, default False
    Modifies the object directly, instead of creating a new Series
    or DataFrame.

Returns
-------
Series, DataFrame, or None
    The same type as the caller or None if ``inplace=True``.

See Also
--------
Series.rename : Alter Series index labels or name.
DataFrame.rename : Alter DataFrame index labels or name.
Index.rename : Set new names on index.

Notes
-----
``DataFrame.rename_axis`` supports two calling conventions

* ``(index=index_mapper, columns=columns_mapper, ...)``
* ``(mapper, axis={'index', 'columns'}, ...)``

The first calling convention will only modify the names of
the index and/or the names of the Index object that is the columns.
In this case, the parameter ``copy`` is ignored.

The second calling convention will modify the names of the
corresponding index if mapper is a list or a scalar.
However, if mapper is dict-like or a function, it will use the
deprecated behavior of modifying the axis *labels*.

We *highly* recommend using keyword arguments to clarify your
intent.

Examples
--------
**Series**

>>> s = pd.Series(["dog", "cat", "monkey"])
>>> s
0       dog
1       cat
2    monkey
dtype: object
>>> s.rename_axis("animal")
animal
0    dog
1    cat
2    monkey
dtype: object

**DataFrame**

>>> df = pd.DataFrame({"num_legs": [4, 4, 2],
...                    "num_arms": [0, 0, 2]},
...                   ["dog", "cat", "monkey"])
>>> df
        num_legs  num_arms
dog            4         0
cat            4         0
monkey         2         2
>>> df = df.rename_axis("animal")
>>> df
        num_legs  num_arms
animal
dog            4         0
cat            4         0
monkey         2         2
>>> df = df.rename_axis("limbs", axis="columns")
>>> df
limbs   num_legs  num_arms
animal
dog            4         0
cat            4         0
monkey         2         2

**MultiIndex**

>>> df.index = pd.MultiIndex.from_product([['mammal'],
...                                        ['dog', 'cat', 'monkey']],
...                                       names=['type', 'name'])
>>> df
limbs          num_legs  num_arms
type   name
mammal dog            4         0
       cat            4         0
       monkey         2         2

>>> df.rename_axis(index={'type': 'class'})
limbs          num_legs  num_arms
class  name
mammal dog            4         0
       cat            4         0
       monkey         2         2

>>> df.rename_axis(columns=str.upper)
LIMBS          num_legs  num_arms
type   name
mammal dog            4         0
       cat            4         0
       monkey         2         2
        """
        pass
    # Rename axis with `mapper`, `axis`, and `inplace=False`
    @overload
    def rename_axis(
        self,
        mapper: Scalar | ListLike | None = ...,
        *,
        axis: AxisIndex | None = 0,
        copy: _bool = ...,
        inplace: Literal[False] = False,
    ) -> Self: ...
    # Rename axis with `index` and `inplace=True`
    @overload
    def rename_axis(
        self,
        *,
        index: Scalar | ListLike | Callable | dict | None = ...,
        copy: _bool = ...,
        inplace: Literal[True],
    ) -> None: ...
    # Rename axis with `index` and `inplace=False`
    @overload
    def rename_axis(
        self,
        *,
        index: Scalar | ListLike | Callable | dict | None = ...,
        copy: _bool = ...,
        inplace: Literal[False] = False,
    ) -> Self: ...
    def set_axis(
        self,
        labels: AxesData,
        *,
        axis: Axis = 0,
        copy: _bool | _NoDefaultDoNotUse = ...,
    ) -> Self:
        """
Assign desired index to given axis.

Indexes for row labels can be changed by assigning
a list-like or Index.

Parameters
----------
labels : list-like, Index
    The values for the new index.

axis : {0 or 'index'}, default 0
    The axis to update. The value 0 identifies the rows. For `Series`
    this parameter is unused and defaults to 0.

copy : bool, default True
    Whether to make a copy of the underlying data.

    .. note::
        The `copy` keyword will change behavior in pandas 3.0.
        `Copy-on-Write
        <https://pandas.pydata.org/docs/dev/user_guide/copy_on_write.html>`__
        will be enabled by default, which means that all methods with a
        `copy` keyword will use a lazy copy mechanism to defer the copy and
        ignore the `copy` keyword. The `copy` keyword will be removed in a
        future version of pandas.

        You can already get the future behavior and improvements through
        enabling copy on write ``pd.options.mode.copy_on_write = True``

Returns
-------
Series
    An object of type Series.

See Also
--------
Series.rename_axis : Alter the name of the index.

        Examples
        --------
        >>> s = pd.Series([1, 2, 3])
        >>> s
        0    1
        1    2
        2    3
        dtype: int64

        >>> s.set_axis(['a', 'b', 'c'], axis=0)
        a    1
        b    2
        c    3
        dtype: int64
        """
        pass
    @final
    def xs(
        self,
        key: Hashable,
        axis: AxisIndex = 0,
        level: Level | None = ...,
        drop_level: _bool = True,
    ) -> Self: ...
    @final
    def __bool__(self) -> NoReturn: ...

@type_check_only
class _SeriesSubclassBase(Series[S1], Generic[S1, GenericT_co]):
    @overload  # type: ignore[override]
    def to_numpy(  # pyrefly: ignore
        self,
        dtype: None = None,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[GenericT_co]: ...
    @overload
    def to_numpy(
        self,
        dtype: np.dtype[GenericT] | SupportsDType[GenericT] | type[GenericT],
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray[GenericT]: ...
    @overload
    def to_numpy(  # pyright: ignore[reportIncompatibleMethodOverride]
        self,
        dtype: DTypeLike,
        copy: bool = False,
        na_value: Scalar = ...,
        **kwargs: Any,
    ) -> np_1darray: ...
