from enum import Enum
from typing import (
    Any,
    final,
    overload,
)

from pandas.core.arrays import (
    ExtensionArray,
    ExtensionOpsMixin,
)
from typing_extensions import Self

from pandas._typing import (
    NpDtype,
    ScalarIndexer,
    SequenceIndexer,
    np_1darray,
)

@final
class ellipsis(Enum):
    Ellipsis = "..."

class SparseArray(ExtensionArray, ExtensionOpsMixin):
    def __init__(
        self,
        data,
        sparse_index=...,
        fill_value=...,
        kind: str = ...,
        dtype=...,
        copy: bool = ...,
    ) -> None: ...
    @classmethod
    def from_spmatrix(cls, data) -> Self: ...
    def __array__(
        self, dtype: NpDtype | None = None, copy: bool | None = None
    ) -> np_1darray: ...
    def __setitem__(self, key, value) -> None: ...
    @property
    def sp_index(self): ...
    @property
    def sp_values(self): ...
    @property
    def dtype(self): ...
    @property
    def fill_value(self): ...
    @fill_value.setter
    def fill_value(self, value) -> None: ...
    @property
    def kind(self) -> str: ...
    @property
    def nbytes(self) -> int: ...
    @property
    def density(self): ...
    @property
    def npoints(self) -> int: ...
    def isna(self): ...
    def shift(self, periods: int = 1, fill_value=...): ...
    def unique(self): ...
    def value_counts(self, dropna: bool = True): ...
    @overload
    def __getitem__(self, key: ScalarIndexer) -> Any: ...
    @overload
    def __getitem__(
        self,
        key: SequenceIndexer | tuple[int | ellipsis, ...],
    ) -> Self: ...
    def copy(self): ...
    def map(self, mapper): ...
    def to_dense(self): ...
    def nonzero(self): ...
    def all(self, axis=..., *args: Any, **kwargs: Any): ...
    def any(self, axis: int = ..., *args: Any, **kwargs: Any): ...
    def sum(self, axis: int = 0, *args: Any, **kwargs: Any): ...
    def cumsum(self, axis: int = ..., *args: Any, **kwargs: Any): ...
    def mean(self, axis: int = ..., *args: Any, **kwargs: Any): ...
    @property
    def T(self): ...
    def __abs__(self): ...
