from typing import Any

from typing_extensions import Self

class OpsMixin:
    def __eq__(self, other: object) -> Self: ...  # type: ignore[override] # pyright: ignore[reportIncompatibleMethodOverride]
    def __ne__(self, other: object) -> Self: ...  # type: ignore[override] # pyright: ignore[reportIncompatibleMethodOverride]
    def __lt__(self, other: Any) -> Self: ...
    def __le__(self, other: Any) -> Self: ...
    def __gt__(self, other: Any) -> Self: ...
    def __ge__(self, other: Any) -> Self: ...
    # -------------------------------------------------------------
    # Logical Methods
    def __and__(self, other: Any) -> Self: ...
    def __rand__(self, other: Any) -> Self: ...
    def __or__(self, other: Any) -> Self: ...
    def __ror__(self, other: Any) -> Self: ...
    def __xor__(self, other: Any) -> Self: ...
    def __rxor__(self, other: Any) -> Self: ...
    # -------------------------------------------------------------
    # Arithmetic Methods
    def __mod__(self, other: Any) -> Self: ...
    def __rmod__(self, other: Any) -> Self: ...
    def __divmod__(self, other: Any) -> tuple[Self, Self]: ...
    def __rdivmod__(self, other: Any) -> tuple[Self, Self]: ...
    def __pow__(self, other: Any) -> Self: ...
    def __rpow__(self, other: Any) -> Self: ...
