import contextlib
from collections.abc import Generator
from typing import Literal

import numpy as np
from packaging.version import parse as parse_version

from . import _docstring, _version, cbook, colors as colors, rcsetup
from ._typing import *

class __getattr__:
    URL_REGEX = ...

def set_loglevel(level: Literal["notset", "debug", "info", "warning", "error", "critical"]) -> None: ...

class ExecutableNotFoundError(FileNotFoundError): ...

def checkdep_usetex(s) -> bool: ...
def get_configdir() -> str: ...
def get_cachedir() -> str: ...
def get_data_path() -> str: ...
def matplotlib_fname() -> str: ...

class RcParams(dict):
    validate = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def find_all(self, pattern) -> RcParams: ...
    def copy(self) -> RcParams: ...

def rc_params(fail_on_error: bool = ...) -> RcParams: ...
def is_url(filename: str) -> bool: ...
def rc_params_from_file(fname: str | PathLike, fail_on_error: bool = ..., use_default_template: bool = ...) -> RcParams: ...

rcParamsDefault: RcParams = ...
rcParams: RcParams = ...
rcParamsOrig: RcParams = ...

def rc(group, **kwargs) -> None: ...
def rcdefaults() -> None: ...
def rc_file_defaults() -> None: ...
def rc_file(fname: str | PathLike, *, use_default_template: bool = ...) -> None: ...
@contextlib.contextmanager
def rc_context(rc: dict = ..., fname: str | PathLike = ...) -> Generator: ...
def use(backend: str, *, force: bool = True) -> None: ...
def get_backend() -> str: ...
def interactive(b) -> bool: ...
def is_interactive() -> bool: ...

default_test_modules: list[str] = ...

def test(verbosity=..., coverage=..., **kwargs): ...
