from collections.abc import Iterable, Sequence
from typing import Any, TypeAlias

from django.db.models.sql.where import NothingNode

_NodeChildren: TypeAlias = Iterable[Node | NothingNode | Sequence[Any]]

class Node:
    children: list[Any]
    default: Any = ...
    connector: str = ...
    negated: bool = ...
    def __init__(
        self,
        children: _NodeChildren | None = ...,
        connector: str | None = ...,
        negated: bool = ...,
    ) -> None: ...
    def __deepcopy__(self, memodict: dict[Any, Any]) -> Node: ...
    def __len__(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, other: tuple[str, int]) -> bool: ...
    def __hash__(self) -> int: ...
    def add(self, data: Any, conn_type: str, squash: bool = ...) -> Any: ...
    def negate(self) -> None: ...
