import sys
from collections.abc import Callable
from functools import wraps as wraps
from typing import Any, Generic, TypeVar, overload

from django.db.models.base import Model

if sys.version_info < (3, 8):
    from typing_extensions import Protocol
else:
    from typing import Protocol

_T = TypeVar("_T")

class cached_property(Generic[_T]):
    func: Callable[..., _T] = ...
    name: str = ...
    def __init__(self, func: Callable[..., _T], name: str = ...): ...
    @overload
    def __get__(self, instance: None, cls: type[Any] = ...) -> cached_property[_T]: ...
    @overload
    def __get__(self, instance: object, cls: type[Any] = ...) -> _T: ...

class Promise: ...

class StrPromise(Promise, str):
    """
    This type is not available at runtime, and it's used when you need to mark
    something explicitly as lazy string.

    It's actually a Promise, but behaves mostly like str.
    """

_C = TypeVar("_C", bound=Callable[..., Any])
_CS = TypeVar("_CS", bound=Callable[..., str])

def lazy(func: _C, *resultclasses: Any) -> _C: ...
def lazystr(text: Any) -> StrPromise: ...
def keep_lazy(*resultclasses: Any) -> Callable[..., Any]: ...
def keep_lazy_text(func: _CS) -> _CS: ...

empty: object

def new_method_proxy(func: Callable[..., _T]) -> Callable[..., _T]: ...

class LazyObject:
    def __init__(self) -> None: ...
    __getattr__: Callable[..., Any] = ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def __delattr__(self, name: str) -> None: ...
    def __reduce__(self) -> tuple[Callable[..., Any], tuple[Model]]: ...
    def __copy__(self) -> LazyObject: ...
    __bytes__: Callable[..., Any] = ...
    __bool__: Callable[..., Any] = ...
    __dir__: Callable[..., Any] = ...
    __class__: Any = ...
    __ne__: Callable[..., Any] = ...
    __hash__: Callable[..., Any] = ...
    __getitem__: Callable[..., Any] = ...
    __setitem__: Callable[..., Any] = ...
    __delitem__: Callable[..., Any] = ...
    __iter__: Callable[..., Any] = ...
    __len__: Callable[..., Any] = ...
    __contains__: Callable[..., Any] = ...

def unpickle_lazyobject(wrapped: Model) -> Model: ...

class SimpleLazyObject(LazyObject):
    def __init__(self, func: Callable[[], Any]) -> None: ...
    def __copy__(self) -> SimpleLazyObject: ...

_PartitionMember = TypeVar("_PartitionMember")

def partition(
    predicate: Callable[[_PartitionMember], int | bool], values: list[_PartitionMember]
) -> tuple[list[_PartitionMember], list[_PartitionMember]]: ...

_Get = TypeVar("_Get", covariant=True)
_Self = TypeVar("_Self")

class classproperty(Generic[_Get]):
    fget: Callable[..., _Get] | None = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, method: Callable[[_Self], _Get]) -> None: ...
    def __get__(self, instance: _Self | None, cls: type[_Self] = ...) -> _Get: ...
    def getter(self, method: Callable[[_Self], _Get]) -> classproperty[_Get]: ...

class _Getter(Protocol[_Get]):
    """Type fake to declare some read-only properties (until `property` builtin is generic)

    We can use something like `Union[_Getter[str], str]` in base class to avoid errors
    when redefining attribute with property or property with attribute.
    """

    @overload
    def __get__(self: _Self, __instance: None, __typeobj: type[Any] | None) -> _Self: ...
    @overload
    def __get__(self, __instance: Any, __typeobj: type[Any] | None) -> _Get: ...
