from collections.abc import Callable
from typing import Any

from django.urls.converters import UUIDConverter
from django.utils.datastructures import MultiValueDict

class ResolverMatch:
    func: Callable[..., Any] = ...
    args: tuple[Any, ...] = ...
    kwargs: dict[str, Any] = ...
    url_name: str | None = ...
    app_names: list[str] = ...
    app_name: str = ...
    namespaces: list[str] = ...
    namespace: str = ...
    view_name: str = ...
    route: str = ...
    def __init__(
        self,
        func: Callable[..., Any],
        args: tuple[Any, ...],
        kwargs: dict[str, Any],
        url_name: str | None = ...,
        app_names: list[str | None] | None = ...,
        namespaces: list[str | None] | None = ...,
        route: str | None = ...,
    ) -> None: ...
    def __getitem__(self, index: int) -> Any: ...
    # for tuple unpacking
    def __iter__(self) -> Any: ...

def get_resolver(urlconf: str | None = ...) -> URLResolver: ...
def get_ns_resolver(
    ns_pattern: str, resolver: URLResolver, converters: tuple[Any, ...]
) -> URLResolver: ...

class LocaleRegexDescriptor:
    attr: str = ...
    def __init__(self, attr: Any) -> None: ...
    def __get__(
        self, instance: RegexPattern | None, cls: type[RegexPattern] = ...
    ) -> LocaleRegexDescriptor: ...

class CheckURLMixin:
    def describe(self) -> str: ...

class RegexPattern(CheckURLMixin):
    regex: Any = ...
    name: str | None = ...
    converters: dict[Any, Any] = ...
    def __init__(
        self, regex: str, name: str | None = ..., is_endpoint: bool = ...
    ) -> None: ...
    def match(
        self, path: str
    ) -> tuple[str, tuple[Any, ...], dict[str, str]] | None: ...
    def check(self) -> list[Warning]: ...

class RoutePattern(CheckURLMixin):
    regex: Any = ...
    name: str | None = ...
    converters: dict[str, UUIDConverter] = ...
    def __init__(
        self, route: str, name: str | None = ..., is_endpoint: bool = ...
    ) -> None: ...
    def match(
        self, path: str
    ) -> tuple[str, tuple[Any, ...], dict[str, int | str]] | None: ...
    def check(self) -> list[Warning]: ...

class LocalePrefixPattern:
    prefix_default_language: bool = ...
    converters: dict[Any, Any] = ...
    def __init__(self, prefix_default_language: bool = ...) -> None: ...
    @property
    def regex(self) -> Any: ...
    @property
    def language_prefix(self) -> str: ...
    def match(
        self, path: str
    ) -> tuple[str, tuple[Any, ...], dict[str, Any]] | None: ...
    def check(self) -> list[Any]: ...
    def describe(self) -> str: ...

class URLPattern:
    lookup_str: str
    pattern: Any = ...
    callback: Callable[..., Any] = ...
    default_args: dict[str, str] | None = ...
    name: str | None = ...
    def __init__(
        self,
        pattern: Any,
        callback: Callable[..., Any],
        default_args: dict[str, str] | None = ...,
        name: str | None = ...,
    ) -> None: ...
    def check(self) -> list[Warning]: ...
    def resolve(self, path: str) -> ResolverMatch | None: ...

class URLResolver:
    url_patterns: list[tuple[str, Callable[..., Any]]]
    urlconf_module: list[tuple[str, Callable[..., Any]]] | None
    pattern: Any = ...
    urlconf_name: str | None = ...
    callback: None = ...
    default_kwargs: dict[str, Any] = ...
    namespace: str | None = ...
    app_name: str | None = ...
    _local: Any
    _reverse_dict: MultiValueDict[Any, Any]
    def __init__(
        self,
        pattern: Any,
        urlconf_name: str | None,
        default_kwargs: dict[str, Any] | None = ...,
        app_name: str | None = ...,
        namespace: str | None = ...,
    ) -> None: ...
    @property
    def reverse_dict(self) -> MultiValueDict[Any, Any]: ...
    @property
    def namespace_dict(self) -> dict[str, tuple[str, URLResolver]]: ...
    @property
    def app_dict(self) -> dict[str, list[str]]: ...
    def resolve(self, path: str) -> ResolverMatch: ...
    def resolve_error_handler(
        self, view_type: int
    ) -> tuple[Callable[..., Any], dict[str, Any]]: ...
    def reverse(self, lookup_view: str, *args: Any, **kwargs: Any) -> str: ...
    def _is_callback(self, name: str) -> bool: ...
    def _populate(self) -> None: ...
