from collections.abc import Sequence
from typing import Any

from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.backends.ddl_references import Statement
from django.db.models.base import Model
from django.db.models.expressions import BaseExpression, Combinable
from django.db.models.query_utils import Q

class Index:
    model: type[Model]
    suffix: str = ...
    max_name_length: int = ...
    fields: Sequence[str] = ...
    fields_orders: Sequence[tuple[str, str]] = ...
    name: str = ...
    db_tablespace: str | None = ...
    opclasses: Sequence[str] = ...
    condition: Q | None = ...
    expressions: Sequence[BaseExpression | Combinable] = ...

    def __init__(
        self,
        *expressions: BaseExpression | Combinable | str,
        fields: Sequence[str] = ...,
        name: str | None = ...,
        db_tablespace: str | None = ...,
        opclasses: Sequence[str] = ...,
        condition: Q | None = ...,
        include: str | Sequence[str] | None = ...,
    ) -> None: ...
    @property
    def contains_expressions(self) -> bool: ...
    def check_name(self) -> list[str]: ...
    def create_sql(
        self,
        model: type[Model],
        schema_editor: BaseDatabaseSchemaEditor,
        using: str = ...,
    ) -> Statement: ...
    def remove_sql(
        self, model: type[Model], schema_editor: BaseDatabaseSchemaEditor
    ) -> str: ...
    def deconstruct(self) -> Any: ...
    def clone(self) -> Index: ...
    def set_name_with_model(self, model: type[Model]) -> None: ...
