from collections.abc import Iterable, Iterator, Mapping
from typing import Any, Literal, overload

from django.core.checks.messages import CheckMessage
from django.core.files.storage import Storage

searched_locations: Any

class BaseFinder:
    def check(self, **kwargs: Any) -> list[CheckMessage]: ...
    def find(self, path: str, all: bool = ...) -> Any | None: ...
    def list(self, ignore_patterns: Any) -> Iterable[Any]: ...

class FileSystemFinder(BaseFinder):
    locations: list[Any] = ...
    storages: Mapping[str, Any] = ...
    def __init__(self, app_names: None = ..., *args: Any, **kwargs: Any) -> None: ...
    def find_location(self, root: str, path: str, prefix: str = ...) -> str | None: ...

class AppDirectoriesFinder(BaseFinder):
    storage_class: Any = ...
    source_dir: str = ...
    apps: list[str] = ...
    storages: Mapping[str, Any] = ...
    def __init__(self, app_names: None = ..., *args: Any, **kwargs: Any) -> None: ...
    def find_in_app(self, app: str, path: str) -> str | None: ...

class BaseStorageFinder(BaseFinder):
    storage: Storage = ...
    def __init__(
        self, storage: Storage | None = ..., *args: Any, **kwargs: Any
    ) -> None: ...

class DefaultStorageFinder(BaseStorageFinder): ...

def find(path: str, all: bool = ...) -> list[str] | str | None: ...
def get_finders() -> Iterator[BaseFinder]: ...
@overload
def get_finder(
    import_path: Literal["django.contrib.staticfiles.finders.FileSystemFinder"],
) -> FileSystemFinder: ...
@overload
def get_finder(
    import_path: Literal["django.contrib.staticfiles.finders.AppDirectoriesFinder"],
) -> AppDirectoriesFinder: ...
@overload
def get_finder(import_path: str) -> BaseFinder: ...
