"""
This type stub file was generated by pyright.
"""

import ast
import collections
import operator
from typing import Any, Callable, Dict, Literal, NamedTuple, Set, TYPE_CHECKING, Tuple, Type, Union
from dataclasses import dataclass
from IPython.utils.decorators import undoc
from typing_extensions import Protocol

if TYPE_CHECKING or GENERATING_DOCUMENTATION:
    ...
else:
    ...
@undoc
class HasGetItem(Protocol):
    def __getitem__(self, key) -> None:
        ...
    


@undoc
class InstancesHaveGetItem(Protocol):
    def __call__(self, *args, **kwargs) -> HasGetItem:
        ...
    


@undoc
class HasGetAttr(Protocol):
    def __getattr__(self, key) -> None:
        ...
    


@undoc
class DoesNotHaveGetAttr(Protocol):
    ...


MayHaveGetattr = ...
@undoc
@dataclass
class EvaluationPolicy:
    """Definition of evaluation policy."""
    allow_locals_access: bool = ...
    allow_globals_access: bool = ...
    allow_item_access: bool = ...
    allow_attr_access: bool = ...
    allow_builtins_access: bool = ...
    allow_all_operations: bool = ...
    allow_any_calls: bool = ...
    allowed_calls: Set[Callable] = ...
    def can_get_item(self, value, item):
        ...
    
    def can_get_attr(self, value, attr):
        ...
    
    def can_operate(self, dunders: Tuple[str, ...], a, b=...): # -> None:
        ...
    
    def can_call(self, func): # -> None:
        ...
    


@undoc
@dataclass
class SelectivePolicy(EvaluationPolicy):
    allowed_getitem: Set[InstancesHaveGetItem] = ...
    allowed_getitem_external: Set[Tuple[str, ...]] = ...
    allowed_getattr: Set[MayHaveGetattr] = ...
    allowed_getattr_external: Set[Tuple[str, ...]] = ...
    allowed_operations: Set = ...
    allowed_operations_external: Set[Tuple[str, ...]] = ...
    _operation_methods_cache: Dict[str, Set[Callable]] = ...
    def can_get_attr(self, value, attr):
        ...
    
    def can_get_item(self, value, item): # -> None:
        """Allow accessing `__getiitem__` of allow-listed instances unless it was not modified."""
        ...
    
    def can_operate(self, dunders: Tuple[str, ...], a, b=...):
        ...
    


class _DummyNamedTuple(NamedTuple):
    """Used internally to retrieve methods of named tuple instance."""
    ...


class EvaluationContext(NamedTuple):
    locals: dict
    globals: dict
    evaluation: Literal["forbidden", "minimal", "limited", "unsafe", "dangerous"] = ...
    in_subscript: bool = ...


class _IdentitySubscript:
    """Returns the key itself when item is requested via subscript."""
    def __getitem__(self, key):
        ...
    


IDENTITY_SUBSCRIPT = ...
SUBSCRIPT_MARKER = ...
class GuardRejection(Exception):
    """Exception raised when guard rejects evaluation attempt."""
    ...


def guarded_eval(code: str, context: EvaluationContext): # -> None:
    """Evaluate provided code in the evaluation context.

    If evaluation policy given by context is set to ``forbidden``
    no evaluation will be performed; if it is set to ``dangerous``
    standard :func:`eval` will be used; finally, for any other,
    policy :func:`eval_node` will be called on parsed AST.
    """
    ...

BINARY_OP_DUNDERS: Dict[Type[ast.operator], Tuple[str]] = ...
COMP_OP_DUNDERS: Dict[Type[ast.cmpop], Tuple[str, ...]] = ...
UNARY_OP_DUNDERS: Dict[Type[ast.unaryop], Tuple[str, ...]] = ...
def eval_node(node: Union[ast.AST, None], context: EvaluationContext): # -> None:
    """Evaluate AST node in provided context.

    Applies evaluation restrictions defined in the context. Currently does not support evaluation of functions with keyword arguments.

    Does not evaluate actions that always have side effects:

    - class definitions (``class sth: ...``)
    - function definitions (``def sth: ...``)
    - variable assignments (``x = 1``)
    - augmented assignments (``x += 1``)
    - deletions (``del x``)

    Does not evaluate operations which do not return values:

    - assertions (``assert x``)
    - pass (``pass``)
    - imports (``import x``)
    - control flow:

        - conditionals (``if x:``) except for ternary IfExp (``a if x else b``)
        - loops (``for`` and `while``)
        - exception handling

    The purpose of this function is to guard against unwanted side-effects;
    it does not give guarantees on protection from malicious code execution.
    """
    ...

SUPPORTED_EXTERNAL_GETITEM = ...
BUILTIN_GETITEM: Set[InstancesHaveGetItem] = ...
dict_non_mutating_methods = ...
list_non_mutating_methods = ...
set_non_mutating_methods = ...
dict_keys: Type[collections.abc.KeysView] = ...
method_descriptor: Any = ...
module = ...
NUMERICS = ...
ALLOWED_CALLS = ...
BUILTIN_GETATTR: Set[MayHaveGetattr] = ...
BUILTIN_OPERATIONS = ...
EVALUATION_POLICIES = ...
__all__ = ["guarded_eval", "eval_node", "GuardRejection", "EvaluationContext", "_unbind_method"]
