# Python: 3.11.9 (tags/v3.11.9:de54cf5, Apr  2 2024, 10:12:12) [MSC v.1938 64 bit (AMD64)]
# Library: numpy, version: 1.26.4
# Module: numpy.core._multiarray_umath, version: 3.1
import typing
import builtins as _mod_builtins
import numpy as _mod_numpy
import numpy.core.multiarray as _mod_numpy_core_multiarray

ALLOW_THREADS: int
BUFSIZE: int
CLIP: int
DATETIMEUNITS: PyCapsule
ERR_CALL: int
ERR_DEFAULT: int
ERR_IGNORE: int
ERR_LOG: int
ERR_PRINT: int
ERR_RAISE: int
ERR_WARN: int
FLOATING_POINT_SUPPORT: int
FPE_DIVIDEBYZERO: int
FPE_INVALID: int
FPE_OVERFLOW: int
FPE_UNDERFLOW: int
ITEM_HASOBJECT: int
ITEM_IS_POINTER: int
LIST_PICKLE: int
MAXDIMS: int
MAY_SHARE_BOUNDS: int
MAY_SHARE_EXACT: int
NAN: float
NEEDS_INIT: int
NEEDS_PYAPI: int
NINF: float
NZERO: float
PINF: float
PZERO: float
RAISE: int
SHIFT_DIVIDEBYZERO: int
SHIFT_INVALID: int
SHIFT_OVERFLOW: int
SHIFT_UNDERFLOW: int
UFUNC_BUFSIZE_DEFAULT: int
UFUNC_PYVALS_NAME: str
USE_GETITEM: int
USE_SETITEM: int
WRAP: int
_ARRAY_API: PyCapsule
_ArrayFunctionDispatcher = _mod_numpy._ArrayFunctionDispatcher
_UFUNC_API: PyCapsule
__cpu_baseline__: list
__cpu_dispatch__: list
__cpu_features__: dict
__doc__: typing.Any
__file__: str
__name__: str
__package__: str
__version__: str
def _add_newdoc_ufunc(ufunc, new_docstring) -> typing.Any:
    'add_ufunc_docstring(ufunc, new_docstring)\n\n    Replace the docstring for a ufunc with new_docstring.\n    This method will only work if the current docstring for\n    the ufunc is NULL. (At the C level, i.e. when ufunc->doc is NULL.)\n\n    Parameters\n    ----------\n    ufunc : numpy.ufunc\n        A ufunc whose current doc is NULL.\n    new_docstring : string\n        The new docstring for the ufunc.\n\n    Notes\n    -----\n    This method allocates memory for new_docstring on\n    the heap. Technically this creates a mempory leak, since this\n    memory will not be reclaimed until the end of the program\n    even if the ufunc itself is removed. However this will only\n    be a problem if the user is repeatedly creating ufuncs with\n    no documentation, adding documentation via add_newdoc_ufunc,\n    and then throwing away the ufunc.'
    ...

def _arg(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'DO NOT USE, ONLY FOR TESTING'
    ...

def _discover_array_parameters() -> typing.Any:
    ...

_flagdict: dict
def _get_castingimpl() -> typing.Any:
    ...

def _get_experimental_dtype_api() -> typing.Any:
    ...

def _get_implementing_args() -> typing.Any:
    '\n    Collect arguments on which to call __array_function__.\n\n    Parameters\n    ----------\n    relevant_args : iterable of array-like\n        Iterable of possibly array-like arguments to check for\n        __array_function__ methods.\n\n    Returns\n    -------\n    Sequence of arguments with __array_function__ methods, in the order in\n    which they should be called.\n    '
    ...

def _get_madvise_hugepage() -> bool:
    '    Get use of ``madvise (2)`` MADV_HUGEPAGE support when\n    allocating the array data. Returns the currently set value.\n    See `global_state` for more information.'
    ...

def _get_ndarray_c_version() -> typing.Any:
    '    Return the compile time NPY_VERSION (formerly called NDARRAY_VERSION) number.'
    ...

def _get_promotion_state() -> typing.Any:
    'Get the current NEP 50 promotion state.'
    ...

def _get_sfloat_dtype() -> typing.Any:
    ...

def _load_from_filelike() -> typing.Any:
    ...

def _monotonicity() -> typing.Any:
    ...

def _ones_like(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'This function used to be the numpy.ones_like, but now a specific\nfunction for that has been written for consistency with the other\n*_like functions. It is only used internally in a limited fashion now.\n\nSee Also\n--------\nones_like'
    ...

def _place() -> typing.Any:
    'Insert vals sequentially into equivalent 1-d positions indicated by mask.'
    ...

def _reconstruct(subtype, shape, dtype) -> typing.Any:
    '    Construct an empty array. Used by Pickles.'
    ...

def _reload_guard() -> typing.Any:
    'Give a warning on reload and big warning in sub-interpreters.'
    ...

def _set_madvise_hugepage(enabled) -> bool:
    '    Set  or unset use of ``madvise (2)`` MADV_HUGEPAGE support when\n    allocating the array data. Returns the previously set value.\n    See `global_state` for more information.'
    ...

def _set_numpy_warn_if_no_mem_policy() -> typing.Any:
    'Change the warn if no mem policy flag for testing.'
    ...

def _set_promotion_state() -> typing.Any:
    'Set the NEP 50 promotion state.  This is not thread-safe.\nThe optional warnings can be safely silenced using the \n`np._no_nep50_warning()` context manager.'
    ...

def _using_numpy2_behavior() -> typing.Any:
    ...

def _vec_string() -> typing.Any:
    ...

def absolute(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Calculate the absolute value element-wise.\n\n``np.abs`` is a shorthand for this function.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nabsolute : ndarray\n    An ndarray containing the absolute value of\n    each element in `x`.  For complex input, ``a + ib``, the\n    absolute value is :math:`\\sqrt{ a^2 + b^2 }`.\n    This is a scalar if `x` is a scalar.\n\nExamples\n--------\n>>> x = np.array([-1.2, 1.2])\n>>> np.absolute(x)\narray([ 1.2,  1.2])\n>>> np.absolute(1.2 + 1j)\n1.5620499351813308\n\nPlot the function over ``[-10, 10]``:\n\n>>> import matplotlib.pyplot as plt\n\n>>> x = np.linspace(start=-10, stop=10, num=101)\n>>> plt.plot(x, np.absolute(x))\n>>> plt.show()\n\nPlot the function over the complex plane:\n\n>>> xx = x + 1j * x[:, np.newaxis]\n>>> plt.imshow(np.abs(xx), extent=[-10, 10, -10, 10], cmap='gray')\n>>> plt.show()\n\nThe `abs` function can be used as a shorthand for ``np.absolute`` on\nndarrays.\n\n>>> x = np.array([-1.2, 1.2])\n>>> abs(x)\narray([1.2, 1.2])"
    ...

def add(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Add arguments element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    The arrays to be added.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nadd : ndarray or scalar\n    The sum of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nNotes\n-----\nEquivalent to `x1` + `x2` in terms of array broadcasting.\n\nExamples\n--------\n>>> np.add(1.0, 4.0)\n5.0\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> np.add(x1, x2)\narray([[  0.,   2.,   4.],\n       [  3.,   5.,   7.],\n       [  6.,   8.,  10.]])\n\nThe ``+`` operator can be used as a shorthand for ``np.add`` on ndarrays.\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> x1 + x2\narray([[ 0.,  2.,  4.],\n       [ 3.,  5.,  7.],\n       [ 6.,  8., 10.]])'
    ...

def add_docstring(obj, docstring) -> typing.Any:
    '    Add a docstring to a built-in obj if possible.\n    If the obj already has a docstring raise a RuntimeError\n    If this routine does not know how to add a docstring to the object\n    raise a TypeError'
    ...

def arange(start=..., stop=..., step=..., dtype=..., *, like=...) -> typing.Any:
    '    Return evenly spaced values within a given interval.\n\n    ``arange`` can be called with a varying number of positional arguments:\n\n    * ``arange(stop)``: Values are generated within the half-open interval\n      ``[0, stop)`` (in other words, the interval including `start` but\n      excluding `stop`).\n    * ``arange(start, stop)``: Values are generated within the half-open\n      interval ``[start, stop)``.\n    * ``arange(start, stop, step)`` Values are generated within the half-open\n      interval ``[start, stop)``, with spacing between values given by\n      ``step``.\n\n    For integer arguments the function is roughly equivalent to the Python\n    built-in :py:class:`range`, but returns an ndarray rather than a ``range``\n    instance.\n\n    When using a non-integer step, such as 0.1, it is often better to use\n    `numpy.linspace`.\n\n    See the Warning sections below for more information.\n\n    Parameters\n    ----------\n    start : integer or real, optional\n        Start of interval.  The interval includes this value.  The default\n        start value is 0.\n    stop : integer or real\n        End of interval.  The interval does not include this value, except\n        in some cases where `step` is not an integer and floating point\n        round-off affects the length of `out`.\n    step : integer or real, optional\n        Spacing between values.  For any output `out`, this is the distance\n        between two adjacent values, ``out[i+1] - out[i]``.  The default\n        step size is 1.  If `step` is specified as a position argument,\n        `start` must also be given.\n    dtype : dtype, optional\n        The type of the output array.  If `dtype` is not given, infer the data\n        type from the other input arguments.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    arange : ndarray\n        Array of evenly spaced values.\n\n        For floating point arguments, the length of the result is\n        ``ceil((stop - start)/step)``.  Because of floating point overflow,\n        this rule may result in the last element of `out` being greater\n        than `stop`.\n\n    Warnings\n    --------\n    The length of the output might not be numerically stable.\n\n    Another stability issue is due to the internal implementation of\n    `numpy.arange`.\n    The actual step value used to populate the array is\n    ``dtype(start + step) - dtype(start)`` and not `step`. Precision loss\n    can occur here, due to casting or due to using floating points when\n    `start` is much larger than `step`. This can lead to unexpected\n    behaviour. For example::\n\n      >>> np.arange(0, 5, 0.5, dtype=int)\n      array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0])\n      >>> np.arange(-3, 3, 0.5, dtype=int)\n      array([-3, -2, -1,  0,  1,  2,  3,  4,  5,  6,  7,  8])\n\n    In such cases, the use of `numpy.linspace` should be preferred.\n\n    The built-in :py:class:`range` generates :std:doc:`Python built-in integers\n    that have arbitrary size <python:c-api/long>`, while `numpy.arange`\n    produces `numpy.int32` or `numpy.int64` numbers. This may result in\n    incorrect results for large integer values::\n\n      >>> power = 40\n      >>> modulo = 10000\n      >>> x1 = [(n ** power) % modulo for n in range(8)]\n      >>> x2 = [(n ** power) % modulo for n in np.arange(8)]\n      >>> print(x1)\n      [0, 1, 7776, 8801, 6176, 625, 6576, 4001]  # correct\n      >>> print(x2)\n      [0, 1, 7776, 7185, 0, 5969, 4816, 3361]  # incorrect\n\n    See Also\n    --------\n    numpy.linspace : Evenly spaced numbers with careful handling of endpoints.\n    numpy.ogrid: Arrays of evenly spaced numbers in N-dimensions.\n    numpy.mgrid: Grid-shaped arrays of evenly spaced numbers in N-dimensions.\n    :ref:`how-to-partition`\n\n    Examples\n    --------\n    >>> np.arange(3)\n    array([0, 1, 2])\n    >>> np.arange(3.0)\n    array([ 0.,  1.,  2.])\n    >>> np.arange(3,7)\n    array([3, 4, 5, 6])\n    >>> np.arange(3,7,2)\n    array([3, 5])'
    ...

def arccos(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Trigonometric inverse cosine, element-wise.\n\nThe inverse of `cos` so that, if ``y = cos(x)``, then ``x = arccos(y)``.\n\nParameters\n----------\nx : array_like\n    `x`-coordinate on the unit circle.\n    For real arguments, the domain is [-1, 1].\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nangle : ndarray\n    The angle of the ray intersecting the unit circle at the given\n    `x`-coordinate in radians [0, pi].\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\ncos, arctan, arcsin, emath.arccos\n\nNotes\n-----\n`arccos` is a multivalued function: for each `x` there are infinitely\nmany numbers `z` such that ``cos(z) = x``. The convention is to return\nthe angle `z` whose real part lies in `[0, pi]`.\n\nFor real-valued input data types, `arccos` always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `arccos` is a complex analytic function that\nhas branch cuts ``[-inf, -1]`` and `[1, inf]` and is continuous from\nabove on the former and from below on the latter.\n\nThe inverse `cos` is also known as `acos` or cos^-1.\n\nReferences\n----------\nM. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n10th printing, 1964, pp. 79.\nhttps://personal.math.ubc.ca/~cbm/aands/page_79.htm\n\nExamples\n--------\nWe expect the arccos of 1 to be 0, and of -1 to be pi:\n\n>>> np.arccos([1, -1])\narray([ 0.        ,  3.14159265])\n\nPlot arccos:\n\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-1, 1, num=100)\n>>> plt.plot(x, np.arccos(x))\n>>> plt.axis(\'tight\')\n>>> plt.show()'
    ...

def arccosh(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Inverse hyperbolic cosine, element-wise.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\narccosh : ndarray\n    Array of the same shape as `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\n\ncosh, arcsinh, sinh, arctanh, tanh\n\nNotes\n-----\n`arccosh` is a multivalued function: for each `x` there are infinitely\nmany numbers `z` such that `cosh(z) = x`. The convention is to return the\n`z` whose imaginary part lies in ``[-pi, pi]`` and the real part in\n``[0, inf]``.\n\nFor real-valued input data types, `arccosh` always returns real output.\nFor each value that cannot be expressed as a real number or infinity, it\nyields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `arccosh` is a complex analytical function that\nhas a branch cut `[-inf, 1]` and is continuous from above on it.\n\nReferences\n----------\n.. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n       10th printing, 1964, pp. 86.\n       https://personal.math.ubc.ca/~cbm/aands/page_86.htm\n.. [2] Wikipedia, "Inverse hyperbolic function",\n       https://en.wikipedia.org/wiki/Arccosh\n\nExamples\n--------\n>>> np.arccosh([np.e, 10.0])\narray([ 1.65745445,  2.99322285])\n>>> np.arccosh(1)\n0.0'
    ...

def arcsin(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Inverse sine, element-wise.\n\nParameters\n----------\nx : array_like\n    `y`-coordinate on the unit circle.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nangle : ndarray\n    The inverse sine of each element in `x`, in radians and in the\n    closed interval ``[-pi/2, pi/2]``.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nsin, cos, arccos, tan, arctan, arctan2, emath.arcsin\n\nNotes\n-----\n`arcsin` is a multivalued function: for each `x` there are infinitely\nmany numbers `z` such that :math:`sin(z) = x`.  The convention is to\nreturn the angle `z` whose real part lies in [-pi/2, pi/2].\n\nFor real-valued input data types, *arcsin* always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `arcsin` is a complex analytic function that\nhas, by convention, the branch cuts [-inf, -1] and [1, inf]  and is\ncontinuous from above on the former and from below on the latter.\n\nThe inverse sine is also known as `asin` or sin^{-1}.\n\nReferences\n----------\nAbramowitz, M. and Stegun, I. A., *Handbook of Mathematical Functions*,\n10th printing, New York: Dover, 1964, pp. 79ff.\nhttps://personal.math.ubc.ca/~cbm/aands/page_79.htm\n\nExamples\n--------\n>>> np.arcsin(1)     # pi/2\n1.5707963267948966\n>>> np.arcsin(-1)    # -pi/2\n-1.5707963267948966\n>>> np.arcsin(0)\n0.0'
    ...

def arcsinh(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Inverse hyperbolic sine element-wise.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Array of the same shape as `x`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\n`arcsinh` is a multivalued function: for each `x` there are infinitely\nmany numbers `z` such that `sinh(z) = x`. The convention is to return the\n`z` whose imaginary part lies in `[-pi/2, pi/2]`.\n\nFor real-valued input data types, `arcsinh` always returns real output.\nFor each value that cannot be expressed as a real number or infinity, it\nreturns ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `arccos` is a complex analytical function that\nhas branch cuts `[1j, infj]` and `[-1j, -infj]` and is continuous from\nthe right on the former and from the left on the latter.\n\nThe inverse hyperbolic sine is also known as `asinh` or ``sinh^-1``.\n\nReferences\n----------\n.. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n       10th printing, 1964, pp. 86.\n       https://personal.math.ubc.ca/~cbm/aands/page_86.htm\n.. [2] Wikipedia, "Inverse hyperbolic function",\n       https://en.wikipedia.org/wiki/Arcsinh\n\nExamples\n--------\n>>> np.arcsinh(np.array([np.e, 10.0]))\narray([ 1.72538256,  2.99822295])'
    ...

def arctan(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Trigonometric inverse tangent, element-wise.\n\nThe inverse of tan, so that if ``y = tan(x)`` then ``x = arctan(y)``.\n\nParameters\n----------\nx : array_like\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Out has the same shape as `x`.  Its real part is in\n    ``[-pi/2, pi/2]`` (``arctan(+/-inf)`` returns ``+/-pi/2``).\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\narctan2 : The "four quadrant" arctan of the angle formed by (`x`, `y`)\n    and the positive `x`-axis.\nangle : Argument of complex values.\n\nNotes\n-----\n`arctan` is a multi-valued function: for each `x` there are infinitely\nmany numbers `z` such that tan(`z`) = `x`.  The convention is to return\nthe angle `z` whose real part lies in [-pi/2, pi/2].\n\nFor real-valued input data types, `arctan` always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `arctan` is a complex analytic function that\nhas [``1j, infj``] and [``-1j, -infj``] as branch cuts, and is continuous\nfrom the left on the former and from the right on the latter.\n\nThe inverse tangent is also known as `atan` or tan^{-1}.\n\nReferences\n----------\nAbramowitz, M. and Stegun, I. A., *Handbook of Mathematical Functions*,\n10th printing, New York: Dover, 1964, pp. 79.\nhttps://personal.math.ubc.ca/~cbm/aands/page_79.htm\n\nExamples\n--------\nWe expect the arctan of 0 to be 0, and of 1 to be pi/4:\n\n>>> np.arctan([0, 1])\narray([ 0.        ,  0.78539816])\n\n>>> np.pi/4\n0.78539816339744828\n\nPlot arctan:\n\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-10, 10)\n>>> plt.plot(x, np.arctan(x))\n>>> plt.axis(\'tight\')\n>>> plt.show()'
    ...

def arctan2(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Element-wise arc tangent of ``x1/x2`` choosing the quadrant correctly.\n\nThe quadrant (i.e., branch) is chosen so that ``arctan2(x1, x2)`` is\nthe signed angle in radians between the ray ending at the origin and\npassing through the point (1,0), and the ray ending at the origin and\npassing through the point (`x2`, `x1`).  (Note the role reversal: the\n"`y`-coordinate" is the first function parameter, the "`x`-coordinate"\nis the second.)  By IEEE convention, this function is defined for\n`x2` = +/-0 and for either or both of `x1` and `x2` = +/-inf (see\nNotes for specific values).\n\nThis function is not defined for complex-valued arguments; for the\nso-called argument of complex values, use `angle`.\n\nParameters\n----------\nx1 : array_like, real-valued\n    `y`-coordinates.\nx2 : array_like, real-valued\n    `x`-coordinates.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nangle : ndarray\n    Array of angles in radians, in the range ``[-pi, pi]``.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\narctan, tan, angle\n\nNotes\n-----\n*arctan2* is identical to the `atan2` function of the underlying\nC library.  The following special values are defined in the C\nstandard: [1]_\n\n====== ====== ================\n`x1`   `x2`   `arctan2(x1,x2)`\n====== ====== ================\n+/- 0  +0     +/- 0\n+/- 0  -0     +/- pi\n > 0   +/-inf +0 / +pi\n < 0   +/-inf -0 / -pi\n+/-inf +inf   +/- (pi/4)\n+/-inf -inf   +/- (3*pi/4)\n====== ====== ================\n\nNote that +0 and -0 are distinct floating point numbers, as are +inf\nand -inf.\n\nReferences\n----------\n.. [1] ISO/IEC standard 9899:1999, "Programming language C."\n\nExamples\n--------\nConsider four points in different quadrants:\n\n>>> x = np.array([-1, +1, +1, -1])\n>>> y = np.array([-1, -1, +1, +1])\n>>> np.arctan2(y, x) * 180 / np.pi\narray([-135.,  -45.,   45.,  135.])\n\nNote the order of the parameters. `arctan2` is defined also when `x2` = 0\nand at several other special points, obtaining values in\nthe range ``[-pi, pi]``:\n\n>>> np.arctan2([1., -1.], [0., 0.])\narray([ 1.57079633, -1.57079633])\n>>> np.arctan2([0., 0., np.inf], [+0., -0., np.inf])\narray([0.        , 3.14159265, 0.78539816])'
    ...

def arctanh(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Inverse hyperbolic tangent element-wise.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Array of the same shape as `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nemath.arctanh\n\nNotes\n-----\n`arctanh` is a multivalued function: for each `x` there are infinitely\nmany numbers `z` such that ``tanh(z) = x``. The convention is to return\nthe `z` whose imaginary part lies in `[-pi/2, pi/2]`.\n\nFor real-valued input data types, `arctanh` always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `arctanh` is a complex analytical function\nthat has branch cuts `[-1, -inf]` and `[1, inf]` and is continuous from\nabove on the former and from below on the latter.\n\nThe inverse hyperbolic tangent is also known as `atanh` or ``tanh^-1``.\n\nReferences\n----------\n.. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n       10th printing, 1964, pp. 86.\n       https://personal.math.ubc.ca/~cbm/aands/page_86.htm\n.. [2] Wikipedia, "Inverse hyperbolic function",\n       https://en.wikipedia.org/wiki/Arctanh\n\nExamples\n--------\n>>> np.arctanh([0, -0.5])\narray([ 0.        , -0.54930614])'
    ...

def array(object, dtype=..., *, copy=..., order=..., subok=..., ndmin=..., like=...) -> typing.Any:
    "    Create an array.\n\n    Parameters\n    ----------\n    object : array_like\n        An array, any object exposing the array interface, an object whose\n        ``__array__`` method returns an array, or any (nested) sequence.\n        If object is a scalar, a 0-dimensional array containing object is\n        returned.\n    dtype : data-type, optional\n        The desired data-type for the array. If not given, NumPy will try to use\n        a default ``dtype`` that can represent the values (by applying promotion\n        rules when necessary.)\n    copy : bool, optional\n        If true (default), then the object is copied.  Otherwise, a copy will\n        only be made if ``__array__`` returns a copy, if obj is a nested\n        sequence, or if a copy is needed to satisfy any of the other\n        requirements (``dtype``, ``order``, etc.).\n    order : {'K', 'A', 'C', 'F'}, optional\n        Specify the memory layout of the array. If object is not an array, the\n        newly created array will be in C order (row major) unless 'F' is\n        specified, in which case it will be in Fortran order (column major).\n        If object is an array the following holds.\n\n        ===== ========= ===================================================\n        order  no copy                     copy=True\n        ===== ========= ===================================================\n        'K'   unchanged F & C order preserved, otherwise most similar order\n        'A'   unchanged F order if input is F and not C, otherwise C order\n        'C'   C order   C order\n        'F'   F order   F order\n        ===== ========= ===================================================\n\n        When ``copy=False`` and a copy is made for other reasons, the result is\n        the same as if ``copy=True``, with some exceptions for 'A', see the\n        Notes section. The default order is 'K'.\n    subok : bool, optional\n        If True, then sub-classes will be passed-through, otherwise\n        the returned array will be forced to be a base-class array (default).\n    ndmin : int, optional\n        Specifies the minimum number of dimensions that the resulting\n        array should have.  Ones will be prepended to the shape as\n        needed to meet this requirement.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        An array object satisfying the specified requirements.\n\n    See Also\n    --------\n    empty_like : Return an empty array with shape and type of input.\n    ones_like : Return an array of ones with shape and type of input.\n    zeros_like : Return an array of zeros with shape and type of input.\n    full_like : Return a new array with shape of input filled with value.\n    empty : Return a new uninitialized array.\n    ones : Return a new array setting values to one.\n    zeros : Return a new array setting values to zero.\n    full : Return a new array of given shape filled with value.\n\n\n    Notes\n    -----\n    When order is 'A' and ``object`` is an array in neither 'C' nor 'F' order,\n    and a copy is forced by a change in dtype, then the order of the result is\n    not necessarily 'C' as expected. This is likely a bug.\n\n    Examples\n    --------\n    >>> np.array([1, 2, 3])\n    array([1, 2, 3])\n\n    Upcasting:\n\n    >>> np.array([1, 2, 3.0])\n    array([ 1.,  2.,  3.])\n\n    More than one dimension:\n\n    >>> np.array([[1, 2], [3, 4]])\n    array([[1, 2],\n           [3, 4]])\n\n    Minimum dimensions 2:\n\n    >>> np.array([1, 2, 3], ndmin=2)\n    array([[1, 2, 3]])\n\n    Type provided:\n\n    >>> np.array([1, 2, 3], dtype=complex)\n    array([ 1.+0.j,  2.+0.j,  3.+0.j])\n\n    Data-type consisting of more than one element:\n\n    >>> x = np.array([(1,2),(3,4)],dtype=[('a','<i4'),('b','<i4')])\n    >>> x['a']\n    array([1, 3])\n\n    Creating an array from sub-classes:\n\n    >>> np.array(np.mat('1 2; 3 4'))\n    array([[1, 2],\n           [3, 4]])\n\n    >>> np.array(np.mat('1 2; 3 4'), subok=True)\n    matrix([[1, 2],\n            [3, 4]])"
    ...

def asanyarray(a, dtype=..., order=..., *, like=...) -> typing.Any:
    "    Convert the input to an ndarray, but pass ndarray subclasses through.\n\n    Parameters\n    ----------\n    a : array_like\n        Input data, in any form that can be converted to an array.  This\n        includes scalars, lists, lists of tuples, tuples, tuples of tuples,\n        tuples of lists, and ndarrays.\n    dtype : data-type, optional\n        By default, the data-type is inferred from the input data.\n    order : {'C', 'F', 'A', 'K'}, optional\n        Memory layout.  'A' and 'K' depend on the order of input array a.\n        'C' row-major (C-style),\n        'F' column-major (Fortran-style) memory representation.\n        'A' (any) means 'F' if `a` is Fortran contiguous, 'C' otherwise\n        'K' (keep) preserve input order\n        Defaults to 'C'.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray or an ndarray subclass\n        Array interpretation of `a`.  If `a` is an ndarray or a subclass\n        of ndarray, it is returned as-is and no copy is performed.\n\n    See Also\n    --------\n    asarray : Similar function which always returns ndarrays.\n    ascontiguousarray : Convert input to a contiguous array.\n    asfarray : Convert input to a floating point ndarray.\n    asfortranarray : Convert input to an ndarray with column-major\n                     memory order.\n    asarray_chkfinite : Similar function which checks input for NaNs and\n                        Infs.\n    fromiter : Create an array from an iterator.\n    fromfunction : Construct an array by executing a function on grid\n                   positions.\n\n    Examples\n    --------\n    Convert a list into an array:\n\n    >>> a = [1, 2]\n    >>> np.asanyarray(a)\n    array([1, 2])\n\n    Instances of `ndarray` subclasses are passed through as-is:\n\n    >>> a = np.array([(1.0, 2), (3.0, 4)], dtype='f4,i4').view(np.recarray)\n    >>> np.asanyarray(a) is a\n    True"
    ...

def asarray(a, dtype=..., order=..., *, like=...) -> typing.Any:
    "    Convert the input to an array.\n\n    Parameters\n    ----------\n    a : array_like\n        Input data, in any form that can be converted to an array.  This\n        includes lists, lists of tuples, tuples, tuples of tuples, tuples\n        of lists and ndarrays.\n    dtype : data-type, optional\n        By default, the data-type is inferred from the input data.\n    order : {'C', 'F', 'A', 'K'}, optional\n        Memory layout.  'A' and 'K' depend on the order of input array a.\n        'C' row-major (C-style),\n        'F' column-major (Fortran-style) memory representation.\n        'A' (any) means 'F' if `a` is Fortran contiguous, 'C' otherwise\n        'K' (keep) preserve input order\n        Defaults to 'K'.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        Array interpretation of `a`.  No copy is performed if the input\n        is already an ndarray with matching dtype and order.  If `a` is a\n        subclass of ndarray, a base class ndarray is returned.\n\n    See Also\n    --------\n    asanyarray : Similar function which passes through subclasses.\n    ascontiguousarray : Convert input to a contiguous array.\n    asfarray : Convert input to a floating point ndarray.\n    asfortranarray : Convert input to an ndarray with column-major\n                     memory order.\n    asarray_chkfinite : Similar function which checks input for NaNs and Infs.\n    fromiter : Create an array from an iterator.\n    fromfunction : Construct an array by executing a function on grid\n                   positions.\n\n    Examples\n    --------\n    Convert a list into an array:\n\n    >>> a = [1, 2]\n    >>> np.asarray(a)\n    array([1, 2])\n\n    Existing arrays are not copied:\n\n    >>> a = np.array([1, 2])\n    >>> np.asarray(a) is a\n    True\n\n    If `dtype` is set, array is copied only if dtype does not match:\n\n    >>> a = np.array([1, 2], dtype=np.float32)\n    >>> np.asarray(a, dtype=np.float32) is a\n    True\n    >>> np.asarray(a, dtype=np.float64) is a\n    False\n\n    Contrary to `asanyarray`, ndarray subclasses are not passed through:\n\n    >>> issubclass(np.recarray, np.ndarray)\n    True\n    >>> a = np.array([(1.0, 2), (3.0, 4)], dtype='f4,i4').view(np.recarray)\n    >>> np.asarray(a) is a\n    False\n    >>> np.asanyarray(a) is a\n    True"
    ...

def ascontiguousarray(a, dtype=..., *, like=...) -> typing.Any:
    "    Return a contiguous array (ndim >= 1) in memory (C order).\n\n    Parameters\n    ----------\n    a : array_like\n        Input array.\n    dtype : str or dtype object, optional\n        Data-type of returned array.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        Contiguous array of same shape and content as `a`, with type `dtype`\n        if specified.\n\n    See Also\n    --------\n    asfortranarray : Convert input to an ndarray with column-major\n                     memory order.\n    require : Return an ndarray that satisfies requirements.\n    ndarray.flags : Information about the memory layout of the array.\n\n    Examples\n    --------\n    Starting with a Fortran-contiguous array:\n\n    >>> x = np.ones((2, 3), order='F')\n    >>> x.flags['F_CONTIGUOUS']\n    True\n\n    Calling ``ascontiguousarray`` makes a C-contiguous copy:\n\n    >>> y = np.ascontiguousarray(x)\n    >>> y.flags['C_CONTIGUOUS']\n    True\n    >>> np.may_share_memory(x, y)\n    False\n\n    Now, starting with a C-contiguous array:\n\n    >>> x = np.ones((2, 3), order='C')\n    >>> x.flags['C_CONTIGUOUS']\n    True\n\n    Then, calling ``ascontiguousarray`` returns the same object:\n\n    >>> y = np.ascontiguousarray(x)\n    >>> x is y\n    True\n\n    Note: This function returns an array with at least one-dimension (1-d)\n    so it will not preserve 0-d arrays."
    ...

def asfortranarray(a, dtype=..., *, like=...) -> typing.Any:
    "    Return an array (ndim >= 1) laid out in Fortran order in memory.\n\n    Parameters\n    ----------\n    a : array_like\n        Input array.\n    dtype : str or dtype object, optional\n        By default, the data-type is inferred from the input data.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        The input `a` in Fortran, or column-major, order.\n\n    See Also\n    --------\n    ascontiguousarray : Convert input to a contiguous (C order) array.\n    asanyarray : Convert input to an ndarray with either row or\n        column-major memory order.\n    require : Return an ndarray that satisfies requirements.\n    ndarray.flags : Information about the memory layout of the array.\n\n    Examples\n    --------\n    Starting with a C-contiguous array:\n\n    >>> x = np.ones((2, 3), order='C')\n    >>> x.flags['C_CONTIGUOUS']\n    True\n\n    Calling ``asfortranarray`` makes a Fortran-contiguous copy:\n\n    >>> y = np.asfortranarray(x)\n    >>> y.flags['F_CONTIGUOUS']\n    True\n    >>> np.may_share_memory(x, y)\n    False\n\n    Now, starting with a Fortran-contiguous array:\n\n    >>> x = np.ones((2, 3), order='F')\n    >>> x.flags['F_CONTIGUOUS']\n    True\n\n    Then, calling ``asfortranarray`` returns the same object:\n\n    >>> y = np.asfortranarray(x)\n    >>> x is y\n    True\n\n    Note: This function returns an array with at least one-dimension (1-d)\n    so it will not preserve 0-d arrays."
    ...

def bincount(x, weights=..., minlength=...) -> typing.Any:
    "    Count number of occurrences of each value in array of non-negative ints.\n\n    The number of bins (of size 1) is one larger than the largest value in\n    `x`. If `minlength` is specified, there will be at least this number\n    of bins in the output array (though it will be longer if necessary,\n    depending on the contents of `x`).\n    Each bin gives the number of occurrences of its index value in `x`.\n    If `weights` is specified the input array is weighted by it, i.e. if a\n    value ``n`` is found at position ``i``, ``out[n] += weight[i]`` instead\n    of ``out[n] += 1``.\n\n    Parameters\n    ----------\n    x : array_like, 1 dimension, nonnegative ints\n        Input array.\n    weights : array_like, optional\n        Weights, array of the same shape as `x`.\n    minlength : int, optional\n        A minimum number of bins for the output array.\n\n        .. versionadded:: 1.6.0\n\n    Returns\n    -------\n    out : ndarray of ints\n        The result of binning the input array.\n        The length of `out` is equal to ``np.amax(x)+1``.\n\n    Raises\n    ------\n    ValueError\n        If the input is not 1-dimensional, or contains elements with negative\n        values, or if `minlength` is negative.\n    TypeError\n        If the type of the input is float or complex.\n\n    See Also\n    --------\n    histogram, digitize, unique\n\n    Examples\n    --------\n    >>> np.bincount(np.arange(5))\n    array([1, 1, 1, 1, 1])\n    >>> np.bincount(np.array([0, 1, 1, 3, 2, 1, 7]))\n    array([1, 3, 1, 1, 0, 0, 0, 1])\n\n    >>> x = np.array([0, 1, 1, 3, 2, 1, 7, 23])\n    >>> np.bincount(x).size == np.amax(x)+1\n    True\n\n    The input array needs to be of integer dtype, otherwise a\n    TypeError is raised:\n\n    >>> np.bincount(np.arange(5, dtype=float))\n    Traceback (most recent call last):\n      ...\n    TypeError: Cannot cast array data from dtype('float64') to dtype('int64')\n    according to the rule 'safe'\n\n    A possible use of ``bincount`` is to perform sums over\n    variable-size chunks of an array, using the ``weights`` keyword.\n\n    >>> w = np.array([0.3, 0.5, 0.2, 0.7, 1., -0.6]) # weights\n    >>> x = np.array([0, 1, 1, 2, 2, 2])\n    >>> np.bincount(x,  weights=w)\n    array([ 0.3,  0.7,  1.1])\n\n    "
    ...

def bitwise_and(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Compute the bit-wise AND of two arrays element-wise.\n\nComputes the bit-wise AND of the underlying binary representation of\nthe integers in the input arrays. This ufunc implements the C/Python\noperator ``&``.\n\nParameters\n----------\nx1, x2 : array_like\n    Only integer and boolean types are handled.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Result.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogical_and\nbitwise_or\nbitwise_xor\nbinary_repr :\n    Return the binary representation of the input number as a string.\n\nExamples\n--------\nThe number 13 is represented by ``00001101``.  Likewise, 17 is\nrepresented by ``00010001``.  The bit-wise AND of 13 and 17 is\ntherefore ``000000001``, or 1:\n\n>>> np.bitwise_and(13, 17)\n1\n\n>>> np.bitwise_and(14, 13)\n12\n>>> np.binary_repr(12)\n'1100'\n>>> np.bitwise_and([14,3], 13)\narray([12,  1])\n\n>>> np.bitwise_and([11,7], [4,25])\narray([0, 1])\n>>> np.bitwise_and(np.array([2,5,255]), np.array([3,14,16]))\narray([ 2,  4, 16])\n>>> np.bitwise_and([True, True], [False, True])\narray([False,  True])\n\nThe ``&`` operator can be used as a shorthand for ``np.bitwise_and`` on\nndarrays.\n\n>>> x1 = np.array([2, 5, 255])\n>>> x2 = np.array([3, 14, 16])\n>>> x1 & x2\narray([ 2,  4, 16])"
    ...

def bitwise_or(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Compute the bit-wise OR of two arrays element-wise.\n\nComputes the bit-wise OR of the underlying binary representation of\nthe integers in the input arrays. This ufunc implements the C/Python\noperator ``|``.\n\nParameters\n----------\nx1, x2 : array_like\n    Only integer and boolean types are handled.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Result.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogical_or\nbitwise_and\nbitwise_xor\nbinary_repr :\n    Return the binary representation of the input number as a string.\n\nExamples\n--------\nThe number 13 has the binary representation ``00001101``. Likewise,\n16 is represented by ``00010000``.  The bit-wise OR of 13 and 16 is\nthen ``00011101``, or 29:\n\n>>> np.bitwise_or(13, 16)\n29\n>>> np.binary_repr(29)\n'11101'\n\n>>> np.bitwise_or(32, 2)\n34\n>>> np.bitwise_or([33, 4], 1)\narray([33,  5])\n>>> np.bitwise_or([33, 4], [1, 2])\narray([33,  6])\n\n>>> np.bitwise_or(np.array([2, 5, 255]), np.array([4, 4, 4]))\narray([  6,   5, 255])\n>>> np.array([2, 5, 255]) | np.array([4, 4, 4])\narray([  6,   5, 255])\n>>> np.bitwise_or(np.array([2, 5, 255, 2147483647], dtype=np.int32),\n...               np.array([4, 4, 4, 2147483647], dtype=np.int32))\narray([         6,          5,        255, 2147483647])\n>>> np.bitwise_or([True, True], [False, True])\narray([ True,  True])\n\nThe ``|`` operator can be used as a shorthand for ``np.bitwise_or`` on\nndarrays.\n\n>>> x1 = np.array([2, 5, 255])\n>>> x2 = np.array([4, 4, 4])\n>>> x1 | x2\narray([  6,   5, 255])"
    ...

def bitwise_xor(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Compute the bit-wise XOR of two arrays element-wise.\n\nComputes the bit-wise XOR of the underlying binary representation of\nthe integers in the input arrays. This ufunc implements the C/Python\noperator ``^``.\n\nParameters\n----------\nx1, x2 : array_like\n    Only integer and boolean types are handled.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Result.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogical_xor\nbitwise_and\nbitwise_or\nbinary_repr :\n    Return the binary representation of the input number as a string.\n\nExamples\n--------\nThe number 13 is represented by ``00001101``. Likewise, 17 is\nrepresented by ``00010001``.  The bit-wise XOR of 13 and 17 is\ntherefore ``00011100``, or 28:\n\n>>> np.bitwise_xor(13, 17)\n28\n>>> np.binary_repr(28)\n'11100'\n\n>>> np.bitwise_xor(31, 5)\n26\n>>> np.bitwise_xor([31,3], 5)\narray([26,  6])\n\n>>> np.bitwise_xor([31,3], [5,6])\narray([26,  5])\n>>> np.bitwise_xor([True, True], [False, True])\narray([ True, False])\n\nThe ``^`` operator can be used as a shorthand for ``np.bitwise_xor`` on\nndarrays.\n\n>>> x1 = np.array([True, True])\n>>> x2 = np.array([False, True])\n>>> x1 ^ x2\narray([ True, False])"
    ...

class broadcast(_mod_builtins.object):
    'Produce an object that mimics broadcasting.\n\n    Parameters\n    ----------\n    in1, in2, ... : array_like\n        Input parameters.\n\n    Returns\n    -------\n    b : broadcast object\n        Broadcast the input parameters against one another, and\n        return an object that encapsulates the result.\n        Amongst others, it has ``shape`` and ``nd`` properties, and\n        may be used as an iterator.\n\n    See Also\n    --------\n    broadcast_arrays\n    broadcast_to\n    broadcast_shapes\n\n    Examples\n    --------\n\n    Manually adding two vectors, using broadcasting:\n\n    >>> x = np.array([[1], [2], [3]])\n    >>> y = np.array([4, 5, 6])\n    >>> b = np.broadcast(x, y)\n\n    >>> out = np.empty(b.shape)\n    >>> out.flat = [u+v for (u,v) in b]\n    >>> out\n    array([[5.,  6.,  7.],\n           [6.,  7.,  8.],\n           [7.,  8.,  9.]])\n\n    Compare against built-in broadcasting:\n\n    >>> x + y\n    array([[5, 6, 7],\n           [6, 7, 8],\n           [7, 8, 9]])'
    def __init__(self, *args, **kwargs) -> None:
        'Produce an object that mimics broadcasting.\n\n    Parameters\n    ----------\n    in1, in2, ... : array_like\n        Input parameters.\n\n    Returns\n    -------\n    b : broadcast object\n        Broadcast the input parameters against one another, and\n        return an object that encapsulates the result.\n        Amongst others, it has ``shape`` and ``nd`` properties, and\n        may be used as an iterator.\n\n    See Also\n    --------\n    broadcast_arrays\n    broadcast_to\n    broadcast_shapes\n\n    Examples\n    --------\n\n    Manually adding two vectors, using broadcasting:\n\n    >>> x = np.array([[1], [2], [3]])\n    >>> y = np.array([4, 5, 6])\n    >>> b = np.broadcast(x, y)\n\n    >>> out = np.empty(b.shape)\n    >>> out.flat = [u+v for (u,v) in b]\n    >>> out\n    array([[5.,  6.,  7.],\n           [6.,  7.,  8.],\n           [7.,  8.,  9.]])\n\n    Compare against built-in broadcasting:\n\n    >>> x + y\n    array([[5, 6, 7],\n           [6, 7, 8],\n           [7, 8, 9]])'
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    def __iter__(self) -> broadcast:
        'Implement iter(self).'
        ...
    
    def __next__(self) -> typing.Any:
        'Implement next(self).'
        ...
    
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    @property
    def index(self) -> typing.Any:
        'current index in broadcasted result\n\n    Examples\n    --------\n    >>> x = np.array([[1], [2], [3]])\n    >>> y = np.array([4, 5, 6])\n    >>> b = np.broadcast(x, y)\n    >>> b.index\n    0\n    >>> next(b), next(b), next(b)\n    ((1, 4), (1, 5), (1, 6))\n    >>> b.index\n    3'
        ...
    
    @property
    def iters(self) -> typing.Any:
        'tuple of iterators along ``self``\'s "components."\n\n    Returns a tuple of `numpy.flatiter` objects, one for each "component"\n    of ``self``.\n\n    See Also\n    --------\n    numpy.flatiter\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> row, col = b.iters\n    >>> next(row), next(col)\n    (1, 4)'
        ...
    
    @property
    def nd(self) -> typing.Any:
        'Number of dimensions of broadcasted result. For code intended for NumPy\n    1.12.0 and later the more consistent `ndim` is preferred.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> b.nd\n    2'
        ...
    
    @property
    def ndim(self) -> typing.Any:
        'Number of dimensions of broadcasted result. Alias for `nd`.\n\n    .. versionadded:: 1.12.0\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> b.ndim\n    2'
        ...
    
    @property
    def numiter(self) -> typing.Any:
        'Number of iterators possessed by the broadcasted result.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> b.numiter\n    2'
        ...
    
    def reset(self) -> typing.Any:
        "    Reset the broadcasted result's iterator(s).\n\n    Parameters\n    ----------\n    None\n\n    Returns\n    -------\n    None\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> b.index\n    0\n    >>> next(b), next(b), next(b)\n    ((1, 4), (2, 4), (3, 4))\n    >>> b.index\n    3\n    >>> b.reset()\n    >>> b.index\n    0"
        ...
    
    @property
    def shape(self) -> typing.Any:
        'Shape of broadcasted result.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> b.shape\n    (3, 3)'
        ...
    
    @property
    def size(self) -> typing.Any:
        'Total size of broadcasted result.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> y = np.array([[4], [5], [6]])\n    >>> b = np.broadcast(x, y)\n    >>> b.size\n    9'
        ...
    
    def __getattr__(self, name) -> typing.Any:
        ...
    

def busday_count(begindates, enddates, weekmask=..., holidays=..., busdaycal=..., out=...) -> typing.Any:
    '    Counts the number of valid days between `begindates` and\n    `enddates`, not including the day of `enddates`.\n\n    If ``enddates`` specifies a date value that is earlier than the\n    corresponding ``begindates`` date value, the count will be negative.\n\n    .. versionadded:: 1.7.0\n\n    Parameters\n    ----------\n    begindates : array_like of datetime64[D]\n        The array of the first dates for counting.\n    enddates : array_like of datetime64[D]\n        The array of the end dates for counting, which are excluded\n        from the count themselves.\n    weekmask : str or array_like of bool, optional\n        A seven-element array indicating which of Monday through Sunday are\n        valid days. May be specified as a length-seven list or array, like\n        [1,1,1,1,1,0,0]; a length-seven string, like \'1111100\'; or a string\n        like "Mon Tue Wed Thu Fri", made up of 3-character abbreviations for\n        weekdays, optionally separated by white space. Valid abbreviations\n        are: Mon Tue Wed Thu Fri Sat Sun\n    holidays : array_like of datetime64[D], optional\n        An array of dates to consider as invalid dates.  They may be\n        specified in any order, and NaT (not-a-time) dates are ignored.\n        This list is saved in a normalized form that is suited for\n        fast calculations of valid days.\n    busdaycal : busdaycalendar, optional\n        A `busdaycalendar` object which specifies the valid days. If this\n        parameter is provided, neither weekmask nor holidays may be\n        provided.\n    out : array of int, optional\n        If provided, this array is filled with the result.\n\n    Returns\n    -------\n    out : array of int\n        An array with a shape from broadcasting ``begindates`` and ``enddates``\n        together, containing the number of valid days between\n        the begin and end dates.\n\n    See Also\n    --------\n    busdaycalendar : An object that specifies a custom set of valid days.\n    is_busday : Returns a boolean array indicating valid days.\n    busday_offset : Applies an offset counted in valid days.\n\n    Examples\n    --------\n    >>> # Number of weekdays in January 2011\n    ... np.busday_count(\'2011-01\', \'2011-02\')\n    21\n    >>> # Number of weekdays in 2011\n    >>> np.busday_count(\'2011\', \'2012\')\n    260\n    >>> # Number of Saturdays in 2011\n    ... np.busday_count(\'2011\', \'2012\', weekmask=\'Sat\')\n    53\n    '
    ...

def busday_offset(dates, offsets, roll=..., weekmask=..., holidays=..., busdaycal=..., out=...) -> typing.Any:
    '    First adjusts the date to fall on a valid day according to\n    the ``roll`` rule, then applies offsets to the given dates\n    counted in valid days.\n\n    .. versionadded:: 1.7.0\n\n    Parameters\n    ----------\n    dates : array_like of datetime64[D]\n        The array of dates to process.\n    offsets : array_like of int\n        The array of offsets, which is broadcast with ``dates``.\n    roll : {\'raise\', \'nat\', \'forward\', \'following\', \'backward\', \'preceding\', \'modifiedfollowing\', \'modifiedpreceding\'}, optional\n        How to treat dates that do not fall on a valid day. The default\n        is \'raise\'.\n\n          * \'raise\' means to raise an exception for an invalid day.\n          * \'nat\' means to return a NaT (not-a-time) for an invalid day.\n          * \'forward\' and \'following\' mean to take the first valid day\n            later in time.\n          * \'backward\' and \'preceding\' mean to take the first valid day\n            earlier in time.\n          * \'modifiedfollowing\' means to take the first valid day\n            later in time unless it is across a Month boundary, in which\n            case to take the first valid day earlier in time.\n          * \'modifiedpreceding\' means to take the first valid day\n            earlier in time unless it is across a Month boundary, in which\n            case to take the first valid day later in time.\n    weekmask : str or array_like of bool, optional\n        A seven-element array indicating which of Monday through Sunday are\n        valid days. May be specified as a length-seven list or array, like\n        [1,1,1,1,1,0,0]; a length-seven string, like \'1111100\'; or a string\n        like "Mon Tue Wed Thu Fri", made up of 3-character abbreviations for\n        weekdays, optionally separated by white space. Valid abbreviations\n        are: Mon Tue Wed Thu Fri Sat Sun\n    holidays : array_like of datetime64[D], optional\n        An array of dates to consider as invalid dates.  They may be\n        specified in any order, and NaT (not-a-time) dates are ignored.\n        This list is saved in a normalized form that is suited for\n        fast calculations of valid days.\n    busdaycal : busdaycalendar, optional\n        A `busdaycalendar` object which specifies the valid days. If this\n        parameter is provided, neither weekmask nor holidays may be\n        provided.\n    out : array of datetime64[D], optional\n        If provided, this array is filled with the result.\n\n    Returns\n    -------\n    out : array of datetime64[D]\n        An array with a shape from broadcasting ``dates`` and ``offsets``\n        together, containing the dates with offsets applied.\n\n    See Also\n    --------\n    busdaycalendar : An object that specifies a custom set of valid days.\n    is_busday : Returns a boolean array indicating valid days.\n    busday_count : Counts how many valid days are in a half-open date range.\n\n    Examples\n    --------\n    >>> # First business day in October 2011 (not accounting for holidays)\n    ... np.busday_offset(\'2011-10\', 0, roll=\'forward\')\n    numpy.datetime64(\'2011-10-03\')\n    >>> # Last business day in February 2012 (not accounting for holidays)\n    ... np.busday_offset(\'2012-03\', -1, roll=\'forward\')\n    numpy.datetime64(\'2012-02-29\')\n    >>> # Third Wednesday in January 2011\n    ... np.busday_offset(\'2011-01\', 2, roll=\'forward\', weekmask=\'Wed\')\n    numpy.datetime64(\'2011-01-19\')\n    >>> # 2012 Mother\'s Day in Canada and the U.S.\n    ... np.busday_offset(\'2012-05\', 1, roll=\'forward\', weekmask=\'Sun\')\n    numpy.datetime64(\'2012-05-13\')\n\n    >>> # First business day on or after a date\n    ... np.busday_offset(\'2011-03-20\', 0, roll=\'forward\')\n    numpy.datetime64(\'2011-03-21\')\n    >>> np.busday_offset(\'2011-03-22\', 0, roll=\'forward\')\n    numpy.datetime64(\'2011-03-22\')\n    >>> # First business day after a date\n    ... np.busday_offset(\'2011-03-20\', 1, roll=\'backward\')\n    numpy.datetime64(\'2011-03-21\')\n    >>> np.busday_offset(\'2011-03-22\', 1, roll=\'backward\')\n    numpy.datetime64(\'2011-03-23\')\n    '
    ...

class busdaycalendar(_mod_builtins.object):
    'busdaycalendar(weekmask=\'1111100\', holidays=None)\n\n    A business day calendar object that efficiently stores information\n    defining valid days for the busday family of functions.\n\n    The default valid days are Monday through Friday ("business days").\n    A busdaycalendar object can be specified with any set of weekly\n    valid days, plus an optional "holiday" dates that always will be invalid.\n\n    Once a busdaycalendar object is created, the weekmask and holidays\n    cannot be modified.\n\n    .. versionadded:: 1.7.0\n\n    Parameters\n    ----------\n    weekmask : str or array_like of bool, optional\n        A seven-element array indicating which of Monday through Sunday are\n        valid days. May be specified as a length-seven list or array, like\n        [1,1,1,1,1,0,0]; a length-seven string, like \'1111100\'; or a string\n        like "Mon Tue Wed Thu Fri", made up of 3-character abbreviations for\n        weekdays, optionally separated by white space. Valid abbreviations\n        are: Mon Tue Wed Thu Fri Sat Sun\n    holidays : array_like of datetime64[D], optional\n        An array of dates to consider as invalid dates, no matter which\n        weekday they fall upon.  Holiday dates may be specified in any\n        order, and NaT (not-a-time) dates are ignored.  This list is\n        saved in a normalized form that is suited for fast calculations\n        of valid days.\n\n    Returns\n    -------\n    out : busdaycalendar\n        A business day calendar object containing the specified\n        weekmask and holidays values.\n\n    See Also\n    --------\n    is_busday : Returns a boolean array indicating valid days.\n    busday_offset : Applies an offset counted in valid days.\n    busday_count : Counts how many valid days are in a half-open date range.\n\n    Attributes\n    ----------\n    Note: once a busdaycalendar object is created, you cannot modify the\n    weekmask or holidays.  The attributes return copies of internal data.\n    weekmask : (copy) seven-element array of bool\n    holidays : (copy) sorted array of datetime64[D]\n\n    Examples\n    --------\n    >>> # Some important days in July\n    ... bdd = np.busdaycalendar(\n    ...             holidays=[\'2011-07-01\', \'2011-07-04\', \'2011-07-17\'])\n    >>> # Default is Monday to Friday weekdays\n    ... bdd.weekmask\n    array([ True,  True,  True,  True,  True, False, False])\n    >>> # Any holidays already on the weekend are removed\n    ... bdd.holidays\n    array([\'2011-07-01\', \'2011-07-04\'], dtype=\'datetime64[D]\')'
    def __init__(self, weekmask=..., holidays=...) -> None:
        'busdaycalendar(weekmask=\'1111100\', holidays=None)\n\n    A business day calendar object that efficiently stores information\n    defining valid days for the busday family of functions.\n\n    The default valid days are Monday through Friday ("business days").\n    A busdaycalendar object can be specified with any set of weekly\n    valid days, plus an optional "holiday" dates that always will be invalid.\n\n    Once a busdaycalendar object is created, the weekmask and holidays\n    cannot be modified.\n\n    .. versionadded:: 1.7.0\n\n    Parameters\n    ----------\n    weekmask : str or array_like of bool, optional\n        A seven-element array indicating which of Monday through Sunday are\n        valid days. May be specified as a length-seven list or array, like\n        [1,1,1,1,1,0,0]; a length-seven string, like \'1111100\'; or a string\n        like "Mon Tue Wed Thu Fri", made up of 3-character abbreviations for\n        weekdays, optionally separated by white space. Valid abbreviations\n        are: Mon Tue Wed Thu Fri Sat Sun\n    holidays : array_like of datetime64[D], optional\n        An array of dates to consider as invalid dates, no matter which\n        weekday they fall upon.  Holiday dates may be specified in any\n        order, and NaT (not-a-time) dates are ignored.  This list is\n        saved in a normalized form that is suited for fast calculations\n        of valid days.\n\n    Returns\n    -------\n    out : busdaycalendar\n        A business day calendar object containing the specified\n        weekmask and holidays values.\n\n    See Also\n    --------\n    is_busday : Returns a boolean array indicating valid days.\n    busday_offset : Applies an offset counted in valid days.\n    busday_count : Counts how many valid days are in a half-open date range.\n\n    Attributes\n    ----------\n    Note: once a busdaycalendar object is created, you cannot modify the\n    weekmask or holidays.  The attributes return copies of internal data.\n    weekmask : (copy) seven-element array of bool\n    holidays : (copy) sorted array of datetime64[D]\n\n    Examples\n    --------\n    >>> # Some important days in July\n    ... bdd = np.busdaycalendar(\n    ...             holidays=[\'2011-07-01\', \'2011-07-04\', \'2011-07-17\'])\n    >>> # Default is Monday to Friday weekdays\n    ... bdd.weekmask\n    array([ True,  True,  True,  True,  True, False, False])\n    >>> # Any holidays already on the weekend are removed\n    ... bdd.holidays\n    array([\'2011-07-01\', \'2011-07-04\'], dtype=\'datetime64[D]\')'
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    @property
    def holidays(self) -> typing.Any:
        'A copy of the holiday array indicating additional invalid days.'
        ...
    
    @property
    def weekmask(self) -> typing.Any:
        'A copy of the seven-element boolean mask indicating valid days.'
        ...
    
    def __getattr__(self, name) -> typing.Any:
        ...
    

def c_einsum(subscripts, *operands, out=..., dtype=..., order=..., casting=...) -> typing.Any:
    "    *This documentation shadows that of the native python implementation of the `einsum` function,\n    except all references and examples related to the `optimize` argument (v 0.12.0) have been removed.*\n\n    Evaluates the Einstein summation convention on the operands.\n\n    Using the Einstein summation convention, many common multi-dimensional,\n    linear algebraic array operations can be represented in a simple fashion.\n    In *implicit* mode `einsum` computes these values.\n\n    In *explicit* mode, `einsum` provides further flexibility to compute\n    other array operations that might not be considered classical Einstein\n    summation operations, by disabling, or forcing summation over specified\n    subscript labels.\n\n    See the notes and examples for clarification.\n\n    Parameters\n    ----------\n    subscripts : str\n        Specifies the subscripts for summation as comma separated list of\n        subscript labels. An implicit (classical Einstein summation)\n        calculation is performed unless the explicit indicator '->' is\n        included as well as subscript labels of the precise output form.\n    operands : list of array_like\n        These are the arrays for the operation.\n    out : ndarray, optional\n        If provided, the calculation is done into this array.\n    dtype : {data-type, None}, optional\n        If provided, forces the calculation to use the data type specified.\n        Note that you may have to also give a more liberal `casting`\n        parameter to allow the conversions. Default is None.\n    order : {'C', 'F', 'A', 'K'}, optional\n        Controls the memory layout of the output. 'C' means it should\n        be C contiguous. 'F' means it should be Fortran contiguous,\n        'A' means it should be 'F' if the inputs are all 'F', 'C' otherwise.\n        'K' means it should be as close to the layout of the inputs as\n        is possible, including arbitrarily permuted axes.\n        Default is 'K'.\n    casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional\n        Controls what kind of data casting may occur.  Setting this to\n        'unsafe' is not recommended, as it can adversely affect accumulations.\n\n          * 'no' means the data types should not be cast at all.\n          * 'equiv' means only byte-order changes are allowed.\n          * 'safe' means only casts which can preserve values are allowed.\n          * 'same_kind' means only safe casts or casts within a kind,\n            like float64 to float32, are allowed.\n          * 'unsafe' means any data conversions may be done.\n\n        Default is 'safe'.\n    optimize : {False, True, 'greedy', 'optimal'}, optional\n        Controls if intermediate optimization should occur. No optimization\n        will occur if False and True will default to the 'greedy' algorithm.\n        Also accepts an explicit contraction list from the ``np.einsum_path``\n        function. See ``np.einsum_path`` for more details. Defaults to False.\n\n    Returns\n    -------\n    output : ndarray\n        The calculation based on the Einstein summation convention.\n\n    See Also\n    --------\n    einsum_path, dot, inner, outer, tensordot, linalg.multi_dot\n\n    Notes\n    -----\n    .. versionadded:: 1.6.0\n\n    The Einstein summation convention can be used to compute\n    many multi-dimensional, linear algebraic array operations. `einsum`\n    provides a succinct way of representing these.\n\n    A non-exhaustive list of these operations,\n    which can be computed by `einsum`, is shown below along with examples:\n\n    * Trace of an array, :py:func:`numpy.trace`.\n    * Return a diagonal, :py:func:`numpy.diag`.\n    * Array axis summations, :py:func:`numpy.sum`.\n    * Transpositions and permutations, :py:func:`numpy.transpose`.\n    * Matrix multiplication and dot product, :py:func:`numpy.matmul` :py:func:`numpy.dot`.\n    * Vector inner and outer products, :py:func:`numpy.inner` :py:func:`numpy.outer`.\n    * Broadcasting, element-wise and scalar multiplication, :py:func:`numpy.multiply`.\n    * Tensor contractions, :py:func:`numpy.tensordot`.\n    * Chained array operations, in efficient calculation order, :py:func:`numpy.einsum_path`.\n\n    The subscripts string is a comma-separated list of subscript labels,\n    where each label refers to a dimension of the corresponding operand.\n    Whenever a label is repeated it is summed, so ``np.einsum('i,i', a, b)``\n    is equivalent to :py:func:`np.inner(a,b) <numpy.inner>`. If a label\n    appears only once, it is not summed, so ``np.einsum('i', a)`` produces a\n    view of ``a`` with no changes. A further example ``np.einsum('ij,jk', a, b)``\n    describes traditional matrix multiplication and is equivalent to\n    :py:func:`np.matmul(a,b) <numpy.matmul>`. Repeated subscript labels in one\n    operand take the diagonal. For example, ``np.einsum('ii', a)`` is equivalent\n    to :py:func:`np.trace(a) <numpy.trace>`.\n\n    In *implicit mode*, the chosen subscripts are important\n    since the axes of the output are reordered alphabetically.  This\n    means that ``np.einsum('ij', a)`` doesn't affect a 2D array, while\n    ``np.einsum('ji', a)`` takes its transpose. Additionally,\n    ``np.einsum('ij,jk', a, b)`` returns a matrix multiplication, while,\n    ``np.einsum('ij,jh', a, b)`` returns the transpose of the\n    multiplication since subscript 'h' precedes subscript 'i'.\n\n    In *explicit mode* the output can be directly controlled by\n    specifying output subscript labels.  This requires the\n    identifier '->' as well as the list of output subscript labels.\n    This feature increases the flexibility of the function since\n    summing can be disabled or forced when required. The call\n    ``np.einsum('i->', a)`` is like :py:func:`np.sum(a, axis=-1) <numpy.sum>`,\n    and ``np.einsum('ii->i', a)`` is like :py:func:`np.diag(a) <numpy.diag>`.\n    The difference is that `einsum` does not allow broadcasting by default.\n    Additionally ``np.einsum('ij,jh->ih', a, b)`` directly specifies the\n    order of the output subscript labels and therefore returns matrix\n    multiplication, unlike the example above in implicit mode.\n\n    To enable and control broadcasting, use an ellipsis.  Default\n    NumPy-style broadcasting is done by adding an ellipsis\n    to the left of each term, like ``np.einsum('...ii->...i', a)``.\n    To take the trace along the first and last axes,\n    you can do ``np.einsum('i...i', a)``, or to do a matrix-matrix\n    product with the left-most indices instead of rightmost, one can do\n    ``np.einsum('ij...,jk...->ik...', a, b)``.\n\n    When there is only one operand, no axes are summed, and no output\n    parameter is provided, a view into the operand is returned instead\n    of a new array.  Thus, taking the diagonal as ``np.einsum('ii->i', a)``\n    produces a view (changed in version 1.10.0).\n\n    `einsum` also provides an alternative way to provide the subscripts\n    and operands as ``einsum(op0, sublist0, op1, sublist1, ..., [sublistout])``.\n    If the output shape is not provided in this format `einsum` will be\n    calculated in implicit mode, otherwise it will be performed explicitly.\n    The examples below have corresponding `einsum` calls with the two\n    parameter methods.\n\n    .. versionadded:: 1.10.0\n\n    Views returned from einsum are now writeable whenever the input array\n    is writeable. For example, ``np.einsum('ijk...->kji...', a)`` will now\n    have the same effect as :py:func:`np.swapaxes(a, 0, 2) <numpy.swapaxes>`\n    and ``np.einsum('ii->i', a)`` will return a writeable view of the diagonal\n    of a 2D array.\n\n    Examples\n    --------\n    >>> a = np.arange(25).reshape(5,5)\n    >>> b = np.arange(5)\n    >>> c = np.arange(6).reshape(2,3)\n\n    Trace of a matrix:\n\n    >>> np.einsum('ii', a)\n    60\n    >>> np.einsum(a, [0,0])\n    60\n    >>> np.trace(a)\n    60\n\n    Extract the diagonal (requires explicit form):\n\n    >>> np.einsum('ii->i', a)\n    array([ 0,  6, 12, 18, 24])\n    >>> np.einsum(a, [0,0], [0])\n    array([ 0,  6, 12, 18, 24])\n    >>> np.diag(a)\n    array([ 0,  6, 12, 18, 24])\n\n    Sum over an axis (requires explicit form):\n\n    >>> np.einsum('ij->i', a)\n    array([ 10,  35,  60,  85, 110])\n    >>> np.einsum(a, [0,1], [0])\n    array([ 10,  35,  60,  85, 110])\n    >>> np.sum(a, axis=1)\n    array([ 10,  35,  60,  85, 110])\n\n    For higher dimensional arrays summing a single axis can be done with ellipsis:\n\n    >>> np.einsum('...j->...', a)\n    array([ 10,  35,  60,  85, 110])\n    >>> np.einsum(a, [Ellipsis,1], [Ellipsis])\n    array([ 10,  35,  60,  85, 110])\n\n    Compute a matrix transpose, or reorder any number of axes:\n\n    >>> np.einsum('ji', c)\n    array([[0, 3],\n           [1, 4],\n           [2, 5]])\n    >>> np.einsum('ij->ji', c)\n    array([[0, 3],\n           [1, 4],\n           [2, 5]])\n    >>> np.einsum(c, [1,0])\n    array([[0, 3],\n           [1, 4],\n           [2, 5]])\n    >>> np.transpose(c)\n    array([[0, 3],\n           [1, 4],\n           [2, 5]])\n\n    Vector inner products:\n\n    >>> np.einsum('i,i', b, b)\n    30\n    >>> np.einsum(b, [0], b, [0])\n    30\n    >>> np.inner(b,b)\n    30\n\n    Matrix vector multiplication:\n\n    >>> np.einsum('ij,j', a, b)\n    array([ 30,  80, 130, 180, 230])\n    >>> np.einsum(a, [0,1], b, [1])\n    array([ 30,  80, 130, 180, 230])\n    >>> np.dot(a, b)\n    array([ 30,  80, 130, 180, 230])\n    >>> np.einsum('...j,j', a, b)\n    array([ 30,  80, 130, 180, 230])\n\n    Broadcasting and scalar multiplication:\n\n    >>> np.einsum('..., ...', 3, c)\n    array([[ 0,  3,  6],\n           [ 9, 12, 15]])\n    >>> np.einsum(',ij', 3, c)\n    array([[ 0,  3,  6],\n           [ 9, 12, 15]])\n    >>> np.einsum(3, [Ellipsis], c, [Ellipsis])\n    array([[ 0,  3,  6],\n           [ 9, 12, 15]])\n    >>> np.multiply(3, c)\n    array([[ 0,  3,  6],\n           [ 9, 12, 15]])\n\n    Vector outer product:\n\n    >>> np.einsum('i,j', np.arange(2)+1, b)\n    array([[0, 1, 2, 3, 4],\n           [0, 2, 4, 6, 8]])\n    >>> np.einsum(np.arange(2)+1, [0], b, [1])\n    array([[0, 1, 2, 3, 4],\n           [0, 2, 4, 6, 8]])\n    >>> np.outer(np.arange(2)+1, b)\n    array([[0, 1, 2, 3, 4],\n           [0, 2, 4, 6, 8]])\n\n    Tensor contraction:\n\n    >>> a = np.arange(60.).reshape(3,4,5)\n    >>> b = np.arange(24.).reshape(4,3,2)\n    >>> np.einsum('ijk,jil->kl', a, b)\n    array([[ 4400.,  4730.],\n           [ 4532.,  4874.],\n           [ 4664.,  5018.],\n           [ 4796.,  5162.],\n           [ 4928.,  5306.]])\n    >>> np.einsum(a, [0,1,2], b, [1,0,3], [2,3])\n    array([[ 4400.,  4730.],\n           [ 4532.,  4874.],\n           [ 4664.,  5018.],\n           [ 4796.,  5162.],\n           [ 4928.,  5306.]])\n    >>> np.tensordot(a,b, axes=([1,0],[0,1]))\n    array([[ 4400.,  4730.],\n           [ 4532.,  4874.],\n           [ 4664.,  5018.],\n           [ 4796.,  5162.],\n           [ 4928.,  5306.]])\n\n    Writeable returned arrays (since version 1.10.0):\n\n    >>> a = np.zeros((3, 3))\n    >>> np.einsum('ii->i', a)[:] = 1\n    >>> a\n    array([[ 1.,  0.,  0.],\n           [ 0.,  1.,  0.],\n           [ 0.,  0.,  1.]])\n\n    Example of ellipsis use:\n\n    >>> a = np.arange(6).reshape((3,2))\n    >>> b = np.arange(12).reshape((4,3))\n    >>> np.einsum('ki,jk->ij', a, b)\n    array([[10, 28, 46, 64],\n           [13, 40, 67, 94]])\n    >>> np.einsum('ki,...k->i...', a, b)\n    array([[10, 28, 46, 64],\n           [13, 40, 67, 94]])\n    >>> np.einsum('k...,jk', a, b)\n    array([[10, 28, 46, 64],\n           [13, 40, 67, 94]])"
    ...

def can_cast(from_, to, casting=...) -> typing.Any:
    '    Returns True if cast between data types can occur according to the\n    casting rule.  If from is a scalar or array scalar, also returns\n    True if the scalar value can be cast without overflow or truncation\n    to an integer.\n\n    Parameters\n    ----------\n    from_ : dtype, dtype specifier, scalar, or array\n        Data type, scalar, or array to cast from.\n    to : dtype or dtype specifier\n        Data type to cast to.\n    casting : {\'no\', \'equiv\', \'safe\', \'same_kind\', \'unsafe\'}, optional\n        Controls what kind of data casting may occur.\n\n          * \'no\' means the data types should not be cast at all.\n          * \'equiv\' means only byte-order changes are allowed.\n          * \'safe\' means only casts which can preserve values are allowed.\n          * \'same_kind\' means only safe casts or casts within a kind,\n            like float64 to float32, are allowed.\n          * \'unsafe\' means any data conversions may be done.\n\n    Returns\n    -------\n    out : bool\n        True if cast can occur according to the casting rule.\n\n    Notes\n    -----\n    .. versionchanged:: 1.17.0\n       Casting between a simple data type and a structured one is possible only\n       for "unsafe" casting.  Casting to multiple fields is allowed, but\n       casting from multiple fields is not.\n\n    .. versionchanged:: 1.9.0\n       Casting from numeric to string types in \'safe\' casting mode requires\n       that the string dtype length is long enough to store the maximum\n       integer/float value converted.\n\n    See also\n    --------\n    dtype, result_type\n\n    Examples\n    --------\n    Basic examples\n\n    >>> np.can_cast(np.int32, np.int64)\n    True\n    >>> np.can_cast(np.float64, complex)\n    True\n    >>> np.can_cast(complex, float)\n    False\n\n    >>> np.can_cast(\'i8\', \'f8\')\n    True\n    >>> np.can_cast(\'i8\', \'f4\')\n    False\n    >>> np.can_cast(\'i4\', \'S4\')\n    False\n\n    Casting scalars\n\n    >>> np.can_cast(100, \'i1\')\n    True\n    >>> np.can_cast(150, \'i1\')\n    False\n    >>> np.can_cast(150, \'u1\')\n    True\n\n    >>> np.can_cast(3.5e100, np.float32)\n    False\n    >>> np.can_cast(1000.0, np.float32)\n    True\n\n    Array scalar checks the value, array does not\n\n    >>> np.can_cast(np.array(1000.0), np.float32)\n    True\n    >>> np.can_cast(np.array([1000.0]), np.float32)\n    False\n\n    Using the casting rules\n\n    >>> np.can_cast(\'i8\', \'i8\', \'no\')\n    True\n    >>> np.can_cast(\'<i8\', \'>i8\', \'no\')\n    False\n\n    >>> np.can_cast(\'<i8\', \'>i8\', \'equiv\')\n    True\n    >>> np.can_cast(\'<i4\', \'>i8\', \'equiv\')\n    False\n\n    >>> np.can_cast(\'<i4\', \'>i8\', \'safe\')\n    True\n    >>> np.can_cast(\'<i8\', \'>i4\', \'safe\')\n    False\n\n    >>> np.can_cast(\'<i8\', \'>i4\', \'same_kind\')\n    True\n    >>> np.can_cast(\'<i8\', \'>u4\', \'same_kind\')\n    False\n\n    >>> np.can_cast(\'<i8\', \'>u4\', \'unsafe\')\n    True\n\n    '
    ...

def cbrt(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the cube-root of an array, element-wise.\n\n.. versionadded:: 1.10.0\n\nParameters\n----------\nx : array_like\n    The values whose cube-roots are required.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    An array of the same shape as `x`, containing the cube\n    cube-root of each element in `x`.\n    If `out` was provided, `y` is a reference to it.\n    This is a scalar if `x` is a scalar.\n\n\nExamples\n--------\n>>> np.cbrt([1,8,27])\narray([ 1.,  2.,  3.])'
    ...

def ceil(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the ceiling of the input, element-wise.\n\nThe ceil of the scalar `x` is the smallest integer `i`, such that\n``i >= x``.  It is often denoted as :math:`\\lceil x \\rceil`.\n\nParameters\n----------\nx : array_like\n    Input data.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The ceiling of each element in `x`, with `float` dtype.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nfloor, trunc, rint, fix\n\nExamples\n--------\n>>> a = np.array([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0])\n>>> np.ceil(a)\narray([-1., -1., -0.,  1.,  2.,  2.,  2.])'
    ...

def clip(x1, x2, x3, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Clip (limit) the values in an array.\n\nGiven an interval, values outside the interval are clipped to\nthe interval edges.  For example, if an interval of ``[0, 1]``\nis specified, values smaller than 0 become 0, and values larger\nthan 1 become 1.\n\nEquivalent to but faster than ``np.minimum(np.maximum(a, a_min), a_max)``.\n\nParameters\n----------\na : array_like\n    Array containing elements to clip.\na_min : array_like\n    Minimum value.\na_max : array_like\n    Maximum value.\nout : ndarray, optional\n    The results will be placed in this array. It may be the input\n    array for in-place clipping.  `out` must be of the right shape\n    to hold the output.  Its type is preserved.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nSee Also\n--------\nnumpy.clip :\n    Wrapper that makes the ``a_min`` and ``a_max`` arguments optional,\n    dispatching to one of `~numpy.core.umath.clip`,\n    `~numpy.core.umath.minimum`, and `~numpy.core.umath.maximum`.\n\nReturns\n-------\nclipped_array : ndarray\n    An array with the elements of `a`, but where values\n    < `a_min` are replaced with `a_min`, and those > `a_max`\n    with `a_max`.'
    ...

def compare_chararrays(a1, a2, cmp, rstrip) -> typing.Any:
    '    Performs element-wise comparison of two string arrays using the\n    comparison operator specified by `cmp_op`.\n\n    Parameters\n    ----------\n    a1, a2 : array_like\n        Arrays to be compared.\n    cmp : {"<", "<=", "==", ">=", ">", "!="}\n        Type of comparison.\n    rstrip : Boolean\n        If True, the spaces at the end of Strings are removed before the comparison.\n\n    Returns\n    -------\n    out : ndarray\n        The output array of type Boolean with the same shape as a and b.\n\n    Raises\n    ------\n    ValueError\n        If `cmp_op` is not valid.\n    TypeError\n        If at least one of `a` or `b` is a non-string array\n\n    Examples\n    --------\n    >>> a = np.array(["a", "b", "cde"])\n    >>> b = np.array(["a", "a", "dec"])\n    >>> np.compare_chararrays(a, b, ">", True)\n    array([False,  True, False])'
    ...

def concatenate() -> typing.Any:
    "    Join a sequence of arrays along an existing axis.\n\n    Parameters\n    ----------\n    a1, a2, ... : sequence of array_like\n        The arrays must have the same shape, except in the dimension\n        corresponding to `axis` (the first, by default).\n    axis : int, optional\n        The axis along which the arrays will be joined.  If axis is None,\n        arrays are flattened before use.  Default is 0.\n    out : ndarray, optional\n        If provided, the destination to place the result. The shape must be\n        correct, matching that of what concatenate would have returned if no\n        out argument were specified.\n    dtype : str or dtype\n        If provided, the destination array will have this dtype. Cannot be\n        provided together with `out`.\n\n        .. versionadded:: 1.20.0\n\n    casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional\n        Controls what kind of data casting may occur. Defaults to 'same_kind'.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    res : ndarray\n        The concatenated array.\n\n    See Also\n    --------\n    ma.concatenate : Concatenate function that preserves input masks.\n    array_split : Split an array into multiple sub-arrays of equal or\n                  near-equal size.\n    split : Split array into a list of multiple sub-arrays of equal size.\n    hsplit : Split array into multiple sub-arrays horizontally (column wise).\n    vsplit : Split array into multiple sub-arrays vertically (row wise).\n    dsplit : Split array into multiple sub-arrays along the 3rd axis (depth).\n    stack : Stack a sequence of arrays along a new axis.\n    block : Assemble arrays from blocks.\n    hstack : Stack arrays in sequence horizontally (column wise).\n    vstack : Stack arrays in sequence vertically (row wise).\n    dstack : Stack arrays in sequence depth wise (along third dimension).\n    column_stack : Stack 1-D arrays as columns into a 2-D array.\n\n    Notes\n    -----\n    When one or more of the arrays to be concatenated is a MaskedArray,\n    this function will return a MaskedArray object instead of an ndarray,\n    but the input masks are *not* preserved. In cases where a MaskedArray\n    is expected as input, use the ma.concatenate function from the masked\n    array module instead.\n\n    Examples\n    --------\n    >>> a = np.array([[1, 2], [3, 4]])\n    >>> b = np.array([[5, 6]])\n    >>> np.concatenate((a, b), axis=0)\n    array([[1, 2],\n           [3, 4],\n           [5, 6]])\n    >>> np.concatenate((a, b.T), axis=1)\n    array([[1, 2, 5],\n           [3, 4, 6]])\n    >>> np.concatenate((a, b), axis=None)\n    array([1, 2, 3, 4, 5, 6])\n\n    This function will not preserve masking of MaskedArray inputs.\n\n    >>> a = np.ma.arange(3)\n    >>> a[1] = np.ma.masked\n    >>> b = np.arange(2, 5)\n    >>> a\n    masked_array(data=[0, --, 2],\n                 mask=[False,  True, False],\n           fill_value=999999)\n    >>> b\n    array([2, 3, 4])\n    >>> np.concatenate([a, b])\n    masked_array(data=[0, 1, 2, 2, 3, 4],\n                 mask=False,\n           fill_value=999999)\n    >>> np.ma.concatenate([a, b])\n    masked_array(data=[0, --, 2, 2, 3, 4],\n                 mask=[False,  True, False, False, False, False],\n           fill_value=999999)\n\n    "
    ...

def conj(self, *args, **kwargs) -> typing.Any:
    "conjugate(x, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nReturn the complex conjugate, element-wise.\n\nThe complex conjugate of a complex number is obtained by changing the\nsign of its imaginary part.\n\nParameters\n----------\nx : array_like\n    Input value.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The complex conjugate of `x`, with same dtype as `y`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\n`conj` is an alias for `conjugate`:\n\n>>> np.conj is np.conjugate\nTrue\n\nExamples\n--------\n>>> np.conjugate(1+2j)\n(1-2j)\n\n>>> x = np.eye(2) + 1j * np.eye(2)\n>>> np.conjugate(x)\narray([[ 1.-1.j,  0.-0.j],\n       [ 0.-0.j,  1.-1.j]])"
    ...

def conjugate(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the complex conjugate, element-wise.\n\nThe complex conjugate of a complex number is obtained by changing the\nsign of its imaginary part.\n\nParameters\n----------\nx : array_like\n    Input value.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The complex conjugate of `x`, with same dtype as `y`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\n`conj` is an alias for `conjugate`:\n\n>>> np.conj is np.conjugate\nTrue\n\nExamples\n--------\n>>> np.conjugate(1+2j)\n(1-2j)\n\n>>> x = np.eye(2) + 1j * np.eye(2)\n>>> np.conjugate(x)\narray([[ 1.-1.j,  0.-0.j],\n       [ 0.-0.j,  1.-1.j]])'
    ...

def copysign(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Change the sign of x1 to that of x2, element-wise.\n\nIf `x2` is a scalar, its sign will be copied to all elements of `x1`.\n\nParameters\n----------\nx1 : array_like\n    Values to change the sign of.\nx2 : array_like\n    The sign of `x2` is copied to `x1`.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    The values of `x1` with the sign of `x2`.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nExamples\n--------\n>>> np.copysign(1.3, -1)\n-1.3\n>>> 1/np.copysign(0, 1)\ninf\n>>> 1/np.copysign(0, -1)\n-inf\n\n>>> np.copysign([-1, 0, 1], -1.1)\narray([-1., -0., -1.])\n>>> np.copysign([-1, 0, 1], np.arange(3)-1)\narray([-1.,  0.,  1.])'
    ...

def copyto(dst, src, casting=..., where=...) -> typing.Any:
    "    Copies values from one array to another, broadcasting as necessary.\n\n    Raises a TypeError if the `casting` rule is violated, and if\n    `where` is provided, it selects which elements to copy.\n\n    .. versionadded:: 1.7.0\n\n    Parameters\n    ----------\n    dst : ndarray\n        The array into which values are copied.\n    src : array_like\n        The array from which values are copied.\n    casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}, optional\n        Controls what kind of data casting may occur when copying.\n\n          * 'no' means the data types should not be cast at all.\n          * 'equiv' means only byte-order changes are allowed.\n          * 'safe' means only casts which can preserve values are allowed.\n          * 'same_kind' means only safe casts or casts within a kind,\n            like float64 to float32, are allowed.\n          * 'unsafe' means any data conversions may be done.\n    where : array_like of bool, optional\n        A boolean array which is broadcasted to match the dimensions\n        of `dst`, and selects elements to copy from `src` to `dst`\n        wherever it contains the value True.\n\n    Examples\n    --------\n    >>> A = np.array([4, 5, 6])\n    >>> B = [1, 2, 3]\n    >>> np.copyto(A, B)\n    >>> A\n    array([1, 2, 3])\n\n    >>> A = np.array([[1, 2, 3], [4, 5, 6]])\n    >>> B = [[4, 5, 6], [7, 8, 9]]\n    >>> np.copyto(A, B)\n    >>> A\n    array([[4, 5, 6],\n           [7, 8, 9]])\n\n    "
    ...

def correlate() -> typing.Any:
    'cross_correlate(a,v, mode=0)'
    ...

def correlate2() -> typing.Any:
    ...

def cos(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Cosine element-wise.\n\nParameters\n----------\nx : array_like\n    Input array in radians.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding cosine values.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nIf `out` is provided, the function writes the result into it,\nand returns a reference to `out`.  (See Examples)\n\nReferences\n----------\nM. Abramowitz and I. A. Stegun, Handbook of Mathematical Functions.\nNew York, NY: Dover, 1972.\n\nExamples\n--------\n>>> np.cos(np.array([0, np.pi/2, np.pi]))\narray([  1.00000000e+00,   6.12303177e-17,  -1.00000000e+00])\n>>>\n>>> # Example of providing the optional output parameter\n>>> out1 = np.array([0], dtype=\'d\')\n>>> out2 = np.cos([0.1], out1)\n>>> out2 is out1\nTrue\n>>>\n>>> # Example of ValueError due to provision of shape mis-matched `out`\n>>> np.cos(np.zeros((3,3)),np.zeros((2,2)))\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: operands could not be broadcast together with shapes (3,3) (2,2)'
    ...

def cosh(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Hyperbolic cosine, element-wise.\n\nEquivalent to ``1/2 * (np.exp(x) + np.exp(-x))`` and ``np.cos(1j*x)``.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array of same shape as `x`.\n    This is a scalar if `x` is a scalar.\n\nExamples\n--------\n>>> np.cosh(0)\n1.0\n\nThe hyperbolic cosine describes the shape of a hanging cable:\n\n>>> import matplotlib.pyplot as plt\n>>> x = np.linspace(-4, 4, 1000)\n>>> plt.plot(x, np.cosh(x))\n>>> plt.show()'
    ...

def count_nonzero() -> typing.Any:
    ...

def datetime_as_string(arr, unit=..., timezone=..., casting=...) -> typing.Any:
    "    Convert an array of datetimes into an array of strings.\n\n    Parameters\n    ----------\n    arr : array_like of datetime64\n        The array of UTC timestamps to format.\n    unit : str\n        One of None, 'auto', or a :ref:`datetime unit <arrays.dtypes.dateunits>`.\n    timezone : {'naive', 'UTC', 'local'} or tzinfo\n        Timezone information to use when displaying the datetime. If 'UTC', end\n        with a Z to indicate UTC time. If 'local', convert to the local timezone\n        first, and suffix with a +-#### timezone offset. If a tzinfo object,\n        then do as with 'local', but use the specified timezone.\n    casting : {'no', 'equiv', 'safe', 'same_kind', 'unsafe'}\n        Casting to allow when changing between datetime units.\n\n    Returns\n    -------\n    str_arr : ndarray\n        An array of strings the same shape as `arr`.\n\n    Examples\n    --------\n    >>> import pytz\n    >>> d = np.arange('2002-10-27T04:30', 4*60, 60, dtype='M8[m]')\n    >>> d\n    array(['2002-10-27T04:30', '2002-10-27T05:30', '2002-10-27T06:30',\n           '2002-10-27T07:30'], dtype='datetime64[m]')\n\n    Setting the timezone to UTC shows the same information, but with a Z suffix\n\n    >>> np.datetime_as_string(d, timezone='UTC')\n    array(['2002-10-27T04:30Z', '2002-10-27T05:30Z', '2002-10-27T06:30Z',\n           '2002-10-27T07:30Z'], dtype='<U35')\n\n    Note that we picked datetimes that cross a DST boundary. Passing in a\n    ``pytz`` timezone object will print the appropriate offset\n\n    >>> np.datetime_as_string(d, timezone=pytz.timezone('US/Eastern'))\n    array(['2002-10-27T00:30-0400', '2002-10-27T01:30-0400',\n           '2002-10-27T01:30-0500', '2002-10-27T02:30-0500'], dtype='<U39')\n\n    Passing in a unit will change the precision\n\n    >>> np.datetime_as_string(d, unit='h')\n    array(['2002-10-27T04', '2002-10-27T05', '2002-10-27T06', '2002-10-27T07'],\n          dtype='<U32')\n    >>> np.datetime_as_string(d, unit='s')\n    array(['2002-10-27T04:30:00', '2002-10-27T05:30:00', '2002-10-27T06:30:00',\n           '2002-10-27T07:30:00'], dtype='<U38')\n\n    'casting' can be used to specify whether precision can be changed\n\n    >>> np.datetime_as_string(d, unit='h', casting='safe')\n    Traceback (most recent call last):\n        ...\n    TypeError: Cannot create a datetime string as units 'h' from a NumPy\n    datetime with units 'm' according to the rule 'safe'\n    "
    ...

def datetime_data(dtype) -> typing.Any:
    "    Get information about the step size of a date or time type.\n\n    The returned tuple can be passed as the second argument of `numpy.datetime64` and\n    `numpy.timedelta64`.\n\n    Parameters\n    ----------\n    dtype : dtype\n        The dtype object, which must be a `datetime64` or `timedelta64` type.\n\n    Returns\n    -------\n    unit : str\n        The :ref:`datetime unit <arrays.dtypes.dateunits>` on which this dtype\n        is based.\n    count : int\n        The number of base units in a step.\n\n    Examples\n    --------\n    >>> dt_25s = np.dtype('timedelta64[25s]')\n    >>> np.datetime_data(dt_25s)\n    ('s', 25)\n    >>> np.array(10, dt_25s).astype('timedelta64[s]')\n    array(250, dtype='timedelta64[s]')\n\n    The result can be used to construct a datetime that uses the same units\n    as a timedelta\n\n    >>> np.datetime64('2010', np.datetime_data(dt_25s))\n    numpy.datetime64('2010-01-01T00:00:00','25s')"
    ...

def deg2rad(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Convert angles from degrees to radians.\n\nParameters\n----------\nx : array_like\n    Angles in degrees.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding angle in radians.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nrad2deg : Convert angles from radians to degrees.\nunwrap : Remove large jumps in angle by wrapping.\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\n``deg2rad(x)`` is ``x * pi / 180``.\n\nExamples\n--------\n>>> np.deg2rad(180)\n3.1415926535897931'
    ...

def degrees(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Convert angles from radians to degrees.\n\nParameters\n----------\nx : array_like\n    Input array in radians.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray of floats\n    The corresponding degree values; if `out` was supplied this is a\n    reference to it.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nrad2deg : equivalent function\n\nExamples\n--------\nConvert a radian array to degrees\n\n>>> rad = np.arange(12.)*np.pi/6\n>>> np.degrees(rad)\narray([   0.,   30.,   60.,   90.,  120.,  150.,  180.,  210.,  240.,\n        270.,  300.,  330.])\n\n>>> out = np.zeros((rad.shape))\n>>> r = np.degrees(rad, out)\n>>> np.all(r == out)\nTrue'
    ...

def divide(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Divide arguments element-wise.\n\nParameters\n----------\nx1 : array_like\n    Dividend array.\nx2 : array_like\n    Divisor array.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The quotient ``x1/x2``, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nseterr : Set whether to raise or warn on overflow, underflow and\n         division by zero.\n\nNotes\n-----\nEquivalent to ``x1`` / ``x2`` in terms of array-broadcasting.\n\nThe ``true_divide(x1, x2)`` function is an alias for\n``divide(x1, x2)``.\n\nExamples\n--------\n>>> np.divide(2.0, 4.0)\n0.5\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> np.divide(x1, x2)\narray([[nan, 1. , 1. ],\n       [inf, 4. , 2.5],\n       [inf, 7. , 4. ]])\n\nThe ``/`` operator can be used as a shorthand for ``np.divide`` on\nndarrays.\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = 2 * np.ones(3)\n>>> x1 / x2\narray([[0. , 0.5, 1. ],\n       [1.5, 2. , 2.5],\n       [3. , 3.5, 4. ]])'
    ...

def divmod(x1, x2, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Return element-wise quotient and remainder simultaneously.\n\n.. versionadded:: 1.13.0\n\n``np.divmod(x, y)`` is equivalent to ``(x // y, x % y)``, but faster\nbecause it avoids redundant work. It is used to implement the Python\nbuilt-in function ``divmod`` on NumPy arrays.\n\nParameters\n----------\nx1 : array_like\n    Dividend array.\nx2 : array_like\n    Divisor array.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout1 : ndarray\n    Element-wise quotient resulting from floor division.\n    This is a scalar if both `x1` and `x2` are scalars.\nout2 : ndarray\n    Element-wise remainder from floor division.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfloor_divide : Equivalent to Python's ``//`` operator.\nremainder : Equivalent to Python's ``%`` operator.\nmodf : Equivalent to ``divmod(x, 1)`` for positive ``x`` with the return\n       values switched.\n\nExamples\n--------\n>>> np.divmod(np.arange(5), 3)\n(array([0, 0, 0, 1, 1]), array([0, 1, 2, 0, 1]))\n\nThe `divmod` function can be used as a shorthand for ``np.divmod`` on\nndarrays.\n\n>>> x = np.arange(5)\n>>> divmod(x, 3)\n(array([0, 0, 0, 1, 1]), array([0, 1, 2, 0, 1]))"
    ...

def dot(a, b, out=...) -> typing.Any:
    "    Dot product of two arrays. Specifically,\n\n    - If both `a` and `b` are 1-D arrays, it is inner product of vectors\n      (without complex conjugation).\n\n    - If both `a` and `b` are 2-D arrays, it is matrix multiplication,\n      but using :func:`matmul` or ``a @ b`` is preferred.\n\n    - If either `a` or `b` is 0-D (scalar), it is equivalent to\n      :func:`multiply` and using ``numpy.multiply(a, b)`` or ``a * b`` is\n      preferred.\n\n    - If `a` is an N-D array and `b` is a 1-D array, it is a sum product over\n      the last axis of `a` and `b`.\n\n    - If `a` is an N-D array and `b` is an M-D array (where ``M>=2``), it is a\n      sum product over the last axis of `a` and the second-to-last axis of\n      `b`::\n\n        dot(a, b)[i,j,k,m] = sum(a[i,j,:] * b[k,:,m])\n\n    It uses an optimized BLAS library when possible (see `numpy.linalg`).\n\n    Parameters\n    ----------\n    a : array_like\n        First argument.\n    b : array_like\n        Second argument.\n    out : ndarray, optional\n        Output argument. This must have the exact kind that would be returned\n        if it was not used. In particular, it must have the right type, must be\n        C-contiguous, and its dtype must be the dtype that would be returned\n        for `dot(a,b)`. This is a performance feature. Therefore, if these\n        conditions are not met, an exception is raised, instead of attempting\n        to be flexible.\n\n    Returns\n    -------\n    output : ndarray\n        Returns the dot product of `a` and `b`.  If `a` and `b` are both\n        scalars or both 1-D arrays then a scalar is returned; otherwise\n        an array is returned.\n        If `out` is given, then it is returned.\n\n    Raises\n    ------\n    ValueError\n        If the last dimension of `a` is not the same size as\n        the second-to-last dimension of `b`.\n\n    See Also\n    --------\n    vdot : Complex-conjugating dot product.\n    tensordot : Sum products over arbitrary axes.\n    einsum : Einstein summation convention.\n    matmul : '@' operator as method with out parameter.\n    linalg.multi_dot : Chained dot product.\n\n    Examples\n    --------\n    >>> np.dot(3, 4)\n    12\n\n    Neither argument is complex-conjugated:\n\n    >>> np.dot([2j, 3j], [2j, 3j])\n    (-13+0j)\n\n    For 2-D arrays it is the matrix product:\n\n    >>> a = [[1, 0], [0, 1]]\n    >>> b = [[4, 1], [2, 2]]\n    >>> np.dot(a, b)\n    array([[4, 1],\n           [2, 2]])\n\n    >>> a = np.arange(3*4*5*6).reshape((3,4,5,6))\n    >>> b = np.arange(3*4*5*6)[::-1].reshape((5,4,6,3))\n    >>> np.dot(a, b)[2,3,2,1,2,2]\n    499128\n    >>> sum(a[2,3,2,:] * b[1,2,:,2])\n    499128\n\n    "
    ...

def dragon4_positional() -> typing.Any:
    ...

def dragon4_scientific() -> typing.Any:
    ...

class dtype(_mod_builtins.object):
    'dtype(dtype, align=False, copy=False, [metadata])\n\n    Create a data type object.\n\n    A numpy array is homogeneous, and contains elements described by a\n    dtype object. A dtype object can be constructed from different\n    combinations of fundamental numeric types.\n\n    Parameters\n    ----------\n    dtype\n        Object to be converted to a data type object.\n    align : bool, optional\n        Add padding to the fields to match what a C compiler would output\n        for a similar C-struct. Can be ``True`` only if `obj` is a dictionary\n        or a comma-separated string. If a struct dtype is being created,\n        this also sets a sticky alignment flag ``isalignedstruct``.\n    copy : bool, optional\n        Make a new copy of the data-type object. If ``False``, the result\n        may just be a reference to a built-in data-type object.\n    metadata : dict, optional\n        An optional dictionary with dtype metadata.\n\n    See also\n    --------\n    result_type\n\n    Examples\n    --------\n    Using array-scalar type:\n\n    >>> np.dtype(np.int16)\n    dtype(\'int16\')\n\n    Structured type, one field name \'f1\', containing int16:\n\n    >>> np.dtype([(\'f1\', np.int16)])\n    dtype([(\'f1\', \'<i2\')])\n\n    Structured type, one field named \'f1\', in itself containing a structured\n    type with one field:\n\n    >>> np.dtype([(\'f1\', [(\'f1\', np.int16)])])\n    dtype([(\'f1\', [(\'f1\', \'<i2\')])])\n\n    Structured type, two fields: the first field contains an unsigned int, the\n    second an int32:\n\n    >>> np.dtype([(\'f1\', np.uint64), (\'f2\', np.int32)])\n    dtype([(\'f1\', \'<u8\'), (\'f2\', \'<i4\')])\n\n    Using array-protocol type strings:\n\n    >>> np.dtype([(\'a\',\'f8\'),(\'b\',\'S10\')])\n    dtype([(\'a\', \'<f8\'), (\'b\', \'S10\')])\n\n    Using comma-separated field formats.  The shape is (2,3):\n\n    >>> np.dtype("i4, (2,3)f8")\n    dtype([(\'f0\', \'<i4\'), (\'f1\', \'<f8\', (2, 3))])\n\n    Using tuples.  ``int`` is a fixed type, 3 the field\'s shape.  ``void``\n    is a flexible type, here of size 10:\n\n    >>> np.dtype([(\'hello\',(np.int64,3)),(\'world\',np.void,10)])\n    dtype([(\'hello\', \'<i8\', (3,)), (\'world\', \'V10\')])\n\n    Subdivide ``int16`` into 2 ``int8``\'s, called x and y.  0 and 1 are\n    the offsets in bytes:\n\n    >>> np.dtype((np.int16, {\'x\':(np.int8,0), \'y\':(np.int8,1)}))\n    dtype((numpy.int16, [(\'x\', \'i1\'), (\'y\', \'i1\')]))\n\n    Using dictionaries.  Two fields named \'gender\' and \'age\':\n\n    >>> np.dtype({\'names\':[\'gender\',\'age\'], \'formats\':[\'S1\',np.uint8]})\n    dtype([(\'gender\', \'S1\'), (\'age\', \'u1\')])\n\n    Offsets in bytes, here 0 and 25:\n\n    >>> np.dtype({\'surname\':(\'S25\',0),\'age\':(np.uint8,25)})\n    dtype([(\'surname\', \'S25\'), (\'age\', \'u1\')])'
    def __bool__(self) -> bool:
        'True if self else False'
        ...
    
    __class__ = _mod_numpy._DTypeMeta
    @classmethod
    def __class_getitem__(cls, item) -> typing.Any:
        '    Return a parametrized wrapper around the `~numpy.dtype` type.\n\n    .. versionadded:: 1.22\n\n    Returns\n    -------\n    alias : types.GenericAlias\n        A parametrized `~numpy.dtype` type.\n\n    Examples\n    --------\n    >>> import numpy as np\n\n    >>> np.dtype[np.int64]\n    numpy.dtype[numpy.int64]\n\n    See Also\n    --------\n    :pep:`585` : Type hinting generics in standard collections.'
        ...
    
    def __eq__(self, value) -> bool:
        'Return self==value.'
        ...
    
    def __ge__(self, value) -> bool:
        'Return self>=value.'
        ...
    
    def __getitem__(self, key) -> typing.Any:
        'Return self[key].'
        ...
    
    def __gt__(self, value) -> bool:
        'Return self>value.'
        ...
    
    def __hash__(self) -> int:
        'Return hash(self).'
        ...
    
    def __init__(self, dtype, align=..., copy=..., metadata=...) -> None:
        'dtype(dtype, align=False, copy=False, [metadata])\n\n    Create a data type object.\n\n    A numpy array is homogeneous, and contains elements described by a\n    dtype object. A dtype object can be constructed from different\n    combinations of fundamental numeric types.\n\n    Parameters\n    ----------\n    dtype\n        Object to be converted to a data type object.\n    align : bool, optional\n        Add padding to the fields to match what a C compiler would output\n        for a similar C-struct. Can be ``True`` only if `obj` is a dictionary\n        or a comma-separated string. If a struct dtype is being created,\n        this also sets a sticky alignment flag ``isalignedstruct``.\n    copy : bool, optional\n        Make a new copy of the data-type object. If ``False``, the result\n        may just be a reference to a built-in data-type object.\n    metadata : dict, optional\n        An optional dictionary with dtype metadata.\n\n    See also\n    --------\n    result_type\n\n    Examples\n    --------\n    Using array-scalar type:\n\n    >>> np.dtype(np.int16)\n    dtype(\'int16\')\n\n    Structured type, one field name \'f1\', containing int16:\n\n    >>> np.dtype([(\'f1\', np.int16)])\n    dtype([(\'f1\', \'<i2\')])\n\n    Structured type, one field named \'f1\', in itself containing a structured\n    type with one field:\n\n    >>> np.dtype([(\'f1\', [(\'f1\', np.int16)])])\n    dtype([(\'f1\', [(\'f1\', \'<i2\')])])\n\n    Structured type, two fields: the first field contains an unsigned int, the\n    second an int32:\n\n    >>> np.dtype([(\'f1\', np.uint64), (\'f2\', np.int32)])\n    dtype([(\'f1\', \'<u8\'), (\'f2\', \'<i4\')])\n\n    Using array-protocol type strings:\n\n    >>> np.dtype([(\'a\',\'f8\'),(\'b\',\'S10\')])\n    dtype([(\'a\', \'<f8\'), (\'b\', \'S10\')])\n\n    Using comma-separated field formats.  The shape is (2,3):\n\n    >>> np.dtype("i4, (2,3)f8")\n    dtype([(\'f0\', \'<i4\'), (\'f1\', \'<f8\', (2, 3))])\n\n    Using tuples.  ``int`` is a fixed type, 3 the field\'s shape.  ``void``\n    is a flexible type, here of size 10:\n\n    >>> np.dtype([(\'hello\',(np.int64,3)),(\'world\',np.void,10)])\n    dtype([(\'hello\', \'<i8\', (3,)), (\'world\', \'V10\')])\n\n    Subdivide ``int16`` into 2 ``int8``\'s, called x and y.  0 and 1 are\n    the offsets in bytes:\n\n    >>> np.dtype((np.int16, {\'x\':(np.int8,0), \'y\':(np.int8,1)}))\n    dtype((numpy.int16, [(\'x\', \'i1\'), (\'y\', \'i1\')]))\n\n    Using dictionaries.  Two fields named \'gender\' and \'age\':\n\n    >>> np.dtype({\'names\':[\'gender\',\'age\'], \'formats\':[\'S1\',np.uint8]})\n    dtype([(\'gender\', \'S1\'), (\'age\', \'u1\')])\n\n    Offsets in bytes, here 0 and 25:\n\n    >>> np.dtype({\'surname\':(\'S25\',0),\'age\':(np.uint8,25)})\n    dtype([(\'surname\', \'S25\'), (\'age\', \'u1\')])'
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    def __le__(self, value) -> bool:
        'Return self<=value.'
        ...
    
    def __len__(self) -> int:
        'Return len(self).'
        ...
    
    def __lt__(self, value) -> bool:
        'Return self<value.'
        ...
    
    def __mul__(self, value) -> dtype:
        'Return self*value.'
        ...
    
    def __ne__(self, value) -> bool:
        'Return self!=value.'
        ...
    
    def __reduce__(self) -> typing.Union[str, typing.Tuple[typing.Any, ...]]:
        ...
    
    def __repr__(self) -> str:
        'Return repr(self).'
        ...
    
    def __rmul__(self, value) -> dtype:
        'Return value*self.'
        ...
    
    def __setstate__(self, state: typing.Any) -> None:
        ...
    
    def __str__(self) -> str:
        'Return str(self).'
        ...
    
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    @property
    def alignment(self) -> typing.Any:
        "The required alignment (bytes) of this data-type according to the compiler.\n\n    More information is available in the C-API section of the manual.\n\n    Examples\n    --------\n\n    >>> x = np.dtype('i4')\n    >>> x.alignment\n    4\n\n    >>> x = np.dtype(float)\n    >>> x.alignment\n    8"
        ...
    
    @property
    def base(self) -> typing.Any:
        "Returns dtype for the base element of the subarrays,\n    regardless of their dimension or shape.\n\n    See Also\n    --------\n    dtype.subdtype\n\n    Examples\n    --------\n    >>> x = numpy.dtype('8f')\n    >>> x.base\n    dtype('float32')\n\n    >>> x =  numpy.dtype('i2')\n    >>> x.base\n    dtype('int16')"
        ...
    
    @property
    def byteorder(self) -> typing.Any:
        "A character indicating the byte-order of this data-type object.\n\n    One of:\n\n    ===  ==============\n    '='  native\n    '<'  little-endian\n    '>'  big-endian\n    '|'  not applicable\n    ===  ==============\n\n    All built-in data-type objects have byteorder either '=' or '|'.\n\n    Examples\n    --------\n\n    >>> dt = np.dtype('i2')\n    >>> dt.byteorder\n    '='\n    >>> # endian is not relevant for 8 bit numbers\n    >>> np.dtype('i1').byteorder\n    '|'\n    >>> # or ASCII strings\n    >>> np.dtype('S2').byteorder\n    '|'\n    >>> # Even if specific code is given, and it is native\n    >>> # '=' is the byteorder\n    >>> import sys\n    >>> sys_is_le = sys.byteorder == 'little'\n    >>> native_code = '<' if sys_is_le else '>'\n    >>> swapped_code = '>' if sys_is_le else '<'\n    >>> dt = np.dtype(native_code + 'i2')\n    >>> dt.byteorder\n    '='\n    >>> # Swapped code shows up as itself\n    >>> dt = np.dtype(swapped_code + 'i2')\n    >>> dt.byteorder == swapped_code\n    True"
        ...
    
    @property
    def char(self) -> typing.Any:
        "A unique character code for each of the 21 different built-in types.\n\n    Examples\n    --------\n\n    >>> x = np.dtype(float)\n    >>> x.char\n    'd'"
        ...
    
    @property
    def descr(self) -> typing.Any:
        "`__array_interface__` description of the data-type.\n\n    The format is that required by the 'descr' key in the\n    `__array_interface__` attribute.\n\n    Warning: This attribute exists specifically for `__array_interface__`,\n    and passing it directly to `np.dtype` will not accurately reconstruct\n    some dtypes (e.g., scalar and subarray dtypes).\n\n    Examples\n    --------\n\n    >>> x = np.dtype(float)\n    >>> x.descr\n    [('', '<f8')]\n\n    >>> dt = np.dtype([('name', np.str_, 16), ('grades', np.float64, (2,))])\n    >>> dt.descr\n    [('name', '<U16'), ('grades', '<f8', (2,))]"
        ...
    
    @property
    def fields(self) -> typing.Any:
        "Dictionary of named fields defined for this data type, or ``None``.\n\n    The dictionary is indexed by keys that are the names of the fields.\n    Each entry in the dictionary is a tuple fully describing the field::\n\n      (dtype, offset[, title])\n\n    Offset is limited to C int, which is signed and usually 32 bits.\n    If present, the optional title can be any object (if it is a string\n    or unicode then it will also be a key in the fields dictionary,\n    otherwise it's meta-data). Notice also that the first two elements\n    of the tuple can be passed directly as arguments to the ``ndarray.getfield``\n    and ``ndarray.setfield`` methods.\n\n    See Also\n    --------\n    ndarray.getfield, ndarray.setfield\n\n    Examples\n    --------\n    >>> dt = np.dtype([('name', np.str_, 16), ('grades', np.float64, (2,))])\n    >>> print(dt.fields)\n    {'grades': (dtype(('float64',(2,))), 16), 'name': (dtype('|S16'), 0)}"
        ...
    
    @property
    def flags(self) -> typing.Any:
        "Bit-flags describing how this data type is to be interpreted.\n\n    Bit-masks are in `numpy.core.multiarray` as the constants\n    `ITEM_HASOBJECT`, `LIST_PICKLE`, `ITEM_IS_POINTER`, `NEEDS_INIT`,\n    `NEEDS_PYAPI`, `USE_GETITEM`, `USE_SETITEM`. A full explanation\n    of these flags is in C-API documentation; they are largely useful\n    for user-defined data-types.\n\n    The following example demonstrates that operations on this particular\n    dtype requires Python C-API.\n\n    Examples\n    --------\n\n    >>> x = np.dtype([('a', np.int32, 8), ('b', np.float64, 6)])\n    >>> x.flags\n    16\n    >>> np.core.multiarray.NEEDS_PYAPI\n    16"
        ...
    
    @property
    def hasobject(self) -> typing.Any:
        "Boolean indicating whether this dtype contains any reference-counted\n    objects in any fields or sub-dtypes.\n\n    Recall that what is actually in the ndarray memory representing\n    the Python object is the memory address of that object (a pointer).\n    Special handling may be required, and this attribute is useful for\n    distinguishing data types that may contain arbitrary Python objects\n    and data-types that won't."
        ...
    
    @property
    def isalignedstruct(self) -> typing.Any:
        'Boolean indicating whether the dtype is a struct which maintains\n    field alignment. This flag is sticky, so when combining multiple\n    structs together, it is preserved and produces new dtypes which\n    are also aligned.'
        ...
    
    @property
    def isbuiltin(self) -> typing.Any:
        "Integer indicating how this dtype relates to the built-in dtypes.\n\n    Read-only.\n\n    =  ========================================================================\n    0  if this is a structured array type, with fields\n    1  if this is a dtype compiled into numpy (such as ints, floats etc)\n    2  if the dtype is for a user-defined numpy type\n       A user-defined type uses the numpy C-API machinery to extend\n       numpy to handle a new array type. See\n       :ref:`user.user-defined-data-types` in the NumPy manual.\n    =  ========================================================================\n\n    Examples\n    --------\n    >>> dt = np.dtype('i2')\n    >>> dt.isbuiltin\n    1\n    >>> dt = np.dtype('f8')\n    >>> dt.isbuiltin\n    1\n    >>> dt = np.dtype([('field1', 'f8')])\n    >>> dt.isbuiltin\n    0"
        ...
    
    @property
    def isnative(self) -> typing.Any:
        'Boolean indicating whether the byte order of this dtype is native\n    to the platform.'
        ...
    
    @property
    def itemsize(self) -> typing.Any:
        "The element size of this data-type object.\n\n    For 18 of the 21 types this number is fixed by the data-type.\n    For the flexible data-types, this number can be anything.\n\n    Examples\n    --------\n\n    >>> arr = np.array([[1, 2], [3, 4]])\n    >>> arr.dtype\n    dtype('int64')\n    >>> arr.itemsize\n    8\n\n    >>> dt = np.dtype([('name', np.str_, 16), ('grades', np.float64, (2,))])\n    >>> dt.itemsize\n    80"
        ...
    
    @property
    def kind(self) -> typing.Any:
        "A character code (one of 'biufcmMOSUV') identifying the general kind of data.\n\n    =  ======================\n    b  boolean\n    i  signed integer\n    u  unsigned integer\n    f  floating-point\n    c  complex floating-point\n    m  timedelta\n    M  datetime\n    O  object\n    S  (byte-)string\n    U  Unicode\n    V  void\n    =  ======================\n\n    Examples\n    --------\n\n    >>> dt = np.dtype('i4')\n    >>> dt.kind\n    'i'\n    >>> dt = np.dtype('f8')\n    >>> dt.kind\n    'f'\n    >>> dt = np.dtype([('field1', 'f8')])\n    >>> dt.kind\n    'V'"
        ...
    
    @property
    def metadata(self) -> typing.Any:
        'Either ``None`` or a readonly dictionary of metadata (mappingproxy).\n\n    The metadata field can be set using any dictionary at data-type\n    creation. NumPy currently has no uniform approach to propagating\n    metadata; although some array operations preserve it, there is no\n    guarantee that others will.\n\n    .. warning::\n\n        Although used in certain projects, this feature was long undocumented\n        and is not well supported. Some aspects of metadata propagation\n        are expected to change in the future.\n\n    Examples\n    --------\n\n    >>> dt = np.dtype(float, metadata={"key": "value"})\n    >>> dt.metadata["key"]\n    \'value\'\n    >>> arr = np.array([1, 2, 3], dtype=dt)\n    >>> arr.dtype.metadata\n    mappingproxy({\'key\': \'value\'})\n\n    Adding arrays with identical datatypes currently preserves the metadata:\n\n    >>> (arr + arr).dtype.metadata\n    mappingproxy({\'key\': \'value\'})\n\n    But if the arrays have different dtype metadata, the metadata may be\n    dropped:\n\n    >>> dt2 = np.dtype(float, metadata={"key2": "value2"})\n    >>> arr2 = np.array([3, 2, 1], dtype=dt2)\n    >>> (arr + arr2).dtype.metadata is None\n    True  # The metadata field is cleared so None is returned'
        ...
    
    @property
    def name(self) -> typing.Any:
        "A bit-width name for this data-type.\n\n    Un-sized flexible data-type objects do not have this attribute.\n\n    Examples\n    --------\n\n    >>> x = np.dtype(float)\n    >>> x.name\n    'float64'\n    >>> x = np.dtype([('a', np.int32, 8), ('b', np.float64, 6)])\n    >>> x.name\n    'void640'"
        ...
    
    @property
    def names(self) -> typing.Any:
        "Ordered list of field names, or ``None`` if there are no fields.\n\n    The names are ordered according to increasing byte offset. This can be\n    used, for example, to walk through all of the named fields in offset order.\n\n    Examples\n    --------\n    >>> dt = np.dtype([('name', np.str_, 16), ('grades', np.float64, (2,))])\n    >>> dt.names\n    ('name', 'grades')"
        ...
    
    @property
    def ndim(self) -> typing.Any:
        "Number of dimensions of the sub-array if this data type describes a\n    sub-array, and ``0`` otherwise.\n\n    .. versionadded:: 1.13.0\n\n    Examples\n    --------\n    >>> x = np.dtype(float)\n    >>> x.ndim\n    0\n\n    >>> x = np.dtype((float, 8))\n    >>> x.ndim\n    1\n\n    >>> x = np.dtype(('i4', (3, 4)))\n    >>> x.ndim\n    2"
        ...
    
    def newbyteorder(self, new_order=...) -> typing.Any:
        "    Return a new dtype with a different byte order.\n\n    Changes are also made in all fields and sub-arrays of the data type.\n\n    Parameters\n    ----------\n    new_order : string, optional\n        Byte order to force; a value from the byte order specifications\n        below.  The default value ('S') results in swapping the current\n        byte order.  `new_order` codes can be any of:\n\n        * 'S' - swap dtype from current to opposite endian\n        * {'<', 'little'} - little endian\n        * {'>', 'big'} - big endian\n        * {'=', 'native'} - native order\n        * {'|', 'I'} - ignore (no change to byte order)\n\n    Returns\n    -------\n    new_dtype : dtype\n        New dtype object with the given change to the byte order.\n\n    Notes\n    -----\n    Changes are also made in all fields and sub-arrays of the data type.\n\n    Examples\n    --------\n    >>> import sys\n    >>> sys_is_le = sys.byteorder == 'little'\n    >>> native_code = '<' if sys_is_le else '>'\n    >>> swapped_code = '>' if sys_is_le else '<'\n    >>> native_dt = np.dtype(native_code+'i2')\n    >>> swapped_dt = np.dtype(swapped_code+'i2')\n    >>> native_dt.newbyteorder('S') == swapped_dt\n    True\n    >>> native_dt.newbyteorder() == swapped_dt\n    True\n    >>> native_dt == swapped_dt.newbyteorder('S')\n    True\n    >>> native_dt == swapped_dt.newbyteorder('=')\n    True\n    >>> native_dt == swapped_dt.newbyteorder('N')\n    True\n    >>> native_dt == native_dt.newbyteorder('|')\n    True\n    >>> np.dtype('<i2') == native_dt.newbyteorder('<')\n    True\n    >>> np.dtype('<i2') == native_dt.newbyteorder('L')\n    True\n    >>> np.dtype('>i2') == native_dt.newbyteorder('>')\n    True\n    >>> np.dtype('>i2') == native_dt.newbyteorder('B')\n    True"
        ...
    
    @property
    def num(self) -> typing.Any:
        'A unique number for each of the 21 different built-in types.\n\n    These are roughly ordered from least-to-most precision.\n\n    Examples\n    --------\n\n    >>> dt = np.dtype(str)\n    >>> dt.num\n    19\n\n    >>> dt = np.dtype(float)\n    >>> dt.num\n    12'
        ...
    
    @property
    def shape(self) -> typing.Any:
        "Shape tuple of the sub-array if this data type describes a sub-array,\n    and ``()`` otherwise.\n\n    Examples\n    --------\n\n    >>> dt = np.dtype(('i4', 4))\n    >>> dt.shape\n    (4,)\n\n    >>> dt = np.dtype(('i4', (2, 3)))\n    >>> dt.shape\n    (2, 3)"
        ...
    
    @property
    def str(self) -> typing.Any:
        'The array-protocol typestring of this data-type object.'
        ...
    
    @property
    def subdtype(self) -> typing.Any:
        "Tuple ``(item_dtype, shape)`` if this `dtype` describes a sub-array, and\n    None otherwise.\n\n    The *shape* is the fixed shape of the sub-array described by this\n    data type, and *item_dtype* the data type of the array.\n\n    If a field whose dtype object has this attribute is retrieved,\n    then the extra dimensions implied by *shape* are tacked on to\n    the end of the retrieved array.\n\n    See Also\n    --------\n    dtype.base\n\n    Examples\n    --------\n    >>> x = numpy.dtype('8f')\n    >>> x.subdtype\n    (dtype('float32'), (8,))\n\n    >>> x =  numpy.dtype('i2')\n    >>> x.subdtype\n    >>>"
        ...
    
    type: typing.Any
    def __getattr__(self, name) -> typing.Any:
        ...
    

e: float
def empty(shape, dtype=..., order=..., *, like=...) -> typing.Any:
    "    Return a new array of given shape and type, without initializing entries.\n\n    Parameters\n    ----------\n    shape : int or tuple of int\n        Shape of the empty array, e.g., ``(2, 3)`` or ``2``.\n    dtype : data-type, optional\n        Desired output data-type for the array, e.g, `numpy.int8`. Default is\n        `numpy.float64`.\n    order : {'C', 'F'}, optional, default: 'C'\n        Whether to store multi-dimensional data in row-major\n        (C-style) or column-major (Fortran-style) order in\n        memory.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        Array of uninitialized (arbitrary) data of the given shape, dtype, and\n        order.  Object arrays will be initialized to None.\n\n    See Also\n    --------\n    empty_like : Return an empty array with shape and type of input.\n    ones : Return a new array setting values to one.\n    zeros : Return a new array setting values to zero.\n    full : Return a new array of given shape filled with value.\n\n\n    Notes\n    -----\n    `empty`, unlike `zeros`, does not set the array values to zero,\n    and may therefore be marginally faster.  On the other hand, it requires\n    the user to manually set all the values in the array, and should be\n    used with caution.\n\n    Examples\n    --------\n    >>> np.empty([2, 2])\n    array([[ -9.74499359e+001,   6.69583040e-309],\n           [  2.13182611e-314,   3.06959433e-309]])         #uninitialized\n\n    >>> np.empty([2, 2], dtype=int)\n    array([[-1073741821, -1067949133],\n           [  496041986,    19249760]])                     #uninitialized"
    ...

def empty_like(prototype, dtype=..., order=..., subok=..., shape=...) -> typing.Any:
    "    Return a new array with the same shape and type as a given array.\n\n    Parameters\n    ----------\n    prototype : array_like\n        The shape and data-type of `prototype` define these same attributes\n        of the returned array.\n    dtype : data-type, optional\n        Overrides the data type of the result.\n\n        .. versionadded:: 1.6.0\n    order : {'C', 'F', 'A', or 'K'}, optional\n        Overrides the memory layout of the result. 'C' means C-order,\n        'F' means F-order, 'A' means 'F' if `prototype` is Fortran\n        contiguous, 'C' otherwise. 'K' means match the layout of `prototype`\n        as closely as possible.\n\n        .. versionadded:: 1.6.0\n    subok : bool, optional.\n        If True, then the newly created array will use the sub-class\n        type of `prototype`, otherwise it will be a base-class array. Defaults\n        to True.\n    shape : int or sequence of ints, optional.\n        Overrides the shape of the result. If order='K' and the number of\n        dimensions is unchanged, will try to keep order, otherwise,\n        order='C' is implied.\n\n        .. versionadded:: 1.17.0\n\n    Returns\n    -------\n    out : ndarray\n        Array of uninitialized (arbitrary) data with the same\n        shape and type as `prototype`.\n\n    See Also\n    --------\n    ones_like : Return an array of ones with shape and type of input.\n    zeros_like : Return an array of zeros with shape and type of input.\n    full_like : Return a new array with shape of input filled with value.\n    empty : Return a new uninitialized array.\n\n    Notes\n    -----\n    This function does *not* initialize the returned array; to do that use\n    `zeros_like` or `ones_like` instead.  It may be marginally faster than\n    the functions that do set the array values.\n\n    Examples\n    --------\n    >>> a = ([1,2,3], [4,5,6])                         # a is array-like\n    >>> np.empty_like(a)\n    array([[-1073741821, -1073741821,           3],    # uninitialized\n           [          0,           0, -1073741821]])\n    >>> a = np.array([[1., 2., 3.],[4.,5.,6.]])\n    >>> np.empty_like(a)\n    array([[ -2.00000715e+000,   1.48219694e-323,  -2.00000572e+000], # uninitialized\n           [  4.38791518e-305,  -2.00000715e+000,   4.17269252e-309]])\n\n    "
    ...

def equal(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return (x1 == x2) element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array, element-wise comparison of `x1` and `x2`.\n    Typically of type bool, unless ``dtype=object`` is passed.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nnot_equal, greater_equal, less_equal, greater, less\n\nExamples\n--------\n>>> np.equal([0, 1, 3], np.arange(3))\narray([ True,  True, False])\n\nWhat is compared are values, not types. So an int (1) and an array of\nlength one can evaluate as True:\n\n>>> np.equal(1, np.ones(1))\narray([ True])\n\nThe ``==`` operator can be used as a shorthand for ``np.equal`` on\nndarrays.\n\n>>> a = np.array([2, 4, 6])\n>>> b = np.array([2, 4, 2])\n>>> a == b\narray([ True,  True, False])'
    ...

error = _mod_builtins.Exception
euler_gamma: float
def exp(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Calculate the exponential of all elements in the input array.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array, element-wise exponential of `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nexpm1 : Calculate ``exp(x) - 1`` for all elements in the array.\nexp2  : Calculate ``2**x`` for all elements in the array.\n\nNotes\n-----\nThe irrational number ``e`` is also known as Euler\'s number.  It is\napproximately 2.718281, and is the base of the natural logarithm,\n``ln`` (this means that, if :math:`x = \\ln y = \\log_e y`,\nthen :math:`e^x = y`. For real input, ``exp(x)`` is always positive.\n\nFor complex arguments, ``x = a + ib``, we can write\n:math:`e^x = e^a e^{ib}`.  The first term, :math:`e^a`, is already\nknown (it is the real argument, described above).  The second term,\n:math:`e^{ib}`, is :math:`\\cos b + i \\sin b`, a function with\nmagnitude 1 and a periodic phase.\n\nReferences\n----------\n.. [1] Wikipedia, "Exponential function",\n       https://en.wikipedia.org/wiki/Exponential_function\n.. [2] M. Abramovitz and I. A. Stegun, "Handbook of Mathematical Functions\n       with Formulas, Graphs, and Mathematical Tables," Dover, 1964, p. 69,\n       https://personal.math.ubc.ca/~cbm/aands/page_69.htm\n\nExamples\n--------\nPlot the magnitude and phase of ``exp(x)`` in the complex plane:\n\n>>> import matplotlib.pyplot as plt\n\n>>> x = np.linspace(-2*np.pi, 2*np.pi, 100)\n>>> xx = x + 1j * x[:, np.newaxis] # a + ib over complex plane\n>>> out = np.exp(xx)\n\n>>> plt.subplot(121)\n>>> plt.imshow(np.abs(out),\n...            extent=[-2*np.pi, 2*np.pi, -2*np.pi, 2*np.pi], cmap=\'gray\')\n>>> plt.title(\'Magnitude of exp(x)\')\n\n>>> plt.subplot(122)\n>>> plt.imshow(np.angle(out),\n...            extent=[-2*np.pi, 2*np.pi, -2*np.pi, 2*np.pi], cmap=\'hsv\')\n>>> plt.title(\'Phase (angle) of exp(x)\')\n>>> plt.show()'
    ...

def exp2(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Calculate `2**p` for all `p` in the input array.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Element-wise 2 to the power `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\npower\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\n\n\nExamples\n--------\n>>> np.exp2([2, 3])\narray([ 4.,  8.])'
    ...

def expm1(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Calculate ``exp(x) - 1`` for all elements in the array.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Element-wise exponential minus one: ``out = exp(x) - 1``.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nlog1p : ``log(1 + x)``, the inverse of expm1.\n\n\nNotes\n-----\nThis function provides greater precision than ``exp(x) - 1``\nfor small values of ``x``.\n\nExamples\n--------\nThe true value of ``exp(1e-10) - 1`` is ``1.00000000005e-10`` to\nabout 32 significant digits. This example shows the superiority of\nexpm1 in this case.\n\n>>> np.expm1(1e-10)\n1.00000000005e-10\n>>> np.exp(1e-10) - 1\n1.000000082740371e-10'
    ...

def fabs(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute the absolute values element-wise.\n\nThis function returns the absolute values (positive magnitude) of the\ndata in `x`. Complex values are not handled, use `absolute` to find the\nabsolute values of complex data.\n\nParameters\n----------\nx : array_like\n    The array of numbers for which the absolute values are required. If\n    `x` is a scalar, the result `y` will also be a scalar.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The absolute values of `x`, the returned values are always floats.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nabsolute : Absolute values including `complex` types.\n\nExamples\n--------\n>>> np.fabs(-1)\n1.0\n>>> np.fabs([-1.2, 1.2])\narray([ 1.2,  1.2])'
    ...

def fastCopyAndTranspose(a) -> typing.Any:
    '    .. deprecated:: 1.24\n\n       fastCopyAndTranspose is deprecated and will be removed. Use the copy and\n       transpose methods instead, e.g. ``arr.T.copy()``'
    ...

flagsobj = _mod_numpy_core_multiarray.flagsobj
class flatiter(_mod_builtins.object):
    "Flat iterator object to iterate over arrays.\n\n    A `flatiter` iterator is returned by ``x.flat`` for any array `x`.\n    It allows iterating over the array as if it were a 1-D array,\n    either in a for-loop or by calling its `next` method.\n\n    Iteration is done in row-major, C-style order (the last\n    index varying the fastest). The iterator can also be indexed using\n    basic slicing or advanced indexing.\n\n    See Also\n    --------\n    ndarray.flat : Return a flat iterator over an array.\n    ndarray.flatten : Returns a flattened copy of an array.\n\n    Notes\n    -----\n    A `flatiter` iterator can not be constructed directly from Python code\n    by calling the `flatiter` constructor.\n\n    Examples\n    --------\n    >>> x = np.arange(6).reshape(2, 3)\n    >>> fl = x.flat\n    >>> type(fl)\n    <class 'numpy.flatiter'>\n    >>> for item in fl:\n    ...     print(item)\n    ...\n    0\n    1\n    2\n    3\n    4\n    5\n\n    >>> fl[2:4]\n    array([2, 3])"
    def __array__(self, type=...) -> typing.Any:
        ...
    
    def __delitem__(self, key) -> None:
        'Delete self[key].'
        ...
    
    def __eq__(self, value) -> bool:
        'Return self==value.'
        ...
    
    def __ge__(self, value) -> bool:
        'Return self>=value.'
        ...
    
    def __getitem__(self, key) -> typing.Any:
        'Return self[key].'
        ...
    
    def __gt__(self, value) -> bool:
        'Return self>value.'
        ...
    
    __hash__: typing.Any
    def __init__(self, *args, **kwargs) -> None:
        "Flat iterator object to iterate over arrays.\n\n    A `flatiter` iterator is returned by ``x.flat`` for any array `x`.\n    It allows iterating over the array as if it were a 1-D array,\n    either in a for-loop or by calling its `next` method.\n\n    Iteration is done in row-major, C-style order (the last\n    index varying the fastest). The iterator can also be indexed using\n    basic slicing or advanced indexing.\n\n    See Also\n    --------\n    ndarray.flat : Return a flat iterator over an array.\n    ndarray.flatten : Returns a flattened copy of an array.\n\n    Notes\n    -----\n    A `flatiter` iterator can not be constructed directly from Python code\n    by calling the `flatiter` constructor.\n\n    Examples\n    --------\n    >>> x = np.arange(6).reshape(2, 3)\n    >>> fl = x.flat\n    >>> type(fl)\n    <class 'numpy.flatiter'>\n    >>> for item in fl:\n    ...     print(item)\n    ...\n    0\n    1\n    2\n    3\n    4\n    5\n\n    >>> fl[2:4]\n    array([2, 3])"
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    def __iter__(self) -> flatiter:
        'Implement iter(self).'
        ...
    
    def __le__(self, value) -> bool:
        'Return self<=value.'
        ...
    
    def __len__(self) -> int:
        'Return len(self).'
        ...
    
    def __lt__(self, value) -> bool:
        'Return self<value.'
        ...
    
    def __ne__(self, value) -> bool:
        'Return self!=value.'
        ...
    
    def __next__(self) -> typing.Any:
        'Implement next(self).'
        ...
    
    def __setitem__(self, key, value) -> None:
        'Set self[key] to value.'
        ...
    
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    @property
    def base(self) -> typing.Any:
        'A reference to the array that is iterated over.\n\n    Examples\n    --------\n    >>> x = np.arange(5)\n    >>> fl = x.flat\n    >>> fl.base is x\n    True'
        ...
    
    @property
    def coords(self) -> typing.Any:
        'An N-dimensional tuple of current coordinates.\n\n    Examples\n    --------\n    >>> x = np.arange(6).reshape(2, 3)\n    >>> fl = x.flat\n    >>> fl.coords\n    (0, 0)\n    >>> next(fl)\n    0\n    >>> fl.coords\n    (0, 1)'
        ...
    
    def copy(self) -> typing.Any:
        '    Get a copy of the iterator as a 1-D array.\n\n    Examples\n    --------\n    >>> x = np.arange(6).reshape(2, 3)\n    >>> x\n    array([[0, 1, 2],\n           [3, 4, 5]])\n    >>> fl = x.flat\n    >>> fl.copy()\n    array([0, 1, 2, 3, 4, 5])'
        ...
    
    @property
    def index(self) -> typing.Any:
        'Current flat index into the array.\n\n    Examples\n    --------\n    >>> x = np.arange(6).reshape(2, 3)\n    >>> fl = x.flat\n    >>> fl.index\n    0\n    >>> next(fl)\n    0\n    >>> fl.index\n    1'
        ...
    
    def __getattr__(self, name) -> typing.Any:
        ...
    

def float_power(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "First array elements raised to powers from second array, element-wise.\n\nRaise each base in `x1` to the positionally-corresponding power in `x2`.\n`x1` and `x2` must be broadcastable to the same shape. This differs from\nthe power function in that integers, float16, and float32  are promoted to\nfloats with a minimum precision of float64 so that the result is always\ninexact.  The intent is that the function will return a usable result for\nnegative powers and seldom overflow for positive powers.\n\nNegative values raised to a non-integral value will return ``nan``.\nTo get complex results, cast the input to complex, or specify the\n``dtype`` to be ``complex`` (see the example below).\n\n.. versionadded:: 1.12.0\n\nParameters\n----------\nx1 : array_like\n    The bases.\nx2 : array_like\n    The exponents.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The bases in `x1` raised to the exponents in `x2`.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\npower : power function that preserves type\n\nExamples\n--------\nCube each element in a list.\n\n>>> x1 = range(6)\n>>> x1\n[0, 1, 2, 3, 4, 5]\n>>> np.float_power(x1, 3)\narray([   0.,    1.,    8.,   27.,   64.,  125.])\n\nRaise the bases to different exponents.\n\n>>> x2 = [1.0, 2.0, 3.0, 3.0, 2.0, 1.0]\n>>> np.float_power(x1, x2)\narray([  0.,   1.,   8.,  27.,  16.,   5.])\n\nThe effect of broadcasting.\n\n>>> x2 = np.array([[1, 2, 3, 3, 2, 1], [1, 2, 3, 3, 2, 1]])\n>>> x2\narray([[1, 2, 3, 3, 2, 1],\n       [1, 2, 3, 3, 2, 1]])\n>>> np.float_power(x1, x2)\narray([[  0.,   1.,   8.,  27.,  16.,   5.],\n       [  0.,   1.,   8.,  27.,  16.,   5.]])\n\nNegative values raised to a non-integral value will result in ``nan``\n(and a warning will be generated).\n\n>>> x3 = np.array([-1, -4])\n>>> with np.errstate(invalid='ignore'):\n...     p = np.float_power(x3, 1.5)\n...\n>>> p\narray([nan, nan])\n\nTo get complex results, give the argument ``dtype=complex``.\n\n>>> np.float_power(x3, 1.5, dtype=complex)\narray([-1.83697020e-16-1.j, -1.46957616e-15-8.j])"
    ...

def floor(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the floor of the input, element-wise.\n\nThe floor of the scalar `x` is the largest integer `i`, such that\n`i <= x`.  It is often denoted as :math:`\\lfloor x \\rfloor`.\n\nParameters\n----------\nx : array_like\n    Input data.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The floor of each element in `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nceil, trunc, rint, fix\n\nNotes\n-----\nSome spreadsheet programs calculate the "floor-towards-zero", where\n``floor(-2.5) == -2``.  NumPy instead uses the definition of\n`floor` where `floor(-2.5) == -3`. The "floor-towards-zero"\nfunction is called ``fix`` in NumPy.\n\nExamples\n--------\n>>> a = np.array([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0])\n>>> np.floor(a)\narray([-2., -2., -1.,  0.,  1.,  1.,  2.])'
    ...

def floor_divide(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the largest integer smaller or equal to the division of the inputs.\nIt is equivalent to the Python ``//`` operator and pairs with the\nPython ``%`` (`remainder`), function so that ``a = a % b + b * (a // b)``\nup to roundoff.\n\nParameters\n----------\nx1 : array_like\n    Numerator.\nx2 : array_like\n    Denominator.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    y = floor(`x1`/`x2`)\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nremainder : Remainder complementary to floor_divide.\ndivmod : Simultaneous floor division and remainder.\ndivide : Standard division.\nfloor : Round a number to the nearest integer toward minus infinity.\nceil : Round a number to the nearest integer toward infinity.\n\nExamples\n--------\n>>> np.floor_divide(7,3)\n2\n>>> np.floor_divide([1., 2., 3., 4.], 2.5)\narray([ 0.,  0.,  1.,  1.])\n\nThe ``//`` operator can be used as a shorthand for ``np.floor_divide``\non ndarrays.\n\n>>> x1 = np.array([1., 2., 3., 4.])\n>>> x1 // 2.5\narray([0., 0., 1., 1.])'
    ...

def fmax(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Element-wise maximum of array elements.\n\nCompare two arrays and return a new array containing the element-wise\nmaxima. If one of the elements being compared is a NaN, then the\nnon-nan element is returned. If both elements are NaNs then the first\nis returned.  The latter distinction is important for complex NaNs,\nwhich are defined as at least one of the real or imaginary parts being\na NaN. The net effect is that NaNs are ignored when possible.\n\nParameters\n----------\nx1, x2 : array_like\n    The arrays holding the elements to be compared.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The maximum of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfmin :\n    Element-wise minimum of two arrays, ignores NaNs.\nmaximum :\n    Element-wise maximum of two arrays, propagates NaNs.\namax :\n    The maximum value of an array along a given axis, propagates NaNs.\nnanmax :\n    The maximum value of an array along a given axis, ignores NaNs.\n\nminimum, amin, nanmin\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nThe fmax is equivalent to ``np.where(x1 >= x2, x1, x2)`` when neither\nx1 nor x2 are NaNs, but it is faster and does proper broadcasting.\n\nExamples\n--------\n>>> np.fmax([2, 3, 4], [1, 5, 2])\narray([ 2.,  5.,  4.])\n\n>>> np.fmax(np.eye(2), [0.5, 2])\narray([[ 1. ,  2. ],\n       [ 0.5,  2. ]])\n\n>>> np.fmax([np.nan, 0, np.nan],[0, np.nan, np.nan])\narray([ 0.,  0., nan])'
    ...

def fmin(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Element-wise minimum of array elements.\n\nCompare two arrays and return a new array containing the element-wise\nminima. If one of the elements being compared is a NaN, then the\nnon-nan element is returned. If both elements are NaNs then the first\nis returned.  The latter distinction is important for complex NaNs,\nwhich are defined as at least one of the real or imaginary parts being\na NaN. The net effect is that NaNs are ignored when possible.\n\nParameters\n----------\nx1, x2 : array_like\n    The arrays holding the elements to be compared.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The minimum of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfmax :\n    Element-wise maximum of two arrays, ignores NaNs.\nminimum :\n    Element-wise minimum of two arrays, propagates NaNs.\namin :\n    The minimum value of an array along a given axis, propagates NaNs.\nnanmin :\n    The minimum value of an array along a given axis, ignores NaNs.\n\nmaximum, amax, nanmax\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nThe fmin is equivalent to ``np.where(x1 <= x2, x1, x2)`` when neither\nx1 nor x2 are NaNs, but it is faster and does proper broadcasting.\n\nExamples\n--------\n>>> np.fmin([2, 3, 4], [1, 5, 2])\narray([1, 3, 2])\n\n>>> np.fmin(np.eye(2), [0.5, 2])\narray([[ 0.5,  0. ],\n       [ 0. ,  1. ]])\n\n>>> np.fmin([np.nan, 0, np.nan],[0, np.nan, np.nan])\narray([ 0.,  0., nan])'
    ...

def fmod(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Returns the element-wise remainder of division.\n\nThis is the NumPy implementation of the C library function fmod, the\nremainder has the same sign as the dividend `x1`. It is equivalent to\nthe Matlab(TM) ``rem`` function and should not be confused with the\nPython modulus operator ``x1 % x2``.\n\nParameters\n----------\nx1 : array_like\n    Dividend.\nx2 : array_like\n    Divisor.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : array_like\n    The remainder of the division of `x1` by `x2`.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nremainder : Equivalent to the Python ``%`` operator.\ndivide\n\nNotes\n-----\nThe result of the modulo operation for negative dividend and divisors\nis bound by conventions. For `fmod`, the sign of result is the sign of\nthe dividend, while for `remainder` the sign of the result is the sign\nof the divisor. The `fmod` function is equivalent to the Matlab(TM)\n``rem`` function.\n\nExamples\n--------\n>>> np.fmod([-3, -2, -1, 1, 2, 3], 2)\narray([-1,  0, -1,  1,  0,  1])\n>>> np.remainder([-3, -2, -1, 1, 2, 3], 2)\narray([1, 0, 1, 1, 0, 1])\n\n>>> np.fmod([5, 3], [2, 2.])\narray([ 1.,  1.])\n>>> a = np.arange(-3, 3).reshape(3, 2)\n>>> a\narray([[-3, -2],\n       [-1,  0],\n       [ 1,  2]])\n>>> np.fmod(a, [2,2])\narray([[-1,  0],\n       [-1,  0],\n       [ 1,  0]])'
    ...

def format_longfloat() -> typing.Any:
    ...

def frexp(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Decompose the elements of x into mantissa and twos exponent.\n\nReturns (`mantissa`, `exponent`), where ``x = mantissa * 2**exponent``.\nThe mantissa lies in the open interval(-1, 1), while the twos\nexponent is a signed integer.\n\nParameters\n----------\nx : array_like\n    Array of numbers to be decomposed.\nout1 : ndarray, optional\n    Output array for the mantissa. Must have the same shape as `x`.\nout2 : ndarray, optional\n    Output array for the exponent. Must have the same shape as `x`.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nmantissa : ndarray\n    Floating values between -1 and 1.\n    This is a scalar if `x` is a scalar.\nexponent : ndarray\n    Integer exponents of 2.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nldexp : Compute ``y = x1 * 2**x2``, the inverse of `frexp`.\n\nNotes\n-----\nComplex dtypes are not supported, they will raise a TypeError.\n\nExamples\n--------\n>>> x = np.arange(9)\n>>> y1, y2 = np.frexp(x)\n>>> y1\narray([ 0.   ,  0.5  ,  0.5  ,  0.75 ,  0.5  ,  0.625,  0.75 ,  0.875,\n        0.5  ])\n>>> y2\narray([0, 1, 2, 2, 3, 3, 3, 3, 4])\n>>> y1 * 2**y2\narray([ 0.,  1.,  2.,  3.,  4.,  5.,  6.,  7.,  8.])'
    ...

def from_dlpack(x) -> typing.Any:
    '    Create a NumPy array from an object implementing the ``__dlpack__``\n    protocol. Generally, the returned NumPy array is a read-only view\n    of the input object. See [1]_ and [2]_ for more details.\n\n    Parameters\n    ----------\n    x : object\n        A Python object that implements the ``__dlpack__`` and\n        ``__dlpack_device__`` methods.\n\n    Returns\n    -------\n    out : ndarray\n\n    References\n    ----------\n    .. [1] Array API documentation,\n       https://data-apis.org/array-api/latest/design_topics/data_interchange.html#syntax-for-data-interchange-with-dlpack\n\n    .. [2] Python specification for DLPack,\n       https://dmlc.github.io/dlpack/latest/python_spec.html\n\n    Examples\n    --------\n    >>> import torch\n    >>> x = torch.arange(10)\n    >>> # create a view of the torch tensor "x" in NumPy\n    >>> y = np.from_dlpack(x)'
    ...

def frombuffer(buffer, dtype=..., count=..., offset=..., *, like=...) -> typing.Any:
    "    Interpret a buffer as a 1-dimensional array.\n\n    Parameters\n    ----------\n    buffer : buffer_like\n        An object that exposes the buffer interface.\n    dtype : data-type, optional\n        Data-type of the returned array; default: float.\n    count : int, optional\n        Number of items to read. ``-1`` means all data in the buffer.\n    offset : int, optional\n        Start reading the buffer from this offset (in bytes); default: 0.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n\n    See also\n    --------\n    ndarray.tobytes\n        Inverse of this operation, construct Python bytes from the raw data\n        bytes in the array.\n\n    Notes\n    -----\n    If the buffer has data that is not in machine byte-order, this should\n    be specified as part of the data-type, e.g.::\n\n      >>> dt = np.dtype(int)\n      >>> dt = dt.newbyteorder('>')\n      >>> np.frombuffer(buf, dtype=dt) # doctest: +SKIP\n\n    The data of the resulting array will not be byteswapped, but will be\n    interpreted correctly.\n\n    This function creates a view into the original object.  This should be safe\n    in general, but it may make sense to copy the result when the original\n    object is mutable or untrusted.\n\n    Examples\n    --------\n    >>> s = b'hello world'\n    >>> np.frombuffer(s, dtype='S1', count=5, offset=6)\n    array([b'w', b'o', b'r', b'l', b'd'], dtype='|S1')\n\n    >>> np.frombuffer(b'\\x01\\x02', dtype=np.uint8)\n    array([1, 2], dtype=uint8)\n    >>> np.frombuffer(b'\\x01\\x02\\x03\\x04\\x05', dtype=np.uint8, count=3)\n    array([1, 2, 3], dtype=uint8)"
    ...

def fromfile(file, dtype=..., count=..., sep=..., offset=..., *, like=...) -> typing.Any:
    '    Construct an array from data in a text or binary file.\n\n    A highly efficient way of reading binary data with a known data-type,\n    as well as parsing simply formatted text files.  Data written using the\n    `tofile` method can be read using this function.\n\n    Parameters\n    ----------\n    file : file or str or Path\n        Open file object or filename.\n\n        .. versionchanged:: 1.17.0\n            `pathlib.Path` objects are now accepted.\n\n    dtype : data-type\n        Data type of the returned array.\n        For binary files, it is used to determine the size and byte-order\n        of the items in the file.\n        Most builtin numeric types are supported and extension types may be supported.\n\n        .. versionadded:: 1.18.0\n            Complex dtypes.\n\n    count : int\n        Number of items to read. ``-1`` means all items (i.e., the complete\n        file).\n    sep : str\n        Separator between items if file is a text file.\n        Empty ("") separator means the file should be treated as binary.\n        Spaces (" ") in the separator match zero or more whitespace characters.\n        A separator consisting only of spaces must match at least one\n        whitespace.\n    offset : int\n        The offset (in bytes) from the file\'s current position. Defaults to 0.\n        Only permitted for binary files.\n\n        .. versionadded:: 1.17.0\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    See also\n    --------\n    load, save\n    ndarray.tofile\n    loadtxt : More flexible way of loading data from a text file.\n\n    Notes\n    -----\n    Do not rely on the combination of `tofile` and `fromfile` for\n    data storage, as the binary files generated are not platform\n    independent.  In particular, no byte-order or data-type information is\n    saved.  Data can be stored in the platform independent ``.npy`` format\n    using `save` and `load` instead.\n\n    Examples\n    --------\n    Construct an ndarray:\n\n    >>> dt = np.dtype([(\'time\', [(\'min\', np.int64), (\'sec\', np.int64)]),\n    ...                (\'temp\', float)])\n    >>> x = np.zeros((1,), dtype=dt)\n    >>> x[\'time\'][\'min\'] = 10; x[\'temp\'] = 98.25\n    >>> x\n    array([((10, 0), 98.25)],\n          dtype=[(\'time\', [(\'min\', \'<i8\'), (\'sec\', \'<i8\')]), (\'temp\', \'<f8\')])\n\n    Save the raw data to disk:\n\n    >>> import tempfile\n    >>> fname = tempfile.mkstemp()[1]\n    >>> x.tofile(fname)\n\n    Read the raw data from disk:\n\n    >>> np.fromfile(fname, dtype=dt)\n    array([((10, 0), 98.25)],\n          dtype=[(\'time\', [(\'min\', \'<i8\'), (\'sec\', \'<i8\')]), (\'temp\', \'<f8\')])\n\n    The recommended way to store and load data:\n\n    >>> np.save(fname, x)\n    >>> np.load(fname + \'.npy\')\n    array([((10, 0), 98.25)],\n          dtype=[(\'time\', [(\'min\', \'<i8\'), (\'sec\', \'<i8\')]), (\'temp\', \'<f8\')])'
    ...

def fromiter(iter, dtype, count=..., *, like=...) -> typing.Any:
    '    Create a new 1-dimensional array from an iterable object.\n\n    Parameters\n    ----------\n    iter : iterable object\n        An iterable object providing data for the array.\n    dtype : data-type\n        The data-type of the returned array.\n\n        .. versionchanged:: 1.23\n            Object and subarray dtypes are now supported (note that the final\n            result is not 1-D for a subarray dtype).\n\n    count : int, optional\n        The number of items to read from *iterable*.  The default is -1,\n        which means all data is read.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        The output array.\n\n    Notes\n    -----\n    Specify `count` to improve performance.  It allows ``fromiter`` to\n    pre-allocate the output array, instead of resizing it on demand.\n\n    Examples\n    --------\n    >>> iterable = (x*x for x in range(5))\n    >>> np.fromiter(iterable, float)\n    array([  0.,   1.,   4.,   9.,  16.])\n\n    A carefully constructed subarray dtype will lead to higher dimensional\n    results:\n\n    >>> iterable = ((x+1, x+2) for x in range(5))\n    >>> np.fromiter(iterable, dtype=np.dtype((int, 2)))\n    array([[1, 2],\n           [2, 3],\n           [3, 4],\n           [4, 5],\n           [5, 6]])'
    ...

def frompyfunc(func, nin, nout, *, identity=...) -> typing.Any:
    "    Takes an arbitrary Python function and returns a NumPy ufunc.\n\n    Can be used, for example, to add broadcasting to a built-in Python\n    function (see Examples section).\n\n    Parameters\n    ----------\n    func : Python function object\n        An arbitrary Python function.\n    nin : int\n        The number of input arguments.\n    nout : int\n        The number of objects returned by `func`.\n    identity : object, optional\n        The value to use for the `~numpy.ufunc.identity` attribute of the resulting\n        object. If specified, this is equivalent to setting the underlying\n        C ``identity`` field to ``PyUFunc_IdentityValue``.\n        If omitted, the identity is set to ``PyUFunc_None``. Note that this is\n        _not_ equivalent to setting the identity to ``None``, which implies the\n        operation is reorderable.\n\n    Returns\n    -------\n    out : ufunc\n        Returns a NumPy universal function (``ufunc``) object.\n\n    See Also\n    --------\n    vectorize : Evaluates pyfunc over input arrays using broadcasting rules of numpy.\n\n    Notes\n    -----\n    The returned ufunc always returns PyObject arrays.\n\n    Examples\n    --------\n    Use frompyfunc to add broadcasting to the Python function ``oct``:\n\n    >>> oct_array = np.frompyfunc(oct, 1, 1)\n    >>> oct_array(np.array((10, 30, 100)))\n    array(['0o12', '0o36', '0o144'], dtype=object)\n    >>> np.array((oct(10), oct(30), oct(100))) # for comparison\n    array(['0o12', '0o36', '0o144'], dtype='<U5')"
    ...

def fromstring(string, dtype=..., count=..., *, sep=..., like=...) -> typing.Any:
    "    A new 1-D array initialized from text data in a string.\n\n    Parameters\n    ----------\n    string : str\n        A string containing the data.\n    dtype : data-type, optional\n        The data type of the array; default: float.  For binary input data,\n        the data must be in exactly this format. Most builtin numeric types are\n        supported and extension types may be supported.\n\n        .. versionadded:: 1.18.0\n            Complex dtypes.\n\n    count : int, optional\n        Read this number of `dtype` elements from the data.  If this is\n        negative (the default), the count will be determined from the\n        length of the data.\n    sep : str, optional\n        The string separating numbers in the data; extra whitespace between\n        elements is also ignored.\n\n        .. deprecated:: 1.14\n            Passing ``sep=''``, the default, is deprecated since it will\n            trigger the deprecated binary mode of this function. This mode\n            interprets `string` as binary bytes, rather than ASCII text with\n            decimal numbers, an operation which is better spelt\n            ``frombuffer(string, dtype, count)``. If `string` contains unicode\n            text, the binary mode of `fromstring` will first encode it into\n            bytes using utf-8, which will not produce sane results.\n\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    arr : ndarray\n        The constructed array.\n\n    Raises\n    ------\n    ValueError\n        If the string is not the correct size to satisfy the requested\n        `dtype` and `count`.\n\n    See Also\n    --------\n    frombuffer, fromfile, fromiter\n\n    Examples\n    --------\n    >>> np.fromstring('1 2', dtype=int, sep=' ')\n    array([1, 2])\n    >>> np.fromstring('1, 2', dtype=int, sep=',')\n    array([1, 2])"
    ...

def gcd(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Returns the greatest common divisor of ``|x1|`` and ``|x2|``\n\nParameters\n----------\nx1, x2 : array_like, int\n    Arrays of values.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\n\nReturns\n-------\ny : ndarray or scalar\n    The greatest common divisor of the absolute value of the inputs\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlcm : The lowest common multiple\n\nExamples\n--------\n>>> np.gcd(12, 20)\n4\n>>> np.gcd.reduce([15, 25, 35])\n5\n>>> np.gcd(np.arange(6), 20)\narray([20,  1,  2,  1,  4,  5])'
    ...

def get_handler_name(a) -> str:
    '    Return the name of the memory handler used by `a`. If not provided, return\n    the name of the memory handler that will be used to allocate data for the\n    next `ndarray` in this context. May return None if `a` does not own its\n    memory, in which case you can traverse ``a.base`` for a memory handler.'
    ...

def get_handler_version(a) -> int:
    '    Return the version of the memory handler used by `a`. If not provided,\n    return the version of the memory handler that will be used to allocate data\n    for the next `ndarray` in this context. May return None if `a` does not own\n    its memory, in which case you can traverse ``a.base`` for a memory handler.'
    ...

def geterrobj() -> typing.Any:
    '    Return the current object that defines floating-point error handling.\n\n    The error object contains all information that defines the error handling\n    behavior in NumPy. `geterrobj` is used internally by the other\n    functions that get and set error handling behavior (`geterr`, `seterr`,\n    `geterrcall`, `seterrcall`).\n\n    Returns\n    -------\n    errobj : list\n        The error object, a list containing three elements:\n        [internal numpy buffer size, error mask, error callback function].\n\n        The error mask is a single integer that holds the treatment information\n        on all four floating point errors. The information for each error type\n        is contained in three bits of the integer. If we print it in base 8, we\n        can see what treatment is set for "invalid", "under", "over", and\n        "divide" (in that order). The printed string can be interpreted with\n\n        * 0 : \'ignore\'\n        * 1 : \'warn\'\n        * 2 : \'raise\'\n        * 3 : \'call\'\n        * 4 : \'print\'\n        * 5 : \'log\'\n\n    See Also\n    --------\n    seterrobj, seterr, geterr, seterrcall, geterrcall\n    getbufsize, setbufsize\n\n    Notes\n    -----\n    For complete documentation of the types of floating-point exceptions and\n    treatment options, see `seterr`.\n\n    Examples\n    --------\n    >>> np.geterrobj()  # first get the defaults\n    [8192, 521, None]\n\n    >>> def err_handler(type, flag):\n    ...     print("Floating point error (%s), with flag %s" % (type, flag))\n    ...\n    >>> old_bufsize = np.setbufsize(20000)\n    >>> old_err = np.seterr(divide=\'raise\')\n    >>> old_handler = np.seterrcall(err_handler)\n    >>> np.geterrobj()\n    [8192, 521, <function err_handler at 0x91dcaac>]\n\n    >>> old_err = np.seterr(all=\'ignore\')\n    >>> np.base_repr(np.geterrobj()[1], 8)\n    \'0\'\n    >>> old_err = np.seterr(divide=\'warn\', over=\'log\', under=\'call\',\n    ...                     invalid=\'print\')\n    >>> np.base_repr(np.geterrobj()[1], 8)\n    \'4351\''
    ...

def greater(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the truth value of (x1 > x2) element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array, element-wise comparison of `x1` and `x2`.\n    Typically of type bool, unless ``dtype=object`` is passed.\n    This is a scalar if both `x1` and `x2` are scalars.\n\n\nSee Also\n--------\ngreater_equal, less, less_equal, equal, not_equal\n\nExamples\n--------\n>>> np.greater([4,2],[2,2])\narray([ True, False])\n\nThe ``>`` operator can be used as a shorthand for ``np.greater`` on\nndarrays.\n\n>>> a = np.array([4, 2])\n>>> b = np.array([2, 2])\n>>> a > b\narray([ True, False])'
    ...

def greater_equal(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the truth value of (x1 >= x2) element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : bool or ndarray of bool\n    Output array, element-wise comparison of `x1` and `x2`.\n    Typically of type bool, unless ``dtype=object`` is passed.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\ngreater, less, less_equal, equal, not_equal\n\nExamples\n--------\n>>> np.greater_equal([4, 2, 1], [2, 2, 2])\narray([ True, True, False])\n\nThe ``>=`` operator can be used as a shorthand for ``np.greater_equal``\non ndarrays.\n\n>>> a = np.array([4, 2, 1])\n>>> b = np.array([2, 2, 2])\n>>> a >= b\narray([ True,  True, False])'
    ...

def heaviside(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute the Heaviside step function.\n\nThe Heaviside step function is defined as::\n\n                          0   if x1 < 0\n    heaviside(x1, x2) =  x2   if x1 == 0\n                          1   if x1 > 0\n\nwhere `x2` is often taken to be 0.5, but 0 and 1 are also sometimes used.\n\nParameters\n----------\nx1 : array_like\n    Input values.\nx2 : array_like\n    The value of the function when x1 is 0.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    The output array, element-wise Heaviside step function of `x1`.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nNotes\n-----\n.. versionadded:: 1.13.0\n\nReferences\n----------\n.. Wikipedia, "Heaviside step function",\n   https://en.wikipedia.org/wiki/Heaviside_step_function\n\nExamples\n--------\n>>> np.heaviside([-1.5, 0, 2.0], 0.5)\narray([ 0. ,  0.5,  1. ])\n>>> np.heaviside([-1.5, 0, 2.0], 1)\narray([ 0.,  1.,  1.])'
    ...

def hypot(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Given the "legs" of a right triangle, return its hypotenuse.\n\nEquivalent to ``sqrt(x1**2 + x2**2)``, element-wise.  If `x1` or\n`x2` is scalar_like (i.e., unambiguously cast-able to a scalar type),\nit is broadcast for use with each element of the other argument.\n(See Examples)\n\nParameters\n----------\nx1, x2 : array_like\n    Leg of the triangle(s).\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nz : ndarray\n    The hypotenuse of the triangle(s).\n    This is a scalar if both `x1` and `x2` are scalars.\n\nExamples\n--------\n>>> np.hypot(3*np.ones((3, 3)), 4*np.ones((3, 3)))\narray([[ 5.,  5.,  5.],\n       [ 5.,  5.,  5.],\n       [ 5.,  5.,  5.]])\n\nExample showing broadcast of scalar_like argument:\n\n>>> np.hypot(3*np.ones((3, 3)), [4])\narray([[ 5.,  5.,  5.],\n       [ 5.,  5.,  5.],\n       [ 5.,  5.,  5.]])'
    ...

def inner(a, b) -> typing.Any:
    '    Inner product of two arrays.\n\n    Ordinary inner product of vectors for 1-D arrays (without complex\n    conjugation), in higher dimensions a sum product over the last axes.\n\n    Parameters\n    ----------\n    a, b : array_like\n        If `a` and `b` are nonscalar, their last dimensions must match.\n\n    Returns\n    -------\n    out : ndarray\n        If `a` and `b` are both\n        scalars or both 1-D arrays then a scalar is returned; otherwise\n        an array is returned.\n        ``out.shape = (*a.shape[:-1], *b.shape[:-1])``\n\n    Raises\n    ------\n    ValueError\n        If both `a` and `b` are nonscalar and their last dimensions have\n        different sizes.\n\n    See Also\n    --------\n    tensordot : Sum products over arbitrary axes.\n    dot : Generalised matrix product, using second last dimension of `b`.\n    einsum : Einstein summation convention.\n\n    Notes\n    -----\n    For vectors (1-D arrays) it computes the ordinary inner-product::\n\n        np.inner(a, b) = sum(a[:]*b[:])\n\n    More generally, if ``ndim(a) = r > 0`` and ``ndim(b) = s > 0``::\n\n        np.inner(a, b) = np.tensordot(a, b, axes=(-1,-1))\n\n    or explicitly::\n\n        np.inner(a, b)[i0,...,ir-2,j0,...,js-2]\n             = sum(a[i0,...,ir-2,:]*b[j0,...,js-2,:])\n\n    In addition `a` or `b` may be scalars, in which case::\n\n       np.inner(a,b) = a*b\n\n    Examples\n    --------\n    Ordinary inner product for vectors:\n\n    >>> a = np.array([1,2,3])\n    >>> b = np.array([0,1,0])\n    >>> np.inner(a, b)\n    2\n\n    Some multidimensional examples:\n\n    >>> a = np.arange(24).reshape((2,3,4))\n    >>> b = np.arange(4)\n    >>> c = np.inner(a, b)\n    >>> c.shape\n    (2, 3)\n    >>> c\n    array([[ 14,  38,  62],\n           [ 86, 110, 134]])\n\n    >>> a = np.arange(2).reshape((1,1,2))\n    >>> b = np.arange(6).reshape((3,2))\n    >>> c = np.inner(a, b)\n    >>> c.shape\n    (1, 1, 3)\n    >>> c\n    array([[[1, 3, 5]]])\n\n    An example where `b` is a scalar:\n\n    >>> np.inner(np.eye(2), 7)\n    array([[7., 0.],\n           [0., 7.]])\n\n    '
    ...

def interp() -> typing.Any:
    ...

def interp_complex() -> typing.Any:
    ...

def invert(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute bit-wise inversion, or bit-wise NOT, element-wise.\n\nComputes the bit-wise NOT of the underlying binary representation of\nthe integers in the input arrays. This ufunc implements the C/Python\noperator ``~``.\n\nFor signed integer inputs, the two\'s complement is returned.  In a\ntwo\'s-complement system negative numbers are represented by the two\'s\ncomplement of the absolute value. This is the most common method of\nrepresenting signed integers on computers [1]_. A N-bit\ntwo\'s-complement system can represent every integer in the range\n:math:`-2^{N-1}` to :math:`+2^{N-1}-1`.\n\nParameters\n----------\nx : array_like\n    Only integer and boolean types are handled.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Result.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nbitwise_and, bitwise_or, bitwise_xor\nlogical_not\nbinary_repr :\n    Return the binary representation of the input number as a string.\n\nNotes\n-----\n`bitwise_not` is an alias for `invert`:\n\n>>> np.bitwise_not is np.invert\nTrue\n\nReferences\n----------\n.. [1] Wikipedia, "Two\'s complement",\n    https://en.wikipedia.org/wiki/Two\'s_complement\n\nExamples\n--------\nWe\'ve seen that 13 is represented by ``00001101``.\nThe invert or bit-wise NOT of 13 is then:\n\n>>> x = np.invert(np.array(13, dtype=np.uint8))\n>>> x\n242\n>>> np.binary_repr(x, width=8)\n\'11110010\'\n\nThe result depends on the bit-width:\n\n>>> x = np.invert(np.array(13, dtype=np.uint16))\n>>> x\n65522\n>>> np.binary_repr(x, width=16)\n\'1111111111110010\'\n\nWhen using signed integer types the result is the two\'s complement of\nthe result for the unsigned type:\n\n>>> np.invert(np.array([13], dtype=np.int8))\narray([-14], dtype=int8)\n>>> np.binary_repr(-14, width=8)\n\'11110010\'\n\nBooleans are accepted as well:\n\n>>> np.invert(np.array([True, False]))\narray([False,  True])\n\nThe ``~`` operator can be used as a shorthand for ``np.invert`` on\nndarrays.\n\n>>> x1 = np.array([True, False])\n>>> ~x1\narray([False,  True])'
    ...

def is_busday(dates, weekmask=..., holidays=..., busdaycal=..., out=...) -> typing.Any:
    '    Calculates which of the given dates are valid days, and which are not.\n\n    .. versionadded:: 1.7.0\n\n    Parameters\n    ----------\n    dates : array_like of datetime64[D]\n        The array of dates to process.\n    weekmask : str or array_like of bool, optional\n        A seven-element array indicating which of Monday through Sunday are\n        valid days. May be specified as a length-seven list or array, like\n        [1,1,1,1,1,0,0]; a length-seven string, like \'1111100\'; or a string\n        like "Mon Tue Wed Thu Fri", made up of 3-character abbreviations for\n        weekdays, optionally separated by white space. Valid abbreviations\n        are: Mon Tue Wed Thu Fri Sat Sun\n    holidays : array_like of datetime64[D], optional\n        An array of dates to consider as invalid dates.  They may be\n        specified in any order, and NaT (not-a-time) dates are ignored.\n        This list is saved in a normalized form that is suited for\n        fast calculations of valid days.\n    busdaycal : busdaycalendar, optional\n        A `busdaycalendar` object which specifies the valid days. If this\n        parameter is provided, neither weekmask nor holidays may be\n        provided.\n    out : array of bool, optional\n        If provided, this array is filled with the result.\n\n    Returns\n    -------\n    out : array of bool\n        An array with the same shape as ``dates``, containing True for\n        each valid day, and False for each invalid day.\n\n    See Also\n    --------\n    busdaycalendar : An object that specifies a custom set of valid days.\n    busday_offset : Applies an offset counted in valid days.\n    busday_count : Counts how many valid days are in a half-open date range.\n\n    Examples\n    --------\n    >>> # The weekdays are Friday, Saturday, and Monday\n    ... np.is_busday([\'2011-07-01\', \'2011-07-02\', \'2011-07-18\'],\n    ...                 holidays=[\'2011-07-01\', \'2011-07-04\', \'2011-07-17\'])\n    array([False, False,  True])\n    '
    ...

def isfinite(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Test element-wise for finiteness (not infinity and not Not a Number).\n\nThe result is returned as a boolean array.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray, bool\n    True where ``x`` is not positive infinity, negative infinity,\n    or NaN; false otherwise.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nisinf, isneginf, isposinf, isnan\n\nNotes\n-----\nNot a Number, positive infinity and negative infinity are considered\nto be non-finite.\n\nNumPy uses the IEEE Standard for Binary Floating-Point for Arithmetic\n(IEEE 754). This means that Not a Number is not equivalent to infinity.\nAlso that positive infinity is not equivalent to negative infinity. But\ninfinity is equivalent to positive infinity.  Errors result if the\nsecond argument is also supplied when `x` is a scalar input, or if\nfirst and second arguments have different shapes.\n\nExamples\n--------\n>>> np.isfinite(1)\nTrue\n>>> np.isfinite(0)\nTrue\n>>> np.isfinite(np.nan)\nFalse\n>>> np.isfinite(np.inf)\nFalse\n>>> np.isfinite(np.NINF)\nFalse\n>>> np.isfinite([np.log(-1.),1.,np.log(0)])\narray([False,  True, False])\n\n>>> x = np.array([-np.inf, 0., np.inf])\n>>> y = np.array([2, 2, 2])\n>>> np.isfinite(x, y)\narray([0, 1, 0])\n>>> y\narray([0, 1, 0])'
    ...

def isinf(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Test element-wise for positive or negative infinity.\n\nReturns a boolean array of the same shape as `x`, True where ``x ==\n+/-inf``, otherwise False.\n\nParameters\n----------\nx : array_like\n    Input values\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : bool (scalar) or boolean ndarray\n    True where ``x`` is positive or negative infinity, false otherwise.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nisneginf, isposinf, isnan, isfinite\n\nNotes\n-----\nNumPy uses the IEEE Standard for Binary Floating-Point for Arithmetic\n(IEEE 754).\n\nErrors result if the second argument is supplied when the first\nargument is a scalar, or if the first and second arguments have\ndifferent shapes.\n\nExamples\n--------\n>>> np.isinf(np.inf)\nTrue\n>>> np.isinf(np.nan)\nFalse\n>>> np.isinf(np.NINF)\nTrue\n>>> np.isinf([np.inf, -np.inf, 1.0, np.nan])\narray([ True,  True, False, False])\n\n>>> x = np.array([-np.inf, 0., np.inf])\n>>> y = np.array([2, 2, 2])\n>>> np.isinf(x, y)\narray([1, 0, 1])\n>>> y\narray([1, 0, 1])'
    ...

def isnan(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Test element-wise for NaN and return result as a boolean array.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or bool\n    True where ``x`` is NaN, false otherwise.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nisinf, isneginf, isposinf, isfinite, isnat\n\nNotes\n-----\nNumPy uses the IEEE Standard for Binary Floating-Point for Arithmetic\n(IEEE 754). This means that Not a Number is not equivalent to infinity.\n\nExamples\n--------\n>>> np.isnan(np.nan)\nTrue\n>>> np.isnan(np.inf)\nFalse\n>>> np.isnan([np.log(-1.),1.,np.log(0)])\narray([ True, False, False])'
    ...

def isnat(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Test element-wise for NaT (not a time) and return result as a boolean array.\n\n.. versionadded:: 1.13.0\n\nParameters\n----------\nx : array_like\n    Input array with datetime or timedelta data type.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or bool\n    True where ``x`` is NaT, false otherwise.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nisnan, isinf, isneginf, isposinf, isfinite\n\nExamples\n--------\n>>> np.isnat(np.datetime64("NaT"))\nTrue\n>>> np.isnat(np.datetime64("2016-01-01"))\nFalse\n>>> np.isnat(np.array(["NaT", "2016-01-01"], dtype="datetime64[ns]"))\narray([ True, False])'
    ...

def lcm(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Returns the lowest common multiple of ``|x1|`` and ``|x2|``\n\nParameters\n----------\nx1, x2 : array_like, int\n    Arrays of values.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\n\nReturns\n-------\ny : ndarray or scalar\n    The lowest common multiple of the absolute value of the inputs\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\ngcd : The greatest common divisor\n\nExamples\n--------\n>>> np.lcm(12, 20)\n60\n>>> np.lcm.reduce([3, 12, 20])\n60\n>>> np.lcm.reduce([40, 12, 20])\n120\n>>> np.lcm(np.arange(6), 20)\narray([ 0, 20, 20, 60, 20, 20])'
    ...

def ldexp(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Returns x1 * 2**x2, element-wise.\n\nThe mantissas `x1` and twos exponents `x2` are used to construct\nfloating point numbers ``x1 * 2**x2``.\n\nParameters\n----------\nx1 : array_like\n    Array of multipliers.\nx2 : array_like, int\n    Array of twos exponents.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The result of ``x1 * 2**x2``.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfrexp : Return (y1, y2) from ``x = y1 * 2**y2``, inverse to `ldexp`.\n\nNotes\n-----\nComplex dtypes are not supported, they will raise a TypeError.\n\n`ldexp` is useful as the inverse of `frexp`, if used by itself it is\nmore clear to simply use the expression ``x1 * 2**x2``.\n\nExamples\n--------\n>>> np.ldexp(5, np.arange(4))\narray([ 5., 10., 20., 40.], dtype=float16)\n\n>>> x = np.arange(6)\n>>> np.ldexp(*np.frexp(x))\narray([ 0.,  1.,  2.,  3.,  4.,  5.])'
    ...

def left_shift(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Shift the bits of an integer to the left.\n\nBits are shifted to the left by appending `x2` 0s at the right of `x1`.\nSince the internal representation of numbers is in binary format, this\noperation is equivalent to multiplying `x1` by ``2**x2``.\n\nParameters\n----------\nx1 : array_like of integer type\n    Input values.\nx2 : array_like of integer type\n    Number of zeros to append to `x1`. Has to be non-negative.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : array of integer type\n    Return `x1` with bits shifted `x2` times to the left.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nright_shift : Shift the bits of an integer to the right.\nbinary_repr : Return the binary representation of the input number\n    as a string.\n\nExamples\n--------\n>>> np.binary_repr(5)\n'101'\n>>> np.left_shift(5, 2)\n20\n>>> np.binary_repr(20)\n'10100'\n\n>>> np.left_shift(5, [1,2,3])\narray([10, 20, 40])\n\nNote that the dtype of the second argument may change the dtype of the\nresult and can lead to unexpected results in some cases (see\n:ref:`Casting Rules <ufuncs.casting>`):\n\n>>> a = np.left_shift(np.uint8(255), 1) # Expect 254\n>>> print(a, type(a)) # Unexpected result due to upcasting\n510 <class 'numpy.int64'>\n>>> b = np.left_shift(np.uint8(255), np.uint8(1))\n>>> print(b, type(b))\n254 <class 'numpy.uint8'>\n\nThe ``<<`` operator can be used as a shorthand for ``np.left_shift`` on\nndarrays.\n\n>>> x1 = 5\n>>> x2 = np.array([1, 2, 3])\n>>> x1 << x2\narray([10, 20, 40])"
    ...

def less(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the truth value of (x1 < x2) element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array, element-wise comparison of `x1` and `x2`.\n    Typically of type bool, unless ``dtype=object`` is passed.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\ngreater, less_equal, greater_equal, equal, not_equal\n\nExamples\n--------\n>>> np.less([1, 2], [2, 2])\narray([ True, False])\n\nThe ``<`` operator can be used as a shorthand for ``np.less`` on ndarrays.\n\n>>> a = np.array([1, 2])\n>>> b = np.array([2, 2])\n>>> a < b\narray([ True, False])'
    ...

def less_equal(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the truth value of (x1 <= x2) element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array, element-wise comparison of `x1` and `x2`.\n    Typically of type bool, unless ``dtype=object`` is passed.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\ngreater, less, greater_equal, equal, not_equal\n\nExamples\n--------\n>>> np.less_equal([4, 2, 1], [2, 2, 2])\narray([False,  True,  True])\n\nThe ``<=`` operator can be used as a shorthand for ``np.less_equal`` on\nndarrays.\n\n>>> a = np.array([4, 2, 1])\n>>> b = np.array([2, 2, 2])\n>>> a <= b\narray([False,  True,  True])'
    ...

def lexsort(keys, axis=...) -> typing.Any:
    '    Perform an indirect stable sort using a sequence of keys.\n\n    Given multiple sorting keys, which can be interpreted as columns in a\n    spreadsheet, lexsort returns an array of integer indices that describes\n    the sort order by multiple columns. The last key in the sequence is used\n    for the primary sort order, the second-to-last key for the secondary sort\n    order, and so on. The keys argument must be a sequence of objects that\n    can be converted to arrays of the same shape. If a 2D array is provided\n    for the keys argument, its rows are interpreted as the sorting keys and\n    sorting is according to the last row, second last row etc.\n\n    Parameters\n    ----------\n    keys : (k, N) array or tuple containing k (N,)-shaped sequences\n        The `k` different "columns" to be sorted.  The last column (or row if\n        `keys` is a 2D array) is the primary sort key.\n    axis : int, optional\n        Axis to be indirectly sorted.  By default, sort over the last axis.\n\n    Returns\n    -------\n    indices : (N,) ndarray of ints\n        Array of indices that sort the keys along the specified axis.\n\n    See Also\n    --------\n    argsort : Indirect sort.\n    ndarray.sort : In-place sort.\n    sort : Return a sorted copy of an array.\n\n    Examples\n    --------\n    Sort names: first by surname, then by name.\n\n    >>> surnames =    (\'Hertz\',    \'Galilei\', \'Hertz\')\n    >>> first_names = (\'Heinrich\', \'Galileo\', \'Gustav\')\n    >>> ind = np.lexsort((first_names, surnames))\n    >>> ind\n    array([1, 2, 0])\n\n    >>> [surnames[i] + ", " + first_names[i] for i in ind]\n    [\'Galilei, Galileo\', \'Hertz, Gustav\', \'Hertz, Heinrich\']\n\n    Sort two columns of numbers:\n\n    >>> a = [1,5,1,4,3,4,4] # First column\n    >>> b = [9,4,0,4,0,2,1] # Second column\n    >>> ind = np.lexsort((b,a)) # Sort by a, then by b\n    >>> ind\n    array([2, 0, 4, 6, 5, 3, 1])\n\n    >>> [(a[i],b[i]) for i in ind]\n    [(1, 0), (1, 9), (3, 0), (4, 1), (4, 2), (4, 4), (5, 4)]\n\n    Note that sorting is first according to the elements of ``a``.\n    Secondary sorting is according to the elements of ``b``.\n\n    A normal ``argsort`` would have yielded:\n\n    >>> [(a[i],b[i]) for i in np.argsort(a)]\n    [(1, 9), (1, 0), (3, 0), (4, 4), (4, 2), (4, 1), (5, 4)]\n\n    Structured arrays are sorted lexically by ``argsort``:\n\n    >>> x = np.array([(1,9), (5,4), (1,0), (4,4), (3,0), (4,2), (4,1)],\n    ...              dtype=np.dtype([(\'x\', int), (\'y\', int)]))\n\n    >>> np.argsort(x) # or np.argsort(x, order=(\'x\', \'y\'))\n    array([2, 0, 4, 6, 5, 3, 1])\n\n    '
    ...

def log(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Natural logarithm, element-wise.\n\nThe natural logarithm `log` is the inverse of the exponential function,\nso that `log(exp(x)) = x`. The natural logarithm is logarithm in base\n`e`.\n\nParameters\n----------\nx : array_like\n    Input value.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The natural logarithm of `x`, element-wise.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nlog10, log2, log1p, emath.log\n\nNotes\n-----\nLogarithm is a multivalued function: for each `x` there is an infinite\nnumber of `z` such that `exp(z) = x`. The convention is to return the\n`z` whose imaginary part lies in `(-pi, pi]`.\n\nFor real-valued input data types, `log` always returns real output. For\neach value that cannot be expressed as a real number or infinity, it\nyields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `log` is a complex analytical function that\nhas a branch cut `[-inf, 0]` and is continuous from above on it. `log`\nhandles the floating-point negative zero as an infinitesimal negative\nnumber, conforming to the C99 standard.\n\nIn the cases where the input has a negative real part and a very small\nnegative complex part (approaching 0), the result is so close to `-pi`\nthat it evaluates to exactly `-pi`.\n\nReferences\n----------\n.. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n       10th printing, 1964, pp. 67.\n       https://personal.math.ubc.ca/~cbm/aands/page_67.htm\n.. [2] Wikipedia, "Logarithm". https://en.wikipedia.org/wiki/Logarithm\n\nExamples\n--------\n>>> np.log([1, np.e, np.e**2, 0])\narray([  0.,   1.,   2., -Inf])'
    ...

def log10(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the base 10 logarithm of the input array, element-wise.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The logarithm to the base 10 of `x`, element-wise. NaNs are\n    returned where x is negative.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nemath.log10\n\nNotes\n-----\nLogarithm is a multivalued function: for each `x` there is an infinite\nnumber of `z` such that `10**z = x`. The convention is to return the\n`z` whose imaginary part lies in `(-pi, pi]`.\n\nFor real-valued input data types, `log10` always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `log10` is a complex analytical function that\nhas a branch cut `[-inf, 0]` and is continuous from above on it.\n`log10` handles the floating-point negative zero as an infinitesimal\nnegative number, conforming to the C99 standard.\n\nIn the cases where the input has a negative real part and a very small\nnegative complex part (approaching 0), the result is so close to `-pi`\nthat it evaluates to exactly `-pi`.\n\nReferences\n----------\n.. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n       10th printing, 1964, pp. 67.\n       https://personal.math.ubc.ca/~cbm/aands/page_67.htm\n.. [2] Wikipedia, "Logarithm". https://en.wikipedia.org/wiki/Logarithm\n\nExamples\n--------\n>>> np.log10([1e-15, -3.])\narray([-15.,  nan])'
    ...

def log1p(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the natural logarithm of one plus the input array, element-wise.\n\nCalculates ``log(1 + x)``.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    Natural logarithm of `1 + x`, element-wise.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nexpm1 : ``exp(x) - 1``, the inverse of `log1p`.\n\nNotes\n-----\nFor real-valued input, `log1p` is accurate also for `x` so small\nthat `1 + x == 1` in floating-point accuracy.\n\nLogarithm is a multivalued function: for each `x` there is an infinite\nnumber of `z` such that `exp(z) = 1 + x`. The convention is to return\nthe `z` whose imaginary part lies in `[-pi, pi]`.\n\nFor real-valued input data types, `log1p` always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `log1p` is a complex analytical function that\nhas a branch cut `[-inf, -1]` and is continuous from above on it.\n`log1p` handles the floating-point negative zero as an infinitesimal\nnegative number, conforming to the C99 standard.\n\nReferences\n----------\n.. [1] M. Abramowitz and I.A. Stegun, "Handbook of Mathematical Functions",\n       10th printing, 1964, pp. 67.\n       https://personal.math.ubc.ca/~cbm/aands/page_67.htm\n.. [2] Wikipedia, "Logarithm". https://en.wikipedia.org/wiki/Logarithm\n\nExamples\n--------\n>>> np.log1p(1e-99)\n1e-99\n>>> np.log(1 + 1e-99)\n0.0'
    ...

def log2(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Base-2 logarithm of `x`.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    Base-2 logarithm of `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nlog, log10, log1p, emath.log2\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nLogarithm is a multivalued function: for each `x` there is an infinite\nnumber of `z` such that `2**z = x`. The convention is to return the `z`\nwhose imaginary part lies in `(-pi, pi]`.\n\nFor real-valued input data types, `log2` always returns real output.\nFor each value that cannot be expressed as a real number or infinity,\nit yields ``nan`` and sets the `invalid` floating point error flag.\n\nFor complex-valued input, `log2` is a complex analytical function that\nhas a branch cut `[-inf, 0]` and is continuous from above on it. `log2`\nhandles the floating-point negative zero as an infinitesimal negative\nnumber, conforming to the C99 standard.\n\nIn the cases where the input has a negative real part and a very small\nnegative complex part (approaching 0), the result is so close to `-pi`\nthat it evaluates to exactly `-pi`.\n\nExamples\n--------\n>>> x = np.array([0, 1, 2, 2**4])\n>>> np.log2(x)\narray([-Inf,   0.,   1.,   4.])\n\n>>> xi = np.array([0+1.j, 1, 2+0.j, 4.j])\n>>> np.log2(xi)\narray([ 0.+2.26618007j,  0.+0.j        ,  1.+0.j        ,  2.+2.26618007j])'
    ...

def logaddexp(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Logarithm of the sum of exponentiations of the inputs.\n\nCalculates ``log(exp(x1) + exp(x2))``. This function is useful in\nstatistics where the calculated probabilities of events may be so small\nas to exceed the range of normal floating point numbers.  In such cases\nthe logarithm of the calculated probability is stored. This function\nallows adding probabilities stored in such a fashion.\n\nParameters\n----------\nx1, x2 : array_like\n    Input values.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nresult : ndarray\n    Logarithm of ``exp(x1) + exp(x2)``.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogaddexp2: Logarithm of the sum of exponentiations of inputs in base 2.\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nExamples\n--------\n>>> prob1 = np.log(1e-50)\n>>> prob2 = np.log(2.5e-50)\n>>> prob12 = np.logaddexp(prob1, prob2)\n>>> prob12\n-113.87649168120691\n>>> np.exp(prob12)\n3.5000000000000057e-50'
    ...

def logaddexp2(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Logarithm of the sum of exponentiations of the inputs in base-2.\n\nCalculates ``log2(2**x1 + 2**x2)``. This function is useful in machine\nlearning when the calculated probabilities of events may be so small as\nto exceed the range of normal floating point numbers.  In such cases\nthe base-2 logarithm of the calculated probability can be used instead.\nThis function allows adding probabilities stored in such a fashion.\n\nParameters\n----------\nx1, x2 : array_like\n    Input values.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nresult : ndarray\n    Base-2 logarithm of ``2**x1 + 2**x2``.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogaddexp: Logarithm of the sum of exponentiations of the inputs.\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nExamples\n--------\n>>> prob1 = np.log2(1e-50)\n>>> prob2 = np.log2(2.5e-50)\n>>> prob12 = np.logaddexp2(prob1, prob2)\n>>> prob1, prob2, prob12\n(-166.09640474436813, -164.77447664948076, -164.28904982231052)\n>>> 2**prob12\n3.4999999999999914e-50'
    ...

def logical_and(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute the truth value of x1 AND x2 element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or bool\n    Boolean result of the logical AND operation applied to the elements\n    of `x1` and `x2`; the shape is determined by broadcasting.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogical_or, logical_not, logical_xor\nbitwise_and\n\nExamples\n--------\n>>> np.logical_and(True, False)\nFalse\n>>> np.logical_and([True, False], [False, False])\narray([False, False])\n\n>>> x = np.arange(5)\n>>> np.logical_and(x>1, x<4)\narray([False, False,  True,  True, False])\n\n\nThe ``&`` operator can be used as a shorthand for ``np.logical_and`` on\nboolean ndarrays.\n\n>>> a = np.array([True, False])\n>>> b = np.array([False, False])\n>>> a & b\narray([False, False])'
    ...

def logical_not(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute the truth value of NOT x element-wise.\n\nParameters\n----------\nx : array_like\n    Logical NOT is applied to the elements of `x`.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : bool or ndarray of bool\n    Boolean result with the same shape as `x` of the NOT operation\n    on elements of `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nlogical_and, logical_or, logical_xor\n\nExamples\n--------\n>>> np.logical_not(3)\nFalse\n>>> np.logical_not([True, False, 0, 1])\narray([False,  True,  True, False])\n\n>>> x = np.arange(5)\n>>> np.logical_not(x<3)\narray([False, False, False,  True,  True])'
    ...

def logical_or(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute the truth value of x1 OR x2 element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Logical OR is applied to the elements of `x1` and `x2`.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or bool\n    Boolean result of the logical OR operation applied to the elements\n    of `x1` and `x2`; the shape is determined by broadcasting.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogical_and, logical_not, logical_xor\nbitwise_or\n\nExamples\n--------\n>>> np.logical_or(True, False)\nTrue\n>>> np.logical_or([True, False], [False, False])\narray([ True, False])\n\n>>> x = np.arange(5)\n>>> np.logical_or(x < 1, x > 3)\narray([ True, False, False, False,  True])\n\nThe ``|`` operator can be used as a shorthand for ``np.logical_or`` on\nboolean ndarrays.\n\n>>> a = np.array([True, False])\n>>> b = np.array([False, False])\n>>> a | b\narray([ True, False])'
    ...

def logical_xor(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute the truth value of x1 XOR x2, element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Logical XOR is applied to the elements of `x1` and `x2`.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : bool or ndarray of bool\n    Boolean result of the logical XOR operation applied to the elements\n    of `x1` and `x2`; the shape is determined by broadcasting.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nlogical_and, logical_or, logical_not, bitwise_xor\n\nExamples\n--------\n>>> np.logical_xor(True, False)\nTrue\n>>> np.logical_xor([True, True, False, False], [True, False, True, False])\narray([False,  True,  True, False])\n\n>>> x = np.arange(5)\n>>> np.logical_xor(x < 1, x > 3)\narray([ True, False, False, False,  True])\n\nSimple example showing support of broadcasting\n\n>>> np.logical_xor(0, np.eye(2))\narray([[ True, False],\n       [False,  True]])'
    ...

def matmul(x1, x2, out=..., *, casting=..., order=..., dtype=..., subok=..., signature=..., extobj=..., axes=..., axis=...) -> typing.Any:
    'Matrix product of two arrays.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays, scalars not allowed.\nout : ndarray, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that matches the signature `(n,k),(k,m)->(n,m)`. If not\n    provided or None, a freshly-allocated array is returned.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\n    .. versionadded:: 1.16\n       Now handles ufunc kwargs\n\nReturns\n-------\ny : ndarray\n    The matrix product of the inputs.\n    This is a scalar only when both x1, x2 are 1-d vectors.\n\nRaises\n------\nValueError\n    If the last dimension of `x1` is not the same size as\n    the second-to-last dimension of `x2`.\n\n    If a scalar value is passed in.\n\nSee Also\n--------\nvdot : Complex-conjugating dot product.\ntensordot : Sum products over arbitrary axes.\neinsum : Einstein summation convention.\ndot : alternative matrix product with different broadcasting rules.\n\nNotes\n-----\n\nThe behavior depends on the arguments in the following way.\n\n- If both arguments are 2-D they are multiplied like conventional\n  matrices.\n- If either argument is N-D, N > 2, it is treated as a stack of\n  matrices residing in the last two indexes and broadcast accordingly.\n- If the first argument is 1-D, it is promoted to a matrix by\n  prepending a 1 to its dimensions. After matrix multiplication\n  the prepended 1 is removed.\n- If the second argument is 1-D, it is promoted to a matrix by\n  appending a 1 to its dimensions. After matrix multiplication\n  the appended 1 is removed.\n\n``matmul`` differs from ``dot`` in two important ways:\n\n- Multiplication by scalars is not allowed, use ``*`` instead.\n- Stacks of matrices are broadcast together as if the matrices\n  were elements, respecting the signature ``(n,k),(k,m)->(n,m)``:\n\n  >>> a = np.ones([9, 5, 7, 4])\n  >>> c = np.ones([9, 5, 4, 3])\n  >>> np.dot(a, c).shape\n  (9, 5, 7, 9, 5, 3)\n  >>> np.matmul(a, c).shape\n  (9, 5, 7, 3)\n  >>> # n is 7, k is 4, m is 3\n\nThe matmul function implements the semantics of the ``@`` operator\nintroduced in Python 3.5 following :pep:`465`.\n\nIt uses an optimized BLAS library when possible (see `numpy.linalg`).\n\nExamples\n--------\nFor 2-D arrays it is the matrix product:\n\n>>> a = np.array([[1, 0],\n...               [0, 1]])\n>>> b = np.array([[4, 1],\n...               [2, 2]])\n>>> np.matmul(a, b)\narray([[4, 1],\n       [2, 2]])\n\nFor 2-D mixed with 1-D, the result is the usual.\n\n>>> a = np.array([[1, 0],\n...               [0, 1]])\n>>> b = np.array([1, 2])\n>>> np.matmul(a, b)\narray([1, 2])\n>>> np.matmul(b, a)\narray([1, 2])\n\n\nBroadcasting is conventional for stacks of arrays\n\n>>> a = np.arange(2 * 2 * 4).reshape((2, 2, 4))\n>>> b = np.arange(2 * 2 * 4).reshape((2, 4, 2))\n>>> np.matmul(a,b).shape\n(2, 2, 2)\n>>> np.matmul(a, b)[0, 1, 1]\n98\n>>> sum(a[0, 1, :] * b[0 , :, 1])\n98\n\nVector, vector returns the scalar inner product, but neither argument\nis complex-conjugated:\n\n>>> np.matmul([2j, 3j], [2j, 3j])\n(-13+0j)\n\nScalar multiplication raises an error.\n\n>>> np.matmul([1,2], 3)\nTraceback (most recent call last):\n...\nValueError: matmul: Input operand 1 does not have enough dimensions ...\n\nThe ``@`` operator can be used as a shorthand for ``np.matmul`` on\nndarrays.\n\n>>> x1 = np.array([2j, 3j])\n>>> x2 = np.array([2j, 3j])\n>>> x1 @ x2\n(-13+0j)\n\n.. versionadded:: 1.10.0'
    ...

def maximum(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Element-wise maximum of array elements.\n\nCompare two arrays and return a new array containing the element-wise\nmaxima. If one of the elements being compared is a NaN, then that\nelement is returned. If both elements are NaNs then the first is\nreturned. The latter distinction is important for complex NaNs, which\nare defined as at least one of the real or imaginary parts being a NaN.\nThe net effect is that NaNs are propagated.\n\nParameters\n----------\nx1, x2 : array_like\n    The arrays holding the elements to be compared.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The maximum of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nminimum :\n    Element-wise minimum of two arrays, propagates NaNs.\nfmax :\n    Element-wise maximum of two arrays, ignores NaNs.\namax :\n    The maximum value of an array along a given axis, propagates NaNs.\nnanmax :\n    The maximum value of an array along a given axis, ignores NaNs.\n\nfmin, amin, nanmin\n\nNotes\n-----\nThe maximum is equivalent to ``np.where(x1 >= x2, x1, x2)`` when\nneither x1 nor x2 are nans, but it is faster and does proper\nbroadcasting.\n\nExamples\n--------\n>>> np.maximum([2, 3, 4], [1, 5, 2])\narray([2, 5, 4])\n\n>>> np.maximum(np.eye(2), [0.5, 2]) # broadcasting\narray([[ 1. ,  2. ],\n       [ 0.5,  2. ]])\n\n>>> np.maximum([np.nan, 0, np.nan], [0, np.nan, np.nan])\narray([nan, nan, nan])\n>>> np.maximum(np.Inf, 1)\ninf'
    ...

def may_share_memory(a, b, max_work=...) -> typing.Any:
    '    Determine if two arrays might share memory\n\n    A return of True does not necessarily mean that the two arrays\n    share any element.  It just means that they *might*.\n\n    Only the memory bounds of a and b are checked by default.\n\n    Parameters\n    ----------\n    a, b : ndarray\n        Input arrays\n    max_work : int, optional\n        Effort to spend on solving the overlap problem.  See\n        `shares_memory` for details.  Default for ``may_share_memory``\n        is to do a bounds check.\n\n    Returns\n    -------\n    out : bool\n\n    See Also\n    --------\n    shares_memory\n\n    Examples\n    --------\n    >>> np.may_share_memory(np.array([1,2]), np.array([5,8,9]))\n    False\n    >>> x = np.zeros([3, 4])\n    >>> np.may_share_memory(x[:,0], x[:,1])\n    True\n\n    '
    ...

def min_scalar_type(a) -> typing.Any:
    "    For scalar ``a``, returns the data type with the smallest size\n    and smallest scalar kind which can hold its value.  For non-scalar\n    array ``a``, returns the vector's dtype unmodified.\n\n    Floating point values are not demoted to integers,\n    and complex values are not demoted to floats.\n\n    Parameters\n    ----------\n    a : scalar or array_like\n        The value whose minimal data type is to be found.\n\n    Returns\n    -------\n    out : dtype\n        The minimal data type.\n\n    Notes\n    -----\n    .. versionadded:: 1.6.0\n\n    See Also\n    --------\n    result_type, promote_types, dtype, can_cast\n\n    Examples\n    --------\n    >>> np.min_scalar_type(10)\n    dtype('uint8')\n\n    >>> np.min_scalar_type(-260)\n    dtype('int16')\n\n    >>> np.min_scalar_type(3.1)\n    dtype('float16')\n\n    >>> np.min_scalar_type(1e50)\n    dtype('float64')\n\n    >>> np.min_scalar_type(np.arange(4,dtype='f8'))\n    dtype('float64')\n\n    "
    ...

def minimum(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Element-wise minimum of array elements.\n\nCompare two arrays and return a new array containing the element-wise\nminima. If one of the elements being compared is a NaN, then that\nelement is returned. If both elements are NaNs then the first is\nreturned. The latter distinction is important for complex NaNs, which\nare defined as at least one of the real or imaginary parts being a NaN.\nThe net effect is that NaNs are propagated.\n\nParameters\n----------\nx1, x2 : array_like\n    The arrays holding the elements to be compared.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The minimum of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nmaximum :\n    Element-wise maximum of two arrays, propagates NaNs.\nfmin :\n    Element-wise minimum of two arrays, ignores NaNs.\namin :\n    The minimum value of an array along a given axis, propagates NaNs.\nnanmin :\n    The minimum value of an array along a given axis, ignores NaNs.\n\nfmax, amax, nanmax\n\nNotes\n-----\nThe minimum is equivalent to ``np.where(x1 <= x2, x1, x2)`` when\nneither x1 nor x2 are NaNs, but it is faster and does proper\nbroadcasting.\n\nExamples\n--------\n>>> np.minimum([2, 3, 4], [1, 5, 2])\narray([1, 3, 2])\n\n>>> np.minimum(np.eye(2), [0.5, 2]) # broadcasting\narray([[ 0.5,  0. ],\n       [ 0. ,  1. ]])\n\n>>> np.minimum([np.nan, 0, np.nan],[0, np.nan, np.nan])\narray([nan, nan, nan])\n>>> np.minimum(-np.Inf, 1)\n-inf'
    ...

def mod(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "remainder(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nReturns the element-wise remainder of division.\n\nComputes the remainder complementary to the `floor_divide` function.  It is\nequivalent to the Python modulus operator``x1 % x2`` and has the same sign\nas the divisor `x2`. The MATLAB function equivalent to ``np.remainder``\nis ``mod``.\n\n.. warning::\n\n    This should not be confused with:\n\n    * Python 3.7's `math.remainder` and C's ``remainder``, which\n      computes the IEEE remainder, which are the complement to\n      ``round(x1 / x2)``.\n    * The MATLAB ``rem`` function and or the C ``%`` operator which is the\n      complement to ``int(x1 / x2)``.\n\nParameters\n----------\nx1 : array_like\n    Dividend array.\nx2 : array_like\n    Divisor array.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The element-wise remainder of the quotient ``floor_divide(x1, x2)``.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfloor_divide : Equivalent of Python ``//`` operator.\ndivmod : Simultaneous floor division and remainder.\nfmod : Equivalent of the MATLAB ``rem`` function.\ndivide, floor\n\nNotes\n-----\nReturns 0 when `x2` is 0 and both `x1` and `x2` are (arrays of)\nintegers.\n``mod`` is an alias of ``remainder``.\n\nExamples\n--------\n>>> np.remainder([4, 7], [2, 3])\narray([0, 1])\n>>> np.remainder(np.arange(7), 5)\narray([0, 1, 2, 3, 4, 0, 1])\n\nThe ``%`` operator can be used as a shorthand for ``np.remainder`` on\nndarrays.\n\n>>> x1 = np.arange(7)\n>>> x1 % 5\narray([0, 1, 2, 3, 4, 0, 1])"
    ...

def modf(x, out1=..., out2=..., out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the fractional and integral parts of an array, element-wise.\n\nThe fractional and integral parts are negative if the given number is\nnegative.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny1 : ndarray\n    Fractional part of `x`.\n    This is a scalar if `x` is a scalar.\ny2 : ndarray\n    Integral part of `x`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nFor integer input the return values are floats.\n\nSee Also\n--------\ndivmod : ``divmod(x, 1)`` is equivalent to ``modf`` with the return values\n         switched, except it always has a positive remainder.\n\nExamples\n--------\n>>> np.modf([0, 3.5])\n(array([ 0. ,  0.5]), array([ 0.,  3.]))\n>>> np.modf(-0.5)\n(-0.5, -0)'
    ...

def multiply(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Multiply arguments element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays to be multiplied.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The product of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nNotes\n-----\nEquivalent to `x1` * `x2` in terms of array broadcasting.\n\nExamples\n--------\n>>> np.multiply(2.0, 4.0)\n8.0\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> np.multiply(x1, x2)\narray([[  0.,   1.,   4.],\n       [  0.,   4.,  10.],\n       [  0.,   7.,  16.]])\n\nThe ``*`` operator can be used as a shorthand for ``np.multiply`` on\nndarrays.\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> x1 * x2\narray([[  0.,   1.,   4.],\n       [  0.,   4.,  10.],\n       [  0.,   7.,  16.]])'
    ...

class ndarray(_mod_builtins.object):
    'ndarray(shape, dtype=float, buffer=None, offset=0,\n            strides=None, order=None)\n\n    An array object represents a multidimensional, homogeneous array\n    of fixed-size items.  An associated data-type object describes the\n    format of each element in the array (its byte-order, how many bytes it\n    occupies in memory, whether it is an integer, a floating point number,\n    or something else, etc.)\n\n    Arrays should be constructed using `array`, `zeros` or `empty` (refer\n    to the See Also section below).  The parameters given here refer to\n    a low-level method (`ndarray(...)`) for instantiating an array.\n\n    For more information, refer to the `numpy` module and examine the\n    methods and attributes of an array.\n\n    Parameters\n    ----------\n    (for the __new__ method; see Notes below)\n\n    shape : tuple of ints\n        Shape of created array.\n    dtype : data-type, optional\n        Any object that can be interpreted as a numpy data type.\n    buffer : object exposing buffer interface, optional\n        Used to fill the array with data.\n    offset : int, optional\n        Offset of array data in buffer.\n    strides : tuple of ints, optional\n        Strides of data in memory.\n    order : {\'C\', \'F\'}, optional\n        Row-major (C-style) or column-major (Fortran-style) order.\n\n    Attributes\n    ----------\n    T : ndarray\n        Transpose of the array.\n    data : buffer\n        The array\'s elements, in memory.\n    dtype : dtype object\n        Describes the format of the elements in the array.\n    flags : dict\n        Dictionary containing information related to memory use, e.g.,\n        \'C_CONTIGUOUS\', \'OWNDATA\', \'WRITEABLE\', etc.\n    flat : numpy.flatiter object\n        Flattened version of the array as an iterator.  The iterator\n        allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for\n        assignment examples; TODO).\n    imag : ndarray\n        Imaginary part of the array.\n    real : ndarray\n        Real part of the array.\n    size : int\n        Number of elements in the array.\n    itemsize : int\n        The memory use of each array element in bytes.\n    nbytes : int\n        The total number of bytes required to store the array data,\n        i.e., ``itemsize * size``.\n    ndim : int\n        The array\'s number of dimensions.\n    shape : tuple of ints\n        Shape of the array.\n    strides : tuple of ints\n        The step-size required to move from one element to the next in\n        memory. For example, a contiguous ``(3, 4)`` array of type\n        ``int16`` in C-order has strides ``(8, 2)``.  This implies that\n        to move from element to element in memory requires jumps of 2 bytes.\n        To move from row-to-row, one needs to jump 8 bytes at a time\n        (``2 * 4``).\n    ctypes : ctypes object\n        Class containing properties of the array needed for interaction\n        with ctypes.\n    base : ndarray\n        If the array is a view into another array, that array is its `base`\n        (unless that array is also a view).  The `base` array is where the\n        array data is actually stored.\n\n    See Also\n    --------\n    array : Construct an array.\n    zeros : Create an array, each element of which is zero.\n    empty : Create an array, but leave its allocated memory unchanged (i.e.,\n            it contains "garbage").\n    dtype : Create a data-type.\n    numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`\n                           w.r.t. its `dtype.type <numpy.dtype.type>`.\n\n    Notes\n    -----\n    There are two modes of creating an array using ``__new__``:\n\n    1. If `buffer` is None, then only `shape`, `dtype`, and `order`\n       are used.\n    2. If `buffer` is an object exposing the buffer interface, then\n       all keywords are interpreted.\n\n    No ``__init__`` method is needed because the array is fully initialized\n    after the ``__new__`` method.\n\n    Examples\n    --------\n    These examples illustrate the low-level `ndarray` constructor.  Refer\n    to the `See Also` section above for easier ways of constructing an\n    ndarray.\n\n    First mode, `buffer` is None:\n\n    >>> np.ndarray(shape=(2,2), dtype=float, order=\'F\')\n    array([[0.0e+000, 0.0e+000], # random\n           [     nan, 2.5e-323]])\n\n    Second mode:\n\n    >>> np.ndarray((2,), buffer=np.array([1,2,3]),\n    ...            offset=np.int_().itemsize,\n    ...            dtype=int) # offset = 1*itemsize, i.e. skip first element\n    array([2, 3])'
    @property
    def T(self) -> typing.Any:
        'View of the transposed array.\n\n    Same as ``self.transpose()``.\n\n    Examples\n    --------\n    >>> a = np.array([[1, 2], [3, 4]])\n    >>> a\n    array([[1, 2],\n           [3, 4]])\n    >>> a.T\n    array([[1, 3],\n           [2, 4]])\n\n    >>> a = np.array([1, 2, 3, 4])\n    >>> a\n    array([1, 2, 3, 4])\n    >>> a.T\n    array([1, 2, 3, 4])\n\n    See Also\n    --------\n    transpose'
        ...
    
    def __abs__(self) -> ndarray:
        'abs(self)'
        ...
    
    def __add__(self, value) -> ndarray:
        'Return self+value.'
        ...
    
    def __and__(self, value) -> ndarray:
        'Return self&value.'
        ...
    
    def __array__(self, dtype=...) -> typing.Any:
        'a.__array__([dtype], /)\n\n    Returns either a new reference to self if dtype is not given or a new array\n    of provided data type if dtype is different from the current dtype of the\n    array.'
        ...
    
    def __array_finalize__(self, obj) -> typing.Any:
        'a.__array_finalize__(obj, /)\n\n    Present so subclasses can call super. Does nothing.'
        ...
    
    def __array_function__(self) -> typing.Any:
        ...
    
    @property
    def __array_interface__(self) -> typing.Any:
        'Array protocol: Python side.'
        ...
    
    def __array_prepare__(self, array, context=...) -> typing.Any:
        'a.__array_prepare__(array[, context], /)\n\n    Returns a view of `array` with the same type as self.'
        ...
    
    @property
    def __array_priority__(self) -> typing.Any:
        'Array priority.'
        ...
    
    @property
    def __array_struct__(self) -> typing.Any:
        'Array protocol: C-struct side.'
        ...
    
    def __array_ufunc__(self) -> typing.Any:
        ...
    
    def __array_wrap__(self, array, context=...) -> typing.Any:
        'a.__array_wrap__(array[, context], /)\n\n    Returns a view of `array` with the same type as self.'
        ...
    
    def __bool__(self) -> bool:
        'True if self else False'
        ...
    
    @classmethod
    def __class_getitem__(cls, item) -> typing.Any:
        'a.__class_getitem__(item, /)\n\n    Return a parametrized wrapper around the `~numpy.ndarray` type.\n\n    .. versionadded:: 1.22\n\n    Returns\n    -------\n    alias : types.GenericAlias\n        A parametrized `~numpy.ndarray` type.\n\n    Examples\n    --------\n    >>> from typing import Any\n    >>> import numpy as np\n\n    >>> np.ndarray[Any, np.dtype[Any]]\n    numpy.ndarray[typing.Any, numpy.dtype[typing.Any]]\n\n    See Also\n    --------\n    :pep:`585` : Type hinting generics in standard collections.\n    numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`\n                        w.r.t. its `dtype.type <numpy.dtype.type>`.'
        ...
    
    def __complex__(self) -> typing.Any:
        ...
    
    def __contains__(self, key) -> bool:
        'Return key in self.'
        ...
    
    def __copy__(self) -> typing.Any:
        "a.__copy__()\n\n    Used if :func:`copy.copy` is called on an array. Returns a copy of the array.\n\n    Equivalent to ``a.copy(order='K')``."
        ...
    
    def __deepcopy__(self, memo) -> typing.Any:
        'a.__deepcopy__(memo, /)\n\n    Used if :func:`copy.deepcopy` is called on an array.'
        ...
    
    def __delitem__(self, key) -> None:
        'Delete self[key].'
        ...
    
    def __divmod__(self, value) -> typing.Tuple[ndarray, ndarray]:
        'Return divmod(self, value).'
        ...
    
    def __dlpack__(self, *, stream=...) -> typing.Any:
        'a.__dlpack__(*, stream=None)\n\n    DLPack Protocol: Part of the Array API.'
        ...
    
    def __dlpack_device__(self) -> typing.Any:
        'a.__dlpack_device__()\n\n    DLPack Protocol: Part of the Array API.'
        ...
    
    def __eq__(self, value) -> bool:
        'Return self==value.'
        ...
    
    def __float__(self) -> float:
        'float(self)'
        ...
    
    def __floordiv__(self, value) -> int:
        'Return self//value.'
        ...
    
    def __format__(self, format_spec: str) -> str:
        ...
    
    def __ge__(self, value) -> bool:
        'Return self>=value.'
        ...
    
    def __getitem__(self, key) -> typing.Any:
        'Return self[key].'
        ...
    
    def __gt__(self, value) -> bool:
        'Return self>value.'
        ...
    
    __hash__: typing.Any
    def __iadd__(self, value) -> None:
        'Return self+=value.'
        ...
    
    def __iand__(self, value) -> None:
        'Return self&=value.'
        ...
    
    def __ifloordiv__(self, value) -> typing.Any:
        'Return self//=value.'
        ...
    
    def __ilshift__(self, value) -> typing.Any:
        'Return self<<=value.'
        ...
    
    def __imatmul__(self, value) -> typing.Any:
        'Return self@=value.'
        ...
    
    def __imod__(self, value) -> typing.Any:
        'Return self%=value.'
        ...
    
    def __imul__(self, value) -> None:
        'Return self*=value.'
        ...
    
    def __index__(self) -> int:
        'Return self converted to an integer, if self is suitable for use as an index into a list.'
        ...
    
    def __init__(self, shape, dtype=..., buffer=..., offset=..., strides=..., order=...) -> None:
        'ndarray(shape, dtype=float, buffer=None, offset=0,\n            strides=None, order=None)\n\n    An array object represents a multidimensional, homogeneous array\n    of fixed-size items.  An associated data-type object describes the\n    format of each element in the array (its byte-order, how many bytes it\n    occupies in memory, whether it is an integer, a floating point number,\n    or something else, etc.)\n\n    Arrays should be constructed using `array`, `zeros` or `empty` (refer\n    to the See Also section below).  The parameters given here refer to\n    a low-level method (`ndarray(...)`) for instantiating an array.\n\n    For more information, refer to the `numpy` module and examine the\n    methods and attributes of an array.\n\n    Parameters\n    ----------\n    (for the __new__ method; see Notes below)\n\n    shape : tuple of ints\n        Shape of created array.\n    dtype : data-type, optional\n        Any object that can be interpreted as a numpy data type.\n    buffer : object exposing buffer interface, optional\n        Used to fill the array with data.\n    offset : int, optional\n        Offset of array data in buffer.\n    strides : tuple of ints, optional\n        Strides of data in memory.\n    order : {\'C\', \'F\'}, optional\n        Row-major (C-style) or column-major (Fortran-style) order.\n\n    Attributes\n    ----------\n    T : ndarray\n        Transpose of the array.\n    data : buffer\n        The array\'s elements, in memory.\n    dtype : dtype object\n        Describes the format of the elements in the array.\n    flags : dict\n        Dictionary containing information related to memory use, e.g.,\n        \'C_CONTIGUOUS\', \'OWNDATA\', \'WRITEABLE\', etc.\n    flat : numpy.flatiter object\n        Flattened version of the array as an iterator.  The iterator\n        allows assignments, e.g., ``x.flat = 3`` (See `ndarray.flat` for\n        assignment examples; TODO).\n    imag : ndarray\n        Imaginary part of the array.\n    real : ndarray\n        Real part of the array.\n    size : int\n        Number of elements in the array.\n    itemsize : int\n        The memory use of each array element in bytes.\n    nbytes : int\n        The total number of bytes required to store the array data,\n        i.e., ``itemsize * size``.\n    ndim : int\n        The array\'s number of dimensions.\n    shape : tuple of ints\n        Shape of the array.\n    strides : tuple of ints\n        The step-size required to move from one element to the next in\n        memory. For example, a contiguous ``(3, 4)`` array of type\n        ``int16`` in C-order has strides ``(8, 2)``.  This implies that\n        to move from element to element in memory requires jumps of 2 bytes.\n        To move from row-to-row, one needs to jump 8 bytes at a time\n        (``2 * 4``).\n    ctypes : ctypes object\n        Class containing properties of the array needed for interaction\n        with ctypes.\n    base : ndarray\n        If the array is a view into another array, that array is its `base`\n        (unless that array is also a view).  The `base` array is where the\n        array data is actually stored.\n\n    See Also\n    --------\n    array : Construct an array.\n    zeros : Create an array, each element of which is zero.\n    empty : Create an array, but leave its allocated memory unchanged (i.e.,\n            it contains "garbage").\n    dtype : Create a data-type.\n    numpy.typing.NDArray : An ndarray alias :term:`generic <generic type>`\n                           w.r.t. its `dtype.type <numpy.dtype.type>`.\n\n    Notes\n    -----\n    There are two modes of creating an array using ``__new__``:\n\n    1. If `buffer` is None, then only `shape`, `dtype`, and `order`\n       are used.\n    2. If `buffer` is an object exposing the buffer interface, then\n       all keywords are interpreted.\n\n    No ``__init__`` method is needed because the array is fully initialized\n    after the ``__new__`` method.\n\n    Examples\n    --------\n    These examples illustrate the low-level `ndarray` constructor.  Refer\n    to the `See Also` section above for easier ways of constructing an\n    ndarray.\n\n    First mode, `buffer` is None:\n\n    >>> np.ndarray(shape=(2,2), dtype=float, order=\'F\')\n    array([[0.0e+000, 0.0e+000], # random\n           [     nan, 2.5e-323]])\n\n    Second mode:\n\n    >>> np.ndarray((2,), buffer=np.array([1,2,3]),\n    ...            offset=np.int_().itemsize,\n    ...            dtype=int) # offset = 1*itemsize, i.e. skip first element\n    array([2, 3])'
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    def __int__(self) -> int:
        'int(self)'
        ...
    
    def __invert__(self) -> ndarray:
        '~self'
        ...
    
    def __ior__(self, value) -> None:
        'Return self|=value.'
        ...
    
    def __ipow__(self, value) -> typing.Any:
        'Return self**=value.'
        ...
    
    def __irshift__(self, value) -> typing.Any:
        'Return self>>=value.'
        ...
    
    def __isub__(self, value) -> None:
        'Return self-=value.'
        ...
    
    def __iter__(self) -> ndarray:
        'Implement iter(self).'
        ...
    
    def __itruediv__(self, value) -> typing.Any:
        'Return self/=value.'
        ...
    
    def __ixor__(self, value) -> None:
        'Return self^=value.'
        ...
    
    def __le__(self, value) -> bool:
        'Return self<=value.'
        ...
    
    def __len__(self) -> int:
        'Return len(self).'
        ...
    
    def __lshift__(self, value) -> ndarray:
        'Return self<<value.'
        ...
    
    def __lt__(self, value) -> bool:
        'Return self<value.'
        ...
    
    def __matmul__(self, value) -> typing.Any:
        'Return self@value.'
        ...
    
    def __mod__(self, value) -> ndarray:
        'Return self%value.'
        ...
    
    def __mul__(self, value) -> ndarray:
        'Return self*value.'
        ...
    
    def __ne__(self, value) -> bool:
        'Return self!=value.'
        ...
    
    def __neg__(self) -> ndarray:
        '-self'
        ...
    
    def __or__(self, value) -> ndarray:
        'Return self|value.'
        ...
    
    def __pos__(self) -> ndarray:
        '+self'
        ...
    
    def __pow__(self, value, mod) -> ndarray:
        'Return pow(self, value, mod).'
        ...
    
    def __radd__(self, value) -> ndarray:
        'Return value+self.'
        ...
    
    def __rand__(self, value) -> ndarray:
        'Return value&self.'
        ...
    
    def __rdivmod__(self, value) -> typing.Tuple[ndarray, ndarray]:
        'Return divmod(value, self).'
        ...
    
    def __reduce__(self) -> typing.Union[str, typing.Tuple[typing.Any, ...]]:
        'a.__reduce__()\n\n    For pickling.'
        ...
    
    def __reduce_ex__(self, protocol: int) -> typing.Union[str, typing.Tuple[typing.Any, ...]]:
        ...
    
    def __repr__(self) -> str:
        'Return repr(self).'
        ...
    
    def __rfloordiv__(self, value) -> ndarray:
        'Return value//self.'
        ...
    
    def __rlshift__(self, value) -> ndarray:
        'Return value<<self.'
        ...
    
    def __rmatmul__(self, value) -> typing.Any:
        'Return value@self.'
        ...
    
    def __rmod__(self, value) -> ndarray:
        'Return value%self.'
        ...
    
    def __rmul__(self, value) -> ndarray:
        'Return value*self.'
        ...
    
    def __ror__(self, value) -> ndarray:
        'Return value|self.'
        ...
    
    def __rpow__(self, value, mod) -> ndarray:
        'Return pow(value, self, mod).'
        ...
    
    def __rrshift__(self, value) -> ndarray:
        'Return value>>self.'
        ...
    
    def __rshift__(self, value) -> ndarray:
        'Return self>>value.'
        ...
    
    def __rsub__(self, value) -> ndarray:
        'Return value-self.'
        ...
    
    def __rtruediv__(self, value) -> ndarray:
        'Return value/self.'
        ...
    
    def __rxor__(self, value) -> ndarray:
        'Return value^self.'
        ...
    
    def __setitem__(self, key, value) -> None:
        'Set self[key] to value.'
        ...
    
    def __setstate__(self, state: typing.Any) -> None:
        "a.__setstate__(state, /)\n\n    For unpickling.\n\n    The `state` argument must be a sequence that contains the following\n    elements:\n\n    Parameters\n    ----------\n    version : int\n        optional pickle version. If omitted defaults to 0.\n    shape : tuple\n    dtype : data-type\n    isFortran : bool\n    rawdata : string or list\n        a binary string with the data (or a list if 'a' is an object array)"
        ...
    
    def __sizeof__(self) -> int:
        ...
    
    def __str__(self) -> str:
        'Return str(self).'
        ...
    
    def __sub__(self, value) -> ndarray:
        'Return self-value.'
        ...
    
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    def __truediv__(self, value) -> float:
        'Return self/value.'
        ...
    
    def __xor__(self, value) -> ndarray:
        'Return self^value.'
        ...
    
    def all(self, axis=..., out=..., keepdims=..., *, where=...) -> typing.Any:
        'a.all(axis=None, out=None, keepdims=False, *, where=True)\n\n    Returns True if all elements evaluate to True.\n\n    Refer to `numpy.all` for full documentation.\n\n    See Also\n    --------\n    numpy.all : equivalent function'
        ...
    
    def any(self, axis=..., out=..., keepdims=..., *, where=...) -> typing.Any:
        'a.any(axis=None, out=None, keepdims=False, *, where=True)\n\n    Returns True if any of the elements of `a` evaluate to True.\n\n    Refer to `numpy.any` for full documentation.\n\n    See Also\n    --------\n    numpy.any : equivalent function'
        ...
    
    def argmax(self, axis=..., out=..., *, keepdims=...) -> typing.Any:
        'a.argmax(axis=None, out=None, *, keepdims=False)\n\n    Return indices of the maximum values along the given axis.\n\n    Refer to `numpy.argmax` for full documentation.\n\n    See Also\n    --------\n    numpy.argmax : equivalent function'
        ...
    
    def argmin(self, axis=..., out=..., *, keepdims=...) -> typing.Any:
        'a.argmin(axis=None, out=None, *, keepdims=False)\n\n    Return indices of the minimum values along the given axis.\n\n    Refer to `numpy.argmin` for detailed documentation.\n\n    See Also\n    --------\n    numpy.argmin : equivalent function'
        ...
    
    def argpartition(self, kth, axis=..., kind=..., order=...) -> typing.Any:
        "a.argpartition(kth, axis=-1, kind='introselect', order=None)\n\n    Returns the indices that would partition this array.\n\n    Refer to `numpy.argpartition` for full documentation.\n\n    .. versionadded:: 1.8.0\n\n    See Also\n    --------\n    numpy.argpartition : equivalent function"
        ...
    
    def argsort(self, axis=..., kind=..., order=...) -> typing.Any:
        'a.argsort(axis=-1, kind=None, order=None)\n\n    Returns the indices that would sort this array.\n\n    Refer to `numpy.argsort` for full documentation.\n\n    See Also\n    --------\n    numpy.argsort : equivalent function'
        ...
    
    def astype(self, dtype, order=..., casting=..., subok=..., copy=...) -> typing.Any:
        'a.astype(dtype, order=\'K\', casting=\'unsafe\', subok=True, copy=True)\n\n    Copy of the array, cast to a specified type.\n\n    Parameters\n    ----------\n    dtype : str or dtype\n        Typecode or data-type to which the array is cast.\n    order : {\'C\', \'F\', \'A\', \'K\'}, optional\n        Controls the memory layout order of the result.\n        \'C\' means C order, \'F\' means Fortran order, \'A\'\n        means \'F\' order if all the arrays are Fortran contiguous,\n        \'C\' order otherwise, and \'K\' means as close to the\n        order the array elements appear in memory as possible.\n        Default is \'K\'.\n    casting : {\'no\', \'equiv\', \'safe\', \'same_kind\', \'unsafe\'}, optional\n        Controls what kind of data casting may occur. Defaults to \'unsafe\'\n        for backwards compatibility.\n\n          * \'no\' means the data types should not be cast at all.\n          * \'equiv\' means only byte-order changes are allowed.\n          * \'safe\' means only casts which can preserve values are allowed.\n          * \'same_kind\' means only safe casts or casts within a kind,\n            like float64 to float32, are allowed.\n          * \'unsafe\' means any data conversions may be done.\n    subok : bool, optional\n        If True, then sub-classes will be passed-through (default), otherwise\n        the returned array will be forced to be a base-class array.\n    copy : bool, optional\n        By default, astype always returns a newly allocated array. If this\n        is set to false, and the `dtype`, `order`, and `subok`\n        requirements are satisfied, the input array is returned instead\n        of a copy.\n\n    Returns\n    -------\n    arr_t : ndarray\n        Unless `copy` is False and the other conditions for returning the input\n        array are satisfied (see description for `copy` input parameter), `arr_t`\n        is a new array of the same shape as the input array, with dtype, order\n        given by `dtype`, `order`.\n\n    Notes\n    -----\n    .. versionchanged:: 1.17.0\n       Casting between a simple data type and a structured one is possible only\n       for "unsafe" casting.  Casting to multiple fields is allowed, but\n       casting from multiple fields is not.\n\n    .. versionchanged:: 1.9.0\n       Casting from numeric to string types in \'safe\' casting mode requires\n       that the string dtype length is long enough to store the max\n       integer/float value converted.\n\n    Raises\n    ------\n    ComplexWarning\n        When casting from complex to float or int. To avoid this,\n        one should use ``a.real.astype(t)``.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 2.5])\n    >>> x\n    array([1. ,  2. ,  2.5])\n\n    >>> x.astype(int)\n    array([1, 2, 2])'
        ...
    
    @property
    def base(self) -> typing.Any:
        'Base object if memory is from some other object.\n\n    Examples\n    --------\n    The base of an array that owns its memory is None:\n\n    >>> x = np.array([1,2,3,4])\n    >>> x.base is None\n    True\n\n    Slicing creates a view, whose memory is shared with x:\n\n    >>> y = x[2:]\n    >>> y.base is x\n    True'
        ...
    
    def byteswap(self, inplace=...) -> typing.Any:
        "a.byteswap(inplace=False)\n\n    Swap the bytes of the array elements\n\n    Toggle between low-endian and big-endian data representation by\n    returning a byteswapped array, optionally swapped in-place.\n    Arrays of byte-strings are not swapped. The real and imaginary\n    parts of a complex number are swapped individually.\n\n    Parameters\n    ----------\n    inplace : bool, optional\n        If ``True``, swap bytes in-place, default is ``False``.\n\n    Returns\n    -------\n    out : ndarray\n        The byteswapped array. If `inplace` is ``True``, this is\n        a view to self.\n\n    Examples\n    --------\n    >>> A = np.array([1, 256, 8755], dtype=np.int16)\n    >>> list(map(hex, A))\n    ['0x1', '0x100', '0x2233']\n    >>> A.byteswap(inplace=True)\n    array([  256,     1, 13090], dtype=int16)\n    >>> list(map(hex, A))\n    ['0x100', '0x1', '0x3322']\n\n    Arrays of byte-strings are not swapped\n\n    >>> A = np.array([b'ceg', b'fac'])\n    >>> A.byteswap()\n    array([b'ceg', b'fac'], dtype='|S3')\n\n    ``A.newbyteorder().byteswap()`` produces an array with the same values\n      but different representation in memory\n\n    >>> A = np.array([1, 2, 3])\n    >>> A.view(np.uint8)\n    array([1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0,\n           0, 0], dtype=uint8)\n    >>> A.newbyteorder().byteswap(inplace=True)\n    array([1, 2, 3])\n    >>> A.view(np.uint8)\n    array([0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,\n           0, 3], dtype=uint8)"
        ...
    
    def choose(self, choices, out=..., mode=...) -> typing.Any:
        "a.choose(choices, out=None, mode='raise')\n\n    Use an index array to construct a new array from a set of choices.\n\n    Refer to `numpy.choose` for full documentation.\n\n    See Also\n    --------\n    numpy.choose : equivalent function"
        ...
    
    def clip(self, min=..., max=..., out=..., **kwargs) -> typing.Any:
        'a.clip(min=None, max=None, out=None, **kwargs)\n\n    Return an array whose values are limited to ``[min, max]``.\n    One of max or min must be given.\n\n    Refer to `numpy.clip` for full documentation.\n\n    See Also\n    --------\n    numpy.clip : equivalent function'
        ...
    
    def compress(self, condition, axis=..., out=...) -> typing.Any:
        'a.compress(condition, axis=None, out=None)\n\n    Return selected slices of this array along given axis.\n\n    Refer to `numpy.compress` for full documentation.\n\n    See Also\n    --------\n    numpy.compress : equivalent function'
        ...
    
    def conj(self) -> typing.Any:
        'a.conj()\n\n    Complex-conjugate all elements.\n\n    Refer to `numpy.conjugate` for full documentation.\n\n    See Also\n    --------\n    numpy.conjugate : equivalent function'
        ...
    
    def conjugate(self) -> typing.Any:
        'a.conjugate()\n\n    Return the complex conjugate, element-wise.\n\n    Refer to `numpy.conjugate` for full documentation.\n\n    See Also\n    --------\n    numpy.conjugate : equivalent function'
        ...
    
    def copy(self, order=...) -> typing.Any:
        "a.copy(order='C')\n\n    Return a copy of the array.\n\n    Parameters\n    ----------\n    order : {'C', 'F', 'A', 'K'}, optional\n        Controls the memory layout of the copy. 'C' means C-order,\n        'F' means F-order, 'A' means 'F' if `a` is Fortran contiguous,\n        'C' otherwise. 'K' means match the layout of `a` as closely\n        as possible. (Note that this function and :func:`numpy.copy` are very\n        similar but have different default values for their order=\n        arguments, and this function always passes sub-classes through.)\n\n    See also\n    --------\n    numpy.copy : Similar function with different default behavior\n    numpy.copyto\n\n    Notes\n    -----\n    This function is the preferred method for creating an array copy.  The\n    function :func:`numpy.copy` is similar, but it defaults to using order 'K',\n    and will not pass sub-classes through by default.\n\n    Examples\n    --------\n    >>> x = np.array([[1,2,3],[4,5,6]], order='F')\n\n    >>> y = x.copy()\n\n    >>> x.fill(0)\n\n    >>> x\n    array([[0, 0, 0],\n           [0, 0, 0]])\n\n    >>> y\n    array([[1, 2, 3],\n           [4, 5, 6]])\n\n    >>> y.flags['C_CONTIGUOUS']\n    True"
        ...
    
    @property
    def ctypes(self) -> typing.Any:
        'An object to simplify the interaction of the array with the ctypes\n    module.\n\n    This attribute creates an object that makes it easier to use arrays\n    when calling shared libraries with the ctypes module. The returned\n    object has, among others, data, shape, and strides attributes (see\n    Notes below) which themselves return ctypes objects that can be used\n    as arguments to a shared library.\n\n    Parameters\n    ----------\n    None\n\n    Returns\n    -------\n    c : Python object\n        Possessing attributes data, shape, strides, etc.\n\n    See Also\n    --------\n    numpy.ctypeslib\n\n    Notes\n    -----\n    Below are the public attributes of this object which were documented\n    in "Guide to NumPy" (we have omitted undocumented public attributes,\n    as well as documented private attributes):\n\n    .. autoattribute:: numpy.core._internal._ctypes.data\n        :noindex:\n\n    .. autoattribute:: numpy.core._internal._ctypes.shape\n        :noindex:\n\n    .. autoattribute:: numpy.core._internal._ctypes.strides\n        :noindex:\n\n    .. automethod:: numpy.core._internal._ctypes.data_as\n        :noindex:\n\n    .. automethod:: numpy.core._internal._ctypes.shape_as\n        :noindex:\n\n    .. automethod:: numpy.core._internal._ctypes.strides_as\n        :noindex:\n\n    If the ctypes module is not available, then the ctypes attribute\n    of array objects still returns something useful, but ctypes objects\n    are not returned and errors may be raised instead. In particular,\n    the object will still have the ``as_parameter`` attribute which will\n    return an integer equal to the data attribute.\n\n    Examples\n    --------\n    >>> import ctypes\n    >>> x = np.array([[0, 1], [2, 3]], dtype=np.int32)\n    >>> x\n    array([[0, 1],\n           [2, 3]], dtype=int32)\n    >>> x.ctypes.data\n    31962608 # may vary\n    >>> x.ctypes.data_as(ctypes.POINTER(ctypes.c_uint32))\n    <__main__.LP_c_uint object at 0x7ff2fc1fc200> # may vary\n    >>> x.ctypes.data_as(ctypes.POINTER(ctypes.c_uint32)).contents\n    c_uint(0)\n    >>> x.ctypes.data_as(ctypes.POINTER(ctypes.c_uint64)).contents\n    c_ulong(4294967296)\n    >>> x.ctypes.shape\n    <numpy.core._internal.c_long_Array_2 object at 0x7ff2fc1fce60> # may vary\n    >>> x.ctypes.strides\n    <numpy.core._internal.c_long_Array_2 object at 0x7ff2fc1ff320> # may vary'
        ...
    
    def cumprod(self, axis=..., dtype=..., out=...) -> typing.Any:
        'a.cumprod(axis=None, dtype=None, out=None)\n\n    Return the cumulative product of the elements along the given axis.\n\n    Refer to `numpy.cumprod` for full documentation.\n\n    See Also\n    --------\n    numpy.cumprod : equivalent function'
        ...
    
    def cumsum(self, axis=..., dtype=..., out=...) -> typing.Any:
        'a.cumsum(axis=None, dtype=None, out=None)\n\n    Return the cumulative sum of the elements along the given axis.\n\n    Refer to `numpy.cumsum` for full documentation.\n\n    See Also\n    --------\n    numpy.cumsum : equivalent function'
        ...
    
    @property
    def data(self) -> typing.Any:
        "Python buffer object pointing to the start of the array's data."
        ...
    
    def diagonal(self, offset=..., axis1=..., axis2=...) -> typing.Any:
        'a.diagonal(offset=0, axis1=0, axis2=1)\n\n    Return specified diagonals. In NumPy 1.9 the returned array is a\n    read-only view instead of a copy as in previous NumPy versions.  In\n    a future version the read-only restriction will be removed.\n\n    Refer to :func:`numpy.diagonal` for full documentation.\n\n    See Also\n    --------\n    numpy.diagonal : equivalent function'
        ...
    
    def dot(self) -> typing.Any:
        ...
    
    @property
    def dtype(self) -> typing.Any:
        "Data-type of the array's elements.\n\n    .. warning::\n\n        Setting ``arr.dtype`` is discouraged and may be deprecated in the\n        future.  Setting will replace the ``dtype`` without modifying the\n        memory (see also `ndarray.view` and `ndarray.astype`).\n\n    Parameters\n    ----------\n    None\n\n    Returns\n    -------\n    d : numpy dtype object\n\n    See Also\n    --------\n    ndarray.astype : Cast the values contained in the array to a new data-type.\n    ndarray.view : Create a view of the same data but a different data-type.\n    numpy.dtype\n\n    Examples\n    --------\n    >>> x\n    array([[0, 1],\n           [2, 3]])\n    >>> x.dtype\n    dtype('int32')\n    >>> type(x.dtype)\n    <type 'numpy.dtype'>"
        ...
    
    def dump(self, file) -> typing.Any:
        'a.dump(file)\n\n    Dump a pickle of the array to the specified file.\n    The array can be read back with pickle.load or numpy.load.\n\n    Parameters\n    ----------\n    file : str or Path\n        A string naming the dump file.\n\n        .. versionchanged:: 1.17.0\n            `pathlib.Path` objects are now accepted.'
        ...
    
    def dumps(self) -> typing.Any:
        'a.dumps()\n\n    Returns the pickle of the array as a string.\n    pickle.loads will convert the string back to an array.\n\n    Parameters\n    ----------\n    None'
        ...
    
    def fill(self, value) -> typing.Any:
        'a.fill(value)\n\n    Fill the array with a scalar value.\n\n    Parameters\n    ----------\n    value : scalar\n        All elements of `a` will be assigned this value.\n\n    Examples\n    --------\n    >>> a = np.array([1, 2])\n    >>> a.fill(0)\n    >>> a\n    array([0, 0])\n    >>> a = np.empty(2)\n    >>> a.fill(1)\n    >>> a\n    array([1.,  1.])\n\n    Fill expects a scalar value and always behaves the same as assigning\n    to a single array element.  The following is a rare example where this\n    distinction is important:\n\n    >>> a = np.array([None, None], dtype=object)\n    >>> a[0] = np.array(3)\n    >>> a\n    array([array(3), None], dtype=object)\n    >>> a.fill(np.array(3))\n    >>> a\n    array([array(3), array(3)], dtype=object)\n\n    Where other forms of assignments will unpack the array being assigned:\n\n    >>> a[...] = np.array(3)\n    >>> a\n    array([3, 3], dtype=object)'
        ...
    
    @property
    def flags(self) -> typing.Any:
        "Information about the memory layout of the array.\n\n    Attributes\n    ----------\n    C_CONTIGUOUS (C)\n        The data is in a single, C-style contiguous segment.\n    F_CONTIGUOUS (F)\n        The data is in a single, Fortran-style contiguous segment.\n    OWNDATA (O)\n        The array owns the memory it uses or borrows it from another object.\n    WRITEABLE (W)\n        The data area can be written to.  Setting this to False locks\n        the data, making it read-only.  A view (slice, etc.) inherits WRITEABLE\n        from its base array at creation time, but a view of a writeable\n        array may be subsequently locked while the base array remains writeable.\n        (The opposite is not true, in that a view of a locked array may not\n        be made writeable.  However, currently, locking a base object does not\n        lock any views that already reference it, so under that circumstance it\n        is possible to alter the contents of a locked array via a previously\n        created writeable view onto it.)  Attempting to change a non-writeable\n        array raises a RuntimeError exception.\n    ALIGNED (A)\n        The data and all elements are aligned appropriately for the hardware.\n    WRITEBACKIFCOPY (X)\n        This array is a copy of some other array. The C-API function\n        PyArray_ResolveWritebackIfCopy must be called before deallocating\n        to the base array will be updated with the contents of this array.\n    FNC\n        F_CONTIGUOUS and not C_CONTIGUOUS.\n    FORC\n        F_CONTIGUOUS or C_CONTIGUOUS (one-segment test).\n    BEHAVED (B)\n        ALIGNED and WRITEABLE.\n    CARRAY (CA)\n        BEHAVED and C_CONTIGUOUS.\n    FARRAY (FA)\n        BEHAVED and F_CONTIGUOUS and not C_CONTIGUOUS.\n\n    Notes\n    -----\n    The `flags` object can be accessed dictionary-like (as in ``a.flags['WRITEABLE']``),\n    or by using lowercased attribute names (as in ``a.flags.writeable``). Short flag\n    names are only supported in dictionary access.\n\n    Only the WRITEBACKIFCOPY, WRITEABLE, and ALIGNED flags can be\n    changed by the user, via direct assignment to the attribute or dictionary\n    entry, or by calling `ndarray.setflags`.\n\n    The array flags cannot be set arbitrarily:\n\n    - WRITEBACKIFCOPY can only be set ``False``.\n    - ALIGNED can only be set ``True`` if the data is truly aligned.\n    - WRITEABLE can only be set ``True`` if the array owns its own memory\n      or the ultimate owner of the memory exposes a writeable buffer\n      interface or is a string.\n\n    Arrays can be both C-style and Fortran-style contiguous simultaneously.\n    This is clear for 1-dimensional arrays, but can also be true for higher\n    dimensional arrays.\n\n    Even for contiguous arrays a stride for a given dimension\n    ``arr.strides[dim]`` may be *arbitrary* if ``arr.shape[dim] == 1``\n    or the array has no elements.\n    It does *not* generally hold that ``self.strides[-1] == self.itemsize``\n    for C-style contiguous arrays or ``self.strides[0] == self.itemsize`` for\n    Fortran-style contiguous arrays is true."
        ...
    
    @property
    def flat(self) -> typing.Any:
        "A 1-D iterator over the array.\n\n    This is a `numpy.flatiter` instance, which acts similarly to, but is not\n    a subclass of, Python's built-in iterator object.\n\n    See Also\n    --------\n    flatten : Return a copy of the array collapsed into one dimension.\n\n    flatiter\n\n    Examples\n    --------\n    >>> x = np.arange(1, 7).reshape(2, 3)\n    >>> x\n    array([[1, 2, 3],\n           [4, 5, 6]])\n    >>> x.flat[3]\n    4\n    >>> x.T\n    array([[1, 4],\n           [2, 5],\n           [3, 6]])\n    >>> x.T.flat[3]\n    5\n    >>> type(x.flat)\n    <class 'numpy.flatiter'>\n\n    An assignment example:\n\n    >>> x.flat = 3; x\n    array([[3, 3, 3],\n           [3, 3, 3]])\n    >>> x.flat[[1,4]] = 1; x\n    array([[3, 1, 3],\n           [3, 1, 3]])"
        ...
    
    def flatten(self, order=...) -> typing.Any:
        "a.flatten(order='C')\n\n    Return a copy of the array collapsed into one dimension.\n\n    Parameters\n    ----------\n    order : {'C', 'F', 'A', 'K'}, optional\n        'C' means to flatten in row-major (C-style) order.\n        'F' means to flatten in column-major (Fortran-\n        style) order. 'A' means to flatten in column-major\n        order if `a` is Fortran *contiguous* in memory,\n        row-major order otherwise. 'K' means to flatten\n        `a` in the order the elements occur in memory.\n        The default is 'C'.\n\n    Returns\n    -------\n    y : ndarray\n        A copy of the input array, flattened to one dimension.\n\n    See Also\n    --------\n    ravel : Return a flattened array.\n    flat : A 1-D flat iterator over the array.\n\n    Examples\n    --------\n    >>> a = np.array([[1,2], [3,4]])\n    >>> a.flatten()\n    array([1, 2, 3, 4])\n    >>> a.flatten('F')\n    array([1, 3, 2, 4])"
        ...
    
    def getfield(self, dtype, offset=...) -> typing.Any:
        'a.getfield(dtype, offset=0)\n\n    Returns a field of the given array as a certain type.\n\n    A field is a view of the array data with a given data-type. The values in\n    the view are determined by the given type and the offset into the current\n    array in bytes. The offset needs to be such that the view dtype fits in the\n    array dtype; for example an array of dtype complex128 has 16-byte elements.\n    If taking a view with a 32-bit integer (4 bytes), the offset needs to be\n    between 0 and 12 bytes.\n\n    Parameters\n    ----------\n    dtype : str or dtype\n        The data type of the view. The dtype size of the view can not be larger\n        than that of the array itself.\n    offset : int\n        Number of bytes to skip before beginning the element view.\n\n    Examples\n    --------\n    >>> x = np.diag([1.+1.j]*2)\n    >>> x[1, 1] = 2 + 4.j\n    >>> x\n    array([[1.+1.j,  0.+0.j],\n           [0.+0.j,  2.+4.j]])\n    >>> x.getfield(np.float64)\n    array([[1.,  0.],\n           [0.,  2.]])\n\n    By choosing an offset of 8 bytes we can select the complex part of the\n    array for our view:\n\n    >>> x.getfield(np.float64, offset=8)\n    array([[1.,  0.],\n           [0.,  4.]])'
        ...
    
    @property
    def imag(self) -> typing.Any:
        "The imaginary part of the array.\n\n    Examples\n    --------\n    >>> x = np.sqrt([1+0j, 0+1j])\n    >>> x.imag\n    array([ 0.        ,  0.70710678])\n    >>> x.imag.dtype\n    dtype('float64')"
        ...
    
    def item(self, *args) -> typing.Any:
        "a.item(*args)\n\n    Copy an element of an array to a standard Python scalar and return it.\n\n    Parameters\n    ----------\n    \\*args : Arguments (variable number and type)\n\n        * none: in this case, the method only works for arrays\n          with one element (`a.size == 1`), which element is\n          copied into a standard Python scalar object and returned.\n\n        * int_type: this argument is interpreted as a flat index into\n          the array, specifying which element to copy and return.\n\n        * tuple of int_types: functions as does a single int_type argument,\n          except that the argument is interpreted as an nd-index into the\n          array.\n\n    Returns\n    -------\n    z : Standard Python scalar object\n        A copy of the specified element of the array as a suitable\n        Python scalar\n\n    Notes\n    -----\n    When the data type of `a` is longdouble or clongdouble, item() returns\n    a scalar array object because there is no available Python scalar that\n    would not lose information. Void arrays return a buffer object for item(),\n    unless fields are defined, in which case a tuple is returned.\n\n    `item` is very similar to a[args], except, instead of an array scalar,\n    a standard Python scalar is returned. This can be useful for speeding up\n    access to elements of the array and doing arithmetic on elements of the\n    array using Python's optimized math.\n\n    Examples\n    --------\n    >>> np.random.seed(123)\n    >>> x = np.random.randint(9, size=(3, 3))\n    >>> x\n    array([[2, 2, 6],\n           [1, 3, 6],\n           [1, 0, 1]])\n    >>> x.item(3)\n    1\n    >>> x.item(7)\n    0\n    >>> x.item((0, 1))\n    2\n    >>> x.item((2, 2))\n    1"
        ...
    
    def itemset(self, *args) -> typing.Any:
        "a.itemset(*args)\n\n    Insert scalar into an array (scalar is cast to array's dtype, if possible)\n\n    There must be at least 1 argument, and define the last argument\n    as *item*.  Then, ``a.itemset(*args)`` is equivalent to but faster\n    than ``a[args] = item``.  The item should be a scalar value and `args`\n    must select a single item in the array `a`.\n\n    Parameters\n    ----------\n    \\*args : Arguments\n        If one argument: a scalar, only used in case `a` is of size 1.\n        If two arguments: the last argument is the value to be set\n        and must be a scalar, the first argument specifies a single array\n        element location. It is either an int or a tuple.\n\n    Notes\n    -----\n    Compared to indexing syntax, `itemset` provides some speed increase\n    for placing a scalar into a particular location in an `ndarray`,\n    if you must do this.  However, generally this is discouraged:\n    among other problems, it complicates the appearance of the code.\n    Also, when using `itemset` (and `item`) inside a loop, be sure\n    to assign the methods to a local variable to avoid the attribute\n    look-up at each loop iteration.\n\n    Examples\n    --------\n    >>> np.random.seed(123)\n    >>> x = np.random.randint(9, size=(3, 3))\n    >>> x\n    array([[2, 2, 6],\n           [1, 3, 6],\n           [1, 0, 1]])\n    >>> x.itemset(4, 0)\n    >>> x.itemset((2, 2), 9)\n    >>> x\n    array([[2, 2, 6],\n           [1, 0, 6],\n           [1, 0, 9]])"
        ...
    
    @property
    def itemsize(self) -> typing.Any:
        'Length of one array element in bytes.\n\n    Examples\n    --------\n    >>> x = np.array([1,2,3], dtype=np.float64)\n    >>> x.itemsize\n    8\n    >>> x = np.array([1,2,3], dtype=np.complex128)\n    >>> x.itemsize\n    16'
        ...
    
    def max(self, axis=..., out=..., keepdims=..., initial=..., where=...) -> typing.Any:
        'a.max(axis=None, out=None, keepdims=False, initial=<no value>, where=True)\n\n    Return the maximum along a given axis.\n\n    Refer to `numpy.amax` for full documentation.\n\n    See Also\n    --------\n    numpy.amax : equivalent function'
        ...
    
    def mean(self, axis=..., dtype=..., out=..., keepdims=..., *, where=...) -> typing.Any:
        'a.mean(axis=None, dtype=None, out=None, keepdims=False, *, where=True)\n\n    Returns the average of the array elements along given axis.\n\n    Refer to `numpy.mean` for full documentation.\n\n    See Also\n    --------\n    numpy.mean : equivalent function'
        ...
    
    def min(self, axis=..., out=..., keepdims=..., initial=..., where=...) -> typing.Any:
        'a.min(axis=None, out=None, keepdims=False, initial=<no value>, where=True)\n\n    Return the minimum along a given axis.\n\n    Refer to `numpy.amin` for full documentation.\n\n    See Also\n    --------\n    numpy.amin : equivalent function'
        ...
    
    @property
    def nbytes(self) -> typing.Any:
        'Total bytes consumed by the elements of the array.\n\n    Notes\n    -----\n    Does not include memory consumed by non-element attributes of the\n    array object.\n\n    See Also\n    --------\n    sys.getsizeof\n        Memory consumed by the object itself without parents in case view.\n        This does include memory consumed by non-element attributes.\n\n    Examples\n    --------\n    >>> x = np.zeros((3,5,2), dtype=np.complex128)\n    >>> x.nbytes\n    480\n    >>> np.prod(x.shape) * x.itemsize\n    480'
        ...
    
    @property
    def ndim(self) -> typing.Any:
        'Number of array dimensions.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3])\n    >>> x.ndim\n    1\n    >>> y = np.zeros((2, 3, 4))\n    >>> y.ndim\n    3'
        ...
    
    def newbyteorder(self, new_order=...) -> typing.Any:
        "arr.newbyteorder(new_order='S', /)\n\n    Return the array with the same data viewed with a different byte order.\n\n    Equivalent to::\n\n        arr.view(arr.dtype.newbytorder(new_order))\n\n    Changes are also made in all fields and sub-arrays of the array data\n    type.\n\n\n\n    Parameters\n    ----------\n    new_order : string, optional\n        Byte order to force; a value from the byte order specifications\n        below. `new_order` codes can be any of:\n\n        * 'S' - swap dtype from current to opposite endian\n        * {'<', 'little'} - little endian\n        * {'>', 'big'} - big endian\n        * {'=', 'native'} - native order, equivalent to `sys.byteorder`\n        * {'|', 'I'} - ignore (no change to byte order)\n\n        The default value ('S') results in swapping the current\n        byte order.\n\n\n    Returns\n    -------\n    new_arr : array\n        New array object with the dtype reflecting given change to the\n        byte order."
        ...
    
    def nonzero(self) -> typing.Any:
        'a.nonzero()\n\n    Return the indices of the elements that are non-zero.\n\n    Refer to `numpy.nonzero` for full documentation.\n\n    See Also\n    --------\n    numpy.nonzero : equivalent function'
        ...
    
    def partition(self, kth, axis=..., kind=..., order=...) -> typing.Any:
        "a.partition(kth, axis=-1, kind='introselect', order=None)\n\n    Rearranges the elements in the array in such a way that the value of the\n    element in kth position is in the position it would be in a sorted array.\n    All elements smaller than the kth element are moved before this element and\n    all equal or greater are moved behind it. The ordering of the elements in\n    the two partitions is undefined.\n\n    .. versionadded:: 1.8.0\n\n    Parameters\n    ----------\n    kth : int or sequence of ints\n        Element index to partition by. The kth element value will be in its\n        final sorted position and all smaller elements will be moved before it\n        and all equal or greater elements behind it.\n        The order of all elements in the partitions is undefined.\n        If provided with a sequence of kth it will partition all elements\n        indexed by kth of them into their sorted position at once.\n\n        .. deprecated:: 1.22.0\n            Passing booleans as index is deprecated.\n    axis : int, optional\n        Axis along which to sort. Default is -1, which means sort along the\n        last axis.\n    kind : {'introselect'}, optional\n        Selection algorithm. Default is 'introselect'.\n    order : str or list of str, optional\n        When `a` is an array with fields defined, this argument specifies\n        which fields to compare first, second, etc. A single field can\n        be specified as a string, and not all fields need to be specified,\n        but unspecified fields will still be used, in the order in which\n        they come up in the dtype, to break ties.\n\n    See Also\n    --------\n    numpy.partition : Return a partitioned copy of an array.\n    argpartition : Indirect partition.\n    sort : Full sort.\n\n    Notes\n    -----\n    See ``np.partition`` for notes on the different algorithms.\n\n    Examples\n    --------\n    >>> a = np.array([3, 4, 2, 1])\n    >>> a.partition(3)\n    >>> a\n    array([2, 1, 3, 4])\n\n    >>> a.partition((1, 3))\n    >>> a\n    array([1, 2, 3, 4])"
        ...
    
    def prod(self, axis=..., dtype=..., out=..., keepdims=..., initial=..., where=...) -> typing.Any:
        'a.prod(axis=None, dtype=None, out=None, keepdims=False, initial=1, where=True)\n\n    Return the product of the array elements over the given axis\n\n    Refer to `numpy.prod` for full documentation.\n\n    See Also\n    --------\n    numpy.prod : equivalent function'
        ...
    
    def ptp(self, axis=..., out=..., keepdims=...) -> typing.Any:
        'a.ptp(axis=None, out=None, keepdims=False)\n\n    Peak to peak (maximum - minimum) value along a given axis.\n\n    Refer to `numpy.ptp` for full documentation.\n\n    See Also\n    --------\n    numpy.ptp : equivalent function'
        ...
    
    def put(self, indices, values, mode=...) -> typing.Any:
        "a.put(indices, values, mode='raise')\n\n    Set ``a.flat[n] = values[n]`` for all `n` in indices.\n\n    Refer to `numpy.put` for full documentation.\n\n    See Also\n    --------\n    numpy.put : equivalent function"
        ...
    
    def ravel(self, order=...) -> typing.Any:
        'a.ravel([order])\n\n    Return a flattened array.\n\n    Refer to `numpy.ravel` for full documentation.\n\n    See Also\n    --------\n    numpy.ravel : equivalent function\n\n    ndarray.flat : a flat iterator on the array.'
        ...
    
    @property
    def real(self) -> typing.Any:
        "The real part of the array.\n\n    Examples\n    --------\n    >>> x = np.sqrt([1+0j, 0+1j])\n    >>> x.real\n    array([ 1.        ,  0.70710678])\n    >>> x.real.dtype\n    dtype('float64')\n\n    See Also\n    --------\n    numpy.real : equivalent function"
        ...
    
    def repeat(self, repeats, axis=...) -> typing.Any:
        'a.repeat(repeats, axis=None)\n\n    Repeat elements of an array.\n\n    Refer to `numpy.repeat` for full documentation.\n\n    See Also\n    --------\n    numpy.repeat : equivalent function'
        ...
    
    def reshape(self, shape, order=...) -> typing.Any:
        "a.reshape(shape, order='C')\n\n    Returns an array containing the same data with a new shape.\n\n    Refer to `numpy.reshape` for full documentation.\n\n    See Also\n    --------\n    numpy.reshape : equivalent function\n\n    Notes\n    -----\n    Unlike the free function `numpy.reshape`, this method on `ndarray` allows\n    the elements of the shape parameter to be passed in as separate arguments.\n    For example, ``a.reshape(10, 11)`` is equivalent to\n    ``a.reshape((10, 11))``."
        ...
    
    def resize(self, new_shape, refcheck=...) -> typing.Any:
        "a.resize(new_shape, refcheck=True)\n\n    Change shape and size of array in-place.\n\n    Parameters\n    ----------\n    new_shape : tuple of ints, or `n` ints\n        Shape of resized array.\n    refcheck : bool, optional\n        If False, reference count will not be checked. Default is True.\n\n    Returns\n    -------\n    None\n\n    Raises\n    ------\n    ValueError\n        If `a` does not own its own data or references or views to it exist,\n        and the data memory must be changed.\n        PyPy only: will always raise if the data memory must be changed, since\n        there is no reliable way to determine if references or views to it\n        exist.\n\n    SystemError\n        If the `order` keyword argument is specified. This behaviour is a\n        bug in NumPy.\n\n    See Also\n    --------\n    resize : Return a new array with the specified shape.\n\n    Notes\n    -----\n    This reallocates space for the data area if necessary.\n\n    Only contiguous arrays (data elements consecutive in memory) can be\n    resized.\n\n    The purpose of the reference count check is to make sure you\n    do not use this array as a buffer for another Python object and then\n    reallocate the memory. However, reference counts can increase in\n    other ways so if you are sure that you have not shared the memory\n    for this array with another Python object, then you may safely set\n    `refcheck` to False.\n\n    Examples\n    --------\n    Shrinking an array: array is flattened (in the order that the data are\n    stored in memory), resized, and reshaped:\n\n    >>> a = np.array([[0, 1], [2, 3]], order='C')\n    >>> a.resize((2, 1))\n    >>> a\n    array([[0],\n           [1]])\n\n    >>> a = np.array([[0, 1], [2, 3]], order='F')\n    >>> a.resize((2, 1))\n    >>> a\n    array([[0],\n           [2]])\n\n    Enlarging an array: as above, but missing entries are filled with zeros:\n\n    >>> b = np.array([[0, 1], [2, 3]])\n    >>> b.resize(2, 3) # new_shape parameter doesn't have to be a tuple\n    >>> b\n    array([[0, 1, 2],\n           [3, 0, 0]])\n\n    Referencing an array prevents resizing...\n\n    >>> c = a\n    >>> a.resize((1, 1))\n    Traceback (most recent call last):\n    ...\n    ValueError: cannot resize an array that references or is referenced ...\n\n    Unless `refcheck` is False:\n\n    >>> a.resize((1, 1), refcheck=False)\n    >>> a\n    array([[0]])\n    >>> c\n    array([[0]])"
        ...
    
    def round(self, decimals=..., out=...) -> typing.Any:
        'a.round(decimals=0, out=None)\n\n    Return `a` with each element rounded to the given number of decimals.\n\n    Refer to `numpy.around` for full documentation.\n\n    See Also\n    --------\n    numpy.around : equivalent function'
        ...
    
    def searchsorted(self, v, side=..., sorter=...) -> typing.Any:
        "a.searchsorted(v, side='left', sorter=None)\n\n    Find indices where elements of v should be inserted in a to maintain order.\n\n    For full documentation, see `numpy.searchsorted`\n\n    See Also\n    --------\n    numpy.searchsorted : equivalent function"
        ...
    
    def setfield(self, val, dtype, offset=...) -> typing.Any:
        "a.setfield(val, dtype, offset=0)\n\n    Put a value into a specified place in a field defined by a data-type.\n\n    Place `val` into `a`'s field defined by `dtype` and beginning `offset`\n    bytes into the field.\n\n    Parameters\n    ----------\n    val : object\n        Value to be placed in field.\n    dtype : dtype object\n        Data-type of the field in which to place `val`.\n    offset : int, optional\n        The number of bytes into the field at which to place `val`.\n\n    Returns\n    -------\n    None\n\n    See Also\n    --------\n    getfield\n\n    Examples\n    --------\n    >>> x = np.eye(3)\n    >>> x.getfield(np.float64)\n    array([[1.,  0.,  0.],\n           [0.,  1.,  0.],\n           [0.,  0.,  1.]])\n    >>> x.setfield(3, np.int32)\n    >>> x.getfield(np.int32)\n    array([[3, 3, 3],\n           [3, 3, 3],\n           [3, 3, 3]], dtype=int32)\n    >>> x\n    array([[1.0e+000, 1.5e-323, 1.5e-323],\n           [1.5e-323, 1.0e+000, 1.5e-323],\n           [1.5e-323, 1.5e-323, 1.0e+000]])\n    >>> x.setfield(np.eye(3), np.int32)\n    >>> x\n    array([[1.,  0.,  0.],\n           [0.,  1.,  0.],\n           [0.,  0.,  1.]])"
        ...
    
    def setflags(self, write=..., align=..., uic=...) -> typing.Any:
        'a.setflags(write=None, align=None, uic=None)\n\n    Set array flags WRITEABLE, ALIGNED, WRITEBACKIFCOPY,\n    respectively.\n\n    These Boolean-valued flags affect how numpy interprets the memory\n    area used by `a` (see Notes below). The ALIGNED flag can only\n    be set to True if the data is actually aligned according to the type.\n    The WRITEBACKIFCOPY and flag can never be set\n    to True. The flag WRITEABLE can only be set to True if the array owns its\n    own memory, or the ultimate owner of the memory exposes a writeable buffer\n    interface, or is a string. (The exception for string is made so that\n    unpickling can be done without copying memory.)\n\n    Parameters\n    ----------\n    write : bool, optional\n        Describes whether or not `a` can be written to.\n    align : bool, optional\n        Describes whether or not `a` is aligned properly for its type.\n    uic : bool, optional\n        Describes whether or not `a` is a copy of another "base" array.\n\n    Notes\n    -----\n    Array flags provide information about how the memory area used\n    for the array is to be interpreted. There are 7 Boolean flags\n    in use, only four of which can be changed by the user:\n    WRITEBACKIFCOPY, WRITEABLE, and ALIGNED.\n\n    WRITEABLE (W) the data area can be written to;\n\n    ALIGNED (A) the data and strides are aligned appropriately for the hardware\n    (as determined by the compiler);\n\n    WRITEBACKIFCOPY (X) this array is a copy of some other array (referenced\n    by .base). When the C-API function PyArray_ResolveWritebackIfCopy is\n    called, the base array will be updated with the contents of this array.\n\n    All flags can be accessed using the single (upper case) letter as well\n    as the full name.\n\n    Examples\n    --------\n    >>> y = np.array([[3, 1, 7],\n    ...               [2, 0, 0],\n    ...               [8, 5, 9]])\n    >>> y\n    array([[3, 1, 7],\n           [2, 0, 0],\n           [8, 5, 9]])\n    >>> y.flags\n      C_CONTIGUOUS : True\n      F_CONTIGUOUS : False\n      OWNDATA : True\n      WRITEABLE : True\n      ALIGNED : True\n      WRITEBACKIFCOPY : False\n    >>> y.setflags(write=0, align=0)\n    >>> y.flags\n      C_CONTIGUOUS : True\n      F_CONTIGUOUS : False\n      OWNDATA : True\n      WRITEABLE : False\n      ALIGNED : False\n      WRITEBACKIFCOPY : False\n    >>> y.setflags(uic=1)\n    Traceback (most recent call last):\n      File "<stdin>", line 1, in <module>\n    ValueError: cannot set WRITEBACKIFCOPY flag to True'
        ...
    
    @property
    def shape(self) -> typing.Any:
        'Tuple of array dimensions.\n\n    The shape property is usually used to get the current shape of an array,\n    but may also be used to reshape the array in-place by assigning a tuple of\n    array dimensions to it.  As with `numpy.reshape`, one of the new shape\n    dimensions can be -1, in which case its value is inferred from the size of\n    the array and the remaining dimensions. Reshaping an array in-place will\n    fail if a copy is required.\n\n    .. warning::\n\n        Setting ``arr.shape`` is discouraged and may be deprecated in the\n        future.  Using `ndarray.reshape` is the preferred approach.\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3, 4])\n    >>> x.shape\n    (4,)\n    >>> y = np.zeros((2, 3, 4))\n    >>> y.shape\n    (2, 3, 4)\n    >>> y.shape = (3, 8)\n    >>> y\n    array([[ 0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.],\n           [ 0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.],\n           [ 0.,  0.,  0.,  0.,  0.,  0.,  0.,  0.]])\n    >>> y.shape = (3, 6)\n    Traceback (most recent call last):\n      File "<stdin>", line 1, in <module>\n    ValueError: total size of new array must be unchanged\n    >>> np.zeros((4,2))[::2].shape = (-1,)\n    Traceback (most recent call last):\n      File "<stdin>", line 1, in <module>\n    AttributeError: Incompatible shape for in-place modification. Use\n    `.reshape()` to make a copy with the desired shape.\n\n    See Also\n    --------\n    numpy.shape : Equivalent getter function.\n    numpy.reshape : Function similar to setting ``shape``.\n    ndarray.reshape : Method similar to setting ``shape``.'
        ...
    
    @property
    def size(self) -> typing.Any:
        "Number of elements in the array.\n\n    Equal to ``np.prod(a.shape)``, i.e., the product of the array's\n    dimensions.\n\n    Notes\n    -----\n    `a.size` returns a standard arbitrary precision Python integer. This\n    may not be the case with other methods of obtaining the same value\n    (like the suggested ``np.prod(a.shape)``, which returns an instance\n    of ``np.int_``), and may be relevant if the value is used further in\n    calculations that may overflow a fixed size integer type.\n\n    Examples\n    --------\n    >>> x = np.zeros((3, 5, 2), dtype=np.complex128)\n    >>> x.size\n    30\n    >>> np.prod(x.shape)\n    30"
        ...
    
    def sort(self, axis=..., kind=..., order=...) -> typing.Any:
        "a.sort(axis=-1, kind=None, order=None)\n\n    Sort an array in-place. Refer to `numpy.sort` for full documentation.\n\n    Parameters\n    ----------\n    axis : int, optional\n        Axis along which to sort. Default is -1, which means sort along the\n        last axis.\n    kind : {'quicksort', 'mergesort', 'heapsort', 'stable'}, optional\n        Sorting algorithm. The default is 'quicksort'. Note that both 'stable'\n        and 'mergesort' use timsort under the covers and, in general, the\n        actual implementation will vary with datatype. The 'mergesort' option\n        is retained for backwards compatibility.\n\n        .. versionchanged:: 1.15.0\n           The 'stable' option was added.\n\n    order : str or list of str, optional\n        When `a` is an array with fields defined, this argument specifies\n        which fields to compare first, second, etc.  A single field can\n        be specified as a string, and not all fields need be specified,\n        but unspecified fields will still be used, in the order in which\n        they come up in the dtype, to break ties.\n\n    See Also\n    --------\n    numpy.sort : Return a sorted copy of an array.\n    numpy.argsort : Indirect sort.\n    numpy.lexsort : Indirect stable sort on multiple keys.\n    numpy.searchsorted : Find elements in sorted array.\n    numpy.partition: Partial sort.\n\n    Notes\n    -----\n    See `numpy.sort` for notes on the different sorting algorithms.\n\n    Examples\n    --------\n    >>> a = np.array([[1,4], [3,1]])\n    >>> a.sort(axis=1)\n    >>> a\n    array([[1, 4],\n           [1, 3]])\n    >>> a.sort(axis=0)\n    >>> a\n    array([[1, 3],\n           [1, 4]])\n\n    Use the `order` keyword to specify a field to use when sorting a\n    structured array:\n\n    >>> a = np.array([('a', 2), ('c', 1)], dtype=[('x', 'S1'), ('y', int)])\n    >>> a.sort(order='y')\n    >>> a\n    array([(b'c', 1), (b'a', 2)],\n          dtype=[('x', 'S1'), ('y', '<i8')])"
        ...
    
    def squeeze(self, axis=...) -> typing.Any:
        'a.squeeze(axis=None)\n\n    Remove axes of length one from `a`.\n\n    Refer to `numpy.squeeze` for full documentation.\n\n    See Also\n    --------\n    numpy.squeeze : equivalent function'
        ...
    
    def std(self, axis=..., dtype=..., out=..., ddof=..., keepdims=..., *, where=...) -> typing.Any:
        'a.std(axis=None, dtype=None, out=None, ddof=0, keepdims=False, *, where=True)\n\n    Returns the standard deviation of the array elements along given axis.\n\n    Refer to `numpy.std` for full documentation.\n\n    See Also\n    --------\n    numpy.std : equivalent function'
        ...
    
    @property
    def strides(self) -> typing.Any:
        'Tuple of bytes to step in each dimension when traversing an array.\n\n    The byte offset of element ``(i[0], i[1], ..., i[n])`` in an array `a`\n    is::\n\n        offset = sum(np.array(i) * a.strides)\n\n    A more detailed explanation of strides can be found in the\n    "ndarray.rst" file in the NumPy reference guide.\n\n    .. warning::\n\n        Setting ``arr.strides`` is discouraged and may be deprecated in the\n        future.  `numpy.lib.stride_tricks.as_strided` should be preferred\n        to create a new view of the same data in a safer way.\n\n    Notes\n    -----\n    Imagine an array of 32-bit integers (each 4 bytes)::\n\n      x = np.array([[0, 1, 2, 3, 4],\n                    [5, 6, 7, 8, 9]], dtype=np.int32)\n\n    This array is stored in memory as 40 bytes, one after the other\n    (known as a contiguous block of memory).  The strides of an array tell\n    us how many bytes we have to skip in memory to move to the next position\n    along a certain axis.  For example, we have to skip 4 bytes (1 value) to\n    move to the next column, but 20 bytes (5 values) to get to the same\n    position in the next row.  As such, the strides for the array `x` will be\n    ``(20, 4)``.\n\n    See Also\n    --------\n    numpy.lib.stride_tricks.as_strided\n\n    Examples\n    --------\n    >>> y = np.reshape(np.arange(2*3*4), (2,3,4))\n    >>> y\n    array([[[ 0,  1,  2,  3],\n            [ 4,  5,  6,  7],\n            [ 8,  9, 10, 11]],\n           [[12, 13, 14, 15],\n            [16, 17, 18, 19],\n            [20, 21, 22, 23]]])\n    >>> y.strides\n    (48, 16, 4)\n    >>> y[1,1,1]\n    17\n    >>> offset=sum(y.strides * np.array((1,1,1)))\n    >>> offset/y.itemsize\n    17\n\n    >>> x = np.reshape(np.arange(5*6*7*8), (5,6,7,8)).transpose(2,3,1,0)\n    >>> x.strides\n    (32, 4, 224, 1344)\n    >>> i = np.array([3,5,2,2])\n    >>> offset = sum(i * x.strides)\n    >>> x[3,5,2,2]\n    813\n    >>> offset / x.itemsize\n    813'
        ...
    
    def sum(self, axis=..., dtype=..., out=..., keepdims=..., initial=..., where=...) -> typing.Any:
        'a.sum(axis=None, dtype=None, out=None, keepdims=False, initial=0, where=True)\n\n    Return the sum of the array elements over the given axis.\n\n    Refer to `numpy.sum` for full documentation.\n\n    See Also\n    --------\n    numpy.sum : equivalent function'
        ...
    
    def swapaxes(self, axis1, axis2) -> typing.Any:
        'a.swapaxes(axis1, axis2)\n\n    Return a view of the array with `axis1` and `axis2` interchanged.\n\n    Refer to `numpy.swapaxes` for full documentation.\n\n    See Also\n    --------\n    numpy.swapaxes : equivalent function'
        ...
    
    def take(self, indices, axis=..., out=..., mode=...) -> typing.Any:
        "a.take(indices, axis=None, out=None, mode='raise')\n\n    Return an array formed from the elements of `a` at the given indices.\n\n    Refer to `numpy.take` for full documentation.\n\n    See Also\n    --------\n    numpy.take : equivalent function"
        ...
    
    def tobytes(self, order=...) -> typing.Any:
        "a.tobytes(order='C')\n\n    Construct Python bytes containing the raw data bytes in the array.\n\n    Constructs Python bytes showing a copy of the raw contents of\n    data memory. The bytes object is produced in C-order by default.\n    This behavior is controlled by the ``order`` parameter.\n\n    .. versionadded:: 1.9.0\n\n    Parameters\n    ----------\n    order : {'C', 'F', 'A'}, optional\n        Controls the memory layout of the bytes object. 'C' means C-order,\n        'F' means F-order, 'A' (short for *Any*) means 'F' if `a` is\n        Fortran contiguous, 'C' otherwise. Default is 'C'.\n\n    Returns\n    -------\n    s : bytes\n        Python bytes exhibiting a copy of `a`'s raw data.\n\n    See also\n    --------\n    frombuffer\n        Inverse of this operation, construct a 1-dimensional array from Python\n        bytes.\n\n    Examples\n    --------\n    >>> x = np.array([[0, 1], [2, 3]], dtype='<u2')\n    >>> x.tobytes()\n    b'\\x00\\x00\\x01\\x00\\x02\\x00\\x03\\x00'\n    >>> x.tobytes('C') == x.tobytes()\n    True\n    >>> x.tobytes('F')\n    b'\\x00\\x00\\x02\\x00\\x01\\x00\\x03\\x00'"
        ...
    
    def tofile(self, fid, sep=..., format=...) -> typing.Any:
        'a.tofile(fid, sep="", format="%s")\n\n    Write array to a file as text or binary (default).\n\n    Data is always written in \'C\' order, independent of the order of `a`.\n    The data produced by this method can be recovered using the function\n    fromfile().\n\n    Parameters\n    ----------\n    fid : file or str or Path\n        An open file object, or a string containing a filename.\n\n        .. versionchanged:: 1.17.0\n            `pathlib.Path` objects are now accepted.\n\n    sep : str\n        Separator between array items for text output.\n        If "" (empty), a binary file is written, equivalent to\n        ``file.write(a.tobytes())``.\n    format : str\n        Format string for text file output.\n        Each entry in the array is formatted to text by first converting\n        it to the closest Python type, and then using "format" % item.\n\n    Notes\n    -----\n    This is a convenience function for quick storage of array data.\n    Information on endianness and precision is lost, so this method is not a\n    good choice for files intended to archive data or transport data between\n    machines with different endianness. Some of these problems can be overcome\n    by outputting the data as text files, at the expense of speed and file\n    size.\n\n    When fid is a file object, array contents are directly written to the\n    file, bypassing the file object\'s ``write`` method. As a result, tofile\n    cannot be used with files objects supporting compression (e.g., GzipFile)\n    or file-like objects that do not support ``fileno()`` (e.g., BytesIO).'
        ...
    
    def tolist(self) -> typing.Any:
        "a.tolist()\n\n    Return the array as an ``a.ndim``-levels deep nested list of Python scalars.\n\n    Return a copy of the array data as a (nested) Python list.\n    Data items are converted to the nearest compatible builtin Python type, via\n    the `~numpy.ndarray.item` function.\n\n    If ``a.ndim`` is 0, then since the depth of the nested list is 0, it will\n    not be a list at all, but a simple Python scalar.\n\n    Parameters\n    ----------\n    none\n\n    Returns\n    -------\n    y : object, or list of object, or list of list of object, or ...\n        The possibly nested list of array elements.\n\n    Notes\n    -----\n    The array may be recreated via ``a = np.array(a.tolist())``, although this\n    may sometimes lose precision.\n\n    Examples\n    --------\n    For a 1D array, ``a.tolist()`` is almost the same as ``list(a)``,\n    except that ``tolist`` changes numpy scalars to Python scalars:\n\n    >>> a = np.uint32([1, 2])\n    >>> a_list = list(a)\n    >>> a_list\n    [1, 2]\n    >>> type(a_list[0])\n    <class 'numpy.uint32'>\n    >>> a_tolist = a.tolist()\n    >>> a_tolist\n    [1, 2]\n    >>> type(a_tolist[0])\n    <class 'int'>\n\n    Additionally, for a 2D array, ``tolist`` applies recursively:\n\n    >>> a = np.array([[1, 2], [3, 4]])\n    >>> list(a)\n    [array([1, 2]), array([3, 4])]\n    >>> a.tolist()\n    [[1, 2], [3, 4]]\n\n    The base case for this recursion is a 0D array:\n\n    >>> a = np.array(1)\n    >>> list(a)\n    Traceback (most recent call last):\n      ...\n    TypeError: iteration over a 0-d array\n    >>> a.tolist()\n    1"
        ...
    
    def tostring(self, order=...) -> typing.Any:
        "a.tostring(order='C')\n\n    A compatibility alias for `tobytes`, with exactly the same behavior.\n\n    Despite its name, it returns `bytes` not `str`\\ s.\n\n    .. deprecated:: 1.19.0"
        ...
    
    def trace(self, offset=..., axis1=..., axis2=..., dtype=..., out=...) -> typing.Any:
        'a.trace(offset=0, axis1=0, axis2=1, dtype=None, out=None)\n\n    Return the sum along diagonals of the array.\n\n    Refer to `numpy.trace` for full documentation.\n\n    See Also\n    --------\n    numpy.trace : equivalent function'
        ...
    
    def transpose(self, *axes) -> typing.Any:
        'a.transpose(*axes)\n\n    Returns a view of the array with axes transposed.\n\n    Refer to `numpy.transpose` for full documentation.\n\n    Parameters\n    ----------\n    axes : None, tuple of ints, or `n` ints\n\n     * None or no argument: reverses the order of the axes.\n\n     * tuple of ints: `i` in the `j`-th place in the tuple means that the\n       array\'s `i`-th axis becomes the transposed array\'s `j`-th axis.\n\n     * `n` ints: same as an n-tuple of the same ints (this form is\n       intended simply as a "convenience" alternative to the tuple form).\n\n    Returns\n    -------\n    p : ndarray\n        View of the array with its axes suitably permuted.\n\n    See Also\n    --------\n    transpose : Equivalent function.\n    ndarray.T : Array property returning the array transposed.\n    ndarray.reshape : Give a new shape to an array without changing its data.\n\n    Examples\n    --------\n    >>> a = np.array([[1, 2], [3, 4]])\n    >>> a\n    array([[1, 2],\n           [3, 4]])\n    >>> a.transpose()\n    array([[1, 3],\n           [2, 4]])\n    >>> a.transpose((1, 0))\n    array([[1, 3],\n           [2, 4]])\n    >>> a.transpose(1, 0)\n    array([[1, 3],\n           [2, 4]])\n\n    >>> a = np.array([1, 2, 3, 4])\n    >>> a\n    array([1, 2, 3, 4])\n    >>> a.transpose()\n    array([1, 2, 3, 4])'
        ...
    
    def var(self, axis=..., dtype=..., out=..., ddof=..., keepdims=..., *, where=...) -> typing.Any:
        'a.var(axis=None, dtype=None, out=None, ddof=0, keepdims=False, *, where=True)\n\n    Returns the variance of the array elements, along given axis.\n\n    Refer to `numpy.var` for full documentation.\n\n    See Also\n    --------\n    numpy.var : equivalent function'
        ...
    
    def view(self, dtype=..., type=...) -> typing.Any:
        "a.view([dtype][, type])\n\n    New view of array with the same data.\n\n    .. note::\n        Passing None for ``dtype`` is different from omitting the parameter,\n        since the former invokes ``dtype(None)`` which is an alias for\n        ``dtype('float_')``.\n\n    Parameters\n    ----------\n    dtype : data-type or ndarray sub-class, optional\n        Data-type descriptor of the returned view, e.g., float32 or int16.\n        Omitting it results in the view having the same data-type as `a`.\n        This argument can also be specified as an ndarray sub-class, which\n        then specifies the type of the returned object (this is equivalent to\n        setting the ``type`` parameter).\n    type : Python type, optional\n        Type of the returned view, e.g., ndarray or matrix.  Again, omission\n        of the parameter results in type preservation.\n\n    Notes\n    -----\n    ``a.view()`` is used two different ways:\n\n    ``a.view(some_dtype)`` or ``a.view(dtype=some_dtype)`` constructs a view\n    of the array's memory with a different data-type.  This can cause a\n    reinterpretation of the bytes of memory.\n\n    ``a.view(ndarray_subclass)`` or ``a.view(type=ndarray_subclass)`` just\n    returns an instance of `ndarray_subclass` that looks at the same array\n    (same shape, dtype, etc.)  This does not cause a reinterpretation of the\n    memory.\n\n    For ``a.view(some_dtype)``, if ``some_dtype`` has a different number of\n    bytes per entry than the previous dtype (for example, converting a regular\n    array to a structured array), then the last axis of ``a`` must be\n    contiguous. This axis will be resized in the result.\n\n    .. versionchanged:: 1.23.0\n       Only the last axis needs to be contiguous. Previously, the entire array\n       had to be C-contiguous.\n\n    Examples\n    --------\n    >>> x = np.array([(1, 2)], dtype=[('a', np.int8), ('b', np.int8)])\n\n    Viewing array data using a different type and dtype:\n\n    >>> y = x.view(dtype=np.int16, type=np.matrix)\n    >>> y\n    matrix([[513]], dtype=int16)\n    >>> print(type(y))\n    <class 'numpy.matrix'>\n\n    Creating a view on a structured array so it can be used in calculations\n\n    >>> x = np.array([(1, 2),(3,4)], dtype=[('a', np.int8), ('b', np.int8)])\n    >>> xv = x.view(dtype=np.int8).reshape(-1,2)\n    >>> xv\n    array([[1, 2],\n           [3, 4]], dtype=int8)\n    >>> xv.mean(0)\n    array([2.,  3.])\n\n    Making changes to the view changes the underlying array\n\n    >>> xv[0,1] = 20\n    >>> x\n    array([(1, 20), (3,  4)], dtype=[('a', 'i1'), ('b', 'i1')])\n\n    Using a view to convert an array to a recarray:\n\n    >>> z = x.view(np.recarray)\n    >>> z.a\n    array([1, 3], dtype=int8)\n\n    Views share data:\n\n    >>> x[0] = (9, 10)\n    >>> z[0]\n    (9, 10)\n\n    Views that change the dtype size (bytes per entry) should normally be\n    avoided on arrays defined by slices, transposes, fortran-ordering, etc.:\n\n    >>> x = np.array([[1, 2, 3], [4, 5, 6]], dtype=np.int16)\n    >>> y = x[:, ::2]\n    >>> y\n    array([[1, 3],\n           [4, 6]], dtype=int16)\n    >>> y.view(dtype=[('width', np.int16), ('length', np.int16)])\n    Traceback (most recent call last):\n        ...\n    ValueError: To change to a dtype of a different size, the last axis must be contiguous\n    >>> z = y.copy()\n    >>> z.view(dtype=[('width', np.int16), ('length', np.int16)])\n    array([[(1, 3)],\n           [(4, 6)]], dtype=[('width', '<i2'), ('length', '<i2')])\n\n    However, views that change dtype are totally fine for arrays with a\n    contiguous last axis, even if the rest of the axes are not C-contiguous:\n\n    >>> x = np.arange(2 * 3 * 4, dtype=np.int8).reshape(2, 3, 4)\n    >>> x.transpose(1, 0, 2).view(np.int16)\n    array([[[ 256,  770],\n            [3340, 3854]],\n    <BLANKLINE>\n           [[1284, 1798],\n            [4368, 4882]],\n    <BLANKLINE>\n           [[2312, 2826],\n            [5396, 5910]]], dtype=int16)"
        ...
    
    def __getattr__(self, name) -> typing.Any:
        ...
    

class nditer(_mod_builtins.object):
    'nditer(op, flags=None, op_flags=None, op_dtypes=None, order=\'K\', casting=\'safe\', op_axes=None, itershape=None, buffersize=0)\n\n    Efficient multi-dimensional iterator object to iterate over arrays.\n    To get started using this object, see the\n    :ref:`introductory guide to array iteration <arrays.nditer>`.\n\n    Parameters\n    ----------\n    op : ndarray or sequence of array_like\n        The array(s) to iterate over.\n\n    flags : sequence of str, optional\n          Flags to control the behavior of the iterator.\n\n          * ``buffered`` enables buffering when required.\n          * ``c_index`` causes a C-order index to be tracked.\n          * ``f_index`` causes a Fortran-order index to be tracked.\n          * ``multi_index`` causes a multi-index, or a tuple of indices\n            with one per iteration dimension, to be tracked.\n          * ``common_dtype`` causes all the operands to be converted to\n            a common data type, with copying or buffering as necessary.\n          * ``copy_if_overlap`` causes the iterator to determine if read\n            operands have overlap with write operands, and make temporary\n            copies as necessary to avoid overlap. False positives (needless\n            copying) are possible in some cases.\n          * ``delay_bufalloc`` delays allocation of the buffers until\n            a reset() call is made. Allows ``allocate`` operands to\n            be initialized before their values are copied into the buffers.\n          * ``external_loop`` causes the ``values`` given to be\n            one-dimensional arrays with multiple values instead of\n            zero-dimensional arrays.\n          * ``grow_inner`` allows the ``value`` array sizes to be made\n            larger than the buffer size when both ``buffered`` and\n            ``external_loop`` is used.\n          * ``ranged`` allows the iterator to be restricted to a sub-range\n            of the iterindex values.\n          * ``refs_ok`` enables iteration of reference types, such as\n            object arrays.\n          * ``reduce_ok`` enables iteration of ``readwrite`` operands\n            which are broadcasted, also known as reduction operands.\n          * ``zerosize_ok`` allows `itersize` to be zero.\n    op_flags : list of list of str, optional\n          This is a list of flags for each operand. At minimum, one of\n          ``readonly``, ``readwrite``, or ``writeonly`` must be specified.\n\n          * ``readonly`` indicates the operand will only be read from.\n          * ``readwrite`` indicates the operand will be read from and written to.\n          * ``writeonly`` indicates the operand will only be written to.\n          * ``no_broadcast`` prevents the operand from being broadcasted.\n          * ``contig`` forces the operand data to be contiguous.\n          * ``aligned`` forces the operand data to be aligned.\n          * ``nbo`` forces the operand data to be in native byte order.\n          * ``copy`` allows a temporary read-only copy if required.\n          * ``updateifcopy`` allows a temporary read-write copy if required.\n          * ``allocate`` causes the array to be allocated if it is None\n            in the ``op`` parameter.\n          * ``no_subtype`` prevents an ``allocate`` operand from using a subtype.\n          * ``arraymask`` indicates that this operand is the mask to use\n            for selecting elements when writing to operands with the\n            \'writemasked\' flag set. The iterator does not enforce this,\n            but when writing from a buffer back to the array, it only\n            copies those elements indicated by this mask.\n          * ``writemasked`` indicates that only elements where the chosen\n            ``arraymask`` operand is True will be written to.\n          * ``overlap_assume_elementwise`` can be used to mark operands that are\n            accessed only in the iterator order, to allow less conservative\n            copying when ``copy_if_overlap`` is present.\n    op_dtypes : dtype or tuple of dtype(s), optional\n        The required data type(s) of the operands. If copying or buffering\n        is enabled, the data will be converted to/from their original types.\n    order : {\'C\', \'F\', \'A\', \'K\'}, optional\n        Controls the iteration order. \'C\' means C order, \'F\' means\n        Fortran order, \'A\' means \'F\' order if all the arrays are Fortran\n        contiguous, \'C\' order otherwise, and \'K\' means as close to the\n        order the array elements appear in memory as possible. This also\n        affects the element memory order of ``allocate`` operands, as they\n        are allocated to be compatible with iteration order.\n        Default is \'K\'.\n    casting : {\'no\', \'equiv\', \'safe\', \'same_kind\', \'unsafe\'}, optional\n        Controls what kind of data casting may occur when making a copy\n        or buffering.  Setting this to \'unsafe\' is not recommended,\n        as it can adversely affect accumulations.\n\n        * \'no\' means the data types should not be cast at all.\n        * \'equiv\' means only byte-order changes are allowed.\n        * \'safe\' means only casts which can preserve values are allowed.\n        * \'same_kind\' means only safe casts or casts within a kind,\n          like float64 to float32, are allowed.\n        * \'unsafe\' means any data conversions may be done.\n    op_axes : list of list of ints, optional\n        If provided, is a list of ints or None for each operands.\n        The list of axes for an operand is a mapping from the dimensions\n        of the iterator to the dimensions of the operand. A value of\n        -1 can be placed for entries, causing that dimension to be\n        treated as `newaxis`.\n    itershape : tuple of ints, optional\n        The desired shape of the iterator. This allows ``allocate`` operands\n        with a dimension mapped by op_axes not corresponding to a dimension\n        of a different operand to get a value not equal to 1 for that\n        dimension.\n    buffersize : int, optional\n        When buffering is enabled, controls the size of the temporary\n        buffers. Set to 0 for the default value.\n\n    Attributes\n    ----------\n    dtypes : tuple of dtype(s)\n        The data types of the values provided in `value`. This may be\n        different from the operand data types if buffering is enabled.\n        Valid only before the iterator is closed.\n    finished : bool\n        Whether the iteration over the operands is finished or not.\n    has_delayed_bufalloc : bool\n        If True, the iterator was created with the ``delay_bufalloc`` flag,\n        and no reset() function was called on it yet.\n    has_index : bool\n        If True, the iterator was created with either the ``c_index`` or\n        the ``f_index`` flag, and the property `index` can be used to\n        retrieve it.\n    has_multi_index : bool\n        If True, the iterator was created with the ``multi_index`` flag,\n        and the property `multi_index` can be used to retrieve it.\n    index\n        When the ``c_index`` or ``f_index`` flag was used, this property\n        provides access to the index. Raises a ValueError if accessed\n        and ``has_index`` is False.\n    iterationneedsapi : bool\n        Whether iteration requires access to the Python API, for example\n        if one of the operands is an object array.\n    iterindex : int\n        An index which matches the order of iteration.\n    itersize : int\n        Size of the iterator.\n    itviews\n        Structured view(s) of `operands` in memory, matching the reordered\n        and optimized iterator access pattern. Valid only before the iterator\n        is closed.\n    multi_index\n        When the ``multi_index`` flag was used, this property\n        provides access to the index. Raises a ValueError if accessed\n        accessed and ``has_multi_index`` is False.\n    ndim : int\n        The dimensions of the iterator.\n    nop : int\n        The number of iterator operands.\n    operands : tuple of operand(s)\n        The array(s) to be iterated over. Valid only before the iterator is\n        closed.\n    shape : tuple of ints\n        Shape tuple, the shape of the iterator.\n    value\n        Value of ``operands`` at current iteration. Normally, this is a\n        tuple of array scalars, but if the flag ``external_loop`` is used,\n        it is a tuple of one dimensional arrays.\n\n    Notes\n    -----\n    `nditer` supersedes `flatiter`.  The iterator implementation behind\n    `nditer` is also exposed by the NumPy C API.\n\n    The Python exposure supplies two iteration interfaces, one which follows\n    the Python iterator protocol, and another which mirrors the C-style\n    do-while pattern.  The native Python approach is better in most cases, but\n    if you need the coordinates or index of an iterator, use the C-style pattern.\n\n    Examples\n    --------\n    Here is how we might write an ``iter_add`` function, using the\n    Python iterator protocol:\n\n    >>> def iter_add_py(x, y, out=None):\n    ...     addop = np.add\n    ...     it = np.nditer([x, y, out], [],\n    ...                 [[\'readonly\'], [\'readonly\'], [\'writeonly\',\'allocate\']])\n    ...     with it:\n    ...         for (a, b, c) in it:\n    ...             addop(a, b, out=c)\n    ...         return it.operands[2]\n\n    Here is the same function, but following the C-style pattern:\n\n    >>> def iter_add(x, y, out=None):\n    ...    addop = np.add\n    ...    it = np.nditer([x, y, out], [],\n    ...                [[\'readonly\'], [\'readonly\'], [\'writeonly\',\'allocate\']])\n    ...    with it:\n    ...        while not it.finished:\n    ...            addop(it[0], it[1], out=it[2])\n    ...            it.iternext()\n    ...        return it.operands[2]\n\n    Here is an example outer product function:\n\n    >>> def outer_it(x, y, out=None):\n    ...     mulop = np.multiply\n    ...     it = np.nditer([x, y, out], [\'external_loop\'],\n    ...             [[\'readonly\'], [\'readonly\'], [\'writeonly\', \'allocate\']],\n    ...             op_axes=[list(range(x.ndim)) + [-1] * y.ndim,\n    ...                      [-1] * x.ndim + list(range(y.ndim)),\n    ...                      None])\n    ...     with it:\n    ...         for (a, b, c) in it:\n    ...             mulop(a, b, out=c)\n    ...         return it.operands[2]\n\n    >>> a = np.arange(2)+1\n    >>> b = np.arange(3)+1\n    >>> outer_it(a,b)\n    array([[1, 2, 3],\n           [2, 4, 6]])\n\n    Here is an example function which operates like a "lambda" ufunc:\n\n    >>> def luf(lamdaexpr, *args, **kwargs):\n    ...    \'\'\'luf(lambdaexpr, op1, ..., opn, out=None, order=\'K\', casting=\'safe\', buffersize=0)\'\'\'\n    ...    nargs = len(args)\n    ...    op = (kwargs.get(\'out\',None),) + args\n    ...    it = np.nditer(op, [\'buffered\',\'external_loop\'],\n    ...            [[\'writeonly\',\'allocate\',\'no_broadcast\']] +\n    ...                            [[\'readonly\',\'nbo\',\'aligned\']]*nargs,\n    ...            order=kwargs.get(\'order\',\'K\'),\n    ...            casting=kwargs.get(\'casting\',\'safe\'),\n    ...            buffersize=kwargs.get(\'buffersize\',0))\n    ...    while not it.finished:\n    ...        it[0] = lamdaexpr(*it[1:])\n    ...        it.iternext()\n    ...    return it.operands[0]\n\n    >>> a = np.arange(5)\n    >>> b = np.ones(5)\n    >>> luf(lambda i,j:i*i + j/2, a, b)\n    array([  0.5,   1.5,   4.5,   9.5,  16.5])\n\n    If operand flags ``"writeonly"`` or ``"readwrite"`` are used the\n    operands may be views into the original data with the\n    `WRITEBACKIFCOPY` flag. In this case `nditer` must be used as a\n    context manager or the `nditer.close` method must be called before\n    using the result. The temporary data will be written back to the\n    original data when the `__exit__` function is called but not before:\n\n    >>> a = np.arange(6, dtype=\'i4\')[::-2]\n    >>> with np.nditer(a, [],\n    ...        [[\'writeonly\', \'updateifcopy\']],\n    ...        casting=\'unsafe\',\n    ...        op_dtypes=[np.dtype(\'f4\')]) as i:\n    ...    x = i.operands[0]\n    ...    x[:] = [-1, -2, -3]\n    ...    # a still unchanged here\n    >>> a, x\n    (array([-1, -2, -3], dtype=int32), array([-1., -2., -3.], dtype=float32))\n\n    It is important to note that once the iterator is exited, dangling\n    references (like `x` in the example) may or may not share data with\n    the original data `a`. If writeback semantics were active, i.e. if\n    `x.base.flags.writebackifcopy` is `True`, then exiting the iterator\n    will sever the connection between `x` and `a`, writing to `x` will\n    no longer write to `a`. If writeback semantics are not active, then\n    `x.data` will still point at some part of `a.data`, and writing to\n    one will affect the other.\n\n    Context management and the `close` method appeared in version 1.15.0.'
    def __copy__(self) -> typing.Any:
        ...
    
    def __delitem__(self, key) -> None:
        'Delete self[key].'
        ...
    
    def __enter__(self) -> typing.Any:
        ...
    
    def __exit__(self) -> typing.Any:
        ...
    
    def __getitem__(self, key) -> typing.Any:
        'Return self[key].'
        ...
    
    def __init__(self, op, flags=..., op_flags=..., op_dtypes=..., order=..., casting=..., op_axes=..., itershape=..., buffersize=...) -> None:
        'nditer(op, flags=None, op_flags=None, op_dtypes=None, order=\'K\', casting=\'safe\', op_axes=None, itershape=None, buffersize=0)\n\n    Efficient multi-dimensional iterator object to iterate over arrays.\n    To get started using this object, see the\n    :ref:`introductory guide to array iteration <arrays.nditer>`.\n\n    Parameters\n    ----------\n    op : ndarray or sequence of array_like\n        The array(s) to iterate over.\n\n    flags : sequence of str, optional\n          Flags to control the behavior of the iterator.\n\n          * ``buffered`` enables buffering when required.\n          * ``c_index`` causes a C-order index to be tracked.\n          * ``f_index`` causes a Fortran-order index to be tracked.\n          * ``multi_index`` causes a multi-index, or a tuple of indices\n            with one per iteration dimension, to be tracked.\n          * ``common_dtype`` causes all the operands to be converted to\n            a common data type, with copying or buffering as necessary.\n          * ``copy_if_overlap`` causes the iterator to determine if read\n            operands have overlap with write operands, and make temporary\n            copies as necessary to avoid overlap. False positives (needless\n            copying) are possible in some cases.\n          * ``delay_bufalloc`` delays allocation of the buffers until\n            a reset() call is made. Allows ``allocate`` operands to\n            be initialized before their values are copied into the buffers.\n          * ``external_loop`` causes the ``values`` given to be\n            one-dimensional arrays with multiple values instead of\n            zero-dimensional arrays.\n          * ``grow_inner`` allows the ``value`` array sizes to be made\n            larger than the buffer size when both ``buffered`` and\n            ``external_loop`` is used.\n          * ``ranged`` allows the iterator to be restricted to a sub-range\n            of the iterindex values.\n          * ``refs_ok`` enables iteration of reference types, such as\n            object arrays.\n          * ``reduce_ok`` enables iteration of ``readwrite`` operands\n            which are broadcasted, also known as reduction operands.\n          * ``zerosize_ok`` allows `itersize` to be zero.\n    op_flags : list of list of str, optional\n          This is a list of flags for each operand. At minimum, one of\n          ``readonly``, ``readwrite``, or ``writeonly`` must be specified.\n\n          * ``readonly`` indicates the operand will only be read from.\n          * ``readwrite`` indicates the operand will be read from and written to.\n          * ``writeonly`` indicates the operand will only be written to.\n          * ``no_broadcast`` prevents the operand from being broadcasted.\n          * ``contig`` forces the operand data to be contiguous.\n          * ``aligned`` forces the operand data to be aligned.\n          * ``nbo`` forces the operand data to be in native byte order.\n          * ``copy`` allows a temporary read-only copy if required.\n          * ``updateifcopy`` allows a temporary read-write copy if required.\n          * ``allocate`` causes the array to be allocated if it is None\n            in the ``op`` parameter.\n          * ``no_subtype`` prevents an ``allocate`` operand from using a subtype.\n          * ``arraymask`` indicates that this operand is the mask to use\n            for selecting elements when writing to operands with the\n            \'writemasked\' flag set. The iterator does not enforce this,\n            but when writing from a buffer back to the array, it only\n            copies those elements indicated by this mask.\n          * ``writemasked`` indicates that only elements where the chosen\n            ``arraymask`` operand is True will be written to.\n          * ``overlap_assume_elementwise`` can be used to mark operands that are\n            accessed only in the iterator order, to allow less conservative\n            copying when ``copy_if_overlap`` is present.\n    op_dtypes : dtype or tuple of dtype(s), optional\n        The required data type(s) of the operands. If copying or buffering\n        is enabled, the data will be converted to/from their original types.\n    order : {\'C\', \'F\', \'A\', \'K\'}, optional\n        Controls the iteration order. \'C\' means C order, \'F\' means\n        Fortran order, \'A\' means \'F\' order if all the arrays are Fortran\n        contiguous, \'C\' order otherwise, and \'K\' means as close to the\n        order the array elements appear in memory as possible. This also\n        affects the element memory order of ``allocate`` operands, as they\n        are allocated to be compatible with iteration order.\n        Default is \'K\'.\n    casting : {\'no\', \'equiv\', \'safe\', \'same_kind\', \'unsafe\'}, optional\n        Controls what kind of data casting may occur when making a copy\n        or buffering.  Setting this to \'unsafe\' is not recommended,\n        as it can adversely affect accumulations.\n\n        * \'no\' means the data types should not be cast at all.\n        * \'equiv\' means only byte-order changes are allowed.\n        * \'safe\' means only casts which can preserve values are allowed.\n        * \'same_kind\' means only safe casts or casts within a kind,\n          like float64 to float32, are allowed.\n        * \'unsafe\' means any data conversions may be done.\n    op_axes : list of list of ints, optional\n        If provided, is a list of ints or None for each operands.\n        The list of axes for an operand is a mapping from the dimensions\n        of the iterator to the dimensions of the operand. A value of\n        -1 can be placed for entries, causing that dimension to be\n        treated as `newaxis`.\n    itershape : tuple of ints, optional\n        The desired shape of the iterator. This allows ``allocate`` operands\n        with a dimension mapped by op_axes not corresponding to a dimension\n        of a different operand to get a value not equal to 1 for that\n        dimension.\n    buffersize : int, optional\n        When buffering is enabled, controls the size of the temporary\n        buffers. Set to 0 for the default value.\n\n    Attributes\n    ----------\n    dtypes : tuple of dtype(s)\n        The data types of the values provided in `value`. This may be\n        different from the operand data types if buffering is enabled.\n        Valid only before the iterator is closed.\n    finished : bool\n        Whether the iteration over the operands is finished or not.\n    has_delayed_bufalloc : bool\n        If True, the iterator was created with the ``delay_bufalloc`` flag,\n        and no reset() function was called on it yet.\n    has_index : bool\n        If True, the iterator was created with either the ``c_index`` or\n        the ``f_index`` flag, and the property `index` can be used to\n        retrieve it.\n    has_multi_index : bool\n        If True, the iterator was created with the ``multi_index`` flag,\n        and the property `multi_index` can be used to retrieve it.\n    index\n        When the ``c_index`` or ``f_index`` flag was used, this property\n        provides access to the index. Raises a ValueError if accessed\n        and ``has_index`` is False.\n    iterationneedsapi : bool\n        Whether iteration requires access to the Python API, for example\n        if one of the operands is an object array.\n    iterindex : int\n        An index which matches the order of iteration.\n    itersize : int\n        Size of the iterator.\n    itviews\n        Structured view(s) of `operands` in memory, matching the reordered\n        and optimized iterator access pattern. Valid only before the iterator\n        is closed.\n    multi_index\n        When the ``multi_index`` flag was used, this property\n        provides access to the index. Raises a ValueError if accessed\n        accessed and ``has_multi_index`` is False.\n    ndim : int\n        The dimensions of the iterator.\n    nop : int\n        The number of iterator operands.\n    operands : tuple of operand(s)\n        The array(s) to be iterated over. Valid only before the iterator is\n        closed.\n    shape : tuple of ints\n        Shape tuple, the shape of the iterator.\n    value\n        Value of ``operands`` at current iteration. Normally, this is a\n        tuple of array scalars, but if the flag ``external_loop`` is used,\n        it is a tuple of one dimensional arrays.\n\n    Notes\n    -----\n    `nditer` supersedes `flatiter`.  The iterator implementation behind\n    `nditer` is also exposed by the NumPy C API.\n\n    The Python exposure supplies two iteration interfaces, one which follows\n    the Python iterator protocol, and another which mirrors the C-style\n    do-while pattern.  The native Python approach is better in most cases, but\n    if you need the coordinates or index of an iterator, use the C-style pattern.\n\n    Examples\n    --------\n    Here is how we might write an ``iter_add`` function, using the\n    Python iterator protocol:\n\n    >>> def iter_add_py(x, y, out=None):\n    ...     addop = np.add\n    ...     it = np.nditer([x, y, out], [],\n    ...                 [[\'readonly\'], [\'readonly\'], [\'writeonly\',\'allocate\']])\n    ...     with it:\n    ...         for (a, b, c) in it:\n    ...             addop(a, b, out=c)\n    ...         return it.operands[2]\n\n    Here is the same function, but following the C-style pattern:\n\n    >>> def iter_add(x, y, out=None):\n    ...    addop = np.add\n    ...    it = np.nditer([x, y, out], [],\n    ...                [[\'readonly\'], [\'readonly\'], [\'writeonly\',\'allocate\']])\n    ...    with it:\n    ...        while not it.finished:\n    ...            addop(it[0], it[1], out=it[2])\n    ...            it.iternext()\n    ...        return it.operands[2]\n\n    Here is an example outer product function:\n\n    >>> def outer_it(x, y, out=None):\n    ...     mulop = np.multiply\n    ...     it = np.nditer([x, y, out], [\'external_loop\'],\n    ...             [[\'readonly\'], [\'readonly\'], [\'writeonly\', \'allocate\']],\n    ...             op_axes=[list(range(x.ndim)) + [-1] * y.ndim,\n    ...                      [-1] * x.ndim + list(range(y.ndim)),\n    ...                      None])\n    ...     with it:\n    ...         for (a, b, c) in it:\n    ...             mulop(a, b, out=c)\n    ...         return it.operands[2]\n\n    >>> a = np.arange(2)+1\n    >>> b = np.arange(3)+1\n    >>> outer_it(a,b)\n    array([[1, 2, 3],\n           [2, 4, 6]])\n\n    Here is an example function which operates like a "lambda" ufunc:\n\n    >>> def luf(lamdaexpr, *args, **kwargs):\n    ...    \'\'\'luf(lambdaexpr, op1, ..., opn, out=None, order=\'K\', casting=\'safe\', buffersize=0)\'\'\'\n    ...    nargs = len(args)\n    ...    op = (kwargs.get(\'out\',None),) + args\n    ...    it = np.nditer(op, [\'buffered\',\'external_loop\'],\n    ...            [[\'writeonly\',\'allocate\',\'no_broadcast\']] +\n    ...                            [[\'readonly\',\'nbo\',\'aligned\']]*nargs,\n    ...            order=kwargs.get(\'order\',\'K\'),\n    ...            casting=kwargs.get(\'casting\',\'safe\'),\n    ...            buffersize=kwargs.get(\'buffersize\',0))\n    ...    while not it.finished:\n    ...        it[0] = lamdaexpr(*it[1:])\n    ...        it.iternext()\n    ...    return it.operands[0]\n\n    >>> a = np.arange(5)\n    >>> b = np.ones(5)\n    >>> luf(lambda i,j:i*i + j/2, a, b)\n    array([  0.5,   1.5,   4.5,   9.5,  16.5])\n\n    If operand flags ``"writeonly"`` or ``"readwrite"`` are used the\n    operands may be views into the original data with the\n    `WRITEBACKIFCOPY` flag. In this case `nditer` must be used as a\n    context manager or the `nditer.close` method must be called before\n    using the result. The temporary data will be written back to the\n    original data when the `__exit__` function is called but not before:\n\n    >>> a = np.arange(6, dtype=\'i4\')[::-2]\n    >>> with np.nditer(a, [],\n    ...        [[\'writeonly\', \'updateifcopy\']],\n    ...        casting=\'unsafe\',\n    ...        op_dtypes=[np.dtype(\'f4\')]) as i:\n    ...    x = i.operands[0]\n    ...    x[:] = [-1, -2, -3]\n    ...    # a still unchanged here\n    >>> a, x\n    (array([-1, -2, -3], dtype=int32), array([-1., -2., -3.], dtype=float32))\n\n    It is important to note that once the iterator is exited, dangling\n    references (like `x` in the example) may or may not share data with\n    the original data `a`. If writeback semantics were active, i.e. if\n    `x.base.flags.writebackifcopy` is `True`, then exiting the iterator\n    will sever the connection between `x` and `a`, writing to `x` will\n    no longer write to `a`. If writeback semantics are not active, then\n    `x.data` will still point at some part of `a.data`, and writing to\n    one will affect the other.\n\n    Context management and the `close` method appeared in version 1.15.0.'
        ...
    
    @classmethod
    def __init_subclass__(cls) -> None:
        'This method is called when a class is subclassed.\n\nThe default implementation does nothing. It may be\noverridden to extend subclasses.\n'
        ...
    
    def __iter__(self) -> nditer:
        'Implement iter(self).'
        ...
    
    def __len__(self) -> int:
        'Return len(self).'
        ...
    
    def __next__(self) -> typing.Any:
        'Implement next(self).'
        ...
    
    def __setitem__(self, key, value) -> None:
        'Set self[key] to value.'
        ...
    
    @classmethod
    def __subclasshook__(cls, subclass: typing.Any) -> bool:
        'Abstract classes can override this to customize issubclass().\n\nThis is invoked early on by abc.ABCMeta.__subclasscheck__().\nIt should return True, False or NotImplemented.  If it returns\nNotImplemented, the normal algorithm is used.  Otherwise, it\noverrides the normal algorithm (and the outcome is cached).\n'
        ...
    
    def close(self) -> typing.Any:
        '    Resolve all writeback semantics in writeable operands.\n\n    .. versionadded:: 1.15.0\n\n    See Also\n    --------\n\n    :ref:`nditer-context-manager`'
        ...
    
    def copy(self) -> typing.Any:
        '    Get a copy of the iterator in its current state.\n\n    Examples\n    --------\n    >>> x = np.arange(10)\n    >>> y = x + 1\n    >>> it = np.nditer([x, y])\n    >>> next(it)\n    (array(0), array(1))\n    >>> it2 = it.copy()\n    >>> next(it2)\n    (array(1), array(2))'
        ...
    
    def debug_print(self) -> typing.Any:
        '    Print the current state of the `nditer` instance and debug info to stdout.'
        ...
    
    @property
    def dtypes(self) -> typing.Any:
        ...
    
    def enable_external_loop(self) -> typing.Any:
        '    When the "external_loop" was not used during construction, but\n    is desired, this modifies the iterator to behave as if the flag\n    was specified.'
        ...
    
    @property
    def finished(self) -> typing.Any:
        ...
    
    @property
    def has_delayed_bufalloc(self) -> typing.Any:
        ...
    
    @property
    def has_index(self) -> typing.Any:
        ...
    
    @property
    def has_multi_index(self) -> typing.Any:
        ...
    
    @property
    def index(self) -> typing.Any:
        ...
    
    @property
    def iterationneedsapi(self) -> typing.Any:
        ...
    
    @property
    def iterindex(self) -> typing.Any:
        ...
    
    def iternext(self) -> typing.Any:
        '    Check whether iterations are left, and perform a single internal iteration\n    without returning the result.  Used in the C-style pattern do-while\n    pattern.  For an example, see `nditer`.\n\n    Returns\n    -------\n    iternext : bool\n        Whether or not there are iterations left.'
        ...
    
    @property
    def iterrange(self) -> typing.Any:
        ...
    
    @property
    def itersize(self) -> typing.Any:
        ...
    
    @property
    def itviews(self) -> typing.Any:
        ...
    
    @property
    def multi_index(self) -> typing.Any:
        ...
    
    @property
    def ndim(self) -> typing.Any:
        ...
    
    @property
    def nop(self) -> typing.Any:
        ...
    
    @property
    def operands(self) -> typing.Any:
        'operands[`Slice`]\n\n    The array(s) to be iterated over. Valid only before the iterator is closed.'
        ...
    
    def remove_axis(self, i) -> typing.Any:
        '    Removes axis `i` from the iterator. Requires that the flag "multi_index"\n    be enabled.'
        ...
    
    def remove_multi_index(self) -> typing.Any:
        '    When the "multi_index" flag was specified, this removes it, allowing\n    the internal iteration structure to be optimized further.'
        ...
    
    def reset(self) -> typing.Any:
        '    Reset the iterator to its initial state.'
        ...
    
    @property
    def shape(self) -> typing.Any:
        ...
    
    @property
    def value(self) -> typing.Any:
        ...
    
    def __getattr__(self, name) -> typing.Any:
        ...
    

def negative(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Numerical negative, element-wise.\n\nParameters\n----------\nx : array_like or scalar\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    Returned array or scalar: `y = -x`.\n    This is a scalar if `x` is a scalar.\n\nExamples\n--------\n>>> np.negative([1.,-1.])\narray([-1.,  1.])\n\nThe unary ``-`` operator can be used as a shorthand for ``np.negative`` on\nndarrays.\n\n>>> x1 = np.array(([1., -1.]))\n>>> -x1\narray([-1.,  1.])'
    ...

def nested_iters(op, axes, flags=..., op_flags=..., op_dtypes=..., order=..., casting=..., buffersize=...) -> typing.Any:
    '    Create nditers for use in nested loops\n\n    Create a tuple of `nditer` objects which iterate in nested loops over\n    different axes of the op argument. The first iterator is used in the\n    outermost loop, the last in the innermost loop. Advancing one will change\n    the subsequent iterators to point at its new element.\n\n    Parameters\n    ----------\n    op : ndarray or sequence of array_like\n        The array(s) to iterate over.\n\n    axes : list of list of int\n        Each item is used as an "op_axes" argument to an nditer\n\n    flags, op_flags, op_dtypes, order, casting, buffersize (optional)\n        See `nditer` parameters of the same name\n\n    Returns\n    -------\n    iters : tuple of nditer\n        An nditer for each item in `axes`, outermost first\n\n    See Also\n    --------\n    nditer\n\n    Examples\n    --------\n\n    Basic usage. Note how y is the "flattened" version of\n    [a[:, 0, :], a[:, 1, 0], a[:, 2, :]] since we specified\n    the first iter\'s axes as [1]\n\n    >>> a = np.arange(12).reshape(2, 3, 2)\n    >>> i, j = np.nested_iters(a, [[1], [0, 2]], flags=["multi_index"])\n    >>> for x in i:\n    ...      print(i.multi_index)\n    ...      for y in j:\n    ...          print(\'\', j.multi_index, y)\n    (0,)\n     (0, 0) 0\n     (0, 1) 1\n     (1, 0) 6\n     (1, 1) 7\n    (1,)\n     (0, 0) 2\n     (0, 1) 3\n     (1, 0) 8\n     (1, 1) 9\n    (2,)\n     (0, 0) 4\n     (0, 1) 5\n     (1, 0) 10\n     (1, 1) 11'
    ...

def nextafter(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the next floating-point value after x1 towards x2, element-wise.\n\nParameters\n----------\nx1 : array_like\n    Values to find the next representable value of.\nx2 : array_like\n    The direction where to look for the next representable value of `x1`.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    The next representable values of `x1` in the direction of `x2`.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nExamples\n--------\n>>> eps = np.finfo(np.float64).eps\n>>> np.nextafter(1, 2) == eps + 1\nTrue\n>>> np.nextafter([1, 2], [2, 1]) == [eps + 1, 2 - eps]\narray([ True,  True])'
    ...

def normalize_axis_index(axis, ndim, msg_prefix=...) -> typing.Any:
    "    Normalizes an axis index, `axis`, such that is a valid positive index into\n    the shape of array with `ndim` dimensions. Raises an AxisError with an\n    appropriate message if this is not possible.\n\n    Used internally by all axis-checking logic.\n\n    .. versionadded:: 1.13.0\n\n    Parameters\n    ----------\n    axis : int\n        The un-normalized index of the axis. Can be negative\n    ndim : int\n        The number of dimensions of the array that `axis` should be normalized\n        against\n    msg_prefix : str\n        A prefix to put before the message, typically the name of the argument\n\n    Returns\n    -------\n    normalized_axis : int\n        The normalized axis index, such that `0 <= normalized_axis < ndim`\n\n    Raises\n    ------\n    AxisError\n        If the axis index is invalid, when `-ndim <= axis < ndim` is false.\n\n    Examples\n    --------\n    >>> normalize_axis_index(0, ndim=3)\n    0\n    >>> normalize_axis_index(1, ndim=3)\n    1\n    >>> normalize_axis_index(-1, ndim=3)\n    2\n\n    >>> normalize_axis_index(3, ndim=3)\n    Traceback (most recent call last):\n    ...\n    AxisError: axis 3 is out of bounds for array of dimension 3\n    >>> normalize_axis_index(-4, ndim=3, msg_prefix='axes_arg')\n    Traceback (most recent call last):\n    ...\n    AxisError: axes_arg: axis -4 is out of bounds for array of dimension 3"
    ...

def not_equal(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return (x1 != x2) element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    Input arrays.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array, element-wise comparison of `x1` and `x2`.\n    Typically of type bool, unless ``dtype=object`` is passed.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nequal, greater, greater_equal, less, less_equal\n\nExamples\n--------\n>>> np.not_equal([1.,2.], [1., 3.])\narray([False,  True])\n>>> np.not_equal([1, 2], [[1, 3],[1, 4]])\narray([[False,  True],\n       [False,  True]])\n\nThe ``!=`` operator can be used as a shorthand for ``np.not_equal`` on\nndarrays.\n\n>>> a = np.array([1., 2.])\n>>> b = np.array([1., 3.])\n>>> a != b\narray([False,  True])'
    ...

def packbits(a, axis=..., bitorder=...) -> typing.Any:
    "    Packs the elements of a binary-valued array into bits in a uint8 array.\n\n    The result is padded to full bytes by inserting zero bits at the end.\n\n    Parameters\n    ----------\n    a : array_like\n        An array of integers or booleans whose elements should be packed to\n        bits.\n    axis : int, optional\n        The dimension over which bit-packing is done.\n        ``None`` implies packing the flattened array.\n    bitorder : {'big', 'little'}, optional\n        The order of the input bits. 'big' will mimic bin(val),\n        ``[0, 0, 0, 0, 0, 0, 1, 1] => 3 = 0b00000011``, 'little' will\n        reverse the order so ``[1, 1, 0, 0, 0, 0, 0, 0] => 3``.\n        Defaults to 'big'.\n\n        .. versionadded:: 1.17.0\n\n    Returns\n    -------\n    packed : ndarray\n        Array of type uint8 whose elements represent bits corresponding to the\n        logical (0 or nonzero) value of the input elements. The shape of\n        `packed` has the same number of dimensions as the input (unless `axis`\n        is None, in which case the output is 1-D).\n\n    See Also\n    --------\n    unpackbits: Unpacks elements of a uint8 array into a binary-valued output\n                array.\n\n    Examples\n    --------\n    >>> a = np.array([[[1,0,1],\n    ...                [0,1,0]],\n    ...               [[1,1,0],\n    ...                [0,0,1]]])\n    >>> b = np.packbits(a, axis=-1)\n    >>> b\n    array([[[160],\n            [ 64]],\n           [[192],\n            [ 32]]], dtype=uint8)\n\n    Note that in binary 160 = 1010 0000, 64 = 0100 0000, 192 = 1100 0000,\n    and 32 = 0010 0000.\n\n    "
    ...

pi: float
def positive(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Numerical positive, element-wise.\n\n.. versionadded:: 1.13.0\n\nParameters\n----------\nx : array_like or scalar\n    Input array.\n\nReturns\n-------\ny : ndarray or scalar\n    Returned array or scalar: `y = +x`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nEquivalent to `x.copy()`, but only defined for types that support\narithmetic.\n\nExamples\n--------\n\n>>> x1 = np.array(([1., -1.]))\n>>> np.positive(x1)\narray([ 1., -1.])\n\nThe unary ``+`` operator can be used as a shorthand for ``np.positive`` on\nndarrays.\n\n>>> x1 = np.array(([1., -1.]))\n>>> +x1\narray([ 1., -1.])'
    ...

def power(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "First array elements raised to powers from second array, element-wise.\n\nRaise each base in `x1` to the positionally-corresponding power in\n`x2`.  `x1` and `x2` must be broadcastable to the same shape.\n\nAn integer type raised to a negative integer power will raise a\n``ValueError``.\n\nNegative values raised to a non-integral value will return ``nan``.\nTo get complex results, cast the input to complex, or specify the\n``dtype`` to be ``complex`` (see the example below).\n\nParameters\n----------\nx1 : array_like\n    The bases.\nx2 : array_like\n    The exponents.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The bases in `x1` raised to the exponents in `x2`.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfloat_power : power function that promotes integers to float\n\nExamples\n--------\nCube each element in an array.\n\n>>> x1 = np.arange(6)\n>>> x1\n[0, 1, 2, 3, 4, 5]\n>>> np.power(x1, 3)\narray([  0,   1,   8,  27,  64, 125])\n\nRaise the bases to different exponents.\n\n>>> x2 = [1.0, 2.0, 3.0, 3.0, 2.0, 1.0]\n>>> np.power(x1, x2)\narray([  0.,   1.,   8.,  27.,  16.,   5.])\n\nThe effect of broadcasting.\n\n>>> x2 = np.array([[1, 2, 3, 3, 2, 1], [1, 2, 3, 3, 2, 1]])\n>>> x2\narray([[1, 2, 3, 3, 2, 1],\n       [1, 2, 3, 3, 2, 1]])\n>>> np.power(x1, x2)\narray([[ 0,  1,  8, 27, 16,  5],\n       [ 0,  1,  8, 27, 16,  5]])\n\nThe ``**`` operator can be used as a shorthand for ``np.power`` on\nndarrays.\n\n>>> x2 = np.array([1, 2, 3, 3, 2, 1])\n>>> x1 = np.arange(6)\n>>> x1 ** x2\narray([ 0,  1,  8, 27, 16,  5])\n\nNegative values raised to a non-integral value will result in ``nan``\n(and a warning will be generated).\n\n>>> x3 = np.array([-1.0, -4.0])\n>>> with np.errstate(invalid='ignore'):\n...     p = np.power(x3, 1.5)\n...\n>>> p\narray([nan, nan])\n\nTo get complex results, give the argument ``dtype=complex``.\n\n>>> np.power(x3, 1.5, dtype=complex)\narray([-1.83697020e-16-1.j, -1.46957616e-15-8.j])"
    ...

def promote_types(type1, type2) -> typing.Any:
    '    Returns the data type with the smallest size and smallest scalar\n    kind to which both ``type1`` and ``type2`` may be safely cast.\n    The returned data type is always considered "canonical", this mainly\n    means that the promoted dtype will always be in native byte order.\n\n    This function is symmetric, but rarely associative.\n\n    Parameters\n    ----------\n    type1 : dtype or dtype specifier\n        First data type.\n    type2 : dtype or dtype specifier\n        Second data type.\n\n    Returns\n    -------\n    out : dtype\n        The promoted data type.\n\n    Notes\n    -----\n    Please see `numpy.result_type` for additional information about promotion.\n\n    .. versionadded:: 1.6.0\n\n    Starting in NumPy 1.9, promote_types function now returns a valid string\n    length when given an integer or float dtype as one argument and a string\n    dtype as another argument. Previously it always returned the input string\n    dtype, even if it wasn\'t long enough to store the max integer/float value\n    converted to a string.\n\n    .. versionchanged:: 1.23.0\n\n    NumPy now supports promotion for more structured dtypes.  It will now\n    remove unnecessary padding from a structure dtype and promote included\n    fields individually.\n\n    See Also\n    --------\n    result_type, dtype, can_cast\n\n    Examples\n    --------\n    >>> np.promote_types(\'f4\', \'f8\')\n    dtype(\'float64\')\n\n    >>> np.promote_types(\'i8\', \'f4\')\n    dtype(\'float64\')\n\n    >>> np.promote_types(\'>i8\', \'<c8\')\n    dtype(\'complex128\')\n\n    >>> np.promote_types(\'i4\', \'S8\')\n    dtype(\'S11\')\n\n    An example of a non-associative case:\n\n    >>> p = np.promote_types\n    >>> p(\'S\', p(\'i1\', \'u1\'))\n    dtype(\'S6\')\n    >>> p(p(\'S\', \'i1\'), \'u1\')\n    dtype(\'S4\')'
    ...

def putmask(a, mask, values) -> typing.Any:
    '    Changes elements of an array based on conditional and input values.\n\n    Sets ``a.flat[n] = values[n]`` for each n where ``mask.flat[n]==True``.\n\n    If `values` is not the same size as `a` and `mask` then it will repeat.\n    This gives behavior different from ``a[mask] = values``.\n\n    Parameters\n    ----------\n    a : ndarray\n        Target array.\n    mask : array_like\n        Boolean mask array. It has to be the same shape as `a`.\n    values : array_like\n        Values to put into `a` where `mask` is True. If `values` is smaller\n        than `a` it will be repeated.\n\n    See Also\n    --------\n    place, put, take, copyto\n\n    Examples\n    --------\n    >>> x = np.arange(6).reshape(2, 3)\n    >>> np.putmask(x, x>2, x**2)\n    >>> x\n    array([[ 0,  1,  2],\n           [ 9, 16, 25]])\n\n    If `values` is smaller than `a` it is repeated:\n\n    >>> x = np.arange(5)\n    >>> np.putmask(x, x>1, [-33, -44])\n    >>> x\n    array([  0,   1, -33, -44, -33])\n\n    '
    ...

def rad2deg(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Convert angles from radians to degrees.\n\nParameters\n----------\nx : array_like\n    Angle in radians.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding angle in degrees.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\ndeg2rad : Convert angles from degrees to radians.\nunwrap : Remove large jumps in angle by wrapping.\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nrad2deg(x) is ``180 * x / pi``.\n\nExamples\n--------\n>>> np.rad2deg(np.pi/2)\n90.0'
    ...

def radians(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Convert angles from degrees to radians.\n\nParameters\n----------\nx : array_like\n    Input array in degrees.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding radian values.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\ndeg2rad : equivalent function\n\nExamples\n--------\nConvert a degree array to radians\n\n>>> deg = np.arange(12.) * 30.\n>>> np.radians(deg)\narray([ 0.        ,  0.52359878,  1.04719755,  1.57079633,  2.0943951 ,\n        2.61799388,  3.14159265,  3.66519143,  4.1887902 ,  4.71238898,\n        5.23598776,  5.75958653])\n\n>>> out = np.zeros((deg.shape))\n>>> ret = np.radians(deg, out)\n>>> ret is out\nTrue'
    ...

def ravel_multi_index(multi_index, dims, mode=..., order=...) -> typing.Any:
    "    Converts a tuple of index arrays into an array of flat\n    indices, applying boundary modes to the multi-index.\n\n    Parameters\n    ----------\n    multi_index : tuple of array_like\n        A tuple of integer arrays, one array for each dimension.\n    dims : tuple of ints\n        The shape of array into which the indices from ``multi_index`` apply.\n    mode : {'raise', 'wrap', 'clip'}, optional\n        Specifies how out-of-bounds indices are handled.  Can specify\n        either one mode or a tuple of modes, one mode per index.\n\n        * 'raise' -- raise an error (default)\n        * 'wrap' -- wrap around\n        * 'clip' -- clip to the range\n\n        In 'clip' mode, a negative index which would normally\n        wrap will clip to 0 instead.\n    order : {'C', 'F'}, optional\n        Determines whether the multi-index should be viewed as\n        indexing in row-major (C-style) or column-major\n        (Fortran-style) order.\n\n    Returns\n    -------\n    raveled_indices : ndarray\n        An array of indices into the flattened version of an array\n        of dimensions ``dims``.\n\n    See Also\n    --------\n    unravel_index\n\n    Notes\n    -----\n    .. versionadded:: 1.6.0\n\n    Examples\n    --------\n    >>> arr = np.array([[3,6,6],[4,5,1]])\n    >>> np.ravel_multi_index(arr, (7,6))\n    array([22, 41, 37])\n    >>> np.ravel_multi_index(arr, (7,6), order='F')\n    array([31, 41, 13])\n    >>> np.ravel_multi_index(arr, (4,6), mode='clip')\n    array([22, 23, 19])\n    >>> np.ravel_multi_index(arr, (4,4), mode=('clip','wrap'))\n    array([12, 13, 13])\n\n    >>> np.ravel_multi_index((3,1,4,1), (6,7,8,9))\n    1621\n    "
    ...

def reciprocal(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the reciprocal of the argument, element-wise.\n\nCalculates ``1/x``.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    Return array.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\n.. note::\n    This function is not designed to work with integers.\n\nFor integer arguments with absolute value larger than 1 the result is\nalways zero because of the way Python handles integer division.  For\ninteger zero the result is an overflow.\n\nExamples\n--------\n>>> np.reciprocal(2.)\n0.5\n>>> np.reciprocal([1, 2., 3.33])\narray([ 1.       ,  0.5      ,  0.3003003])'
    ...

def remainder(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Returns the element-wise remainder of division.\n\nComputes the remainder complementary to the `floor_divide` function.  It is\nequivalent to the Python modulus operator``x1 % x2`` and has the same sign\nas the divisor `x2`. The MATLAB function equivalent to ``np.remainder``\nis ``mod``.\n\n.. warning::\n\n    This should not be confused with:\n\n    * Python 3.7's `math.remainder` and C's ``remainder``, which\n      computes the IEEE remainder, which are the complement to\n      ``round(x1 / x2)``.\n    * The MATLAB ``rem`` function and or the C ``%`` operator which is the\n      complement to ``int(x1 / x2)``.\n\nParameters\n----------\nx1 : array_like\n    Dividend array.\nx2 : array_like\n    Divisor array.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The element-wise remainder of the quotient ``floor_divide(x1, x2)``.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nfloor_divide : Equivalent of Python ``//`` operator.\ndivmod : Simultaneous floor division and remainder.\nfmod : Equivalent of the MATLAB ``rem`` function.\ndivide, floor\n\nNotes\n-----\nReturns 0 when `x2` is 0 and both `x1` and `x2` are (arrays of)\nintegers.\n``mod`` is an alias of ``remainder``.\n\nExamples\n--------\n>>> np.remainder([4, 7], [2, 3])\narray([0, 1])\n>>> np.remainder(np.arange(7), 5)\narray([0, 1, 2, 3, 4, 0, 1])\n\nThe ``%`` operator can be used as a shorthand for ``np.remainder`` on\nndarrays.\n\n>>> x1 = np.arange(7)\n>>> x1 % 5\narray([0, 1, 2, 3, 4, 0, 1])"
    ...

def result_type(*arrays_and_dtypes) -> typing.Any:
    "    Returns the type that results from applying the NumPy\n    type promotion rules to the arguments.\n\n    Type promotion in NumPy works similarly to the rules in languages\n    like C++, with some slight differences.  When both scalars and\n    arrays are used, the array's type takes precedence and the actual value\n    of the scalar is taken into account.\n\n    For example, calculating 3*a, where a is an array of 32-bit floats,\n    intuitively should result in a 32-bit float output.  If the 3 is a\n    32-bit integer, the NumPy rules indicate it can't convert losslessly\n    into a 32-bit float, so a 64-bit float should be the result type.\n    By examining the value of the constant, '3', we see that it fits in\n    an 8-bit integer, which can be cast losslessly into the 32-bit float.\n\n    Parameters\n    ----------\n    arrays_and_dtypes : list of arrays and dtypes\n        The operands of some operation whose result type is needed.\n\n    Returns\n    -------\n    out : dtype\n        The result type.\n\n    See also\n    --------\n    dtype, promote_types, min_scalar_type, can_cast\n\n    Notes\n    -----\n    .. versionadded:: 1.6.0\n\n    The specific algorithm used is as follows.\n\n    Categories are determined by first checking which of boolean,\n    integer (int/uint), or floating point (float/complex) the maximum\n    kind of all the arrays and the scalars are.\n\n    If there are only scalars or the maximum category of the scalars\n    is higher than the maximum category of the arrays,\n    the data types are combined with :func:`promote_types`\n    to produce the return value.\n\n    Otherwise, `min_scalar_type` is called on each scalar, and\n    the resulting data types are all combined with :func:`promote_types`\n    to produce the return value.\n\n    The set of int values is not a subset of the uint values for types\n    with the same number of bits, something not reflected in\n    :func:`min_scalar_type`, but handled as a special case in `result_type`.\n\n    Examples\n    --------\n    >>> np.result_type(3, np.arange(7, dtype='i1'))\n    dtype('int8')\n\n    >>> np.result_type('i4', 'c8')\n    dtype('complex128')\n\n    >>> np.result_type(3.0, -2)\n    dtype('float64')\n\n    "
    ...

def right_shift(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Shift the bits of an integer to the right.\n\nBits are shifted to the right `x2`.  Because the internal\nrepresentation of numbers is in binary format, this operation is\nequivalent to dividing `x1` by ``2**x2``.\n\nParameters\n----------\nx1 : array_like, int\n    Input values.\nx2 : array_like, int\n    Number of bits to remove at the right of `x1`.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray, int\n    Return `x1` with bits shifted `x2` times to the right.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nleft_shift : Shift the bits of an integer to the left.\nbinary_repr : Return the binary representation of the input number\n    as a string.\n\nExamples\n--------\n>>> np.binary_repr(10)\n'1010'\n>>> np.right_shift(10, 1)\n5\n>>> np.binary_repr(5)\n'101'\n\n>>> np.right_shift(10, [1,2,3])\narray([5, 2, 1])\n\nThe ``>>`` operator can be used as a shorthand for ``np.right_shift`` on\nndarrays.\n\n>>> x1 = 10\n>>> x2 = np.array([1,2,3])\n>>> x1 >> x2\narray([5, 2, 1])"
    ...

def rint(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Round elements of the array to the nearest integer.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Output array is same shape and type as `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nfix, ceil, floor, trunc\n\nNotes\n-----\nFor values exactly halfway between rounded decimal values, NumPy\nrounds to the nearest even value. Thus 1.5 and 2.5 round to 2.0,\n-0.5 and 0.5 round to 0.0, etc.\n\nExamples\n--------\n>>> a = np.array([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0])\n>>> np.rint(a)\narray([-2., -2., -0.,  0.,  2.,  2.,  2.])'
    ...

def scalar(dtype, obj) -> typing.Any:
    '    Return a new scalar array of the given type initialized with obj.\n\n    This function is meant mainly for pickle support. `dtype` must be a\n    valid data-type descriptor. If `dtype` corresponds to an object\n    descriptor, then `obj` can be any object, otherwise `obj` must be a\n    string. If `obj` is not given, it will be interpreted as None for object\n    type and as zeros for all other types.'
    ...

def set_datetimeparse_function() -> typing.Any:
    ...

def set_legacy_print_mode() -> typing.Any:
    ...

def set_numeric_ops() -> typing.Any:
    '    Set numerical operators for array objects.\n\n    .. deprecated:: 1.16\n\n        For the general case, use :c:func:`PyUFunc_ReplaceLoopBySignature`.\n        For ndarray subclasses, define the ``__array_ufunc__`` method and\n        override the relevant ufunc.\n\n    Parameters\n    ----------\n    op1, op2, ... : callable\n        Each ``op = func`` pair describes an operator to be replaced.\n        For example, ``add = lambda x, y: np.add(x, y) % 5`` would replace\n        addition by modulus 5 addition.\n\n    Returns\n    -------\n    saved_ops : list of callables\n        A list of all operators, stored before making replacements.\n\n    Notes\n    -----\n    .. warning::\n       Use with care!  Incorrect usage may lead to memory errors.\n\n    A function replacing an operator cannot make use of that operator.\n    For example, when replacing add, you may not use ``+``.  Instead,\n    directly call ufuncs.\n\n    Examples\n    --------\n    >>> def add_mod5(x, y):\n    ...     return np.add(x, y) % 5\n    ...\n    >>> old_funcs = np.set_numeric_ops(add=add_mod5)\n\n    >>> x = np.arange(12).reshape((3, 4))\n    >>> x + x\n    array([[0, 2, 4, 1],\n           [3, 0, 2, 4],\n           [1, 3, 0, 2]])\n\n    >>> ignore = np.set_numeric_ops(**old_funcs) # restore operators'
    ...

def set_string_function(f, repr=...) -> typing.Any:
    '    Internal method to set a function to be used when pretty printing arrays.'
    ...

def set_typeDict(dict) -> typing.Any:
    '    Set the internal dictionary that can look up an array type using a\n    registered code.'
    ...

def seterrobj(errobj) -> typing.Any:
    '    Set the object that defines floating-point error handling.\n\n    The error object contains all information that defines the error handling\n    behavior in NumPy. `seterrobj` is used internally by the other\n    functions that set error handling behavior (`seterr`, `seterrcall`).\n\n    Parameters\n    ----------\n    errobj : list\n        The error object, a list containing three elements:\n        [internal numpy buffer size, error mask, error callback function].\n\n        The error mask is a single integer that holds the treatment information\n        on all four floating point errors. The information for each error type\n        is contained in three bits of the integer. If we print it in base 8, we\n        can see what treatment is set for "invalid", "under", "over", and\n        "divide" (in that order). The printed string can be interpreted with\n\n        * 0 : \'ignore\'\n        * 1 : \'warn\'\n        * 2 : \'raise\'\n        * 3 : \'call\'\n        * 4 : \'print\'\n        * 5 : \'log\'\n\n    See Also\n    --------\n    geterrobj, seterr, geterr, seterrcall, geterrcall\n    getbufsize, setbufsize\n\n    Notes\n    -----\n    For complete documentation of the types of floating-point exceptions and\n    treatment options, see `seterr`.\n\n    Examples\n    --------\n    >>> old_errobj = np.geterrobj()  # first get the defaults\n    >>> old_errobj\n    [8192, 521, None]\n\n    >>> def err_handler(type, flag):\n    ...     print("Floating point error (%s), with flag %s" % (type, flag))\n    ...\n    >>> new_errobj = [20000, 12, err_handler]\n    >>> np.seterrobj(new_errobj)\n    >>> np.base_repr(12, 8)  # int for divide=4 (\'print\') and over=1 (\'warn\')\n    \'14\'\n    >>> np.geterr()\n    {\'over\': \'warn\', \'divide\': \'print\', \'invalid\': \'ignore\', \'under\': \'ignore\'}\n    >>> np.geterrcall() is err_handler\n    True'
    ...

def shares_memory(a, b, max_work=...) -> typing.Any:
    '    Determine if two arrays share memory.\n\n    .. warning::\n\n       This function can be exponentially slow for some inputs, unless\n       `max_work` is set to a finite number or ``MAY_SHARE_BOUNDS``.\n       If in doubt, use `numpy.may_share_memory` instead.\n\n    Parameters\n    ----------\n    a, b : ndarray\n        Input arrays\n    max_work : int, optional\n        Effort to spend on solving the overlap problem (maximum number\n        of candidate solutions to consider). The following special\n        values are recognized:\n\n        max_work=MAY_SHARE_EXACT  (default)\n            The problem is solved exactly. In this case, the function returns\n            True only if there is an element shared between the arrays. Finding\n            the exact solution may take extremely long in some cases.\n        max_work=MAY_SHARE_BOUNDS\n            Only the memory bounds of a and b are checked.\n\n    Raises\n    ------\n    numpy.exceptions.TooHardError\n        Exceeded max_work.\n\n    Returns\n    -------\n    out : bool\n\n    See Also\n    --------\n    may_share_memory\n\n    Examples\n    --------\n    >>> x = np.array([1, 2, 3, 4])\n    >>> np.shares_memory(x, np.array([5, 6, 7]))\n    False\n    >>> np.shares_memory(x[::2], x)\n    True\n    >>> np.shares_memory(x[::2], x[1::2])\n    False\n\n    Checking whether two arrays share memory is NP-complete, and\n    runtime may increase exponentially in the number of\n    dimensions. Hence, `max_work` should generally be set to a finite\n    number, as it is possible to construct examples that take\n    extremely long to run:\n\n    >>> from numpy.lib.stride_tricks import as_strided\n    >>> x = np.zeros([192163377], dtype=np.int8)\n    >>> x1 = as_strided(x, strides=(36674, 61119, 85569), shape=(1049, 1049, 1049))\n    >>> x2 = as_strided(x[64023025:], strides=(12223, 12224, 1), shape=(1049, 1049, 1))\n    >>> np.shares_memory(x1, x2, max_work=1000)\n    Traceback (most recent call last):\n    ...\n    numpy.exceptions.TooHardError: Exceeded max_work\n\n    Running ``np.shares_memory(x1, x2)`` without `max_work` set takes\n    around 1 minute for this case. It is possible to find problems\n    that take still significantly longer.\n\n    '
    ...

def sign(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Returns an element-wise indication of the sign of a number.\n\nThe `sign` function returns ``-1 if x < 0, 0 if x==0, 1 if x > 0``.  nan\nis returned for nan inputs.\n\nFor complex inputs, the `sign` function returns\n``sign(x.real) + 0j if x.real != 0 else sign(x.imag) + 0j``.\n\ncomplex(nan, 0) is returned for complex nan inputs.\n\nParameters\n----------\nx : array_like\n    Input values.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The sign of `x`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nThere is more than one definition of sign in common use for complex\nnumbers.  The definition used here is equivalent to :math:`x/\\sqrt{x*x}`\nwhich is different from a common alternative, :math:`x/|x|`.\n\nExamples\n--------\n>>> np.sign([-5., 4.5])\narray([-1.,  1.])\n>>> np.sign(0)\n0\n>>> np.sign(5-2j)\n(1+0j)'
    ...

def signbit(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Returns element-wise True where signbit is set (less than zero).\n\nParameters\n----------\nx : array_like\n    The input value(s).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nresult : ndarray of bool\n    Output array, or reference to `out` if that was supplied.\n    This is a scalar if `x` is a scalar.\n\nExamples\n--------\n>>> np.signbit(-1.2)\nTrue\n>>> np.signbit(np.array([1, -2.3, 2.1]))\narray([False,  True, False])'
    ...

def sin(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "Trigonometric sine, element-wise.\n\nParameters\n----------\nx : array_like\n    Angle, in radians (:math:`2 \\pi` rad equals 360 degrees).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : array_like\n    The sine of each element of x.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\narcsin, sinh, cos\n\nNotes\n-----\nThe sine is one of the fundamental functions of trigonometry (the\nmathematical study of triangles).  Consider a circle of radius 1\ncentered on the origin.  A ray comes in from the :math:`+x` axis, makes\nan angle at the origin (measured counter-clockwise from that axis), and\ndeparts from the origin.  The :math:`y` coordinate of the outgoing\nray's intersection with the unit circle is the sine of that angle.  It\nranges from -1 for :math:`x=3\\pi / 2` to +1 for :math:`\\pi / 2.`  The\nfunction has zeroes where the angle is a multiple of :math:`\\pi`.\nSines of angles between :math:`\\pi` and :math:`2\\pi` are negative.\nThe numerous properties of the sine and related functions are included\nin any standard trigonometry text.\n\nExamples\n--------\nPrint sine of one angle:\n\n>>> np.sin(np.pi/2.)\n1.0\n\nPrint sines of an array of angles given in degrees:\n\n>>> np.sin(np.array((0., 30., 45., 60., 90.)) * np.pi / 180. )\narray([ 0.        ,  0.5       ,  0.70710678,  0.8660254 ,  1.        ])\n\nPlot the sine function:\n\n>>> import matplotlib.pylab as plt\n>>> x = np.linspace(-np.pi, np.pi, 201)\n>>> plt.plot(x, np.sin(x))\n>>> plt.xlabel('Angle [rad]')\n>>> plt.ylabel('sin(x)')\n>>> plt.axis('tight')\n>>> plt.show()"
    ...

def sinh(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Hyperbolic sine, element-wise.\n\nEquivalent to ``1/2 * (np.exp(x) - np.exp(-x))`` or\n``-1j * np.sin(1j*x)``.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding hyperbolic sine values.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nIf `out` is provided, the function writes the result into it,\nand returns a reference to `out`.  (See Examples)\n\nReferences\n----------\nM. Abramowitz and I. A. Stegun, Handbook of Mathematical Functions.\nNew York, NY: Dover, 1972, pg. 83.\n\nExamples\n--------\n>>> np.sinh(0)\n0.0\n>>> np.sinh(np.pi*1j/2)\n1j\n>>> np.sinh(np.pi*1j) # (exact value is 0)\n1.2246063538223773e-016j\n>>> # Discrepancy due to vagaries of floating point arithmetic.\n\n>>> # Example of providing the optional output parameter\n>>> out1 = np.array([0], dtype=\'d\')\n>>> out2 = np.sinh([0.1], out1)\n>>> out2 is out1\nTrue\n\n>>> # Example of ValueError due to provision of shape mis-matched `out`\n>>> np.sinh(np.zeros((3,3)),np.zeros((2,2)))\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: operands could not be broadcast together with shapes (3,3) (2,2)'
    ...

def spacing(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the distance between x and the nearest adjacent number.\n\nParameters\n----------\nx : array_like\n    Values to find the spacing of.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    The spacing of values of `x`.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nIt can be considered as a generalization of EPS:\n``spacing(np.float64(1)) == np.finfo(np.float64).eps``, and there\nshould not be any representable number between ``x + spacing(x)`` and\nx for any finite x.\n\nSpacing of +- inf and NaN is NaN.\n\nExamples\n--------\n>>> np.spacing(1) == np.finfo(np.float64).eps\nTrue'
    ...

def sqrt(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the non-negative square-root of an array, element-wise.\n\nParameters\n----------\nx : array_like\n    The values whose square-roots are required.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    An array of the same shape as `x`, containing the positive\n    square-root of each element in `x`.  If any element in `x` is\n    complex, a complex array is returned (and the square-roots of\n    negative reals are calculated).  If all of the elements in `x`\n    are real, so is `y`, with negative elements returning ``nan``.\n    If `out` was provided, `y` is a reference to it.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nemath.sqrt\n    A version which returns complex numbers when given negative reals.\n    Note that 0.0 and -0.0 are handled differently for complex inputs.\n\nNotes\n-----\n*sqrt* has--consistent with common convention--as its branch cut the\nreal "interval" [`-inf`, 0), and is continuous from above on it.\nA branch cut is a curve in the complex plane across which a given\ncomplex function fails to be continuous.\n\nExamples\n--------\n>>> np.sqrt([1,4,9])\narray([ 1.,  2.,  3.])\n\n>>> np.sqrt([4, -1, -3+4J])\narray([ 2.+0.j,  0.+1.j,  1.+2.j])\n\n>>> np.sqrt([4, -1, np.inf])\narray([ 2., nan, inf])'
    ...

def square(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the element-wise square of the input.\n\nParameters\n----------\nx : array_like\n    Input data.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\nout : ndarray or scalar\n    Element-wise `x*x`, of the same shape and dtype as `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nnumpy.linalg.matrix_power\nsqrt\npower\n\nExamples\n--------\n>>> np.square([-1j, 1])\narray([-1.-0.j,  1.+0.j])'
    ...

def subtract(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Subtract arguments, element-wise.\n\nParameters\n----------\nx1, x2 : array_like\n    The arrays to be subtracted from each other.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The difference of `x1` and `x2`, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nNotes\n-----\nEquivalent to ``x1 - x2`` in terms of array broadcasting.\n\nExamples\n--------\n>>> np.subtract(1.0, 4.0)\n-3.0\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> np.subtract(x1, x2)\narray([[ 0.,  0.,  0.],\n       [ 3.,  3.,  3.],\n       [ 6.,  6.,  6.]])\n\nThe ``-`` operator can be used as a shorthand for ``np.subtract`` on\nndarrays.\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> x1 - x2\narray([[0., 0., 0.],\n       [3., 3., 3.],\n       [6., 6., 6.]])'
    ...

def tan(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute tangent element-wise.\n\nEquivalent to ``np.sin(x)/np.cos(x)`` element-wise.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding tangent values.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nIf `out` is provided, the function writes the result into it,\nand returns a reference to `out`.  (See Examples)\n\nReferences\n----------\nM. Abramowitz and I. A. Stegun, Handbook of Mathematical Functions.\nNew York, NY: Dover, 1972.\n\nExamples\n--------\n>>> from math import pi\n>>> np.tan(np.array([-pi,pi/2,pi]))\narray([  1.22460635e-16,   1.63317787e+16,  -1.22460635e-16])\n>>>\n>>> # Example of providing the optional output parameter illustrating\n>>> # that what is returned is a reference to said parameter\n>>> out1 = np.array([0], dtype=\'d\')\n>>> out2 = np.cos([0.1], out1)\n>>> out2 is out1\nTrue\n>>>\n>>> # Example of ValueError due to provision of shape mis-matched `out`\n>>> np.cos(np.zeros((3,3)),np.zeros((2,2)))\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: operands could not be broadcast together with shapes (3,3) (2,2)'
    ...

def tanh(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Compute hyperbolic tangent element-wise.\n\nEquivalent to ``np.sinh(x)/np.cosh(x)`` or ``-1j * np.tan(1j*x)``.\n\nParameters\n----------\nx : array_like\n    Input array.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray\n    The corresponding hyperbolic tangent values.\n    This is a scalar if `x` is a scalar.\n\nNotes\n-----\nIf `out` is provided, the function writes the result into it,\nand returns a reference to `out`.  (See Examples)\n\nReferences\n----------\n.. [1] M. Abramowitz and I. A. Stegun, Handbook of Mathematical Functions.\n       New York, NY: Dover, 1972, pg. 83.\n       https://personal.math.ubc.ca/~cbm/aands/page_83.htm\n\n.. [2] Wikipedia, "Hyperbolic function",\n       https://en.wikipedia.org/wiki/Hyperbolic_function\n\nExamples\n--------\n>>> np.tanh((0, np.pi*1j, np.pi*1j/2))\narray([ 0. +0.00000000e+00j,  0. -1.22460635e-16j,  0. +1.63317787e+16j])\n\n>>> # Example of providing the optional output parameter illustrating\n>>> # that what is returned is a reference to said parameter\n>>> out1 = np.array([0], dtype=\'d\')\n>>> out2 = np.tanh([0.1], out1)\n>>> out2 is out1\nTrue\n\n>>> # Example of ValueError due to provision of shape mis-matched `out`\n>>> np.tanh(np.zeros((3,3)),np.zeros((2,2)))\nTraceback (most recent call last):\n  File "<stdin>", line 1, in <module>\nValueError: operands could not be broadcast together with shapes (3,3) (2,2)'
    ...

tracemalloc_domain: int
def true_divide(x1, x2, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    "divide(x1, x2, /, out=None, *, where=True, casting='same_kind', order='K', dtype=None, subok=True[, signature, extobj])\n\nDivide arguments element-wise.\n\nParameters\n----------\nx1 : array_like\n    Dividend array.\nx2 : array_like\n    Divisor array.\n    If ``x1.shape != x2.shape``, they must be broadcastable to a common\n    shape (which becomes the shape of the output).\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The quotient ``x1/x2``, element-wise.\n    This is a scalar if both `x1` and `x2` are scalars.\n\nSee Also\n--------\nseterr : Set whether to raise or warn on overflow, underflow and\n         division by zero.\n\nNotes\n-----\nEquivalent to ``x1`` / ``x2`` in terms of array-broadcasting.\n\nThe ``true_divide(x1, x2)`` function is an alias for\n``divide(x1, x2)``.\n\nExamples\n--------\n>>> np.divide(2.0, 4.0)\n0.5\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = np.arange(3.0)\n>>> np.divide(x1, x2)\narray([[nan, 1. , 1. ],\n       [inf, 4. , 2.5],\n       [inf, 7. , 4. ]])\n\nThe ``/`` operator can be used as a shorthand for ``np.divide`` on\nndarrays.\n\n>>> x1 = np.arange(9.0).reshape((3, 3))\n>>> x2 = 2 * np.ones(3)\n>>> x1 / x2\narray([[0. , 0.5, 1. ],\n       [1.5, 2. , 2.5],\n       [3. , 3.5, 4. ]])"
    ...

def trunc(x, out=..., *, where=..., casting=..., order=..., dtype=..., subok=..., signature=..., extobj=...) -> typing.Any:
    'Return the truncated value of the input, element-wise.\n\nThe truncated value of the scalar `x` is the nearest integer `i` which\nis closer to zero than `x` is. In short, the fractional part of the\nsigned number `x` is discarded.\n\nParameters\n----------\nx : array_like\n    Input data.\nout : ndarray, None, or tuple of ndarray and None, optional\n    A location into which the result is stored. If provided, it must have\n    a shape that the inputs broadcast to. If not provided or None,\n    a freshly-allocated array is returned. A tuple (possible only as a\n    keyword argument) must have length equal to the number of outputs.\nwhere : array_like, optional\n    This condition is broadcast over the input. At locations where the\n    condition is True, the `out` array will be set to the ufunc result.\n    Elsewhere, the `out` array will retain its original value.\n    Note that if an uninitialized `out` array is created via the default\n    ``out=None``, locations within it where the condition is False will\n    remain uninitialized.\n**kwargs\n    For other keyword-only arguments, see the\n    :ref:`ufunc docs <ufuncs.kwargs>`.\n\nReturns\n-------\ny : ndarray or scalar\n    The truncated value of each element in `x`.\n    This is a scalar if `x` is a scalar.\n\nSee Also\n--------\nceil, floor, rint, fix\n\nNotes\n-----\n.. versionadded:: 1.3.0\n\nExamples\n--------\n>>> a = np.array([-1.7, -1.5, -0.2, 0.2, 1.5, 1.7, 2.0])\n>>> np.trunc(a)\narray([-1., -1., -0.,  0.,  1.,  1.,  2.])'
    ...

typeinfo: dict
typeinforanged = _mod_numpy_core_multiarray.typeinforanged
def unpackbits(a, axis=..., count=..., bitorder=...) -> typing.Any:
    "    Unpacks elements of a uint8 array into a binary-valued output array.\n\n    Each element of `a` represents a bit-field that should be unpacked\n    into a binary-valued output array. The shape of the output array is\n    either 1-D (if `axis` is ``None``) or the same shape as the input\n    array with unpacking done along the axis specified.\n\n    Parameters\n    ----------\n    a : ndarray, uint8 type\n       Input array.\n    axis : int, optional\n        The dimension over which bit-unpacking is done.\n        ``None`` implies unpacking the flattened array.\n    count : int or None, optional\n        The number of elements to unpack along `axis`, provided as a way\n        of undoing the effect of packing a size that is not a multiple\n        of eight. A non-negative number means to only unpack `count`\n        bits. A negative number means to trim off that many bits from\n        the end. ``None`` means to unpack the entire array (the\n        default). Counts larger than the available number of bits will\n        add zero padding to the output. Negative counts must not\n        exceed the available number of bits.\n\n        .. versionadded:: 1.17.0\n\n    bitorder : {'big', 'little'}, optional\n        The order of the returned bits. 'big' will mimic bin(val),\n        ``3 = 0b00000011 => [0, 0, 0, 0, 0, 0, 1, 1]``, 'little' will reverse\n        the order to ``[1, 1, 0, 0, 0, 0, 0, 0]``.\n        Defaults to 'big'.\n\n        .. versionadded:: 1.17.0\n\n    Returns\n    -------\n    unpacked : ndarray, uint8 type\n       The elements are binary-valued (0 or 1).\n\n    See Also\n    --------\n    packbits : Packs the elements of a binary-valued array into bits in\n               a uint8 array.\n\n    Examples\n    --------\n    >>> a = np.array([[2], [7], [23]], dtype=np.uint8)\n    >>> a\n    array([[ 2],\n           [ 7],\n           [23]], dtype=uint8)\n    >>> b = np.unpackbits(a, axis=1)\n    >>> b\n    array([[0, 0, 0, 0, 0, 0, 1, 0],\n           [0, 0, 0, 0, 0, 1, 1, 1],\n           [0, 0, 0, 1, 0, 1, 1, 1]], dtype=uint8)\n    >>> c = np.unpackbits(a, axis=1, count=-3)\n    >>> c\n    array([[0, 0, 0, 0, 0],\n           [0, 0, 0, 0, 0],\n           [0, 0, 0, 1, 0]], dtype=uint8)\n\n    >>> p = np.packbits(b, axis=0)\n    >>> np.unpackbits(p, axis=0)\n    array([[0, 0, 0, 0, 0, 0, 1, 0],\n           [0, 0, 0, 0, 0, 1, 1, 1],\n           [0, 0, 0, 1, 0, 1, 1, 1],\n           [0, 0, 0, 0, 0, 0, 0, 0],\n           [0, 0, 0, 0, 0, 0, 0, 0],\n           [0, 0, 0, 0, 0, 0, 0, 0],\n           [0, 0, 0, 0, 0, 0, 0, 0],\n           [0, 0, 0, 0, 0, 0, 0, 0]], dtype=uint8)\n    >>> np.array_equal(b, np.unpackbits(p, axis=0, count=b.shape[0]))\n    True\n\n    "
    ...

def unravel_index(indices, shape, order=...) -> typing.Any:
    "    Converts a flat index or array of flat indices into a tuple\n    of coordinate arrays.\n\n    Parameters\n    ----------\n    indices : array_like\n        An integer array whose elements are indices into the flattened\n        version of an array of dimensions ``shape``. Before version 1.6.0,\n        this function accepted just one index value.\n    shape : tuple of ints\n        The shape of the array to use for unraveling ``indices``.\n\n        .. versionchanged:: 1.16.0\n            Renamed from ``dims`` to ``shape``.\n\n    order : {'C', 'F'}, optional\n        Determines whether the indices should be viewed as indexing in\n        row-major (C-style) or column-major (Fortran-style) order.\n\n        .. versionadded:: 1.6.0\n\n    Returns\n    -------\n    unraveled_coords : tuple of ndarray\n        Each array in the tuple has the same shape as the ``indices``\n        array.\n\n    See Also\n    --------\n    ravel_multi_index\n\n    Examples\n    --------\n    >>> np.unravel_index([22, 41, 37], (7,6))\n    (array([3, 6, 6]), array([4, 5, 1]))\n    >>> np.unravel_index([31, 41, 13], (7,6), order='F')\n    (array([3, 6, 6]), array([4, 5, 1]))\n\n    >>> np.unravel_index(1621, (6,7,8,9))\n    (3, 1, 4, 1)\n\n    "
    ...

def vdot(a, b) -> typing.Any:
    '    Return the dot product of two vectors.\n\n    The vdot(`a`, `b`) function handles complex numbers differently than\n    dot(`a`, `b`).  If the first argument is complex the complex conjugate\n    of the first argument is used for the calculation of the dot product.\n\n    Note that `vdot` handles multidimensional arrays differently than `dot`:\n    it does *not* perform a matrix product, but flattens input arguments\n    to 1-D vectors first. Consequently, it should only be used for vectors.\n\n    Parameters\n    ----------\n    a : array_like\n        If `a` is complex the complex conjugate is taken before calculation\n        of the dot product.\n    b : array_like\n        Second argument to the dot product.\n\n    Returns\n    -------\n    output : ndarray\n        Dot product of `a` and `b`.  Can be an int, float, or\n        complex depending on the types of `a` and `b`.\n\n    See Also\n    --------\n    dot : Return the dot product without using the complex conjugate of the\n          first argument.\n\n    Examples\n    --------\n    >>> a = np.array([1+2j,3+4j])\n    >>> b = np.array([5+6j,7+8j])\n    >>> np.vdot(a, b)\n    (70-8j)\n    >>> np.vdot(b, a)\n    (70+8j)\n\n    Note that higher-dimensional arrays are flattened!\n\n    >>> a = np.array([[1, 4], [5, 6]])\n    >>> b = np.array([[4, 1], [2, 2]])\n    >>> np.vdot(a, b)\n    30\n    >>> np.vdot(b, a)\n    30\n    >>> 1*4 + 4*1 + 5*2 + 6*2\n    30\n\n    '
    ...

def where(condition, x=..., y=...) -> typing.Any:
    '    Return elements chosen from `x` or `y` depending on `condition`.\n\n    .. note::\n        When only `condition` is provided, this function is a shorthand for\n        ``np.asarray(condition).nonzero()``. Using `nonzero` directly should be\n        preferred, as it behaves correctly for subclasses. The rest of this\n        documentation covers only the case where all three arguments are\n        provided.\n\n    Parameters\n    ----------\n    condition : array_like, bool\n        Where True, yield `x`, otherwise yield `y`.\n    x, y : array_like\n        Values from which to choose. `x`, `y` and `condition` need to be\n        broadcastable to some shape.\n\n    Returns\n    -------\n    out : ndarray\n        An array with elements from `x` where `condition` is True, and elements\n        from `y` elsewhere.\n\n    See Also\n    --------\n    choose\n    nonzero : The function that is called when x and y are omitted\n\n    Notes\n    -----\n    If all the arrays are 1-D, `where` is equivalent to::\n\n        [xv if c else yv\n         for c, xv, yv in zip(condition, x, y)]\n\n    Examples\n    --------\n    >>> a = np.arange(10)\n    >>> a\n    array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9])\n    >>> np.where(a < 5, a, 10*a)\n    array([ 0,  1,  2,  3,  4, 50, 60, 70, 80, 90])\n\n    This can be used on multidimensional arrays too:\n\n    >>> np.where([[True, False], [True, True]],\n    ...          [[1, 2], [3, 4]],\n    ...          [[9, 8], [7, 6]])\n    array([[1, 8],\n           [3, 4]])\n\n    The shapes of x, y, and the condition are broadcast together:\n\n    >>> x, y = np.ogrid[:3, :4]\n    >>> np.where(x < y, x, 10 + y)  # both x and 10+y are broadcast\n    array([[10,  0,  0,  0],\n           [10, 11,  1,  1],\n           [10, 11, 12,  2]])\n\n    >>> a = np.array([[0, 1, 2],\n    ...               [0, 2, 4],\n    ...               [0, 3, 6]])\n    >>> np.where(a < 4, a, -1)  # -1 is broadcast\n    array([[ 0,  1,  2],\n           [ 0,  2, -1],\n           [ 0,  3, -1]])\n    '
    ...

def zeros(shape, dtype=..., order=..., *, like=...) -> typing.Any:
    "    Return a new array of given shape and type, filled with zeros.\n\n    Parameters\n    ----------\n    shape : int or tuple of ints\n        Shape of the new array, e.g., ``(2, 3)`` or ``2``.\n    dtype : data-type, optional\n        The desired data-type for the array, e.g., `numpy.int8`.  Default is\n        `numpy.float64`.\n    order : {'C', 'F'}, optional, default: 'C'\n        Whether to store multi-dimensional data in row-major\n        (C-style) or column-major (Fortran-style) order in\n        memory.\n    like : array_like, optional\n        Reference object to allow the creation of arrays which are not\n        NumPy arrays. If an array-like passed in as ``like`` supports\n        the ``__array_function__`` protocol, the result will be defined\n        by it. In this case, it ensures the creation of an array object\n        compatible with that passed in via this argument.\n\n        .. versionadded:: 1.20.0\n\n    Returns\n    -------\n    out : ndarray\n        Array of zeros with the given shape, dtype, and order.\n\n    See Also\n    --------\n    zeros_like : Return an array of zeros with shape and type of input.\n    empty : Return a new uninitialized array.\n    ones : Return a new array setting values to one.\n    full : Return a new array of given shape filled with value.\n\n    Examples\n    --------\n    >>> np.zeros(5)\n    array([ 0.,  0.,  0.,  0.,  0.])\n\n    >>> np.zeros((5,), dtype=int)\n    array([0, 0, 0, 0, 0])\n\n    >>> np.zeros((2, 1))\n    array([[ 0.],\n           [ 0.]])\n\n    >>> s = (2,2)\n    >>> np.zeros(s)\n    array([[ 0.,  0.],\n           [ 0.,  0.]])\n\n    >>> np.zeros((2,), dtype=[('x', 'i4'), ('y', 'i4')]) # custom dtype\n    array([(0, 0), (0, 0)],\n          dtype=[('x', '<i4'), ('y', '<i4')])"
    ...

def __getattr__(name) -> typing.Any:
    ...

