
const Sharp = function (inputBuffer, options) {
	if (arguments.length === 1 && !is.defined(input)) {
		throw new Error('Invalid input');
	}
	if (!(this instanceof Sharp)) {
		return new Sharp(input, options);
	}
	this.inputBuffer = inputBuffer;
	return this;
};

Sharp.prototype.resize = function () {
	const that = this;
	const img = {
		toBuffer: () => that.inputBuffer,
		png: () => img,
		jpeg: () => img
	};
	return img;
};

module.exports = Sharp;
