/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/client/activation/activationManager.ts":
/*!****************************************************!*\
  !*** ./src/client/activation/activationManager.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExtensionActivationManager = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../common/application/types */ "./src/client/common/application/types.ts");
const constants_1 = __webpack_require__(/*! ../common/constants */ "./src/client/common/constants.ts");
const logging_1 = __webpack_require__(/*! ../logging */ "./src/client/logging/index.ts");
const types_2 = __webpack_require__(/*! ./types */ "./src/client/activation/types.ts");
let ExtensionActivationManager = class ExtensionActivationManager {
    constructor(activationServices, singleActivationServices, documentManager, workspaceService, activeResourceService) {
        this.activationServices = activationServices;
        this.singleActivationServices = singleActivationServices;
        this.documentManager = documentManager;
        this.workspaceService = workspaceService;
        this.activeResourceService = activeResourceService;
        this.activatedWorkspaces = new Set();
        this.isInterpreterSetForWorkspacePromises = new Map();
        this.disposables = [];
    }
    filterServices() {
        if (!this.workspaceService.isTrusted) {
            this.activationServices = this.activationServices.filter((service) => service.supportedWorkspaceTypes.untrustedWorkspace);
            this.singleActivationServices = this.singleActivationServices.filter((service) => service.supportedWorkspaceTypes.untrustedWorkspace);
        }
        if (this.workspaceService.isVirtualWorkspace) {
            this.activationServices = this.activationServices.filter((service) => service.supportedWorkspaceTypes.virtualWorkspace);
            this.singleActivationServices = this.singleActivationServices.filter((service) => service.supportedWorkspaceTypes.virtualWorkspace);
        }
    }
    dispose() {
        while (this.disposables.length > 0) {
            const disposable = this.disposables.shift();
            disposable.dispose();
        }
        if (this.docOpenedHandler) {
            this.docOpenedHandler.dispose();
            this.docOpenedHandler = undefined;
        }
    }
    async activate() {
        this.filterServices();
        await this.initialize();
        await Promise.all([
            ...this.singleActivationServices.map((item) => item.activate()),
            this.activateWorkspace(this.activeResourceService.getActiveResource()),
        ]);
    }
    async activateWorkspace(resource) {
        const key = this.getWorkspaceKey(resource);
        if (this.activatedWorkspaces.has(key)) {
            return;
        }
        this.activatedWorkspaces.add(key);
        await Promise.all(this.activationServices.map((item) => item.activate(resource)));
    }
    async initialize() {
        this.addHandlers();
        this.addRemoveDocOpenedHandlers();
    }
    onDocOpened(doc) {
        var _a;
        if (doc.languageId !== constants_1.PYTHON_LANGUAGE) {
            return;
        }
        const key = this.getWorkspaceKey(doc.uri);
        const hasWorkspaceFolders = (((_a = this.workspaceService.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) || 0) > 0;
        if (key === '' && hasWorkspaceFolders) {
            return;
        }
        if (this.activatedWorkspaces.has(key)) {
            return;
        }
        const folder = this.workspaceService.getWorkspaceFolder(doc.uri);
        this.activateWorkspace(folder ? folder.uri : undefined).ignoreErrors();
    }
    addHandlers() {
        this.disposables.push(this.workspaceService.onDidChangeWorkspaceFolders(this.onWorkspaceFoldersChanged, this));
    }
    addRemoveDocOpenedHandlers() {
        if (this.hasMultipleWorkspaces()) {
            if (!this.docOpenedHandler) {
                this.docOpenedHandler = this.documentManager.onDidOpenTextDocument(this.onDocOpened, this);
            }
            return;
        }
        if (this.docOpenedHandler) {
            this.docOpenedHandler.dispose();
            this.docOpenedHandler = undefined;
        }
    }
    onWorkspaceFoldersChanged() {
        const workspaceKeys = this.workspaceService.workspaceFolders.map((workspaceFolder) => this.getWorkspaceKey(workspaceFolder.uri));
        const activatedWkspcKeys = Array.from(this.activatedWorkspaces.keys());
        const activatedWkspcFoldersRemoved = activatedWkspcKeys.filter((item) => workspaceKeys.indexOf(item) < 0);
        if (activatedWkspcFoldersRemoved.length > 0) {
            for (const folder of activatedWkspcFoldersRemoved) {
                this.activatedWorkspaces.delete(folder);
            }
        }
        this.addRemoveDocOpenedHandlers();
    }
    hasMultipleWorkspaces() {
        var _a;
        return (((_a = this.workspaceService.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) || 0) > 1;
    }
    getWorkspaceKey(resource) {
        return this.workspaceService.getWorkspaceFolderIdentifier(resource, '');
    }
};
__decorate([
    (0, logging_1.traceDecoratorError)('Failed to activate a workspace')
], ExtensionActivationManager.prototype, "activateWorkspace", null);
ExtensionActivationManager = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.multiInject)(types_2.IExtensionActivationService)),
    __param(1, (0, inversify_1.multiInject)(types_2.IExtensionSingleActivationService)),
    __param(2, (0, inversify_1.inject)(types_1.IDocumentManager)),
    __param(3, (0, inversify_1.inject)(types_1.IWorkspaceService)),
    __param(4, (0, inversify_1.inject)(types_1.IActiveResourceService))
], ExtensionActivationManager);
exports.ExtensionActivationManager = ExtensionActivationManager;


/***/ }),

/***/ "./src/client/activation/serviceRegistry.ts":
/*!**************************************************!*\
  !*** ./src/client/activation/serviceRegistry.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const activationManager_1 = __webpack_require__(/*! ./activationManager */ "./src/client/activation/activationManager.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/activation/types.ts");
function registerTypes(serviceManager) {
    serviceManager.add(types_1.IExtensionActivationManager, activationManager_1.ExtensionActivationManager);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/client/activation/types.ts":
/*!****************************************!*\
  !*** ./src/client/activation/types.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IExtensionSingleActivationService = exports.IExtensionActivationService = exports.IExtensionActivationManager = void 0;
exports.IExtensionActivationManager = Symbol('IExtensionActivationManager');
exports.IExtensionActivationService = Symbol('IExtensionActivationService');
exports.IExtensionSingleActivationService = Symbol('IExtensionSingleActivationService');


/***/ }),

/***/ "./src/client/common/application/activeResource.ts":
/*!*********************************************************!*\
  !*** ./src/client/common/application/activeResource.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ActiveResourceService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/common/application/types.ts");
let ActiveResourceService = class ActiveResourceService {
    constructor(documentManager, workspaceService) {
        this.documentManager = documentManager;
        this.workspaceService = workspaceService;
    }
    getActiveResource() {
        const editor = this.documentManager.activeTextEditor;
        if (editor && !editor.document.isUntitled) {
            return editor.document.uri;
        }
        return Array.isArray(this.workspaceService.workspaceFolders) &&
            this.workspaceService.workspaceFolders.length > 0
            ? this.workspaceService.workspaceFolders[0].uri
            : undefined;
    }
};
ActiveResourceService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IDocumentManager)),
    __param(1, (0, inversify_1.inject)(types_1.IWorkspaceService))
], ActiveResourceService);
exports.ActiveResourceService = ActiveResourceService;


/***/ }),

/***/ "./src/client/common/application/applicationEnvironment.ts":
/*!*****************************************************************!*\
  !*** ./src/client/common/application/applicationEnvironment.ts ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApplicationEnvironment = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const semver_1 = __webpack_require__(/*! semver */ "./node_modules/semver/semver.js");
const vscode = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const types_2 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
let ApplicationEnvironment = class ApplicationEnvironment {
    constructor(platform, pathUtils, process) {
        this.platform = platform;
        this.pathUtils = pathUtils;
        this.process = process;
    }
    get userSettingsFile() {
        const vscodeFolderName = this.channel === 'insiders' ? 'Code - Insiders' : 'Code';
        switch (this.platform.osType) {
            case platform_1.OSType.OSX:
                return path.join(this.pathUtils.home, 'Library', 'Application Support', vscodeFolderName, 'User', 'settings.json');
            case platform_1.OSType.Linux:
                return path.join(this.pathUtils.home, '.config', vscodeFolderName, 'User', 'settings.json');
            case platform_1.OSType.Windows:
                return this.process.env.APPDATA
                    ? path.join(this.process.env.APPDATA, vscodeFolderName, 'User', 'settings.json')
                    : undefined;
            default:
                return;
        }
    }
    get appName() {
        return vscode.env.appName;
    }
    get vscodeVersion() {
        return vscode.version;
    }
    get appRoot() {
        return vscode.env.appRoot;
    }
    get uiKind() {
        return vscode.env.uiKind;
    }
    get language() {
        return vscode.env.language;
    }
    get sessionId() {
        return vscode.env.sessionId;
    }
    get machineId() {
        return vscode.env.machineId;
    }
    get remoteName() {
        return vscode.env.remoteName;
    }
    get extensionName() {
        return this.packageJson.displayName;
    }
    get shell() {
        return vscode.env.shell;
    }
    get onDidChangeShell() {
        try {
            return vscode.env.onDidChangeShell;
        }
        catch (ex) {
            (0, logging_1.traceError)('Failed to get onDidChangeShell API', ex);
            return new vscode.EventEmitter().event;
        }
    }
    get packageJson() {
        return __webpack_require__(/*! ../../../../package.json */ "./package.json");
    }
    get channel() {
        return this.appName.indexOf('Insider') > 0 ? 'insiders' : 'stable';
    }
    get extensionChannel() {
        const version = (0, semver_1.parse)(this.packageJson.version);
        return !version || version.prerelease.length > 0 || version.minor % 2 == 1 ? 'insiders' : 'stable';
    }
    get uriScheme() {
        return vscode.env.uriScheme;
    }
};
ApplicationEnvironment = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IPlatformService)),
    __param(1, (0, inversify_1.inject)(types_2.IPathUtils)),
    __param(2, (0, inversify_1.inject)(types_2.ICurrentProcess))
], ApplicationEnvironment);
exports.ApplicationEnvironment = ApplicationEnvironment;


/***/ }),

/***/ "./src/client/common/application/applicationShell.ts":
/*!***********************************************************!*\
  !*** ./src/client/common/application/applicationShell.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApplicationShell = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
let ApplicationShell = class ApplicationShell {
    get onDidChangeWindowState() {
        return vscode_1.window.onDidChangeWindowState;
    }
    showInformationMessage(message, options, ...items) {
        return vscode_1.window.showInformationMessage(message, options, ...items);
    }
    showWarningMessage(message, options, ...items) {
        return vscode_1.window.showWarningMessage(message, options, ...items);
    }
    showErrorMessage(message, options, ...items) {
        return vscode_1.window.showErrorMessage(message, options, ...items);
    }
    showQuickPick(items, options, token) {
        return vscode_1.window.showQuickPick(items, options, token);
    }
    showOpenDialog(options) {
        return vscode_1.window.showOpenDialog(options);
    }
    showSaveDialog(options) {
        return vscode_1.window.showSaveDialog(options);
    }
    showInputBox(options, token) {
        return vscode_1.window.showInputBox(options, token);
    }
    showTextDocument(document, column, preserveFocus) {
        return vscode_1.window.showTextDocument(document, column, preserveFocus);
    }
    openUrl(url) {
        vscode_1.env.openExternal(vscode_1.Uri.parse(url));
    }
    setStatusBarMessage(text, arg) {
        return vscode_1.window.setStatusBarMessage(text, arg);
    }
    createStatusBarItem(alignment, priority, id) {
        return id
            ? vscode_1.window.createStatusBarItem(id, alignment, priority)
            : vscode_1.window.createStatusBarItem(alignment, priority);
    }
    showWorkspaceFolderPick(options) {
        return vscode_1.window.showWorkspaceFolderPick(options);
    }
    withProgress(options, task) {
        return vscode_1.window.withProgress(options, task);
    }
    withProgressCustomIcon(icon, task) {
        const token = new vscode_1.CancellationTokenSource().token;
        const statusBarProgress = this.createStatusBarItem(vscode_1.StatusBarAlignment.Left);
        const progress = {
            report: (value) => {
                statusBarProgress.text = `${icon} ${value.message}`;
            },
        };
        statusBarProgress.show();
        return task(progress, token).then((result) => {
            statusBarProgress.dispose();
            return result;
        });
    }
    createQuickPick() {
        return vscode_1.window.createQuickPick();
    }
    createInputBox() {
        return vscode_1.window.createInputBox();
    }
    createTreeView(viewId, options) {
        return vscode_1.window.createTreeView(viewId, options);
    }
    createOutputChannel(name) {
        return vscode_1.window.createOutputChannel(name, { log: true });
    }
    createLanguageStatusItem(id, selector) {
        return vscode_1.languages.createLanguageStatusItem(id, selector);
    }
};
ApplicationShell = __decorate([
    (0, inversify_1.injectable)()
], ApplicationShell);
exports.ApplicationShell = ApplicationShell;


/***/ }),

/***/ "./src/client/common/application/commandManager.ts":
/*!*********************************************************!*\
  !*** ./src/client/common/application/commandManager.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandManager = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
let CommandManager = class CommandManager {
    registerCommand(command, callback, thisArg) {
        return vscode_1.commands.registerCommand(command, callback, thisArg);
    }
    registerTextEditorCommand(command, callback, thisArg) {
        return vscode_1.commands.registerTextEditorCommand(command, callback, thisArg);
    }
    executeCommand(command, ...rest) {
        return vscode_1.commands.executeCommand(command, ...rest);
    }
    getCommands(filterInternal) {
        return vscode_1.commands.getCommands(filterInternal);
    }
};
CommandManager = __decorate([
    (0, inversify_1.injectable)()
], CommandManager);
exports.CommandManager = CommandManager;


/***/ }),

/***/ "./src/client/common/application/documentManager.ts":
/*!**********************************************************!*\
  !*** ./src/client/common/application/documentManager.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentManager = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
let DocumentManager = class DocumentManager {
    get textDocuments() {
        return vscode_1.workspace.textDocuments;
    }
    get activeTextEditor() {
        return vscode_1.window.activeTextEditor;
    }
    get visibleTextEditors() {
        return vscode_1.window.visibleTextEditors;
    }
    get onDidChangeActiveTextEditor() {
        return vscode_1.window.onDidChangeActiveTextEditor;
    }
    get onDidChangeTextDocument() {
        return vscode_1.workspace.onDidChangeTextDocument;
    }
    get onDidChangeVisibleTextEditors() {
        return vscode_1.window.onDidChangeVisibleTextEditors;
    }
    get onDidChangeTextEditorSelection() {
        return vscode_1.window.onDidChangeTextEditorSelection;
    }
    get onDidChangeTextEditorOptions() {
        return vscode_1.window.onDidChangeTextEditorOptions;
    }
    get onDidChangeTextEditorViewColumn() {
        return vscode_1.window.onDidChangeTextEditorViewColumn;
    }
    get onDidOpenTextDocument() {
        return vscode_1.workspace.onDidOpenTextDocument;
    }
    get onDidCloseTextDocument() {
        return vscode_1.workspace.onDidCloseTextDocument;
    }
    get onDidSaveTextDocument() {
        return vscode_1.workspace.onDidSaveTextDocument;
    }
    showTextDocument(uri, options, preserveFocus) {
        return vscode_1.window.showTextDocument(uri, options, preserveFocus);
    }
    openTextDocument(arg) {
        return vscode_1.workspace.openTextDocument(arg);
    }
    applyEdit(edit) {
        return vscode_1.workspace.applyEdit(edit);
    }
    createTextEditorDecorationType(options) {
        return vscode_1.window.createTextEditorDecorationType(options);
    }
};
DocumentManager = __decorate([
    (0, inversify_1.injectable)()
], DocumentManager);
exports.DocumentManager = DocumentManager;


/***/ }),

/***/ "./src/client/common/application/terminalManager.ts":
/*!**********************************************************!*\
  !*** ./src/client/common/application/terminalManager.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalManager = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
let TerminalManager = class TerminalManager {
    constructor() {
        this.didOpenTerminal = new vscode_1.EventEmitter();
        vscode_1.window.onDidOpenTerminal((terminal) => {
            this.didOpenTerminal.fire(monkeyPatchTerminal(terminal));
        });
    }
    get onDidCloseTerminal() {
        return vscode_1.window.onDidCloseTerminal;
    }
    get onDidOpenTerminal() {
        return this.didOpenTerminal.event;
    }
    createTerminal(options) {
        return monkeyPatchTerminal(vscode_1.window.createTerminal(options));
    }
};
TerminalManager = __decorate([
    (0, inversify_1.injectable)()
], TerminalManager);
exports.TerminalManager = TerminalManager;
function monkeyPatchTerminal(terminal) {
    if (!terminal.isPatched) {
        const oldSendText = terminal.sendText.bind(terminal);
        terminal.sendText = (text, addNewLine = true) => {
            (0, logging_1.traceLog)(`Send text to terminal: ${text}`);
            return oldSendText(text, addNewLine);
        };
        terminal.isPatched = true;
    }
    return terminal;
}


/***/ }),

/***/ "./src/client/common/application/types.ts":
/*!************************************************!*\
  !*** ./src/client/common/application/types.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IActiveResourceService = exports.IApplicationEnvironment = exports.ITerminalManager = exports.IWorkspaceService = exports.IDocumentManager = exports.IJupyterExtensionDependencyManager = exports.ICommandManager = exports.IApplicationShell = void 0;
exports.IApplicationShell = Symbol('IApplicationShell');
exports.ICommandManager = Symbol('ICommandManager');
exports.IJupyterExtensionDependencyManager = Symbol('IJupyterExtensionDependencyManager');
exports.IDocumentManager = Symbol('IDocumentManager');
exports.IWorkspaceService = Symbol('IWorkspaceService');
exports.ITerminalManager = Symbol('ITerminalManager');
exports.IApplicationEnvironment = Symbol('IApplicationEnvironment');
exports.IActiveResourceService = Symbol('IActiveResourceService');


/***/ }),

/***/ "./src/client/common/application/workspace.ts":
/*!****************************************************!*\
  !*** ./src/client/common/application/workspace.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
let WorkspaceService = class WorkspaceService {
    get onDidChangeConfiguration() {
        return vscode_1.workspace.onDidChangeConfiguration;
    }
    get rootPath() {
        return Array.isArray(vscode_1.workspace.workspaceFolders) && vscode_1.workspace.workspaceFolders.length > 0
            ? vscode_1.workspace.workspaceFolders[0].uri.fsPath
            : undefined;
    }
    get workspaceFolders() {
        return vscode_1.workspace.workspaceFolders;
    }
    get onDidChangeWorkspaceFolders() {
        return vscode_1.workspace.onDidChangeWorkspaceFolders;
    }
    get workspaceFile() {
        return vscode_1.workspace.workspaceFile;
    }
    getConfiguration(section, resource, languageSpecific = false) {
        if (languageSpecific) {
            return vscode_1.workspace.getConfiguration(section, { uri: resource, languageId: 'python' });
        }
        else {
            return vscode_1.workspace.getConfiguration(section, resource);
        }
    }
    getWorkspaceFolder(uri) {
        return uri ? vscode_1.workspace.getWorkspaceFolder(uri) : undefined;
    }
    asRelativePath(pathOrUri, includeWorkspaceFolder) {
        return vscode_1.workspace.asRelativePath(pathOrUri, includeWorkspaceFolder);
    }
    createFileSystemWatcher(globPattern, ignoreCreateEvents, ignoreChangeEvents, ignoreDeleteEvents) {
        return vscode_1.workspace.createFileSystemWatcher(globPattern, ignoreCreateEvents, ignoreChangeEvents, ignoreDeleteEvents);
    }
    findFiles(include, exclude, maxResults, token) {
        const excludePattern = exclude === undefined ? this.searchExcludes : exclude;
        return vscode_1.workspace.findFiles(include, excludePattern, maxResults, token);
    }
    getWorkspaceFolderIdentifier(resource, defaultValue = '') {
        const workspaceFolder = resource ? vscode_1.workspace.getWorkspaceFolder(resource) : undefined;
        return workspaceFolder
            ? path.normalize((0, platform_1.getOSType)() === platform_1.OSType.Windows
                ? workspaceFolder.uri.fsPath.toUpperCase()
                : workspaceFolder.uri.fsPath)
            : defaultValue;
    }
    get isVirtualWorkspace() {
        const isVirtualWorkspace = vscode_1.workspace.workspaceFolders && vscode_1.workspace.workspaceFolders.every((f) => f.uri.scheme !== 'file');
        return !!isVirtualWorkspace;
    }
    get isTrusted() {
        return vscode_1.workspace.isTrusted;
    }
    get onDidGrantWorkspaceTrust() {
        return vscode_1.workspace.onDidGrantWorkspaceTrust;
    }
    openTextDocument(options) {
        return vscode_1.workspace.openTextDocument(options);
    }
    get searchExcludes() {
        const searchExcludes = this.getConfiguration('search.exclude');
        const enabledSearchExcludes = Object.keys(searchExcludes).filter((key) => searchExcludes.get(key) === true);
        return `{${enabledSearchExcludes.join(',')}}`;
    }
    async save(uri) {
        try {
            const result = await vscode_1.workspace.save(uri);
            return result;
        }
        catch (ex) {
            return undefined;
        }
    }
};
WorkspaceService = __decorate([
    (0, inversify_1.injectable)()
], WorkspaceService);
exports.WorkspaceService = WorkspaceService;


/***/ }),

/***/ "./src/client/common/cancellation.ts":
/*!*******************************************!*\
  !*** ./src/client/common/cancellation.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Cancellation = exports.wrapCancellationTokens = exports.createPromiseFromCancellation = exports.CancellationError = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const async_1 = __webpack_require__(/*! ./utils/async */ "./src/client/common/utils/async.ts");
const localize = __webpack_require__(/*! ./utils/localize */ "./src/client/common/utils/localize.ts");
class CancellationError extends Error {
    constructor() {
        super(localize.Common.canceled);
    }
}
exports.CancellationError = CancellationError;
function createPromiseFromCancellation(options) {
    return new Promise((resolve, reject) => {
        if (!options.token) {
            return;
        }
        const complete = () => {
            const optionsToken = options.token;
            if (optionsToken.isCancellationRequested) {
                if (options.cancelAction === 'resolve') {
                    return resolve(options.defaultValue);
                }
                if (options.cancelAction === 'reject') {
                    return reject(new CancellationError());
                }
            }
        };
        options.token.onCancellationRequested(complete);
    });
}
exports.createPromiseFromCancellation = createPromiseFromCancellation;
function wrapCancellationTokens(...tokens) {
    const wrappedCancellantionToken = new vscode_1.CancellationTokenSource();
    for (const token of tokens) {
        if (!token) {
            continue;
        }
        if (token.isCancellationRequested) {
            return token;
        }
        token.onCancellationRequested(() => wrappedCancellantionToken.cancel());
    }
    return wrappedCancellantionToken.token;
}
exports.wrapCancellationTokens = wrapCancellationTokens;
var Cancellation;
(function (Cancellation) {
    function race(work, token) {
        if (token) {
            const deferred = (0, async_1.createDeferred)();
            token.onCancellationRequested(() => {
                if (!deferred.completed) {
                    deferred.reject(new CancellationError());
                }
            });
            if (token.isCancellationRequested) {
                deferred.reject(new CancellationError());
            }
            else {
                work(token)
                    .then((v) => {
                    if (!deferred.completed) {
                        deferred.resolve(v);
                    }
                })
                    .catch((e) => {
                    if (!deferred.completed) {
                        deferred.reject(e);
                    }
                });
            }
            return deferred.promise;
        }
        else {
            return work();
        }
    }
    Cancellation.race = race;
    function isCanceled(cancelToken) {
        return cancelToken ? cancelToken.isCancellationRequested : false;
    }
    Cancellation.isCanceled = isCanceled;
    function throwIfCanceled(cancelToken) {
        if (isCanceled(cancelToken)) {
            throw new CancellationError();
        }
    }
    Cancellation.throwIfCanceled = throwIfCanceled;
})(Cancellation = exports.Cancellation || (exports.Cancellation = {}));


/***/ }),

/***/ "./src/client/common/configSettings.ts":
/*!*********************************************!*\
  !*** ./src/client/common/configSettings.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonSettings = void 0;
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
__webpack_require__(/*! ./extensions */ "./src/client/common/extensions.ts");
const workspace_1 = __webpack_require__(/*! ./application/workspace */ "./src/client/common/application/workspace.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/client/common/constants.ts");
const decorators_1 = __webpack_require__(/*! ./utils/decorators */ "./src/client/common/utils/decorators.ts");
const systemVariables_1 = __webpack_require__(/*! ./variables/systemVariables */ "./src/client/common/variables/systemVariables.ts");
const untildify = __webpack_require__(/*! untildify */ "./node_modules/untildify/index.js");
class PythonSettings {
    constructor(api, workspaceFolder, workspace) {
        this.api = api;
        this.envFile = '';
        this.venvPath = '';
        this.venvFolders = [];
        this.activeStateToolPath = '';
        this.condaPath = '';
        this.pipenvPath = '';
        this.poetryPath = '';
        this.devOptions = [];
        this.disableInstallationChecks = false;
        this.globalModuleInstallation = false;
        this.autoUpdateLanguageServer = true;
        this.languageServerIsDefault = true;
        this.changed = new vscode_1.EventEmitter();
        this.disposables = [];
        this._defaultInterpreterPath = '';
        this.workspace = workspace || new workspace_1.WorkspaceService();
        this.workspaceRoot = workspaceFolder;
        this.initialize();
    }
    static onConfigChange() {
        return PythonSettings.configChanged.event;
    }
    get pythonPath() {
        try {
            return this.api.environments.getActiveEnvironmentPath(this.workspaceRoot).path;
        }
        catch (_a) {
            return 'python';
        }
    }
    get defaultInterpreterPath() {
        return this._defaultInterpreterPath;
    }
    set defaultInterpreterPath(value) {
        if (this._defaultInterpreterPath === value) {
            return;
        }
        try {
            this._defaultInterpreterPath = this.api.environments.getActiveEnvironmentPath().path;
        }
        catch (ex) {
            this._defaultInterpreterPath = value;
        }
    }
    static getInstance(api, resource, workspace) {
        workspace = workspace || new workspace_1.WorkspaceService();
        const workspaceFolderUri = PythonSettings.getSettingsUriAndTarget(resource, workspace).uri;
        const workspaceFolderKey = workspaceFolderUri ? workspaceFolderUri.fsPath : '';
        if (!PythonSettings.pythonSettings.has(workspaceFolderKey)) {
            const settings = new PythonSettings(api, workspaceFolderUri, workspace);
            PythonSettings.pythonSettings.set(workspaceFolderKey, settings);
        }
        return PythonSettings.pythonSettings.get(workspaceFolderKey);
    }
    static debounceConfigChangeNotification(event) {
        PythonSettings.configChanged.fire(event);
    }
    static getSettingsUriAndTarget(resource, workspace) {
        workspace = workspace || new workspace_1.WorkspaceService();
        const workspaceFolder = resource ? workspace.getWorkspaceFolder(resource) : undefined;
        let workspaceFolderUri = workspaceFolder ? workspaceFolder.uri : undefined;
        if (!workspaceFolderUri && Array.isArray(workspace.workspaceFolders) && workspace.workspaceFolders.length > 0) {
            workspaceFolderUri = workspace.workspaceFolders[0].uri;
        }
        const target = workspaceFolderUri ? vscode_1.ConfigurationTarget.WorkspaceFolder : vscode_1.ConfigurationTarget.Global;
        return { uri: workspaceFolderUri, target };
    }
    static dispose() {
        if (!(0, constants_1.isTestExecution)()) {
            throw new Error('Dispose can only be called from unit tests');
        }
        PythonSettings.pythonSettings.forEach((item) => item && item.dispose());
        PythonSettings.pythonSettings.clear();
    }
    static toSerializable(settings) {
        const clone = {};
        const keys = Object.entries(settings);
        keys.forEach((e) => {
            const [k, v] = e;
            if (!k.includes('Manager') && !k.includes('Service') && !k.includes('onDid')) {
                clone[k] = v;
            }
        });
        return clone;
    }
    dispose() {
        this.disposables.forEach((disposable) => disposable && disposable.dispose());
        this.disposables = [];
    }
    update(pythonSettings) {
        var _a;
        const workspaceRoot = (_a = this.workspaceRoot) === null || _a === void 0 ? void 0 : _a.fsPath;
        const systemVariables = new systemVariables_1.SystemVariables(undefined, workspaceRoot, this.workspace);
        const defaultInterpreterPath = systemVariables.resolveAny(pythonSettings.get('defaultInterpreterPath'));
        this.defaultInterpreterPath = defaultInterpreterPath || constants_1.DEFAULT_INTERPRETER_SETTING;
        this.venvPath = systemVariables.resolveAny(pythonSettings.get('venvPath'));
        this.venvFolders = systemVariables.resolveAny(pythonSettings.get('venvFolders'));
        const activeStateToolPath = systemVariables.resolveAny(pythonSettings.get('activeStateToolPath'));
        this.activeStateToolPath =
            activeStateToolPath && activeStateToolPath.length > 0
                ? getAbsolutePath(activeStateToolPath, workspaceRoot)
                : activeStateToolPath;
        const condaPath = systemVariables.resolveAny(pythonSettings.get('condaPath'));
        this.condaPath = condaPath && condaPath.length > 0 ? getAbsolutePath(condaPath, workspaceRoot) : condaPath;
        const pipenvPath = systemVariables.resolveAny(pythonSettings.get('pipenvPath'));
        this.pipenvPath = pipenvPath && pipenvPath.length > 0 ? getAbsolutePath(pipenvPath, workspaceRoot) : pipenvPath;
        const poetryPath = systemVariables.resolveAny(pythonSettings.get('poetryPath'));
        this.poetryPath = poetryPath && poetryPath.length > 0 ? getAbsolutePath(poetryPath, workspaceRoot) : poetryPath;
        this.autoUpdateLanguageServer = systemVariables.resolveAny(pythonSettings.get('autoUpdateLanguageServer', true));
        const envFileSetting = pythonSettings.get('envFile');
        this.envFile = systemVariables.resolveAny(envFileSetting);
        this.devOptions = systemVariables.resolveAny(pythonSettings.get('devOptions'));
        this.devOptions = Array.isArray(this.devOptions) ? this.devOptions : [];
        this.disableInstallationChecks = pythonSettings.get('disableInstallationCheck') === true;
        this.globalModuleInstallation = pythonSettings.get('globalModuleInstallation') === true;
        const terminalSettings = systemVariables.resolveAny(pythonSettings.get('terminal'));
        if (this.terminal) {
            Object.assign(this.terminal, terminalSettings);
        }
        else {
            this.terminal = terminalSettings;
            if ((0, constants_1.isTestExecution)() && !this.terminal) {
                this.terminal = {};
            }
        }
    }
    onWorkspaceFoldersChanged() {
        const workspaceKeys = this.workspace.workspaceFolders.map((workspaceFolder) => workspaceFolder.uri.fsPath);
        const activatedWkspcKeys = Array.from(PythonSettings.pythonSettings.keys());
        const activatedWkspcFoldersRemoved = activatedWkspcKeys.filter((item) => workspaceKeys.indexOf(item) < 0);
        if (activatedWkspcFoldersRemoved.length > 0) {
            for (const folder of activatedWkspcFoldersRemoved) {
                PythonSettings.pythonSettings.delete(folder);
            }
        }
    }
    register() {
        PythonSettings.pythonSettings = new Map();
        this.initialize();
    }
    onDidChanged(event) {
        const currentConfig = this.workspace.getConfiguration('python', this.workspaceRoot);
        this.update(currentConfig);
        this.debounceChangeNotification(event);
    }
    initialize() {
        this.disposables.push(this.workspace.onDidChangeWorkspaceFolders(this.onWorkspaceFoldersChanged, this));
        this.disposables.push(this.workspace.onDidChangeConfiguration((event) => {
            if (event.affectsConfiguration('python')) {
                this.onDidChanged(event);
            }
        }));
        const initialConfig = this.workspace.getConfiguration('python', this.workspaceRoot);
        if (initialConfig) {
            this.update(initialConfig);
        }
    }
    debounceChangeNotification(event) {
        this.changed.fire(event);
    }
}
PythonSettings.pythonSettings = new Map();
PythonSettings.configChanged = new vscode_1.EventEmitter();
__decorate([
    (0, decorators_1.debounceSync)(1)
], PythonSettings.prototype, "debounceChangeNotification", null);
__decorate([
    (0, decorators_1.debounceSync)(1)
], PythonSettings, "debounceConfigChangeNotification", null);
exports.PythonSettings = PythonSettings;
function getAbsolutePath(pathToCheck, rootDir) {
    if (!rootDir) {
        rootDir = __dirname;
    }
    pathToCheck = untildify(pathToCheck);
    if ((0, constants_1.isTestExecution)() && !pathToCheck) {
        return rootDir;
    }
    if (pathToCheck.indexOf(path.sep) === -1) {
        return pathToCheck;
    }
    return path.isAbsolute(pathToCheck) ? pathToCheck : path.resolve(rootDir, pathToCheck);
}


/***/ }),

/***/ "./src/client/common/configuration/executionSettings/pipEnvExecution.ts":
/*!******************************************************************************!*\
  !*** ./src/client/common/configuration/executionSettings/pipEnvExecution.ts ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PipEnvExecutionPath = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../../types */ "./src/client/common/types.ts");
let PipEnvExecutionPath = class PipEnvExecutionPath {
    constructor(configService) {
        this.configService = configService;
    }
    get executable() {
        return this.configService.getSettings().pipenvPath;
    }
};
PipEnvExecutionPath = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IConfigurationService))
], PipEnvExecutionPath);
exports.PipEnvExecutionPath = PipEnvExecutionPath;


/***/ }),

/***/ "./src/client/common/configuration/service.ts":
/*!****************************************************!*\
  !*** ./src/client/common/configuration/service.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConfigurationService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../../ioc/types */ "./src/client/ioc/types.ts");
const types_2 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
const configSettings_1 = __webpack_require__(/*! ../configSettings */ "./src/client/common/configSettings.ts");
let ConfigurationService = class ConfigurationService {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
        this.workspaceService = this.serviceContainer.get(types_2.IWorkspaceService);
    }
    initialize(api) {
        this.api = api;
    }
    get onDidChange() {
        return configSettings_1.PythonSettings.onConfigChange();
    }
    getSettings(resource) {
        return configSettings_1.PythonSettings.getInstance(this.api, resource, this.workspaceService);
    }
};
ConfigurationService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer))
], ConfigurationService);
exports.ConfigurationService = ConfigurationService;


/***/ }),

/***/ "./src/client/common/constants.ts":
/*!****************************************!*\
  !*** ./src/client/common/constants.ts ***!
  \****************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UseProposedApi = exports.isUnitTestExecution = exports.isTestExecution = exports.isCI = exports.DEFAULT_INTERPRETER_SETTING = exports.ThemeIcons = exports.Octicons = exports.Commands = exports.CommandSource = exports.AppinsightsKey = exports.JUPYTER_EXTENSION_ID = exports.PYLANCE_EXTENSION_ID = exports.PVSC_EXTENSION_ID = exports.PYTHON_NOTEBOOKS = exports.PYTHON = exports.InteractiveScheme = exports.InteractiveInputScheme = exports.NotebookCellScheme = exports.PYTHON_WARNINGS = exports.PYTHON_LANGUAGE = void 0;
exports.PYTHON_LANGUAGE = 'python';
exports.PYTHON_WARNINGS = 'PYTHONWARNINGS';
exports.NotebookCellScheme = 'vscode-notebook-cell';
exports.InteractiveInputScheme = 'vscode-interactive-input';
exports.InteractiveScheme = 'vscode-interactive';
exports.PYTHON = [
    { scheme: 'file', language: exports.PYTHON_LANGUAGE },
    { scheme: 'untitled', language: exports.PYTHON_LANGUAGE },
    { scheme: 'vscode-notebook', language: exports.PYTHON_LANGUAGE },
    { scheme: exports.NotebookCellScheme, language: exports.PYTHON_LANGUAGE },
    { scheme: exports.InteractiveInputScheme, language: exports.PYTHON_LANGUAGE },
];
exports.PYTHON_NOTEBOOKS = [
    { scheme: 'vscode-notebook', language: exports.PYTHON_LANGUAGE },
    { scheme: exports.NotebookCellScheme, language: exports.PYTHON_LANGUAGE },
    { scheme: exports.InteractiveInputScheme, language: exports.PYTHON_LANGUAGE },
];
exports.PVSC_EXTENSION_ID = 'ms-python.python';
exports.PYLANCE_EXTENSION_ID = 'ms-python.vscode-pylance';
exports.JUPYTER_EXTENSION_ID = 'ms-toolsai.jupyter';
exports.AppinsightsKey = '0c6ae279ed8443289764825290e4f9e2-1a736e7c-1324-4338-be46-fc2a58ae4d14-7255';
var CommandSource;
(function (CommandSource) {
    CommandSource["ui"] = "ui";
    CommandSource["commandPalette"] = "commandpalette";
})(CommandSource = exports.CommandSource || (exports.CommandSource = {}));
var Commands;
(function (Commands) {
    Commands.ClearStorage = 'python.envManager.clearPersistentStorage';
    Commands.CreateNewFile = 'python.createNewFile';
    Commands.ClearWorkspaceInterpreter = 'python.clearWorkspaceInterpreter';
    Commands.Create_Environment = 'python.envManager.createEnvironment';
    Commands.Create_Environment_Button = 'python.envManager.createEnvironment-button';
    Commands.Create_Terminal = 'python.createTerminal';
    Commands.Debug_In_Terminal = 'python.debugInTerminal';
    Commands.Enable_Linter = 'python.enableLinting';
    Commands.Enable_SourceMap_Support = 'python.enableSourceMapSupport';
    Commands.Exec_In_Terminal = 'python.execInTerminal';
    Commands.Exec_In_Terminal_Icon = 'python.execInTerminal-icon';
    Commands.Exec_In_Separate_Terminal = 'python.execInDedicatedTerminal';
    Commands.Exec_Selection_In_Django_Shell = 'python.execSelectionInDjangoShell';
    Commands.Exec_Selection_In_Terminal = 'python.execSelectionInTerminal';
    Commands.GetSelectedInterpreterPath = 'python.interpreterPath';
    Commands.InstallJupyter = 'python.installJupyter';
    Commands.InstallPython = 'python.installPython';
    Commands.InstallPythonOnLinux = 'python.installPythonOnLinux';
    Commands.InstallPythonOnMac = 'python.installPythonOnMac';
    Commands.LaunchTensorBoard = 'python.launchTensorBoard';
    Commands.PickLocalProcess = 'python.pickLocalProcess';
    Commands.RefreshTensorBoard = 'python.refreshTensorBoard';
    Commands.ReportIssue = 'python.reportIssue';
    Commands.Run_Linter = 'python.runLinting';
    Commands.Set_Interpreter = 'python.setInterpreter';
    Commands.Set_Linter = 'python.setLinter';
    Commands.Set_ShebangInterpreter = 'python.setShebangInterpreter';
    Commands.Sort_Imports = 'python.sortImports';
    Commands.Start_REPL = 'python.startREPL';
    Commands.Tests_Configure = 'python.configureTests';
    Commands.TriggerEnvironmentSelection = 'python.triggerEnvSelection';
    Commands.ViewOutput = 'python.viewOutput';
})(Commands = exports.Commands || (exports.Commands = {}));
var Octicons;
(function (Octicons) {
    Octicons.Add = '$(add)';
    Octicons.Test_Pass = '$(check)';
    Octicons.Test_Fail = '$(alert)';
    Octicons.Test_Error = '$(x)';
    Octicons.Test_Skip = '$(circle-slash)';
    Octicons.Downloading = '$(cloud-download)';
    Octicons.Installing = '$(desktop-download)';
    Octicons.Search_Stop = '$(search-stop)';
    Octicons.Star = '$(star-full)';
    Octicons.Gear = '$(gear)';
    Octicons.Warning = '$(warning)';
    Octicons.Error = '$(error)';
    Octicons.Lightbulb = '$(lightbulb)';
})(Octicons = exports.Octicons || (exports.Octicons = {}));
var ThemeIcons;
(function (ThemeIcons) {
    ThemeIcons.Refresh = 'refresh';
    ThemeIcons.SpinningLoader = 'loading~spin';
})(ThemeIcons = exports.ThemeIcons || (exports.ThemeIcons = {}));
exports.DEFAULT_INTERPRETER_SETTING = 'python';
exports.isCI = process.env.TRAVIS === 'true' || process.env.TF_BUILD !== undefined;
function isTestExecution() {
    return process.env.VSC_PYTHON_CI_TEST === '1' || isUnitTestExecution();
}
exports.isTestExecution = isTestExecution;
function isUnitTestExecution() {
    return process.env.VSC_PYTHON_UNIT_TEST === '1';
}
exports.isUnitTestExecution = isUnitTestExecution;
exports.UseProposedApi = Symbol('USE_VSC_PROPOSED_API');
__exportStar(__webpack_require__(/*! ../constants */ "./src/client/constants.ts"), exports);


/***/ }),

/***/ "./src/client/common/editor.ts":
/*!*************************************!*\
  !*** ./src/client/common/editor.ts ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditorUtils = exports.getTempFileWithDocumentContents = exports.getWorkspaceEditsFromPatch = exports.getTextEditsFromPatch = void 0;
const diff_match_patch_1 = __webpack_require__(/*! ./node_modules/diff-match-patch */ "./node_modules/diff-match-patch");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const md5 = __webpack_require__(/*! md5 */ "./node_modules/md5/md5.js");
const os_1 = __webpack_require__(/*! os */ "os");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../logging */ "./src/client/logging/index.ts");
const errorUtils_1 = __webpack_require__(/*! ./errors/errorUtils */ "./src/client/common/errors/errorUtils.ts");
const misc_1 = __webpack_require__(/*! ./utils/misc */ "./src/client/common/utils/misc.ts");
var EditAction;
(function (EditAction) {
    EditAction[EditAction["Delete"] = 0] = "Delete";
    EditAction[EditAction["Insert"] = 1] = "Insert";
    EditAction[EditAction["Replace"] = 2] = "Replace";
})(EditAction || (EditAction = {}));
const NEW_LINE_LENGTH = os_1.EOL.length;
class Patch {
}
class Edit {
    constructor(action, start) {
        this.action = action;
        this.start = start;
        this.text = '';
    }
    apply() {
        switch (this.action) {
            case EditAction.Insert:
                return vscode_1.TextEdit.insert(this.start, this.text);
            case EditAction.Delete:
                return vscode_1.TextEdit.delete(new vscode_1.Range(this.start, this.end));
            case EditAction.Replace:
                return vscode_1.TextEdit.replace(new vscode_1.Range(this.start, this.end), this.text);
            default:
                return new vscode_1.TextEdit(new vscode_1.Range(new vscode_1.Position(0, 0), new vscode_1.Position(0, 0)), '');
        }
    }
}
function getTextEditsFromPatch(before, patch) {
    if (patch.startsWith('---')) {
        patch = patch.substring(patch.indexOf('@@'));
    }
    if (patch.length === 0) {
        return [];
    }
    patch = patch.replace(/\\ No newline at end of file[\r\n]/, '');
    const dmp = __webpack_require__(/*! ./node_modules/diff-match-patch */ "./node_modules/diff-match-patch");
    const d = new dmp.diff_match_patch();
    const patches = patch_fromText.call(d, patch);
    if (!Array.isArray(patches) || patches.length === 0) {
        throw new Error('Unable to parse Patch string');
    }
    const textEdits = [];
    patches.forEach((p) => {
        p.diffs.forEach((diff) => {
            diff[1] += os_1.EOL;
        });
        getTextEditsInternal(before, p.diffs, p.start1).forEach((edit) => textEdits.push(edit.apply()));
    });
    return textEdits;
}
exports.getTextEditsFromPatch = getTextEditsFromPatch;
function getWorkspaceEditsFromPatch(filePatches, workspaceRoot, fs) {
    const workspaceEdit = new vscode_1.WorkspaceEdit();
    filePatches.forEach((patch) => {
        const indexOfAtAt = patch.indexOf('@@');
        if (indexOfAtAt === -1) {
            return;
        }
        const fileNameLines = patch
            .substring(0, indexOfAtAt)
            .split(/\r?\n/g)
            .map((line) => line.trim())
            .filter((line) => line.length > 0 && line.toLowerCase().endsWith('.py') && line.indexOf(' a') > 0);
        if (patch.startsWith('---')) {
            patch = patch.substring(indexOfAtAt);
        }
        if (patch.length === 0) {
            return;
        }
        if (fileNameLines.length === 0) {
            return;
        }
        let fileName = fileNameLines[0].substring(fileNameLines[0].indexOf(' a') + 3).trim();
        fileName = workspaceRoot && !path.isAbsolute(fileName) ? path.resolve(workspaceRoot, fileName) : fileName;
        if (!fs.fileExistsSync(fileName)) {
            return;
        }
        patch = patch.replace(/\\ No newline at end of file[\r\n]/, '');
        const dmp = __webpack_require__(/*! ./node_modules/diff-match-patch */ "./node_modules/diff-match-patch");
        const d = new dmp.diff_match_patch();
        const patches = patch_fromText.call(d, patch);
        if (!Array.isArray(patches) || patches.length === 0) {
            throw new Error('Unable to parse Patch string');
        }
        const fileSource = fs.readFileSync(fileName);
        const fileUri = vscode_1.Uri.file(fileName);
        patches.forEach((p) => {
            p.diffs.forEach((diff) => {
                diff[1] += os_1.EOL;
            });
            getTextEditsInternal(fileSource, p.diffs, p.start1).forEach((edit) => {
                switch (edit.action) {
                    case EditAction.Delete:
                        workspaceEdit.delete(fileUri, new vscode_1.Range(edit.start, edit.end));
                        break;
                    case EditAction.Insert:
                        workspaceEdit.insert(fileUri, edit.start, edit.text);
                        break;
                    case EditAction.Replace:
                        workspaceEdit.replace(fileUri, new vscode_1.Range(edit.start, edit.end), edit.text);
                        break;
                    default:
                        break;
                }
            });
        });
    });
    return workspaceEdit;
}
exports.getWorkspaceEditsFromPatch = getWorkspaceEditsFromPatch;
function getTextEditsInternal(before, diffs, startLine = 0) {
    let line = startLine;
    let character = 0;
    const beforeLines = before.split(/\r?\n/g);
    if (line > 0) {
        beforeLines.filter((_l, i) => i < line).forEach((l) => (character += l.length + NEW_LINE_LENGTH));
    }
    const edits = [];
    let edit = null;
    let end;
    for (let i = 0; i < diffs.length; i += 1) {
        let start = new vscode_1.Position(line, character);
        for (let curr = 0; curr < diffs[i][1].length; curr += 1) {
            if (diffs[i][1][curr] !== '\n') {
                character += 1;
            }
            else {
                character = 0;
                line += 1;
            }
        }
        const dmp = __webpack_require__(/*! ./node_modules/diff-match-patch */ "./node_modules/diff-match-patch");
        switch (diffs[i][0]) {
            case dmp.DIFF_DELETE:
                if (beforeLines[line - 1].length === 0 &&
                    beforeLines[start.line - 1] &&
                    beforeLines[start.line - 1].length === 0) {
                    start = new vscode_1.Position(start.line - 1, 0);
                    end = new vscode_1.Position(line - 1, 0);
                }
                else {
                    end = new vscode_1.Position(line, character);
                }
                if (edit === null) {
                    edit = new Edit(EditAction.Delete, start);
                }
                else if (edit.action !== EditAction.Delete) {
                    throw new Error('cannot format due to an internal error.');
                }
                edit.end = end;
                break;
            case dmp.DIFF_INSERT:
                if (edit === null) {
                    edit = new Edit(EditAction.Insert, start);
                }
                else if (edit.action === EditAction.Delete) {
                    edit.action = EditAction.Replace;
                }
                line = start.line;
                character = start.character;
                edit.text += diffs[i][1];
                break;
            case dmp.DIFF_EQUAL:
                if (edit !== null) {
                    edits.push(edit);
                    edit = null;
                }
                break;
        }
    }
    if (edit !== null) {
        edits.push(edit);
    }
    return edits;
}
async function getTempFileWithDocumentContents(document, fs) {
    let fileName = `${document.uri.fsPath}.${md5(document.uri.fsPath + document.uri.fragment)}.tmp`;
    try {
        if ((0, misc_1.isNotebookCell)(document.uri) && !(await fs.fileExists(document.uri.fsPath))) {
            fileName = (await fs.createTemporaryFile(`${path.basename(document.uri.fsPath)}-${document.uri.fragment}.tmp`)).filePath;
        }
        await fs.writeFile(fileName, document.getText());
    }
    catch (ex) {
        (0, logging_1.traceError)('Failed to create a temporary file', ex);
        const exception = ex;
        throw new errorUtils_1.WrappedError(`Failed to create a temporary file, ${exception.message}`, exception);
    }
    return fileName;
}
exports.getTempFileWithDocumentContents = getTempFileWithDocumentContents;
function patch_fromText(textline) {
    const patches = [];
    if (!textline) {
        return patches;
    }
    const text = textline.split(/[\r\n]/);
    let textPointer = 0;
    const patchHeader = /^@@ -(\d+),?(\d*) \+(\d+),?(\d*) @@$/;
    while (textPointer < text.length) {
        const m = text[textPointer].match(patchHeader);
        if (!m) {
            throw new Error(`Invalid patch string: ${text[textPointer]}`);
        }
        const patch = new diff_match_patch_1.diff_match_patch.patch_obj();
        patches.push(patch);
        patch.start1 = parseInt(m[1], 10);
        if (m[2] === '') {
            patch.start1 -= 1;
            patch.length1 = 1;
        }
        else if (m[2] === '0') {
            patch.length1 = 0;
        }
        else {
            patch.start1 -= 1;
            patch.length1 = parseInt(m[2], 10);
        }
        patch.start2 = parseInt(m[3], 10);
        if (m[4] === '') {
            patch.start2 -= 1;
            patch.length2 = 1;
        }
        else if (m[4] === '0') {
            patch.length2 = 0;
        }
        else {
            patch.start2 -= 1;
            patch.length2 = parseInt(m[4], 10);
        }
        textPointer += 1;
        const dmp = __webpack_require__(/*! ./node_modules/diff-match-patch */ "./node_modules/diff-match-patch");
        while (textPointer < text.length) {
            const sign = text[textPointer].charAt(0);
            let line;
            try {
                line = text[textPointer].substring(1);
            }
            catch (ex) {
                throw new Error('Illegal escape in patch_fromText');
            }
            if (sign === '-') {
                patch.diffs.push([dmp.DIFF_DELETE, line]);
            }
            else if (sign === '+') {
                patch.diffs.push([dmp.DIFF_INSERT, line]);
            }
            else if (sign === ' ') {
                patch.diffs.push([dmp.DIFF_EQUAL, line]);
            }
            else if (sign === '@') {
                break;
            }
            else if (sign === '') {
            }
            else {
                throw new Error(`Invalid patch mode '${sign}' in: ${line}`);
            }
            textPointer += 1;
        }
    }
    return patches;
}
let EditorUtils = class EditorUtils {
    getWorkspaceEditsFromPatch(originalContents, patch, uri) {
        const workspaceEdit = new vscode_1.WorkspaceEdit();
        if (patch.startsWith('---')) {
            patch = patch.substring(patch.indexOf('@@'));
        }
        if (patch.length === 0) {
            return workspaceEdit;
        }
        patch = patch.replace(/\\ No newline at end of file[\r\n]/, '');
        const dmp = __webpack_require__(/*! ./node_modules/diff-match-patch */ "./node_modules/diff-match-patch");
        const d = new dmp.diff_match_patch();
        const patches = patch_fromText.call(d, patch);
        if (!Array.isArray(patches) || patches.length === 0) {
            throw new Error('Unable to parse Patch string');
        }
        patches.forEach((p) => {
            p.diffs.forEach((diff) => {
                diff[1] += os_1.EOL;
            });
            getTextEditsInternal(originalContents, p.diffs, p.start1).forEach((edit) => {
                switch (edit.action) {
                    case EditAction.Delete:
                        workspaceEdit.delete(uri, new vscode_1.Range(edit.start, edit.end));
                        break;
                    case EditAction.Insert:
                        workspaceEdit.insert(uri, edit.start, edit.text);
                        break;
                    case EditAction.Replace:
                        workspaceEdit.replace(uri, new vscode_1.Range(edit.start, edit.end), edit.text);
                        break;
                    default:
                        break;
                }
            });
        });
        return workspaceEdit;
    }
};
EditorUtils = __decorate([
    (0, inversify_1.injectable)()
], EditorUtils);
exports.EditorUtils = EditorUtils;


/***/ }),

/***/ "./src/client/common/errors/errorUtils.ts":
/*!************************************************!*\
  !*** ./src/client/common/errors/errorUtils.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WrappedError = exports.ErrorUtils = void 0;
const os_1 = __webpack_require__(/*! os */ "os");
class ErrorUtils {
    static outputHasModuleNotInstalledError(moduleName, content) {
        return content &&
            (content.indexOf(`No module named ${moduleName}`) > 0 ||
                content.indexOf(`No module named '${moduleName}'`) > 0)
            ? true
            : false;
    }
}
exports.ErrorUtils = ErrorUtils;
class WrappedError extends Error {
    constructor(message, originalException) {
        super(message);
        this.stack = `${new Error('').stack}${os_1.EOL}${os_1.EOL}${originalException.stack}`;
    }
}
exports.WrappedError = WrappedError;


/***/ }),

/***/ "./src/client/common/errors/moduleNotInstalledError.ts":
/*!*************************************************************!*\
  !*** ./src/client/common/errors/moduleNotInstalledError.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModuleNotInstalledError = void 0;
class ModuleNotInstalledError extends Error {
    constructor(moduleName) {
        super(`Module '${moduleName}' not installed.`);
    }
}
exports.ModuleNotInstalledError = ModuleNotInstalledError;


/***/ }),

/***/ "./src/client/common/extensions.ts":
/*!*****************************************!*\
  !*** ./src/client/common/extensions.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.format = exports.trimQuotes = void 0;
String.prototype.toCommandArgumentForPythonMgrExt = function () {
    if (!this) {
        return this;
    }
    return (this.indexOf(' ') >= 0 || this.indexOf('&') >= 0 || this.indexOf('(') >= 0 || this.indexOf(')') >= 0) &&
        !this.startsWith('"') &&
        !this.endsWith('"')
        ? `"${this}"`
        : this.toString();
};
String.prototype.fileToCommandArgumentForPythonMgrExt = function () {
    if (!this) {
        return this;
    }
    return this.toCommandArgumentForPythonMgrExt().replace(/\\/g, '/');
};
function trimQuotes(value) {
    if (!value) {
        return value;
    }
    return value.replace(/(^['"])|(['"]$)/g, '');
}
exports.trimQuotes = trimQuotes;
;
Promise.prototype.ignoreErrors = function () {
    return this.catch(() => { });
};
function format(value) {
    const args = arguments;
    return value.replace(/{(\d+)}/g, (match, number) => (args[number] === undefined ? match : args[number]));
}
exports.format = format;
;


/***/ }),

/***/ "./src/client/common/persistentState.ts":
/*!**********************************************!*\
  !*** ./src/client/common/persistentState.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getGlobalStorage = exports.PersistentStateFactory = exports.WORKSPACE_PERSISTENT_KEYS_DEPRECATED = exports.GLOBAL_PERSISTENT_KEYS_DEPRECATED = exports.PersistentState = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ./application/types */ "./src/client/common/application/types.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/client/common/constants.ts");
const types_2 = __webpack_require__(/*! ./types */ "./src/client/common/types.ts");
const decorators_1 = __webpack_require__(/*! ./utils/decorators */ "./src/client/common/utils/decorators.ts");
class PersistentState {
    constructor(storage, key, defaultValue, expiryDurationMs) {
        this.storage = storage;
        this.key = key;
        this.defaultValue = defaultValue;
        this.expiryDurationMs = expiryDurationMs;
    }
    get value() {
        if (this.expiryDurationMs) {
            const cachedData = this.storage.get(this.key, { data: this.defaultValue });
            if (!cachedData || !cachedData.expiry || cachedData.expiry < Date.now()) {
                return this.defaultValue;
            }
            else {
                return cachedData.data;
            }
        }
        else {
            return this.storage.get(this.key, this.defaultValue);
        }
    }
    async updateValue(newValue, retryOnce = true) {
        try {
            if (this.expiryDurationMs) {
                await this.storage.update(this.key, { data: newValue, expiry: Date.now() + this.expiryDurationMs });
            }
            else {
                await this.storage.update(this.key, newValue);
            }
            if (retryOnce && JSON.stringify(this.value) != JSON.stringify(newValue)) {
                (0, logging_1.traceVerbose)('Storage update failed for key', this.key, ' retrying by resetting first');
                await this.updateValue(undefined, false);
                await this.updateValue(newValue, false);
                if (JSON.stringify(this.value) != JSON.stringify(newValue)) {
                    (0, logging_1.traceWarn)('Retry failed, storage update failed for key', this.key);
                }
            }
        }
        catch (ex) {
            (0, logging_1.traceError)('Error while updating storage for key:', this.key, ex);
        }
    }
}
exports.PersistentState = PersistentState;
exports.GLOBAL_PERSISTENT_KEYS_DEPRECATED = 'PYTHON_EXTENSION_GLOBAL_STORAGE_KEYS';
exports.WORKSPACE_PERSISTENT_KEYS_DEPRECATED = 'PYTHON_EXTENSION_WORKSPACE_STORAGE_KEYS';
const GLOBAL_PERSISTENT_KEYS = 'PYTHON_GLOBAL_STORAGE_KEYS';
const WORKSPACE_PERSISTENT_KEYS = 'PYTHON_WORKSPACE_STORAGE_KEYS';
let PersistentStateFactory = class PersistentStateFactory {
    constructor(globalState, workspaceState, cmdManager) {
        this.globalState = globalState;
        this.workspaceState = workspaceState;
        this.cmdManager = cmdManager;
        this.supportedWorkspaceTypes = { untrustedWorkspace: false, virtualWorkspace: true };
        this._globalKeysStorage = new PersistentState(this.globalState, GLOBAL_PERSISTENT_KEYS, []);
        this._workspaceKeysStorage = new PersistentState(this.workspaceState, WORKSPACE_PERSISTENT_KEYS, []);
    }
    async activate() {
        var _a;
        (_a = this.cmdManager) === null || _a === void 0 ? void 0 : _a.registerCommand(constants_1.Commands.ClearStorage, this.cleanAllPersistentStates.bind(this));
        const globalKeysStorageDeprecated = this.createGlobalPersistentState(exports.GLOBAL_PERSISTENT_KEYS_DEPRECATED, []);
        const workspaceKeysStorageDeprecated = this.createWorkspacePersistentState(exports.WORKSPACE_PERSISTENT_KEYS_DEPRECATED, []);
        if (globalKeysStorageDeprecated.value.length > 0) {
            globalKeysStorageDeprecated.updateValue([]).ignoreErrors();
        }
        if (workspaceKeysStorageDeprecated.value.length > 0) {
            workspaceKeysStorageDeprecated.updateValue([]).ignoreErrors();
        }
    }
    createGlobalPersistentState(key, defaultValue, expiryDurationMs) {
        this.addKeyToStorage('global', key, defaultValue).ignoreErrors();
        return new PersistentState(this.globalState, key, defaultValue, expiryDurationMs);
    }
    createWorkspacePersistentState(key, defaultValue, expiryDurationMs) {
        this.addKeyToStorage('workspace', key, defaultValue).ignoreErrors();
        return new PersistentState(this.workspaceState, key, defaultValue, expiryDurationMs);
    }
    async addKeyToStorage(keyStorageType, key, defaultValue) {
        const storage = keyStorageType === 'global' ? this._globalKeysStorage : this._workspaceKeysStorage;
        const found = storage.value.find((value) => value.key === key);
        if (!found) {
            await storage.updateValue([{ key, defaultValue }, ...storage.value]);
        }
    }
    async cleanAllPersistentStates() {
        await Promise.all(this._globalKeysStorage.value.map(async (keyContent) => {
            const storage = this.createGlobalPersistentState(keyContent.key);
            await storage.updateValue(keyContent.defaultValue);
        }));
        await Promise.all(this._workspaceKeysStorage.value.map(async (keyContent) => {
            const storage = this.createWorkspacePersistentState(keyContent.key);
            await storage.updateValue(keyContent.defaultValue);
        }));
        await this._globalKeysStorage.updateValue([]);
        await this._workspaceKeysStorage.updateValue([]);
    }
};
__decorate([
    (0, decorators_1.cache)(-1, true)
], PersistentStateFactory.prototype, "addKeyToStorage", null);
PersistentStateFactory = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.IMemento)),
    __param(0, (0, inversify_1.named)(types_2.GLOBAL_MEMENTO)),
    __param(1, (0, inversify_1.inject)(types_2.IMemento)),
    __param(1, (0, inversify_1.named)(types_2.WORKSPACE_MEMENTO)),
    __param(2, (0, inversify_1.inject)(types_1.ICommandManager))
], PersistentStateFactory);
exports.PersistentStateFactory = PersistentStateFactory;
function getGlobalStorage(context, key, defaultValue) {
    const globalKeysStorage = new PersistentState(context.globalState, GLOBAL_PERSISTENT_KEYS, []);
    const found = globalKeysStorage.value.find((value) => value.key === key);
    if (!found) {
        const newValue = [{ key, defaultValue }, ...globalKeysStorage.value];
        globalKeysStorage.updateValue(newValue).ignoreErrors();
    }
    const raw = new PersistentState(context.globalState, key, defaultValue);
    return {
        get() {
            return raw.value;
        },
        set(value) {
            return raw.updateValue(value);
        },
    };
}
exports.getGlobalStorage = getGlobalStorage;


/***/ }),

/***/ "./src/client/common/platform/errors.ts":
/*!**********************************************!*\
  !*** ./src/client/common/platform/errors.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNoPermissionsError = exports.isNotDirError = exports.isFileIsDirError = exports.isFileExistsError = exports.isFileNotFoundError = exports.createDirNotEmptyError = void 0;
const vscode = __webpack_require__(/*! vscode */ "vscode");
var vscErrors;
(function (vscErrors) {
    const FILE_NOT_FOUND = vscode.FileSystemError.FileNotFound().name;
    const FILE_EXISTS = vscode.FileSystemError.FileExists().name;
    const IS_DIR = vscode.FileSystemError.FileIsADirectory().name;
    const NOT_DIR = vscode.FileSystemError.FileNotADirectory().name;
    const NO_PERM = vscode.FileSystemError.NoPermissions().name;
    const known = [
        FILE_NOT_FOUND,
        FILE_EXISTS,
        IS_DIR,
        NOT_DIR,
        NO_PERM,
    ];
    function errorMatches(err, expectedName) {
        if (!known.includes(err.name)) {
            return undefined;
        }
        return err.name === expectedName;
    }
    function isFileNotFound(err) {
        return errorMatches(err, FILE_NOT_FOUND);
    }
    vscErrors.isFileNotFound = isFileNotFound;
    function isFileExists(err) {
        return errorMatches(err, FILE_EXISTS);
    }
    vscErrors.isFileExists = isFileExists;
    function isFileIsDir(err) {
        return errorMatches(err, IS_DIR);
    }
    vscErrors.isFileIsDir = isFileIsDir;
    function isNotDir(err) {
        return errorMatches(err, NOT_DIR);
    }
    vscErrors.isNotDir = isNotDir;
    function isNoPermissions(err) {
        return errorMatches(err, NO_PERM);
    }
    vscErrors.isNoPermissions = isNoPermissions;
})(vscErrors || (vscErrors = {}));
function createDirNotEmptyError(dirname) {
    const err = new Error(`directory "${dirname}" not empty`);
    err.name = 'SystemError';
    err.code = 'ENOTEMPTY';
    err.path = dirname;
    err.syscall = 'rmdir';
    return err;
}
exports.createDirNotEmptyError = createDirNotEmptyError;
function isSystemError(err, expectedCode) {
    const code = err.code;
    if (!code) {
        return undefined;
    }
    return code === expectedCode;
}
function isFileNotFoundError(err) {
    const error = err;
    const matched = vscErrors.isFileNotFound(error);
    if (matched !== undefined) {
        return matched;
    }
    return isSystemError(error, 'ENOENT');
}
exports.isFileNotFoundError = isFileNotFoundError;
function isFileExistsError(err) {
    const error = err;
    const matched = vscErrors.isFileExists(error);
    if (matched !== undefined) {
        return matched;
    }
    return isSystemError(error, 'EEXIST');
}
exports.isFileExistsError = isFileExistsError;
function isFileIsDirError(err) {
    const matched = vscErrors.isFileIsDir(err);
    if (matched !== undefined) {
        return matched;
    }
    return isSystemError(err, 'EISDIR');
}
exports.isFileIsDirError = isFileIsDirError;
function isNotDirError(err) {
    const matched = vscErrors.isNotDir(err);
    if (matched !== undefined) {
        return matched;
    }
    return isSystemError(err, 'ENOTDIR');
}
exports.isNotDirError = isNotDirError;
function isNoPermissionsError(err) {
    const error = err;
    const matched = vscErrors.isNoPermissions(error);
    if (matched !== undefined) {
        return matched;
    }
    return isSystemError(error, 'EACCES');
}
exports.isNoPermissionsError = isNoPermissionsError;


/***/ }),

/***/ "./src/client/common/platform/fileSystem.ts":
/*!**************************************************!*\
  !*** ./src/client/common/platform/fileSystem.ts ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileSystem = exports.getHashString = exports.FileSystemUtils = exports.RawFileSystem = exports.convertStat = void 0;
const crypto_1 = __webpack_require__(/*! crypto */ "crypto");
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const glob = __webpack_require__(/*! glob */ "./node_modules/glob/glob.js");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const util_1 = __webpack_require__(/*! util */ "util");
const vscode = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
__webpack_require__(/*! ../extensions */ "./src/client/common/extensions.ts");
const filesystem_1 = __webpack_require__(/*! ../utils/filesystem */ "./src/client/common/utils/filesystem.ts");
const errors_1 = __webpack_require__(/*! ./errors */ "./src/client/common/platform/errors.ts");
const fs_paths_1 = __webpack_require__(/*! ./fs-paths */ "./src/client/common/platform/fs-paths.ts");
const fs_temp_1 = __webpack_require__(/*! ./fs-temp */ "./src/client/common/platform/fs-temp.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/common/platform/types.ts");
const ENCODING = 'utf8';
function convertStat(old, filetype) {
    return {
        type: filetype,
        size: old.size,
        ctime: Math.round(old.ctimeMs),
        mtime: Math.round(old.mtimeMs),
    };
}
exports.convertStat = convertStat;
function filterByFileType(files, fileType) {
    if (fileType === types_1.FileType.Unknown) {
        return files.filter(([_file, ft]) => ft === types_1.FileType.Unknown || ft === (types_1.FileType.SymbolicLink & types_1.FileType.Unknown));
    }
    return files.filter(([_file, ft]) => (ft & fileType) > 0);
}
class RawFileSystem {
    constructor(paths, vscfs, fsExtra) {
        this.paths = paths;
        this.vscfs = vscfs;
        this.fsExtra = fsExtra;
    }
    static withDefaults(paths, vscfs, fsExtra) {
        return new RawFileSystem(paths || fs_paths_1.FileSystemPaths.withDefaults(), vscfs || vscode.workspace.fs, fsExtra || fs);
    }
    async pathExists(filename) {
        return this.fsExtra.pathExists(filename);
    }
    async stat(filename) {
        const uri = vscode.Uri.file(filename);
        return this.vscfs.stat(uri);
    }
    async lstat(filename) {
        const stat = await this.fsExtra.lstat(filename);
        const fileType = (0, filesystem_1.convertFileType)(stat);
        return convertStat(stat, fileType);
    }
    async chmod(filename, mode) {
        return this.fsExtra.chmod(filename, mode);
    }
    async move(src, tgt) {
        const srcUri = vscode.Uri.file(src);
        const tgtUri = vscode.Uri.file(tgt);
        await this.vscfs.stat(vscode.Uri.file(this.paths.dirname(tgt)));
        const options = { overwrite: false };
        try {
            await this.vscfs.rename(srcUri, tgtUri, options);
        }
        catch (err) {
            if (!(0, errors_1.isFileExistsError)(err)) {
                throw err;
            }
            const stat = await this.vscfs.stat(tgtUri);
            if (stat.type === types_1.FileType.Directory) {
                throw err;
            }
            options.overwrite = true;
            await this.vscfs.rename(srcUri, tgtUri, options);
        }
    }
    async readData(filename) {
        const uri = vscode.Uri.file(filename);
        const data = await this.vscfs.readFile(uri);
        return Buffer.from(data);
    }
    async readText(filename) {
        const uri = vscode.Uri.file(filename);
        const result = await this.vscfs.readFile(uri);
        const data = Buffer.from(result);
        return data.toString(ENCODING);
    }
    async writeText(filename, text) {
        const uri = vscode.Uri.file(filename);
        const data = Buffer.from(text);
        await this.vscfs.writeFile(uri, data);
    }
    async appendText(filename, text) {
        return this.fsExtra.appendFile(filename, text);
    }
    async copyFile(src, dest) {
        const srcURI = vscode.Uri.file(src);
        const destURI = vscode.Uri.file(dest);
        await this.vscfs.stat(vscode.Uri.file(this.paths.dirname(dest)));
        await this.vscfs.copy(srcURI, destURI, {
            overwrite: true,
        });
    }
    async rmfile(filename) {
        const uri = vscode.Uri.file(filename);
        return this.vscfs.delete(uri, {
            recursive: false,
            useTrash: false,
        });
    }
    async rmdir(dirname) {
        const uri = vscode.Uri.file(dirname);
        const files = await this.vscfs.readDirectory(uri);
        if (files && files.length > 0) {
            throw (0, errors_1.createDirNotEmptyError)(dirname);
        }
        return this.vscfs.delete(uri, {
            recursive: true,
            useTrash: false,
        });
    }
    async rmtree(dirname) {
        const uri = vscode.Uri.file(dirname);
        await this.vscfs.stat(uri);
        return this.vscfs.delete(uri, {
            recursive: true,
            useTrash: false,
        });
    }
    async mkdirp(dirname) {
        const uri = vscode.Uri.file(dirname);
        await this.vscfs.createDirectory(uri);
    }
    async listdir(dirname) {
        const uri = vscode.Uri.file(dirname);
        const files = await this.vscfs.readDirectory(uri);
        return files.map(([basename, filetype]) => {
            const filename = this.paths.join(dirname, basename);
            return [filename, filetype];
        });
    }
    statSync(filename) {
        let stat = this.fsExtra.lstatSync(filename);
        let filetype = types_1.FileType.Unknown;
        if (stat.isSymbolicLink()) {
            filetype = types_1.FileType.SymbolicLink;
            stat = this.fsExtra.statSync(filename);
        }
        filetype |= (0, filesystem_1.convertFileType)(stat);
        return convertStat(stat, filetype);
    }
    readTextSync(filename) {
        return this.fsExtra.readFileSync(filename, ENCODING);
    }
    createReadStream(filename) {
        return this.fsExtra.createReadStream(filename);
    }
    createWriteStream(filename) {
        return this.fsExtra.createWriteStream(filename);
    }
}
exports.RawFileSystem = RawFileSystem;
class FileSystemUtils {
    constructor(raw, pathUtils, paths, tmp, getHash, globFiles) {
        this.raw = raw;
        this.pathUtils = pathUtils;
        this.paths = paths;
        this.tmp = tmp;
        this.getHash = getHash;
        this.globFiles = globFiles;
    }
    static withDefaults(raw, pathUtils, tmp, getHash, globFiles) {
        pathUtils = pathUtils || fs_paths_1.FileSystemPathUtils.withDefaults();
        return new FileSystemUtils(raw || RawFileSystem.withDefaults(pathUtils.paths), pathUtils, pathUtils.paths, tmp || fs_temp_1.TemporaryFileSystem.withDefaults(), getHash || getHashString, globFiles || (0, util_1.promisify)(glob));
    }
    async createDirectory(directoryPath) {
        return this.raw.mkdirp(directoryPath);
    }
    async deleteDirectory(directoryPath) {
        return this.raw.rmdir(directoryPath);
    }
    async deleteFile(filename) {
        return this.raw.rmfile(filename);
    }
    async pathExists(filename, fileType) {
        if (fileType === undefined) {
            return this.raw.pathExists(filename);
        }
        let stat;
        try {
            stat = await this.raw.stat(filename);
        }
        catch (err) {
            if ((0, errors_1.isFileNotFoundError)(err)) {
                return false;
            }
            (0, logging_1.traceError)(`stat() failed for "${filename}"`, err);
            return false;
        }
        if (fileType === types_1.FileType.Unknown) {
            return stat.type === types_1.FileType.Unknown;
        }
        return (stat.type & fileType) === fileType;
    }
    async fileExists(filename) {
        return this.pathExists(filename, types_1.FileType.File);
    }
    async directoryExists(dirname) {
        return this.pathExists(dirname, types_1.FileType.Directory);
    }
    async listdir(dirname) {
        try {
            return await this.raw.listdir(dirname);
        }
        catch (err) {
            if (!(await this.pathExists(dirname))) {
                return [];
            }
            throw err;
        }
    }
    async getSubDirectories(dirname) {
        const files = await this.listdir(dirname);
        const filtered = filterByFileType(files, types_1.FileType.Directory);
        return filtered.map(([filename, _fileType]) => filename);
    }
    async getFiles(dirname) {
        const files = await this.listdir(dirname);
        const filtered = filterByFileType(files, types_1.FileType.File);
        return filtered.map(([filename, _fileType]) => filename);
    }
    async isDirReadonly(dirname) {
        const filePath = `${dirname}${this.paths.sep}___vscpTest___`;
        try {
            await this.raw.stat(dirname);
            await this.raw.writeText(filePath, '');
        }
        catch (err) {
            if ((0, errors_1.isNoPermissionsError)(err)) {
                return true;
            }
            throw err;
        }
        this.raw
            .rmfile(filePath)
            .ignoreErrors();
        return false;
    }
    async getFileHash(filename) {
        const stat = await this.raw.lstat(filename);
        const data = `${stat.ctime}-${stat.mtime}`;
        return this.getHash(data);
    }
    async search(globPattern, cwd, dot) {
        let options;
        if (cwd) {
            options = { ...options, cwd };
        }
        if (dot) {
            options = { ...options, dot };
        }
        const found = await this.globFiles(globPattern, options);
        return Array.isArray(found) ? found : [];
    }
    fileExistsSync(filePath) {
        try {
            this.raw.statSync(filePath);
        }
        catch (err) {
            if ((0, errors_1.isFileNotFoundError)(err)) {
                return false;
            }
            throw err;
        }
        return true;
    }
}
exports.FileSystemUtils = FileSystemUtils;
function getHashString(data) {
    const hash = (0, crypto_1.createHash)('sha512');
    hash.update(data);
    return hash.digest('hex');
}
exports.getHashString = getHashString;
let FileSystem = class FileSystem {
    constructor() {
        this.utils = FileSystemUtils.withDefaults();
    }
    get directorySeparatorChar() {
        return this.utils.paths.sep;
    }
    arePathsSame(path1, path2) {
        return this.utils.pathUtils.arePathsSame(path1, path2);
    }
    getDisplayName(path) {
        return this.utils.pathUtils.getDisplayName(path);
    }
    async stat(filename) {
        return this.utils.raw.stat(filename);
    }
    async createDirectory(dirname) {
        return this.utils.createDirectory(dirname);
    }
    async deleteDirectory(dirname) {
        return this.utils.deleteDirectory(dirname);
    }
    async listdir(dirname) {
        return this.utils.listdir(dirname);
    }
    async readFile(filePath) {
        return this.utils.raw.readText(filePath);
    }
    async readData(filePath) {
        return this.utils.raw.readData(filePath);
    }
    async writeFile(filename, data) {
        return this.utils.raw.writeText(filename, data);
    }
    async appendFile(filename, text) {
        return this.utils.raw.appendText(filename, text);
    }
    async copyFile(src, dest) {
        return this.utils.raw.copyFile(src, dest);
    }
    async deleteFile(filename) {
        return this.utils.deleteFile(filename);
    }
    async chmod(filename, mode) {
        return this.utils.raw.chmod(filename, mode);
    }
    async move(src, tgt) {
        await this.utils.raw.move(src, tgt);
    }
    readFileSync(filePath) {
        return this.utils.raw.readTextSync(filePath);
    }
    createReadStream(filePath) {
        return this.utils.raw.createReadStream(filePath);
    }
    createWriteStream(filePath) {
        return this.utils.raw.createWriteStream(filePath);
    }
    async fileExists(filename) {
        return this.utils.fileExists(filename);
    }
    pathExists(filename) {
        return this.utils.pathExists(filename);
    }
    fileExistsSync(filename) {
        return this.utils.fileExistsSync(filename);
    }
    async directoryExists(dirname) {
        return this.utils.directoryExists(dirname);
    }
    async getSubDirectories(dirname) {
        return this.utils.getSubDirectories(dirname);
    }
    async getFiles(dirname) {
        return this.utils.getFiles(dirname);
    }
    async getFileHash(filename) {
        return this.utils.getFileHash(filename);
    }
    async search(globPattern, cwd, dot) {
        return this.utils.search(globPattern, cwd, dot);
    }
    async createTemporaryFile(suffix, mode) {
        return this.utils.tmp.createFile(suffix, mode);
    }
    async isDirReadonly(dirname) {
        return this.utils.isDirReadonly(dirname);
    }
};
FileSystem = __decorate([
    (0, inversify_1.injectable)()
], FileSystem);
exports.FileSystem = FileSystem;


/***/ }),

/***/ "./src/client/common/platform/fileSystemWatcher.ts":
/*!*********************************************************!*\
  !*** ./src/client/common/platform/fileSystemWatcher.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.watchLocationForPattern = exports.FileChangeType = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
var FileChangeType;
(function (FileChangeType) {
    FileChangeType["Changed"] = "changed";
    FileChangeType["Created"] = "created";
    FileChangeType["Deleted"] = "deleted";
})(FileChangeType = exports.FileChangeType || (exports.FileChangeType = {}));
function watchLocationForPattern(baseDir, pattern, callback) {
    const globPattern = new vscode_1.RelativePattern(baseDir, pattern);
    const disposables = new resourceLifecycle_1.Disposables();
    (0, logging_1.traceVerbose)(`Start watching: ${baseDir} with pattern ${pattern} using VSCode API`);
    try {
        const watcher = vscode_1.workspace.createFileSystemWatcher(globPattern);
        disposables.push(watcher.onDidCreate((e) => callback(FileChangeType.Created, e.fsPath)));
        disposables.push(watcher.onDidChange((e) => callback(FileChangeType.Changed, e.fsPath)));
        disposables.push(watcher.onDidDelete((e) => callback(FileChangeType.Deleted, e.fsPath)));
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to create File System watcher for patter ${pattern} in ${baseDir}`, ex);
    }
    return disposables;
}
exports.watchLocationForPattern = watchLocationForPattern;


/***/ }),

/***/ "./src/client/common/platform/fs-paths.ts":
/*!************************************************!*\
  !*** ./src/client/common/platform/fs-paths.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.arePathsSame = exports.isParentPath = exports.normCase = exports.normCasePath = exports.FileSystemPathUtils = exports.Executables = exports.FileSystemPaths = void 0;
const nodepath = __webpack_require__(/*! path */ "path");
const exec_1 = __webpack_require__(/*! ../utils/exec */ "./src/client/common/utils/exec.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
const untildify = __webpack_require__(/*! untildify */ "./node_modules/untildify/index.js");
class FileSystemPaths {
    constructor(isCaseInsensitive, raw) {
        this.isCaseInsensitive = isCaseInsensitive;
        this.raw = raw;
    }
    static withDefaults(isCaseInsensitive) {
        if (isCaseInsensitive === undefined) {
            isCaseInsensitive = (0, platform_1.getOSType)() === platform_1.OSType.Windows;
        }
        return new FileSystemPaths(isCaseInsensitive, nodepath);
    }
    get sep() {
        return this.raw.sep;
    }
    join(...filenames) {
        return this.raw.join(...filenames);
    }
    dirname(filename) {
        return this.raw.dirname(filename);
    }
    basename(filename, suffix) {
        return this.raw.basename(filename, suffix);
    }
    normalize(filename) {
        return this.raw.normalize(filename);
    }
    normCase(filename) {
        filename = this.raw.normalize(filename);
        return this.isCaseInsensitive ? filename.toUpperCase() : filename;
    }
}
exports.FileSystemPaths = FileSystemPaths;
class Executables {
    constructor(delimiter, osType) {
        this.delimiter = delimiter;
        this.osType = osType;
    }
    static withDefaults() {
        return new Executables(nodepath.delimiter, (0, platform_1.getOSType)());
    }
    get envVar() {
        return (0, exec_1.getSearchPathEnvVarNames)(this.osType)[0];
    }
}
exports.Executables = Executables;
class FileSystemPathUtils {
    constructor(home, paths, executables, raw) {
        this.home = home;
        this.paths = paths;
        this.executables = executables;
        this.raw = raw;
    }
    static withDefaults(paths) {
        if (paths === undefined) {
            paths = FileSystemPaths.withDefaults();
        }
        return new FileSystemPathUtils(untildify('~'), paths, Executables.withDefaults(), nodepath);
    }
    arePathsSame(path1, path2) {
        path1 = this.paths.normCase(path1);
        path2 = this.paths.normCase(path2);
        return path1 === path2;
    }
    getDisplayName(filename, cwd) {
        if (cwd && isParentPath(filename, cwd)) {
            return `.${this.paths.sep}${this.raw.relative(cwd, filename)}`;
        }
        else if (isParentPath(filename, this.home)) {
            return `~${this.paths.sep}${this.raw.relative(this.home, filename)}`;
        }
        else {
            return filename;
        }
    }
}
exports.FileSystemPathUtils = FileSystemPathUtils;
function normCasePath(filePath) {
    return normCase(nodepath.normalize(filePath));
}
exports.normCasePath = normCasePath;
function normCase(s) {
    return (0, platform_1.getOSType)() === platform_1.OSType.Windows ? s.toUpperCase() : s;
}
exports.normCase = normCase;
function isParentPath(filePath, parentPath) {
    if (!parentPath.endsWith(nodepath.sep)) {
        parentPath += nodepath.sep;
    }
    if (!filePath.endsWith(nodepath.sep)) {
        filePath += nodepath.sep;
    }
    return normCasePath(filePath).startsWith(normCasePath(parentPath));
}
exports.isParentPath = isParentPath;
function arePathsSame(path1, path2) {
    return normCasePath(path1) === normCasePath(path2);
}
exports.arePathsSame = arePathsSame;


/***/ }),

/***/ "./src/client/common/platform/fs-temp.ts":
/*!***********************************************!*\
  !*** ./src/client/common/platform/fs-temp.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TemporaryFileSystem = void 0;
const tmp = __webpack_require__(/*! tmp */ "./node_modules/tmp/lib/tmp.js");
class TemporaryFileSystem {
    constructor(raw) {
        this.raw = raw;
    }
    static withDefaults() {
        return new TemporaryFileSystem(tmp);
    }
    createFile(suffix, mode) {
        const opts = {
            postfix: suffix,
            mode,
        };
        return new Promise((resolve, reject) => {
            this.raw.file(opts, (err, filename, _fd, cleanUp) => {
                if (err) {
                    return reject(err);
                }
                resolve({
                    filePath: filename,
                    dispose: cleanUp,
                });
            });
        });
    }
}
exports.TemporaryFileSystem = TemporaryFileSystem;


/***/ }),

/***/ "./src/client/common/platform/pathUtils.ts":
/*!*************************************************!*\
  !*** ./src/client/common/platform/pathUtils.ts ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathUtils = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
const fs_paths_1 = __webpack_require__(/*! ./fs-paths */ "./src/client/common/platform/fs-paths.ts");
const untildify = __webpack_require__(/*! untildify */ "./node_modules/untildify/index.js");
let PathUtils = class PathUtils {
    constructor(isWindows) {
        const osType = isWindows ? platform_1.OSType.Windows : platform_1.OSType.Unknown;
        this.utils = new fs_paths_1.FileSystemPathUtils(untildify('~'), fs_paths_1.FileSystemPaths.withDefaults(), new fs_paths_1.Executables(path.delimiter, osType), path);
    }
    get home() {
        return this.utils.home;
    }
    get delimiter() {
        return this.utils.executables.delimiter;
    }
    get separator() {
        return this.utils.paths.sep;
    }
    getPathVariableName() {
        return this.utils.executables.envVar;
    }
    getDisplayName(pathValue, cwd) {
        return this.utils.getDisplayName(pathValue, cwd);
    }
    basename(pathValue, ext) {
        return this.utils.paths.basename(pathValue, ext);
    }
};
PathUtils = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IsWindows))
], PathUtils);
exports.PathUtils = PathUtils;


/***/ }),

/***/ "./src/client/common/platform/platformService.ts":
/*!*******************************************************!*\
  !*** ./src/client/common/platform/platformService.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isWindows = exports.PlatformService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const os = __webpack_require__(/*! os */ "os");
const semver_1 = __webpack_require__(/*! semver */ "./node_modules/semver/semver.js");
const exec_1 = __webpack_require__(/*! ../utils/exec */ "./src/client/common/utils/exec.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
const version_1 = __webpack_require__(/*! ../utils/version */ "./src/client/common/utils/version.ts");
let PlatformService = class PlatformService {
    constructor() {
        this.osType = (0, platform_1.getOSType)();
    }
    get pathVariableName() {
        return (0, exec_1.getSearchPathEnvVarNames)(this.osType)[0];
    }
    get virtualEnvBinName() {
        return this.isWindows ? 'Scripts' : 'bin';
    }
    async getVersion() {
        if (this.version) {
            return this.version;
        }
        switch (this.osType) {
            case platform_1.OSType.Windows:
            case platform_1.OSType.OSX:
                try {
                    const ver = (0, semver_1.coerce)(os.release());
                    if (ver) {
                        this.version = ver;
                        return this.version;
                    }
                    throw new Error('Unable to parse version');
                }
                catch (ex) {
                    return (0, version_1.parseSemVerSafe)(os.release());
                }
            default:
                throw new Error('Not Supported');
        }
    }
    get isWindows() {
        return isWindows();
    }
    get isMac() {
        return this.osType === platform_1.OSType.OSX;
    }
    get isLinux() {
        return this.osType === platform_1.OSType.Linux;
    }
    get osRelease() {
        return os.release();
    }
    get is64bit() {
        return (0, platform_1.getArchitecture)() === platform_1.Architecture.x64;
    }
};
PlatformService = __decorate([
    (0, inversify_1.injectable)()
], PlatformService);
exports.PlatformService = PlatformService;
function isWindows() {
    return (0, platform_1.getOSType)() === platform_1.OSType.Windows;
}
exports.isWindows = isWindows;


/***/ }),

/***/ "./src/client/common/platform/registry.ts":
/*!************************************************!*\
  !*** ./src/client/common/platform/registry.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getArchitectureDisplayName = void 0;
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
function getArchitectureDisplayName(arch) {
    switch (arch) {
        case platform_1.Architecture.x64:
            return '64-bit';
        case platform_1.Architecture.x86:
            return '32-bit';
        default:
            return '';
    }
}
exports.getArchitectureDisplayName = getArchitectureDisplayName;


/***/ }),

/***/ "./src/client/common/platform/serviceRegistry.ts":
/*!*******************************************************!*\
  !*** ./src/client/common/platform/serviceRegistry.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const fileSystem_1 = __webpack_require__(/*! ./fileSystem */ "./src/client/common/platform/fileSystem.ts");
const platformService_1 = __webpack_require__(/*! ./platformService */ "./src/client/common/platform/platformService.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/common/platform/types.ts");
function registerTypes(serviceManager) {
    serviceManager.addSingleton(types_1.IPlatformService, platformService_1.PlatformService);
    serviceManager.addSingleton(types_1.IFileSystem, fileSystem_1.FileSystem);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/client/common/platform/types.ts":
/*!*********************************************!*\
  !*** ./src/client/common/platform/types.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IFileSystem = exports.IFileSystemPathUtils = exports.IPlatformService = exports.RegistryHive = exports.FileType = void 0;
const vscode = __webpack_require__(/*! vscode */ "vscode");
exports.FileType = vscode.FileType;
var RegistryHive;
(function (RegistryHive) {
    RegistryHive[RegistryHive["HKCU"] = 0] = "HKCU";
    RegistryHive[RegistryHive["HKLM"] = 1] = "HKLM";
})(RegistryHive = exports.RegistryHive || (exports.RegistryHive = {}));
exports.IPlatformService = Symbol('IPlatformService');
exports.IFileSystemPathUtils = Symbol('IFileSystemPathUtils');
exports.IFileSystem = Symbol('IFileSystem');


/***/ }),

/***/ "./src/client/common/process/constants.ts":
/*!************************************************!*\
  !*** ./src/client/common/process/constants.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEFAULT_ENCODING = void 0;
exports.DEFAULT_ENCODING = 'utf8';


/***/ }),

/***/ "./src/client/common/process/currentProcess.ts":
/*!*****************************************************!*\
  !*** ./src/client/common/process/currentProcess.ts ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CurrentProcess = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
let CurrentProcess = class CurrentProcess {
    constructor() {
        this.on = (event, listener) => {
            process.on(event, listener);
            return process;
        };
    }
    get env() {
        return process.env;
    }
    get argv() {
        return process.argv;
    }
    get stdout() {
        return process.stdout;
    }
    get stdin() {
        return process.stdin;
    }
    get execPath() {
        return process.execPath;
    }
};
CurrentProcess = __decorate([
    (0, inversify_1.injectable)()
], CurrentProcess);
exports.CurrentProcess = CurrentProcess;


/***/ }),

/***/ "./src/client/common/process/decoder.ts":
/*!**********************************************!*\
  !*** ./src/client/common/process/decoder.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.decodeBuffer = void 0;
const iconv = __webpack_require__(/*! iconv-lite */ "./node_modules/iconv-lite/lib/index.js");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/client/common/process/constants.ts");
function decodeBuffer(buffers, encoding = constants_1.DEFAULT_ENCODING) {
    encoding = iconv.encodingExists(encoding) ? encoding : constants_1.DEFAULT_ENCODING;
    return iconv.decode(Buffer.concat(buffers), encoding);
}
exports.decodeBuffer = decodeBuffer;


/***/ }),

/***/ "./src/client/common/process/internal/python.ts":
/*!******************************************************!*\
  !*** ./src/client/common/process/internal/python.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getModuleVersion = exports.isModuleInstalled = exports.isValid = exports.getUserSitePackages = exports.getSitePackages = exports.getExecutable = exports.execModule = exports.execCode = void 0;
function execCode(code) {
    let args = ['-c', code];
    return args;
}
exports.execCode = execCode;
function execModule(name, moduleArgs) {
    const args = ['-m', name, ...moduleArgs];
    return args;
}
exports.execModule = execModule;
function getExecutable() {
    const args = ['-c', 'import sys;print(sys.executable)'];
    function parse(out) {
        return out.trim();
    }
    return [args, parse];
}
exports.getExecutable = getExecutable;
function getSitePackages() {
    const args = ['-c', 'from distutils.sysconfig import get_python_lib; print(get_python_lib())'];
    function parse(out) {
        return out.trim();
    }
    return [args, parse];
}
exports.getSitePackages = getSitePackages;
function getUserSitePackages() {
    const args = ['site', '--user-site'];
    function parse(out) {
        return out.trim();
    }
    return [args, parse];
}
exports.getUserSitePackages = getUserSitePackages;
function isValid() {
    const args = ['-c', 'print(1234)'];
    function parse(out) {
        return out.startsWith('1234');
    }
    return [args, parse];
}
exports.isValid = isValid;
function isModuleInstalled(name) {
    const args = ['-c', `import ${name}`];
    function parse(_out) {
        return true;
    }
    return [args, parse];
}
exports.isModuleInstalled = isModuleInstalled;
function getModuleVersion(name) {
    const args = ['-c', `import ${name}; print(${name}.__version__)`];
    function parse(out) {
        return out.trim();
    }
    return [args, parse];
}
exports.getModuleVersion = getModuleVersion;


/***/ }),

/***/ "./src/client/common/process/internal/scripts/constants.ts":
/*!*****************************************************************!*\
  !*** ./src/client/common/process/internal/scripts/constants.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._SCRIPTS_DIR = void 0;
const path = __webpack_require__(/*! path */ "path");
const constants_1 = __webpack_require__(/*! ../../../constants */ "./src/client/common/constants.ts");
exports._SCRIPTS_DIR = path.join(constants_1.EXTENSION_ROOT_DIR, 'pythonFiles');


/***/ }),

/***/ "./src/client/common/process/internal/scripts/index.ts":
/*!*************************************************************!*\
  !*** ./src/client/common/process/internal/scripts/index.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.installedCheckScript = exports.createCondaScript = exports.createVenvScript = exports.linterScript = exports.tensorboardLauncher = exports.execution_py_testlauncher = exports.visualstudio_py_testlauncher = exports.pytestlauncher = exports.testlauncher = exports.shell_exec = exports.printEnvVariables = exports.normalizeSelection = exports.interpreterInfo = exports.OUTPUT_MARKER_SCRIPT = void 0;
const path = __webpack_require__(/*! path */ "path");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/client/common/process/internal/scripts/constants.ts");
const SCRIPTS_DIR = constants_1._SCRIPTS_DIR;
exports.OUTPUT_MARKER_SCRIPT = path.join(constants_1._SCRIPTS_DIR, 'get_output_via_markers.py');
function interpreterInfo() {
    const script = path.join(SCRIPTS_DIR, 'interpreterInfo.py');
    const args = [script];
    function parse(out) {
        try {
            return JSON.parse(out);
        }
        catch (ex) {
            throw Error(`python ${args} returned bad JSON (${out}) (${ex})`);
        }
    }
    return [args, parse];
}
exports.interpreterInfo = interpreterInfo;
function normalizeSelection() {
    const script = path.join(SCRIPTS_DIR, 'normalizeSelection.py');
    const args = [script];
    function parse(out) {
        return out;
    }
    return [args, parse];
}
exports.normalizeSelection = normalizeSelection;
function printEnvVariables() {
    const script = path.join(SCRIPTS_DIR, 'printEnvVariables.py').fileToCommandArgumentForPythonMgrExt();
    const args = [script];
    function parse(out) {
        return JSON.parse(out);
    }
    return [args, parse];
}
exports.printEnvVariables = printEnvVariables;
function shell_exec(command, lockfile, shellArgs) {
    const script = path.join(SCRIPTS_DIR, 'shell_exec.py');
    return [
        script,
        command.fileToCommandArgumentForPythonMgrExt(),
        ...shellArgs,
        lockfile.fileToCommandArgumentForPythonMgrExt(),
    ];
}
exports.shell_exec = shell_exec;
function testlauncher(testArgs) {
    const script = path.join(SCRIPTS_DIR, 'testlauncher.py');
    return [script, ...testArgs];
}
exports.testlauncher = testlauncher;
function pytestlauncher(testArgs) {
    const script = path.join(SCRIPTS_DIR, 'vscode_pytest', 'run_pytest_script.py');
    return [script, ...testArgs];
}
exports.pytestlauncher = pytestlauncher;
function visualstudio_py_testlauncher(testArgs) {
    const script = path.join(SCRIPTS_DIR, 'visualstudio_py_testlauncher.py');
    return [script, ...testArgs];
}
exports.visualstudio_py_testlauncher = visualstudio_py_testlauncher;
function execution_py_testlauncher(testArgs) {
    const script = path.join(SCRIPTS_DIR, 'unittestadapter', 'execution.py');
    return [script, ...testArgs];
}
exports.execution_py_testlauncher = execution_py_testlauncher;
function tensorboardLauncher(args) {
    const script = path.join(SCRIPTS_DIR, 'tensorboard_launcher.py');
    return [script, ...args];
}
exports.tensorboardLauncher = tensorboardLauncher;
function linterScript() {
    const script = path.join(SCRIPTS_DIR, 'linter.py');
    return script;
}
exports.linterScript = linterScript;
function createVenvScript() {
    const script = path.join(SCRIPTS_DIR, 'create_venv.py');
    return script;
}
exports.createVenvScript = createVenvScript;
function createCondaScript() {
    const script = path.join(SCRIPTS_DIR, 'create_conda.py');
    return script;
}
exports.createCondaScript = createCondaScript;
function installedCheckScript() {
    const script = path.join(SCRIPTS_DIR, 'installed_check.py');
    return script;
}
exports.installedCheckScript = installedCheckScript;


/***/ }),

/***/ "./src/client/common/process/logger.ts":
/*!*********************************************!*\
  !*** ./src/client/common/process/logger.ts ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProcessLogger = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
const constants_1 = __webpack_require__(/*! ../constants */ "./src/client/common/constants.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const stringUtils_1 = __webpack_require__(/*! ../stringUtils */ "./src/client/common/stringUtils.ts");
const baseShellDetector_1 = __webpack_require__(/*! ../terminal/shellDetectors/baseShellDetector */ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts");
const extensions_1 = __webpack_require__(/*! ../extensions */ "./src/client/common/extensions.ts");
let ProcessLogger = class ProcessLogger {
    constructor(workspaceService) {
        this.workspaceService = workspaceService;
    }
    logProcess(fileOrCommand, args, options) {
        if (!(0, constants_1.isTestExecution)() && constants_1.isCI && process.env.UITEST_DISABLE_PROCESS_LOGGING) {
            return;
        }
        let command = args
            ? [fileOrCommand, ...args].map((e) => (0, extensions_1.trimQuotes)(e).toCommandArgumentForPythonMgrExt()).join(' ')
            : fileOrCommand;
        const info = [`> ${this.getDisplayCommands(command)}`];
        if (options === null || options === void 0 ? void 0 : options.cwd) {
            info.push(`cwd: ${this.getDisplayCommands(options.cwd.toString())}`);
        }
        if (typeof (options === null || options === void 0 ? void 0 : options.shell) === 'string') {
            info.push(`shell: ${(0, baseShellDetector_1.identifyShellFromShellPath)(options === null || options === void 0 ? void 0 : options.shell)}`);
        }
        info.forEach((line) => {
            (0, logging_1.traceLog)(line);
        });
    }
    getDisplayCommands(command) {
        if (this.workspaceService.workspaceFolders && this.workspaceService.workspaceFolders.length === 1) {
            command = replaceMatchesWithCharacter(command, this.workspaceService.workspaceFolders[0].uri.fsPath, '.');
        }
        const home = (0, platform_1.getUserHomeDir)();
        if (home) {
            command = replaceMatchesWithCharacter(command, home, '~');
        }
        return command;
    }
};
ProcessLogger = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IWorkspaceService))
], ProcessLogger);
exports.ProcessLogger = ProcessLogger;
function replaceMatchesWithCharacter(original, match, character) {
    function getRegex(match) {
        let pattern = (0, lodash_1.escapeRegExp)(match);
        if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
            pattern = (0, stringUtils_1.replaceAll)(pattern, '\\\\', '(\\\\|/)');
        }
        let regex = new RegExp(pattern, 'ig');
        return regex;
    }
    function isPrevioustoMatchRegexALetter(chunk, index) {
        return chunk[index].match(/[a-z]/);
    }
    let chunked = original.split(' ');
    for (let i = 0; i < chunked.length; i++) {
        let regex = getRegex(match);
        const regexResult = regex.exec(chunked[i]);
        if (regexResult) {
            const regexIndex = regexResult.index;
            if (regexIndex > 0 && isPrevioustoMatchRegexALetter(chunked[i], regexIndex - 1))
                regex = getRegex(match.substring(1));
            chunked[i] = chunked[i].replace(regex, character);
        }
    }
    return chunked.join(' ');
}


/***/ }),

/***/ "./src/client/common/process/proc.ts":
/*!*******************************************!*\
  !*** ./src/client/common/process/proc.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProcessService = void 0;
const events_1 = __webpack_require__(/*! events */ "events");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const rawProcessApis_1 = __webpack_require__(/*! ./rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
class ProcessService extends events_1.EventEmitter {
    constructor(env) {
        super();
        this.env = env;
        this.processesToKill = new Set();
    }
    static isAlive(pid) {
        try {
            process.kill(pid, 0);
            return true;
        }
        catch (_a) {
            return false;
        }
    }
    static kill(pid) {
        (0, rawProcessApis_1.killPid)(pid);
    }
    dispose() {
        this.removeAllListeners();
        this.processesToKill.forEach((p) => {
            try {
                p.dispose();
            }
            catch (_a) {
            }
        });
    }
    execObservable(file, args, options = {}) {
        const result = (0, rawProcessApis_1.execObservable)(file, args, options, this.env, this.processesToKill);
        this.emit('exec', file, args, options);
        return result;
    }
    exec(file, args, options = {}) {
        const promise = (0, rawProcessApis_1.plainExec)(file, args, options, this.env, this.processesToKill);
        this.emit('exec', file, args, options);
        return promise;
    }
    shellExec(command, options = {}) {
        this.emit('exec', command, undefined, options);
        const disposables = new Set();
        return (0, rawProcessApis_1.shellExec)(command, options, this.env, disposables).finally(() => {
            disposables.forEach((p) => {
                try {
                    p.dispose();
                }
                catch (_a) {
                    (0, logging_1.traceError)(`Unable to kill process for ${command}`);
                }
            });
        });
    }
}
exports.ProcessService = ProcessService;


/***/ }),

/***/ "./src/client/common/process/processFactory.ts":
/*!*****************************************************!*\
  !*** ./src/client/common/process/processFactory.ts ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProcessServiceFactory = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const types_2 = __webpack_require__(/*! ../variables/types */ "./src/client/common/variables/types.ts");
const proc_1 = __webpack_require__(/*! ./proc */ "./src/client/common/process/proc.ts");
const types_3 = __webpack_require__(/*! ./types */ "./src/client/common/process/types.ts");
let ProcessServiceFactory = class ProcessServiceFactory {
    constructor(envVarsService, processLogger, disposableRegistry) {
        this.envVarsService = envVarsService;
        this.processLogger = processLogger;
        this.disposableRegistry = disposableRegistry;
    }
    async create(resource, options) {
        const customEnvVars = (options === null || options === void 0 ? void 0 : options.doNotUseCustomEnvs)
            ? undefined
            : await this.envVarsService.getEnvironmentVariables(resource);
        const proc = new proc_1.ProcessService(customEnvVars);
        this.disposableRegistry.push(proc);
        return proc.on('exec', this.processLogger.logProcess.bind(this.processLogger));
    }
};
ProcessServiceFactory = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.IEnvironmentVariablesProvider)),
    __param(1, (0, inversify_1.inject)(types_3.IProcessLogger)),
    __param(2, (0, inversify_1.inject)(types_1.IDisposableRegistry))
], ProcessServiceFactory);
exports.ProcessServiceFactory = ProcessServiceFactory;


/***/ }),

/***/ "./src/client/common/process/pythonEnvironment.ts":
/*!********************************************************!*\
  !*** ./src/client/common/process/pythonEnvironment.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createMicrosoftStoreEnv = exports.createCondaEnv = exports.createPythonEnv = void 0;
const path = __webpack_require__(/*! path */ "path");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const conda_1 = __webpack_require__(/*! ../../pythonEnvironments/common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const exec_1 = __webpack_require__(/*! ../../pythonEnvironments/exec */ "./src/client/pythonEnvironments/exec.ts");
const executable_1 = __webpack_require__(/*! ../../pythonEnvironments/info/executable */ "./src/client/pythonEnvironments/info/executable.ts");
const interpreter_1 = __webpack_require__(/*! ../../pythonEnvironments/info/interpreter */ "./src/client/pythonEnvironments/info/interpreter.ts");
const constants_1 = __webpack_require__(/*! ../constants */ "./src/client/common/constants.ts");
const internalPython = __webpack_require__(/*! ./internal/python */ "./src/client/common/process/internal/python.ts");
const cachedExecutablePath = new Map();
class PythonEnvironment {
    constructor(pythonPath, deps) {
        this.pythonPath = pythonPath;
        this.deps = deps;
        this.cachedInterpreterInformation = null;
    }
    getExecutionInfo(pythonArgs = [], pythonExecutable) {
        const python = this.deps.getPythonArgv(this.pythonPath);
        return (0, exec_1.buildPythonExecInfo)(python, pythonArgs, pythonExecutable);
    }
    getExecutionObservableInfo(pythonArgs = [], pythonExecutable) {
        const python = this.deps.getObservablePythonArgv(this.pythonPath);
        return (0, exec_1.buildPythonExecInfo)(python, pythonArgs, pythonExecutable);
    }
    async getInterpreterInformation() {
        if (this.cachedInterpreterInformation === null) {
            this.cachedInterpreterInformation = await this.getInterpreterInformationImpl();
        }
        return this.cachedInterpreterInformation;
    }
    async getExecutablePath() {
        if (await this.deps.isValidExecutable(this.pythonPath)) {
            return this.pythonPath;
        }
        const result = cachedExecutablePath.get(this.pythonPath);
        if (result !== undefined && !(0, constants_1.isTestExecution)()) {
            return result;
        }
        const python = this.getExecutionInfo();
        const promise = (0, executable_1.getExecutablePath)(python, this.deps.shellExec);
        cachedExecutablePath.set(this.pythonPath, promise);
        return promise;
    }
    async getModuleVersion(moduleName) {
        const [args, parse] = internalPython.getModuleVersion(moduleName);
        const info = this.getExecutionInfo(args);
        let data;
        try {
            data = await this.deps.exec(info.command, info.args);
        }
        catch (ex) {
            (0, logging_1.traceVerbose)(`Error when getting version of module ${moduleName}`, ex);
            return undefined;
        }
        return parse(data.stdout);
    }
    async isModuleInstalled(moduleName) {
        const [args,] = internalPython.isModuleInstalled(moduleName);
        const info = this.getExecutionInfo(args);
        try {
            await this.deps.exec(info.command, info.args);
        }
        catch (ex) {
            (0, logging_1.traceVerbose)(`Error when checking if module is installed ${moduleName}`, ex);
            return false;
        }
        return true;
    }
    async getInterpreterInformationImpl() {
        try {
            const python = this.getExecutionInfo();
            return await (0, interpreter_1.getInterpreterInfo)(python, this.deps.shellExec, { verbose: logging_1.traceVerbose, error: logging_1.traceError });
        }
        catch (ex) {
            (0, logging_1.traceError)(`Failed to get interpreter information for '${this.pythonPath}'`, ex);
        }
    }
}
function createDeps(isValidExecutable, pythonArgv, observablePythonArgv, exec, shellExec) {
    return {
        getPythonArgv: (python) => {
            if (path.basename(python) === python) {
                pythonArgv = python.split(' ');
            }
            return pythonArgv || [python];
        },
        getObservablePythonArgv: (python) => {
            if (path.basename(python) === python) {
                observablePythonArgv = python.split(' ');
            }
            return observablePythonArgv || [python];
        },
        isValidExecutable,
        exec: async (cmd, args) => exec(cmd, args, { throwOnStdErr: true }),
        shellExec,
    };
}
function createPythonEnv(pythonPath, procs, fs) {
    const deps = createDeps(async (filename) => fs.pathExists(filename), undefined, undefined, (file, args, opts) => procs.exec(file, args, opts), (command, opts) => procs.shellExec(command, opts));
    return new PythonEnvironment(pythonPath, deps);
}
exports.createPythonEnv = createPythonEnv;
async function createCondaEnv(condaInfo, procs, fs) {
    const conda = await conda_1.Conda.getConda();
    const pythonArgv = await (conda === null || conda === void 0 ? void 0 : conda.getRunPythonArgs({ name: condaInfo.name, prefix: condaInfo.path }));
    if (!pythonArgv) {
        return undefined;
    }
    const deps = createDeps(async (filename) => fs.pathExists(filename), pythonArgv, pythonArgv, (file, args, opts) => procs.exec(file, args, opts), (command, opts) => procs.shellExec(command, opts));
    const interpreterPath = await (conda === null || conda === void 0 ? void 0 : conda.getInterpreterPathForEnvironment({
        name: condaInfo.name,
        prefix: condaInfo.path,
    }));
    if (!interpreterPath) {
        return undefined;
    }
    return new PythonEnvironment(interpreterPath, deps);
}
exports.createCondaEnv = createCondaEnv;
function createMicrosoftStoreEnv(pythonPath, procs) {
    const deps = createDeps(async (_f) => true, undefined, undefined, (file, args, opts) => procs.exec(file, args, opts), (command, opts) => procs.shellExec(command, opts));
    return new PythonEnvironment(pythonPath, deps);
}
exports.createMicrosoftStoreEnv = createMicrosoftStoreEnv;


/***/ }),

/***/ "./src/client/common/process/pythonExecutionFactory.ts":
/*!*************************************************************!*\
  !*** ./src/client/common/process/pythonExecutionFactory.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonExecutionFactory = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../../interpreter/activation/types */ "./src/client/interpreter/activation/types.ts");
const contracts_1 = __webpack_require__(/*! ../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const types_2 = __webpack_require__(/*! ../../ioc/types */ "./src/client/ioc/types.ts");
const telemetry_1 = __webpack_require__(/*! ../../telemetry */ "./src/client/telemetry/index.ts");
const constants_1 = __webpack_require__(/*! ../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const types_3 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const types_4 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const proc_1 = __webpack_require__(/*! ./proc */ "./src/client/common/process/proc.ts");
const pythonEnvironment_1 = __webpack_require__(/*! ./pythonEnvironment */ "./src/client/common/process/pythonEnvironment.ts");
const pythonProcess_1 = __webpack_require__(/*! ./pythonProcess */ "./src/client/common/process/pythonProcess.ts");
const types_5 = __webpack_require__(/*! ./types */ "./src/client/common/process/types.ts");
let PythonExecutionFactory = class PythonExecutionFactory {
    constructor(serviceContainer, activationHelper, processServiceFactory, configService, pyenvs) {
        this.serviceContainer = serviceContainer;
        this.activationHelper = activationHelper;
        this.processServiceFactory = processServiceFactory;
        this.configService = configService;
        this.pyenvs = pyenvs;
        this.disposables = this.serviceContainer.get(types_4.IDisposableRegistry);
        this.logger = this.serviceContainer.get(types_5.IProcessLogger);
        this.fileSystem = this.serviceContainer.get(types_3.IFileSystem);
    }
    async create(options) {
        let { pythonPath } = options;
        if (!pythonPath || pythonPath === 'python') {
            const activatedEnvLaunch = this.serviceContainer.get(contracts_1.IActivatedEnvironmentLaunch);
            await activatedEnvLaunch.selectIfLaunchedViaActivatedEnv();
            pythonPath = this.configService.getSettings(options.resource).pythonPath;
        }
        const processService = await this.processServiceFactory.create(options.resource);
        const condaExecutionService = await this.createCondaExecutionService(pythonPath, processService);
        if (condaExecutionService) {
            return condaExecutionService;
        }
        const windowsStoreInterpreterCheck = this.pyenvs.isMicrosoftStoreInterpreter.bind(this.pyenvs);
        const env = (await windowsStoreInterpreterCheck(pythonPath))
            ? (0, pythonEnvironment_1.createMicrosoftStoreEnv)(pythonPath, processService)
            : (0, pythonEnvironment_1.createPythonEnv)(pythonPath, processService, this.fileSystem);
        return createPythonService(processService, env);
    }
    async createActivatedEnvironment(options) {
        const envVars = await this.activationHelper.getActivatedEnvironmentVariables(options.resource, options.interpreter, options.allowEnvironmentFetchExceptions);
        const hasEnvVars = envVars && Object.keys(envVars).length > 0;
        (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.PYTHON_INTERPRETER_ACTIVATION_ENVIRONMENT_VARIABLES, undefined, { hasEnvVars });
        if (!hasEnvVars) {
            return this.create({
                resource: options.resource,
                pythonPath: options.interpreter ? options.interpreter.path : undefined,
            });
        }
        const pythonPath = options.interpreter
            ? options.interpreter.path
            : this.configService.getSettings(options.resource).pythonPath;
        const processService = new proc_1.ProcessService({ ...envVars });
        processService.on('exec', this.logger.logProcess.bind(this.logger));
        this.disposables.push(processService);
        const condaExecutionService = await this.createCondaExecutionService(pythonPath, processService);
        if (condaExecutionService) {
            return condaExecutionService;
        }
        const env = (0, pythonEnvironment_1.createPythonEnv)(pythonPath, processService, this.fileSystem);
        return createPythonService(processService, env);
    }
    async createCondaExecutionService(pythonPath, processService) {
        const condaLocatorService = this.serviceContainer.get(contracts_1.IComponentAdapter);
        const [condaEnvironment] = await Promise.all([condaLocatorService.getCondaEnvironment(pythonPath)]);
        if (!condaEnvironment) {
            return undefined;
        }
        const env = await (0, pythonEnvironment_1.createCondaEnv)(condaEnvironment, processService, this.fileSystem);
        if (!env) {
            return undefined;
        }
        return createPythonService(processService, env);
    }
};
PythonExecutionFactory = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.IServiceContainer)),
    __param(1, (0, inversify_1.inject)(types_1.IEnvironmentActivationService)),
    __param(2, (0, inversify_1.inject)(types_5.IProcessServiceFactory)),
    __param(3, (0, inversify_1.inject)(types_4.IConfigurationService)),
    __param(4, (0, inversify_1.inject)(contracts_1.IComponentAdapter))
], PythonExecutionFactory);
exports.PythonExecutionFactory = PythonExecutionFactory;
function createPythonService(procService, env) {
    const procs = (0, pythonProcess_1.createPythonProcessService)(procService, env);
    return {
        getInterpreterInformation: () => env.getInterpreterInformation(),
        getExecutablePath: () => env.getExecutablePath(),
        isModuleInstalled: (m) => env.isModuleInstalled(m),
        getModuleVersion: (m) => env.getModuleVersion(m),
        getExecutionInfo: (a) => env.getExecutionInfo(a),
        execObservable: (a, o) => procs.execObservable(a, o),
        execModuleObservable: (m, a, o) => procs.execModuleObservable(m, a, o),
        exec: (a, o) => procs.exec(a, o),
        execModule: (m, a, o) => procs.execModule(m, a, o),
        execForLinter: (m, a, o) => procs.execForLinter(m, a, o),
    };
}


/***/ }),

/***/ "./src/client/common/process/pythonProcess.ts":
/*!****************************************************!*\
  !*** ./src/client/common/process/pythonProcess.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createPythonProcessService = void 0;
const errorUtils_1 = __webpack_require__(/*! ../errors/errorUtils */ "./src/client/common/errors/errorUtils.ts");
const moduleNotInstalledError_1 = __webpack_require__(/*! ../errors/moduleNotInstalledError */ "./src/client/common/errors/moduleNotInstalledError.ts");
const internalPython = __webpack_require__(/*! ./internal/python */ "./src/client/common/process/internal/python.ts");
class PythonProcessService {
    constructor(deps) {
        this.deps = deps;
    }
    execObservable(args, options) {
        const opts = { ...options };
        const executable = this.deps.getExecutionObservableInfo(args);
        return this.deps.execObservable(executable.command, executable.args, opts);
    }
    execModuleObservable(moduleName, moduleArgs, options) {
        const args = internalPython.execModule(moduleName, moduleArgs);
        const opts = { ...options };
        const executable = this.deps.getExecutionObservableInfo(args);
        return this.deps.execObservable(executable.command, executable.args, opts);
    }
    async exec(args, options) {
        const opts = { ...options };
        const executable = this.deps.getExecutionInfo(args);
        return this.deps.exec(executable.command, executable.args, opts);
    }
    async execModule(moduleName, moduleArgs, options) {
        const args = internalPython.execModule(moduleName, moduleArgs);
        const opts = { ...options };
        const executable = this.deps.getExecutionInfo(args);
        const result = await this.deps.exec(executable.command, executable.args, opts);
        if (moduleName && errorUtils_1.ErrorUtils.outputHasModuleNotInstalledError(moduleName, result.stderr)) {
            const isInstalled = await this.deps.isModuleInstalled(moduleName);
            if (!isInstalled) {
                throw new moduleNotInstalledError_1.ModuleNotInstalledError(moduleName);
            }
        }
        return result;
    }
    async execForLinter(moduleName, args, options) {
        const opts = { ...options };
        const executable = this.deps.getExecutionInfo(args);
        const result = await this.deps.exec(executable.command, executable.args, opts);
        if (moduleName && errorUtils_1.ErrorUtils.outputHasModuleNotInstalledError(moduleName, result.stderr)) {
            const isInstalled = await this.deps.isModuleInstalled(moduleName);
            if (!isInstalled) {
                throw new moduleNotInstalledError_1.ModuleNotInstalledError(moduleName);
            }
        }
        return result;
    }
}
function createPythonProcessService(procs, env) {
    const deps = {
        isModuleInstalled: async (m) => env.isModuleInstalled(m),
        getExecutionInfo: (a) => env.getExecutionInfo(a),
        getExecutionObservableInfo: (a) => env.getExecutionObservableInfo(a),
        exec: async (f, a, o) => procs.exec(f, a, o),
        execObservable: (f, a, o) => procs.execObservable(f, a, o),
    };
    return new PythonProcessService(deps);
}
exports.createPythonProcessService = createPythonProcessService;


/***/ }),

/***/ "./src/client/common/process/pythonToolService.ts":
/*!********************************************************!*\
  !*** ./src/client/common/process/pythonToolService.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonToolExecutionService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../../ioc/types */ "./src/client/ioc/types.ts");
const types_2 = __webpack_require__(/*! ./types */ "./src/client/common/process/types.ts");
let PythonToolExecutionService = class PythonToolExecutionService {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
    }
    async execObservable(executionInfo, options, resource) {
        if (options.env) {
            throw new Error('Environment variables are not supported');
        }
        if (executionInfo.moduleName && executionInfo.moduleName.length > 0) {
            const pythonExecutionService = await this.serviceContainer
                .get(types_2.IPythonExecutionFactory)
                .create({ resource });
            return pythonExecutionService.execModuleObservable(executionInfo.moduleName, executionInfo.args, options);
        }
        else {
            const processService = await this.serviceContainer
                .get(types_2.IProcessServiceFactory)
                .create(resource);
            return processService.execObservable(executionInfo.execPath, executionInfo.args, { ...options });
        }
    }
    async exec(executionInfo, options, resource) {
        if (options.env) {
            throw new Error('Environment variables are not supported');
        }
        if (executionInfo.moduleName && executionInfo.moduleName.length > 0) {
            const pythonExecutionService = await this.serviceContainer
                .get(types_2.IPythonExecutionFactory)
                .create({ resource });
            return pythonExecutionService.execModule(executionInfo.moduleName, executionInfo.args, options);
        }
        else {
            const processService = await this.serviceContainer
                .get(types_2.IProcessServiceFactory)
                .create(resource);
            return processService.exec(executionInfo.execPath, executionInfo.args, { ...options });
        }
    }
    async execForLinter(executionInfo, options, resource) {
        if (options.env) {
            throw new Error('Environment variables are not supported');
        }
        const pythonExecutionService = await this.serviceContainer
            .get(types_2.IPythonExecutionFactory)
            .create({ resource });
        if (executionInfo.execPath) {
            return pythonExecutionService.exec(executionInfo.args, options);
        }
        return pythonExecutionService.execForLinter(executionInfo.moduleName, executionInfo.args, options);
    }
};
PythonToolExecutionService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer))
], PythonToolExecutionService);
exports.PythonToolExecutionService = PythonToolExecutionService;


/***/ }),

/***/ "./src/client/common/process/rawProcessApis.ts":
/*!*****************************************************!*\
  !*** ./src/client/common/process/rawProcessApis.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.killPid = exports.execObservable = exports.plainExec = exports.shellExec = void 0;
const child_process_1 = __webpack_require__(/*! child_process */ "child_process");
const Observable_1 = __webpack_require__(/*! rxjs/Observable */ "./node_modules/rxjs/Observable.js");
const async_1 = __webpack_require__(/*! ../utils/async */ "./src/client/common/utils/async.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/client/common/process/constants.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/common/process/types.ts");
const misc_1 = __webpack_require__(/*! ../utils/misc */ "./src/client/common/utils/misc.ts");
const decoder_1 = __webpack_require__(/*! ./decoder */ "./src/client/common/process/decoder.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const PS_ERROR_SCREEN_BOGUS = /your [0-9]+x[0-9]+ screen size is bogus\. expect trouble/;
function getDefaultOptions(options, defaultEnv) {
    const defaultOptions = { ...options };
    const execOptions = defaultOptions;
    if (execOptions) {
        execOptions.encoding =
            typeof execOptions.encoding === 'string' && execOptions.encoding.length > 0
                ? execOptions.encoding
                : constants_1.DEFAULT_ENCODING;
        const { encoding } = execOptions;
        delete execOptions.encoding;
        execOptions.encoding = encoding;
    }
    if (!defaultOptions.env || Object.keys(defaultOptions.env).length === 0) {
        const env = defaultEnv || process.env;
        defaultOptions.env = { ...env };
    }
    else {
        defaultOptions.env = { ...defaultOptions.env };
    }
    if (execOptions && execOptions.extraVariables) {
        defaultOptions.env = { ...defaultOptions.env, ...execOptions.extraVariables };
    }
    defaultOptions.env.PYTHONUNBUFFERED = '1';
    if (!defaultOptions.env.PYTHONIOENCODING) {
        defaultOptions.env.PYTHONIOENCODING = 'utf-8';
    }
    return defaultOptions;
}
function shellExec(command, options = {}, defaultEnv, disposables) {
    const shellOptions = getDefaultOptions(options, defaultEnv);
    (0, logging_1.traceVerbose)(`Shell Exec: ${command} with options: ${JSON.stringify(shellOptions, null, 4)}`);
    return new Promise((resolve, reject) => {
        const callback = (e, stdout, stderr) => {
            if (e && e !== null) {
                reject(e);
            }
            else if (shellOptions.throwOnStdErr && stderr && stderr.length) {
                reject(new Error(stderr));
            }
            else {
                stdout = filterOutputUsingCondaRunMarkers(stdout);
                resolve({ stderr: stderr && stderr.length > 0 ? stderr : undefined, stdout });
            }
        };
        const proc = (0, child_process_1.exec)(command, shellOptions, callback);
        const disposable = {
            dispose: () => {
                if (!proc.killed) {
                    proc.kill();
                }
            },
        };
        if (disposables) {
            disposables.add(disposable);
        }
    });
}
exports.shellExec = shellExec;
function plainExec(file, args, options = {}, defaultEnv, disposables) {
    var _a, _b;
    const spawnOptions = getDefaultOptions(options, defaultEnv);
    const encoding = spawnOptions.encoding ? spawnOptions.encoding : 'utf8';
    const proc = (0, child_process_1.spawn)(file, args, spawnOptions);
    (_a = proc.stdout) === null || _a === void 0 ? void 0 : _a.on('error', misc_1.noop);
    (_b = proc.stderr) === null || _b === void 0 ? void 0 : _b.on('error', misc_1.noop);
    const deferred = (0, async_1.createDeferred)();
    const disposable = {
        dispose: () => {
            if (!proc.killed) {
                proc.kill();
            }
        },
    };
    disposables === null || disposables === void 0 ? void 0 : disposables.add(disposable);
    const internalDisposables = [];
    const on = (ee, name, fn) => {
        ee === null || ee === void 0 ? void 0 : ee.on(name, fn);
        internalDisposables.push({ dispose: () => ee === null || ee === void 0 ? void 0 : ee.removeListener(name, fn) });
    };
    if (options.token) {
        internalDisposables.push(options.token.onCancellationRequested(disposable.dispose));
    }
    const stdoutBuffers = [];
    on(proc.stdout, 'data', (data) => {
        var _a;
        stdoutBuffers.push(data);
        (_a = options.outputChannel) === null || _a === void 0 ? void 0 : _a.append(data.toString());
    });
    const stderrBuffers = [];
    on(proc.stderr, 'data', (data) => {
        var _a;
        if (options.mergeStdOutErr) {
            stdoutBuffers.push(data);
            stderrBuffers.push(data);
        }
        else {
            stderrBuffers.push(data);
        }
        (_a = options.outputChannel) === null || _a === void 0 ? void 0 : _a.append(data.toString());
    });
    proc.once('close', () => {
        if (deferred.completed) {
            return;
        }
        const stderr = stderrBuffers.length === 0 ? undefined : (0, decoder_1.decodeBuffer)(stderrBuffers, encoding);
        if (stderr &&
            stderr.length > 0 &&
            options.throwOnStdErr &&
            !(PS_ERROR_SCREEN_BOGUS.test(stderr) && stderr.replace(PS_ERROR_SCREEN_BOGUS, '').trim().length === 0)) {
            deferred.reject(new types_1.StdErrError(stderr));
        }
        else {
            let stdout = (0, decoder_1.decodeBuffer)(stdoutBuffers, encoding);
            stdout = filterOutputUsingCondaRunMarkers(stdout);
            deferred.resolve({ stdout, stderr });
        }
        internalDisposables.forEach((d) => d.dispose());
        disposable.dispose();
    });
    proc.once('error', (ex) => {
        deferred.reject(ex);
        internalDisposables.forEach((d) => d.dispose());
        disposable.dispose();
    });
    return deferred.promise;
}
exports.plainExec = plainExec;
function filterOutputUsingCondaRunMarkers(stdout) {
    const regex = />>>PYTHON-EXEC-OUTPUT([\s\S]*)<<<PYTHON-EXEC-OUTPUT/;
    const match = stdout.match(regex);
    const filteredOut = match !== null && match.length >= 2 ? match[1].trim() : undefined;
    return filteredOut !== undefined ? filteredOut : stdout;
}
function removeCondaRunMarkers(out) {
    out = out.replace('>>>PYTHON-EXEC-OUTPUT\r\n', '').replace('>>>PYTHON-EXEC-OUTPUT\n', '');
    return out.replace('<<<PYTHON-EXEC-OUTPUT\r\n', '').replace('<<<PYTHON-EXEC-OUTPUT\n', '');
}
function execObservable(file, args, options = {}, defaultEnv, disposables) {
    const spawnOptions = getDefaultOptions(options, defaultEnv);
    const encoding = spawnOptions.encoding ? spawnOptions.encoding : 'utf8';
    const proc = (0, child_process_1.spawn)(file, args, spawnOptions);
    let procExited = false;
    const disposable = {
        dispose() {
            if (proc && proc.pid && !proc.killed && !procExited) {
                killPid(proc.pid);
            }
            if (proc) {
                proc.unref();
            }
        },
    };
    disposables === null || disposables === void 0 ? void 0 : disposables.add(disposable);
    const output = new Observable_1.Observable((subscriber) => {
        const internalDisposables = [];
        const on = (ee, name, fn) => {
            ee === null || ee === void 0 ? void 0 : ee.on(name, fn);
            internalDisposables.push({ dispose: () => ee === null || ee === void 0 ? void 0 : ee.removeListener(name, fn) });
        };
        if (options.token) {
            internalDisposables.push(options.token.onCancellationRequested(() => {
                if (!procExited && !proc.killed) {
                    proc.kill();
                    procExited = true;
                }
            }));
        }
        const sendOutput = (source, data) => {
            let out = (0, decoder_1.decodeBuffer)([data], encoding);
            if (source === 'stderr' && options.throwOnStdErr) {
                subscriber.error(new types_1.StdErrError(out));
            }
            else {
                out = removeCondaRunMarkers(out);
                subscriber.next({ source, out });
            }
        };
        on(proc.stdout, 'data', (data) => sendOutput('stdout', data));
        on(proc.stderr, 'data', (data) => sendOutput('stderr', data));
        proc.once('close', () => {
            procExited = true;
            subscriber.complete();
            internalDisposables.forEach((d) => d.dispose());
        });
        proc.once('exit', () => {
            procExited = true;
            subscriber.complete();
            internalDisposables.forEach((d) => d.dispose());
        });
        proc.once('error', (ex) => {
            procExited = true;
            subscriber.error(ex);
            internalDisposables.forEach((d) => d.dispose());
        });
    });
    return {
        proc,
        out: output,
        dispose: disposable.dispose,
    };
}
exports.execObservable = execObservable;
function killPid(pid) {
    try {
        if (process.platform === 'win32') {
            (0, child_process_1.execSync)(`taskkill /pid ${pid} /T /F`);
        }
        else {
            process.kill(pid);
        }
    }
    catch (_a) {
    }
}
exports.killPid = killPid;


/***/ }),

/***/ "./src/client/common/process/serviceRegistry.ts":
/*!******************************************************!*\
  !*** ./src/client/common/process/serviceRegistry.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const processFactory_1 = __webpack_require__(/*! ./processFactory */ "./src/client/common/process/processFactory.ts");
const pythonExecutionFactory_1 = __webpack_require__(/*! ./pythonExecutionFactory */ "./src/client/common/process/pythonExecutionFactory.ts");
const pythonToolService_1 = __webpack_require__(/*! ./pythonToolService */ "./src/client/common/process/pythonToolService.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/common/process/types.ts");
function registerTypes(serviceManager) {
    serviceManager.addSingleton(types_1.IProcessServiceFactory, processFactory_1.ProcessServiceFactory);
    serviceManager.addSingleton(types_1.IPythonExecutionFactory, pythonExecutionFactory_1.PythonExecutionFactory);
    serviceManager.addSingleton(types_1.IPythonToolExecutionService, pythonToolService_1.PythonToolExecutionService);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/client/common/process/types.ts":
/*!********************************************!*\
  !*** ./src/client/common/process/types.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IPythonToolExecutionService = exports.StdErrError = exports.IPythonExecutionService = exports.IPythonExecutionFactory = exports.IProcessServiceFactory = exports.IProcessLogger = void 0;
exports.IProcessLogger = Symbol('IProcessLogger');
exports.IProcessServiceFactory = Symbol('IProcessServiceFactory');
exports.IPythonExecutionFactory = Symbol('IPythonExecutionFactory');
exports.IPythonExecutionService = Symbol('IPythonExecutionService');
class StdErrError extends Error {
    constructor(message) {
        super(message);
    }
}
exports.StdErrError = StdErrError;
exports.IPythonToolExecutionService = Symbol('IPythonToolRunnerService');


/***/ }),

/***/ "./src/client/common/serviceRegistry.ts":
/*!**********************************************!*\
  !*** ./src/client/common/serviceRegistry.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const types_1 = __webpack_require__(/*! ../activation/types */ "./src/client/activation/types.ts");
const types_2 = __webpack_require__(/*! ./types */ "./src/client/common/types.ts");
const activeResource_1 = __webpack_require__(/*! ./application/activeResource */ "./src/client/common/application/activeResource.ts");
const applicationEnvironment_1 = __webpack_require__(/*! ./application/applicationEnvironment */ "./src/client/common/application/applicationEnvironment.ts");
const applicationShell_1 = __webpack_require__(/*! ./application/applicationShell */ "./src/client/common/application/applicationShell.ts");
const commandManager_1 = __webpack_require__(/*! ./application/commandManager */ "./src/client/common/application/commandManager.ts");
const documentManager_1 = __webpack_require__(/*! ./application/documentManager */ "./src/client/common/application/documentManager.ts");
const terminalManager_1 = __webpack_require__(/*! ./application/terminalManager */ "./src/client/common/application/terminalManager.ts");
const types_3 = __webpack_require__(/*! ./application/types */ "./src/client/common/application/types.ts");
const workspace_1 = __webpack_require__(/*! ./application/workspace */ "./src/client/common/application/workspace.ts");
const service_1 = __webpack_require__(/*! ./configuration/service */ "./src/client/common/configuration/service.ts");
const pipEnvExecution_1 = __webpack_require__(/*! ./configuration/executionSettings/pipEnvExecution */ "./src/client/common/configuration/executionSettings/pipEnvExecution.ts");
const editor_1 = __webpack_require__(/*! ./editor */ "./src/client/common/editor.ts");
const persistentState_1 = __webpack_require__(/*! ./persistentState */ "./src/client/common/persistentState.ts");
const pathUtils_1 = __webpack_require__(/*! ./platform/pathUtils */ "./src/client/common/platform/pathUtils.ts");
const currentProcess_1 = __webpack_require__(/*! ./process/currentProcess */ "./src/client/common/process/currentProcess.ts");
const logger_1 = __webpack_require__(/*! ./process/logger */ "./src/client/common/process/logger.ts");
const types_4 = __webpack_require__(/*! ./process/types */ "./src/client/common/process/types.ts");
const activator_1 = __webpack_require__(/*! ./terminal/activator */ "./src/client/common/terminal/activator/index.ts");
const bash_1 = __webpack_require__(/*! ./terminal/environmentActivationProviders/bash */ "./src/client/common/terminal/environmentActivationProviders/bash.ts");
const nushell_1 = __webpack_require__(/*! ./terminal/environmentActivationProviders/nushell */ "./src/client/common/terminal/environmentActivationProviders/nushell.ts");
const commandPrompt_1 = __webpack_require__(/*! ./terminal/environmentActivationProviders/commandPrompt */ "./src/client/common/terminal/environmentActivationProviders/commandPrompt.ts");
const condaActivationProvider_1 = __webpack_require__(/*! ./terminal/environmentActivationProviders/condaActivationProvider */ "./src/client/common/terminal/environmentActivationProviders/condaActivationProvider.ts");
const pipEnvActivationProvider_1 = __webpack_require__(/*! ./terminal/environmentActivationProviders/pipEnvActivationProvider */ "./src/client/common/terminal/environmentActivationProviders/pipEnvActivationProvider.ts");
const pyenvActivationProvider_1 = __webpack_require__(/*! ./terminal/environmentActivationProviders/pyenvActivationProvider */ "./src/client/common/terminal/environmentActivationProviders/pyenvActivationProvider.ts");
const factory_1 = __webpack_require__(/*! ./terminal/factory */ "./src/client/common/terminal/factory.ts");
const helper_1 = __webpack_require__(/*! ./terminal/helper */ "./src/client/common/terminal/helper.ts");
const settingsShellDetector_1 = __webpack_require__(/*! ./terminal/shellDetectors/settingsShellDetector */ "./src/client/common/terminal/shellDetectors/settingsShellDetector.ts");
const terminalNameShellDetector_1 = __webpack_require__(/*! ./terminal/shellDetectors/terminalNameShellDetector */ "./src/client/common/terminal/shellDetectors/terminalNameShellDetector.ts");
const userEnvironmentShellDetector_1 = __webpack_require__(/*! ./terminal/shellDetectors/userEnvironmentShellDetector */ "./src/client/common/terminal/shellDetectors/userEnvironmentShellDetector.ts");
const vscEnvironmentShellDetector_1 = __webpack_require__(/*! ./terminal/shellDetectors/vscEnvironmentShellDetector */ "./src/client/common/terminal/shellDetectors/vscEnvironmentShellDetector.ts");
const types_5 = __webpack_require__(/*! ./terminal/types */ "./src/client/common/terminal/types.ts");
const multiStepInput_1 = __webpack_require__(/*! ./utils/multiStepInput */ "./src/client/common/utils/multiStepInput.ts");
const random_1 = __webpack_require__(/*! ./utils/random */ "./src/client/common/utils/random.ts");
const platformService_1 = __webpack_require__(/*! ./platform/platformService */ "./src/client/common/platform/platformService.ts");
function registerTypes(serviceManager) {
    serviceManager.addSingletonInstance(types_2.IsWindows, (0, platformService_1.isWindows)());
    serviceManager.addSingleton(types_3.IActiveResourceService, activeResource_1.ActiveResourceService);
    serviceManager.addSingleton(types_2.IRandom, random_1.Random);
    serviceManager.addSingleton(types_2.IPersistentStateFactory, persistentState_1.PersistentStateFactory);
    serviceManager.addBinding(types_2.IPersistentStateFactory, types_1.IExtensionSingleActivationService);
    serviceManager.addSingleton(types_5.ITerminalServiceFactory, factory_1.TerminalServiceFactory);
    serviceManager.addSingleton(types_2.IPathUtils, pathUtils_1.PathUtils);
    serviceManager.addSingleton(types_3.IApplicationShell, applicationShell_1.ApplicationShell);
    serviceManager.addSingleton(types_2.ICurrentProcess, currentProcess_1.CurrentProcess);
    serviceManager.addSingleton(types_3.ICommandManager, commandManager_1.CommandManager);
    serviceManager.addSingleton(types_2.IConfigurationService, service_1.ConfigurationService);
    serviceManager.addSingleton(types_3.IWorkspaceService, workspace_1.WorkspaceService);
    serviceManager.addSingleton(types_4.IProcessLogger, logger_1.ProcessLogger);
    serviceManager.addSingleton(types_3.IDocumentManager, documentManager_1.DocumentManager);
    serviceManager.addSingleton(types_3.ITerminalManager, terminalManager_1.TerminalManager);
    serviceManager.addSingleton(types_3.IApplicationEnvironment, applicationEnvironment_1.ApplicationEnvironment);
    serviceManager.addSingleton(types_2.IEditorUtils, editor_1.EditorUtils);
    serviceManager.addSingleton(types_5.ITerminalActivator, activator_1.TerminalActivator);
    serviceManager.addSingleton(types_5.ITerminalHelper, helper_1.TerminalHelper);
    serviceManager.addSingleton(types_5.ITerminalActivationCommandProvider, bash_1.Bash, types_5.TerminalActivationProviders.bashCShellFish);
    serviceManager.addSingleton(types_5.ITerminalActivationCommandProvider, commandPrompt_1.CommandPromptAndPowerShell, types_5.TerminalActivationProviders.commandPromptAndPowerShell);
    serviceManager.addSingleton(types_5.ITerminalActivationCommandProvider, nushell_1.Nushell, types_5.TerminalActivationProviders.nushell);
    serviceManager.addSingleton(types_5.ITerminalActivationCommandProvider, pyenvActivationProvider_1.PyEnvActivationCommandProvider, types_5.TerminalActivationProviders.pyenv);
    serviceManager.addSingleton(types_5.ITerminalActivationCommandProvider, condaActivationProvider_1.CondaActivationCommandProvider, types_5.TerminalActivationProviders.conda);
    serviceManager.addSingleton(types_5.ITerminalActivationCommandProvider, pipEnvActivationProvider_1.PipEnvActivationCommandProvider, types_5.TerminalActivationProviders.pipenv);
    serviceManager.addSingleton(types_2.IToolExecutionPath, pipEnvExecution_1.PipEnvExecutionPath, types_2.ToolExecutionPath.pipenv);
    serviceManager.addSingleton(multiStepInput_1.IMultiStepInputFactory, multiStepInput_1.MultiStepInputFactory);
    serviceManager.addSingleton(types_5.IShellDetector, terminalNameShellDetector_1.TerminalNameShellDetector);
    serviceManager.addSingleton(types_5.IShellDetector, settingsShellDetector_1.SettingsShellDetector);
    serviceManager.addSingleton(types_5.IShellDetector, userEnvironmentShellDetector_1.UserEnvironmentShellDetector);
    serviceManager.addSingleton(types_5.IShellDetector, vscEnvironmentShellDetector_1.VSCEnvironmentShellDetector);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/client/common/stringUtils.ts":
/*!******************************************!*\
  !*** ./src/client/common/stringUtils.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.replaceAll = exports.splitLines = void 0;
function splitLines(source, splitOptions = { removeEmptyEntries: true, trim: true }) {
    let lines = source.split(/\r?\n/g);
    if (splitOptions === null || splitOptions === void 0 ? void 0 : splitOptions.trim) {
        lines = lines.map((line) => line.trim());
    }
    if (splitOptions === null || splitOptions === void 0 ? void 0 : splitOptions.removeEmptyEntries) {
        lines = lines.filter((line) => line.length > 0);
    }
    return lines;
}
exports.splitLines = splitLines;
function replaceAll(source, substr, newSubstr) {
    if (!source) {
        return source;
    }
    function escapeRegExp(unescapedStr) {
        return unescapedStr.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    }
    return source.replace(new RegExp(escapeRegExp(substr), 'g'), newSubstr);
}
exports.replaceAll = replaceAll;


/***/ }),

/***/ "./src/client/common/terminal/activator/base.ts":
/*!******************************************************!*\
  !*** ./src/client/common/terminal/activator/base.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseTerminalActivator = void 0;
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const async_1 = __webpack_require__(/*! ../../utils/async */ "./src/client/common/utils/async.ts");
class BaseTerminalActivator {
    constructor(helper) {
        this.helper = helper;
        this.activatedTerminals = new Map();
    }
    async activateEnvironmentInTerminal(terminal, options) {
        if (this.activatedTerminals.has(terminal)) {
            return this.activatedTerminals.get(terminal);
        }
        const deferred = (0, async_1.createDeferred)();
        this.activatedTerminals.set(terminal, deferred.promise);
        const terminalShellType = this.helper.identifyTerminalShell(terminal);
        const activationCommands = await this.helper.getEnvironmentActivationCommands(terminalShellType, options === null || options === void 0 ? void 0 : options.resource, options === null || options === void 0 ? void 0 : options.interpreter);
        let activated = false;
        if (activationCommands) {
            for (const command of activationCommands) {
                terminal.show(options === null || options === void 0 ? void 0 : options.preserveFocus);
                (0, logging_1.traceVerbose)(`Command sent to terminal: ${command}`);
                terminal.sendText(command);
                await this.waitForCommandToProcess(terminalShellType);
                activated = true;
            }
        }
        deferred.resolve(activated);
        return activated;
    }
    async waitForCommandToProcess(_shell) {
        await (0, async_1.sleep)(500);
    }
}
exports.BaseTerminalActivator = BaseTerminalActivator;


/***/ }),

/***/ "./src/client/common/terminal/activator/index.ts":
/*!*******************************************************!*\
  !*** ./src/client/common/terminal/activator/index.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalActivator = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const base_1 = __webpack_require__(/*! ./base */ "./src/client/common/terminal/activator/base.ts");
let TerminalActivator = class TerminalActivator {
    constructor(helper) {
        this.helper = helper;
        this.pendingActivations = new WeakMap();
        this.initialize();
    }
    async activateEnvironmentInTerminal(terminal, options) {
        let promise = this.pendingActivations.get(terminal);
        if (promise) {
            return promise;
        }
        promise = this.activateEnvironmentInTerminalImpl(terminal, options);
        this.pendingActivations.set(terminal, promise);
        return promise;
    }
    async activateEnvironmentInTerminalImpl(_terminal, _options) {
        return false;
    }
    initialize() {
        this.baseActivator = new base_1.BaseTerminalActivator(this.helper);
    }
};
TerminalActivator = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.ITerminalHelper))
], TerminalActivator);
exports.TerminalActivator = TerminalActivator;


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/baseActivationProvider.ts":
/*!*********************************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/baseActivationProvider.ts ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VenvBaseActivationCommandProvider = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const contracts_1 = __webpack_require__(/*! ../../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const types_1 = __webpack_require__(/*! ../../../ioc/types */ "./src/client/ioc/types.ts");
const types_2 = __webpack_require__(/*! ../../platform/types */ "./src/client/common/platform/types.ts");
function getVenvExecutableFinder(basename, pathDirname, pathJoin, fileExists) {
    const basenames = typeof basename === 'string' ? [basename] : basename;
    return async (python) => {
        const binDir = pathDirname(python);
        for (const name of basenames) {
            const filename = pathJoin(binDir, name);
            if (await fileExists(filename)) {
                return filename;
            }
        }
        return undefined;
    };
}
let BaseActivationCommandProvider = class BaseActivationCommandProvider {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
    }
    async getActivationCommands(resource, targetShell) {
        const interpreter = await this.serviceContainer
            .get(contracts_1.IInterpreterService)
            .getActiveInterpreter(resource);
        if (!interpreter) {
            return undefined;
        }
        return this.getActivationCommandsForInterpreter(interpreter.path, targetShell);
    }
};
BaseActivationCommandProvider = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer))
], BaseActivationCommandProvider);
class VenvBaseActivationCommandProvider extends BaseActivationCommandProvider {
    isShellSupported(targetShell) {
        return this.scripts[targetShell] !== undefined;
    }
    async findScriptFile(pythonPath, targetShell) {
        const fs = this.serviceContainer.get(types_2.IFileSystem);
        const candidates = this.scripts[targetShell];
        if (!candidates) {
            return undefined;
        }
        const findScript = getVenvExecutableFinder(candidates, path.dirname, path.join, (n) => fs.fileExists(n));
        return findScript(pythonPath);
    }
}
exports.VenvBaseActivationCommandProvider = VenvBaseActivationCommandProvider;


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/bash.ts":
/*!***************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/bash.ts ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Bash = exports.getAllScripts = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
__webpack_require__(/*! ../../extensions */ "./src/client/common/extensions.ts");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseActivationProvider_1 = __webpack_require__(/*! ./baseActivationProvider */ "./src/client/common/terminal/environmentActivationProviders/baseActivationProvider.ts");
const SCRIPTS = {
    [types_1.TerminalShellType.wsl]: ['activate.sh', 'activate'],
    [types_1.TerminalShellType.ksh]: ['activate.sh', 'activate'],
    [types_1.TerminalShellType.zsh]: ['activate.sh', 'activate'],
    [types_1.TerminalShellType.gitbash]: ['activate.sh', 'activate'],
    [types_1.TerminalShellType.bash]: ['activate.sh', 'activate'],
    [types_1.TerminalShellType.tcshell]: ['activate.csh'],
    [types_1.TerminalShellType.cshell]: ['activate.csh'],
    [types_1.TerminalShellType.fish]: ['activate.fish'],
};
function getAllScripts() {
    const scripts = [];
    for (const names of Object.values(SCRIPTS)) {
        for (const name of names) {
            if (!scripts.includes(name)) {
                scripts.push(name);
            }
        }
    }
    return scripts;
}
exports.getAllScripts = getAllScripts;
let Bash = class Bash extends baseActivationProvider_1.VenvBaseActivationCommandProvider {
    constructor() {
        super(...arguments);
        this.scripts = SCRIPTS;
    }
    async getActivationCommandsForInterpreter(pythonPath, targetShell) {
        const scriptFile = await this.findScriptFile(pythonPath, targetShell);
        if (!scriptFile) {
            return undefined;
        }
        return [`source ${scriptFile.fileToCommandArgumentForPythonMgrExt()}`];
    }
};
Bash = __decorate([
    (0, inversify_1.injectable)()
], Bash);
exports.Bash = Bash;


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/commandPrompt.ts":
/*!************************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/commandPrompt.ts ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandPromptAndPowerShell = exports.getAllScripts = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const types_1 = __webpack_require__(/*! ../../../ioc/types */ "./src/client/ioc/types.ts");
__webpack_require__(/*! ../../extensions */ "./src/client/common/extensions.ts");
const types_2 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseActivationProvider_1 = __webpack_require__(/*! ./baseActivationProvider */ "./src/client/common/terminal/environmentActivationProviders/baseActivationProvider.ts");
const SCRIPTS = {
    [types_2.TerminalShellType.commandPrompt]: ['activate.bat', 'Activate.ps1'],
    [types_2.TerminalShellType.powershell]: ['Activate.ps1', 'activate.bat'],
    [types_2.TerminalShellType.powershellCore]: ['Activate.ps1', 'activate.bat'],
};
function getAllScripts(pathJoin) {
    const scripts = [];
    for (const names of Object.values(SCRIPTS)) {
        for (const name of names) {
            if (!scripts.includes(name)) {
                scripts.push(name, pathJoin('Scripts', name), pathJoin('scripts', name));
            }
        }
    }
    return scripts;
}
exports.getAllScripts = getAllScripts;
let CommandPromptAndPowerShell = class CommandPromptAndPowerShell extends baseActivationProvider_1.VenvBaseActivationCommandProvider {
    constructor(serviceContainer) {
        super(serviceContainer);
        this.scripts = {};
        for (const [key, names] of Object.entries(SCRIPTS)) {
            const shell = key;
            const scripts = [];
            for (const name of names) {
                scripts.push(name, path.join('Scripts', name), path.join('scripts', name));
            }
            this.scripts[shell] = scripts;
        }
    }
    async getActivationCommandsForInterpreter(pythonPath, targetShell) {
        const scriptFile = await this.findScriptFile(pythonPath, targetShell);
        if (!scriptFile) {
            return undefined;
        }
        if (targetShell === types_2.TerminalShellType.commandPrompt && scriptFile.endsWith('activate.bat')) {
            return [scriptFile.fileToCommandArgumentForPythonMgrExt()];
        }
        if ((targetShell === types_2.TerminalShellType.powershell || targetShell === types_2.TerminalShellType.powershellCore) &&
            scriptFile.endsWith('Activate.ps1')) {
            return [`& ${scriptFile.fileToCommandArgumentForPythonMgrExt()}`];
        }
        if (targetShell === types_2.TerminalShellType.commandPrompt && scriptFile.endsWith('Activate.ps1')) {
            return [];
        }
        return undefined;
    }
};
CommandPromptAndPowerShell = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer))
], CommandPromptAndPowerShell);
exports.CommandPromptAndPowerShell = CommandPromptAndPowerShell;


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/condaActivationProvider.ts":
/*!**********************************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/condaActivationProvider.ts ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._getPowershellCommands = exports.CondaActivationCommandProvider = void 0;
__webpack_require__(/*! ../../extensions */ "./src/client/common/extensions.ts");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const contracts_1 = __webpack_require__(/*! ../../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const types_1 = __webpack_require__(/*! ../../platform/types */ "./src/client/common/platform/types.ts");
const types_2 = __webpack_require__(/*! ../../types */ "./src/client/common/types.ts");
const types_3 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
let CondaActivationCommandProvider = class CondaActivationCommandProvider {
    constructor(condaService, platform, configService, pyenvs) {
        this.condaService = condaService;
        this.platform = platform;
        this.configService = configService;
        this.pyenvs = pyenvs;
    }
    isShellSupported() {
        return true;
    }
    getActivationCommands(resource, targetShell) {
        const { pythonPath } = this.configService.getSettings(resource);
        return this.getActivationCommandsForInterpreter(pythonPath, targetShell);
    }
    async getActivationCommandsForInterpreter(pythonPath, targetShell) {
        const envInfo = await this.pyenvs.getCondaEnvironment(pythonPath);
        if (!envInfo) {
            return undefined;
        }
        const condaEnv = envInfo.name.length > 0 ? envInfo.name : envInfo.path;
        const interpreterPath = await this.condaService.getInterpreterPathForEnvironment(envInfo);
        const activatePath = await this.condaService.getActivationScriptFromInterpreter(interpreterPath, envInfo.name);
        if (activatePath === null || activatePath === void 0 ? void 0 : activatePath.path) {
            if (this.platform.isWindows &&
                targetShell !== types_3.TerminalShellType.bash &&
                targetShell !== types_3.TerminalShellType.gitbash) {
                return [activatePath.path, `conda activate ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
            }
            const condaInfo = await this.condaService.getCondaInfo();
            if (activatePath.type !== 'global' ||
                (condaInfo === null || condaInfo === void 0 ? void 0 : condaInfo.conda_shlvl) === undefined ||
                condaInfo.conda_shlvl === -1) {
                if (activatePath.path === 'activate') {
                    return [
                        `source ${activatePath.path}`,
                        `conda activate ${condaEnv.toCommandArgumentForPythonMgrExt()}`,
                    ];
                }
                return [`source ${activatePath.path} ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
            }
            return [`conda activate ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
        }
        switch (targetShell) {
            case types_3.TerminalShellType.powershell:
            case types_3.TerminalShellType.powershellCore:
                return _getPowershellCommands(condaEnv);
            case types_3.TerminalShellType.fish:
                return getFishCommands(condaEnv, await this.condaService.getCondaFile());
            default:
                if (this.platform.isWindows) {
                    return this.getWindowsCommands(condaEnv);
                }
                return getUnixCommands(condaEnv, await this.condaService.getCondaFile());
        }
    }
    async getWindowsActivateCommand() {
        let activateCmd = 'activate';
        const condaExePath = await this.condaService.getCondaFile();
        if (condaExePath && path.basename(condaExePath) !== condaExePath) {
            const condaScriptsPath = path.dirname(condaExePath);
            activateCmd = path.join(condaScriptsPath, activateCmd);
            activateCmd = activateCmd.toCommandArgumentForPythonMgrExt();
        }
        return activateCmd;
    }
    async getWindowsCommands(condaEnv) {
        const activate = await this.getWindowsActivateCommand();
        return [`${activate} ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
    }
};
CondaActivationCommandProvider = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(contracts_1.ICondaService)),
    __param(1, (0, inversify_1.inject)(types_1.IPlatformService)),
    __param(2, (0, inversify_1.inject)(types_2.IConfigurationService)),
    __param(3, (0, inversify_1.inject)(contracts_1.IComponentAdapter))
], CondaActivationCommandProvider);
exports.CondaActivationCommandProvider = CondaActivationCommandProvider;
async function _getPowershellCommands(condaEnv) {
    return [`conda activate ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
}
exports._getPowershellCommands = _getPowershellCommands;
async function getFishCommands(condaEnv, condaFile) {
    return [`${condaFile.fileToCommandArgumentForPythonMgrExt()} activate ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
}
async function getUnixCommands(condaEnv, condaFile) {
    const condaDir = path.dirname(condaFile);
    const activateFile = path.join(condaDir, 'activate');
    return [`source ${activateFile.fileToCommandArgumentForPythonMgrExt()} ${condaEnv.toCommandArgumentForPythonMgrExt()}`];
}


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/nushell.ts":
/*!******************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/nushell.ts ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Nushell = exports.getAllScripts = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
__webpack_require__(/*! ../../extensions */ "./src/client/common/extensions.ts");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseActivationProvider_1 = __webpack_require__(/*! ./baseActivationProvider */ "./src/client/common/terminal/environmentActivationProviders/baseActivationProvider.ts");
const SCRIPTS = {
    [types_1.TerminalShellType.nushell]: ['activate.nu'],
};
function getAllScripts() {
    const scripts = [];
    for (const names of Object.values(SCRIPTS)) {
        for (const name of names) {
            if (!scripts.includes(name)) {
                scripts.push(name);
            }
        }
    }
    return scripts;
}
exports.getAllScripts = getAllScripts;
let Nushell = class Nushell extends baseActivationProvider_1.VenvBaseActivationCommandProvider {
    constructor() {
        super(...arguments);
        this.scripts = SCRIPTS;
    }
    async getActivationCommandsForInterpreter(pythonPath, targetShell) {
        const scriptFile = await this.findScriptFile(pythonPath, targetShell);
        if (!scriptFile) {
            return undefined;
        }
        return [`overlay use ${scriptFile.fileToCommandArgumentForPythonMgrExt()}`];
    }
};
Nushell = __decorate([
    (0, inversify_1.injectable)()
], Nushell);
exports.Nushell = Nushell;


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/pipEnvActivationProvider.ts":
/*!***********************************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/pipEnvActivationProvider.ts ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PipEnvActivationCommandProvider = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
__webpack_require__(/*! ../../extensions */ "./src/client/common/extensions.ts");
const contracts_1 = __webpack_require__(/*! ../../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const pipenv_1 = __webpack_require__(/*! ../../../pythonEnvironments/common/environmentManagers/pipenv */ "./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts");
const info_1 = __webpack_require__(/*! ../../../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const types_1 = __webpack_require__(/*! ../../application/types */ "./src/client/common/application/types.ts");
const types_2 = __webpack_require__(/*! ../../types */ "./src/client/common/types.ts");
let PipEnvActivationCommandProvider = class PipEnvActivationCommandProvider {
    constructor(interpreterService, pipEnvExecution, workspaceService) {
        this.interpreterService = interpreterService;
        this.pipEnvExecution = pipEnvExecution;
        this.workspaceService = workspaceService;
    }
    isShellSupported() {
        return false;
    }
    async getActivationCommands(resource) {
        const interpreter = await this.interpreterService.getActiveInterpreter(resource);
        if (!interpreter || interpreter.envType !== info_1.EnvironmentType.Pipenv) {
            return undefined;
        }
        const workspaceFolder = resource ? this.workspaceService.getWorkspaceFolder(resource) : undefined;
        if (workspaceFolder) {
            if (!(await (0, pipenv_1.isPipenvEnvironmentRelatedToFolder)(interpreter.path, workspaceFolder === null || workspaceFolder === void 0 ? void 0 : workspaceFolder.uri.fsPath))) {
                return undefined;
            }
        }
        const execName = this.pipEnvExecution.executable;
        return [`${execName.fileToCommandArgumentForPythonMgrExt()} shell`];
    }
    async getActivationCommandsForInterpreter(pythonPath) {
        const interpreter = await this.interpreterService.getInterpreterDetails(pythonPath);
        if (!interpreter || interpreter.envType !== info_1.EnvironmentType.Pipenv) {
            return undefined;
        }
        const execName = this.pipEnvExecution.executable;
        return [`${execName.fileToCommandArgumentForPythonMgrExt()} shell`];
    }
};
PipEnvActivationCommandProvider = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(contracts_1.IInterpreterService)),
    __param(1, (0, inversify_1.inject)(types_2.IToolExecutionPath)),
    __param(1, (0, inversify_1.named)(types_2.ToolExecutionPath.pipenv)),
    __param(2, (0, inversify_1.inject)(types_1.IWorkspaceService))
], PipEnvActivationCommandProvider);
exports.PipEnvActivationCommandProvider = PipEnvActivationCommandProvider;


/***/ }),

/***/ "./src/client/common/terminal/environmentActivationProviders/pyenvActivationProvider.ts":
/*!**********************************************************************************************!*\
  !*** ./src/client/common/terminal/environmentActivationProviders/pyenvActivationProvider.ts ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PyEnvActivationCommandProvider = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const contracts_1 = __webpack_require__(/*! ../../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const types_1 = __webpack_require__(/*! ../../../ioc/types */ "./src/client/ioc/types.ts");
const info_1 = __webpack_require__(/*! ../../../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
let PyEnvActivationCommandProvider = class PyEnvActivationCommandProvider {
    constructor(serviceContainer) {
        this.serviceContainer = serviceContainer;
    }
    isShellSupported(_targetShell) {
        return true;
    }
    async getActivationCommands(resource, _) {
        const interpreter = await this.serviceContainer
            .get(contracts_1.IInterpreterService)
            .getActiveInterpreter(resource);
        if (!interpreter || interpreter.envType !== info_1.EnvironmentType.Pyenv || !interpreter.envName) {
            return undefined;
        }
        return [`pyenv shell ${interpreter.envName.toCommandArgumentForPythonMgrExt()}`];
    }
    async getActivationCommandsForInterpreter(pythonPath, _targetShell) {
        const interpreter = await this.serviceContainer
            .get(contracts_1.IInterpreterService)
            .getInterpreterDetails(pythonPath);
        if (!interpreter || interpreter.envType !== info_1.EnvironmentType.Pyenv || !interpreter.envName) {
            return undefined;
        }
        return [`pyenv shell ${interpreter.envName.toCommandArgumentForPythonMgrExt()}`];
    }
};
PyEnvActivationCommandProvider = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer))
], PyEnvActivationCommandProvider);
exports.PyEnvActivationCommandProvider = PyEnvActivationCommandProvider;


/***/ }),

/***/ "./src/client/common/terminal/factory.ts":
/*!***********************************************!*\
  !*** ./src/client/common/terminal/factory.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalServiceFactory = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const contracts_1 = __webpack_require__(/*! ../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const types_1 = __webpack_require__(/*! ../../ioc/types */ "./src/client/ioc/types.ts");
const types_2 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
const types_3 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const service_1 = __webpack_require__(/*! ./service */ "./src/client/common/terminal/service.ts");
const syncTerminalService_1 = __webpack_require__(/*! ./syncTerminalService */ "./src/client/common/terminal/syncTerminalService.ts");
let TerminalServiceFactory = class TerminalServiceFactory {
    constructor(serviceContainer, fs, interpreterService) {
        this.serviceContainer = serviceContainer;
        this.fs = fs;
        this.interpreterService = interpreterService;
        this.terminalServices = new Map();
    }
    getTerminalService(options) {
        const resource = options === null || options === void 0 ? void 0 : options.resource;
        const title = options === null || options === void 0 ? void 0 : options.title;
        let terminalTitle = typeof title === 'string' && title.trim().length > 0 ? title.trim() : 'Python';
        const interpreter = options === null || options === void 0 ? void 0 : options.interpreter;
        const id = this.getTerminalId(terminalTitle, resource, interpreter, options.newTerminalPerFile);
        if (!this.terminalServices.has(id)) {
            if (resource && options.newTerminalPerFile) {
                terminalTitle = `${terminalTitle}: ${path.basename(resource.fsPath).replace('.py', '')}`;
            }
            options.title = terminalTitle;
            const terminalService = new service_1.TerminalService(this.serviceContainer, options);
            this.terminalServices.set(id, terminalService);
        }
        return new syncTerminalService_1.SynchronousTerminalService(this.fs, this.interpreterService, this.terminalServices.get(id), interpreter);
    }
    createTerminalService(resource, title) {
        title = typeof title === 'string' && title.trim().length > 0 ? title.trim() : 'Python';
        return new service_1.TerminalService(this.serviceContainer, { resource, title });
    }
    getTerminalId(title, resource, interpreter, newTerminalPerFile) {
        if (!resource && !interpreter) {
            return title;
        }
        const workspaceFolder = this.serviceContainer
            .get(types_2.IWorkspaceService)
            .getWorkspaceFolder(resource || undefined);
        const fileId = resource && newTerminalPerFile ? resource.fsPath : '';
        return `${title}:${(workspaceFolder === null || workspaceFolder === void 0 ? void 0 : workspaceFolder.uri.fsPath) || ''}:${interpreter === null || interpreter === void 0 ? void 0 : interpreter.path}:${fileId}`;
    }
};
TerminalServiceFactory = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer)),
    __param(1, (0, inversify_1.inject)(types_3.IFileSystem)),
    __param(2, (0, inversify_1.inject)(contracts_1.IInterpreterService))
], TerminalServiceFactory);
exports.TerminalServiceFactory = TerminalServiceFactory;


/***/ }),

/***/ "./src/client/common/terminal/helper.ts":
/*!**********************************************!*\
  !*** ./src/client/common/terminal/helper.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalHelper = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const contracts_1 = __webpack_require__(/*! ../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const types_1 = __webpack_require__(/*! ../../ioc/types */ "./src/client/ioc/types.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const telemetry_1 = __webpack_require__(/*! ../../telemetry */ "./src/client/telemetry/index.ts");
const constants_1 = __webpack_require__(/*! ../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const types_2 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
__webpack_require__(/*! ../extensions */ "./src/client/common/extensions.ts");
const types_3 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const types_4 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
const shellDetector_1 = __webpack_require__(/*! ./shellDetector */ "./src/client/common/terminal/shellDetector.ts");
const types_5 = __webpack_require__(/*! ./types */ "./src/client/common/terminal/types.ts");
let TerminalHelper = class TerminalHelper {
    constructor(platform, terminalManager, serviceContainer, interpreterService, configurationService, conda, bashCShellFish, commandPromptAndPowerShell, nushell, pyenv, pipenv, shellDetectors) {
        this.platform = platform;
        this.terminalManager = terminalManager;
        this.serviceContainer = serviceContainer;
        this.interpreterService = interpreterService;
        this.configurationService = configurationService;
        this.conda = conda;
        this.bashCShellFish = bashCShellFish;
        this.commandPromptAndPowerShell = commandPromptAndPowerShell;
        this.nushell = nushell;
        this.pyenv = pyenv;
        this.pipenv = pipenv;
        this.shellDetector = new shellDetector_1.ShellDetector(this.platform, shellDetectors);
    }
    createTerminal(title) {
        return this.terminalManager.createTerminal({ name: title });
    }
    identifyTerminalShell(terminal) {
        return this.shellDetector.identifyTerminalShell(terminal);
    }
    buildCommandForTerminal(terminalShellType, command, args) {
        const isPowershell = terminalShellType === types_5.TerminalShellType.powershell ||
            terminalShellType === types_5.TerminalShellType.powershellCore;
        const commandPrefix = isPowershell ? '& ' : '';
        const formattedArgs = args.map((a) => a.toCommandArgumentForPythonMgrExt());
        return `${commandPrefix}${command.fileToCommandArgumentForPythonMgrExt()} ${formattedArgs.join(' ')}`.trim();
    }
    async getEnvironmentActivationCommands(terminalShellType, resource, interpreter) {
        const providers = [this.pipenv, this.pyenv, this.bashCShellFish, this.commandPromptAndPowerShell, this.nushell];
        const promise = this.getActivationCommands(resource || undefined, interpreter, terminalShellType, providers);
        this.sendTelemetry(terminalShellType, constants_1.EventName.PYTHON_INTERPRETER_ACTIVATION_FOR_TERMINAL, interpreter, promise).ignoreErrors();
        return promise;
    }
    async getEnvironmentActivationShellCommands(resource, shell, interpreter) {
        if (this.platform.osType === platform_1.OSType.Unknown) {
            return;
        }
        const providers = [this.bashCShellFish, this.commandPromptAndPowerShell, this.nushell];
        const promise = this.getActivationCommands(resource, interpreter, shell, providers);
        this.sendTelemetry(shell, constants_1.EventName.PYTHON_INTERPRETER_ACTIVATION_FOR_RUNNING_CODE, interpreter, promise).ignoreErrors();
        return promise;
    }
    async sendTelemetry(terminalShellType, eventName, interpreter, promise) {
        let hasCommands = false;
        let failed = false;
        try {
            const cmds = await promise;
            hasCommands = Array.isArray(cmds) && cmds.length > 0;
        }
        catch (ex) {
            failed = true;
            (0, logging_1.traceError)('Failed to get activation commands', ex);
        }
        const pythonVersion = interpreter && interpreter.version ? interpreter.version.raw : undefined;
        const interpreterType = interpreter ? interpreter.envType : info_1.EnvironmentType.Unknown;
        const data = { failed, hasCommands, interpreterType, terminal: terminalShellType, pythonVersion };
        (0, telemetry_1.sendTelemetryEvent)(eventName, undefined, data);
    }
    async getActivationCommands(resource, interpreter, terminalShellType, providers) {
        const settings = this.configurationService.getSettings(resource);
        const condaService = this.serviceContainer.get(contracts_1.IComponentAdapter);
        const isCondaEnvironment = interpreter
            ? interpreter.envType === info_1.EnvironmentType.Conda
            : await condaService.isCondaEnvironment(settings.pythonPath);
        if (isCondaEnvironment) {
            const activationCommands = interpreter
                ? await this.conda.getActivationCommandsForInterpreter(interpreter.path, terminalShellType)
                : await this.conda.getActivationCommands(resource, terminalShellType);
            if (Array.isArray(activationCommands)) {
                return activationCommands;
            }
        }
        const supportedProviders = providers.filter((provider) => provider.isShellSupported(terminalShellType));
        for (const provider of supportedProviders) {
            const activationCommands = interpreter
                ? await provider.getActivationCommandsForInterpreter(interpreter.path, terminalShellType)
                : await provider.getActivationCommands(resource, terminalShellType);
            if (Array.isArray(activationCommands) && activationCommands.length > 0) {
                return activationCommands;
            }
        }
    }
};
__decorate([
    (0, logging_1.traceDecoratorError)('Failed to capture telemetry')
], TerminalHelper.prototype, "sendTelemetry", null);
TerminalHelper = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_3.IPlatformService)),
    __param(1, (0, inversify_1.inject)(types_2.ITerminalManager)),
    __param(2, (0, inversify_1.inject)(types_1.IServiceContainer)),
    __param(3, (0, inversify_1.inject)(contracts_1.IInterpreterService)),
    __param(4, (0, inversify_1.inject)(types_4.IConfigurationService)),
    __param(5, (0, inversify_1.inject)(types_5.ITerminalActivationCommandProvider)),
    __param(5, (0, inversify_1.named)(types_5.TerminalActivationProviders.conda)),
    __param(6, (0, inversify_1.inject)(types_5.ITerminalActivationCommandProvider)),
    __param(6, (0, inversify_1.named)(types_5.TerminalActivationProviders.bashCShellFish)),
    __param(7, (0, inversify_1.inject)(types_5.ITerminalActivationCommandProvider)),
    __param(7, (0, inversify_1.named)(types_5.TerminalActivationProviders.commandPromptAndPowerShell)),
    __param(8, (0, inversify_1.inject)(types_5.ITerminalActivationCommandProvider)),
    __param(8, (0, inversify_1.named)(types_5.TerminalActivationProviders.nushell)),
    __param(9, (0, inversify_1.inject)(types_5.ITerminalActivationCommandProvider)),
    __param(9, (0, inversify_1.named)(types_5.TerminalActivationProviders.pyenv)),
    __param(10, (0, inversify_1.inject)(types_5.ITerminalActivationCommandProvider)),
    __param(10, (0, inversify_1.named)(types_5.TerminalActivationProviders.pipenv)),
    __param(11, (0, inversify_1.multiInject)(types_5.IShellDetector))
], TerminalHelper);
exports.TerminalHelper = TerminalHelper;


/***/ }),

/***/ "./src/client/common/terminal/service.ts":
/*!***********************************************!*\
  !*** ./src/client/common/terminal/service.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
__webpack_require__(/*! ../../common/extensions */ "./src/client/common/extensions.ts");
const types_1 = __webpack_require__(/*! ../../ioc/types */ "./src/client/ioc/types.ts");
const types_2 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
const types_3 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const types_4 = __webpack_require__(/*! ./types */ "./src/client/common/terminal/types.ts");
let TerminalService = class TerminalService {
    constructor(serviceContainer, options) {
        this.serviceContainer = serviceContainer;
        this.options = options;
        this.terminalClosed = new vscode_1.EventEmitter();
        const disposableRegistry = this.serviceContainer.get(types_3.IDisposableRegistry);
        disposableRegistry.push(this);
        this.terminalHelper = this.serviceContainer.get(types_4.ITerminalHelper);
        this.terminalManager = this.serviceContainer.get(types_2.ITerminalManager);
        this.terminalManager.onDidCloseTerminal(this.terminalCloseHandler, this, disposableRegistry);
        this.terminalActivator = this.serviceContainer.get(types_4.ITerminalActivator);
    }
    get onDidCloseTerminal() {
        return this.terminalClosed.event.bind(this.terminalClosed);
    }
    dispose() {
        if (this.terminal) {
            this.terminal.dispose();
        }
    }
    async sendCommand(command, args, _) {
        var _a;
        await this.ensureTerminal();
        const text = this.terminalHelper.buildCommandForTerminal(this.terminalShellType, command, args);
        if (!((_a = this.options) === null || _a === void 0 ? void 0 : _a.hideFromUser)) {
            this.terminal.show(true);
        }
        this.terminal.sendText(text, true);
    }
    async sendText(text) {
        var _a;
        await this.ensureTerminal();
        if (!((_a = this.options) === null || _a === void 0 ? void 0 : _a.hideFromUser)) {
            this.terminal.show(true);
        }
        this.terminal.sendText(text);
    }
    async show(preserveFocus = true) {
        var _a;
        await this.ensureTerminal(preserveFocus);
        if (!((_a = this.options) === null || _a === void 0 ? void 0 : _a.hideFromUser)) {
            this.terminal.show(preserveFocus);
        }
    }
    async ensureTerminal(preserveFocus = true) {
        var _a, _b, _c, _d, _e, _f, _g;
        if (this.terminal) {
            return;
        }
        this.terminalShellType = this.terminalHelper.identifyTerminalShell(this.terminal);
        this.terminal = this.terminalManager.createTerminal({
            name: ((_a = this.options) === null || _a === void 0 ? void 0 : _a.title) || 'Python',
            env: (_b = this.options) === null || _b === void 0 ? void 0 : _b.env,
            hideFromUser: (_c = this.options) === null || _c === void 0 ? void 0 : _c.hideFromUser,
        });
        await new Promise((resolve) => setTimeout(resolve, 100));
        await this.terminalActivator.activateEnvironmentInTerminal(this.terminal, {
            resource: (_d = this.options) === null || _d === void 0 ? void 0 : _d.resource,
            preserveFocus,
            interpreter: (_e = this.options) === null || _e === void 0 ? void 0 : _e.interpreter,
            hideFromUser: (_f = this.options) === null || _f === void 0 ? void 0 : _f.hideFromUser,
        });
        if (!((_g = this.options) === null || _g === void 0 ? void 0 : _g.hideFromUser)) {
            this.terminal.show(preserveFocus);
        }
    }
    terminalCloseHandler(terminal) {
        if (terminal === this.terminal) {
            this.terminalClosed.fire();
            this.terminal = undefined;
        }
    }
};
TerminalService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IServiceContainer))
], TerminalService);
exports.TerminalService = TerminalService;


/***/ }),

/***/ "./src/client/common/terminal/shellDetector.ts":
/*!*****************************************************!*\
  !*** ./src/client/common/terminal/shellDetector.ts ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShellDetector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const telemetry_1 = __webpack_require__(/*! ../../telemetry */ "./src/client/telemetry/index.ts");
const constants_1 = __webpack_require__(/*! ../../telemetry/constants */ "./src/client/telemetry/constants.ts");
__webpack_require__(/*! ../extensions */ "./src/client/common/extensions.ts");
const types_1 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const platform_1 = __webpack_require__(/*! ../utils/platform */ "./src/client/common/utils/platform.ts");
const types_2 = __webpack_require__(/*! ./types */ "./src/client/common/terminal/types.ts");
const defaultOSShells = {
    [platform_1.OSType.Linux]: types_2.TerminalShellType.bash,
    [platform_1.OSType.OSX]: types_2.TerminalShellType.bash,
    [platform_1.OSType.Windows]: types_2.TerminalShellType.commandPrompt,
    [platform_1.OSType.Unknown]: types_2.TerminalShellType.other,
};
let ShellDetector = class ShellDetector {
    constructor(platform, shellDetectors) {
        this.platform = platform;
        this.shellDetectors = shellDetectors;
    }
    identifyTerminalShell(terminal) {
        let shell;
        const telemetryProperties = {
            failed: true,
            shellIdentificationSource: 'default',
            terminalProvided: !!terminal,
            hasCustomShell: undefined,
            hasShellInEnv: undefined,
        };
        const shellDetectors = this.shellDetectors.slice().sort((a, b) => b.priority - a.priority);
        for (const detector of shellDetectors) {
            shell = detector.identify(telemetryProperties, terminal);
            (0, logging_1.traceVerbose)(`${detector}. Shell identified as ${shell} ${terminal ? `(Terminal name is ${terminal.name})` : ''}`);
            if (shell && shell !== types_2.TerminalShellType.other) {
                telemetryProperties.failed = false;
                break;
            }
        }
        (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.TERMINAL_SHELL_IDENTIFICATION, undefined, telemetryProperties);
        (0, logging_1.traceVerbose)(`Shell identified as '${shell}'`);
        if (shell === undefined || shell === types_2.TerminalShellType.other) {
            (0, logging_1.traceError)('Unable to identify shell', vscode_1.env.shell, ' for OS ', this.platform.osType);
            (0, logging_1.traceVerbose)('Using default OS shell');
            shell = defaultOSShells[this.platform.osType];
        }
        return shell;
    }
};
ShellDetector = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IPlatformService)),
    __param(1, (0, inversify_1.multiInject)(types_2.IShellDetector))
], ShellDetector);
exports.ShellDetector = ShellDetector;


/***/ }),

/***/ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts":
/*!************************************************************************!*\
  !*** ./src/client/common/terminal/shellDetectors/baseShellDetector.ts ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.identifyShellFromShellPath = exports.BaseShellDetector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const IS_GITBASH = /(gitbash$)/i;
const IS_BASH = /(bash$)/i;
const IS_WSL = /(wsl$)/i;
const IS_ZSH = /(zsh$)/i;
const IS_KSH = /(ksh$)/i;
const IS_COMMAND = /(cmd$)/i;
const IS_POWERSHELL = /(powershell$)/i;
const IS_POWERSHELL_CORE = /(pwsh$)/i;
const IS_FISH = /(fish$)/i;
const IS_CSHELL = /(csh$)/i;
const IS_TCSHELL = /(tcsh$)/i;
const IS_NUSHELL = /(nu$)/i;
const IS_XONSH = /(xonsh$)/i;
const detectableShells = new Map();
detectableShells.set(types_1.TerminalShellType.powershell, IS_POWERSHELL);
detectableShells.set(types_1.TerminalShellType.gitbash, IS_GITBASH);
detectableShells.set(types_1.TerminalShellType.bash, IS_BASH);
detectableShells.set(types_1.TerminalShellType.wsl, IS_WSL);
detectableShells.set(types_1.TerminalShellType.zsh, IS_ZSH);
detectableShells.set(types_1.TerminalShellType.ksh, IS_KSH);
detectableShells.set(types_1.TerminalShellType.commandPrompt, IS_COMMAND);
detectableShells.set(types_1.TerminalShellType.fish, IS_FISH);
detectableShells.set(types_1.TerminalShellType.tcshell, IS_TCSHELL);
detectableShells.set(types_1.TerminalShellType.cshell, IS_CSHELL);
detectableShells.set(types_1.TerminalShellType.nushell, IS_NUSHELL);
detectableShells.set(types_1.TerminalShellType.powershellCore, IS_POWERSHELL_CORE);
detectableShells.set(types_1.TerminalShellType.xonsh, IS_XONSH);
let BaseShellDetector = class BaseShellDetector {
    constructor(priority) {
        this.priority = priority;
    }
    identifyShellFromShellPath(shellPath) {
        return identifyShellFromShellPath(shellPath);
    }
};
BaseShellDetector = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.unmanaged)())
], BaseShellDetector);
exports.BaseShellDetector = BaseShellDetector;
function identifyShellFromShellPath(shellPath) {
    const basePath = shellPath.replace(/\.exe$/, '');
    const shell = Array.from(detectableShells.keys()).reduce((matchedShell, shellToDetect) => {
        if (matchedShell === types_1.TerminalShellType.other) {
            const pat = detectableShells.get(shellToDetect);
            if (pat && pat.test(basePath)) {
                return shellToDetect;
            }
        }
        return matchedShell;
    }, types_1.TerminalShellType.other);
    (0, logging_1.traceVerbose)(`Shell path '${shellPath}', base path '${basePath}'`);
    (0, logging_1.traceVerbose)(`Shell path identified as shell '${shell}'`);
    return shell;
}
exports.identifyShellFromShellPath = identifyShellFromShellPath;


/***/ }),

/***/ "./src/client/common/terminal/shellDetectors/settingsShellDetector.ts":
/*!****************************************************************************!*\
  !*** ./src/client/common/terminal/shellDetectors/settingsShellDetector.ts ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SettingsShellDetector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../../application/types */ "./src/client/common/application/types.ts");
const types_2 = __webpack_require__(/*! ../../platform/types */ "./src/client/common/platform/types.ts");
const platform_1 = __webpack_require__(/*! ../../utils/platform */ "./src/client/common/utils/platform.ts");
const types_3 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseShellDetector_1 = __webpack_require__(/*! ./baseShellDetector */ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts");
let SettingsShellDetector = class SettingsShellDetector extends baseShellDetector_1.BaseShellDetector {
    constructor(workspace, platform) {
        super(2);
        this.workspace = workspace;
        this.platform = platform;
    }
    getTerminalShellPath() {
        const shellConfig = this.workspace.getConfiguration('terminal.integrated.shell');
        let osSection = '';
        switch (this.platform.osType) {
            case platform_1.OSType.Windows: {
                osSection = 'windows';
                break;
            }
            case platform_1.OSType.OSX: {
                osSection = 'osx';
                break;
            }
            case platform_1.OSType.Linux: {
                osSection = 'linux';
                break;
            }
            default: {
                return '';
            }
        }
        return shellConfig.get(osSection);
    }
    identify(telemetryProperties, _terminal) {
        const shellPath = this.getTerminalShellPath();
        telemetryProperties.hasCustomShell = !!shellPath;
        const shell = shellPath ? this.identifyShellFromShellPath(shellPath) : types_3.TerminalShellType.other;
        if (shell !== types_3.TerminalShellType.other) {
            telemetryProperties.shellIdentificationSource = 'environment';
        }
        else {
            telemetryProperties.shellIdentificationSource = 'settings';
        }
        (0, logging_1.traceVerbose)(`Shell path from user settings '${shellPath}'`);
        return shell;
    }
};
SettingsShellDetector = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IWorkspaceService)),
    __param(1, (0, inversify_1.inject)(types_2.IPlatformService))
], SettingsShellDetector);
exports.SettingsShellDetector = SettingsShellDetector;


/***/ }),

/***/ "./src/client/common/terminal/shellDetectors/terminalNameShellDetector.ts":
/*!********************************************************************************!*\
  !*** ./src/client/common/terminal/shellDetectors/terminalNameShellDetector.ts ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalNameShellDetector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseShellDetector_1 = __webpack_require__(/*! ./baseShellDetector */ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts");
let TerminalNameShellDetector = class TerminalNameShellDetector extends baseShellDetector_1.BaseShellDetector {
    constructor() {
        super(4);
    }
    identify(telemetryProperties, terminal) {
        if (!terminal) {
            return;
        }
        const shell = this.identifyShellFromShellPath(terminal.name);
        (0, logging_1.traceVerbose)(`Terminal name '${terminal.name}' identified as shell '${shell}'`);
        telemetryProperties.shellIdentificationSource =
            shell === types_1.TerminalShellType.other ? telemetryProperties.shellIdentificationSource : 'terminalName';
        return shell;
    }
};
TerminalNameShellDetector = __decorate([
    (0, inversify_1.injectable)()
], TerminalNameShellDetector);
exports.TerminalNameShellDetector = TerminalNameShellDetector;


/***/ }),

/***/ "./src/client/common/terminal/shellDetectors/userEnvironmentShellDetector.ts":
/*!***********************************************************************************!*\
  !*** ./src/client/common/terminal/shellDetectors/userEnvironmentShellDetector.ts ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserEnvironmentShellDetector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../../platform/types */ "./src/client/common/platform/types.ts");
const types_2 = __webpack_require__(/*! ../../types */ "./src/client/common/types.ts");
const platform_1 = __webpack_require__(/*! ../../utils/platform */ "./src/client/common/utils/platform.ts");
const types_3 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseShellDetector_1 = __webpack_require__(/*! ./baseShellDetector */ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts");
let UserEnvironmentShellDetector = class UserEnvironmentShellDetector extends baseShellDetector_1.BaseShellDetector {
    constructor(currentProcess, platform) {
        super(1);
        this.currentProcess = currentProcess;
        this.platform = platform;
    }
    getDefaultPlatformShell() {
        return getDefaultShell(this.platform, this.currentProcess);
    }
    identify(telemetryProperties, _terminal) {
        const shellPath = this.getDefaultPlatformShell();
        telemetryProperties.hasShellInEnv = !!shellPath;
        const shell = this.identifyShellFromShellPath(shellPath);
        if (shell !== types_3.TerminalShellType.other) {
            telemetryProperties.shellIdentificationSource = 'environment';
        }
        (0, logging_1.traceVerbose)(`Shell path from user env '${shellPath}'`);
        return shell;
    }
};
UserEnvironmentShellDetector = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.ICurrentProcess)),
    __param(1, (0, inversify_1.inject)(types_1.IPlatformService))
], UserEnvironmentShellDetector);
exports.UserEnvironmentShellDetector = UserEnvironmentShellDetector;
function getDefaultShell(platform, currentProcess) {
    if (platform.osType === platform_1.OSType.Windows) {
        return getTerminalDefaultShellWindows(platform, currentProcess);
    }
    return currentProcess.env.SHELL && currentProcess.env.SHELL !== '/bin/false'
        ? currentProcess.env.SHELL
        : '/bin/bash';
}
function getTerminalDefaultShellWindows(platform, currentProcess) {
    const isAtLeastWindows10 = parseFloat(platform.osRelease) >= 10;
    const is32ProcessOn64Windows = currentProcess.env.hasOwnProperty('PROCESSOR_ARCHITEW6432');
    const powerShellPath = `${currentProcess.env.windir}\\${is32ProcessOn64Windows ? 'Sysnative' : 'System32'}\\WindowsPowerShell\\v1.0\\powershell.exe`;
    return isAtLeastWindows10 ? powerShellPath : getWindowsShell(currentProcess);
}
function getWindowsShell(currentProcess) {
    return currentProcess.env.comspec || 'cmd.exe';
}


/***/ }),

/***/ "./src/client/common/terminal/shellDetectors/vscEnvironmentShellDetector.ts":
/*!**********************************************************************************!*\
  !*** ./src/client/common/terminal/shellDetectors/vscEnvironmentShellDetector.ts ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VSCEnvironmentShellDetector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../../application/types */ "./src/client/common/application/types.ts");
const types_2 = __webpack_require__(/*! ../types */ "./src/client/common/terminal/types.ts");
const baseShellDetector_1 = __webpack_require__(/*! ./baseShellDetector */ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts");
let VSCEnvironmentShellDetector = class VSCEnvironmentShellDetector extends baseShellDetector_1.BaseShellDetector {
    constructor(appEnv) {
        super(3);
        this.appEnv = appEnv;
    }
    identify(telemetryProperties, terminal) {
        const shellPath = (terminal === null || terminal === void 0 ? void 0 : terminal.creationOptions) && 'shellPath' in terminal.creationOptions && terminal.creationOptions.shellPath
            ? terminal.creationOptions.shellPath
            : this.appEnv.shell;
        if (!shellPath) {
            return;
        }
        const shell = this.identifyShellFromShellPath(shellPath);
        (0, logging_1.traceVerbose)(`Terminal shell path '${shellPath}' identified as shell '${shell}'`);
        telemetryProperties.shellIdentificationSource =
            shell === types_2.TerminalShellType.other ? telemetryProperties.shellIdentificationSource : 'vscode';
        telemetryProperties.failed = shell === types_2.TerminalShellType.other ? false : true;
        return shell;
    }
};
VSCEnvironmentShellDetector = __decorate([
    __param(0, (0, inversify_1.inject)(types_1.IApplicationEnvironment))
], VSCEnvironmentShellDetector);
exports.VSCEnvironmentShellDetector = VSCEnvironmentShellDetector;


/***/ }),

/***/ "./src/client/common/terminal/syncTerminalService.ts":
/*!***********************************************************!*\
  !*** ./src/client/common/terminal/syncTerminalService.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SynchronousTerminalService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const contracts_1 = __webpack_require__(/*! ../../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const cancellation_1 = __webpack_require__(/*! ../cancellation */ "./src/client/common/cancellation.ts");
const types_1 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const internalScripts = __webpack_require__(/*! ../process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const async_1 = __webpack_require__(/*! ../utils/async */ "./src/client/common/utils/async.ts");
const misc_1 = __webpack_require__(/*! ../utils/misc */ "./src/client/common/utils/misc.ts");
var State;
(function (State) {
    State[State["notStarted"] = 0] = "notStarted";
    State[State["started"] = 1] = "started";
    State[State["completed"] = 2] = "completed";
    State[State["errored"] = 4] = "errored";
})(State || (State = {}));
class ExecutionState {
    constructor(lockFile, fs, command) {
        this.lockFile = lockFile;
        this.fs = fs;
        this.command = command;
        this.state = State.notStarted;
        this._completed = (0, async_1.createDeferred)();
        this.registerStateUpdate();
        this._completed.promise.finally(() => this.dispose()).ignoreErrors();
    }
    get completed() {
        return this._completed.promise;
    }
    dispose() {
        if (this.disposable) {
            this.disposable.dispose();
            this.disposable = undefined;
        }
    }
    registerStateUpdate() {
        const timeout = setInterval(async () => {
            const state = await this.getLockFileState(this.lockFile);
            if (state !== this.state) {
                (0, logging_1.traceVerbose)(`Command state changed to ${state}. ${this.command.join(' ')}`);
            }
            this.state = state;
            if (state & State.errored) {
                const errorContents = await this.fs.readFile(`${this.lockFile}.error`).catch(() => '');
                this._completed.reject(new Error(`Command failed with errors, check the terminal for details. Command: ${this.command.join(' ')}\n${errorContents}`));
            }
            else if (state & State.completed) {
                this._completed.resolve();
            }
        }, 100);
        this.disposable = {
            dispose: () => clearInterval(timeout),
        };
    }
    async getLockFileState(file) {
        const source = await this.fs.readFile(file);
        let state = State.notStarted;
        if (source.includes('START')) {
            state |= State.started;
        }
        if (source.includes('END')) {
            state |= State.completed;
        }
        if (source.includes('FAIL')) {
            state |= State.completed | State.errored;
        }
        return state;
    }
}
let SynchronousTerminalService = class SynchronousTerminalService {
    constructor(fs, interpreter, terminalService, pythonInterpreter) {
        this.fs = fs;
        this.interpreter = interpreter;
        this.terminalService = terminalService;
        this.pythonInterpreter = pythonInterpreter;
        this.disposables = [];
    }
    get onDidCloseTerminal() {
        return this.terminalService.onDidCloseTerminal;
    }
    dispose() {
        this.terminalService.dispose();
        while (this.disposables.length) {
            const disposable = this.disposables.shift();
            if (disposable) {
                try {
                    disposable.dispose();
                }
                catch (_a) {
                    (0, misc_1.noop)();
                }
            }
            else {
                break;
            }
        }
    }
    async sendCommand(command, args, cancel, swallowExceptions = true) {
        if (!cancel) {
            return this.terminalService.sendCommand(command, args);
        }
        const lockFile = await this.createLockFile();
        const state = new ExecutionState(lockFile.filePath, this.fs, [command, ...args]);
        try {
            const pythonExec = this.pythonInterpreter || (await this.interpreter.getActiveInterpreter(undefined));
            const sendArgs = internalScripts.shell_exec(command, lockFile.filePath, args);
            await this.terminalService.sendCommand((pythonExec === null || pythonExec === void 0 ? void 0 : pythonExec.path) || 'python', sendArgs);
            const promise = swallowExceptions ? state.completed : state.completed.catch(misc_1.noop);
            await cancellation_1.Cancellation.race(() => promise, cancel);
        }
        finally {
            state.dispose();
            lockFile.dispose();
        }
    }
    sendText(text) {
        return this.terminalService.sendText(text);
    }
    show(preserveFocus) {
        return this.terminalService.show(preserveFocus);
    }
    createLockFile() {
        return this.fs.createTemporaryFile('.log').then((l) => {
            this.disposables.push(l);
            return l;
        });
    }
};
SynchronousTerminalService = __decorate([
    __param(0, (0, inversify_1.inject)(types_1.IFileSystem)),
    __param(1, (0, inversify_1.inject)(contracts_1.IInterpreterService))
], SynchronousTerminalService);
exports.SynchronousTerminalService = SynchronousTerminalService;


/***/ }),

/***/ "./src/client/common/terminal/types.ts":
/*!*********************************************!*\
  !*** ./src/client/common/terminal/types.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IShellDetector = exports.ITerminalActivationCommandProvider = exports.ITerminalActivator = exports.ITerminalHelper = exports.ITerminalServiceFactory = exports.TerminalShellType = exports.TerminalActivationProviders = void 0;
var TerminalActivationProviders;
(function (TerminalActivationProviders) {
    TerminalActivationProviders["bashCShellFish"] = "bashCShellFish";
    TerminalActivationProviders["commandPromptAndPowerShell"] = "commandPromptAndPowerShell";
    TerminalActivationProviders["nushell"] = "nushell";
    TerminalActivationProviders["pyenv"] = "pyenv";
    TerminalActivationProviders["conda"] = "conda";
    TerminalActivationProviders["pipenv"] = "pipenv";
})(TerminalActivationProviders = exports.TerminalActivationProviders || (exports.TerminalActivationProviders = {}));
var TerminalShellType;
(function (TerminalShellType) {
    TerminalShellType["powershell"] = "powershell";
    TerminalShellType["powershellCore"] = "powershellCore";
    TerminalShellType["commandPrompt"] = "commandPrompt";
    TerminalShellType["gitbash"] = "gitbash";
    TerminalShellType["bash"] = "bash";
    TerminalShellType["zsh"] = "zsh";
    TerminalShellType["ksh"] = "ksh";
    TerminalShellType["fish"] = "fish";
    TerminalShellType["cshell"] = "cshell";
    TerminalShellType["tcshell"] = "tshell";
    TerminalShellType["nushell"] = "nushell";
    TerminalShellType["wsl"] = "wsl";
    TerminalShellType["xonsh"] = "xonsh";
    TerminalShellType["other"] = "other";
})(TerminalShellType = exports.TerminalShellType || (exports.TerminalShellType = {}));
exports.ITerminalServiceFactory = Symbol('ITerminalServiceFactory');
exports.ITerminalHelper = Symbol('ITerminalHelper');
exports.ITerminalActivator = Symbol('ITerminalActivator');
exports.ITerminalActivationCommandProvider = Symbol('ITerminalActivationCommandProvider');
exports.IShellDetector = Symbol('IShellDetector');


/***/ }),

/***/ "./src/client/common/types.ts":
/*!************************************!*\
  !*** ./src/client/common/types.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IEditorUtils = exports.IExtensionContext = exports.ISocketServer = exports.ToolExecutionPath = exports.IToolExecutionPath = exports.IConfigurationService = exports.ICurrentProcess = exports.IRandom = exports.IPathUtils = exports.Product = exports.ProductType = exports.ProductInstallStatus = exports.InstallerResponse = exports.IPersistentStateFactory = exports.WORKSPACE_MEMENTO = exports.GLOBAL_MEMENTO = exports.IMemento = exports.IDisposableRegistry = exports.IsWindows = exports.IDocumentSymbolProvider = exports.ITestOutputChannel = exports.ILogOutputChannel = void 0;
exports.ILogOutputChannel = Symbol('ILogOutputChannel');
exports.ITestOutputChannel = Symbol('ITestOutputChannel');
exports.IDocumentSymbolProvider = Symbol('IDocumentSymbolProvider');
exports.IsWindows = Symbol('IS_WINDOWS');
exports.IDisposableRegistry = Symbol('IDisposableRegistry');
exports.IMemento = Symbol('IGlobalMemento');
exports.GLOBAL_MEMENTO = Symbol('IGlobalMemento');
exports.WORKSPACE_MEMENTO = Symbol('IWorkspaceMemento');
exports.IPersistentStateFactory = Symbol('IPersistentStateFactory');
var InstallerResponse;
(function (InstallerResponse) {
    InstallerResponse[InstallerResponse["Installed"] = 0] = "Installed";
    InstallerResponse[InstallerResponse["Disabled"] = 1] = "Disabled";
    InstallerResponse[InstallerResponse["Ignore"] = 2] = "Ignore";
})(InstallerResponse = exports.InstallerResponse || (exports.InstallerResponse = {}));
var ProductInstallStatus;
(function (ProductInstallStatus) {
    ProductInstallStatus[ProductInstallStatus["Installed"] = 0] = "Installed";
    ProductInstallStatus[ProductInstallStatus["NotInstalled"] = 1] = "NotInstalled";
    ProductInstallStatus[ProductInstallStatus["NeedsUpgrade"] = 2] = "NeedsUpgrade";
})(ProductInstallStatus = exports.ProductInstallStatus || (exports.ProductInstallStatus = {}));
var ProductType;
(function (ProductType) {
    ProductType["DataScience"] = "DataScience";
    ProductType["Python"] = "Python";
})(ProductType = exports.ProductType || (exports.ProductType = {}));
var Product;
(function (Product) {
    Product[Product["pytest"] = 1] = "pytest";
    Product[Product["pylint"] = 3] = "pylint";
    Product[Product["flake8"] = 4] = "flake8";
    Product[Product["pycodestyle"] = 5] = "pycodestyle";
    Product[Product["pylama"] = 6] = "pylama";
    Product[Product["prospector"] = 7] = "prospector";
    Product[Product["pydocstyle"] = 8] = "pydocstyle";
    Product[Product["yapf"] = 9] = "yapf";
    Product[Product["autopep8"] = 10] = "autopep8";
    Product[Product["mypy"] = 11] = "mypy";
    Product[Product["unittest"] = 12] = "unittest";
    Product[Product["isort"] = 15] = "isort";
    Product[Product["black"] = 16] = "black";
    Product[Product["bandit"] = 17] = "bandit";
    Product[Product["tensorboard"] = 24] = "tensorboard";
    Product[Product["torchProfilerInstallName"] = 25] = "torchProfilerInstallName";
    Product[Product["torchProfilerImportName"] = 26] = "torchProfilerImportName";
    Product[Product["pip"] = 27] = "pip";
    Product[Product["ensurepip"] = 28] = "ensurepip";
    Product[Product["python"] = 29] = "python";
})(Product = exports.Product || (exports.Product = {}));
exports.IPathUtils = Symbol('IPathUtils');
exports.IRandom = Symbol('IRandom');
exports.ICurrentProcess = Symbol('ICurrentProcess');
exports.IConfigurationService = Symbol('IConfigurationService');
exports.IToolExecutionPath = Symbol('IToolExecutionPath');
var ToolExecutionPath;
(function (ToolExecutionPath) {
    ToolExecutionPath["pipenv"] = "pipenv";
})(ToolExecutionPath = exports.ToolExecutionPath || (exports.ToolExecutionPath = {}));
exports.ISocketServer = Symbol('ISocketServer');
exports.IExtensionContext = Symbol('ExtensionContext');
exports.IEditorUtils = Symbol('IEditorUtils');


/***/ }),

/***/ "./src/client/common/utils/arrayUtils.ts":
/*!***********************************************!*\
  !*** ./src/client/common/utils/arrayUtils.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.asyncForEach = exports.asyncFilter = void 0;
async function asyncFilter(arr, asyncPredicate) {
    const results = await Promise.all(arr.map(asyncPredicate));
    return arr.filter((_v, index) => results[index]);
}
exports.asyncFilter = asyncFilter;
async function asyncForEach(arr, asyncFunc) {
    await Promise.all(arr.map(asyncFunc));
}
exports.asyncForEach = asyncForEach;


/***/ }),

/***/ "./src/client/common/utils/async.ts":
/*!******************************************!*\
  !*** ./src/client/common/utils/async.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.flattenIterator = exports.iterable = exports.mapToIterator = exports.chain = exports.iterEmpty = exports.createDeferredFromPromise = exports.createDeferredFrom = exports.createDeferred = exports.isPromise = exports.isThenable = exports.sleep = void 0;
async function sleep(timeout) {
    return new Promise((resolve) => {
        setTimeout(() => resolve(timeout), timeout);
    });
}
exports.sleep = sleep;
function isThenable(v) {
    return typeof (v === null || v === void 0 ? void 0 : v.then) === 'function';
}
exports.isThenable = isThenable;
function isPromise(v) {
    return typeof (v === null || v === void 0 ? void 0 : v.then) === 'function' && typeof (v === null || v === void 0 ? void 0 : v.catch) === 'function';
}
exports.isPromise = isPromise;
class DeferredImpl {
    constructor(scope = null) {
        this.scope = scope;
        this._resolved = false;
        this._rejected = false;
        this._promise = new Promise((res, rej) => {
            this._resolve = res;
            this._reject = rej;
        });
    }
    resolve(_value) {
        if (this.completed) {
            return;
        }
        this._resolve.apply(this.scope ? this.scope : this, [_value]);
        this._resolved = true;
    }
    reject(_reason) {
        if (this.completed) {
            return;
        }
        this._reject.apply(this.scope ? this.scope : this, [_reason]);
        this._rejected = true;
    }
    get promise() {
        return this._promise;
    }
    get resolved() {
        return this._resolved;
    }
    get rejected() {
        return this._rejected;
    }
    get completed() {
        return this._rejected || this._resolved;
    }
}
function createDeferred(scope = null) {
    return new DeferredImpl(scope);
}
exports.createDeferred = createDeferred;
function createDeferredFrom(...promises) {
    const deferred = createDeferred();
    Promise.all(promises)
        .then(deferred.resolve.bind(deferred))
        .catch(deferred.reject.bind(deferred));
    return deferred;
}
exports.createDeferredFrom = createDeferredFrom;
function createDeferredFromPromise(promise) {
    const deferred = createDeferred();
    promise.then(deferred.resolve.bind(deferred)).catch(deferred.reject.bind(deferred));
    return deferred;
}
exports.createDeferredFromPromise = createDeferredFromPromise;
function iterEmpty() {
    return (async function* () {
    })();
}
exports.iterEmpty = iterEmpty;
async function getNext(it, indexMaybe) {
    const index = indexMaybe === undefined ? -1 : indexMaybe;
    try {
        const result = await it.next();
        return { index, result, err: null };
    }
    catch (err) {
        return { index, err: err, result: null };
    }
}
const NEVER = new Promise(() => {
});
async function* chain(iterators, onError) {
    const promises = iterators.map(getNext);
    let numRunning = iterators.length;
    while (numRunning > 0) {
        const { index, result, err } = await Promise.race(promises);
        if (err !== null) {
            promises[index] = NEVER;
            numRunning -= 1;
            if (onError !== undefined) {
                await onError(err, index);
            }
        }
        else if (result.done) {
            promises[index] = NEVER;
            numRunning -= 1;
            if (result.value !== undefined) {
                yield result.value;
            }
        }
        else {
            promises[index] = getNext(iterators[index], index);
            yield result.value;
        }
    }
}
exports.chain = chain;
async function* mapToIterator(items, func, race = true) {
    if (race) {
        const iterators = items.map((item) => {
            async function* generator() {
                yield func(item);
            }
            return generator();
        });
        yield* iterable(chain(iterators));
    }
    else {
        yield* items.map(func);
    }
}
exports.mapToIterator = mapToIterator;
function iterable(iterator) {
    const it = iterator;
    if (it[Symbol.asyncIterator] === undefined) {
        it[Symbol.asyncIterator] = () => it;
    }
    return it;
}
exports.iterable = iterable;
async function flattenIterator(iterator) {
    const results = [];
    for await (const item of iterable(iterator)) {
        results.push(item);
    }
    return results;
}
exports.flattenIterator = flattenIterator;


/***/ }),

/***/ "./src/client/common/utils/cacheUtils.ts":
/*!***********************************************!*\
  !*** ./src/client/common/utils/cacheUtils.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InMemoryCache = exports.clearCache = exports.getCacheKeyFromFunctionArgs = exports.getGlobalCacheStore = void 0;
const globalCacheStore = new Map();
function getGlobalCacheStore() {
    return globalCacheStore;
}
exports.getGlobalCacheStore = getGlobalCacheStore;
function getCacheKeyFromFunctionArgs(keyPrefix, fnArgs) {
    const argsKey = fnArgs.map((arg) => `${JSON.stringify(arg)}`).join('-Arg-Separator-');
    return `KeyPrefix=${keyPrefix}-Args=${argsKey}`;
}
exports.getCacheKeyFromFunctionArgs = getCacheKeyFromFunctionArgs;
function clearCache() {
    globalCacheStore.clear();
}
exports.clearCache = clearCache;
class InMemoryCache {
    constructor(expiryDurationMs) {
        this.expiryDurationMs = expiryDurationMs;
    }
    get hasData() {
        if (!this.cacheData || this.hasExpired(this.cacheData.expiry)) {
            this.cacheData = undefined;
            return false;
        }
        return true;
    }
    get data() {
        var _a;
        if (!this.hasData) {
            return;
        }
        return (_a = this.cacheData) === null || _a === void 0 ? void 0 : _a.value;
    }
    set data(value) {
        if (value !== undefined) {
            this.cacheData = {
                expiry: this.calculateExpiry(),
                value,
            };
        }
        else {
            this.cacheData = undefined;
        }
    }
    clear() {
        this.cacheData = undefined;
    }
    hasExpired(expiry) {
        return expiry <= Date.now();
    }
    calculateExpiry() {
        return Date.now() + this.expiryDurationMs;
    }
}
exports.InMemoryCache = InMemoryCache;


/***/ }),

/***/ "./src/client/common/utils/decorators.ts":
/*!***********************************************!*\
  !*** ./src/client/common/utils/decorators.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.swallowExceptions = exports.cache = exports.makeDebounceAsyncDecorator = exports.makeDebounceDecorator = exports.debounceAsync = exports.debounceSync = void 0;
__webpack_require__(/*! ../../common/extensions */ "./src/client/common/extensions.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const constants_1 = __webpack_require__(/*! ../constants */ "./src/client/common/constants.ts");
const async_1 = __webpack_require__(/*! ./async */ "./src/client/common/utils/async.ts");
const cacheUtils_1 = __webpack_require__(/*! ./cacheUtils */ "./src/client/common/utils/cacheUtils.ts");
const stopWatch_1 = __webpack_require__(/*! ./stopWatch */ "./src/client/common/utils/stopWatch.ts");
const _debounce = __webpack_require__(/*! lodash/debounce */ "./node_modules/lodash/debounce.js");
function debounceSync(wait) {
    if ((0, constants_1.isTestExecution)()) {
        wait = undefined;
    }
    return makeDebounceDecorator(wait);
}
exports.debounceSync = debounceSync;
function debounceAsync(wait) {
    if ((0, constants_1.isTestExecution)()) {
        wait = undefined;
    }
    return makeDebounceAsyncDecorator(wait);
}
exports.debounceAsync = debounceAsync;
function makeDebounceDecorator(wait) {
    return function (_target, _propertyName, descriptor) {
        const options = {};
        const originalMethod = descriptor.value;
        const debounced = _debounce(function () {
            return originalMethod.apply(this, arguments);
        }, wait, options);
        descriptor.value = debounced;
    };
}
exports.makeDebounceDecorator = makeDebounceDecorator;
function makeDebounceAsyncDecorator(wait) {
    return function (_target, _propertyName, descriptor) {
        const originalMethod = descriptor.value;
        const state = { started: false, deferred: undefined, timer: undefined };
        descriptor.value = function () {
            const existingDeferred = state.deferred;
            if (existingDeferred && state.started) {
                return existingDeferred.promise;
            }
            const existingDeferredCompleted = existingDeferred && existingDeferred.completed;
            const deferred = (state.deferred =
                !existingDeferred || existingDeferredCompleted ? (0, async_1.createDeferred)() : existingDeferred);
            if (state.timer) {
                clearTimeout(state.timer);
            }
            state.timer = setTimeout(async () => {
                state.started = true;
                originalMethod
                    .apply(this)
                    .then((r) => {
                    state.started = false;
                    deferred.resolve(r);
                })
                    .catch((ex) => {
                    state.started = false;
                    deferred.reject(ex);
                });
            }, wait || 0);
            return deferred.promise;
        };
    };
}
exports.makeDebounceAsyncDecorator = makeDebounceAsyncDecorator;
const cacheStoreForMethods = (0, cacheUtils_1.getGlobalCacheStore)();
const extensionStartUpTime = 200000;
const moduleLoadWatch = new stopWatch_1.StopWatch();
function cache(expiryDurationMs, cachePromise = false, expiryDurationAfterStartUpMs) {
    return function (target, propertyName, descriptor) {
        const originalMethod = descriptor.value;
        const className = 'constructor' in target && target.constructor.name ? target.constructor.name : '';
        const keyPrefix = `Cache_Method_Output_${className}.${propertyName}`;
        descriptor.value = async function (...args) {
            if ((0, constants_1.isTestExecution)()) {
                return originalMethod.apply(this, args);
            }
            let key;
            try {
                key = (0, cacheUtils_1.getCacheKeyFromFunctionArgs)(keyPrefix, args);
            }
            catch (ex) {
                (0, logging_1.traceError)('Error while creating key for keyPrefix:', keyPrefix, ex);
                return originalMethod.apply(this, args);
            }
            const cachedItem = cacheStoreForMethods.get(key);
            if (cachedItem && (cachedItem.expiry > Date.now() || expiryDurationMs === -1)) {
                (0, logging_1.traceVerbose)(`Cached data exists ${key}`);
                return Promise.resolve(cachedItem.data);
            }
            const expiryMs = expiryDurationAfterStartUpMs && moduleLoadWatch.elapsedTime > extensionStartUpTime
                ? expiryDurationAfterStartUpMs
                : expiryDurationMs;
            const promise = originalMethod.apply(this, args);
            if (cachePromise) {
                cacheStoreForMethods.set(key, { data: promise, expiry: Date.now() + expiryMs });
            }
            else {
                promise
                    .then((result) => cacheStoreForMethods.set(key, { data: result, expiry: Date.now() + expiryMs }))
                    .ignoreErrors();
            }
            return promise;
        };
    };
}
exports.cache = cache;
function swallowExceptions(scopeName) {
    return function (_target, propertyName, descriptor) {
        const originalMethod = descriptor.value;
        const errorMessage = `Python Extension (Error in ${scopeName || propertyName}, method:${propertyName}):`;
        descriptor.value = function (...args) {
            try {
                const result = originalMethod.apply(this, args);
                if (result && typeof result.then === 'function' && typeof result.catch === 'function') {
                    return result.catch((error) => {
                        if ((0, constants_1.isTestExecution)()) {
                            return;
                        }
                        (0, logging_1.traceError)(errorMessage, error);
                    });
                }
            }
            catch (error) {
                if ((0, constants_1.isTestExecution)()) {
                    return;
                }
                (0, logging_1.traceError)(errorMessage, error);
            }
        };
    };
}
exports.swallowExceptions = swallowExceptions;


/***/ }),

/***/ "./src/client/common/utils/exec.ts":
/*!*****************************************!*\
  !*** ./src/client/common/utils/exec.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isValidAndExecutable = exports.getSearchPathEntries = exports.getSearchPathEnvVarNames = void 0;
const fsapi = __webpack_require__(/*! fs */ "fs");
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ./platform */ "./src/client/common/utils/platform.ts");
function getSearchPathEnvVarNames(ostype = (0, platform_1.getOSType)()) {
    if (ostype === platform_1.OSType.Windows) {
        return ['Path', 'PATH'];
    }
    return ['PATH'];
}
exports.getSearchPathEnvVarNames = getSearchPathEnvVarNames;
function getSearchPathEntries() {
    const envVars = getSearchPathEnvVarNames();
    for (const envVar of envVars) {
        const value = (0, platform_1.getEnvironmentVariable)(envVar);
        if (value !== undefined) {
            return parseSearchPathEntries(value);
        }
    }
    return [];
}
exports.getSearchPathEntries = getSearchPathEntries;
function parseSearchPathEntries(envVarValue) {
    return envVarValue
        .split(path.delimiter)
        .map((entry) => entry.trim())
        .filter((entry) => entry.length > 0);
}
async function isValidAndExecutable(filename) {
    try {
        await fsapi.promises.access(filename, fsapi.constants.X_OK);
    }
    catch (err) {
        return false;
    }
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        return undefined;
    }
    return true;
}
exports.isValidAndExecutable = isValidAndExecutable;


/***/ }),

/***/ "./src/client/common/utils/filesystem.ts":
/*!***********************************************!*\
  !*** ./src/client/common/utils/filesystem.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getFileFilter = exports.getFileType = exports.convertFileType = exports.FileType = void 0;
const fs = __webpack_require__(/*! fs */ "fs");
const vscode = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
exports.FileType = vscode.FileType;
function convertFileType(info) {
    if (info.isFile()) {
        return exports.FileType.File;
    }
    if (info.isDirectory()) {
        return exports.FileType.Directory;
    }
    if (info.isSymbolicLink()) {
        return exports.FileType.SymbolicLink;
    }
    return exports.FileType.Unknown;
}
exports.convertFileType = convertFileType;
async function getFileType(filename, opts = { ignoreErrors: true }) {
    let stat;
    try {
        stat = await fs.promises.lstat(filename);
    }
    catch (err) {
        const error = err;
        if (error.code === 'ENOENT') {
            return undefined;
        }
        if (opts.ignoreErrors) {
            (0, logging_1.traceError)(`lstat() failed for "${filename}" (${err})`);
            return exports.FileType.Unknown;
        }
        throw err;
    }
    return convertFileType(stat);
}
exports.getFileType = getFileType;
function normalizeFileTypes(filetypes) {
    if (filetypes === undefined) {
        return undefined;
    }
    if (Array.isArray(filetypes)) {
        if (filetypes.length === 0) {
            return undefined;
        }
        return filetypes;
    }
    return [filetypes];
}
async function resolveFile(file, opts = {}) {
    let filename;
    if (typeof file !== 'string') {
        if (!opts.ensure) {
            if (opts.onMissing === undefined) {
                return file;
            }
            if ((await getFileType(file.filename)) !== undefined) {
                return file;
            }
        }
        filename = file.filename;
    }
    else {
        filename = file;
    }
    const filetype = (await getFileType(filename)) || opts.onMissing;
    if (filetype === undefined) {
        return undefined;
    }
    return { filename, filetype };
}
function getFileFilter(opts = {
    ignoreMissing: true,
}) {
    const ignoreFileType = normalizeFileTypes(opts.ignoreFileType);
    if (!opts.ignoreMissing && !ignoreFileType) {
        return undefined;
    }
    async function filterFile(file) {
        let entry = await resolveFile(file, { ensure: opts.ensureEntry });
        if (!entry) {
            if (opts.ignoreMissing) {
                return false;
            }
            const filename = typeof file === 'string' ? file : file.filename;
            entry = { filename, filetype: exports.FileType.Unknown };
        }
        if (ignoreFileType) {
            if (ignoreFileType.includes(entry.filetype)) {
                return false;
            }
        }
        return true;
    }
    return filterFile;
}
exports.getFileFilter = getFileFilter;


/***/ }),

/***/ "./src/client/common/utils/localize.ts":
/*!*********************************************!*\
  !*** ./src/client/common/utils/localize.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolsExtensions = exports.CreateEnv = exports.SwitchToDefaultLS = exports.Python27Support = exports.OutdatedDebugger = exports.Testing = exports.DebugConfigStrings = exports.ExtensionSurveyBanner = exports.Installer = exports.Linters = exports.OutputChannelNames = exports.InterpreterQuickPickList = exports.Interpreters = exports.LanguageService = exports.TensorBoard = exports.Pylance = exports.AttachProcess = exports.CommonSurvey = exports.Common = exports.Diagnostics = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
var Diagnostics;
(function (Diagnostics) {
    Diagnostics.warnSourceMaps = vscode_1.l10n.t('Source map support is enabled in the Python Extension, this will adversely impact performance of the extension.');
    Diagnostics.disableSourceMaps = vscode_1.l10n.t('Disable Source Map Support');
    Diagnostics.warnBeforeEnablingSourceMaps = vscode_1.l10n.t('Enabling source map support in the Python Extension will adversely impact performance of the extension.');
    Diagnostics.enableSourceMapsAndReloadVSC = vscode_1.l10n.t('Enable and reload Window.');
    Diagnostics.lsNotSupported = vscode_1.l10n.t('Your operating system does not meet the minimum requirements of the Python Language Server. Reverting to the alternative autocompletion provider, Jedi.');
    Diagnostics.invalidPythonPathInDebuggerSettings = vscode_1.l10n.t('You need to select a Python interpreter before you start debugging.\n\nTip: click on "Select Interpreter" in the status bar.');
    Diagnostics.invalidPythonPathInDebuggerLaunch = vscode_1.l10n.t('The Python path in your debug configuration is invalid.');
    Diagnostics.invalidDebuggerTypeDiagnostic = vscode_1.l10n.t('Your launch.json file needs to be updated to change the "pythonExperimental" debug configurations to use the "python" debugger type, otherwise Python debugging may not work. Would you like to automatically update your launch.json file now?');
    Diagnostics.consoleTypeDiagnostic = vscode_1.l10n.t('Your launch.json file needs to be updated to change the console type string from "none" to "internalConsole", otherwise Python debugging may not work. Would you like to automatically update your launch.json file now?');
    Diagnostics.justMyCodeDiagnostic = vscode_1.l10n.t('Configuration "debugStdLib" in launch.json is no longer supported. It\'s recommended to replace it with "justMyCode", which is the exact opposite of using "debugStdLib". Would you like to automatically update your launch.json file to do that?');
    Diagnostics.yesUpdateLaunch = vscode_1.l10n.t('Yes, update launch.json');
    Diagnostics.invalidTestSettings = vscode_1.l10n.t('Your settings needs to be updated to change the setting "python.unitTest." to "python.testing.", otherwise testing Python code using the extension may not work. Would you like to automatically update your settings now?');
    Diagnostics.updateSettings = vscode_1.l10n.t('Yes, update settings');
    Diagnostics.checkIsort5UpgradeGuide = vscode_1.l10n.t('We found outdated configuration for sorting imports in this workspace. Check the [isort upgrade guide](https://aka.ms/AA9j5x4) to update your settings.');
    Diagnostics.pylanceDefaultMessage = vscode_1.l10n.t("The Python extension now includes Pylance to improve completions, code navigation, overall performance and much more! You can learn more about the update and learn how to change your language server [here](https://aka.ms/new-python-bundle).\n\nRead Pylance's license [here](https://marketplace.visualstudio.com/items/ms-python.vscode-pylance/license).");
})(Diagnostics = exports.Diagnostics || (exports.Diagnostics = {}));
var Common;
(function (Common) {
    Common.allow = vscode_1.l10n.t('Allow');
    Common.seeInstructions = vscode_1.l10n.t('See Instructions');
    Common.close = vscode_1.l10n.t('Close');
    Common.bannerLabelYes = vscode_1.l10n.t('Yes');
    Common.bannerLabelNo = vscode_1.l10n.t('No');
    Common.canceled = vscode_1.l10n.t('Canceled');
    Common.cancel = vscode_1.l10n.t('Cancel');
    Common.ok = vscode_1.l10n.t('Ok');
    Common.error = vscode_1.l10n.t('Error');
    Common.gotIt = vscode_1.l10n.t('Got it!');
    Common.install = vscode_1.l10n.t('Install');
    Common.loadingExtension = vscode_1.l10n.t('Python extension loading...');
    Common.openOutputPanel = vscode_1.l10n.t('Show output');
    Common.noIWillDoItLater = vscode_1.l10n.t('No, I will do it later');
    Common.notNow = vscode_1.l10n.t('Not now');
    Common.doNotShowAgain = vscode_1.l10n.t("Don't show again");
    Common.reload = vscode_1.l10n.t('Reload');
    Common.moreInfo = vscode_1.l10n.t('More Info');
    Common.learnMore = vscode_1.l10n.t('Learn more');
    Common.and = vscode_1.l10n.t('and');
    Common.reportThisIssue = vscode_1.l10n.t('Report this issue');
    Common.recommended = vscode_1.l10n.t('Recommended');
    Common.clearAll = vscode_1.l10n.t('Clear all');
    Common.alwaysIgnore = vscode_1.l10n.t('Always Ignore');
    Common.ignore = vscode_1.l10n.t('Ignore');
    Common.selectPythonInterpreter = vscode_1.l10n.t('Select Python Interpreter');
    Common.openLaunch = vscode_1.l10n.t('Open launch.json');
    Common.useCommandPrompt = vscode_1.l10n.t('Use Command Prompt');
    Common.download = vscode_1.l10n.t('Download');
    Common.showLogs = vscode_1.l10n.t('Show logs');
    Common.openFolder = vscode_1.l10n.t('Open Folder...');
})(Common = exports.Common || (exports.Common = {}));
var CommonSurvey;
(function (CommonSurvey) {
    CommonSurvey.remindMeLaterLabel = vscode_1.l10n.t('Remind me later');
    CommonSurvey.yesLabel = vscode_1.l10n.t('Yes, take survey now');
    CommonSurvey.noLabel = vscode_1.l10n.t('No, thanks');
})(CommonSurvey = exports.CommonSurvey || (exports.CommonSurvey = {}));
var AttachProcess;
(function (AttachProcess) {
    AttachProcess.attachTitle = vscode_1.l10n.t('Attach to process');
    AttachProcess.selectProcessPlaceholder = vscode_1.l10n.t('Select the process to attach to');
    AttachProcess.noProcessSelected = vscode_1.l10n.t('No process selected');
    AttachProcess.refreshList = vscode_1.l10n.t('Refresh process list');
})(AttachProcess = exports.AttachProcess || (exports.AttachProcess = {}));
var Pylance;
(function (Pylance) {
    Pylance.remindMeLater = vscode_1.l10n.t('Remind me later');
    Pylance.pylanceNotInstalledMessage = vscode_1.l10n.t('Pylance extension is not installed.');
    Pylance.pylanceInstalledReloadPromptMessage = vscode_1.l10n.t('Pylance extension is now installed. Reload window to activate?');
    Pylance.pylanceRevertToJediPrompt = vscode_1.l10n.t('The Pylance extension is not installed but the python.languageServer value is set to "Pylance". Would you like to install the Pylance extension to use Pylance, or revert back to Jedi?');
    Pylance.pylanceInstallPylance = vscode_1.l10n.t('Install Pylance');
    Pylance.pylanceRevertToJedi = vscode_1.l10n.t('Revert to Jedi');
})(Pylance = exports.Pylance || (exports.Pylance = {}));
var TensorBoard;
(function (TensorBoard) {
    TensorBoard.enterRemoteUrl = vscode_1.l10n.t('Enter remote URL');
    TensorBoard.enterRemoteUrlDetail = vscode_1.l10n.t('Enter a URL pointing to a remote directory containing your TensorBoard log files');
    TensorBoard.useCurrentWorkingDirectoryDetail = vscode_1.l10n.t('TensorBoard will search for tfevent files in all subdirectories of the current working directory');
    TensorBoard.useCurrentWorkingDirectory = vscode_1.l10n.t('Use current working directory');
    TensorBoard.logDirectoryPrompt = vscode_1.l10n.t('Select a log directory to start TensorBoard with');
    TensorBoard.progressMessage = vscode_1.l10n.t('Starting TensorBoard session...');
    TensorBoard.nativeTensorBoardPrompt = vscode_1.l10n.t('VS Code now has integrated TensorBoard support. Would you like to launch TensorBoard?  (Tip: Launch TensorBoard anytime by opening the command palette and searching for "Launch TensorBoard".)');
    TensorBoard.selectAFolder = vscode_1.l10n.t('Select a folder');
    TensorBoard.selectAFolderDetail = vscode_1.l10n.t('Select a log directory containing tfevent files');
    TensorBoard.selectAnotherFolder = vscode_1.l10n.t('Select another folder');
    TensorBoard.selectAnotherFolderDetail = vscode_1.l10n.t('Use the file explorer to select another folder');
    TensorBoard.installPrompt = vscode_1.l10n.t('The package TensorBoard is required to launch a TensorBoard session. Would you like to install it?');
    TensorBoard.installTensorBoardAndProfilerPluginPrompt = vscode_1.l10n.t('TensorBoard >= 2.4.1 and the PyTorch Profiler TensorBoard plugin >= 0.2.0 are required. Would you like to install these packages?');
    TensorBoard.installProfilerPluginPrompt = vscode_1.l10n.t('We recommend installing version >= 0.2.0 of the PyTorch Profiler TensorBoard plugin. Would you like to install the package?');
    TensorBoard.upgradePrompt = vscode_1.l10n.t('Integrated TensorBoard support is only available for TensorBoard >= 2.4.1. Would you like to upgrade your copy of TensorBoard?');
    TensorBoard.launchNativeTensorBoardSessionCodeLens = vscode_1.l10n.t('▶ Launch TensorBoard Session');
    TensorBoard.launchNativeTensorBoardSessionCodeAction = vscode_1.l10n.t('Launch TensorBoard session');
    TensorBoard.missingSourceFile = vscode_1.l10n.t('The Python extension could not locate the requested source file on disk. Please manually specify the file.');
    TensorBoard.selectMissingSourceFile = vscode_1.l10n.t('Choose File');
    TensorBoard.selectMissingSourceFileDescription = vscode_1.l10n.t("The source file's contents may not match the original contents in the trace.");
})(TensorBoard = exports.TensorBoard || (exports.TensorBoard = {}));
var LanguageService;
(function (LanguageService) {
    LanguageService.virtualWorkspaceStatusItem = {
        detail: vscode_1.l10n.t('Limited IntelliSense supported by Jedi and Pylance'),
    };
    LanguageService.statusItem = {
        name: vscode_1.l10n.t('Python IntelliSense Status'),
        text: vscode_1.l10n.t('Partial Mode'),
        detail: vscode_1.l10n.t('Limited IntelliSense provided by Pylance'),
    };
    LanguageService.startingPylance = vscode_1.l10n.t('Starting Pylance language server.');
    LanguageService.startingNone = vscode_1.l10n.t('Editor support is inactive since language server is set to None.');
    LanguageService.untrustedWorkspaceMessage = vscode_1.l10n.t('Only Pylance is supported in untrusted workspaces, setting language server to None.');
    LanguageService.reloadAfterLanguageServerChange = vscode_1.l10n.t('Reload the window after switching between language servers.');
    LanguageService.lsFailedToStart = vscode_1.l10n.t('We encountered an issue starting the language server. Reverting to Jedi language engine. Check the Python output panel for details.');
    LanguageService.lsFailedToDownload = vscode_1.l10n.t('We encountered an issue downloading the language server. Reverting to Jedi language engine. Check the Python output panel for details.');
    LanguageService.lsFailedToExtract = vscode_1.l10n.t('We encountered an issue extracting the language server. Reverting to Jedi language engine. Check the Python output panel for details.');
    LanguageService.downloadFailedOutputMessage = vscode_1.l10n.t('Language server download failed.');
    LanguageService.extractionFailedOutputMessage = vscode_1.l10n.t('Language server extraction failed.');
    LanguageService.extractionCompletedOutputMessage = vscode_1.l10n.t('Language server download complete.');
    LanguageService.extractionDoneOutputMessage = vscode_1.l10n.t('done.');
    LanguageService.reloadVSCodeIfSeachPathHasChanged = vscode_1.l10n.t('Search paths have changed for this Python interpreter. Reload the extension to ensure that the IntelliSense works correctly.');
})(LanguageService = exports.LanguageService || (exports.LanguageService = {}));
var Interpreters;
(function (Interpreters) {
    Interpreters.requireJupyter = vscode_1.l10n.t('Running in Interactive window requires Jupyter Extension. Would you like to install it? [Learn more](https://aka.ms/pythonJupyterSupport).');
    Interpreters.installingPython = vscode_1.l10n.t('Installing Python into Environment...');
    Interpreters.discovering = vscode_1.l10n.t('Discovering Python Interpreters');
    Interpreters.refreshing = vscode_1.l10n.t('Refreshing Python Interpreters');
    Interpreters.condaInheritEnvMessage = vscode_1.l10n.t('We noticed you\'re using a conda environment. If you are experiencing issues with this environment in the integrated terminal, we recommend that you let the Python extension change "terminal.integrated.inheritEnv" to false in your user settings. [Learn more](https://aka.ms/AA66i8f).');
    Interpreters.activatingTerminals = vscode_1.l10n.t('Reactivating terminals...');
    Interpreters.activateTerminalDescription = vscode_1.l10n.t('Activated environment for');
    Interpreters.terminalEnvVarCollectionPrompt = vscode_1.l10n.t('The Python extension automatically activates all terminals using the selected environment, even when the name of the environment{0} is not present in the terminal prompt. [Learn more](https://aka.ms/vscodePythonTerminalActivation).');
    Interpreters.activatedCondaEnvLaunch = vscode_1.l10n.t('We noticed VS Code was launched from an activated conda environment, would you like to select it?');
    Interpreters.environmentPromptMessage = vscode_1.l10n.t('We noticed a new environment has been created. Do you want to select it for the workspace folder?');
    Interpreters.entireWorkspace = vscode_1.l10n.t('Select at workspace level');
    Interpreters.clearAtWorkspace = vscode_1.l10n.t('Clear at workspace level');
    Interpreters.selectInterpreterTip = vscode_1.l10n.t('Tip: you can change the Python interpreter used by the Python extension by clicking on the Python version in the status bar');
    Interpreters.installPythonTerminalMessageLinux = vscode_1.l10n.t('💡 Try installing the Python package using your package manager. Alternatively you can also download it from https://www.python.org/downloads');
    Interpreters.installPythonTerminalMacMessage = vscode_1.l10n.t('💡 Brew does not seem to be available. You can download Python from https://www.python.org/downloads. Alternatively, you can install the Python package using some other available package manager.');
    Interpreters.changePythonInterpreter = vscode_1.l10n.t('Change Python Interpreter');
    Interpreters.selectedPythonInterpreter = vscode_1.l10n.t('Selected Python Interpreter');
})(Interpreters = exports.Interpreters || (exports.Interpreters = {}));
var InterpreterQuickPickList;
(function (InterpreterQuickPickList) {
    InterpreterQuickPickList.condaEnvWithoutPythonTooltip = vscode_1.l10n.t('Python is not available in this environment, it will automatically be installed upon selecting it');
    InterpreterQuickPickList.noPythonInstalled = vscode_1.l10n.t('Python is not installed');
    InterpreterQuickPickList.clickForInstructions = vscode_1.l10n.t('Click for instructions...');
    InterpreterQuickPickList.globalGroupName = vscode_1.l10n.t('Global');
    InterpreterQuickPickList.workspaceGroupName = vscode_1.l10n.t('Workspace');
    InterpreterQuickPickList.enterPath = {
        label: vscode_1.l10n.t('Enter interpreter path...'),
        placeholder: vscode_1.l10n.t('Enter path to a Python interpreter.'),
    };
    InterpreterQuickPickList.defaultInterpreterPath = {
        label: vscode_1.l10n.t('Use Python from `python.defaultInterpreterPath` setting'),
    };
    InterpreterQuickPickList.browsePath = {
        label: vscode_1.l10n.t('Find...'),
        detail: vscode_1.l10n.t('Browse your file system to find a Python interpreter.'),
        openButtonLabel: vscode_1.l10n.t('Select Interpreter'),
        title: vscode_1.l10n.t('Select Python interpreter'),
    };
    InterpreterQuickPickList.refreshInterpreterList = vscode_1.l10n.t('Refresh Interpreter list');
    InterpreterQuickPickList.refreshingInterpreterList = vscode_1.l10n.t('Refreshing Interpreter list...');
})(InterpreterQuickPickList = exports.InterpreterQuickPickList || (exports.InterpreterQuickPickList = {}));
var OutputChannelNames;
(function (OutputChannelNames) {
    OutputChannelNames.languageServer = vscode_1.l10n.t('Python Language Server');
    OutputChannelNames.python = vscode_1.l10n.t('Python');
    OutputChannelNames.pythonTest = vscode_1.l10n.t('Python Test Log');
})(OutputChannelNames = exports.OutputChannelNames || (exports.OutputChannelNames = {}));
var Linters;
(function (Linters) {
    Linters.selectLinter = vscode_1.l10n.t('Select Linter');
})(Linters = exports.Linters || (exports.Linters = {}));
var Installer;
(function (Installer) {
    Installer.noCondaOrPipInstaller = vscode_1.l10n.t('There is no Conda or Pip installer available in the selected environment.');
    Installer.noPipInstaller = vscode_1.l10n.t('There is no Pip installer available in the selected environment.');
    Installer.searchForHelp = vscode_1.l10n.t('Search for help');
})(Installer = exports.Installer || (exports.Installer = {}));
var ExtensionSurveyBanner;
(function (ExtensionSurveyBanner) {
    ExtensionSurveyBanner.bannerMessage = vscode_1.l10n.t('Can you take 2 minutes to tell us how the Python extension is working for you?');
    ExtensionSurveyBanner.bannerLabelYes = vscode_1.l10n.t('Yes, take survey now');
    ExtensionSurveyBanner.bannerLabelNo = vscode_1.l10n.t('No, thanks');
    ExtensionSurveyBanner.maybeLater = vscode_1.l10n.t('Maybe later');
})(ExtensionSurveyBanner = exports.ExtensionSurveyBanner || (exports.ExtensionSurveyBanner = {}));
var DebugConfigStrings;
(function (DebugConfigStrings) {
    DebugConfigStrings.selectConfiguration = {
        title: vscode_1.l10n.t('Select a debug configuration'),
        placeholder: vscode_1.l10n.t('Debug Configuration'),
    };
    DebugConfigStrings.launchJsonCompletions = {
        label: vscode_1.l10n.t('Python'),
        description: vscode_1.l10n.t('Select a Python debug configuration'),
    };
    let file;
    (function (file) {
        file.snippet = {
            name: vscode_1.l10n.t('Python: Current File'),
        };
        file.selectConfiguration = {
            label: vscode_1.l10n.t('Python File'),
            description: vscode_1.l10n.t('Debug the currently active Python file'),
        };
    })(file = DebugConfigStrings.file || (DebugConfigStrings.file = {}));
    let module;
    (function (module) {
        module.snippet = {
            name: vscode_1.l10n.t('Python: Module'),
            default: vscode_1.l10n.t('enter-your-module-name'),
        };
        module.selectConfiguration = {
            label: vscode_1.l10n.t('Module'),
            description: vscode_1.l10n.t("Debug a Python module by invoking it with '-m'"),
        };
        module.enterModule = {
            title: vscode_1.l10n.t('Debug Module'),
            prompt: vscode_1.l10n.t('Enter a Python module/package name'),
            default: vscode_1.l10n.t('enter-your-module-name'),
            invalid: vscode_1.l10n.t('Enter a valid module name'),
        };
    })(module = DebugConfigStrings.module || (DebugConfigStrings.module = {}));
    let attach;
    (function (attach) {
        attach.snippet = {
            name: vscode_1.l10n.t('Python: Remote Attach'),
        };
        attach.selectConfiguration = {
            label: vscode_1.l10n.t('Remote Attach'),
            description: vscode_1.l10n.t('Attach to a remote debug server'),
        };
        attach.enterRemoteHost = {
            title: vscode_1.l10n.t('Remote Debugging'),
            prompt: vscode_1.l10n.t('Enter a valid host name or IP address'),
            invalid: vscode_1.l10n.t('Enter a valid host name or IP address'),
        };
        attach.enterRemotePort = {
            title: vscode_1.l10n.t('Remote Debugging'),
            prompt: vscode_1.l10n.t('Enter the port number that the debug server is listening on'),
            invalid: vscode_1.l10n.t('Enter a valid port number'),
        };
    })(attach = DebugConfigStrings.attach || (DebugConfigStrings.attach = {}));
    let attachPid;
    (function (attachPid) {
        attachPid.snippet = {
            name: vscode_1.l10n.t('Python: Attach using Process Id'),
        };
        attachPid.selectConfiguration = {
            label: vscode_1.l10n.t('Attach using Process ID'),
            description: vscode_1.l10n.t('Attach to a local process'),
        };
    })(attachPid = DebugConfigStrings.attachPid || (DebugConfigStrings.attachPid = {}));
    let django;
    (function (django) {
        django.snippet = {
            name: vscode_1.l10n.t('Python: Django'),
        };
        django.selectConfiguration = {
            label: vscode_1.l10n.t('Django'),
            description: vscode_1.l10n.t('Launch and debug a Django web application'),
        };
        django.enterManagePyPath = {
            title: vscode_1.l10n.t('Debug Django'),
            prompt: vscode_1.l10n.t("Enter the path to manage.py ('${workspaceFolder}' points to the root of the current workspace folder)"),
            invalid: vscode_1.l10n.t('Enter a valid Python file path'),
        };
    })(django = DebugConfigStrings.django || (DebugConfigStrings.django = {}));
    let fastapi;
    (function (fastapi) {
        fastapi.snippet = {
            name: vscode_1.l10n.t('Python: FastAPI'),
        };
        fastapi.selectConfiguration = {
            label: vscode_1.l10n.t('FastAPI'),
            description: vscode_1.l10n.t('Launch and debug a FastAPI web application'),
        };
        fastapi.enterAppPathOrNamePath = {
            title: vscode_1.l10n.t('Debug FastAPI'),
            prompt: vscode_1.l10n.t("Enter the path to the application, e.g. 'main.py' or 'main'"),
            invalid: vscode_1.l10n.t('Enter a valid name'),
        };
    })(fastapi = DebugConfigStrings.fastapi || (DebugConfigStrings.fastapi = {}));
    let flask;
    (function (flask) {
        flask.snippet = {
            name: vscode_1.l10n.t('Python: Flask'),
        };
        flask.selectConfiguration = {
            label: vscode_1.l10n.t('Flask'),
            description: vscode_1.l10n.t('Launch and debug a Flask web application'),
        };
        flask.enterAppPathOrNamePath = {
            title: vscode_1.l10n.t('Debug Flask'),
            prompt: vscode_1.l10n.t('Python: Flask'),
            invalid: vscode_1.l10n.t('Enter a valid name'),
        };
    })(flask = DebugConfigStrings.flask || (DebugConfigStrings.flask = {}));
    let pyramid;
    (function (pyramid) {
        pyramid.snippet = {
            name: vscode_1.l10n.t('Python: Pyramid Application'),
        };
        pyramid.selectConfiguration = {
            label: vscode_1.l10n.t('Pyramid'),
            description: vscode_1.l10n.t('Launch and debug a Pyramid web application'),
        };
        pyramid.enterDevelopmentIniPath = {
            title: vscode_1.l10n.t('Debug Pyramid'),
            invalid: vscode_1.l10n.t('Enter a valid file path'),
        };
    })(pyramid = DebugConfigStrings.pyramid || (DebugConfigStrings.pyramid = {}));
})(DebugConfigStrings = exports.DebugConfigStrings || (exports.DebugConfigStrings = {}));
var Testing;
(function (Testing) {
    Testing.configureTests = vscode_1.l10n.t('Configure Test Framework');
    Testing.testNotConfigured = vscode_1.l10n.t('No test framework configured.');
    Testing.cancelUnittestDiscovery = vscode_1.l10n.t('Canceled unittest test discovery');
    Testing.errorUnittestDiscovery = vscode_1.l10n.t('Unittest test discovery error');
    Testing.cancelPytestDiscovery = vscode_1.l10n.t('Canceled pytest test discovery');
    Testing.errorPytestDiscovery = vscode_1.l10n.t('pytest test discovery error');
    Testing.seePythonOutput = vscode_1.l10n.t('(see Output > Python)');
    Testing.cancelUnittestExecution = vscode_1.l10n.t('Canceled unittest test execution');
    Testing.errorUnittestExecution = vscode_1.l10n.t('Unittest test execution error');
    Testing.cancelPytestExecution = vscode_1.l10n.t('Canceled pytest test execution');
    Testing.errorPytestExecution = vscode_1.l10n.t('Pytest test execution error');
})(Testing = exports.Testing || (exports.Testing = {}));
var OutdatedDebugger;
(function (OutdatedDebugger) {
    OutdatedDebugger.outdatedDebuggerMessage = vscode_1.l10n.t('We noticed you are attaching to ptvsd (Python debugger), which was deprecated on May 1st, 2020. Use [debugpy](https://aka.ms/migrateToDebugpy) instead.');
})(OutdatedDebugger = exports.OutdatedDebugger || (exports.OutdatedDebugger = {}));
var Python27Support;
(function (Python27Support) {
    Python27Support.jediMessage = vscode_1.l10n.t('IntelliSense with Jedi for Python 2.7 is no longer supported. [Learn more](https://aka.ms/python-27-support).');
})(Python27Support = exports.Python27Support || (exports.Python27Support = {}));
var SwitchToDefaultLS;
(function (SwitchToDefaultLS) {
    SwitchToDefaultLS.bannerMessage = vscode_1.l10n.t("The Microsoft Python Language Server has reached end of life. Your language server has been set to the default for Python in VS Code, Pylance.\n\nIf you'd like to change your language server, you can learn about how to do so [here](https://devblogs.microsoft.com/python/python-in-visual-studio-code-may-2021-release/#configuring-your-language-server).\n\nRead Pylance's license [here](https://marketplace.visualstudio.com/items/ms-python.vscode-pylance/license).");
})(SwitchToDefaultLS = exports.SwitchToDefaultLS || (exports.SwitchToDefaultLS = {}));
var CreateEnv;
(function (CreateEnv) {
    CreateEnv.informEnvCreation = vscode_1.l10n.t('The following environment is selected:');
    CreateEnv.statusTitle = vscode_1.l10n.t('Creating environment');
    CreateEnv.statusStarting = vscode_1.l10n.t('Starting...');
    CreateEnv.hasVirtualEnv = vscode_1.l10n.t('Workspace folder contains a virtual environment');
    CreateEnv.noWorkspace = vscode_1.l10n.t('A workspace is required when creating an environment using venv.');
    CreateEnv.pickWorkspacePlaceholder = vscode_1.l10n.t('Select a workspace to create environment');
    CreateEnv.providersQuickPickPlaceholder = vscode_1.l10n.t('Select an environment type');
    let Venv;
    (function (Venv) {
        Venv.creating = vscode_1.l10n.t('Creating venv...');
        Venv.creatingMicrovenv = vscode_1.l10n.t('Creating microvenv...');
        Venv.created = vscode_1.l10n.t('Environment created...');
        Venv.existing = vscode_1.l10n.t('Using existing environment...');
        Venv.downloadingPip = vscode_1.l10n.t('Downloading pip...');
        Venv.installingPip = vscode_1.l10n.t('Installing pip...');
        Venv.upgradingPip = vscode_1.l10n.t('Upgrading pip...');
        Venv.installingPackages = vscode_1.l10n.t('Installing packages...');
        Venv.errorCreatingEnvironment = vscode_1.l10n.t('Error while creating virtual environment.');
        Venv.selectPythonPlaceHolder = vscode_1.l10n.t('Select a Python installation to create the virtual environment');
        Venv.providerDescription = vscode_1.l10n.t('Creates a `.venv` virtual environment in the current workspace');
        Venv.error = vscode_1.l10n.t('Creating virtual environment failed with error.');
        Venv.tomlExtrasQuickPickTitle = vscode_1.l10n.t('Select optional dependencies to install from pyproject.toml');
        Venv.requirementsQuickPickTitle = vscode_1.l10n.t('Select dependencies to install');
        Venv.recreate = vscode_1.l10n.t('Recreate');
        Venv.recreateDescription = vscode_1.l10n.t('Delete existing ".venv" environment and create a new one');
        Venv.useExisting = vscode_1.l10n.t('Use Existing');
        Venv.useExistingDescription = vscode_1.l10n.t('Use existing ".venv" environment with no changes to it');
        Venv.existingVenvQuickPickPlaceholder = vscode_1.l10n.t('Choose an option to handle the existing ".venv" environment');
        Venv.deletingEnvironmentProgress = vscode_1.l10n.t('Deleting existing ".venv" environment...');
        Venv.errorDeletingEnvironment = vscode_1.l10n.t('Error while deleting existing ".venv" environment.');
    })(Venv = CreateEnv.Venv || (CreateEnv.Venv = {}));
    let Conda;
    (function (Conda) {
        Conda.condaMissing = vscode_1.l10n.t('Install `conda` to create conda environments.');
        Conda.created = vscode_1.l10n.t('Environment created...');
        Conda.installingPackages = vscode_1.l10n.t('Installing packages...');
        Conda.errorCreatingEnvironment = vscode_1.l10n.t('Error while creating conda environment.');
        Conda.selectPythonQuickPickPlaceholder = vscode_1.l10n.t('Select the version of Python to install in the environment');
        Conda.creating = vscode_1.l10n.t('Creating conda environment...');
        Conda.providerDescription = vscode_1.l10n.t('Creates a `.conda` Conda environment in the current workspace');
    })(Conda = CreateEnv.Conda || (CreateEnv.Conda = {}));
})(CreateEnv = exports.CreateEnv || (exports.CreateEnv = {}));
var ToolsExtensions;
(function (ToolsExtensions) {
    ToolsExtensions.flake8PromptMessage = vscode_1.l10n.t('Use the Flake8 extension to enable easier configuration and new features such as quick fixes.');
    ToolsExtensions.pylintPromptMessage = vscode_1.l10n.t('Use the Pylint extension to enable easier configuration and new features such as quick fixes.');
    ToolsExtensions.isortPromptMessage = vscode_1.l10n.t('To use sort imports, install the isort extension. It provides easier configuration and new features such as code actions.');
    ToolsExtensions.installPylintExtension = vscode_1.l10n.t('Install Pylint extension');
    ToolsExtensions.installFlake8Extension = vscode_1.l10n.t('Install Flake8 extension');
    ToolsExtensions.installISortExtension = vscode_1.l10n.t('Install isort extension');
    ToolsExtensions.selectBlackFormatterPrompt = vscode_1.l10n.t('You have the Black formatter extension installed, would you like to use that as the default formatter?');
    ToolsExtensions.selectAutopep8FormatterPrompt = vscode_1.l10n.t('You have the Autopep8 formatter extension installed, would you like to use that as the default formatter?');
    ToolsExtensions.selectMultipleFormattersPrompt = vscode_1.l10n.t('You have multiple formatters installed, would you like to select one as the default formatter?');
    ToolsExtensions.installBlackFormatterPrompt = vscode_1.l10n.t('You triggered formatting with Black, would you like to install one of our new formatter extensions? This will also set it as the default formatter for Python.');
    ToolsExtensions.installAutopep8FormatterPrompt = vscode_1.l10n.t('You triggered formatting with Autopep8, would you like to install one of our new formatter extension? This will also set it as the default formatter for Python.');
})(ToolsExtensions = exports.ToolsExtensions || (exports.ToolsExtensions = {}));


/***/ }),

/***/ "./src/client/common/utils/misc.ts":
/*!*****************************************!*\
  !*** ./src/client/common/utils/misc.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNotebookCell = exports.getURIFilter = exports.noop = void 0;
const constants_1 = __webpack_require__(/*! ../constants */ "./src/client/common/constants.ts");
const fs_paths_1 = __webpack_require__(/*! ../platform/fs-paths */ "./src/client/common/platform/fs-paths.ts");
function noop() { }
exports.noop = noop;
function isUri(resource) {
    if (!resource) {
        return false;
    }
    const uri = resource;
    return typeof uri.path === 'string' && typeof uri.scheme === 'string';
}
function getURIFilter(uri, opts = { checkParent: true }) {
    let uriPath = uri.path;
    while (uriPath.endsWith('/')) {
        uriPath = uriPath.slice(0, -1);
    }
    const uriRoot = `${uriPath}/`;
    function filter(candidate) {
        let candidatePath = candidate.path;
        while (candidatePath.endsWith('/')) {
            candidatePath = candidatePath.slice(0, -1);
        }
        if (opts.checkParent && (0, fs_paths_1.isParentPath)(candidatePath, uriRoot)) {
            return true;
        }
        if (opts.checkChild) {
            const candidateRoot = `${candidatePath}/`;
            if ((0, fs_paths_1.isParentPath)(uriPath, candidateRoot)) {
                return true;
            }
        }
        return false;
    }
    return filter;
}
exports.getURIFilter = getURIFilter;
function isNotebookCell(documentOrUri) {
    const uri = isUri(documentOrUri) ? documentOrUri : documentOrUri.uri;
    return uri.scheme.includes(constants_1.NotebookCellScheme) || uri.scheme.includes(constants_1.InteractiveInputScheme);
}
exports.isNotebookCell = isNotebookCell;


/***/ }),

/***/ "./src/client/common/utils/multiStepInput.ts":
/*!***************************************************!*\
  !*** ./src/client/common/utils/multiStepInput.ts ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MultiStepInputFactory = exports.IMultiStepInputFactory = exports.MultiStepInput = exports.InputFlowAction = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const types_1 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
const async_1 = __webpack_require__(/*! ./async */ "./src/client/common/utils/async.ts");
class InputFlowAction {
    constructor() {
    }
}
exports.InputFlowAction = InputFlowAction;
InputFlowAction.back = new InputFlowAction();
InputFlowAction.cancel = new InputFlowAction();
InputFlowAction.resume = new InputFlowAction();
class MultiStepInput {
    constructor(shell) {
        this.shell = shell;
        this.steps = [];
    }
    run(start, state) {
        return this.stepThrough(start, state);
    }
    async showQuickPick({ title, step, totalSteps, items, activeItem, placeholder, customButtonSetups, matchOnDescription, matchOnDetail, acceptFilterBoxTextAsSelection, onChangeItem, keepScrollPosition, sortByLabel, initialize, }) {
        const disposables = [];
        const input = this.shell.createQuickPick();
        input.title = title;
        input.step = step;
        try {
            input.sortByLabel = sortByLabel || false;
        }
        catch (_a) {
        }
        input.totalSteps = totalSteps;
        input.placeholder = placeholder;
        input.ignoreFocusOut = true;
        input.items = items;
        input.matchOnDescription = matchOnDescription || false;
        input.matchOnDetail = matchOnDetail || false;
        input.buttons = this.steps.length > 1 ? [vscode_1.QuickInputButtons.Back] : [];
        if (customButtonSetups) {
            for (const customButtonSetup of customButtonSetups) {
                input.buttons = [...input.buttons, customButtonSetup.button];
            }
        }
        if (this.current) {
            this.current.dispose();
        }
        this.current = input;
        if (onChangeItem) {
            disposables.push(onChangeItem.event((e) => onChangeItem.callback(e, input)));
        }
        if (initialize) {
            initialize(input);
        }
        if (activeItem) {
            input.activeItems = [await activeItem];
        }
        else {
            input.activeItems = [];
        }
        this.current.show();
        input.keepScrollPosition = keepScrollPosition;
        const deferred = (0, async_1.createDeferred)();
        disposables.push(input.onDidTriggerButton(async (item) => {
            if (item === vscode_1.QuickInputButtons.Back) {
                deferred.reject(InputFlowAction.back);
                input.hide();
            }
            if (customButtonSetups) {
                for (const customButtonSetup of customButtonSetups) {
                    if (JSON.stringify(item) === JSON.stringify(customButtonSetup === null || customButtonSetup === void 0 ? void 0 : customButtonSetup.button)) {
                        await (customButtonSetup === null || customButtonSetup === void 0 ? void 0 : customButtonSetup.callback(input));
                    }
                }
            }
        }), input.onDidChangeSelection((selectedItems) => deferred.resolve(selectedItems[0])), input.onDidHide(() => {
            if (!deferred.completed) {
                deferred.resolve(undefined);
            }
        }));
        if (acceptFilterBoxTextAsSelection) {
            disposables.push(input.onDidAccept(() => {
                deferred.resolve(input.value);
            }));
        }
        try {
            return await deferred.promise;
        }
        finally {
            disposables.forEach((d) => d.dispose());
        }
    }
    async showInputBox({ title, step, totalSteps, value, prompt, validate, password, buttons, }) {
        const disposables = [];
        try {
            return await new Promise((resolve, reject) => {
                const input = this.shell.createInputBox();
                input.title = title;
                input.step = step;
                input.totalSteps = totalSteps;
                input.password = !!password;
                input.value = value || '';
                input.prompt = prompt;
                input.ignoreFocusOut = true;
                input.buttons = [...(this.steps.length > 1 ? [vscode_1.QuickInputButtons.Back] : []), ...(buttons || [])];
                let validating = validate('');
                disposables.push(input.onDidTriggerButton((item) => {
                    if (item === vscode_1.QuickInputButtons.Back) {
                        reject(InputFlowAction.back);
                    }
                    else {
                        resolve(item);
                    }
                }), input.onDidAccept(async () => {
                    const inputValue = input.value;
                    input.enabled = false;
                    input.busy = true;
                    if (!(await validate(inputValue))) {
                        resolve(inputValue);
                    }
                    input.enabled = true;
                    input.busy = false;
                }), input.onDidChangeValue(async (text) => {
                    const current = validate(text);
                    validating = current;
                    const validationMessage = await current;
                    if (current === validating) {
                        input.validationMessage = validationMessage;
                    }
                }), input.onDidHide(() => {
                    resolve(undefined);
                }));
                if (this.current) {
                    this.current.dispose();
                }
                this.current = input;
                this.current.show();
            });
        }
        finally {
            disposables.forEach((d) => d.dispose());
        }
    }
    async stepThrough(start, state) {
        let step = start;
        while (step) {
            this.steps.push(step);
            if (this.current) {
                this.current.enabled = false;
                this.current.busy = true;
            }
            try {
                step = await step(this, state);
            }
            catch (err) {
                if (err === InputFlowAction.back) {
                    this.steps.pop();
                    step = this.steps.pop();
                    if (step === undefined) {
                        throw err;
                    }
                }
                else if (err === InputFlowAction.resume) {
                    step = this.steps.pop();
                }
                else if (err === InputFlowAction.cancel) {
                    step = undefined;
                }
                else {
                    throw err;
                }
            }
        }
        if (this.current) {
            this.current.dispose();
        }
    }
}
exports.MultiStepInput = MultiStepInput;
exports.IMultiStepInputFactory = Symbol('IMultiStepInputFactory');
let MultiStepInputFactory = class MultiStepInputFactory {
    constructor(shell) {
        this.shell = shell;
    }
    create() {
        return new MultiStepInput(this.shell);
    }
};
MultiStepInputFactory = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IApplicationShell))
], MultiStepInputFactory);
exports.MultiStepInputFactory = MultiStepInputFactory;


/***/ }),

/***/ "./src/client/common/utils/platform.ts":
/*!*********************************************!*\
  !*** ./src/client/common/utils/platform.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getUserHomeDir = exports.getEnvironmentVariable = exports.getArchitecture = exports.getOSType = exports.OSType = exports.Architecture = void 0;
var Architecture;
(function (Architecture) {
    Architecture[Architecture["Unknown"] = 1] = "Unknown";
    Architecture[Architecture["x86"] = 2] = "x86";
    Architecture[Architecture["x64"] = 3] = "x64";
})(Architecture = exports.Architecture || (exports.Architecture = {}));
var OSType;
(function (OSType) {
    OSType["Unknown"] = "Unknown";
    OSType["Windows"] = "Windows";
    OSType["OSX"] = "OSX";
    OSType["Linux"] = "Linux";
})(OSType = exports.OSType || (exports.OSType = {}));
function getOSType(platform = process.platform) {
    if (/^win/.test(platform)) {
        return OSType.Windows;
    }
    else if (/^darwin/.test(platform)) {
        return OSType.OSX;
    }
    else if (/^linux/.test(platform)) {
        return OSType.Linux;
    }
    else {
        return OSType.Unknown;
    }
}
exports.getOSType = getOSType;
const architectures = {
    x86: Architecture.x86,
    x64: Architecture.x64,
    '': Architecture.Unknown,
};
function getArchitecture() {
    const fromProc = architectures[process.arch];
    if (fromProc !== undefined) {
        return fromProc;
    }
    const arch = __webpack_require__(/*! arch */ "./node_modules/arch/index.js");
    return architectures[arch()] || Architecture.Unknown;
}
exports.getArchitecture = getArchitecture;
function getEnvironmentVariable(key) {
    return process.env[key];
}
exports.getEnvironmentVariable = getEnvironmentVariable;
function getUserHomeDir() {
    if (getOSType() === OSType.Windows) {
        return getEnvironmentVariable('USERPROFILE');
    }
    return getEnvironmentVariable('HOME') || getEnvironmentVariable('HOMEPATH');
}
exports.getUserHomeDir = getUserHomeDir;


/***/ }),

/***/ "./src/client/common/utils/random.ts":
/*!*******************************************!*\
  !*** ./src/client/common/utils/random.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Random = void 0;
const crypto = __webpack_require__(/*! crypto */ "crypto");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
function getRandom() {
    let num = 0;
    const buf = crypto.randomBytes(2);
    num = (buf.readUInt8(0) << 8) + buf.readUInt8(1);
    const maxValue = Math.pow(16, 4) - 1;
    return num / maxValue;
}
function getRandomBetween(min = 0, max = 10) {
    const randomVal = getRandom();
    return min + randomVal * (max - min);
}
let Random = class Random {
    getRandomInt(min = 0, max = 10) {
        return getRandomBetween(min, max);
    }
};
Random = __decorate([
    (0, inversify_1.injectable)()
], Random);
exports.Random = Random;


/***/ }),

/***/ "./src/client/common/utils/regexp.ts":
/*!*******************************************!*\
  !*** ./src/client/common/utils/regexp.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.verboseRegExp = void 0;
function verboseRegExp(pattern, flags) {
    pattern = pattern.replace(/(^| {2})# .*$/gm, '');
    pattern = pattern.replace(/\s+?/g, '');
    return RegExp(pattern, flags);
}
exports.verboseRegExp = verboseRegExp;


/***/ }),

/***/ "./src/client/common/utils/resourceLifecycle.ts":
/*!******************************************************!*\
  !*** ./src/client/common/utils/resourceLifecycle.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Disposables = exports.disposeAll = void 0;
async function disposeAll(disposables) {
    await Promise.all(disposables.map(async (d) => {
        try {
            return Promise.resolve(d.dispose());
        }
        catch (err) {
        }
        return Promise.resolve();
    }));
}
exports.disposeAll = disposeAll;
class Disposables {
    constructor(...disposables) {
        this.disposables = [];
        this.disposables.push(...disposables);
    }
    push(...disposables) {
        this.disposables.push(...disposables);
    }
    async dispose() {
        const { disposables } = this;
        this.disposables = [];
        await disposeAll(disposables);
    }
}
exports.Disposables = Disposables;


/***/ }),

/***/ "./src/client/common/utils/stopWatch.ts":
/*!**********************************************!*\
  !*** ./src/client/common/utils/stopWatch.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StopWatch = void 0;
class StopWatch {
    constructor() {
        this.started = new Date().getTime();
    }
    get elapsedTime() {
        return new Date().getTime() - this.started;
    }
    reset() {
        this.started = new Date().getTime();
    }
}
exports.StopWatch = StopWatch;


/***/ }),

/***/ "./src/client/common/utils/sysTypes.ts":
/*!*********************************************!*\
  !*** ./src/client/common/utils/sysTypes.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNumber = exports.isObject = exports.isString = exports.isArray = void 0;
const _typeof = {
    number: 'number',
    string: 'string',
    undefined: 'undefined',
    object: 'object',
    function: 'function',
};
function isArray(array) {
    if (Array.isArray) {
        return Array.isArray(array);
    }
    if (array && typeof array.length === _typeof.number && array.constructor === Array) {
        return true;
    }
    return false;
}
exports.isArray = isArray;
function isString(str) {
    if (typeof str === _typeof.string || str instanceof String) {
        return true;
    }
    return false;
}
exports.isString = isString;
function isObject(obj) {
    return (typeof obj === _typeof.object &&
        obj !== null &&
        !Array.isArray(obj) &&
        !(obj instanceof RegExp) &&
        !(obj instanceof Date));
}
exports.isObject = isObject;
function isNumber(obj) {
    if ((typeof obj === _typeof.number || obj instanceof Number) && !isNaN(obj)) {
        return true;
    }
    return false;
}
exports.isNumber = isNumber;


/***/ }),

/***/ "./src/client/common/utils/version.ts":
/*!********************************************!*\
  !*** ./src/client/common/utils/version.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseSemVerSafe = exports.areSimilarVersions = exports.areIdenticalVersion = exports.parseVersionInfo = exports.validateVersionInfo = exports.normalizeVersionInfo = exports.compareVersions = exports.isVersionInfoEmpty = exports.parseBasicVersionInfo = exports.getVersionString = exports.EMPTY_VERSION = void 0;
const semver = __webpack_require__(/*! semver */ "./node_modules/semver/semver.js");
const regexp_1 = __webpack_require__(/*! ./regexp */ "./src/client/common/utils/regexp.ts");
function normalizeVersionPart(part) {
    if (typeof part === 'number') {
        if (Number.isNaN(part)) {
            return [-1, 'missing'];
        }
        if (part < 0) {
            return [-1, ''];
        }
        return [part, ''];
    }
    if (typeof part === 'string') {
        const parsed = parseInt(part, 10);
        if (Number.isNaN(parsed)) {
            return [-1, 'string not numeric'];
        }
        if (parsed < 0) {
            return [-1, ''];
        }
        return [parsed, ''];
    }
    if (part === undefined || part === null) {
        return [-1, 'missing'];
    }
    return [-1, 'unsupported type'];
}
exports.EMPTY_VERSION = {
    major: -1,
    minor: -1,
    micro: -1,
};
Object.freeze(exports.EMPTY_VERSION);
function copyStrict(info) {
    const copied = {
        major: info.major,
        minor: info.minor,
        micro: info.micro,
    };
    const { unnormalized } = info;
    if (unnormalized !== undefined) {
        copied.unnormalized = {
            major: unnormalized.major,
            minor: unnormalized.minor,
            micro: unnormalized.micro,
        };
    }
    return copied;
}
function normalizeBasicVersionInfo(info) {
    if (!info) {
        return exports.EMPTY_VERSION;
    }
    const norm = copyStrict(info);
    if (norm.unnormalized === undefined) {
        norm.unnormalized = {};
        [norm.major, norm.unnormalized.major] = normalizeVersionPart(norm.major);
        [norm.minor, norm.unnormalized.minor] = normalizeVersionPart(norm.minor);
        [norm.micro, norm.unnormalized.micro] = normalizeVersionPart(norm.micro);
    }
    return norm;
}
function validateVersionPart(prop, part, unnormalized) {
    if (part === 0 || part > 0) {
        return;
    }
    if (!unnormalized || unnormalized === '') {
        return;
    }
    throw Error(`invalid ${prop} version (failed to normalize; ${unnormalized})`);
}
function validateBasicVersionInfo(info) {
    var _a, _b, _c;
    const raw = info;
    validateVersionPart('major', info.major, (_a = raw.unnormalized) === null || _a === void 0 ? void 0 : _a.major);
    validateVersionPart('minor', info.minor, (_b = raw.unnormalized) === null || _b === void 0 ? void 0 : _b.minor);
    validateVersionPart('micro', info.micro, (_c = raw.unnormalized) === null || _c === void 0 ? void 0 : _c.micro);
    if (info.major < 0) {
        throw Error('missing major version');
    }
    if (info.minor < 0) {
        if (info.micro === 0 || info.micro > 0) {
            throw Error('missing minor version');
        }
    }
}
function getVersionString(info) {
    if (info.major < 0) {
        return '';
    }
    if (info.minor < 0) {
        return `${info.major}`;
    }
    if (info.micro < 0) {
        return `${info.major}.${info.minor}`;
    }
    return `${info.major}.${info.minor}.${info.micro}`;
}
exports.getVersionString = getVersionString;
const basicVersionPattern = `
    ^
    (.*?)  # <before>
    (\\d+)  # <major>
    (?:
        [.]
        (\\d+)  # <minor>
        (?:
            [.]
            (\\d+)  # <micro>
        )?
    )?
    ([^\\d].*)?  # <after>
    $
`;
const basicVersionRegexp = (0, regexp_1.verboseRegExp)(basicVersionPattern, 's');
function parseBasicVersionInfo(verStr) {
    const match = verStr.match(basicVersionRegexp);
    if (!match) {
        return undefined;
    }
    const [, before, majorStr, minorStr, microStr, after] = match;
    if (before && before.endsWith('.')) {
        return undefined;
    }
    if (after && after !== '') {
        if (after === '.') {
            return undefined;
        }
        if (!before || before === '') {
            if (!microStr || microStr === '') {
                return undefined;
            }
        }
    }
    const major = parseInt(majorStr, 10);
    const minor = minorStr ? parseInt(minorStr, 10) : -1;
    const micro = microStr ? parseInt(microStr, 10) : -1;
    return {
        version: { major, minor, micro },
        before: before || '',
        after: after || '',
    };
}
exports.parseBasicVersionInfo = parseBasicVersionInfo;
function isVersionInfoEmpty(info) {
    if (!info) {
        return false;
    }
    if (typeof info.major !== 'number' || typeof info.minor !== 'number' || typeof info.micro !== 'number') {
        return false;
    }
    return info.major < 0 && info.minor < 0 && info.micro < 0;
}
exports.isVersionInfoEmpty = isVersionInfoEmpty;
function compareVersions(left, right, compareExtra) {
    if (left.major < right.major) {
        return [1, 'major'];
    }
    if (left.major > right.major) {
        return [-1, 'major'];
    }
    if (left.major === -1) {
        return [0, ''];
    }
    if (left.minor < right.minor) {
        return [1, 'minor'];
    }
    if (left.minor > right.minor) {
        return [-1, 'minor'];
    }
    if (left.minor === -1) {
        return [0, ''];
    }
    if (left.micro < right.micro) {
        return [1, 'micro'];
    }
    if (left.micro > right.micro) {
        return [-1, 'micro'];
    }
    if (compareExtra !== undefined) {
        return compareExtra(left, right);
    }
    return [0, ''];
}
exports.compareVersions = compareVersions;
function normalizeVersionInfo(info) {
    const norm = normalizeBasicVersionInfo(info);
    norm.raw = info.raw;
    if (!norm.raw) {
        norm.raw = '';
    }
    return norm;
}
exports.normalizeVersionInfo = normalizeVersionInfo;
function validateVersionInfo(info) {
    validateBasicVersionInfo(info);
}
exports.validateVersionInfo = validateVersionInfo;
function parseVersionInfo(verStr) {
    const result = parseBasicVersionInfo(verStr);
    if (result === undefined) {
        return undefined;
    }
    result.version.raw = verStr;
    return result;
}
exports.parseVersionInfo = parseVersionInfo;
function areIdenticalVersion(left, right, compareExtra) {
    const [result] = compareVersions(left, right, compareExtra);
    return result === 0;
}
exports.areIdenticalVersion = areIdenticalVersion;
function areSimilarVersions(left, right, compareExtra) {
    const [result, prop] = compareVersions(left, right, compareExtra);
    if (result === 0) {
        return true;
    }
    if (prop === 'major') {
        return false;
    }
    if (result < 0) {
        return right[prop] === -1;
    }
    return left[prop] === -1;
}
exports.areSimilarVersions = areSimilarVersions;
function parseSemVerSafe(raw) {
    raw = raw.replace(/\.00*(?=[1-9]|0\.)/, '.');
    const ver = semver.coerce(raw);
    if (ver === null || !semver.valid(ver)) {
        return new semver.SemVer('0.0.0');
    }
    return ver;
}
exports.parseSemVerSafe = parseSemVerSafe;


/***/ }),

/***/ "./src/client/common/utils/workerPool.ts":
/*!***********************************************!*\
  !*** ./src/client/common/utils/workerPool.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createRunningWorkerPool = exports.QueuePosition = void 0;
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const async_1 = __webpack_require__(/*! ./async */ "./src/client/common/utils/async.ts");
var QueuePosition;
(function (QueuePosition) {
    QueuePosition[QueuePosition["Back"] = 0] = "Back";
    QueuePosition[QueuePosition["Front"] = 1] = "Front";
})(QueuePosition = exports.QueuePosition || (exports.QueuePosition = {}));
class Worker {
    constructor(next, workFunc, postResult, name) {
        this.next = next;
        this.workFunc = workFunc;
        this.postResult = postResult;
        this.name = name;
        this.stopProcessing = false;
    }
    stop() {
        this.stopProcessing = true;
    }
    async start() {
        while (!this.stopProcessing) {
            try {
                const workItem = await this.next();
                try {
                    const result = await this.workFunc(workItem);
                    this.postResult(workItem, result);
                }
                catch (ex) {
                    this.postResult(workItem, undefined, ex);
                }
            }
            catch (ex) {
                (0, logging_1.traceError)(`Error while running worker[${this.name}].`, ex);
                continue;
            }
        }
    }
}
class WorkQueue {
    constructor() {
        this.items = [];
        this.results = new Map();
    }
    add(item, position) {
        const workItem = { item };
        if (position === QueuePosition.Front) {
            this.items.unshift(workItem);
        }
        else {
            this.items.push(workItem);
        }
        const deferred = (0, async_1.createDeferred)();
        this.results.set(workItem, deferred);
        return deferred.promise;
    }
    completed(workItem, result, error) {
        const deferred = this.results.get(workItem);
        if (deferred !== undefined) {
            this.results.delete(workItem);
            if (error !== undefined) {
                deferred.reject(error);
            }
            deferred.resolve(result);
        }
    }
    next() {
        return this.items.shift();
    }
    clear() {
        this.results.forEach((v, k, map) => {
            v.reject(Error('Queue stopped processing'));
            map.delete(k);
        });
    }
}
class WorkerPool {
    constructor(workerFunc, numWorkers = 2, name = 'Worker') {
        this.workerFunc = workerFunc;
        this.numWorkers = numWorkers;
        this.name = name;
        this.workers = [];
        this.waitingWorkersUnblockQueue = [];
        this.queue = new WorkQueue();
        this.stopProcessing = false;
    }
    addToQueue(item, position) {
        if (this.stopProcessing) {
            throw Error('Queue is stopped');
        }
        const deferred = this.queue.add(item, position);
        const worker = this.waitingWorkersUnblockQueue.shift();
        if (worker) {
            const workItem = this.queue.next();
            if (workItem !== undefined) {
                worker.unblock(workItem);
            }
            else {
                (0, logging_1.traceError)('Work queue was empty immediately after adding item.');
            }
        }
        return deferred;
    }
    start() {
        this.stopProcessing = false;
        let num = this.numWorkers;
        while (num > 0) {
            this.workers.push(new Worker(() => this.nextWorkItem(), (workItem) => this.workerFunc(workItem.item), (workItem, result, error) => this.queue.completed(workItem, result, error), `${this.name} ${num}`));
            num = num - 1;
        }
        this.workers.forEach(async (w) => w.start());
    }
    stop() {
        this.stopProcessing = true;
        let worker = this.workers.shift();
        while (worker) {
            worker.stop();
            worker = this.workers.shift();
        }
        this.queue.clear();
        let blockedWorker = this.waitingWorkersUnblockQueue.shift();
        while (blockedWorker) {
            blockedWorker.stop();
            blockedWorker = this.waitingWorkersUnblockQueue.shift();
        }
    }
    nextWorkItem() {
        const nextWorkItem = this.queue.next();
        if (nextWorkItem !== undefined) {
            return Promise.resolve(nextWorkItem);
        }
        return new Promise((resolve, reject) => {
            this.waitingWorkersUnblockQueue.push({
                unblock: (workItem) => {
                    if (this.stopProcessing) {
                        reject();
                    }
                    resolve(workItem);
                },
                stop: () => {
                    reject();
                },
            });
        });
    }
}
function createRunningWorkerPool(workerFunc, numWorkers, name) {
    const pool = new WorkerPool(workerFunc, numWorkers, name);
    pool.start();
    return pool;
}
exports.createRunningWorkerPool = createRunningWorkerPool;


/***/ }),

/***/ "./src/client/common/variables/environment.ts":
/*!****************************************************!*\
  !*** ./src/client/common/variables/environment.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.matchTarget = exports.restoreKeys = exports.normCaseKeys = exports.parseEnvFile = exports.EnvironmentVariablesService = void 0;
const fs_extra_1 = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const telemetry_1 = __webpack_require__(/*! ../../telemetry */ "./src/client/telemetry/index.ts");
const constants_1 = __webpack_require__(/*! ../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const types_1 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const types_2 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const fs_paths_1 = __webpack_require__(/*! ../platform/fs-paths */ "./src/client/common/platform/fs-paths.ts");
let EnvironmentVariablesService = class EnvironmentVariablesService {
    constructor(pathUtils, fs) {
        this.pathUtils = pathUtils;
        this.fs = fs;
    }
    async parseFile(filePath, baseVars) {
        if (!filePath || !(await this.fs.pathExists(filePath))) {
            return;
        }
        const contents = await this.fs.readFile(filePath).catch((ex) => {
            (0, logging_1.traceError)('Custom .env is likely not pointing to a valid file', ex);
            return undefined;
        });
        if (!contents) {
            return;
        }
        return parseEnvFile(contents, baseVars);
    }
    parseFileSync(filePath, baseVars) {
        if (!filePath || !(0, fs_extra_1.pathExistsSync)(filePath)) {
            return;
        }
        let contents;
        try {
            contents = (0, fs_extra_1.readFileSync)(filePath, { encoding: 'utf8' });
        }
        catch (ex) {
            (0, logging_1.traceError)('Custom .env is likely not pointing to a valid file', ex);
        }
        if (!contents) {
            return;
        }
        return parseEnvFile(contents, baseVars);
    }
    mergeVariables(source, target, options) {
        if (!target) {
            return;
        }
        const reference = target;
        target = normCaseKeys(target);
        source = normCaseKeys(source);
        const settingsNotToMerge = ['PYTHONPATH', this.pathVariable];
        Object.keys(source).forEach((setting) => {
            if (!(options === null || options === void 0 ? void 0 : options.mergeAll) && settingsNotToMerge.indexOf(setting) >= 0) {
                return;
            }
            if (target[setting] === undefined || (options === null || options === void 0 ? void 0 : options.overwrite)) {
                target[setting] = source[setting];
            }
        });
        restoreKeys(target);
        matchTarget(reference, target);
    }
    appendPythonPath(vars, ...pythonPaths) {
        return this.appendPaths(vars, 'PYTHONPATH', ...pythonPaths);
    }
    appendPath(vars, ...paths) {
        return this.appendPaths(vars, this.pathVariable, ...paths);
    }
    get pathVariable() {
        if (!this._pathVariable) {
            this._pathVariable = this.pathUtils.getPathVariableName();
        }
        return (0, fs_paths_1.normCase)(this._pathVariable);
    }
    appendPaths(vars, variableName, ...pathsToAppend) {
        const reference = vars;
        vars = normCaseKeys(vars);
        variableName = (0, fs_paths_1.normCase)(variableName);
        vars = this._appendPaths(vars, variableName, ...pathsToAppend);
        restoreKeys(vars);
        matchTarget(reference, vars);
        return vars;
    }
    _appendPaths(vars, variableName, ...pathsToAppend) {
        const valueToAppend = pathsToAppend
            .filter((item) => typeof item === 'string' && item.trim().length > 0)
            .map((item) => item.trim())
            .join(path.delimiter);
        if (valueToAppend.length === 0) {
            return vars;
        }
        const variable = vars ? vars[variableName] : undefined;
        if (variable && typeof variable === 'string' && variable.length > 0) {
            vars[variableName] = variable + path.delimiter + valueToAppend;
        }
        else {
            vars[variableName] = valueToAppend;
        }
        return vars;
    }
};
EnvironmentVariablesService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.IPathUtils)),
    __param(1, (0, inversify_1.inject)(types_1.IFileSystem))
], EnvironmentVariablesService);
exports.EnvironmentVariablesService = EnvironmentVariablesService;
function parseEnvFile(lines, baseVars) {
    const globalVars = baseVars ? baseVars : {};
    const vars = {};
    lines
        .toString()
        .split('\n')
        .forEach((line, _idx) => {
        const [name, value] = parseEnvLine(line);
        if (name === '') {
            return;
        }
        vars[name] = substituteEnvVars(value, vars, globalVars);
    });
    return vars;
}
exports.parseEnvFile = parseEnvFile;
function parseEnvLine(line) {
    const match = line.match(/^\s*(_*[a-zA-Z]\w*)\s*=\s*(.*?)?\s*$/);
    if (!match) {
        return ['', ''];
    }
    const name = match[1];
    let value = match[2];
    if (value && value !== '') {
        if (value[0] === "'" && value[value.length - 1] === "'") {
            value = value.substring(1, value.length - 1);
            value = value.replace(/\\n/gm, '\n');
        }
        else if (value[0] === '"' && value[value.length - 1] === '"') {
            value = value.substring(1, value.length - 1);
            value = value.replace(/\\n/gm, '\n');
        }
    }
    else {
        value = '';
    }
    return [name, value];
}
const SUBST_REGEX = /\${([a-zA-Z]\w*)?([^}\w].*)?}/g;
function substituteEnvVars(value, localVars, globalVars, missing = '') {
    let invalid = false;
    let replacement = value;
    replacement = replacement.replace(SUBST_REGEX, (match, substName, bogus, offset, orig) => {
        if (offset > 0 && orig[offset - 1] === '\\') {
            return match;
        }
        if ((bogus && bogus !== '') || !substName || substName === '') {
            invalid = true;
            return match;
        }
        return localVars[substName] || globalVars[substName] || missing;
    });
    if (!invalid && replacement !== value) {
        value = replacement;
        (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVFILE_VARIABLE_SUBSTITUTION);
    }
    return value.replace(/\\\$/g, '$');
}
function normCaseKeys(env) {
    const normalizedEnv = {};
    Object.keys(env).forEach((key) => {
        const normalizedKey = (0, fs_paths_1.normCase)(key);
        normalizedEnv[normalizedKey] = env[key];
    });
    return normalizedEnv;
}
exports.normCaseKeys = normCaseKeys;
function restoreKeys(env) {
    const processEnvKeys = Object.keys(process.env);
    processEnvKeys.forEach((processEnvKey) => {
        const originalKey = (0, fs_paths_1.normCase)(processEnvKey);
        if (originalKey !== processEnvKey && env[originalKey] !== undefined) {
            env[processEnvKey] = env[originalKey];
            delete env[originalKey];
        }
    });
}
exports.restoreKeys = restoreKeys;
function matchTarget(reference, target) {
    Object.keys(reference).forEach((key) => {
        if (target.hasOwnProperty(key)) {
            reference[key] = target[key];
        }
        else {
            delete reference[key];
        }
    });
    Object.keys(target).forEach((key) => {
        if (!reference.hasOwnProperty(key)) {
            reference[key] = target[key];
        }
    });
}
exports.matchTarget = matchTarget;


/***/ }),

/***/ "./src/client/common/variables/environmentVariablesProvider.ts":
/*!*********************************************************************!*\
  !*** ./src/client/common/variables/environmentVariablesProvider.ts ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvironmentVariablesProvider = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ../application/types */ "./src/client/common/application/types.ts");
const configSettings_1 = __webpack_require__(/*! ../configSettings */ "./src/client/common/configSettings.ts");
const types_2 = __webpack_require__(/*! ../platform/types */ "./src/client/common/platform/types.ts");
const types_3 = __webpack_require__(/*! ../types */ "./src/client/common/types.ts");
const cacheUtils_1 = __webpack_require__(/*! ../utils/cacheUtils */ "./src/client/common/utils/cacheUtils.ts");
const systemVariables_1 = __webpack_require__(/*! ./systemVariables */ "./src/client/common/variables/systemVariables.ts");
const types_4 = __webpack_require__(/*! ./types */ "./src/client/common/variables/types.ts");
const CACHE_DURATION = 60 * 60 * 1000;
let EnvironmentVariablesProvider = class EnvironmentVariablesProvider {
    constructor(envVarsService, disposableRegistry, platformService, workspaceService, process, cacheDuration = CACHE_DURATION) {
        this.envVarsService = envVarsService;
        this.platformService = platformService;
        this.workspaceService = workspaceService;
        this.process = process;
        this.cacheDuration = cacheDuration;
        this.trackedWorkspaceFolders = new Set();
        this.fileWatchers = new Map();
        this.disposables = [];
        this.envVarCaches = new Map();
        disposableRegistry.push(this);
        this.changeEventEmitter = new vscode_1.EventEmitter();
        const disposable = this.workspaceService.onDidChangeConfiguration(this.configurationChanged, this);
        this.disposables.push(disposable);
    }
    get onDidEnvironmentVariablesChange() {
        return this.changeEventEmitter.event;
    }
    dispose() {
        this.changeEventEmitter.dispose();
        this.fileWatchers.forEach((watcher) => {
            if (watcher) {
                watcher.dispose();
            }
        });
    }
    async getEnvironmentVariables(resource) {
        const cached = this.getCachedEnvironmentVariables(resource);
        if (cached) {
            return cached;
        }
        const vars = await this._getEnvironmentVariables(resource);
        this.setCachedEnvironmentVariables(resource, vars);
        (0, logging_1.traceVerbose)('Dump environment variables', JSON.stringify(vars, null, 4));
        return vars;
    }
    getEnvironmentVariablesSync(resource) {
        const cached = this.getCachedEnvironmentVariables(resource);
        if (cached) {
            return cached;
        }
        const vars = this._getEnvironmentVariablesSync(resource);
        this.setCachedEnvironmentVariables(resource, vars);
        return vars;
    }
    getCachedEnvironmentVariables(resource) {
        var _a, _b;
        const cacheKey = (_b = (_a = this.getWorkspaceFolderUri(resource)) === null || _a === void 0 ? void 0 : _a.fsPath) !== null && _b !== void 0 ? _b : '';
        const cache = this.envVarCaches.get(cacheKey);
        if (cache) {
            const cachedData = cache.data;
            if (cachedData) {
                return { ...cachedData };
            }
        }
        return undefined;
    }
    setCachedEnvironmentVariables(resource, vars) {
        var _a, _b;
        const cacheKey = (_b = (_a = this.getWorkspaceFolderUri(resource)) === null || _a === void 0 ? void 0 : _a.fsPath) !== null && _b !== void 0 ? _b : '';
        const cache = new cacheUtils_1.InMemoryCache(this.cacheDuration);
        this.envVarCaches.set(cacheKey, cache);
        cache.data = { ...vars };
    }
    async _getEnvironmentVariables(resource) {
        const customVars = await this.getCustomEnvironmentVariables(resource);
        return this.getMergedEnvironmentVariables(customVars);
    }
    _getEnvironmentVariablesSync(resource) {
        const customVars = this.getCustomEnvironmentVariablesSync(resource);
        return this.getMergedEnvironmentVariables(customVars);
    }
    getMergedEnvironmentVariables(mergedVars) {
        if (!mergedVars) {
            mergedVars = {};
        }
        this.envVarsService.mergeVariables(this.process.env, mergedVars);
        const pathVariable = this.platformService.pathVariableName;
        const pathValue = this.process.env[pathVariable];
        if (pathValue) {
            this.envVarsService.appendPath(mergedVars, pathValue);
        }
        if (this.process.env.PYTHONPATH) {
            this.envVarsService.appendPythonPath(mergedVars, this.process.env.PYTHONPATH);
        }
        return mergedVars;
    }
    async getCustomEnvironmentVariables(resource) {
        return this.envVarsService.parseFile(this.getEnvFile(resource), this.process.env);
    }
    getCustomEnvironmentVariablesSync(resource) {
        return this.envVarsService.parseFileSync(this.getEnvFile(resource), this.process.env);
    }
    getEnvFile(resource) {
        var _a;
        const systemVariables = new systemVariables_1.SystemVariables(undefined, (_a = configSettings_1.PythonSettings.getSettingsUriAndTarget(resource, this.workspaceService).uri) === null || _a === void 0 ? void 0 : _a.fsPath, this.workspaceService);
        const workspaceFolderUri = this.getWorkspaceFolderUri(resource);
        const envFileSetting = this.workspaceService.getConfiguration('python', resource).get('envFile');
        const envFile = systemVariables.resolveAny(envFileSetting);
        if (envFile === undefined) {
            (0, logging_1.traceError)('Unable to read `python.envFile` setting for resource', JSON.stringify(resource));
            return (workspaceFolderUri === null || workspaceFolderUri === void 0 ? void 0 : workspaceFolderUri.fsPath) ? path.join(workspaceFolderUri === null || workspaceFolderUri === void 0 ? void 0 : workspaceFolderUri.fsPath, '.env') : '';
        }
        this.trackedWorkspaceFolders.add(workspaceFolderUri ? workspaceFolderUri.fsPath : '');
        this.createFileWatcher(envFile, workspaceFolderUri);
        return envFile;
    }
    configurationChanged(e) {
        this.trackedWorkspaceFolders.forEach((item) => {
            const uri = item && item.length > 0 ? vscode_1.Uri.file(item) : undefined;
            if (e.affectsConfiguration('python.envFile', uri)) {
                this.onEnvironmentFileChanged(uri);
            }
        });
    }
    createFileWatcher(envFile, workspaceFolderUri) {
        if (this.fileWatchers.has(envFile)) {
            return;
        }
        try {
            const envFileWatcher = this.workspaceService.createFileSystemWatcher(envFile);
            this.fileWatchers.set(envFile, envFileWatcher);
            if (envFileWatcher) {
                this.disposables.push(envFileWatcher.onDidChange(() => this.onEnvironmentFileChanged(workspaceFolderUri)));
                this.disposables.push(envFileWatcher.onDidCreate(() => this.onEnvironmentFileCreated(workspaceFolderUri)));
                this.disposables.push(envFileWatcher.onDidDelete(() => this.onEnvironmentFileChanged(workspaceFolderUri)));
            }
        }
        catch (ex) {
            (0, logging_1.traceError)(`Failed to create a file system watcher for ${envFile} in ${workspaceFolderUri === null || workspaceFolderUri === void 0 ? void 0 : workspaceFolderUri.fsPath}`, ex);
        }
    }
    getWorkspaceFolderUri(resource) {
        if (!resource) {
            return undefined;
        }
        const workspaceFolder = this.workspaceService.getWorkspaceFolder(resource);
        return workspaceFolder ? workspaceFolder.uri : undefined;
    }
    onEnvironmentFileCreated(workspaceFolderUri) {
        this.onEnvironmentFileChanged(workspaceFolderUri);
    }
    onEnvironmentFileChanged(workspaceFolderUri) {
        this.envVarCaches.clear();
        this.changeEventEmitter.fire(workspaceFolderUri);
    }
};
EnvironmentVariablesProvider = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_4.IEnvironmentVariablesService)),
    __param(1, (0, inversify_1.inject)(types_3.IDisposableRegistry)),
    __param(2, (0, inversify_1.inject)(types_2.IPlatformService)),
    __param(3, (0, inversify_1.inject)(types_1.IWorkspaceService)),
    __param(4, (0, inversify_1.inject)(types_3.ICurrentProcess)),
    __param(5, (0, inversify_1.optional)())
], EnvironmentVariablesProvider);
exports.EnvironmentVariablesProvider = EnvironmentVariablesProvider;


/***/ }),

/***/ "./src/client/common/variables/serviceRegistry.ts":
/*!********************************************************!*\
  !*** ./src/client/common/variables/serviceRegistry.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const environment_1 = __webpack_require__(/*! ./environment */ "./src/client/common/variables/environment.ts");
const environmentVariablesProvider_1 = __webpack_require__(/*! ./environmentVariablesProvider */ "./src/client/common/variables/environmentVariablesProvider.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/common/variables/types.ts");
function registerTypes(serviceManager) {
    serviceManager.addSingleton(types_1.IEnvironmentVariablesService, environment_1.EnvironmentVariablesService);
    serviceManager.addSingleton(types_1.IEnvironmentVariablesProvider, environmentVariablesProvider_1.EnvironmentVariablesProvider);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/client/common/variables/systemVariables.ts":
/*!********************************************************!*\
  !*** ./src/client/common/variables/systemVariables.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SystemVariables = void 0;
const Path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const workspace_1 = __webpack_require__(/*! ../application/workspace */ "./src/client/common/application/workspace.ts");
const Types = __webpack_require__(/*! ../utils/sysTypes */ "./src/client/common/utils/sysTypes.ts");
class AbstractSystemVariables {
    resolve(value) {
        if (Types.isString(value)) {
            return this.__resolveString(value);
        }
        else if (Types.isArray(value)) {
            return this.__resolveArray(value);
        }
        else if (Types.isObject(value)) {
            return this.__resolveLiteral(value);
        }
        return value;
    }
    resolveAny(value) {
        if (Types.isString(value)) {
            return this.__resolveString(value);
        }
        else if (Types.isArray(value)) {
            return this.__resolveAnyArray(value);
        }
        else if (Types.isObject(value)) {
            return this.__resolveAnyLiteral(value);
        }
        return value;
    }
    __resolveString(value) {
        const regexp = /\$\{(.*?)\}/g;
        return value.replace(regexp, (match, name) => {
            const newValue = this[name];
            if (Types.isString(newValue)) {
                return newValue;
            }
            else {
                return match && (match.indexOf('env.') > 0 || match.indexOf('env:') > 0) ? '' : match;
            }
        });
    }
    __resolveLiteral(values) {
        const result = Object.create(null);
        Object.keys(values).forEach((key) => {
            const value = values[key];
            result[key] = this.resolve(value);
        });
        return result;
    }
    __resolveAnyLiteral(values) {
        const result = Object.create(null);
        Object.keys(values).forEach((key) => {
            const value = values[key];
            result[key] = this.resolveAny(value);
        });
        return result;
    }
    __resolveArray(value) {
        return value.map((s) => this.__resolveString(s));
    }
    __resolveAnyArray(value) {
        return value.map((s) => this.resolveAny(s));
    }
}
class SystemVariables extends AbstractSystemVariables {
    constructor(file, rootFolder, workspace, documentManager) {
        var _a;
        super();
        const workspaceFolder = workspace && file ? workspace.getWorkspaceFolder(file) : undefined;
        this._workspaceFolder = workspaceFolder ? workspaceFolder.uri.fsPath : rootFolder || __dirname;
        this._workspaceFolderName = Path.basename(this._workspaceFolder);
        this._filePath = file ? file.fsPath : undefined;
        if (documentManager && documentManager.activeTextEditor) {
            this._lineNumber = documentManager.activeTextEditor.selection.anchor.line + 1;
            this._selectedText = documentManager.activeTextEditor.document.getText(new vscode_1.Range(documentManager.activeTextEditor.selection.start, documentManager.activeTextEditor.selection.end));
        }
        this._execPath = process.execPath;
        Object.keys(process.env).forEach((key) => {
            this[`env:${key}`] = this[`env.${key}`] = process.env[key];
        });
        workspace = workspace !== null && workspace !== void 0 ? workspace : new workspace_1.WorkspaceService();
        try {
            (_a = workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.forEach((folder) => {
                const basename = Path.basename(folder.uri.fsPath);
                this[`workspaceFolder:${basename}`] =
                    folder.uri.fsPath;
            });
        }
        catch (_b) {
        }
    }
    get cwd() {
        return this.workspaceFolder;
    }
    get workspaceRoot() {
        return this._workspaceFolder;
    }
    get workspaceFolder() {
        return this._workspaceFolder;
    }
    get workspaceRootFolderName() {
        return this._workspaceFolderName;
    }
    get workspaceFolderBasename() {
        return this._workspaceFolderName;
    }
    get file() {
        return this._filePath;
    }
    get relativeFile() {
        return this.file ? Path.relative(this._workspaceFolder, this.file) : undefined;
    }
    get relativeFileDirname() {
        return this.relativeFile ? Path.dirname(this.relativeFile) : undefined;
    }
    get fileBasename() {
        return this.file ? Path.basename(this.file) : undefined;
    }
    get fileBasenameNoExtension() {
        return this.file ? Path.parse(this.file).name : undefined;
    }
    get fileDirname() {
        return this.file ? Path.dirname(this.file) : undefined;
    }
    get fileExtname() {
        return this.file ? Path.extname(this.file) : undefined;
    }
    get lineNumber() {
        return this._lineNumber;
    }
    get selectedText() {
        return this._selectedText;
    }
    get execPath() {
        return this._execPath;
    }
}
exports.SystemVariables = SystemVariables;


/***/ }),

/***/ "./src/client/common/variables/types.ts":
/*!**********************************************!*\
  !*** ./src/client/common/variables/types.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IEnvironmentVariablesProvider = exports.IEnvironmentVariablesService = void 0;
exports.IEnvironmentVariablesService = Symbol('IEnvironmentVariablesService');
exports.IEnvironmentVariablesProvider = Symbol('IEnvironmentVariablesProvider');


/***/ }),

/***/ "./src/client/common/vscodeApis/commandApis.ts":
/*!*****************************************************!*\
  !*** ./src/client/common/vscodeApis/commandApis.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.executeCommand = exports.registerCommand = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
function registerCommand(command, callback, thisArg) {
    return vscode_1.commands.registerCommand(command, callback, thisArg);
}
exports.registerCommand = registerCommand;
function executeCommand(command, ...rest) {
    return vscode_1.commands.executeCommand(command, ...rest);
}
exports.executeCommand = executeCommand;


/***/ }),

/***/ "./src/client/common/vscodeApis/windowApis.ts":
/*!****************************************************!*\
  !*** ./src/client/common/vscodeApis/windowApis.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createStepForwardEndNode = exports.createStepBackEndNode = exports.MultiStepNode = exports.showQuickPickWithBack = exports.MultiStepAction = exports.onDidChangeActiveTextEditor = exports.getActiveTextEditor = exports.withProgress = exports.showInformationMessage = exports.showErrorMessage = exports.createQuickPick = exports.showQuickPick = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const async_1 = __webpack_require__(/*! ../utils/async */ "./src/client/common/utils/async.ts");
function showQuickPick(items, options, token) {
    return vscode_1.window.showQuickPick(items, options, token);
}
exports.showQuickPick = showQuickPick;
function createQuickPick() {
    return vscode_1.window.createQuickPick();
}
exports.createQuickPick = createQuickPick;
function showErrorMessage(message, ...items) {
    return vscode_1.window.showErrorMessage(message, ...items);
}
exports.showErrorMessage = showErrorMessage;
function showInformationMessage(message, ...items) {
    return vscode_1.window.showInformationMessage(message, ...items);
}
exports.showInformationMessage = showInformationMessage;
function withProgress(options, task) {
    return vscode_1.window.withProgress(options, task);
}
exports.withProgress = withProgress;
function getActiveTextEditor() {
    const { activeTextEditor } = vscode_1.window;
    return activeTextEditor;
}
exports.getActiveTextEditor = getActiveTextEditor;
function onDidChangeActiveTextEditor(handler) {
    return vscode_1.window.onDidChangeActiveTextEditor(handler);
}
exports.onDidChangeActiveTextEditor = onDidChangeActiveTextEditor;
var MultiStepAction;
(function (MultiStepAction) {
    MultiStepAction["Back"] = "Back";
    MultiStepAction["Cancel"] = "Cancel";
    MultiStepAction["Continue"] = "Continue";
})(MultiStepAction = exports.MultiStepAction || (exports.MultiStepAction = {}));
async function showQuickPickWithBack(items, options, token) {
    var _a, _b, _c, _d;
    const quickPick = vscode_1.window.createQuickPick();
    const disposables = [quickPick];
    quickPick.items = items;
    quickPick.buttons = [vscode_1.QuickInputButtons.Back];
    quickPick.canSelectMany = (_a = options === null || options === void 0 ? void 0 : options.canPickMany) !== null && _a !== void 0 ? _a : false;
    quickPick.ignoreFocusOut = (_b = options === null || options === void 0 ? void 0 : options.ignoreFocusOut) !== null && _b !== void 0 ? _b : false;
    quickPick.matchOnDescription = (_c = options === null || options === void 0 ? void 0 : options.matchOnDescription) !== null && _c !== void 0 ? _c : false;
    quickPick.matchOnDetail = (_d = options === null || options === void 0 ? void 0 : options.matchOnDetail) !== null && _d !== void 0 ? _d : false;
    quickPick.placeholder = options === null || options === void 0 ? void 0 : options.placeHolder;
    quickPick.title = options === null || options === void 0 ? void 0 : options.title;
    const deferred = (0, async_1.createDeferred)();
    disposables.push(quickPick, quickPick.onDidTriggerButton((item) => {
        if (item === vscode_1.QuickInputButtons.Back) {
            deferred.reject(MultiStepAction.Back);
            quickPick.hide();
        }
    }), quickPick.onDidAccept(() => {
        if (!deferred.completed) {
            if (quickPick.canSelectMany) {
                deferred.resolve(quickPick.selectedItems.map((item) => item));
            }
            else {
                deferred.resolve(quickPick.selectedItems[0]);
            }
            quickPick.hide();
        }
    }), quickPick.onDidHide(() => {
        if (!deferred.completed) {
            deferred.resolve(undefined);
        }
    }));
    if (token) {
        disposables.push(token.onCancellationRequested(() => {
            quickPick.hide();
        }));
    }
    quickPick.show();
    try {
        return await deferred.promise;
    }
    finally {
        disposables.forEach((d) => d.dispose());
    }
}
exports.showQuickPickWithBack = showQuickPickWithBack;
class MultiStepNode {
    constructor(previous, current, next) {
        this.previous = previous;
        this.current = current;
        this.next = next;
    }
    static async run(step, context) {
        let nextStep = step;
        let flowAction = await nextStep.current(context);
        while (nextStep !== undefined) {
            if (flowAction === MultiStepAction.Cancel) {
                return flowAction;
            }
            if (flowAction === MultiStepAction.Back) {
                nextStep = nextStep === null || nextStep === void 0 ? void 0 : nextStep.previous;
            }
            if (flowAction === MultiStepAction.Continue) {
                nextStep = nextStep === null || nextStep === void 0 ? void 0 : nextStep.next;
            }
            if (nextStep) {
                flowAction = await (nextStep === null || nextStep === void 0 ? void 0 : nextStep.current(flowAction));
            }
        }
        return flowAction;
    }
}
exports.MultiStepNode = MultiStepNode;
function createStepBackEndNode(deferred) {
    return new MultiStepNode(undefined, async () => {
        if (deferred) {
            deferred.reject(MultiStepAction.Back);
        }
        return Promise.resolve(MultiStepAction.Back);
    }, undefined);
}
exports.createStepBackEndNode = createStepBackEndNode;
function createStepForwardEndNode(deferred, result) {
    return new MultiStepNode(undefined, async () => {
        if (deferred) {
            deferred.resolve(result);
        }
        return Promise.resolve(MultiStepAction.Back);
    }, undefined);
}
exports.createStepForwardEndNode = createStepForwardEndNode;


/***/ }),

/***/ "./src/client/common/vscodeApis/workspaceApis.ts":
/*!*******************************************************!*\
  !*** ./src/client/common/vscodeApis/workspaceApis.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.onDidChangeConfiguration = exports.onDidChangeTextDocument = exports.onDidOpenTextDocument = exports.getOpenTextDocuments = exports.onDidSaveTextDocument = exports.onDidCloseTextDocument = exports.findFiles = exports.applyEdit = exports.getConfiguration = exports.getWorkspaceFolderPaths = exports.getWorkspaceFolder = exports.getWorkspaceFolders = void 0;
const vscode = __webpack_require__(/*! vscode */ "vscode");
function getWorkspaceFolders() {
    return vscode.workspace.workspaceFolders;
}
exports.getWorkspaceFolders = getWorkspaceFolders;
function getWorkspaceFolder(uri) {
    return uri ? vscode.workspace.getWorkspaceFolder(uri) : undefined;
}
exports.getWorkspaceFolder = getWorkspaceFolder;
function getWorkspaceFolderPaths() {
    var _a, _b;
    return (_b = (_a = vscode.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.map((w) => w.uri.fsPath)) !== null && _b !== void 0 ? _b : [];
}
exports.getWorkspaceFolderPaths = getWorkspaceFolderPaths;
function getConfiguration(section, scope) {
    return vscode.workspace.getConfiguration(section, scope);
}
exports.getConfiguration = getConfiguration;
function applyEdit(edit) {
    return vscode.workspace.applyEdit(edit);
}
exports.applyEdit = applyEdit;
function findFiles(include, exclude, maxResults, token) {
    return vscode.workspace.findFiles(include, exclude, maxResults, token);
}
exports.findFiles = findFiles;
function onDidCloseTextDocument(handler) {
    return vscode.workspace.onDidCloseTextDocument(handler);
}
exports.onDidCloseTextDocument = onDidCloseTextDocument;
function onDidSaveTextDocument(handler) {
    return vscode.workspace.onDidSaveTextDocument(handler);
}
exports.onDidSaveTextDocument = onDidSaveTextDocument;
function getOpenTextDocuments() {
    return vscode.workspace.textDocuments;
}
exports.getOpenTextDocuments = getOpenTextDocuments;
function onDidOpenTextDocument(handler) {
    return vscode.workspace.onDidOpenTextDocument(handler);
}
exports.onDidOpenTextDocument = onDidOpenTextDocument;
function onDidChangeTextDocument(handler) {
    return vscode.workspace.onDidChangeTextDocument(handler);
}
exports.onDidChangeTextDocument = onDidChangeTextDocument;
function onDidChangeConfiguration(handler) {
    return vscode.workspace.onDidChangeConfiguration(handler);
}
exports.onDidChangeConfiguration = onDidChangeConfiguration;


/***/ }),

/***/ "./src/client/constants.ts":
/*!*********************************!*\
  !*** ./src/client/constants.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HiddenFilePrefix = exports.EXTENSION_ROOT_DIR = void 0;
const path = __webpack_require__(/*! path */ "path");
const folderName = path.basename(__dirname);
exports.EXTENSION_ROOT_DIR = folderName === 'client' ? path.join(__dirname, '..', '..') : path.join(__dirname, '..', '..', '..', '..');
exports.HiddenFilePrefix = '_HiddenFile_';


/***/ }),

/***/ "./src/client/extensionActivation.ts":
/*!*******************************************!*\
  !*** ./src/client/extensionActivation.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activateFeatures = exports.activateComponents = void 0;
const serviceRegistry_1 = __webpack_require__(/*! ./activation/serviceRegistry */ "./src/client/activation/serviceRegistry.ts");
const types_1 = __webpack_require__(/*! ./activation/types */ "./src/client/activation/types.ts");
const types_2 = __webpack_require__(/*! ./common/application/types */ "./src/client/common/application/types.ts");
const constants_1 = __webpack_require__(/*! ./common/constants */ "./src/client/common/constants.ts");
const types_3 = __webpack_require__(/*! ./common/types */ "./src/client/common/types.ts");
const serviceRegistry_2 = __webpack_require__(/*! ../environments/serviceRegistry */ "./src/environments/serviceRegistry.ts");
const pythonEnvironments = __webpack_require__(/*! ./pythonEnvironments */ "./src/client/pythonEnvironments/index.ts");
const types_4 = __webpack_require__(/*! ./interpreter/configuration/types */ "./src/client/interpreter/configuration/types.ts");
const registrations_1 = __webpack_require__(/*! ./pythonEnvironments/creation/registrations */ "./src/client/pythonEnvironments/creation/registrations.ts");
const sillyDI_1 = __webpack_require__(/*! ../environments/sillyDI */ "./src/environments/sillyDI.ts");
async function activateComponents(ext, components) {
    const legacyActivationResult = await activateLegacy(ext);
    const promises = [
        pythonEnvironments.activate(components.pythonEnvs, ext),
    ];
    return Promise.all([legacyActivationResult, ...promises]);
}
exports.activateComponents = activateComponents;
function activateFeatures(ext, _components) {
    const interpreterQuickPick = ext.legacyIOC.serviceContainer.get(types_4.IInterpreterQuickPick);
    (0, registrations_1.registerAllCreateEnvironmentFeatures)(ext.disposables, interpreterQuickPick);
}
exports.activateFeatures = activateFeatures;
async function activateLegacy(ext) {
    const { context, legacyIOC } = ext;
    const { serviceManager, serviceContainer } = legacyIOC;
    const applicationEnv = serviceManager.get(types_2.IApplicationEnvironment);
    const { enableProposedApi } = applicationEnv.packageJson;
    serviceManager.addSingletonInstance(constants_1.UseProposedApi, enableProposedApi);
    (0, serviceRegistry_1.registerTypes)(serviceManager);
    serviceManager.addSingleton(types_1.IExtensionActivationService, sillyDI_1.Dummy);
    const manager = serviceContainer.get(types_1.IExtensionActivationManager);
    context.subscriptions.push(manager);
    serviceContainer.get(types_3.IConfigurationService).getSettings();
    const activationPromise = manager.activate();
    (0, serviceRegistry_2.registerTypes)(serviceManager, context);
    return { fullyReady: activationPromise };
}


/***/ }),

/***/ "./src/client/extensionInit.ts":
/*!*************************************!*\
  !*** ./src/client/extensionInit.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.initializeComponents = exports.initializeStandard = exports.initializeGlobals = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const serviceRegistry_1 = __webpack_require__(/*! ./common/platform/serviceRegistry */ "./src/client/common/platform/serviceRegistry.ts");
const serviceRegistry_2 = __webpack_require__(/*! ./common/process/serviceRegistry */ "./src/client/common/process/serviceRegistry.ts");
const serviceRegistry_3 = __webpack_require__(/*! ./common/serviceRegistry */ "./src/client/common/serviceRegistry.ts");
const serviceRegistry_4 = __webpack_require__(/*! ./interpreter/serviceRegistry */ "./src/client/interpreter/serviceRegistry.ts");
const types_1 = __webpack_require__(/*! ./common/types */ "./src/client/common/types.ts");
const serviceRegistry_5 = __webpack_require__(/*! ./common/variables/serviceRegistry */ "./src/client/common/variables/serviceRegistry.ts");
const container_1 = __webpack_require__(/*! ./ioc/container */ "./src/client/ioc/container.ts");
const serviceManager_1 = __webpack_require__(/*! ./ioc/serviceManager */ "./src/client/ioc/serviceManager.ts");
const types_2 = __webpack_require__(/*! ./ioc/types */ "./src/client/ioc/types.ts");
const pythonEnvironments = __webpack_require__(/*! ./pythonEnvironments */ "./src/client/pythonEnvironments/index.ts");
const logging_1 = __webpack_require__(/*! ./logging */ "./src/client/logging/index.ts");
const outputChannelLogger_1 = __webpack_require__(/*! ./logging/outputChannelLogger */ "./src/client/logging/outputChannelLogger.ts");
const constants_1 = __webpack_require__(/*! ../environments/constants */ "./src/environments/constants.ts");
function initializeGlobals(context) {
    const disposables = context.subscriptions;
    const cont = new inversify_1.Container({ skipBaseClassChecks: true });
    const serviceManager = new serviceManager_1.ServiceManager(cont);
    const serviceContainer = new container_1.ServiceContainer(cont);
    serviceManager.addSingletonInstance(types_2.IServiceContainer, serviceContainer);
    serviceManager.addSingletonInstance(types_2.IServiceManager, serviceManager);
    serviceManager.addSingletonInstance(types_1.IDisposableRegistry, disposables);
    serviceManager.addSingletonInstance(types_1.IMemento, context.globalState, types_1.GLOBAL_MEMENTO);
    serviceManager.addSingletonInstance(types_1.IMemento, context.workspaceState, types_1.WORKSPACE_MEMENTO);
    serviceManager.addSingletonInstance(types_1.IExtensionContext, context);
    context.subscriptions.push((0, logging_1.registerLogger)(new outputChannelLogger_1.OutputChannelLogger(constants_1.loggingOutputChannel)));
    return {
        context,
        disposables,
        legacyIOC: { serviceManager, serviceContainer },
    };
}
exports.initializeGlobals = initializeGlobals;
function initializeStandard(ext) {
    const { serviceManager } = ext.legacyIOC;
    (0, serviceRegistry_3.registerTypes)(serviceManager);
    (0, serviceRegistry_5.registerTypes)(serviceManager);
    (0, serviceRegistry_1.registerTypes)(serviceManager);
    (0, serviceRegistry_2.registerTypes)(serviceManager);
    (0, serviceRegistry_4.registerTypes)(serviceManager);
}
exports.initializeStandard = initializeStandard;
async function initializeComponents(ext) {
    const pythonEnvs = await pythonEnvironments.initialize(ext);
    return {
        pythonEnvs,
    };
}
exports.initializeComponents = initializeComponents;


/***/ }),

/***/ "./src/client/interpreter/activation/service.ts":
/*!******************************************************!*\
  !*** ./src/client/interpreter/activation/service.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvironmentActivationService = exports.EnvironmentActivationServiceCache = exports.defaultShells = void 0;
__webpack_require__(/*! ../../common/extensions */ "./src/client/common/extensions.ts");
const path = __webpack_require__(/*! path */ "path");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const types_1 = __webpack_require__(/*! ../../common/application/types */ "./src/client/common/application/types.ts");
const constants_1 = __webpack_require__(/*! ../../common/constants */ "./src/client/common/constants.ts");
const types_2 = __webpack_require__(/*! ../../common/platform/types */ "./src/client/common/platform/types.ts");
const internalScripts = __webpack_require__(/*! ../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const types_3 = __webpack_require__(/*! ../../common/process/types */ "./src/client/common/process/types.ts");
const types_4 = __webpack_require__(/*! ../../common/terminal/types */ "./src/client/common/terminal/types.ts");
const types_5 = __webpack_require__(/*! ../../common/types */ "./src/client/common/types.ts");
const async_1 = __webpack_require__(/*! ../../common/utils/async */ "./src/client/common/utils/async.ts");
const cacheUtils_1 = __webpack_require__(/*! ../../common/utils/cacheUtils */ "./src/client/common/utils/cacheUtils.ts");
const platform_1 = __webpack_require__(/*! ../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const types_6 = __webpack_require__(/*! ../../common/variables/types */ "./src/client/common/variables/types.ts");
const info_1 = __webpack_require__(/*! ../../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const telemetry_1 = __webpack_require__(/*! ../../telemetry */ "./src/client/telemetry/index.ts");
const constants_2 = __webpack_require__(/*! ../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const contracts_1 = __webpack_require__(/*! ../contracts */ "./src/client/interpreter/contracts.ts");
const types_7 = __webpack_require__(/*! ../../logging/types */ "./src/client/logging/types.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const conda_1 = __webpack_require__(/*! ../../pythonEnvironments/common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const stopWatch_1 = __webpack_require__(/*! ../../common/utils/stopWatch */ "./src/client/common/utils/stopWatch.ts");
const baseShellDetector_1 = __webpack_require__(/*! ../../common/terminal/shellDetectors/baseShellDetector */ "./src/client/common/terminal/shellDetectors/baseShellDetector.ts");
const exec_1 = __webpack_require__(/*! ../../common/utils/exec */ "./src/client/common/utils/exec.ts");
const decorators_1 = __webpack_require__(/*! ../../common/utils/decorators */ "./src/client/common/utils/decorators.ts");
const ENVIRONMENT_PREFIX = 'e8b39361-0157-4923-80e1-22d70d46dee6';
const CACHE_DURATION = 10 * 60 * 1000;
const ENVIRONMENT_TIMEOUT = 30000;
const CONDA_ENVIRONMENT_TIMEOUT = 60000;
exports.defaultShells = {
    [platform_1.OSType.Windows]: { shell: 'cmd', shellType: types_4.TerminalShellType.commandPrompt },
    [platform_1.OSType.OSX]: { shell: 'bash', shellType: types_4.TerminalShellType.bash },
    [platform_1.OSType.Linux]: { shell: 'bash', shellType: types_4.TerminalShellType.bash },
    [platform_1.OSType.Unknown]: undefined,
};
const condaRetryMessages = [
    'The process cannot access the file because it is being used by another process',
    'The directory is not empty',
];
class EnvironmentActivationServiceCache {
    constructor() {
        this.normalMap = new Map();
    }
    static forceUseStatic() {
        EnvironmentActivationServiceCache.useStatic = true;
    }
    static forceUseNormal() {
        EnvironmentActivationServiceCache.useStatic = false;
    }
    get(key) {
        if (EnvironmentActivationServiceCache.useStatic) {
            return EnvironmentActivationServiceCache.staticMap.get(key);
        }
        return this.normalMap.get(key);
    }
    set(key, value) {
        if (EnvironmentActivationServiceCache.useStatic) {
            EnvironmentActivationServiceCache.staticMap.set(key, value);
        }
        else {
            this.normalMap.set(key, value);
        }
    }
    delete(key) {
        if (EnvironmentActivationServiceCache.useStatic) {
            EnvironmentActivationServiceCache.staticMap.delete(key);
        }
        else {
            this.normalMap.delete(key);
        }
    }
    clear() {
        if (!EnvironmentActivationServiceCache.useStatic) {
            this.normalMap.clear();
        }
    }
}
exports.EnvironmentActivationServiceCache = EnvironmentActivationServiceCache;
EnvironmentActivationServiceCache.useStatic = false;
EnvironmentActivationServiceCache.staticMap = new Map();
let EnvironmentActivationService = class EnvironmentActivationService {
    constructor(helper, platform, processServiceFactory, currentProcess, workspace, interpreterService, envVarsService) {
        this.helper = helper;
        this.platform = platform;
        this.processServiceFactory = processServiceFactory;
        this.currentProcess = currentProcess;
        this.workspace = workspace;
        this.interpreterService = interpreterService;
        this.envVarsService = envVarsService;
        this.disposables = [];
        this.activatedEnvVariablesCache = new EnvironmentActivationServiceCache();
        this.envVarsService.onDidEnvironmentVariablesChange(() => this.activatedEnvVariablesCache.clear(), this, this.disposables);
    }
    dispose() {
        this.disposables.forEach((d) => d.dispose());
    }
    async getActivatedEnvironmentVariables(resource, interpreter, allowExceptions, shell) {
        var _a;
        const stopWatch = new stopWatch_1.StopWatch();
        const workspaceKey = this.workspace.getWorkspaceFolderIdentifier(resource);
        interpreter = interpreter !== null && interpreter !== void 0 ? interpreter : (await this.interpreterService.getActiveInterpreter(resource));
        const interpreterPath = this.platform.isWindows ? interpreter === null || interpreter === void 0 ? void 0 : interpreter.path.toLowerCase() : interpreter === null || interpreter === void 0 ? void 0 : interpreter.path;
        const cacheKey = `${workspaceKey}_${interpreterPath}_${shell}`;
        if ((_a = this.activatedEnvVariablesCache.get(cacheKey)) === null || _a === void 0 ? void 0 : _a.hasData) {
            return this.activatedEnvVariablesCache.get(cacheKey).data;
        }
        const memCache = new cacheUtils_1.InMemoryCache(CACHE_DURATION);
        return this.getActivatedEnvironmentVariablesImpl(resource, interpreter, allowExceptions, shell)
            .then((vars) => {
            memCache.data = vars;
            this.activatedEnvVariablesCache.set(cacheKey, memCache);
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.PYTHON_INTERPRETER_ACTIVATION_ENVIRONMENT_VARIABLES, stopWatch.elapsedTime, { failed: false });
            return vars;
        })
            .catch((ex) => {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.PYTHON_INTERPRETER_ACTIVATION_ENVIRONMENT_VARIABLES, stopWatch.elapsedTime, { failed: true });
            throw ex;
        });
    }
    async getProcessEnvironmentVariables(resource, shell) {
        const globalInterpreters = this.interpreterService
            .getInterpreters()
            .filter((i) => !info_1.virtualEnvTypes.includes(i.envType));
        const interpreterPath = globalInterpreters.length > 0 && globalInterpreters[0] ? globalInterpreters[0].path : 'python';
        try {
            const [args, parse] = internalScripts.printEnvVariables();
            args.forEach((arg, i) => {
                args[i] = arg.toCommandArgumentForPythonMgrExt();
            });
            const command = `${interpreterPath} ${args.join(' ')}`;
            const processService = await this.processServiceFactory.create(resource, { doNotUseCustomEnvs: true });
            const result = await processService.shellExec(command, {
                shell,
                timeout: ENVIRONMENT_TIMEOUT,
                maxBuffer: 1000 * 1000,
                throwOnStdErr: false,
            });
            const returnedEnv = this.parseEnvironmentOutput(result.stdout, parse);
            return returnedEnv !== null && returnedEnv !== void 0 ? returnedEnv : process.env;
        }
        catch (ex) {
            return process.env;
        }
    }
    async getEnvironmentActivationShellCommands(resource, interpreter) {
        const shellInfo = exports.defaultShells[this.platform.osType];
        if (!shellInfo) {
            return [];
        }
        return this.helper.getEnvironmentActivationShellCommands(resource, shellInfo.shellType, interpreter);
    }
    async getActivatedEnvironmentVariablesImpl(resource, interpreter, allowExceptions, shell) {
        var _a, _b;
        let shellInfo = exports.defaultShells[this.platform.osType];
        if (!shellInfo) {
            return undefined;
        }
        if (shell) {
            const customShellType = (0, baseShellDetector_1.identifyShellFromShellPath)(shell);
            shellInfo = { shellType: customShellType, shell };
        }
        try {
            const processService = await this.processServiceFactory.create(resource);
            const customEnvVars = (_a = (await this.envVarsService.getEnvironmentVariables(resource))) !== null && _a !== void 0 ? _a : {};
            const hasCustomEnvVars = Object.keys(customEnvVars).length;
            const env = hasCustomEnvVars ? customEnvVars : { ...this.currentProcess.env };
            let command;
            const [args, parse] = internalScripts.printEnvVariables();
            args.forEach((arg, i) => {
                args[i] = arg.toCommandArgumentForPythonMgrExt();
            });
            if ((interpreter === null || interpreter === void 0 ? void 0 : interpreter.envType) === info_1.EnvironmentType.Conda) {
                const conda = await conda_1.Conda.getConda(shell);
                const pythonArgv = await (conda === null || conda === void 0 ? void 0 : conda.getRunPythonArgs({
                    name: interpreter.envName,
                    prefix: (_b = interpreter.envPath) !== null && _b !== void 0 ? _b : '',
                }));
                if (pythonArgv) {
                    command = [...pythonArgv, ...args].map((arg) => arg.toCommandArgumentForPythonMgrExt()).join(' ');
                }
            }
            if (!command) {
                const activationCommands = await this.helper.getEnvironmentActivationShellCommands(resource, shellInfo.shellType, interpreter);
                (0, logging_1.traceVerbose)(`Activation Commands received ${activationCommands} for shell ${shellInfo.shell}`);
                if (!activationCommands || !Array.isArray(activationCommands) || activationCommands.length === 0) {
                    if (interpreter && [info_1.EnvironmentType.Venv, info_1.EnvironmentType.Pyenv].includes(interpreter === null || interpreter === void 0 ? void 0 : interpreter.envType)) {
                        const key = (0, exec_1.getSearchPathEnvVarNames)()[0];
                        if (env[key]) {
                            env[key] = `${path.dirname(interpreter.path)}${path.delimiter}${env[key]}`;
                        }
                        else {
                            env[key] = `${path.dirname(interpreter.path)}`;
                        }
                        return env;
                    }
                    return undefined;
                }
                const activationCommand = fixActivationCommands(activationCommands).join(' && ');
                const commandSeparator = [types_4.TerminalShellType.powershell, types_4.TerminalShellType.powershellCore].includes(shellInfo.shellType)
                    ? ';'
                    : '&&';
                command = `${activationCommand} ${commandSeparator} echo '${ENVIRONMENT_PREFIX}' ${commandSeparator} python ${args.join(' ')}`;
            }
            const oldWarnings = env[constants_1.PYTHON_WARNINGS];
            env[constants_1.PYTHON_WARNINGS] = 'ignore';
            (0, logging_1.traceVerbose)(`${hasCustomEnvVars ? 'Has' : 'No'} Custom Env Vars`);
            (0, logging_1.traceVerbose)(`Activating Environment to capture Environment variables, ${command}`);
            let result;
            let tryCount = 1;
            let returnedEnv;
            while (!result) {
                try {
                    result = await processService.shellExec(command, {
                        env,
                        shell: shellInfo.shell,
                        timeout: (interpreter === null || interpreter === void 0 ? void 0 : interpreter.envType) === info_1.EnvironmentType.Conda
                            ? CONDA_ENVIRONMENT_TIMEOUT
                            : ENVIRONMENT_TIMEOUT,
                        maxBuffer: 1000 * 1000,
                        throwOnStdErr: false,
                    });
                    try {
                        returnedEnv = this.parseEnvironmentOutput(result.stdout, parse);
                    }
                    catch (ex) {
                        if (!result.stderr) {
                            throw ex;
                        }
                    }
                    if (result.stderr) {
                        if (returnedEnv) {
                            (0, logging_1.traceWarn)('Got env variables but with errors', result.stderr);
                        }
                        else {
                            throw new Error(`StdErr from ShellExec, ${result.stderr} for ${command}`);
                        }
                    }
                }
                catch (exc) {
                    const excString = exc.toString();
                    if (condaRetryMessages.find((m) => excString.includes(m)) && tryCount < 10) {
                        (0, logging_1.traceInfo)(`Conda is busy, attempting to retry ...`);
                        result = undefined;
                        tryCount += 1;
                        await (0, async_1.sleep)(500);
                    }
                    else {
                        throw exc;
                    }
                }
            }
            if (oldWarnings && returnedEnv) {
                returnedEnv[constants_1.PYTHON_WARNINGS] = oldWarnings;
            }
            else if (returnedEnv) {
                delete returnedEnv[constants_1.PYTHON_WARNINGS];
            }
            return returnedEnv;
        }
        catch (e) {
            (0, logging_1.traceError)('getActivatedEnvironmentVariables', e);
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ACTIVATE_ENV_TO_GET_ENV_VARS_FAILED, undefined, {
                isPossiblyCondaEnv: (interpreter === null || interpreter === void 0 ? void 0 : interpreter.envType) === info_1.EnvironmentType.Conda,
                terminal: shellInfo.shellType,
            });
            if (allowExceptions) {
                throw e;
            }
        }
        return undefined;
    }
    parseEnvironmentOutput(output, parse) {
        if (output.indexOf(ENVIRONMENT_PREFIX) === -1) {
            return parse(output);
        }
        output = output.substring(output.indexOf(ENVIRONMENT_PREFIX) + ENVIRONMENT_PREFIX.length);
        const js = output.substring(output.indexOf('{')).trim();
        return parse(js);
    }
};
__decorate([
    (0, logging_1.traceDecoratorVerbose)('getActivatedEnvironmentVariables', types_7.TraceOptions.Arguments)
], EnvironmentActivationService.prototype, "getActivatedEnvironmentVariables", null);
__decorate([
    (0, decorators_1.cache)(-1, true)
], EnvironmentActivationService.prototype, "getProcessEnvironmentVariables", null);
__decorate([
    (0, logging_1.traceDecoratorError)('Failed to parse Environment variables'),
    (0, logging_1.traceDecoratorVerbose)('parseEnvironmentOutput', types_7.TraceOptions.None)
], EnvironmentActivationService.prototype, "parseEnvironmentOutput", null);
EnvironmentActivationService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_4.ITerminalHelper)),
    __param(1, (0, inversify_1.inject)(types_2.IPlatformService)),
    __param(2, (0, inversify_1.inject)(types_3.IProcessServiceFactory)),
    __param(3, (0, inversify_1.inject)(types_5.ICurrentProcess)),
    __param(4, (0, inversify_1.inject)(types_1.IWorkspaceService)),
    __param(5, (0, inversify_1.inject)(contracts_1.IInterpreterService)),
    __param(6, (0, inversify_1.inject)(types_6.IEnvironmentVariablesProvider))
], EnvironmentActivationService);
exports.EnvironmentActivationService = EnvironmentActivationService;
function fixActivationCommands(commands) {
    return commands.map((cmd) => cmd.replace(/^source\s+/, '. '));
}


/***/ }),

/***/ "./src/client/interpreter/activation/types.ts":
/*!****************************************************!*\
  !*** ./src/client/interpreter/activation/types.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ITerminalEnvVarCollectionService = exports.IEnvironmentActivationService = void 0;
exports.IEnvironmentActivationService = Symbol('IEnvironmentActivationService');
exports.ITerminalEnvVarCollectionService = Symbol('ITerminalEnvVarCollectionService');


/***/ }),

/***/ "./src/client/interpreter/configuration/environmentTypeComparer.ts":
/*!*************************************************************************!*\
  !*** ./src/client/interpreter/configuration/environmentTypeComparer.ts ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnvLocationHeuristic = exports.isProblematicCondaEnvironment = exports.EnvironmentTypeComparer = exports.EnvLocationHeuristic = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const platform_1 = __webpack_require__(/*! ../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const activestate_1 = __webpack_require__(/*! ../../pythonEnvironments/common/environmentManagers/activestate */ "./src/client/pythonEnvironments/common/environmentManagers/activestate.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../pythonEnvironments/common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const info_1 = __webpack_require__(/*! ../../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const contracts_1 = __webpack_require__(/*! ../contracts */ "./src/client/interpreter/contracts.ts");
const utils_1 = __webpack_require__(/*! ../../../environments/utils */ "./src/environments/utils.ts");
var EnvLocationHeuristic;
(function (EnvLocationHeuristic) {
    EnvLocationHeuristic[EnvLocationHeuristic["Local"] = 1] = "Local";
    EnvLocationHeuristic[EnvLocationHeuristic["Global"] = 2] = "Global";
})(EnvLocationHeuristic = exports.EnvLocationHeuristic || (exports.EnvLocationHeuristic = {}));
let EnvironmentTypeComparer = class EnvironmentTypeComparer {
    constructor(interpreterHelper) {
        var _a, _b;
        this.interpreterHelper = interpreterHelper;
        this.workspaceFolderPath = (_b = (_a = this.interpreterHelper.getActiveWorkspaceUri(undefined)) === null || _a === void 0 ? void 0 : _a.folderUri.fsPath) !== null && _b !== void 0 ? _b : '';
    }
    compare(a, b) {
        if (isProblematicCondaEnvironment(a)) {
            return 1;
        }
        if (isProblematicCondaEnvironment(b)) {
            return -1;
        }
        const envLocationComparison = compareEnvironmentLocation(a, b, this.workspaceFolderPath);
        if (envLocationComparison !== 0) {
            return envLocationComparison;
        }
        const envTypeComparison = compareEnvironmentType(a, b);
        if (envTypeComparison !== 0) {
            return envTypeComparison;
        }
        const versionComparison = comparePythonVersionDescending(a.version, b.version);
        if (versionComparison !== 0) {
            return versionComparison;
        }
        if (isBaseCondaEnvironment(a)) {
            return 1;
        }
        if (isBaseCondaEnvironment(b)) {
            return -1;
        }
        const nameA = getSortName(a, this.interpreterHelper);
        const nameB = getSortName(b, this.interpreterHelper);
        if (nameA === nameB) {
            return 0;
        }
        return nameA > nameB ? 1 : -1;
    }
    compareV2(a, b) {
        if ((0, utils_1.isNonPythonCondaEnvironment)(a)) {
            return 1;
        }
        if ((0, utils_1.isNonPythonCondaEnvironment)(b)) {
            return -1;
        }
        const envTypeComparison = compareEnvironmentTypeV2(a, b);
        if (envTypeComparison !== 0) {
            return envTypeComparison;
        }
        const versionComparison = comparePythonVersionDescendingV2(a, b);
        if (versionComparison !== 0) {
            return versionComparison;
        }
        if (isBaseCondaEnvironmentV2(a)) {
            return 1;
        }
        if (isBaseCondaEnvironmentV2(b)) {
            return -1;
        }
        const nameA = getSortNameV2(a, this.interpreterHelper);
        const nameB = getSortNameV2(b, this.interpreterHelper);
        if (nameA === nameB) {
            return 0;
        }
        return nameA > nameB ? 1 : -1;
    }
    getRecommended(interpreters, resource) {
        const workspaceUri = this.interpreterHelper.getActiveWorkspaceUri(resource);
        const filteredInterpreters = interpreters.filter((i) => {
            var _a;
            if (isProblematicCondaEnvironment(i)) {
                return false;
            }
            if (i.envType === info_1.EnvironmentType.ActiveState &&
                (!i.path ||
                    !workspaceUri ||
                    !(0, activestate_1.isActiveStateEnvironmentForWorkspace)(i.path, workspaceUri.folderUri.fsPath))) {
                return false;
            }
            if (getEnvLocationHeuristic(i, (workspaceUri === null || workspaceUri === void 0 ? void 0 : workspaceUri.folderUri.fsPath) || '') === EnvLocationHeuristic.Local) {
                return true;
            }
            if (info_1.virtualEnvTypes.includes(i.envType)) {
                return false;
            }
            if (((_a = i.version) === null || _a === void 0 ? void 0 : _a.major) === 2) {
                return false;
            }
            return true;
        });
        filteredInterpreters.sort(this.compare.bind(this));
        return filteredInterpreters.length ? filteredInterpreters[0] : undefined;
    }
};
EnvironmentTypeComparer = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(contracts_1.IInterpreterHelper))
], EnvironmentTypeComparer);
exports.EnvironmentTypeComparer = EnvironmentTypeComparer;
function getSortName(info, interpreterHelper) {
    const sortNameParts = [];
    const envSuffixParts = [];
    if (info.version) {
        sortNameParts.push(info.version.raw);
    }
    if (info.architecture) {
        sortNameParts.push(getArchitectureSortName(info.architecture));
    }
    if (info.companyDisplayName && info.companyDisplayName.length > 0) {
        sortNameParts.push(info.companyDisplayName.trim());
    }
    else {
        sortNameParts.push('Python');
    }
    if (info.envType) {
        const name = interpreterHelper.getInterpreterTypeDisplayName(info.envType);
        if (name) {
            envSuffixParts.push(name);
        }
    }
    if (info.envName && info.envName.length > 0) {
        envSuffixParts.push(info.envName);
    }
    const envSuffix = envSuffixParts.length === 0 ? '' : `(${envSuffixParts.join(': ')})`;
    return `${sortNameParts.join(' ')} ${envSuffix}`.trim();
}
function getSortNameV2(info, interpreterHelper) {
    var _a, _b, _c;
    const sortNameParts = [];
    const envSuffixParts = [];
    if ((_a = info.version) === null || _a === void 0 ? void 0 : _a.sysVersion) {
        sortNameParts.push(info.version.sysVersion);
    }
    if (info.executable.bitness) {
        sortNameParts.push(info.executable.bitness);
    }
    const name = interpreterHelper.getInterpreterTypeDisplayName((0, utils_1.getEnvironmentType)(info));
    if (name) {
        envSuffixParts.push(name);
    }
    if ((_b = info.environment) === null || _b === void 0 ? void 0 : _b.name) {
        envSuffixParts.push((_c = info.environment) === null || _c === void 0 ? void 0 : _c.name);
    }
    const envSuffix = envSuffixParts.length === 0 ? '' : `(${envSuffixParts.join(': ')})`;
    return `${sortNameParts.join(' ')} ${envSuffix}`.trim();
}
function getArchitectureSortName(arch) {
    switch (arch) {
        case platform_1.Architecture.x64:
            return 'x64';
        case platform_1.Architecture.x86:
            return 'x86';
        default:
            return '';
    }
}
function isBaseCondaEnvironment(environment) {
    return (environment.envType === info_1.EnvironmentType.Conda &&
        (environment.envName === 'base' || environment.envName === 'miniconda'));
}
function isBaseCondaEnvironmentV2(environment) {
    var _a, _b;
    return ((0, utils_1.isCondaEnvironment)(environment) &&
        (((_a = environment.environment) === null || _a === void 0 ? void 0 : _a.name) === 'base' || ((_b = environment.environment) === null || _b === void 0 ? void 0 : _b.name) === 'miniconda'));
}
function isProblematicCondaEnvironment(environment) {
    return environment.envType === info_1.EnvironmentType.Conda && environment.path === 'python';
}
exports.isProblematicCondaEnvironment = isProblematicCondaEnvironment;
function comparePythonVersionDescending(a, b) {
    if (!a) {
        return 1;
    }
    if (!b) {
        return -1;
    }
    if (a.raw === b.raw) {
        return 0;
    }
    if (a.major === b.major) {
        if (a.minor === b.minor) {
            if (a.patch === b.patch) {
                return a.build.join(' ') > b.build.join(' ') ? -1 : 1;
            }
            return a.patch > b.patch ? -1 : 1;
        }
        return a.minor > b.minor ? -1 : 1;
    }
    return a.major > b.major ? -1 : 1;
}
function comparePythonVersionDescendingV2(a, b) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
    if (!a) {
        return 1;
    }
    if (!b) {
        return -1;
    }
    if (((_a = a.version) === null || _a === void 0 ? void 0 : _a.sysVersion) === ((_b = b.version) === null || _b === void 0 ? void 0 : _b.sysVersion)) {
        return 0;
    }
    if (((_c = a.version) === null || _c === void 0 ? void 0 : _c.major) === ((_d = b.version) === null || _d === void 0 ? void 0 : _d.major)) {
        if (((_e = a.version) === null || _e === void 0 ? void 0 : _e.minor) === ((_f = b.version) === null || _f === void 0 ? void 0 : _f.minor)) {
            if (((_g = a.version) === null || _g === void 0 ? void 0 : _g.micro) === ((_h = b.version) === null || _h === void 0 ? void 0 : _h.micro)) {
                return (((_k = (_j = a.version) === null || _j === void 0 ? void 0 : _j.release) === null || _k === void 0 ? void 0 : _k.serial) || 0) > (((_m = (_l = b.version) === null || _l === void 0 ? void 0 : _l.release) === null || _m === void 0 ? void 0 : _m.serial) || 0) ? -1 : 1;
            }
            return (((_o = a.version) === null || _o === void 0 ? void 0 : _o.micro) || 0) > (((_p = b.version) === null || _p === void 0 ? void 0 : _p.micro) || 0) ? -1 : 1;
        }
        return (((_q = a.version) === null || _q === void 0 ? void 0 : _q.minor) || 0) > (((_r = b.version) === null || _r === void 0 ? void 0 : _r.minor) || 0) ? -1 : 1;
    }
    return (((_s = a.version) === null || _s === void 0 ? void 0 : _s.major) || 0) > (((_t = b.version) === null || _t === void 0 ? void 0 : _t.major) || 0) ? -1 : 1;
}
function compareEnvironmentLocation(a, b, workspacePath) {
    const aHeuristic = getEnvLocationHeuristic(a, workspacePath);
    const bHeuristic = getEnvLocationHeuristic(b, workspacePath);
    return Math.sign(aHeuristic - bHeuristic);
}
function getEnvLocationHeuristic(environment, workspacePath) {
    if (workspacePath.length > 0 &&
        ((environment.envPath && (0, externalDependencies_1.isParentPath)(environment.envPath, workspacePath)) ||
            (environment.path && (0, externalDependencies_1.isParentPath)(environment.path, workspacePath)))) {
        return EnvLocationHeuristic.Local;
    }
    return EnvLocationHeuristic.Global;
}
exports.getEnvLocationHeuristic = getEnvLocationHeuristic;
function compareEnvironmentType(a, b) {
    const envTypeByPriority = getPrioritizedEnvironmentType();
    return Math.sign(envTypeByPriority.indexOf(a.envType) - envTypeByPriority.indexOf(b.envType));
}
function compareEnvironmentTypeV2(a, b) {
    const envTypeByPriority = getPrioritizedEnvironmentType();
    return Math.sign(envTypeByPriority.indexOf((0, utils_1.getEnvironmentType)(a)) - envTypeByPriority.indexOf((0, utils_1.getEnvironmentType)(b)));
}
function getPrioritizedEnvironmentType() {
    return [
        info_1.EnvironmentType.Poetry,
        info_1.EnvironmentType.Pipenv,
        info_1.EnvironmentType.VirtualEnvWrapper,
        info_1.EnvironmentType.Venv,
        info_1.EnvironmentType.VirtualEnv,
        info_1.EnvironmentType.ActiveState,
        info_1.EnvironmentType.Conda,
        info_1.EnvironmentType.Pyenv,
        info_1.EnvironmentType.MicrosoftStore,
        info_1.EnvironmentType.Global,
        info_1.EnvironmentType.System,
        info_1.EnvironmentType.Unknown,
    ];
}


/***/ }),

/***/ "./src/client/interpreter/configuration/interpreterSelector/commands/base.ts":
/*!***********************************************************************************!*\
  !*** ./src/client/interpreter/configuration/interpreterSelector/commands/base.ts ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BaseInterpreterSelectorCommand = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const localize_1 = __webpack_require__(/*! ../../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
let BaseInterpreterSelectorCommand = class BaseInterpreterSelectorCommand {
    constructor(commandManager, applicationShell, workspaceService, pathUtils, configurationService) {
        this.commandManager = commandManager;
        this.applicationShell = applicationShell;
        this.workspaceService = workspaceService;
        this.pathUtils = pathUtils;
        this.configurationService = configurationService;
        this.supportedWorkspaceTypes = { untrustedWorkspace: false, virtualWorkspace: true };
        this.disposables = [];
        this.disposables.push(this);
    }
    dispose() {
        this.disposables.forEach((disposable) => disposable.dispose());
    }
    async getConfigTargets(options) {
        const workspaceFolders = this.workspaceService.workspaceFolders;
        if (workspaceFolders === undefined || workspaceFolders.length === 0) {
            return [
                {
                    folderUri: undefined,
                    configTarget: vscode_1.ConfigurationTarget.Global,
                },
            ];
        }
        if (workspaceFolders.length === 1) {
            return [
                {
                    folderUri: workspaceFolders[0].uri,
                    configTarget: vscode_1.ConfigurationTarget.WorkspaceFolder,
                },
            ];
        }
        let quickPickItems = (options === null || options === void 0 ? void 0 : options.resetTarget)
            ? [
                {
                    label: localize_1.Common.clearAll,
                },
            ]
            : [];
        quickPickItems.push(...workspaceFolders.map((w) => {
            const selectedInterpreter = this.pathUtils.getDisplayName(this.configurationService.getSettings(w.uri).pythonPath, w.uri.fsPath);
            return {
                label: w.name,
                description: this.pathUtils.getDisplayName(path.dirname(w.uri.fsPath)),
                uri: w.uri,
                detail: selectedInterpreter,
            };
        }), {
            label: (options === null || options === void 0 ? void 0 : options.resetTarget) ? localize_1.Interpreters.clearAtWorkspace : localize_1.Interpreters.entireWorkspace,
            uri: workspaceFolders[0].uri,
        });
        const selection = await this.applicationShell.showQuickPick(quickPickItems, {
            placeHolder: (options === null || options === void 0 ? void 0 : options.resetTarget)
                ? 'Select the workspace folder to clear the interpreter for'
                : 'Select the workspace folder to set the interpreter',
        });
        if ((selection === null || selection === void 0 ? void 0 : selection.label) === localize_1.Common.clearAll) {
            const folderTargets = workspaceFolders.map((w) => ({
                folderUri: w.uri,
                configTarget: vscode_1.ConfigurationTarget.WorkspaceFolder,
            }));
            return [
                ...folderTargets,
                { folderUri: workspaceFolders[0].uri, configTarget: vscode_1.ConfigurationTarget.Workspace },
            ];
        }
        return selection
            ? selection.label === localize_1.Interpreters.entireWorkspace || selection.label === localize_1.Interpreters.clearAtWorkspace
                ? [{ folderUri: selection.uri, configTarget: vscode_1.ConfigurationTarget.Workspace }]
                : [{ folderUri: selection.uri, configTarget: vscode_1.ConfigurationTarget.WorkspaceFolder }]
            : undefined;
    }
};
BaseInterpreterSelectorCommand = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.unmanaged)()),
    __param(1, (0, inversify_1.unmanaged)()),
    __param(2, (0, inversify_1.unmanaged)()),
    __param(3, (0, inversify_1.unmanaged)()),
    __param(4, (0, inversify_1.unmanaged)())
], BaseInterpreterSelectorCommand);
exports.BaseInterpreterSelectorCommand = BaseInterpreterSelectorCommand;


/***/ }),

/***/ "./src/client/interpreter/configuration/interpreterSelector/commands/setInterpreter.ts":
/*!*********************************************************************************************!*\
  !*** ./src/client/interpreter/configuration/interpreterSelector/commands/setInterpreter.ts ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetInterpreterCommand = exports.EnvGroups = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const types_1 = __webpack_require__(/*! ../../../../common/application/types */ "./src/client/common/application/types.ts");
const constants_1 = __webpack_require__(/*! ../../../../common/constants */ "./src/client/common/constants.ts");
const fs_paths_1 = __webpack_require__(/*! ../../../../common/platform/fs-paths */ "./src/client/common/platform/fs-paths.ts");
const types_2 = __webpack_require__(/*! ../../../../common/platform/types */ "./src/client/common/platform/types.ts");
const types_3 = __webpack_require__(/*! ../../../../common/types */ "./src/client/common/types.ts");
const localize_1 = __webpack_require__(/*! ../../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const misc_1 = __webpack_require__(/*! ../../../../common/utils/misc */ "./src/client/common/utils/misc.ts");
const multiStepInput_1 = __webpack_require__(/*! ../../../../common/utils/multiStepInput */ "./src/client/common/utils/multiStepInput.ts");
const systemVariables_1 = __webpack_require__(/*! ../../../../common/variables/systemVariables */ "./src/client/common/variables/systemVariables.ts");
const info_1 = __webpack_require__(/*! ../../../../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const telemetry_1 = __webpack_require__(/*! ../../../../telemetry */ "./src/client/telemetry/index.ts");
const constants_2 = __webpack_require__(/*! ../../../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const contracts_1 = __webpack_require__(/*! ../../../contracts */ "./src/client/interpreter/contracts.ts");
const types_4 = __webpack_require__(/*! ../../types */ "./src/client/interpreter/configuration/types.ts");
const base_1 = __webpack_require__(/*! ./base */ "./src/client/interpreter/configuration/interpreterSelector/commands/base.ts");
const utils_1 = __webpack_require__(/*! ../../../../../environments/utils */ "./src/environments/utils.ts");
function isInterpreterQuickPickItem(item) {
    return 'interpreter' in item;
}
function isSpecialQuickPickItem(item) {
    return 'alwaysShow' in item;
}
function isSeparatorItem(item) {
    return 'kind' in item && item.kind === vscode_1.QuickPickItemKind.Separator;
}
var EnvGroups;
(function (EnvGroups) {
    EnvGroups.Workspace = localize_1.InterpreterQuickPickList.workspaceGroupName;
    EnvGroups.Conda = 'Conda';
    EnvGroups.Global = localize_1.InterpreterQuickPickList.globalGroupName;
    EnvGroups.VirtualEnv = 'VirtualEnv';
    EnvGroups.PipEnv = 'PipEnv';
    EnvGroups.Pyenv = 'Pyenv';
    EnvGroups.Venv = 'Venv';
    EnvGroups.Poetry = 'Poetry';
    EnvGroups.VirtualEnvWrapper = 'VirtualEnvWrapper';
    EnvGroups.ActiveState = 'ActiveState';
    EnvGroups.Recommended = localize_1.Common.recommended;
})(EnvGroups = exports.EnvGroups || (exports.EnvGroups = {}));
let SetInterpreterCommand = class SetInterpreterCommand extends base_1.BaseInterpreterSelectorCommand {
    constructor(applicationShell, pathUtils, configurationService, commandManager, multiStepFactory, platformService, interpreterSelector, workspaceService, interpreterService) {
        super(commandManager, applicationShell, workspaceService, pathUtils, configurationService);
        this.multiStepFactory = multiStepFactory;
        this.platformService = platformService;
        this.interpreterSelector = interpreterSelector;
        this.interpreterService = interpreterService;
        this.manualEntrySuggestion = {
            label: `${constants_1.Octicons.Add} ${localize_1.InterpreterQuickPickList.enterPath.label}`,
            alwaysShow: true,
        };
        this.refreshButton = {
            iconPath: new vscode_1.ThemeIcon(constants_1.ThemeIcons.Refresh),
            tooltip: localize_1.InterpreterQuickPickList.refreshInterpreterList,
        };
        this.noPythonInstalled = {
            label: `${constants_1.Octicons.Error} ${localize_1.InterpreterQuickPickList.noPythonInstalled}`,
            detail: localize_1.InterpreterQuickPickList.clickForInstructions,
            alwaysShow: true,
        };
        this.wasNoPythonInstalledItemClicked = false;
        this.tipToReloadWindow = {
            label: `${constants_1.Octicons.Lightbulb} Reload the window if you installed Python but don't see it`,
            detail: `Click to run \`Developer: Reload Window\` command`,
            alwaysShow: true,
        };
        this.isBusyLoadingPythonEnvs = false;
        this.isBusyLoadingPythonEnvs = true;
        python_extension_1.PythonExtension.api().then((api) => {
            this.api = api;
            api.environments.refreshEnvironments().finally(() => {
                this.isBusyLoadingPythonEnvs = false;
            });
        });
    }
    async activate() {
    }
    async _pickInterpreter(input, state, filter, params) {
        var _a, _b;
        const api = await python_extension_1.PythonExtension.api();
        const preserveOrderWhenFiltering = this.isBusyLoadingPythonEnvs;
        const suggestions = this._getItems(api, state.workspace, filter, params);
        state.path = undefined;
        const currentInterpreterPathDisplay = this.pathUtils.getDisplayName(this.configurationService.getSettings(state.workspace).pythonPath, state.workspace ? state.workspace.fsPath : undefined);
        const placeholder = (params === null || params === void 0 ? void 0 : params.placeholder) === null
            ? undefined
            : (_a = params === null || params === void 0 ? void 0 : params.placeholder) !== null && _a !== void 0 ? _a : vscode_1.l10n.t('Selected Interpreter: {0}', currentInterpreterPathDisplay);
        const title = (params === null || params === void 0 ? void 0 : params.title) === null ? undefined : (_b = params === null || params === void 0 ? void 0 : params.title) !== null && _b !== void 0 ? _b : localize_1.InterpreterQuickPickList.browsePath.openButtonLabel;
        const buttons = [
            {
                button: this.refreshButton,
                callback: (quickpickInput) => {
                    this.refreshCallback(quickpickInput, { isButton: true, showBackButton: params === null || params === void 0 ? void 0 : params.showBackButton });
                },
            },
        ];
        if (params === null || params === void 0 ? void 0 : params.showBackButton) {
            buttons.push({
                button: vscode_1.QuickInputButtons.Back,
                callback: () => {
                },
            });
        }
        const selection = await input.showQuickPick({
            placeholder,
            items: suggestions,
            sortByLabel: !preserveOrderWhenFiltering,
            keepScrollPosition: true,
            activeItem: this.getActiveItem(state.workspace, suggestions),
            matchOnDetail: true,
            matchOnDescription: true,
            title,
            customButtonSetups: buttons,
            initialize: (quickPick) => {
                if (this.api.environments.known.length === 0) {
                    this.refreshCallback(quickPick, { showBackButton: params === null || params === void 0 ? void 0 : params.showBackButton });
                }
                else {
                    this.refreshCallback(quickPick, {
                        ifNotTriggerredAlready: true,
                        showBackButton: params === null || params === void 0 ? void 0 : params.showBackButton,
                    });
                }
            },
            onChangeItem: {
                event: this.api.environments.onDidChangeEnvironments,
                callback: (event, quickPick) => {
                    if (this.isBusyLoadingPythonEnvs) {
                        quickPick.busy = true;
                        this.api.environments.refreshEnvironments().then(() => {
                            quickPick.busy = false;
                            this.updateQuickPickItems(api, quickPick, undefined, state.workspace, filter, params);
                        });
                    }
                    this.updateQuickPickItems(api, quickPick, event, state.workspace, filter, params);
                },
            },
        });
        if (selection === undefined) {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.SELECT_INTERPRETER_SELECTED, undefined, { action: 'escape' });
        }
        else if (selection.label === this.manualEntrySuggestion.label) {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.SELECT_INTERPRETER_ENTER_OR_FIND);
            return this._enterOrBrowseInterpreterPath.bind(this);
        }
        else if (selection.label === this.noPythonInstalled.label) {
            this.commandManager.executeCommand(constants_1.Commands.InstallPython).then(misc_1.noop, misc_1.noop);
            this.wasNoPythonInstalledItemClicked = true;
        }
        else if (selection.label === this.tipToReloadWindow.label) {
            this.commandManager.executeCommand('workbench.action.reloadWindow').then(misc_1.noop, misc_1.noop);
        }
        else {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.SELECT_INTERPRETER_SELECTED, undefined, { action: 'selected' });
            state.path = selection.path;
        }
        return undefined;
    }
    _getItems(api, resource, filter, params) {
        const suggestions = [this.manualEntrySuggestion];
        const defaultInterpreterPathSuggestion = this.getDefaultInterpreterPathSuggestion(resource);
        if (defaultInterpreterPathSuggestion) {
            suggestions.push(defaultInterpreterPathSuggestion);
        }
        const interpreterSuggestions = this.getSuggestions(api, resource, filter, params);
        this.finalizeItems(api, interpreterSuggestions, resource, params);
        suggestions.push(...interpreterSuggestions);
        return suggestions;
    }
    getSuggestions(api, resource, filter, params) {
        var _a;
        const workspaceFolder = this.workspaceService.getWorkspaceFolder(resource);
        const items = this.interpreterSelector
            .getSuggestions(api, resource, this.isBusyLoadingPythonEnvs)
            .filter((i) => !filter || filter(i.interpreter));
        if (this.isBusyLoadingPythonEnvs) {
            return items;
        }
        const itemsWithFullName = this.interpreterSelector
            .getSuggestions(api, resource, true)
            .filter((i) => !filter || filter(i.interpreter));
        let recommended;
        if (!(params === null || params === void 0 ? void 0 : params.skipRecommended)) {
            recommended = this.interpreterSelector.getRecommendedSuggestion(itemsWithFullName, (_a = this.workspaceService.getWorkspaceFolder(resource)) === null || _a === void 0 ? void 0 : _a.uri);
        }
        if (recommended && items[0].interpreter.id === recommended.interpreter.id) {
            items.shift();
        }
        return getGroupedQuickPickItems(items, recommended, workspaceFolder === null || workspaceFolder === void 0 ? void 0 : workspaceFolder.uri.fsPath);
    }
    async getActiveItem(resource, suggestions) {
        const interpreter = await this.interpreterService.getActiveInterpreter(resource);
        const activeInterpreterItem = suggestions.find((i) => isInterpreterQuickPickItem(i) && i.interpreter.id === (interpreter === null || interpreter === void 0 ? void 0 : interpreter.id));
        if (activeInterpreterItem) {
            return activeInterpreterItem;
        }
        const firstInterpreterSuggestion = suggestions.find((s) => isInterpreterQuickPickItem(s));
        if (firstInterpreterSuggestion) {
            return firstInterpreterSuggestion;
        }
        const noPythonInstalledItem = suggestions.find((i) => isSpecialQuickPickItem(i) && i.label === this.noPythonInstalled.label);
        return noPythonInstalledItem !== null && noPythonInstalledItem !== void 0 ? noPythonInstalledItem : suggestions[0];
    }
    getDefaultInterpreterPathSuggestion(resource) {
        const config = this.workspaceService.getConfiguration('python', resource);
        const systemVariables = new systemVariables_1.SystemVariables(resource, undefined, this.workspaceService);
        const defaultInterpreterPathValue = systemVariables.resolveAny(config.get('defaultInterpreterPath'));
        if (defaultInterpreterPathValue && defaultInterpreterPathValue !== 'python') {
            return {
                label: `${constants_1.Octicons.Gear} ${localize_1.InterpreterQuickPickList.defaultInterpreterPath.label}`,
                description: this.pathUtils.getDisplayName(defaultInterpreterPathValue, resource ? resource.fsPath : undefined),
                path: defaultInterpreterPathValue,
                alwaysShow: true,
            };
        }
        return undefined;
    }
    updateQuickPickItems(api, quickPick, event, resource, filter, params) {
        const activeItemBeforeUpdate = quickPick.activeItems.length > 0 ? quickPick.activeItems[0] : undefined;
        quickPick.items = this.getUpdatedItems(api, quickPick.items, event, resource, filter, params);
        const activeItem = activeItemBeforeUpdate
            ? quickPick.items.find((item) => {
                if (isInterpreterQuickPickItem(item) && isInterpreterQuickPickItem(activeItemBeforeUpdate)) {
                    return item.interpreter.id === activeItemBeforeUpdate.interpreter.id;
                }
                if (isSpecialQuickPickItem(item) && isSpecialQuickPickItem(activeItemBeforeUpdate)) {
                    return item.label === activeItemBeforeUpdate.label;
                }
                return false;
            })
            : undefined;
        quickPick.activeItems = activeItem ? [activeItem] : [];
    }
    getUpdatedItems(_api, _items, _event, _resource, _filter, _params) {
        return [];
    }
    finalizeItems(api, items, resource, params) {
        const interpreterSuggestions = this.interpreterSelector.getSuggestions(api, resource, true);
        if (!this.isBusyLoadingPythonEnvs) {
            if (interpreterSuggestions.length) {
                if (!(params === null || params === void 0 ? void 0 : params.skipRecommended)) {
                    this.setRecommendedItem(interpreterSuggestions, items, resource);
                }
                items.forEach((item, i) => {
                    if (isInterpreterQuickPickItem(item) && (0, utils_1.isNonPythonCondaEnvironment)(item.interpreter)) {
                        if (!items[i].label.includes(constants_1.Octicons.Warning)) {
                            items[i].label = `${constants_1.Octicons.Warning} ${items[i].label}`;
                            items[i].tooltip = localize_1.InterpreterQuickPickList.condaEnvWithoutPythonTooltip;
                        }
                    }
                });
            }
            else {
                if (!items.some((i) => isSpecialQuickPickItem(i) && i.label === this.noPythonInstalled.label)) {
                    items.push(this.noPythonInstalled);
                }
                if (this.wasNoPythonInstalledItemClicked &&
                    !items.some((i) => isSpecialQuickPickItem(i) && i.label === this.tipToReloadWindow.label)) {
                    items.push(this.tipToReloadWindow);
                }
            }
        }
    }
    setRecommendedItem(interpreterSuggestions, items, resource) {
        var _a, _b;
        const suggestion = this.interpreterSelector.getRecommendedSuggestion(interpreterSuggestions, (_a = this.workspaceService.getWorkspaceFolder(resource)) === null || _a === void 0 ? void 0 : _a.uri);
        if (!suggestion) {
            return;
        }
        const areItemsGrouped = items.find((item) => isSeparatorItem(item) && item.label === EnvGroups.Recommended);
        const recommended = (0, lodash_1.cloneDeep)(suggestion);
        recommended.label = `${constants_1.Octicons.Star} ${recommended.label}`;
        recommended.description = areItemsGrouped
            ?
                recommended.description
            : `${(_b = recommended.description) !== null && _b !== void 0 ? _b : ''} - ${localize_1.Common.recommended}`;
        const index = items.findIndex((item) => isInterpreterQuickPickItem(item) && item.interpreter.id === recommended.interpreter.id);
        if (index !== -1) {
            items[index] = recommended;
        }
    }
    refreshCallback(input, options) {
        input.buttons = this.getButtons(options);
        input.busy = true;
        this.api.environments
            .refreshEnvironments({})
            .finally(() => {
            input.busy = false;
            input.buttons = this.getButtons({ isButton: false, showBackButton: options === null || options === void 0 ? void 0 : options.showBackButton });
        })
            .ignoreErrors();
    }
    getButtons(options) {
        const buttons = [];
        if (options === null || options === void 0 ? void 0 : options.showBackButton) {
            buttons.push(vscode_1.QuickInputButtons.Back);
        }
        if (options === null || options === void 0 ? void 0 : options.isButton) {
            buttons.push({
                iconPath: new vscode_1.ThemeIcon(constants_1.ThemeIcons.SpinningLoader),
                tooltip: localize_1.InterpreterQuickPickList.refreshingInterpreterList,
            });
        }
        else {
            buttons.push(this.refreshButton);
        }
        return buttons;
    }
    async _enterOrBrowseInterpreterPath(input, state) {
        const items = [
            {
                label: localize_1.InterpreterQuickPickList.browsePath.label,
                detail: localize_1.InterpreterQuickPickList.browsePath.detail,
            },
        ];
        const selection = await input.showQuickPick({
            placeholder: localize_1.InterpreterQuickPickList.enterPath.placeholder,
            items,
            acceptFilterBoxTextAsSelection: true,
        });
        if (typeof selection === 'string') {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.SELECT_INTERPRETER_ENTER_CHOICE, undefined, { choice: 'enter' });
            state.path = selection;
        }
        else if (selection && selection.label === localize_1.InterpreterQuickPickList.browsePath.label) {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.SELECT_INTERPRETER_ENTER_CHOICE, undefined, { choice: 'browse' });
            const filtersKey = 'Executables';
            const filtersObject = {};
            filtersObject[filtersKey] = ['exe'];
            const uris = await this.applicationShell.showOpenDialog({
                filters: this.platformService.isWindows ? filtersObject : undefined,
                openLabel: localize_1.InterpreterQuickPickList.browsePath.openButtonLabel,
                canSelectMany: false,
                title: localize_1.InterpreterQuickPickList.browsePath.title,
            });
            if (uris && uris.length > 0) {
                state.path = uris[0].fsPath;
            }
            else {
                return Promise.reject(multiStepInput_1.InputFlowAction.resume);
            }
        }
        return Promise.resolve();
    }
    async setInterpreter() {
        const targetConfig = await this.getConfigTargets();
        if (!targetConfig) {
            return;
        }
        const wkspace = targetConfig[0].folderUri;
        const interpreterState = { path: undefined, workspace: wkspace };
        const multiStep = this.multiStepFactory.create();
        await multiStep.run((input, s) => this._pickInterpreter(input, s, undefined), interpreterState);
    }
    async getInterpreterViaQuickPick(workspace, filter, params) {
        const interpreterState = { path: undefined, workspace };
        const multiStep = this.multiStepFactory.create();
        await multiStep.run((input, s) => this._pickInterpreter(input, s, filter, params), interpreterState);
        return interpreterState.path;
    }
};
SetInterpreterCommand = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IApplicationShell)),
    __param(1, (0, inversify_1.inject)(types_3.IPathUtils)),
    __param(2, (0, inversify_1.inject)(types_3.IConfigurationService)),
    __param(3, (0, inversify_1.inject)(types_1.ICommandManager)),
    __param(4, (0, inversify_1.inject)(multiStepInput_1.IMultiStepInputFactory)),
    __param(5, (0, inversify_1.inject)(types_2.IPlatformService)),
    __param(6, (0, inversify_1.inject)(types_4.IInterpreterSelector)),
    __param(7, (0, inversify_1.inject)(types_1.IWorkspaceService)),
    __param(8, (0, inversify_1.inject)(contracts_1.IInterpreterService))
], SetInterpreterCommand);
exports.SetInterpreterCommand = SetInterpreterCommand;
function getGroupedQuickPickItems(items, recommended, workspacePath) {
    const updatedItems = [];
    if (recommended) {
        updatedItems.push({ label: EnvGroups.Recommended, kind: vscode_1.QuickPickItemKind.Separator }, recommended);
    }
    let previousGroup = EnvGroups.Recommended;
    for (const item of items) {
        previousGroup = addSeparatorIfApplicable(updatedItems, item, workspacePath, previousGroup);
        updatedItems.push(item);
    }
    return updatedItems;
}
function addSeparatorIfApplicable(items, newItem, workspacePath, previousGroup) {
    if (!previousGroup) {
        const lastItem = items.length ? items[items.length - 1] : undefined;
        previousGroup =
            lastItem && isInterpreterQuickPickItem(lastItem) ? getGroup(lastItem, workspacePath) : undefined;
    }
    const currentGroup = getGroup(newItem, workspacePath);
    if (!previousGroup || currentGroup !== previousGroup) {
        const separatorItem = { label: currentGroup, kind: vscode_1.QuickPickItemKind.Separator };
        items.push(separatorItem);
        previousGroup = currentGroup;
    }
    return previousGroup;
}
function getGroup(item, workspacePath) {
    if (workspacePath && (0, fs_paths_1.isParentPath)(item.path, workspacePath)) {
        return EnvGroups.Workspace;
    }
    const envType = (0, utils_1.getEnvironmentType)(item.interpreter);
    switch (envType) {
        case info_1.EnvironmentType.Global:
        case info_1.EnvironmentType.System:
        case info_1.EnvironmentType.Unknown:
        case info_1.EnvironmentType.MicrosoftStore:
            return EnvGroups.Global;
        default:
            return EnvGroups[envType];
    }
}


/***/ }),

/***/ "./src/client/interpreter/configuration/interpreterSelector/interpreterSelector.ts":
/*!*****************************************************************************************!*\
  !*** ./src/client/interpreter/configuration/interpreterSelector/interpreterSelector.ts ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterpreterSelector = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path_1 = __webpack_require__(/*! path */ "path");
const types_1 = __webpack_require__(/*! ../../../common/types */ "./src/client/common/types.ts");
const types_2 = __webpack_require__(/*! ../types */ "./src/client/interpreter/configuration/types.ts");
let InterpreterSelector = class InterpreterSelector {
    constructor(envTypeComparer, pathUtils) {
        this.envTypeComparer = envTypeComparer;
        this.pathUtils = pathUtils;
        this.disposables = [];
    }
    dispose() {
        this.disposables.forEach((disposable) => disposable.dispose());
    }
    getSuggestions(api, resource, useFullDisplayName = false) {
        const interpreters = api.environments.known.slice();
        interpreters.sort(this.envTypeComparer.compareV2.bind(this.envTypeComparer));
        return interpreters.map((item) => this.suggestionToQuickPickItem(item, resource, useFullDisplayName));
    }
    suggestionToQuickPickItem(interpreter, workspaceUri, _useDetailedName = false) {
        var _a, _b, _c, _d, _e, _f, _g;
        const path = ((_b = (_a = interpreter.environment) === null || _a === void 0 ? void 0 : _a.folderUri) === null || _b === void 0 ? void 0 : _b.fsPath) || ((_d = (_c = interpreter.executable) === null || _c === void 0 ? void 0 : _c.uri) === null || _d === void 0 ? void 0 : _d.fsPath) || interpreter.path;
        const detail = this.pathUtils.getDisplayName(path, workspaceUri ? workspaceUri.fsPath : undefined);
        const version = ((_e = interpreter.version) === null || _e === void 0 ? void 0 : _e.major) ? `${interpreter.version.major}.${interpreter.version.minor}.${interpreter.version.micro}` : '';
        const displayVersion = version ? ` (${version})` : '';
        const pythonDisplayName = `Python${displayVersion}`;
        const envName = ((_f = interpreter.environment) === null || _f === void 0 ? void 0 : _f.name) || (((_g = interpreter.environment) === null || _g === void 0 ? void 0 : _g.folderUri) ? (0, path_1.dirname)(interpreter.environment.folderUri.fsPath) : undefined);
        return {
            label: envName ? `${envName} (${pythonDisplayName})` : pythonDisplayName,
            description: detail || '',
            path,
            interpreter,
        };
    }
    getRecommendedSuggestion(_suggestions, _resource) {
        return undefined;
    }
};
InterpreterSelector = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.IInterpreterComparer)),
    __param(1, (0, inversify_1.inject)(types_1.IPathUtils))
], InterpreterSelector);
exports.InterpreterSelector = InterpreterSelector;


/***/ }),

/***/ "./src/client/interpreter/configuration/types.ts":
/*!*******************************************************!*\
  !*** ./src/client/interpreter/configuration/types.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IInterpreterQuickPick = exports.IInterpreterComparer = exports.IInterpreterSelector = void 0;
exports.IInterpreterSelector = Symbol('IInterpreterSelector');
exports.IInterpreterComparer = Symbol('IInterpreterComparer');
exports.IInterpreterQuickPick = Symbol('IInterpreterQuickPick');


/***/ }),

/***/ "./src/client/interpreter/contracts.ts":
/*!*********************************************!*\
  !*** ./src/client/interpreter/contracts.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IActivatedEnvironmentLaunch = exports.IInterpreterStatusbarVisibilityFilter = exports.IInterpreterHelper = exports.IInterpreterService = exports.ICondaService = exports.IComponentAdapter = void 0;
exports.IComponentAdapter = Symbol('IComponentAdapter');
exports.ICondaService = Symbol('ICondaService');
exports.IInterpreterService = Symbol('IInterpreterService');
exports.IInterpreterHelper = Symbol('IInterpreterHelper');
exports.IInterpreterStatusbarVisibilityFilter = Symbol('IInterpreterStatusbarVisibilityFilter');
exports.IActivatedEnvironmentLaunch = Symbol('IActivatedEnvironmentLaunch');


/***/ }),

/***/ "./src/client/interpreter/helpers.ts":
/*!*******************************************!*\
  !*** ./src/client/interpreter/helpers.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterpreterHelper = exports.isInterpreterLocatedInWorkspace = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const types_1 = __webpack_require__(/*! ../common/application/types */ "./src/client/common/application/types.ts");
const fs_paths_1 = __webpack_require__(/*! ../common/platform/fs-paths */ "./src/client/common/platform/fs-paths.ts");
const types_2 = __webpack_require__(/*! ../ioc/types */ "./src/client/ioc/types.ts");
const pythonVersion_1 = __webpack_require__(/*! ../pythonEnvironments/base/info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const info_1 = __webpack_require__(/*! ../pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const contracts_1 = __webpack_require__(/*! ./contracts */ "./src/client/interpreter/contracts.ts");
function isInterpreterLocatedInWorkspace(interpreter, activeWorkspaceUri) {
    const fileSystemPaths = fs_paths_1.FileSystemPaths.withDefaults();
    const interpreterPath = fileSystemPaths.normCase(interpreter.path);
    const resourcePath = fileSystemPaths.normCase(activeWorkspaceUri.fsPath);
    return interpreterPath.startsWith(resourcePath);
}
exports.isInterpreterLocatedInWorkspace = isInterpreterLocatedInWorkspace;
function sortInterpreters(interpreters) {
    if (interpreters.length === 0) {
        return [];
    }
    if (interpreters.length === 1) {
        return [interpreters[0]];
    }
    const sorted = interpreters.slice();
    sorted.sort((a, b) => (a.version && b.version ? (0, pythonVersion_1.compareSemVerLikeVersions)(a.version, b.version) : 0));
    return sorted;
}
let InterpreterHelper = class InterpreterHelper {
    constructor(serviceContainer, pyenvs) {
        this.serviceContainer = serviceContainer;
        this.pyenvs = pyenvs;
    }
    getActiveWorkspaceUri(resource) {
        var _a;
        const workspaceService = this.serviceContainer.get(types_1.IWorkspaceService);
        const hasWorkspaceFolders = (((_a = workspaceService.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) || 0) > 0;
        if (!hasWorkspaceFolders) {
            return;
        }
        if (Array.isArray(workspaceService.workspaceFolders) && workspaceService.workspaceFolders.length === 1) {
            return { folderUri: workspaceService.workspaceFolders[0].uri, configTarget: vscode_1.ConfigurationTarget.Workspace };
        }
        if (resource) {
            const workspaceFolder = workspaceService.getWorkspaceFolder(resource);
            if (workspaceFolder) {
                return { configTarget: vscode_1.ConfigurationTarget.WorkspaceFolder, folderUri: workspaceFolder.uri };
            }
        }
        const documentManager = this.serviceContainer.get(types_1.IDocumentManager);
        if (documentManager.activeTextEditor) {
            const workspaceFolder = workspaceService.getWorkspaceFolder(documentManager.activeTextEditor.document.uri);
            if (workspaceFolder) {
                return { configTarget: vscode_1.ConfigurationTarget.WorkspaceFolder, folderUri: workspaceFolder.uri };
            }
        }
    }
    async getInterpreterInformation(pythonPath) {
        return this.pyenvs.getInterpreterInformation(pythonPath);
    }
    async getInterpreters({ resource, source } = {}) {
        const interpreters = await this.pyenvs.getInterpreters(resource, source);
        return sortInterpreters(interpreters);
    }
    async getInterpreterPath(pythonPath) {
        const interpreterInfo = await this.getInterpreterInformation(pythonPath);
        if (interpreterInfo) {
            return interpreterInfo.path;
        }
        else {
            return pythonPath;
        }
    }
    async isMacDefaultPythonPath(pythonPath) {
        return this.pyenvs.isMacDefaultPythonPath(pythonPath);
    }
    getInterpreterTypeDisplayName(interpreterType) {
        return (0, info_1.getEnvironmentTypeName)(interpreterType);
    }
    getBestInterpreter(interpreters) {
        if (!Array.isArray(interpreters) || interpreters.length === 0) {
            return;
        }
        const sorted = sortInterpreters(interpreters);
        return sorted[sorted.length - 1];
    }
};
InterpreterHelper = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_2.IServiceContainer)),
    __param(1, (0, inversify_1.inject)(contracts_1.IComponentAdapter))
], InterpreterHelper);
exports.InterpreterHelper = InterpreterHelper;


/***/ }),

/***/ "./src/client/interpreter/interpreterService.ts":
/*!******************************************************!*\
  !*** ./src/client/interpreter/interpreterService.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterpreterService = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
__webpack_require__(/*! ../common/extensions */ "./src/client/common/extensions.ts");
const contracts_1 = __webpack_require__(/*! ./contracts */ "./src/client/interpreter/contracts.ts");
let InterpreterService = class InterpreterService {
    constructor(pyenvs) {
        this.pyenvs = pyenvs;
        this.didChangeInterpreterEmitter = new vscode_1.EventEmitter();
        python_extension_1.PythonExtension.api().then((api) => api.environments.onDidChangeActiveEnvironmentPath((e) => {
            var _a;
            this.didChangeInterpreterEmitter.fire((_a = e.resource) === null || _a === void 0 ? void 0 : _a.uri);
        }));
    }
    get onDidChangeInterpreter() {
        return this.didChangeInterpreterEmitter.event;
    }
    getInterpreters(resource) {
        return this.pyenvs.getInterpreters(resource);
    }
    dispose() {
        this.didChangeInterpreterEmitter.dispose();
    }
    async getActiveInterpreter(resource) {
        const api = await python_extension_1.PythonExtension.api();
        const pythonPath = await api.environments.getActiveEnvironmentPath(resource);
        return pythonPath ? this.getInterpreterDetails(pythonPath.path) : undefined;
    }
    async getInterpreterDetails(pythonPath) {
        return this.pyenvs.getInterpreterDetails(pythonPath);
    }
};
InterpreterService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(contracts_1.IComponentAdapter))
], InterpreterService);
exports.InterpreterService = InterpreterService;


/***/ }),

/***/ "./src/client/interpreter/serviceRegistry.ts":
/*!***************************************************!*\
  !*** ./src/client/interpreter/serviceRegistry.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const service_1 = __webpack_require__(/*! ./activation/service */ "./src/client/interpreter/activation/service.ts");
const types_1 = __webpack_require__(/*! ./activation/types */ "./src/client/interpreter/activation/types.ts");
const environmentTypeComparer_1 = __webpack_require__(/*! ./configuration/environmentTypeComparer */ "./src/client/interpreter/configuration/environmentTypeComparer.ts");
const setInterpreter_1 = __webpack_require__(/*! ./configuration/interpreterSelector/commands/setInterpreter */ "./src/client/interpreter/configuration/interpreterSelector/commands/setInterpreter.ts");
const interpreterSelector_1 = __webpack_require__(/*! ./configuration/interpreterSelector/interpreterSelector */ "./src/client/interpreter/configuration/interpreterSelector/interpreterSelector.ts");
const types_2 = __webpack_require__(/*! ./configuration/types */ "./src/client/interpreter/configuration/types.ts");
const contracts_1 = __webpack_require__(/*! ./contracts */ "./src/client/interpreter/contracts.ts");
const helpers_1 = __webpack_require__(/*! ./helpers */ "./src/client/interpreter/helpers.ts");
const interpreterService_1 = __webpack_require__(/*! ./interpreterService */ "./src/client/interpreter/interpreterService.ts");
function registerInterpreterTypes(serviceManager) {
    serviceManager.addSingleton(contracts_1.IInterpreterService, interpreterService_1.InterpreterService);
    serviceManager.addSingleton(types_2.IInterpreterSelector, interpreterSelector_1.InterpreterSelector);
    serviceManager.addSingleton(types_2.IInterpreterQuickPick, setInterpreter_1.SetInterpreterCommand);
    serviceManager.addSingleton(contracts_1.IInterpreterHelper, helpers_1.InterpreterHelper);
    serviceManager.addSingleton(types_2.IInterpreterComparer, environmentTypeComparer_1.EnvironmentTypeComparer);
}
function registerTypes(serviceManager) {
    registerInterpreterTypes(serviceManager);
    serviceManager.addSingleton(service_1.EnvironmentActivationService, service_1.EnvironmentActivationService);
    serviceManager.addSingleton(types_1.IEnvironmentActivationService, service_1.EnvironmentActivationService);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/client/ioc/container.ts":
/*!*************************************!*\
  !*** ./src/client/ioc/container.ts ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ServiceContainer = void 0;
const events_1 = __webpack_require__(/*! events */ "events");
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const logging_1 = __webpack_require__(/*! ../logging */ "./src/client/logging/index.ts");
try {
    (0, inversify_1.decorate)((0, inversify_1.injectable)(), events_1.EventEmitter);
}
catch (ex) {
    (0, logging_1.traceWarn)('Failed to decorate EventEmitter for DI (possibly already decorated by another Extension)', ex);
}
let ServiceContainer = class ServiceContainer {
    constructor(container) {
        this.container = container;
    }
    get(serviceIdentifier, name) {
        return name ? this.container.getNamed(serviceIdentifier, name) : this.container.get(serviceIdentifier);
    }
    getAll(serviceIdentifier, name) {
        return name
            ? this.container.getAllNamed(serviceIdentifier, name)
            : this.container.getAll(serviceIdentifier);
    }
    tryGet(serviceIdentifier, name) {
        try {
            return name
                ? this.container.getNamed(serviceIdentifier, name)
                : this.container.get(serviceIdentifier);
        }
        catch (_a) {
        }
        return undefined;
    }
};
ServiceContainer = __decorate([
    (0, inversify_1.injectable)()
], ServiceContainer);
exports.ServiceContainer = ServiceContainer;


/***/ }),

/***/ "./src/client/ioc/serviceManager.ts":
/*!******************************************!*\
  !*** ./src/client/ioc/serviceManager.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ServiceManager = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
let ServiceManager = class ServiceManager {
    constructor(container) {
        this.container = container;
    }
    add(serviceIdentifier, constructor, name, bindings) {
        if (name) {
            this.container.bind(serviceIdentifier).to(constructor).whenTargetNamed(name);
        }
        else {
            this.container.bind(serviceIdentifier).to(constructor);
        }
        if (bindings) {
            bindings.forEach((binding) => {
                this.addBinding(serviceIdentifier, binding);
            });
        }
    }
    addFactory(factoryIdentifier, factoryMethod) {
        this.container.bind(factoryIdentifier).toFactory(factoryMethod);
    }
    addBinding(from, to) {
        this.container.bind(to).toService(from);
    }
    addSingleton(serviceIdentifier, constructor, name, bindings) {
        if (name) {
            this.container.bind(serviceIdentifier).to(constructor).inSingletonScope().whenTargetNamed(name);
        }
        else {
            this.container.bind(serviceIdentifier).to(constructor).inSingletonScope();
        }
        if (bindings) {
            bindings.forEach((binding) => {
                this.addBinding(serviceIdentifier, binding);
            });
        }
    }
    addSingletonInstance(serviceIdentifier, instance, name) {
        if (name) {
            this.container.bind(serviceIdentifier).toConstantValue(instance).whenTargetNamed(name);
        }
        else {
            this.container.bind(serviceIdentifier).toConstantValue(instance);
        }
    }
    get(serviceIdentifier, name) {
        return name ? this.container.getNamed(serviceIdentifier, name) : this.container.get(serviceIdentifier);
    }
    tryGet(serviceIdentifier, name) {
        try {
            return name
                ? this.container.getNamed(serviceIdentifier, name)
                : this.container.get(serviceIdentifier);
        }
        catch (_a) {
        }
        return undefined;
    }
    getAll(serviceIdentifier, name) {
        return name
            ? this.container.getAllNamed(serviceIdentifier, name)
            : this.container.getAll(serviceIdentifier);
    }
    rebind(serviceIdentifier, constructor, name) {
        if (name) {
            this.container.rebind(serviceIdentifier).to(constructor).whenTargetNamed(name);
        }
        else {
            this.container.rebind(serviceIdentifier).to(constructor);
        }
    }
    rebindSingleton(serviceIdentifier, constructor, name) {
        if (name) {
            this.container.rebind(serviceIdentifier).to(constructor).inSingletonScope().whenTargetNamed(name);
        }
        else {
            this.container.rebind(serviceIdentifier).to(constructor).inSingletonScope();
        }
    }
    rebindInstance(serviceIdentifier, instance, name) {
        if (name) {
            this.container.rebind(serviceIdentifier).toConstantValue(instance).whenTargetNamed(name);
        }
        else {
            this.container.rebind(serviceIdentifier).toConstantValue(instance);
        }
    }
    dispose() {
        this.container.unbindAll();
        this.container.unload();
    }
};
ServiceManager = __decorate([
    (0, inversify_1.injectable)()
], ServiceManager);
exports.ServiceManager = ServiceManager;


/***/ }),

/***/ "./src/client/ioc/types.ts":
/*!*********************************!*\
  !*** ./src/client/ioc/types.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IServiceContainer = exports.IServiceManager = void 0;
exports.IServiceManager = Symbol('IServiceManager');
exports.IServiceContainer = Symbol('IServiceContainer');


/***/ }),

/***/ "./src/client/logging/index.ts":
/*!*************************************!*\
  !*** ./src/client/logging/index.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.logTo = exports.traceDecoratorWarn = exports.traceDecoratorInfo = exports.traceDecoratorError = exports.traceDecoratorVerbose = exports.traceVerbose = exports.traceInfo = exports.traceWarn = exports.traceError = exports.traceLog = exports.registerLogger = void 0;
const internal_compatibility_1 = __webpack_require__(/*! rxjs/internal-compatibility */ "./node_modules/rxjs/_esm5/internal-compatibility/index.js");
const stopWatch_1 = __webpack_require__(/*! ../common/utils/stopWatch */ "./src/client/common/utils/stopWatch.ts");
const telemetry_1 = __webpack_require__(/*! ../telemetry */ "./src/client/telemetry/index.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/client/logging/types.ts");
const util_1 = __webpack_require__(/*! ./util */ "./src/client/logging/util.ts");
const DEFAULT_OPTS = types_1.TraceOptions.Arguments | types_1.TraceOptions.ReturnValue;
let loggers = [];
function registerLogger(logger) {
    loggers.push(logger);
    return {
        dispose: () => {
            loggers = loggers.filter((l) => l !== logger);
        },
    };
}
exports.registerLogger = registerLogger;
function traceLog(...args) {
    loggers.forEach((l) => l.traceLog(...args));
}
exports.traceLog = traceLog;
function traceError(...args) {
    loggers.forEach((l) => l.traceError(...args));
}
exports.traceError = traceError;
function traceWarn(...args) {
    loggers.forEach((l) => l.traceWarn(...args));
}
exports.traceWarn = traceWarn;
function traceInfo(...args) {
    loggers.forEach((l) => l.traceInfo(...args));
}
exports.traceInfo = traceInfo;
function traceVerbose(...args) {
    loggers.forEach((l) => l.traceVerbose(...args));
}
exports.traceVerbose = traceVerbose;
function traceDecoratorVerbose(message, opts = DEFAULT_OPTS) {
    return createTracingDecorator({ message, opts, level: types_1.LogLevel.Debug });
}
exports.traceDecoratorVerbose = traceDecoratorVerbose;
function traceDecoratorError(message) {
    return createTracingDecorator({ message, opts: DEFAULT_OPTS, level: types_1.LogLevel.Error });
}
exports.traceDecoratorError = traceDecoratorError;
function traceDecoratorInfo(message) {
    return createTracingDecorator({ message, opts: DEFAULT_OPTS, level: types_1.LogLevel.Info });
}
exports.traceDecoratorInfo = traceDecoratorInfo;
function traceDecoratorWarn(message) {
    return createTracingDecorator({ message, opts: DEFAULT_OPTS, level: types_1.LogLevel.Warning });
}
exports.traceDecoratorWarn = traceDecoratorWarn;
function traceDecorator(log) {
    return function (_, __, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            const call = {
                kind: 'Class',
                name: _ && _.constructor ? _.constructor.name : '',
                args,
            };
            const scope = this;
            return tracing((t) => log(call, t), () => originalMethod.apply(scope, args));
        };
        return descriptor;
    };
}
function tracing(log, run) {
    const timer = new stopWatch_1.StopWatch();
    try {
        const result = run();
        if ((0, internal_compatibility_1.isPromise)(result)) {
            result
                .then((data) => {
                log({ elapsed: timer.elapsedTime, returnValue: data });
                return data;
            })
                .catch((ex) => {
                log({ elapsed: timer.elapsedTime, err: ex });
            });
        }
        else {
            log({ elapsed: timer.elapsedTime, returnValue: result });
        }
        return result;
    }
    catch (ex) {
        log({ elapsed: timer.elapsedTime, err: ex });
        throw ex;
    }
}
function createTracingDecorator(logInfo) {
    return traceDecorator((call, traced) => logResult(logInfo, traced, call));
}
function normalizeCall(call) {
    let { kind, name, args } = call;
    if (!kind || kind === '') {
        kind = 'Function';
    }
    if (!name || name === '') {
        name = '<anon>';
    }
    if (!args) {
        args = [];
    }
    return { kind, name, args };
}
function formatMessages(logInfo, traced, call) {
    call = normalizeCall(call);
    const messages = [logInfo.message];
    messages.push(`${call.kind} name = ${call.name}`.trim(), `completed in ${traced.elapsed}ms`, `has a ${traced.returnValue ? 'truthy' : 'falsy'} return value`);
    if ((logInfo.opts & types_1.TraceOptions.Arguments) === types_1.TraceOptions.Arguments) {
        messages.push((0, util_1.argsToLogString)(call.args));
    }
    if ((logInfo.opts & types_1.TraceOptions.ReturnValue) === types_1.TraceOptions.ReturnValue) {
        messages.push((0, util_1.returnValueToLogString)(traced.returnValue));
    }
    return messages.join(', ');
}
function logResult(logInfo, traced, call) {
    const formatted = formatMessages(logInfo, traced, call);
    if (traced.err === undefined) {
        if (!logInfo.level || logInfo.level > types_1.LogLevel.Error) {
            logTo(types_1.LogLevel.Info, [formatted]);
        }
    }
    else {
        logTo(types_1.LogLevel.Error, [formatted, traced.err]);
        (0, telemetry_1.sendTelemetryEvent)('ERROR', undefined, undefined, traced.err);
    }
}
function logTo(logLevel, ...args) {
    switch (logLevel) {
        case types_1.LogLevel.Error:
            traceError(...args);
            break;
        case types_1.LogLevel.Warning:
            traceWarn(...args);
            break;
        case types_1.LogLevel.Info:
            traceInfo(...args);
            break;
        case types_1.LogLevel.Debug:
            traceVerbose(...args);
            break;
        default:
            break;
    }
}
exports.logTo = logTo;


/***/ }),

/***/ "./src/client/logging/outputChannelLogger.ts":
/*!***************************************************!*\
  !*** ./src/client/logging/outputChannelLogger.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputChannelLogger = void 0;
const util = __webpack_require__(/*! util */ "util");
class OutputChannelLogger {
    constructor(channel) {
        this.channel = channel;
    }
    traceLog(...data) {
        this.channel.appendLine(util.format(...data));
    }
    traceError(...data) {
        this.channel.appendLine(`Error: ${util.format(...data)}`);
    }
    traceWarn(...data) {
        this.channel.appendLine(`Warn: ${util.format(...data)}`);
    }
    traceInfo(...data) {
        this.channel.appendLine(`Info: ${util.format(...data)}`);
    }
    traceVerbose(...data) {
        this.channel.appendLine(`Debug: ${util.format(...data)}`);
    }
}
exports.OutputChannelLogger = OutputChannelLogger;


/***/ }),

/***/ "./src/client/logging/types.ts":
/*!*************************************!*\
  !*** ./src/client/logging/types.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TraceOptions = exports.LogLevel = void 0;
var LogLevel;
(function (LogLevel) {
    LogLevel[LogLevel["Off"] = 0] = "Off";
    LogLevel[LogLevel["Trace"] = 1] = "Trace";
    LogLevel[LogLevel["Debug"] = 2] = "Debug";
    LogLevel[LogLevel["Info"] = 3] = "Info";
    LogLevel[LogLevel["Warning"] = 4] = "Warning";
    LogLevel[LogLevel["Error"] = 5] = "Error";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
var TraceOptions;
(function (TraceOptions) {
    TraceOptions[TraceOptions["None"] = 0] = "None";
    TraceOptions[TraceOptions["Arguments"] = 1] = "Arguments";
    TraceOptions[TraceOptions["ReturnValue"] = 2] = "ReturnValue";
})(TraceOptions = exports.TraceOptions || (exports.TraceOptions = {}));


/***/ }),

/***/ "./src/client/logging/util.ts":
/*!************************************!*\
  !*** ./src/client/logging/util.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.returnValueToLogString = exports.argsToLogString = void 0;
function valueToLogString(value, kind) {
    if (value === undefined) {
        return 'undefined';
    }
    if (value === null) {
        return 'null';
    }
    try {
        if (value && value.fsPath) {
            return `<Uri:${value.fsPath}>`;
        }
        return JSON.stringify(value);
    }
    catch (_a) {
        return `<${kind} cannot be serialized for logging>`;
    }
}
function argsToLogString(args) {
    if (!args) {
        return '';
    }
    try {
        const argStrings = args.map((item, index) => {
            const valueString = valueToLogString(item, 'argument');
            return `Arg ${index + 1}: ${valueString}`;
        });
        return argStrings.join(', ');
    }
    catch (_a) {
        return '';
    }
}
exports.argsToLogString = argsToLogString;
function returnValueToLogString(returnValue) {
    const valueString = valueToLogString(returnValue, 'Return value');
    return `Return Value: ${valueString}`;
}
exports.returnValueToLogString = returnValueToLogString;


/***/ }),

/***/ "./src/client/pythonEnvironments/api.ts":
/*!**********************************************!*\
  !*** ./src/client/pythonEnvironments/api.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createPythonEnvironments = void 0;
class PythonEnvironments {
    constructor(getLocator) {
        this.getLocator = getLocator;
    }
    async activate() {
        this.locator = await this.getLocator();
    }
    get onProgress() {
        return this.locator.onProgress;
    }
    get refreshState() {
        return this.locator.refreshState;
    }
    getRefreshPromise(options) {
        return this.locator.getRefreshPromise(options);
    }
    get onChanged() {
        return this.locator.onChanged;
    }
    getEnvs(query) {
        return this.locator.getEnvs(query);
    }
    async resolveEnv(env) {
        return this.locator.resolveEnv(env);
    }
    async triggerRefresh(query, options) {
        return this.locator.triggerRefresh(query, options);
    }
}
async function createPythonEnvironments(getLocator) {
    const api = new PythonEnvironments(getLocator);
    await api.activate();
    return api;
}
exports.createPythonEnvironments = createPythonEnvironments;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/env.ts":
/*!********************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/env.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.comparePythonVersionSpecificity = exports.areSameEnv = exports.getEnvID = exports.getEnvPath = exports.setEnvDisplayString = exports.copyEnvInfo = exports.areEnvsDeepEqual = exports.buildEnvInfo = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const path = __webpack_require__(/*! path */ "path");
const registry_1 = __webpack_require__(/*! ../../../common/platform/registry */ "./src/client/common/platform/registry.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const envKind_1 = __webpack_require__(/*! ./envKind */ "./src/client/pythonEnvironments/base/info/envKind.ts");
const pythonVersion_1 = __webpack_require__(/*! ./pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const _1 = __webpack_require__(/*! . */ "./src/client/pythonEnvironments/base/info/index.ts");
function buildEnvInfo(init) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    const env = {
        name: (_a = init === null || init === void 0 ? void 0 : init.name) !== null && _a !== void 0 ? _a : '',
        location: '',
        kind: _1.PythonEnvKind.Unknown,
        executable: {
            filename: '',
            sysPrefix: (_b = init === null || init === void 0 ? void 0 : init.sysPrefix) !== null && _b !== void 0 ? _b : '',
            ctime: (_d = (_c = init === null || init === void 0 ? void 0 : init.fileInfo) === null || _c === void 0 ? void 0 : _c.ctime) !== null && _d !== void 0 ? _d : -1,
            mtime: (_f = (_e = init === null || init === void 0 ? void 0 : init.fileInfo) === null || _e === void 0 ? void 0 : _e.mtime) !== null && _f !== void 0 ? _f : -1,
        },
        searchLocation: undefined,
        display: init === null || init === void 0 ? void 0 : init.display,
        version: {
            major: -1,
            minor: -1,
            micro: -1,
            release: {
                level: _1.PythonReleaseLevel.Final,
                serial: 0,
            },
        },
        arch: (_g = init === null || init === void 0 ? void 0 : init.arch) !== null && _g !== void 0 ? _g : platform_1.Architecture.Unknown,
        distro: {
            org: (_h = init === null || init === void 0 ? void 0 : init.org) !== null && _h !== void 0 ? _h : '',
        },
        source: (_j = init === null || init === void 0 ? void 0 : init.source) !== null && _j !== void 0 ? _j : [],
    };
    if (init !== undefined) {
        updateEnv(env, init);
    }
    env.id = getEnvID(env.executable.filename, env.location);
    return env;
}
exports.buildEnvInfo = buildEnvInfo;
function areEnvsDeepEqual(env1, env2) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const env1Clone = (0, lodash_1.cloneDeep)(env1);
    const env2Clone = (0, lodash_1.cloneDeep)(env2);
    delete env1Clone.searchLocation;
    delete env2Clone.searchLocation;
    env1Clone.source = env1Clone.source.sort();
    env2Clone.source = env2Clone.source.sort();
    const searchLocation1 = (_b = (_a = env1.searchLocation) === null || _a === void 0 ? void 0 : _a.fsPath) !== null && _b !== void 0 ? _b : '';
    const searchLocation2 = (_d = (_c = env2.searchLocation) === null || _c === void 0 ? void 0 : _c.fsPath) !== null && _d !== void 0 ? _d : '';
    const searchLocation1Scheme = (_f = (_e = env1.searchLocation) === null || _e === void 0 ? void 0 : _e.scheme) !== null && _f !== void 0 ? _f : '';
    const searchLocation2Scheme = (_h = (_g = env2.searchLocation) === null || _g === void 0 ? void 0 : _g.scheme) !== null && _h !== void 0 ? _h : '';
    return ((0, lodash_1.isEqual)(env1Clone, env2Clone) &&
        (0, externalDependencies_1.arePathsSame)(searchLocation1, searchLocation2) &&
        searchLocation1Scheme === searchLocation2Scheme);
}
exports.areEnvsDeepEqual = areEnvsDeepEqual;
function copyEnvInfo(env, updates) {
    const copied = (0, lodash_1.cloneDeep)(env);
    if (updates !== undefined) {
        updateEnv(copied, updates);
    }
    return copied;
}
exports.copyEnvInfo = copyEnvInfo;
function updateEnv(env, updates) {
    if (updates.kind !== undefined) {
        env.kind = updates.kind;
    }
    if (updates.executable !== undefined) {
        env.executable.filename = updates.executable;
    }
    if (updates.location !== undefined) {
        env.location = updates.location;
    }
    if (updates.version !== undefined) {
        env.version = updates.version;
    }
    if (updates.searchLocation !== undefined) {
        env.searchLocation = updates.searchLocation;
    }
    if (updates.type !== undefined) {
        env.type = updates.type;
    }
}
function setEnvDisplayString(env) {
    env.display = buildEnvDisplayString(env);
    env.detailedDisplayName = buildEnvDisplayString(env, true);
}
exports.setEnvDisplayString = setEnvDisplayString;
function buildEnvDisplayString(env, getAllDetails = false) {
    const shouldDisplayKind = getAllDetails || env.searchLocation || _1.globallyInstalledEnvKinds.includes(env.kind);
    const shouldDisplayArch = !_1.virtualEnvKinds.includes(env.kind);
    const displayNameParts = ['Python'];
    if (env.version && !(0, pythonVersion_1.isVersionEmpty)(env.version)) {
        displayNameParts.push((0, pythonVersion_1.getVersionDisplayString)(env.version));
    }
    if (shouldDisplayArch) {
        const archName = (0, registry_1.getArchitectureDisplayName)(env.arch);
        if (archName !== '') {
            displayNameParts.push(archName);
        }
    }
    const envSuffixParts = [];
    if (env.name && env.name !== '') {
        envSuffixParts.push(`'${env.name}'`);
    }
    if (shouldDisplayKind) {
        const kindName = (0, envKind_1.getKindDisplayName)(env.kind);
        if (kindName !== '') {
            envSuffixParts.push(kindName);
        }
    }
    const envSuffix = envSuffixParts.length === 0 ? '' : `(${envSuffixParts.join(': ')})`;
    return `${displayNameParts.join(' ')} ${envSuffix}`.trim();
}
function getMinimalPartialInfo(env) {
    if (typeof env === 'string') {
        if (env === '') {
            return undefined;
        }
        return {
            id: '',
            executable: {
                filename: env,
                sysPrefix: '',
                ctime: -1,
                mtime: -1,
            },
        };
    }
    if ('executablePath' in env) {
        return {
            id: '',
            executable: {
                filename: env.executablePath,
                sysPrefix: '',
                ctime: -1,
                mtime: -1,
            },
            location: env.envPath,
            kind: env.kind,
            source: env.source,
        };
    }
    return env;
}
function getEnvPath(interpreterPath, envFolderPath) {
    let envPath = { path: interpreterPath, pathType: 'interpreterPath' };
    if (envFolderPath && !(0, externalDependencies_1.isParentPath)(interpreterPath, envFolderPath)) {
        envPath = { path: envFolderPath, pathType: 'envFolderPath' };
    }
    return envPath;
}
exports.getEnvPath = getEnvPath;
function getEnvID(interpreterPath, envFolderPath) {
    return (0, externalDependencies_1.normCasePath)(getEnvPath(interpreterPath, envFolderPath).path);
}
exports.getEnvID = getEnvID;
function areSameEnv(left, right, allowPartialMatch = true) {
    const leftInfo = getMinimalPartialInfo(left);
    const rightInfo = getMinimalPartialInfo(right);
    if (leftInfo === undefined || rightInfo === undefined) {
        return undefined;
    }
    const leftFilename = leftInfo.executable.filename;
    const rightFilename = rightInfo.executable.filename;
    if (leftInfo.id && leftInfo.id === rightInfo.id) {
        return true;
    }
    if (getEnvID(leftFilename, leftInfo.location) === getEnvID(rightFilename, rightInfo.location)) {
        return true;
    }
    if (allowPartialMatch) {
        const isSameDirectory = leftFilename !== 'python' &&
            rightFilename !== 'python' &&
            (0, externalDependencies_1.arePathsSame)(path.dirname(leftFilename), path.dirname(rightFilename));
        if (isSameDirectory) {
            const leftVersion = typeof left === 'string' ? undefined : leftInfo.version;
            const rightVersion = typeof right === 'string' ? undefined : rightInfo.version;
            if (leftVersion && rightVersion) {
                if ((0, pythonVersion_1.areIdenticalVersion)(leftVersion, rightVersion) || (0, pythonVersion_1.areSimilarVersions)(leftVersion, rightVersion)) {
                    return true;
                }
            }
        }
    }
    return false;
}
exports.areSameEnv = areSameEnv;
function getPythonVersionSpecificity(version) {
    var _a, _b;
    let infoLevel = 0;
    if (version.major > 0) {
        infoLevel += 20;
    }
    if (version.minor >= 0) {
        infoLevel += 10;
    }
    if (version.micro >= 0) {
        infoLevel += 5;
    }
    if ((_a = version.release) === null || _a === void 0 ? void 0 : _a.level) {
        infoLevel += 3;
    }
    if (((_b = version.release) === null || _b === void 0 ? void 0 : _b.serial) || version.sysVersion) {
        infoLevel += 1;
    }
    return infoLevel;
}
function comparePythonVersionSpecificity(versionA, versionB) {
    return Math.sign(getPythonVersionSpecificity(versionA) - getPythonVersionSpecificity(versionB));
}
exports.comparePythonVersionSpecificity = comparePythonVersionSpecificity;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/envKind.ts":
/*!************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/envKind.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPrioritizedEnvKinds = exports.getKindDisplayName = void 0;
const _1 = __webpack_require__(/*! . */ "./src/client/pythonEnvironments/base/info/index.ts");
function getKindDisplayName(kind) {
    for (const [candidate, value] of [
        [_1.PythonEnvKind.System, 'system'],
        [_1.PythonEnvKind.MicrosoftStore, 'microsoft store'],
        [_1.PythonEnvKind.Pyenv, 'pyenv'],
        [_1.PythonEnvKind.Poetry, 'poetry'],
        [_1.PythonEnvKind.Custom, 'custom'],
        [_1.PythonEnvKind.Venv, 'venv'],
        [_1.PythonEnvKind.VirtualEnv, 'virtualenv'],
        [_1.PythonEnvKind.VirtualEnvWrapper, 'virtualenv'],
        [_1.PythonEnvKind.Pipenv, 'pipenv'],
        [_1.PythonEnvKind.Conda, 'conda'],
        [_1.PythonEnvKind.ActiveState, 'ActiveState'],
    ]) {
        if (kind === candidate) {
            return value;
        }
    }
    return '';
}
exports.getKindDisplayName = getKindDisplayName;
function getPrioritizedEnvKinds() {
    return [
        _1.PythonEnvKind.Pyenv,
        _1.PythonEnvKind.Conda,
        _1.PythonEnvKind.MicrosoftStore,
        _1.PythonEnvKind.Pipenv,
        _1.PythonEnvKind.Poetry,
        _1.PythonEnvKind.Venv,
        _1.PythonEnvKind.VirtualEnvWrapper,
        _1.PythonEnvKind.VirtualEnv,
        _1.PythonEnvKind.ActiveState,
        _1.PythonEnvKind.OtherVirtual,
        _1.PythonEnvKind.OtherGlobal,
        _1.PythonEnvKind.System,
        _1.PythonEnvKind.Custom,
        _1.PythonEnvKind.Unknown,
    ];
}
exports.getPrioritizedEnvKinds = getPrioritizedEnvKinds;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/environmentInfoService.ts":
/*!***************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/environmentInfoService.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnvironmentInfoService = exports.EnvironmentInfoServiceQueuePriority = void 0;
const async_1 = __webpack_require__(/*! ../../../common/utils/async */ "./src/client/common/utils/async.ts");
const workerPool_1 = __webpack_require__(/*! ../../../common/utils/workerPool */ "./src/client/common/utils/workerPool.ts");
const interpreter_1 = __webpack_require__(/*! ./interpreter */ "./src/client/pythonEnvironments/base/info/interpreter.ts");
const exec_1 = __webpack_require__(/*! ../../exec */ "./src/client/pythonEnvironments/exec.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const conda_1 = __webpack_require__(/*! ../../common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const _1 = __webpack_require__(/*! . */ "./src/client/pythonEnvironments/base/info/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const scripts_1 = __webpack_require__(/*! ../../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const pythonVersion_1 = __webpack_require__(/*! ./pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
var EnvironmentInfoServiceQueuePriority;
(function (EnvironmentInfoServiceQueuePriority) {
    EnvironmentInfoServiceQueuePriority[EnvironmentInfoServiceQueuePriority["Default"] = 0] = "Default";
    EnvironmentInfoServiceQueuePriority[EnvironmentInfoServiceQueuePriority["High"] = 1] = "High";
})(EnvironmentInfoServiceQueuePriority = exports.EnvironmentInfoServiceQueuePriority || (exports.EnvironmentInfoServiceQueuePriority = {}));
async function buildEnvironmentInfo(env, useIsolated = true) {
    const python = [env.executable.filename];
    if (useIsolated) {
        python.push(...['-I', scripts_1.OUTPUT_MARKER_SCRIPT]);
    }
    else {
        python.push(...[scripts_1.OUTPUT_MARKER_SCRIPT]);
    }
    const interpreterInfo = await (0, interpreter_1.getInterpreterInfo)((0, exec_1.buildPythonExecInfo)(python, undefined, env.executable.filename));
    return interpreterInfo;
}
async function buildEnvironmentInfoUsingCondaRun(env) {
    const conda = await conda_1.Conda.getConda();
    const path = env.location.length ? env.location : env.executable.filename;
    const condaEnv = await (conda === null || conda === void 0 ? void 0 : conda.getCondaEnvironment(path));
    if (!condaEnv) {
        return undefined;
    }
    const python = await (conda === null || conda === void 0 ? void 0 : conda.getRunPythonArgs(condaEnv, true, true));
    if (!python) {
        return undefined;
    }
    const interpreterInfo = await (0, interpreter_1.getInterpreterInfo)((0, exec_1.buildPythonExecInfo)(python, undefined, env.executable.filename), conda_1.CONDA_ACTIVATION_TIMEOUT);
    return interpreterInfo;
}
class EnvironmentInfoService {
    constructor() {
        this.cache = new Map();
    }
    dispose() {
        if (this.workerPool !== undefined) {
            this.workerPool.stop();
            this.workerPool = undefined;
        }
        if (this.condaRunWorkerPool !== undefined) {
            this.condaRunWorkerPool.stop();
            this.condaRunWorkerPool = undefined;
        }
    }
    async getEnvironmentInfo(env, priority) {
        const interpreterPath = env.executable.filename;
        const result = this.cache.get((0, externalDependencies_1.normCasePath)(interpreterPath));
        if (result !== undefined) {
            return result.promise;
        }
        const deferred = (0, async_1.createDeferred)();
        this.cache.set((0, externalDependencies_1.normCasePath)(interpreterPath), deferred);
        this._getEnvironmentInfo(env, priority)
            .then((r) => {
            deferred.resolve(r);
        })
            .catch((ex) => {
            deferred.reject(ex);
        });
        return deferred.promise;
    }
    async _getEnvironmentInfo(env, priority, retryOnce = true) {
        if (env.kind === _1.PythonEnvKind.Conda && env.executable.filename === 'python') {
            const emptyInterpreterInfo = {
                arch: platform_1.Architecture.Unknown,
                executable: {
                    filename: 'python',
                    ctime: -1,
                    mtime: -1,
                    sysPrefix: '',
                },
                version: (0, pythonVersion_1.getEmptyVersion)(),
            };
            return emptyInterpreterInfo;
        }
        if (this.workerPool === undefined) {
            this.workerPool = (0, workerPool_1.createRunningWorkerPool)(buildEnvironmentInfo);
        }
        let reason;
        let r = await addToQueue(this.workerPool, env, priority).catch((err) => {
            reason = err;
            return undefined;
        });
        if (r === undefined) {
            const isCondaEnv = env.kind === _1.PythonEnvKind.Conda || (await (0, conda_1.isCondaEnvironment)(env.executable.filename));
            if (isCondaEnv) {
                (0, logging_1.traceVerbose)(`Validating ${env.executable.filename} normally failed with error, falling back to using conda run: (${reason})`);
                if (this.condaRunWorkerPool === undefined) {
                    this.condaRunWorkerPool = (0, workerPool_1.createRunningWorkerPool)(buildEnvironmentInfoUsingCondaRun);
                }
                r = await addToQueue(this.condaRunWorkerPool, env, priority).catch((err) => {
                    (0, logging_1.traceError)(err);
                    return undefined;
                });
            }
            else if (reason) {
                if (reason.message.includes('Unknown option: -I') ||
                    reason.message.includes("ModuleNotFoundError: No module named 'encodings'")) {
                    (0, logging_1.traceWarn)(reason);
                    if (reason.message.includes('Unknown option: -I')) {
                        (0, logging_1.traceError)('Support for Python 2.7 has been dropped by the Python extension so certain features may not work, upgrade to using Python 3.');
                    }
                    return buildEnvironmentInfo(env, false).catch((err) => {
                        (0, logging_1.traceError)(err);
                        return undefined;
                    });
                }
                (0, logging_1.traceError)(reason);
            }
        }
        if (r === undefined && retryOnce) {
            return (0, async_1.sleep)(2000).then(() => this._getEnvironmentInfo(env, priority, false));
        }
        return r;
    }
    resetInfo(searchLocation) {
        const searchLocationPath = searchLocation.fsPath;
        const keys = Array.from(this.cache.keys());
        keys.forEach((key) => {
            if (key.startsWith((0, externalDependencies_1.normCasePath)(searchLocationPath))) {
                this.cache.delete(key);
            }
        });
    }
}
function addToQueue(workerPool, env, priority) {
    return priority === EnvironmentInfoServiceQueuePriority.High
        ? workerPool.addToQueue(env, workerPool_1.QueuePosition.Front)
        : workerPool.addToQueue(env, workerPool_1.QueuePosition.Back);
}
let envInfoService;
function getEnvironmentInfoService(disposables) {
    if (envInfoService === undefined) {
        const service = new EnvironmentInfoService();
        disposables === null || disposables === void 0 ? void 0 : disposables.push({
            dispose: () => {
                service.dispose();
                envInfoService = undefined;
            },
        });
        envInfoService = service;
    }
    return envInfoService;
}
exports.getEnvironmentInfoService = getEnvironmentInfoService;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/executable.ts":
/*!***************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/executable.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseVersionFromExecutable = void 0;
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const pythonVersion_1 = __webpack_require__(/*! ./pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
function parseVersionFromExecutable(filename) {
    const version = parseBasename(path.basename(filename));
    if (version.major === 2 && version.minor === -1) {
        version.minor = 7;
    }
    return version;
}
exports.parseVersionFromExecutable = parseVersionFromExecutable;
function parseBasename(basename) {
    basename = (0, externalDependencies_1.normCasePath)(basename);
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        if (basename === 'python.exe') {
            return (0, pythonVersion_1.getEmptyVersion)();
        }
    }
    else if (basename === 'python') {
        return (0, pythonVersion_1.parseVersion)('2.7');
    }
    if (!basename.startsWith('python')) {
        throw Error(`not a Python executable (expected "python..", got "${basename}")`);
    }
    return (0, pythonVersion_1.parseVersion)(basename);
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/index.ts":
/*!**********************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/index.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UNKNOWN_PYTHON_VERSION = exports.PythonReleaseLevel = exports.PythonEnvSource = exports.globallyInstalledEnvKinds = exports.virtualEnvKinds = exports.PythonEnvType = exports.PythonEnvKind = void 0;
var PythonEnvKind;
(function (PythonEnvKind) {
    PythonEnvKind["Unknown"] = "unknown";
    PythonEnvKind["System"] = "global-system";
    PythonEnvKind["MicrosoftStore"] = "global-microsoft-store";
    PythonEnvKind["Pyenv"] = "global-pyenv";
    PythonEnvKind["Poetry"] = "poetry";
    PythonEnvKind["ActiveState"] = "activestate";
    PythonEnvKind["Custom"] = "global-custom";
    PythonEnvKind["OtherGlobal"] = "global-other";
    PythonEnvKind["Venv"] = "virt-venv";
    PythonEnvKind["VirtualEnv"] = "virt-virtualenv";
    PythonEnvKind["VirtualEnvWrapper"] = "virt-virtualenvwrapper";
    PythonEnvKind["Pipenv"] = "virt-pipenv";
    PythonEnvKind["Conda"] = "virt-conda";
    PythonEnvKind["OtherVirtual"] = "virt-other";
})(PythonEnvKind = exports.PythonEnvKind || (exports.PythonEnvKind = {}));
var PythonEnvType;
(function (PythonEnvType) {
    PythonEnvType["Conda"] = "Conda";
    PythonEnvType["Virtual"] = "Virtual";
})(PythonEnvType = exports.PythonEnvType || (exports.PythonEnvType = {}));
exports.virtualEnvKinds = [
    PythonEnvKind.Poetry,
    PythonEnvKind.Pipenv,
    PythonEnvKind.Venv,
    PythonEnvKind.VirtualEnvWrapper,
    PythonEnvKind.Conda,
    PythonEnvKind.VirtualEnv,
];
exports.globallyInstalledEnvKinds = [
    PythonEnvKind.OtherGlobal,
    PythonEnvKind.Unknown,
    PythonEnvKind.MicrosoftStore,
    PythonEnvKind.System,
    PythonEnvKind.Custom,
];
var PythonEnvSource;
(function (PythonEnvSource) {
    PythonEnvSource["PathEnvVar"] = "path env var";
    PythonEnvSource["WindowsRegistry"] = "windows registry";
})(PythonEnvSource = exports.PythonEnvSource || (exports.PythonEnvSource = {}));
var PythonReleaseLevel;
(function (PythonReleaseLevel) {
    PythonReleaseLevel["Alpha"] = "alpha";
    PythonReleaseLevel["Beta"] = "beta";
    PythonReleaseLevel["Candidate"] = "candidate";
    PythonReleaseLevel["Final"] = "final";
})(PythonReleaseLevel = exports.PythonReleaseLevel || (exports.PythonReleaseLevel = {}));
exports.UNKNOWN_PYTHON_VERSION = {
    major: -1,
    minor: -1,
    micro: -1,
    release: { level: PythonReleaseLevel.Final, serial: -1 },
    sysVersion: undefined,
};
Object.freeze(exports.UNKNOWN_PYTHON_VERSION);


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/interpreter.ts":
/*!****************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/interpreter.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getInterpreterInfo = void 0;
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const scripts_1 = __webpack_require__(/*! ../../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const exec_1 = __webpack_require__(/*! ../../exec */ "./src/client/pythonEnvironments/exec.ts");
const pythonVersion_1 = __webpack_require__(/*! ./pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
function extractInterpreterInfo(python, raw) {
    let rawVersion = `${raw.versionInfo.slice(0, 3).join('.')}`;
    if (raw.versionInfo[3] !== undefined && ['final', 'alpha', 'beta', 'candidate'].includes(raw.versionInfo[3])) {
        rawVersion = `${rawVersion}-${raw.versionInfo[3]}`;
        if (raw.versionInfo[4] !== undefined) {
            let serial = -1;
            try {
                serial = parseInt(`${raw.versionInfo[4]}`, 10);
            }
            catch (ex) {
                serial = -1;
            }
            rawVersion = serial >= 0 ? `${rawVersion}${serial}` : rawVersion;
        }
    }
    return {
        arch: raw.is64Bit ? platform_1.Architecture.x64 : platform_1.Architecture.x86,
        executable: {
            filename: python,
            sysPrefix: raw.sysPrefix,
            mtime: -1,
            ctime: -1,
        },
        version: {
            ...(0, pythonVersion_1.parseVersion)(rawVersion),
            sysVersion: raw.sysVersion,
        },
    };
}
async function getInterpreterInfo(python, timeout) {
    const [args, parse] = (0, scripts_1.interpreterInfo)();
    const info = (0, exec_1.copyPythonExecInfo)(python, args);
    const argv = [info.command, ...info.args];
    const quoted = argv.reduce((p, c) => (p ? `${p} ${c.toCommandArgumentForPythonMgrExt()}` : `${c.toCommandArgumentForPythonMgrExt()}`), '');
    const standardTimeout = constants_1.isCI ? 30000 : 15000;
    const result = await (0, externalDependencies_1.shellExecute)(quoted, { timeout: timeout !== null && timeout !== void 0 ? timeout : standardTimeout });
    if (result.stderr) {
        (0, logging_1.traceError)(`Stderr when executing script with >> ${quoted} << stderr: ${result.stderr}, still attempting to parse output`);
    }
    let json;
    try {
        json = parse(result.stdout);
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to parse interpreter information for >> ${quoted} << with ${ex}`);
        return undefined;
    }
    (0, logging_1.traceVerbose)(`Found interpreter for >> ${quoted} <<: ${JSON.stringify(json)}`);
    return extractInterpreterInfo(python.pythonExecutable, json);
}
exports.getInterpreterInfo = getInterpreterInfo;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/info/pythonVersion.ts":
/*!******************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/info/pythonVersion.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.compareSemVerLikeVersions = exports.toSemverLikeVersion = exports.areSimilarVersions = exports.areIdenticalVersion = exports.getShortVersionString = exports.getVersionDisplayString = exports.isVersionEmpty = exports.getEmptyVersion = exports.parseBasicVersion = exports.parseRelease = exports.parseVersion = exports.getPythonVersionFromPath = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const path = __webpack_require__(/*! path */ "path");
const basic = __webpack_require__(/*! ../../../common/utils/version */ "./src/client/common/utils/version.ts");
const _1 = __webpack_require__(/*! . */ "./src/client/pythonEnvironments/base/info/index.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
function getPythonVersionFromPath(exe) {
    let version = _1.UNKNOWN_PYTHON_VERSION;
    try {
        version = parseVersion(path.basename(exe));
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to parse version from path: ${exe}`, ex);
    }
    return version;
}
exports.getPythonVersionFromPath = getPythonVersionFromPath;
function parseVersion(versionStr) {
    const [version, after] = parseBasicVersion(versionStr);
    if (version.micro === -1) {
        return version;
    }
    const [release] = parseRelease(after);
    version.release = release;
    return version;
}
exports.parseVersion = parseVersion;
function parseRelease(text) {
    let after;
    let alpha;
    let beta;
    let rc;
    let fin;
    let serialStr;
    let match = text.match(/^(?:-?final|\.final(?:\.0)?)(.*)$/);
    if (match) {
        [, after] = match;
        fin = 'final';
        serialStr = '0';
    }
    else {
        for (const regex of [
            /^(?:(a)|(b)|(rc))([1-9]\d*)(.*)$/,
            /^-(?:(?:(alpha)|(beta)|(candidate))([1-9]\d*))(.*)$/,
            /^\.(?:(?:(alpha)|(beta)|(candidate))\.([1-9]\d*))(.*)$/,
        ]) {
            match = text.match(regex);
            if (match) {
                [, alpha, beta, rc, serialStr, after] = match;
                break;
            }
        }
    }
    let level;
    if (fin) {
        level = _1.PythonReleaseLevel.Final;
    }
    else if (rc) {
        level = _1.PythonReleaseLevel.Candidate;
    }
    else if (beta) {
        level = _1.PythonReleaseLevel.Beta;
    }
    else if (alpha) {
        level = _1.PythonReleaseLevel.Alpha;
    }
    else {
        return [undefined, text];
    }
    const serial = parseInt(serialStr, 10);
    return [{ level, serial }, after];
}
exports.parseRelease = parseRelease;
function parseBasicVersion(versionStr) {
    const parsed = basic.parseBasicVersionInfo(`ignored-${versionStr}`);
    if (!parsed) {
        if (versionStr === '') {
            return [getEmptyVersion(), ''];
        }
        throw Error(`invalid version ${versionStr}`);
    }
    const { version, after } = parsed;
    version.release = undefined;
    if (version.minor === -1) {
        if (version.major > 9) {
            const numdigits = version.major.toString().length - 1;
            const factor = 10 ** numdigits;
            version.minor = version.major % factor;
            version.major = Math.floor(version.major / factor);
        }
    }
    return [version, after];
}
exports.parseBasicVersion = parseBasicVersion;
function getEmptyVersion() {
    return (0, lodash_1.cloneDeep)(basic.EMPTY_VERSION);
}
exports.getEmptyVersion = getEmptyVersion;
function isVersionEmpty(version) {
    return basic.isVersionInfoEmpty(version);
}
exports.isVersionEmpty = isVersionEmpty;
function getVersionDisplayString(ver) {
    if (isVersionEmpty(ver)) {
        return '';
    }
    if (ver.micro !== -1) {
        return getShortVersionString(ver);
    }
    return `${getShortVersionString(ver)}.x`;
}
exports.getVersionDisplayString = getVersionDisplayString;
function getShortVersionString(ver) {
    let verStr = basic.getVersionString(ver);
    if (ver.release === undefined) {
        return verStr;
    }
    if (ver.release.level === _1.PythonReleaseLevel.Final) {
        return verStr;
    }
    if (ver.release.level === _1.PythonReleaseLevel.Candidate) {
        verStr = `${verStr}rc${ver.release.serial}`;
    }
    else if (ver.release.level === _1.PythonReleaseLevel.Beta) {
        verStr = `${verStr}b${ver.release.serial}`;
    }
    else if (ver.release.level === _1.PythonReleaseLevel.Alpha) {
        verStr = `${verStr}a${ver.release.serial}`;
    }
    else {
        throw Error(`unsupported release level ${ver.release.level}`);
    }
    return verStr;
}
exports.getShortVersionString = getShortVersionString;
function areIdenticalVersion(left, right) {
    return basic.areIdenticalVersion(left, right, compareVersionRelease);
}
exports.areIdenticalVersion = areIdenticalVersion;
function areSimilarVersions(left, right) {
    if (!basic.areSimilarVersions(left, right, compareVersionRelease)) {
        return false;
    }
    if (left.major === 2) {
        return true;
    }
    return left.minor > -1 && right.minor > -1;
}
exports.areSimilarVersions = areSimilarVersions;
function compareVersionRelease(left, right) {
    if (left.release === undefined) {
        if (right.release === undefined) {
            return [0, ''];
        }
        return [1, 'level'];
    }
    if (right.release === undefined) {
        return [-1, 'level'];
    }
    if (left.release.level < right.release.level) {
        return [1, 'level'];
    }
    if (left.release.level > right.release.level) {
        return [-1, 'level'];
    }
    if (left.release.level === _1.PythonReleaseLevel.Final) {
        return [0, ''];
    }
    if (left.release.serial < right.release.serial) {
        return [1, 'serial'];
    }
    if (left.release.serial > right.release.serial) {
        return [-1, 'serial'];
    }
    return [0, ''];
}
function toSemverLikeVersion(version) {
    const versionPrefix = basic.getVersionString(version);
    let preRelease = [];
    if (version.release) {
        preRelease =
            version.release.serial < 0
                ? [`${version.release.level}`]
                : [`${version.release.level}`, `${version.release.serial}`];
    }
    return {
        raw: versionPrefix,
        major: version.major,
        minor: version.minor,
        patch: version.micro,
        build: [],
        prerelease: preRelease,
    };
}
exports.toSemverLikeVersion = toSemverLikeVersion;
function compareSemVerLikeVersions(v1, v2) {
    if (v1.major === v2.major) {
        if (v1.minor === v2.minor) {
            if (v1.patch === v2.patch) {
                return 0;
            }
            return v1.patch > v2.patch ? 1 : -1;
        }
        return v1.minor > v2.minor ? 1 : -1;
    }
    return v1.major > v2.major ? 1 : -1;
}
exports.compareSemVerLikeVersions = compareSemVerLikeVersions;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locator.ts":
/*!*******************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locator.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Locator = exports.NOOP_ITERATOR = exports.isProgressEvent = exports.ProgressReportStage = void 0;
const async_1 = __webpack_require__(/*! ../../common/utils/async */ "./src/client/common/utils/async.ts");
const watcher_1 = __webpack_require__(/*! ./watcher */ "./src/client/pythonEnvironments/base/watcher.ts");
var ProgressReportStage;
(function (ProgressReportStage) {
    ProgressReportStage["discoveryStarted"] = "discoveryStarted";
    ProgressReportStage["allPathsDiscovered"] = "allPathsDiscovered";
    ProgressReportStage["discoveryFinished"] = "discoveryFinished";
})(ProgressReportStage = exports.ProgressReportStage || (exports.ProgressReportStage = {}));
function isProgressEvent(event) {
    return 'stage' in event;
}
exports.isProgressEvent = isProgressEvent;
exports.NOOP_ITERATOR = (0, async_1.iterEmpty)();
class LocatorBase {
    constructor(watcher) {
        this.emitter = watcher;
        this.onChanged = watcher.onChanged;
    }
}
class Locator extends LocatorBase {
    constructor() {
        super(new watcher_1.PythonEnvsWatcher());
    }
}
exports.Locator = Locator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locatorUtils.ts":
/*!************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locatorUtils.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnvs = exports.getQueryFilter = void 0;
const async_1 = __webpack_require__(/*! ../../common/utils/async */ "./src/client/common/utils/async.ts");
const misc_1 = __webpack_require__(/*! ../../common/utils/misc */ "./src/client/common/utils/misc.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const locator_1 = __webpack_require__(/*! ./locator */ "./src/client/pythonEnvironments/base/locator.ts");
function getQueryFilter(query) {
    var _a;
    const kinds = query.kinds !== undefined && query.kinds.length > 0 ? query.kinds : undefined;
    const includeNonRooted = !((_a = query.searchLocations) === null || _a === void 0 ? void 0 : _a.doNotIncludeNonRooted);
    const locationFilters = getSearchLocationFilters(query);
    function checkKind(env) {
        if (kinds === undefined) {
            return true;
        }
        return kinds.includes(env.kind);
    }
    function checkSearchLocation(env) {
        if (env.searchLocation === undefined) {
            return includeNonRooted;
        }
        const loc = env.searchLocation;
        if (locationFilters !== undefined) {
            return locationFilters.some((filter) => filter(loc));
        }
        return true;
    }
    return (env) => {
        if (!checkKind(env)) {
            return false;
        }
        if (!checkSearchLocation(env)) {
            return false;
        }
        return true;
    };
}
exports.getQueryFilter = getQueryFilter;
function getSearchLocationFilters(query) {
    if (query.searchLocations === undefined) {
        return undefined;
    }
    if (query.searchLocations.roots.length === 0) {
        return [];
    }
    return query.searchLocations.roots.map((loc) => (0, misc_1.getURIFilter)(loc, {
        checkParent: true,
    }));
}
async function getEnvs(iterator) {
    const envs = [];
    const updatesDone = (0, async_1.createDeferred)();
    if (iterator.onUpdated === undefined) {
        updatesDone.resolve();
    }
    else {
        const listener = iterator.onUpdated((event) => {
            if ((0, locator_1.isProgressEvent)(event)) {
                if (event.stage !== locator_1.ProgressReportStage.discoveryFinished) {
                    return;
                }
                updatesDone.resolve();
                listener.dispose();
            }
            else {
                const { index, update } = event;
                if (envs[index] === undefined) {
                    const json = JSON.stringify(update);
                    (0, logging_1.traceVerbose)(`Updates sent for an env which was classified as invalid earlier, currently not expected, ${json}`);
                }
                envs[index] = update;
            }
        });
    }
    let itemIndex = 0;
    for await (const env of iterator) {
        if (envs[itemIndex] === undefined) {
            envs[itemIndex] = env;
        }
        itemIndex += 1;
    }
    await updatesDone.promise;
    return envs.filter((e) => e !== undefined).map((e) => e);
}
exports.getEnvs = getEnvs;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators.ts":
/*!********************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Locators = exports.combineIterators = void 0;
const async_1 = __webpack_require__(/*! ../../common/utils/async */ "./src/client/common/utils/async.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const locator_1 = __webpack_require__(/*! ./locator */ "./src/client/pythonEnvironments/base/locator.ts");
const watchers_1 = __webpack_require__(/*! ./watchers */ "./src/client/pythonEnvironments/base/watchers.ts");
function combineIterators(iterators) {
    const result = (0, async_1.chain)(iterators);
    const events = iterators.map((it) => it.onUpdated).filter((v) => v);
    if (!events || events.length === 0) {
        return result;
    }
    result.onUpdated = (handleEvent) => {
        const disposables = new resourceLifecycle_1.Disposables();
        let numActive = events.length;
        events.forEach((event) => {
            const disposable = event((e) => {
                if ((0, locator_1.isProgressEvent)(e)) {
                    if (e.stage === locator_1.ProgressReportStage.discoveryFinished) {
                        numActive -= 1;
                        if (numActive === 0) {
                            handleEvent({ stage: locator_1.ProgressReportStage.discoveryFinished });
                        }
                    }
                    else {
                        handleEvent({ stage: e.stage });
                    }
                }
                else {
                    handleEvent(e);
                }
            });
            disposables.push(disposable);
        });
        return disposables;
    };
    return result;
}
exports.combineIterators = combineIterators;
class Locators extends watchers_1.PythonEnvsWatchers {
    constructor(locators) {
        super(locators);
        this.locators = locators;
        this.providerId = locators.map((loc) => loc.providerId).join('+');
    }
    iterEnvs(query) {
        const iterators = this.locators.map((loc) => loc.iterEnvs(query));
        return combineIterators(iterators);
    }
}
exports.Locators = Locators;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/common/resourceBasedLocator.ts":
/*!************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/common/resourceBasedLocator.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LazyResourceBasedLocator = void 0;
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../../../common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const env_1 = __webpack_require__(/*! ../../info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const locator_1 = __webpack_require__(/*! ../../locator */ "./src/client/pythonEnvironments/base/locator.ts");
class LazyResourceBasedLocator extends locator_1.Locator {
    constructor() {
        super(...arguments);
        this.disposables = new resourceLifecycle_1.Disposables();
    }
    async activate() {
        await this.ensureResourcesReady();
        this.ensureWatchersReady().ignoreErrors();
    }
    async dispose() {
        await this.disposables.dispose();
    }
    async *iterEnvs(query) {
        await this.activate();
        const iterator = this.doIterEnvs(query);
        if (query === null || query === void 0 ? void 0 : query.envPath) {
            let result = await iterator.next();
            while (!result.done) {
                const currEnv = result.value;
                const { path } = (0, env_1.getEnvPath)(currEnv.executablePath, currEnv.envPath);
                if ((0, externalDependencies_1.arePathsSame)(path, query.envPath)) {
                    yield currEnv;
                    break;
                }
                result = await iterator.next();
            }
        }
        else {
            yield* iterator;
        }
    }
    async initResources() {
    }
    async initWatchers() {
    }
    async ensureResourcesReady() {
        if (this.resourcesReady !== undefined) {
            await this.resourcesReady.promise;
            return;
        }
        this.resourcesReady = (0, async_1.createDeferred)();
        await this.initResources().catch((ex) => {
            var _a;
            (0, logging_1.traceError)(ex);
            (_a = this.resourcesReady) === null || _a === void 0 ? void 0 : _a.reject(ex);
        });
        this.resourcesReady.resolve();
    }
    async ensureWatchersReady() {
        if (this.watchersReady !== undefined) {
            await this.watchersReady.promise;
            return;
        }
        this.watchersReady = (0, async_1.createDeferred)();
        if (!(0, externalDependencies_1.isVirtualWorkspace)()) {
            await this.initWatchers().catch((ex) => {
                var _a;
                (0, logging_1.traceError)(ex);
                (_a = this.watchersReady) === null || _a === void 0 ? void 0 : _a.reject(ex);
            });
        }
        this.watchersReady.resolve();
    }
}
exports.LazyResourceBasedLocator = LazyResourceBasedLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/composite/envsCollectionCache.ts":
/*!**************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/composite/envsCollectionCache.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createCollectionCache = exports.PythonEnvInfoCache = void 0;
const constants_1 = __webpack_require__(/*! ../../../../common/constants */ "./src/client/common/constants.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const env_1 = __webpack_require__(/*! ../../info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const watcher_1 = __webpack_require__(/*! ../../watcher */ "./src/client/pythonEnvironments/base/watcher.ts");
const conda_1 = __webpack_require__(/*! ../../../common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
class PythonEnvInfoCache extends watcher_1.PythonEnvsWatcher {
    constructor(persistentStorage) {
        super();
        this.persistentStorage = persistentStorage;
        this.envs = [];
        this.validatedEnvs = new Set();
        this.flushedEnvs = new Set();
    }
    async validateCache(envs, isCompleteList) {
        const areEnvsValid = await Promise.all(this.envs.map(async (cachedEnv) => {
            const { path } = (0, env_1.getEnvPath)(cachedEnv.executable.filename, cachedEnv.location);
            if (await (0, externalDependencies_1.pathExists)(path)) {
                if (envs && isCompleteList) {
                    if (cachedEnv.searchLocation) {
                        return true;
                    }
                    if (envs.some((env) => cachedEnv.id === env.id)) {
                        return true;
                    }
                    if (Array.from(this.validatedEnvs.keys()).some((envId) => cachedEnv.id === envId)) {
                        return true;
                    }
                }
                else {
                    return true;
                }
            }
            return false;
        }));
        const invalidIndexes = areEnvsValid
            .map((isValid, index) => (isValid ? -1 : index))
            .filter((i) => i !== -1)
            .reverse();
        invalidIndexes.forEach((index) => {
            const env = this.envs.splice(index, 1)[0];
            (0, logging_1.traceVerbose)(`Removing invalid env from cache ${env.id}`);
            this.fire({ old: env, new: undefined });
        });
        if (envs) {
            envs.forEach((env) => {
                const cachedEnv = this.envs.find((e) => e.id === env.id);
                if (cachedEnv && !(0, env_1.areEnvsDeepEqual)(cachedEnv, env)) {
                    this.updateEnv(cachedEnv, env, true);
                }
            });
        }
    }
    getAllEnvs() {
        return this.envs;
    }
    addEnv(env, hasLatestInfo) {
        const found = this.envs.find((e) => (0, env_1.areSameEnv)(e, env));
        if (!found) {
            this.envs.push(env);
            this.fire({ new: env });
        }
        else if (hasLatestInfo && !this.validatedEnvs.has(env.id)) {
            this.updateEnv(found, env, true);
        }
        if (hasLatestInfo) {
            (0, logging_1.traceVerbose)(`Flushing env to cache ${env.id}`);
            this.validatedEnvs.add(env.id);
            this.flush(env).ignoreErrors();
        }
    }
    updateEnv(oldValue, newValue, forceUpdate = false) {
        if (this.flushedEnvs.has(oldValue.id) && !forceUpdate) {
            return;
        }
        const index = this.envs.findIndex((e) => (0, env_1.areSameEnv)(e, oldValue));
        if (index !== -1) {
            if (newValue === undefined) {
                this.envs.splice(index, 1);
            }
            else {
                this.envs[index] = newValue;
            }
            this.fire({ old: oldValue, new: newValue });
        }
    }
    async getLatestInfo(path) {
        var _a;
        const env = (_a = this.envs.find((e) => (0, externalDependencies_1.arePathsSame)(e.location, path))) !== null && _a !== void 0 ? _a : this.envs.find((e) => (0, env_1.areSameEnv)(e, path));
        if ((env === null || env === void 0 ? void 0 : env.kind) === info_1.PythonEnvKind.Conda &&
            (0, env_1.getEnvPath)(env.executable.filename, env.location).pathType === 'envFolderPath') {
            if (await (0, externalDependencies_1.pathExists)((0, conda_1.getCondaInterpreterPath)(env.location))) {
                this.validatedEnvs.delete(env.id);
                return undefined;
            }
            this.validatedEnvs.add(env.id);
            return env;
        }
        if (env) {
            if (this.validatedEnvs.has(env.id)) {
                (0, logging_1.traceVerbose)(`Found cached env for ${path}`);
                return env;
            }
            if (await this.validateInfo(env)) {
                (0, logging_1.traceVerbose)(`Needed to validate ${path} with latest info`);
                this.validatedEnvs.add(env.id);
                return env;
            }
        }
        (0, logging_1.traceVerbose)(`No cached env found for ${path}`);
        return undefined;
    }
    clearAndReloadFromStorage() {
        this.envs = this.persistentStorage.get();
        this.markAllEnvsAsFlushed();
    }
    async flush(env) {
        if (env) {
            const envs = this.persistentStorage.get();
            const index = envs.findIndex((e) => e.id === env.id);
            envs[index] = env;
            this.flushedEnvs.add(env.id);
            await this.persistentStorage.store(envs);
            return;
        }
        (0, logging_1.traceVerbose)('Environments added to cache', JSON.stringify(this.envs));
        this.markAllEnvsAsFlushed();
        await this.persistentStorage.store(this.envs);
    }
    markAllEnvsAsFlushed() {
        this.envs.forEach((e) => {
            this.flushedEnvs.add(e.id);
        });
    }
    async validateInfo(env) {
        if (!this.flushedEnvs.has(env.id)) {
            return false;
        }
        const { ctime, mtime } = await (0, externalDependencies_1.getFileInfo)(env.executable.filename);
        if (ctime !== -1 && mtime !== -1 && ctime === env.executable.ctime && mtime === env.executable.mtime) {
            return true;
        }
        env.executable.ctime = ctime;
        env.executable.mtime = mtime;
        return false;
    }
}
exports.PythonEnvInfoCache = PythonEnvInfoCache;
async function createCollectionCache(storage) {
    const cache = new PythonEnvInfoCache(storage);
    cache.clearAndReloadFromStorage();
    await validateCache(cache);
    return cache;
}
exports.createCollectionCache = createCollectionCache;
async function validateCache(cache) {
    if ((0, constants_1.isTestExecution)()) {
        return cache.validateCache();
    }
    return cache.validateCache().ignoreErrors();
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/composite/envsCollectionService.ts":
/*!****************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/composite/envsCollectionService.ts ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvsCollectionService = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
__webpack_require__(/*! ../../../../common/extensions */ "./src/client/common/extensions.ts");
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const stopWatch_1 = __webpack_require__(/*! ../../../../common/utils/stopWatch */ "./src/client/common/utils/stopWatch.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const telemetry_1 = __webpack_require__(/*! ../../../../telemetry */ "./src/client/telemetry/index.ts");
const constants_1 = __webpack_require__(/*! ../../../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const env_1 = __webpack_require__(/*! ../../info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const locator_1 = __webpack_require__(/*! ../../locator */ "./src/client/pythonEnvironments/base/locator.ts");
const locatorUtils_1 = __webpack_require__(/*! ../../locatorUtils */ "./src/client/pythonEnvironments/base/locatorUtils.ts");
const watcher_1 = __webpack_require__(/*! ../../watcher */ "./src/client/pythonEnvironments/base/watcher.ts");
class EnvsCollectionService extends watcher_1.PythonEnvsWatcher {
    constructor(cache, locator) {
        super();
        this.cache = cache;
        this.locator = locator;
        this.refreshesPerQuery = new Map();
        this.scheduledRefreshesPerQuery = new Map();
        this.progressPromises = new Map();
        this.hasRefreshFinishedForQuery = new Map();
        this.progress = new vscode_1.EventEmitter();
        this.refreshState = locator_1.ProgressReportStage.discoveryFinished;
        this.locator.onChanged((event) => {
            const query = event.providerId
                ? { providerId: event.providerId, envPath: event.envPath }
                : undefined;
            let scheduledRefresh = this.scheduledRefreshesPerQuery.get(query);
            if (!scheduledRefresh) {
                scheduledRefresh = this.scheduleNewRefresh(query);
            }
            scheduledRefresh.then(() => {
                this.fire(event);
            });
        });
        this.cache.onChanged((e) => {
            this.fire(e);
        });
        this.onProgress((event) => {
            var _a;
            this.refreshState = event.stage;
            (_a = this.progressPromises.get(event.stage)) === null || _a === void 0 ? void 0 : _a.resolve();
            this.progressPromises.delete(event.stage);
        });
    }
    get onProgress() {
        return this.progress.event;
    }
    getRefreshPromise(options) {
        var _a, _b;
        const stage = (_a = options === null || options === void 0 ? void 0 : options.stage) !== null && _a !== void 0 ? _a : locator_1.ProgressReportStage.discoveryFinished;
        return (_b = this.progressPromises.get(stage)) === null || _b === void 0 ? void 0 : _b.promise;
    }
    async resolveEnv(path) {
        path = (0, externalDependencies_1.normalizePath)(path);
        const cachedEnv = await this.cache.getLatestInfo(path);
        if (cachedEnv) {
            (0, logging_1.traceVerbose)(`Resolved ${path} from cache: ${JSON.stringify(cachedEnv)}`);
            return cachedEnv;
        }
        const resolved = await this.locator.resolveEnv(path).catch((ex) => {
            (0, logging_1.traceError)(`Failed to resolve ${path}`, ex);
            return undefined;
        });
        (0, logging_1.traceVerbose)(`Resolved ${path} to ${JSON.stringify(resolved)}`);
        if (resolved) {
            this.cache.addEnv(resolved, true);
        }
        return resolved;
    }
    getEnvs(query) {
        const cachedEnvs = this.cache.getAllEnvs();
        return query ? cachedEnvs.filter((0, locatorUtils_1.getQueryFilter)(query)) : cachedEnvs;
    }
    triggerRefresh(query, options) {
        const stopWatch = new stopWatch_1.StopWatch();
        let refreshPromise = this.getRefreshPromiseForQuery(query);
        if (!refreshPromise) {
            if ((options === null || options === void 0 ? void 0 : options.ifNotTriggerredAlready) && this.hasRefreshFinished(query)) {
                return Promise.resolve();
            }
            refreshPromise = this.startRefresh(query);
        }
        return refreshPromise.then(() => this.sendTelemetry(query, stopWatch));
    }
    startRefresh(query) {
        this.createProgressStates(query);
        const promise = this.addEnvsToCacheForQuery(query);
        return promise
            .then(async () => {
            this.resolveProgressStates(query);
        })
            .catch((ex) => {
            this.rejectProgressStates(query, ex);
        });
    }
    async addEnvsToCacheForQuery(query) {
        const iterator = this.locator.iterEnvs(query);
        const seen = [];
        const state = {
            done: false,
            pending: 0,
        };
        const updatesDone = (0, async_1.createDeferred)();
        if (iterator.onUpdated !== undefined) {
            const listener = iterator.onUpdated(async (event) => {
                if ((0, locator_1.isProgressEvent)(event)) {
                    switch (event.stage) {
                        case locator_1.ProgressReportStage.discoveryFinished:
                            state.done = true;
                            listener.dispose();
                            break;
                        case locator_1.ProgressReportStage.allPathsDiscovered:
                            if (!query) {
                                this.progress.fire(event);
                            }
                            break;
                        default:
                            this.progress.fire(event);
                    }
                }
                else {
                    state.pending += 1;
                    this.cache.updateEnv(seen[event.index], event.update);
                    if (event.update) {
                        seen[event.index] = event.update;
                    }
                    state.pending -= 1;
                }
                if (state.done && state.pending === 0) {
                    updatesDone.resolve();
                }
            });
        }
        else {
            this.progress.fire({ stage: locator_1.ProgressReportStage.discoveryStarted });
            updatesDone.resolve();
        }
        for await (const env of iterator) {
            seen.push(env);
            this.cache.addEnv(env);
        }
        await updatesDone.promise;
        await this.cache.validateCache(seen, query === undefined);
        this.cache.flush().ignoreErrors();
    }
    getRefreshPromiseForQuery(query) {
        var _a, _b, _c;
        return (_b = (_a = this.refreshesPerQuery.get(query)) === null || _a === void 0 ? void 0 : _a.promise) !== null && _b !== void 0 ? _b : (_c = this.refreshesPerQuery.get(undefined)) === null || _c === void 0 ? void 0 : _c.promise;
    }
    hasRefreshFinished(query) {
        var _a;
        return (_a = this.hasRefreshFinishedForQuery.get(query)) !== null && _a !== void 0 ? _a : this.hasRefreshFinishedForQuery.get(undefined);
    }
    async scheduleNewRefresh(query) {
        const refreshPromise = this.getRefreshPromiseForQuery(query);
        let nextRefreshPromise;
        if (!refreshPromise) {
            nextRefreshPromise = this.startRefresh(query);
        }
        else {
            nextRefreshPromise = refreshPromise.then(() => {
                this.scheduledRefreshesPerQuery.delete(query);
                this.startRefresh(query);
            });
            this.scheduledRefreshesPerQuery.set(query, nextRefreshPromise);
        }
        return nextRefreshPromise;
    }
    createProgressStates(query) {
        this.refreshesPerQuery.set(query, (0, async_1.createDeferred)());
        Object.values(locator_1.ProgressReportStage).forEach((stage) => {
            this.progressPromises.set(stage, (0, async_1.createDeferred)());
        });
        if (locator_1.ProgressReportStage.allPathsDiscovered && query) {
            this.progressPromises.delete(locator_1.ProgressReportStage.allPathsDiscovered);
        }
    }
    rejectProgressStates(query, ex) {
        var _a;
        (_a = this.refreshesPerQuery.get(query)) === null || _a === void 0 ? void 0 : _a.reject(ex);
        this.refreshesPerQuery.delete(query);
        Object.values(locator_1.ProgressReportStage).forEach((stage) => {
            var _a;
            (_a = this.progressPromises.get(stage)) === null || _a === void 0 ? void 0 : _a.reject(ex);
            this.progressPromises.delete(stage);
        });
    }
    resolveProgressStates(query) {
        var _a;
        (_a = this.refreshesPerQuery.get(query)) === null || _a === void 0 ? void 0 : _a.resolve();
        this.refreshesPerQuery.delete(query);
        const isRefreshComplete = Array.from(this.refreshesPerQuery.values()).every((d) => d.completed);
        if (isRefreshComplete) {
            this.progress.fire({ stage: locator_1.ProgressReportStage.discoveryFinished });
        }
    }
    sendTelemetry(query, stopWatch) {
        if (!query && !this.hasRefreshFinished(query)) {
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.PYTHON_INTERPRETER_DISCOVERY, stopWatch.elapsedTime, {
                interpreters: this.cache.getAllEnvs().length,
                environmentsWithoutPython: this.cache
                    .getAllEnvs()
                    .filter((e) => (0, env_1.getEnvPath)(e.executable.filename, e.location).pathType === 'envFolderPath').length,
            });
        }
        this.hasRefreshFinishedForQuery.set(query, true);
    }
}
exports.EnvsCollectionService = EnvsCollectionService;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/composite/envsReducer.ts":
/*!******************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/composite/envsReducer.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonEnvsReducer = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const env_1 = __webpack_require__(/*! ../../info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const envKind_1 = __webpack_require__(/*! ../../info/envKind */ "./src/client/pythonEnvironments/base/info/envKind.ts");
const locator_1 = __webpack_require__(/*! ../../locator */ "./src/client/pythonEnvironments/base/locator.ts");
class PythonEnvsReducer {
    constructor(parentLocator) {
        this.parentLocator = parentLocator;
    }
    get onChanged() {
        return this.parentLocator.onChanged;
    }
    iterEnvs(query) {
        const didUpdate = new vscode_1.EventEmitter();
        const incomingIterator = this.parentLocator.iterEnvs(query);
        const iterator = iterEnvsIterator(incomingIterator, didUpdate);
        iterator.onUpdated = didUpdate.event;
        return iterator;
    }
}
exports.PythonEnvsReducer = PythonEnvsReducer;
async function* iterEnvsIterator(iterator, didUpdate) {
    const state = {
        done: false,
        pending: 0,
    };
    const seen = [];
    if (iterator.onUpdated !== undefined) {
        const listener = iterator.onUpdated((event) => {
            state.pending += 1;
            if ((0, locator_1.isProgressEvent)(event)) {
                if (event.stage === locator_1.ProgressReportStage.discoveryFinished) {
                    state.done = true;
                    listener.dispose();
                }
                else {
                    didUpdate.fire(event);
                }
            }
            else if (event.update === undefined) {
                throw new Error('Unsupported behavior: `undefined` environment updates are not supported from downstream locators in reducer');
            }
            else if (seen[event.index] !== undefined) {
                const oldEnv = seen[event.index];
                seen[event.index] = event.update;
                didUpdate.fire({ index: event.index, old: oldEnv, update: event.update });
            }
            else {
                (0, logging_1.traceVerbose)(`Expected already iterated env, got ${event.old} (#${event.index})`);
            }
            state.pending -= 1;
            checkIfFinishedAndNotify(state, didUpdate);
        });
    }
    else {
        didUpdate.fire({ stage: locator_1.ProgressReportStage.discoveryStarted });
    }
    let result = await iterator.next();
    while (!result.done) {
        const currEnv = result.value;
        const oldIndex = seen.findIndex((s) => (0, env_1.areSameEnv)(s, currEnv));
        if (oldIndex !== -1) {
            resolveDifferencesInBackground(oldIndex, currEnv, state, didUpdate, seen).ignoreErrors();
        }
        else {
            yield currEnv;
            seen.push(currEnv);
        }
        result = await iterator.next();
    }
    if (iterator.onUpdated === undefined) {
        state.done = true;
        checkIfFinishedAndNotify(state, didUpdate);
    }
}
async function resolveDifferencesInBackground(oldIndex, newEnv, state, didUpdate, seen) {
    state.pending += 1;
    const oldEnv = seen[oldIndex];
    const merged = resolveEnvCollision(oldEnv, newEnv);
    if (!(0, lodash_1.isEqual)(oldEnv, merged)) {
        seen[oldIndex] = merged;
        didUpdate.fire({ index: oldIndex, old: oldEnv, update: merged });
    }
    state.pending -= 1;
    checkIfFinishedAndNotify(state, didUpdate);
}
function checkIfFinishedAndNotify(state, didUpdate) {
    if (state.done && state.pending === 0) {
        didUpdate.fire({ stage: locator_1.ProgressReportStage.discoveryFinished });
        didUpdate.dispose();
        (0, logging_1.traceVerbose)(`Finished with environment reducer`);
    }
}
function resolveEnvCollision(oldEnv, newEnv) {
    var _a, _b;
    const [env] = sortEnvInfoByPriority(oldEnv, newEnv);
    const merged = (0, lodash_1.cloneDeep)(env);
    merged.source = (0, lodash_1.uniq)(((_a = oldEnv.source) !== null && _a !== void 0 ? _a : []).concat((_b = newEnv.source) !== null && _b !== void 0 ? _b : []));
    return merged;
}
function sortEnvInfoByPriority(...envs) {
    const envKindByPriority = (0, envKind_1.getPrioritizedEnvKinds)();
    return envs.sort((a, b) => envKindByPriority.indexOf(a.kind) - envKindByPriority.indexOf(b.kind));
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/composite/envsResolver.ts":
/*!*******************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/composite/envsResolver.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonEnvsResolver = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const environmentIdentifier_1 = __webpack_require__(/*! ../../../common/environmentIdentifier */ "./src/client/pythonEnvironments/common/environmentIdentifier.ts");
const env_1 = __webpack_require__(/*! ../../info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const locator_1 = __webpack_require__(/*! ../../locator */ "./src/client/pythonEnvironments/base/locator.ts");
const resolverUtils_1 = __webpack_require__(/*! ./resolverUtils */ "./src/client/pythonEnvironments/base/locators/composite/resolverUtils.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const pythonVersion_1 = __webpack_require__(/*! ../../info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
class PythonEnvsResolver {
    constructor(parentLocator, environmentInfoService) {
        this.parentLocator = parentLocator;
        this.environmentInfoService = environmentInfoService;
        this.parentLocator.onChanged((event) => {
            if (event.type && event.searchLocation !== undefined) {
                this.environmentInfoService.resetInfo(event.searchLocation);
            }
        });
    }
    get onChanged() {
        return this.parentLocator.onChanged;
    }
    async resolveEnv(path) {
        const [executablePath, envPath] = await getExecutablePathAndEnvPath(path);
        path = executablePath.length ? executablePath : envPath;
        const kind = await (0, environmentIdentifier_1.identifyEnvironment)(path);
        const environment = await (0, resolverUtils_1.resolveBasicEnv)({ kind, executablePath, envPath });
        const info = await this.environmentInfoService.getEnvironmentInfo(environment);
        (0, logging_1.traceVerbose)(`Environment resolver resolved ${path} for ${JSON.stringify(environment)} to ${JSON.stringify(info)}`);
        if (!info) {
            return undefined;
        }
        return getResolvedEnv(info, environment);
    }
    iterEnvs(query) {
        const didUpdate = new vscode_1.EventEmitter();
        const incomingIterator = this.parentLocator.iterEnvs(query);
        const iterator = this.iterEnvsIterator(incomingIterator, didUpdate);
        iterator.onUpdated = didUpdate.event;
        return iterator;
    }
    async *iterEnvsIterator(iterator, didUpdate) {
        const environmentKinds = new Map();
        const state = {
            done: false,
            pending: 0,
        };
        const seen = [];
        if (iterator.onUpdated !== undefined) {
            const listener = iterator.onUpdated(async (event) => {
                state.pending += 1;
                if ((0, locator_1.isProgressEvent)(event)) {
                    if (event.stage === locator_1.ProgressReportStage.discoveryFinished) {
                        didUpdate.fire({ stage: locator_1.ProgressReportStage.allPathsDiscovered });
                        state.done = true;
                        listener.dispose();
                    }
                    else {
                        didUpdate.fire(event);
                    }
                }
                else if (event.update === undefined) {
                    throw new Error('Unsupported behavior: `undefined` environment updates are not supported from downstream locators in resolver');
                }
                else if (seen[event.index] !== undefined) {
                    const old = seen[event.index];
                    await setKind(event.update, environmentKinds);
                    seen[event.index] = await (0, resolverUtils_1.resolveBasicEnv)(event.update);
                    didUpdate.fire({ old, index: event.index, update: seen[event.index] });
                    this.resolveInBackground(event.index, state, didUpdate, seen).ignoreErrors();
                }
                else {
                    (0, logging_1.traceVerbose)(`Expected already iterated env, got ${event.old} (#${event.index})`);
                }
                state.pending -= 1;
                checkIfFinishedAndNotify(state, didUpdate);
            });
        }
        else {
            didUpdate.fire({ stage: locator_1.ProgressReportStage.discoveryStarted });
        }
        let result = await iterator.next();
        while (!result.done) {
            await setKind(result.value, environmentKinds);
            const currEnv = await (0, resolverUtils_1.resolveBasicEnv)(result.value);
            seen.push(currEnv);
            yield currEnv;
            this.resolveInBackground(seen.indexOf(currEnv), state, didUpdate, seen).ignoreErrors();
            result = await iterator.next();
        }
        if (iterator.onUpdated === undefined) {
            state.done = true;
            checkIfFinishedAndNotify(state, didUpdate);
        }
    }
    async resolveInBackground(envIndex, state, didUpdate, seen) {
        state.pending += 1;
        const info = await this.environmentInfoService.getEnvironmentInfo(seen[envIndex]);
        const old = seen[envIndex];
        if (info) {
            const resolvedEnv = getResolvedEnv(info, seen[envIndex]);
            seen[envIndex] = resolvedEnv;
            didUpdate.fire({ old, index: envIndex, update: resolvedEnv });
        }
        else {
            didUpdate.fire({ old, index: envIndex, update: undefined });
        }
        state.pending -= 1;
        checkIfFinishedAndNotify(state, didUpdate);
    }
}
exports.PythonEnvsResolver = PythonEnvsResolver;
async function setKind(env, environmentKinds) {
    const { path } = (0, env_1.getEnvPath)(env.executablePath, env.envPath);
    let kind = environmentKinds.get(path);
    if (!kind) {
        kind = await (0, environmentIdentifier_1.identifyEnvironment)(path);
        environmentKinds.set(path, kind);
    }
    env.kind = kind;
}
function checkIfFinishedAndNotify(state, didUpdate) {
    if (state.done && state.pending === 0) {
        didUpdate.fire({ stage: locator_1.ProgressReportStage.discoveryFinished });
        didUpdate.dispose();
        (0, logging_1.traceVerbose)(`Finished with environment resolver`);
    }
}
function getResolvedEnv(interpreterInfo, environment) {
    const resolvedEnv = (0, lodash_1.cloneDeep)(environment);
    resolvedEnv.executable.sysPrefix = interpreterInfo.executable.sysPrefix;
    const isEnvLackingPython = (0, env_1.getEnvPath)(resolvedEnv.executable.filename, resolvedEnv.location).pathType === 'envFolderPath';
    if (isEnvLackingPython) {
        resolvedEnv.version = (0, pythonVersion_1.getEmptyVersion)();
    }
    else {
        resolvedEnv.version = interpreterInfo.version;
    }
    resolvedEnv.arch = interpreterInfo.arch;
    (0, env_1.setEnvDisplayString)(resolvedEnv);
    return resolvedEnv;
}
async function getExecutablePathAndEnvPath(path) {
    var _a;
    let executablePath;
    let envPath;
    const isPathAnExecutable = await (0, commonUtils_1.isPythonExecutable)(path).catch((ex) => {
        (0, logging_1.traceWarn)('Failed to check if', path, 'is an executable', ex);
        return true;
    });
    if (isPathAnExecutable) {
        executablePath = path;
        envPath = (0, commonUtils_1.getEnvironmentDirFromPath)(executablePath);
    }
    else {
        envPath = path;
        executablePath = (_a = (await (0, commonUtils_1.getInterpreterPathFromDir)(envPath))) !== null && _a !== void 0 ? _a : '';
    }
    return [executablePath, envPath];
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/composite/resolverUtils.ts":
/*!********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/composite/resolverUtils.ts ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.resolveBasicEnv = void 0;
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const env_1 = __webpack_require__(/*! ../../info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const conda_1 = __webpack_require__(/*! ../../../common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const pyenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
const platform_1 = __webpack_require__(/*! ../../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const pythonVersion_1 = __webpack_require__(/*! ../../info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const windowsUtils_1 = __webpack_require__(/*! ../../../common/windowsUtils */ "./src/client/pythonEnvironments/common/windowsUtils.ts");
const executable_1 = __webpack_require__(/*! ../../info/executable */ "./src/client/pythonEnvironments/base/info/executable.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ../../../common/environmentManagers/simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
const workspaceApis_1 = __webpack_require__(/*! ../../../../common/vscodeApis/workspaceApis */ "./src/client/common/vscodeApis/workspaceApis.ts");
const activestate_1 = __webpack_require__(/*! ../../../common/environmentManagers/activestate */ "./src/client/pythonEnvironments/common/environmentManagers/activestate.ts");
function getResolvers() {
    const resolvers = new Map();
    Object.values(info_1.PythonEnvKind).forEach((k) => {
        resolvers.set(k, resolveGloballyInstalledEnv);
    });
    info_1.virtualEnvKinds.forEach((k) => {
        resolvers.set(k, resolveSimpleEnv);
    });
    resolvers.set(info_1.PythonEnvKind.Conda, resolveCondaEnv);
    resolvers.set(info_1.PythonEnvKind.MicrosoftStore, resolveMicrosoftStoreEnv);
    resolvers.set(info_1.PythonEnvKind.Pyenv, resolvePyenvEnv);
    resolvers.set(info_1.PythonEnvKind.ActiveState, resolveActiveStateEnv);
    return resolvers;
}
async function resolveBasicEnv(env) {
    var _a;
    const { kind, source } = env;
    const resolvers = getResolvers();
    const resolverForKind = resolvers.get(kind);
    const resolvedEnv = await resolverForKind(env);
    resolvedEnv.searchLocation = getSearchLocation(resolvedEnv);
    resolvedEnv.source = (0, lodash_1.uniq)(resolvedEnv.source.concat(source !== null && source !== void 0 ? source : []));
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows && ((_a = resolvedEnv.source) === null || _a === void 0 ? void 0 : _a.includes(info_1.PythonEnvSource.WindowsRegistry))) {
        await updateEnvUsingRegistry(resolvedEnv);
    }
    (0, env_1.setEnvDisplayString)(resolvedEnv);
    const { ctime, mtime } = await (0, externalDependencies_1.getFileInfo)(resolvedEnv.executable.filename);
    resolvedEnv.executable.ctime = ctime;
    resolvedEnv.executable.mtime = mtime;
    const type = await getEnvType(resolvedEnv);
    if (type) {
        resolvedEnv.type = type;
    }
    return resolvedEnv;
}
exports.resolveBasicEnv = resolveBasicEnv;
async function getEnvType(env) {
    if (env.type) {
        return env.type;
    }
    if (await (0, simplevirtualenvs_1.isVirtualEnvironment)(env.executable.filename)) {
        return info_1.PythonEnvType.Virtual;
    }
    if (await (0, conda_1.isCondaEnvironment)(env.executable.filename)) {
        return info_1.PythonEnvType.Conda;
    }
    return undefined;
}
function getSearchLocation(env) {
    const folders = (0, workspaceApis_1.getWorkspaceFolderPaths)();
    const isRootedEnv = folders.some((f) => (0, externalDependencies_1.isParentPath)(env.executable.filename, f) || (0, externalDependencies_1.isParentPath)(env.location, f));
    if (isRootedEnv) {
        return vscode_1.Uri.file(env.location);
    }
    return undefined;
}
async function updateEnvUsingRegistry(env) {
    var _a, _b, _c;
    let interpreters = (0, windowsUtils_1.getRegistryInterpretersSync)();
    if (!interpreters) {
        (0, logging_1.traceError)('Expected registry interpreter cache to be initialized already');
        interpreters = await (0, windowsUtils_1.getRegistryInterpreters)();
    }
    const data = interpreters.find((i) => (0, externalDependencies_1.arePathsSame)(i.interpreterPath, env.executable.filename));
    if (data) {
        const versionStr = (_b = (_a = data.versionStr) !== null && _a !== void 0 ? _a : data.sysVersionStr) !== null && _b !== void 0 ? _b : data.interpreterPath;
        let version;
        try {
            version = (0, pythonVersion_1.parseVersion)(versionStr);
        }
        catch (ex) {
            version = info_1.UNKNOWN_PYTHON_VERSION;
        }
        env.kind = env.kind === info_1.PythonEnvKind.Unknown ? info_1.PythonEnvKind.OtherGlobal : env.kind;
        env.version = (0, env_1.comparePythonVersionSpecificity)(version, env.version) > 0 ? version : env.version;
        env.distro.defaultDisplayName = data.companyDisplayName;
        env.arch = data.bitnessStr === '32bit' ? platform_1.Architecture.x86 : platform_1.Architecture.x64;
        env.distro.org = (_c = data.distroOrgName) !== null && _c !== void 0 ? _c : env.distro.org;
        env.source = (0, lodash_1.uniq)(env.source.concat(info_1.PythonEnvSource.WindowsRegistry));
    }
    else {
        (0, logging_1.traceWarn)('Expected registry to find the interpreter as source was set');
    }
}
async function resolveGloballyInstalledEnv(env) {
    const { executablePath } = env;
    let version;
    try {
        version = (0, executable_1.parseVersionFromExecutable)(executablePath);
    }
    catch (_a) {
        version = info_1.UNKNOWN_PYTHON_VERSION;
    }
    const envInfo = (0, env_1.buildEnvInfo)({
        kind: env.kind,
        version,
        executable: executablePath,
    });
    return envInfo;
}
async function resolveSimpleEnv(env) {
    const { executablePath, kind } = env;
    const envInfo = (0, env_1.buildEnvInfo)({
        kind,
        version: await (0, commonUtils_1.getPythonVersionFromPath)(executablePath),
        executable: executablePath,
        type: info_1.PythonEnvType.Virtual,
    });
    const location = (0, commonUtils_1.getEnvironmentDirFromPath)(executablePath);
    envInfo.location = location;
    envInfo.name = path.basename(location);
    return envInfo;
}
async function resolveCondaEnv(env) {
    var _a;
    const { executablePath } = env;
    const conda = await conda_1.Conda.getConda();
    if (conda === undefined) {
        (0, logging_1.traceWarn)(`${executablePath} identified as Conda environment even though Conda is not found`);
        env.kind = info_1.PythonEnvKind.Unknown;
        const envInfo = await resolveSimpleEnv(env);
        envInfo.type = info_1.PythonEnvType.Conda;
        envInfo.name = '';
        return envInfo;
    }
    const envPath = (_a = env.envPath) !== null && _a !== void 0 ? _a : (0, commonUtils_1.getEnvironmentDirFromPath)(env.executablePath);
    let executable;
    if (env.executablePath.length > 0) {
        executable = env.executablePath;
    }
    else {
        executable = await conda.getInterpreterPathForEnvironment({ prefix: envPath });
    }
    const info = (0, env_1.buildEnvInfo)({
        executable,
        kind: info_1.PythonEnvKind.Conda,
        org: conda_1.AnacondaCompanyName,
        location: envPath,
        source: [],
        version: executable ? await (0, commonUtils_1.getPythonVersionFromPath)(executable) : undefined,
        type: info_1.PythonEnvType.Conda,
    });
    const name = await (conda === null || conda === void 0 ? void 0 : conda.getName(envPath));
    if (name) {
        info.name = name;
    }
    if (env.envPath && path.basename(executable) === executable) {
        const predictedExecutable = (0, conda_1.getCondaInterpreterPath)(env.envPath);
        info.id = (0, env_1.getEnvID)(predictedExecutable, env.envPath);
    }
    return info;
}
async function resolvePyenvEnv(env) {
    const { executablePath } = env;
    const location = (0, commonUtils_1.getEnvironmentDirFromPath)(executablePath);
    const name = path.basename(location);
    const versionStrings = (0, pyenv_1.parsePyenvVersion)(name);
    const envInfo = (0, env_1.buildEnvInfo)({
        kind: info_1.PythonEnvKind.Pyenv,
        executable: executablePath,
        source: [],
        location,
        version: await (0, commonUtils_1.getPythonVersionFromPath)(executablePath, versionStrings === null || versionStrings === void 0 ? void 0 : versionStrings.pythonVer),
        org: versionStrings && versionStrings.distro ? versionStrings.distro : '',
    });
    if (await isBaseCondaPyenvEnvironment(executablePath)) {
        envInfo.name = 'base';
    }
    else {
        envInfo.name = name;
    }
    return envInfo;
}
async function resolveActiveStateEnv(env) {
    const info = (0, env_1.buildEnvInfo)({
        kind: env.kind,
        executable: env.executablePath,
    });
    const projects = await activestate_1.ActiveState.getState().then((v) => v === null || v === void 0 ? void 0 : v.getProjects());
    if (projects) {
        for (const project of projects) {
            for (const dir of project.executables) {
                if ((0, externalDependencies_1.arePathsSame)(dir, path.dirname(env.executablePath))) {
                    info.name = `${project.organization}/${project.name}`;
                    return info;
                }
            }
        }
    }
    return info;
}
async function isBaseCondaPyenvEnvironment(executablePath) {
    if (!(await (0, conda_1.isCondaEnvironment)(executablePath))) {
        return false;
    }
    const location = (0, commonUtils_1.getEnvironmentDirFromPath)(executablePath);
    const pyenvVersionDir = (0, pyenv_1.getPyenvVersionsDir)();
    return (0, externalDependencies_1.arePathsSame)(path.dirname(location), pyenvVersionDir);
}
async function resolveMicrosoftStoreEnv(env) {
    const { executablePath } = env;
    return (0, env_1.buildEnvInfo)({
        kind: info_1.PythonEnvKind.MicrosoftStore,
        executable: executablePath,
        version: (0, pythonVersion_1.getPythonVersionFromPath)(executablePath),
        org: 'Microsoft',
        arch: platform_1.Architecture.x64,
        source: [info_1.PythonEnvSource.PathEnvVar],
    });
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/activeStateLocator.ts":
/*!************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/activeStateLocator.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ActiveStateLocator = void 0;
const activestate_1 = __webpack_require__(/*! ../../../common/environmentManagers/activestate */ "./src/client/pythonEnvironments/common/environmentManagers/activestate.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const resourceBasedLocator_1 = __webpack_require__(/*! ../common/resourceBasedLocator */ "./src/client/pythonEnvironments/base/locators/common/resourceBasedLocator.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
class ActiveStateLocator extends resourceBasedLocator_1.LazyResourceBasedLocator {
    constructor() {
        super(...arguments);
        this.providerId = 'activestate';
    }
    async *doIterEnvs() {
        const state = await activestate_1.ActiveState.getState();
        if (state === undefined) {
            (0, logging_1.traceVerbose)(`Couldn't locate the state binary.`);
            return;
        }
        (0, logging_1.traceVerbose)(`Searching for active state environments`);
        const projects = await state.getProjects();
        if (projects === undefined) {
            (0, logging_1.traceVerbose)(`Couldn't fetch State Tool projects.`);
            return;
        }
        for (const project of projects) {
            if (project.executables) {
                for (const dir of project.executables) {
                    try {
                        (0, logging_1.traceVerbose)(`Looking for Python in: ${project.name}`);
                        for await (const exe of (0, commonUtils_1.findInterpretersInDir)(dir)) {
                            (0, logging_1.traceVerbose)(`Found Python executable: ${exe.filename}`);
                            yield { kind: info_1.PythonEnvKind.ActiveState, executablePath: exe.filename };
                        }
                    }
                    catch (ex) {
                        (0, logging_1.traceError)(`Failed to process State Tool project: ${JSON.stringify(project)}`, ex);
                    }
                }
            }
        }
        (0, logging_1.traceVerbose)(`Finished searching for active state environments`);
    }
}
exports.ActiveStateLocator = ActiveStateLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/condaLocator.ts":
/*!******************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/condaLocator.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CondaEnvironmentLocator = void 0;
__webpack_require__(/*! ../../../../common/extensions */ "./src/client/common/extensions.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const conda_1 = __webpack_require__(/*! ../../../common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const fsWatchingLocator_1 = __webpack_require__(/*! ./fsWatchingLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts");
class CondaEnvironmentLocator extends fsWatchingLocator_1.FSWatchingLocator {
    constructor() {
        super(() => (0, conda_1.getCondaEnvironmentsTxt)(), async () => info_1.PythonEnvKind.Conda, { isFile: true });
        this.providerId = 'conda-envs';
    }
    async *doIterEnvs() {
        const conda = await conda_1.Conda.getConda();
        if (conda === undefined) {
            (0, logging_1.traceVerbose)(`Couldn't locate the conda binary.`);
            return;
        }
        (0, logging_1.traceVerbose)(`Searching for conda environments using ${conda.command}`);
        const envs = await conda.getEnvList();
        for (const env of envs) {
            try {
                (0, logging_1.traceVerbose)(`Looking into conda env for executable: ${JSON.stringify(env)}`);
                const executablePath = await conda.getInterpreterPathForEnvironment(env);
                (0, logging_1.traceVerbose)(`Found conda executable: ${executablePath}`);
                yield { kind: info_1.PythonEnvKind.Conda, executablePath, envPath: env.prefix };
            }
            catch (ex) {
                (0, logging_1.traceError)(`Failed to process conda env: ${JSON.stringify(env)}`, ex);
            }
        }
        (0, logging_1.traceVerbose)(`Finished searching for conda environments`);
    }
}
exports.CondaEnvironmentLocator = CondaEnvironmentLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/customVirtualEnvLocator.ts":
/*!*****************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/customVirtualEnvLocator.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomVirtualEnvironmentLocator = exports.VENVFOLDERS_SETTING_KEY = exports.VENVPATH_SETTING_KEY = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const path = __webpack_require__(/*! path */ "path");
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const platform_1 = __webpack_require__(/*! ../../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const fsWatchingLocator_1 = __webpack_require__(/*! ./fsWatchingLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const pipenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pipenv */ "./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ../../../common/environmentManagers/simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
__webpack_require__(/*! ../../../../common/extensions */ "./src/client/common/extensions.ts");
const arrayUtils_1 = __webpack_require__(/*! ../../../../common/utils/arrayUtils */ "./src/client/common/utils/arrayUtils.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const DEFAULT_SEARCH_DEPTH = 2;
exports.VENVPATH_SETTING_KEY = 'venvPath';
exports.VENVFOLDERS_SETTING_KEY = 'venvFolders';
async function getCustomVirtualEnvDirs() {
    var _a;
    const venvDirs = [];
    const venvPath = (0, externalDependencies_1.getPythonSetting)(exports.VENVPATH_SETTING_KEY);
    if (venvPath) {
        venvDirs.push((0, externalDependencies_1.untildify)(venvPath));
    }
    const venvFolders = (_a = (0, externalDependencies_1.getPythonSetting)(exports.VENVFOLDERS_SETTING_KEY)) !== null && _a !== void 0 ? _a : [];
    const homeDir = (0, platform_1.getUserHomeDir)();
    if (homeDir && (await (0, externalDependencies_1.pathExists)(homeDir))) {
        venvFolders.map((item) => path.join(homeDir, item)).forEach((d) => venvDirs.push(d));
    }
    return (0, arrayUtils_1.asyncFilter)((0, lodash_1.uniq)(venvDirs), externalDependencies_1.pathExists);
}
async function getVirtualEnvKind(interpreterPath) {
    if (await (0, pipenv_1.isPipenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Pipenv;
    }
    if (await (0, simplevirtualenvs_1.isVirtualenvwrapperEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.VirtualEnvWrapper;
    }
    if (await (0, simplevirtualenvs_1.isVenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Venv;
    }
    if (await (0, simplevirtualenvs_1.isVirtualenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.VirtualEnv;
    }
    return info_1.PythonEnvKind.Unknown;
}
class CustomVirtualEnvironmentLocator extends fsWatchingLocator_1.FSWatchingLocator {
    constructor() {
        super(getCustomVirtualEnvDirs, getVirtualEnvKind, {
            delayOnCreated: 1000,
        });
        this.providerId = 'custom-virtual-envs';
    }
    async initResources() {
        this.disposables.push((0, externalDependencies_1.onDidChangePythonSetting)(exports.VENVPATH_SETTING_KEY, () => this.emitter.fire({})));
        this.disposables.push((0, externalDependencies_1.onDidChangePythonSetting)(exports.VENVFOLDERS_SETTING_KEY, () => this.emitter.fire({})));
    }
    doIterEnvs() {
        async function* iterator() {
            const envRootDirs = await getCustomVirtualEnvDirs();
            const envGenerators = envRootDirs.map((envRootDir) => {
                async function* generator() {
                    (0, logging_1.traceVerbose)(`Searching for custom virtual envs in: ${envRootDir}`);
                    const executables = (0, commonUtils_1.findInterpretersInDir)(envRootDir, DEFAULT_SEARCH_DEPTH);
                    for await (const entry of executables) {
                        const { filename } = entry;
                        if (await (0, commonUtils_1.looksLikeBasicVirtualPython)(entry)) {
                            try {
                                const kind = await getVirtualEnvKind(filename);
                                yield { kind, executablePath: filename };
                                (0, logging_1.traceVerbose)(`Custom Virtual Environment: [added] ${filename}`);
                            }
                            catch (ex) {
                                (0, logging_1.traceError)(`Failed to process environment: ${filename}`, ex);
                            }
                        }
                        else {
                            (0, logging_1.traceVerbose)(`Custom Virtual Environment: [skipped] ${filename}`);
                        }
                    }
                }
                return generator();
            });
            yield* (0, async_1.iterable)((0, async_1.chain)(envGenerators));
            (0, logging_1.traceVerbose)(`Finished searching for custom virtual envs`);
        }
        return iterator();
    }
}
exports.CustomVirtualEnvironmentLocator = CustomVirtualEnvironmentLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/filesLocator.ts":
/*!******************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/filesLocator.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DirFilesLocator = void 0;
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const watcher_1 = __webpack_require__(/*! ../../watcher */ "./src/client/pythonEnvironments/base/watcher.ts");
class FoundFilesLocator {
    constructor(kind, getExecutables, source) {
        this.kind = kind;
        this.getExecutables = getExecutables;
        this.source = source;
        this.watcher = new watcher_1.PythonEnvsWatcher();
        this.onChanged = this.watcher.onChanged;
    }
    iterEnvs(_query) {
        const executables = this.getExecutables();
        async function* generator(kind, source) {
            for await (const executablePath of executables) {
                yield { executablePath, kind, source };
            }
        }
        const iterator = generator(this.kind, this.source);
        return iterator;
    }
}
class DirFilesLocator extends FoundFilesLocator {
    constructor(dirname, defaultKind, getExecutables = getExecutablesDefault, source) {
        super(defaultKind, () => getExecutables(dirname), source);
        this.providerId = `dir-files-${dirname}`;
    }
}
exports.DirFilesLocator = DirFilesLocator;
async function* getExecutablesDefault(dirname) {
    for await (const entry of (0, commonUtils_1.iterPythonExecutablesInDir)(dirname)) {
        yield entry.filename;
    }
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts":
/*!***********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FSWatchingLocator = exports.FSWatcherKind = void 0;
const fs = __webpack_require__(/*! fs */ "fs");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const fileSystemWatcher_1 = __webpack_require__(/*! ../../../../common/platform/fileSystemWatcher */ "./src/client/common/platform/fileSystemWatcher.ts");
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const pythonBinariesWatcher_1 = __webpack_require__(/*! ../../../common/pythonBinariesWatcher */ "./src/client/pythonEnvironments/common/pythonBinariesWatcher.ts");
const resourceBasedLocator_1 = __webpack_require__(/*! ../common/resourceBasedLocator */ "./src/client/pythonEnvironments/base/locators/common/resourceBasedLocator.ts");
var FSWatcherKind;
(function (FSWatcherKind) {
    FSWatcherKind[FSWatcherKind["Global"] = 0] = "Global";
    FSWatcherKind[FSWatcherKind["Workspace"] = 1] = "Workspace";
})(FSWatcherKind = exports.FSWatcherKind || (exports.FSWatcherKind = {}));
function checkDirWatchable(dirname) {
    let names;
    try {
        names = fs.readdirSync(dirname);
    }
    catch (err) {
        const exception = err;
        (0, logging_1.traceError)('Reading directory to watch failed', exception);
        if (exception.code === 'ENOENT') {
            return 'directory does not exist';
        }
        throw err;
    }
    if (names.length > 200) {
        return 'too many files';
    }
    return undefined;
}
class FSWatchingLocator extends resourceBasedLocator_1.LazyResourceBasedLocator {
    constructor(getRoots, getKind, creationOptions = {}, watcherKind = FSWatcherKind.Global) {
        super();
        this.getRoots = getRoots;
        this.getKind = getKind;
        this.creationOptions = creationOptions;
        this.watcherKind = watcherKind;
        this.activate().ignoreErrors();
    }
    async initWatchers() {
        if (this.watcherKind === FSWatcherKind.Global && !isWatchingAFile(this.creationOptions)) {
            return;
        }
        (0, logging_1.traceVerbose)('Getting roots');
        let roots = await this.getRoots();
        (0, logging_1.traceVerbose)('Found roots');
        if (typeof roots === 'string') {
            roots = [roots];
        }
        const promises = roots.map(async (root) => {
            if (isWatchingAFile(this.creationOptions)) {
                return root;
            }
            const unwatchable = await checkDirWatchable(root);
            if (unwatchable) {
                (0, logging_1.traceError)(`Dir "${root}" is not watchable (${unwatchable})`);
                return undefined;
            }
            return root;
        });
        const watchableRoots = (await Promise.all(promises)).filter((root) => !!root);
        watchableRoots.forEach((root) => this.startWatchers(root));
    }
    startWatchers(root) {
        const opts = this.creationOptions;
        if (isWatchingAFile(opts)) {
            (0, logging_1.traceVerbose)('Start watching file for changes', root);
            this.disposables.push((0, fileSystemWatcher_1.watchLocationForPattern)(path.dirname(root), path.basename(root), () => {
                (0, logging_1.traceVerbose)('Detected change in file: ', root, 'initiating a refresh');
                this.emitter.fire({ providerId: this.providerId });
            }));
            return;
        }
        const callback = async (type, executable) => {
            var _a;
            if (type === fileSystemWatcher_1.FileChangeType.Created) {
                if (opts.delayOnCreated !== undefined) {
                    await (0, async_1.sleep)(opts.delayOnCreated);
                }
            }
            const kind = await this.getKind(executable).catch(() => undefined);
            const searchLocation = vscode_1.Uri.file((_a = opts.searchLocation) !== null && _a !== void 0 ? _a : path.dirname((0, commonUtils_1.getEnvironmentDirFromPath)(executable)));
            (0, logging_1.traceVerbose)('Fired event ', JSON.stringify({ type, kind, searchLocation }), 'from locator');
            this.emitter.fire({ type, kind, searchLocation, providerId: this.providerId, envPath: executable });
        };
        const globs = (0, pythonBinariesWatcher_1.resolvePythonExeGlobs)(opts.baseGlob, opts.envStructure);
        (0, logging_1.traceVerbose)('Start watching root', root, 'for globs', JSON.stringify(globs));
        const watchers = globs.map((g) => (0, pythonBinariesWatcher_1.watchLocationForPythonBinaries)(root, callback, g));
        this.disposables.push(...watchers);
    }
}
exports.FSWatchingLocator = FSWatchingLocator;
function isWatchingAFile(options) {
    return 'isFile' in options && options.isFile;
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/globalVirtualEnvronmentLocator.ts":
/*!************************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/globalVirtualEnvronmentLocator.ts ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobalVirtualEnvironmentLocator = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const path = __webpack_require__(/*! path */ "path");
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const platform_1 = __webpack_require__(/*! ../../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const fsWatchingLocator_1 = __webpack_require__(/*! ./fsWatchingLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const pipenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pipenv */ "./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ../../../common/environmentManagers/simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
__webpack_require__(/*! ../../../../common/extensions */ "./src/client/common/extensions.ts");
const arrayUtils_1 = __webpack_require__(/*! ../../../../common/utils/arrayUtils */ "./src/client/common/utils/arrayUtils.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const DEFAULT_SEARCH_DEPTH = 2;
async function getGlobalVirtualEnvDirs() {
    const venvDirs = [];
    let workOnHome = (0, platform_1.getEnvironmentVariable)('WORKON_HOME');
    if (workOnHome) {
        workOnHome = (0, externalDependencies_1.untildify)(workOnHome);
        if (await (0, externalDependencies_1.pathExists)(workOnHome)) {
            venvDirs.push(workOnHome);
        }
    }
    const homeDir = (0, platform_1.getUserHomeDir)();
    if (homeDir && (await (0, externalDependencies_1.pathExists)(homeDir))) {
        const subDirs = ['Envs', '.direnv', '.venvs', '.virtualenvs', path.join('.local', 'share', 'virtualenvs')];
        if ((0, platform_1.getOSType)() !== platform_1.OSType.Windows) {
            subDirs.push('envs');
        }
        const filtered = await (0, arrayUtils_1.asyncFilter)(subDirs.map((d) => path.join(homeDir, d)), externalDependencies_1.pathExists);
        filtered.forEach((d) => venvDirs.push(d));
    }
    return (0, lodash_1.uniq)(venvDirs);
}
async function getVirtualEnvKind(interpreterPath) {
    if (await (0, pipenv_1.isPipenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Pipenv;
    }
    if (await (0, simplevirtualenvs_1.isVirtualenvwrapperEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.VirtualEnvWrapper;
    }
    if (await (0, simplevirtualenvs_1.isVenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Venv;
    }
    if (await (0, simplevirtualenvs_1.isVirtualenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.VirtualEnv;
    }
    return info_1.PythonEnvKind.Unknown;
}
class GlobalVirtualEnvironmentLocator extends fsWatchingLocator_1.FSWatchingLocator {
    constructor(searchDepth) {
        super(getGlobalVirtualEnvDirs, getVirtualEnvKind, {
            delayOnCreated: 1000,
        });
        this.searchDepth = searchDepth;
        this.providerId = 'global-virtual-env';
    }
    doIterEnvs() {
        var _a;
        const searchDepth = (_a = this.searchDepth) !== null && _a !== void 0 ? _a : DEFAULT_SEARCH_DEPTH;
        async function* iterator() {
            const envRootDirs = await getGlobalVirtualEnvDirs();
            const envGenerators = envRootDirs.map((envRootDir) => {
                async function* generator() {
                    (0, logging_1.traceVerbose)(`Searching for global virtual envs in: ${envRootDir}`);
                    const executables = (0, commonUtils_1.findInterpretersInDir)(envRootDir, searchDepth);
                    for await (const entry of executables) {
                        const { filename } = entry;
                        if (await (0, commonUtils_1.looksLikeBasicVirtualPython)(entry)) {
                            const kind = await getVirtualEnvKind(filename);
                            try {
                                yield { kind, executablePath: filename };
                                (0, logging_1.traceVerbose)(`Global Virtual Environment: [added] ${filename}`);
                            }
                            catch (ex) {
                                (0, logging_1.traceError)(`Failed to process environment: ${filename}`, ex);
                            }
                        }
                        else {
                            (0, logging_1.traceVerbose)(`Global Virtual Environment: [skipped] ${filename}`);
                        }
                    }
                }
                return generator();
            });
            yield* (0, async_1.iterable)((0, async_1.chain)(envGenerators));
            (0, logging_1.traceVerbose)(`Finished searching for global virtual envs`);
        }
        return iterator();
    }
}
exports.GlobalVirtualEnvironmentLocator = GlobalVirtualEnvironmentLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/microsoftStoreLocator.ts":
/*!***************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/microsoftStoreLocator.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MicrosoftStoreLocator = exports.getMicrosoftStorePythonExes = void 0;
const fsapi = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const minimatch = __webpack_require__(/*! minimatch */ "./node_modules/minimatch/minimatch.js");
const path = __webpack_require__(/*! path */ "path");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const fsWatchingLocator_1 = __webpack_require__(/*! ./fsWatchingLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts");
const pythonBinariesWatcher_1 = __webpack_require__(/*! ../../../common/pythonBinariesWatcher */ "./src/client/pythonEnvironments/common/pythonBinariesWatcher.ts");
const microsoftStoreEnv_1 = __webpack_require__(/*! ../../../common/environmentManagers/microsoftStoreEnv */ "./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const pythonExeGlob = 'python3.{[0-9],[0-9][0-9]}.exe';
function isMicrosoftStorePythonExePattern(interpreterPath) {
    return minimatch(path.basename(interpreterPath), pythonExeGlob, { nocase: true });
}
async function getMicrosoftStorePythonExes() {
    if (await (0, microsoftStoreEnv_1.isStorePythonInstalled)()) {
        const windowsAppsRoot = (0, microsoftStoreEnv_1.getMicrosoftStoreAppsRoot)();
        const files = await fsapi.readdir(windowsAppsRoot);
        return files
            .map((filename) => path.join(windowsAppsRoot, filename))
            .filter(isMicrosoftStorePythonExePattern);
    }
    return [];
}
exports.getMicrosoftStorePythonExes = getMicrosoftStorePythonExes;
class MicrosoftStoreLocator extends fsWatchingLocator_1.FSWatchingLocator {
    constructor() {
        super(microsoftStoreEnv_1.getMicrosoftStoreAppsRoot, async () => this.kind, {
            baseGlob: pythonExeGlob,
            searchLocation: (0, microsoftStoreEnv_1.getMicrosoftStoreAppsRoot)(),
            envStructure: pythonBinariesWatcher_1.PythonEnvStructure.Flat,
        });
        this.providerId = 'microsoft-store';
        this.kind = info_1.PythonEnvKind.MicrosoftStore;
    }
    doIterEnvs() {
        const iterator = async function* (kind) {
            (0, logging_1.traceVerbose)('Searching for windows store envs');
            const exes = await getMicrosoftStorePythonExes();
            yield* exes.map(async (executablePath) => ({
                kind,
                executablePath,
            }));
            (0, logging_1.traceVerbose)(`Finished searching for windows store envs`);
        };
        return iterator(this.kind);
    }
}
exports.MicrosoftStoreLocator = MicrosoftStoreLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/poetryLocator.ts":
/*!*******************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/poetryLocator.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PoetryLocator = void 0;
const path = __webpack_require__(/*! path */ "path");
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const poetry_1 = __webpack_require__(/*! ../../../common/environmentManagers/poetry */ "./src/client/pythonEnvironments/common/environmentManagers/poetry.ts");
__webpack_require__(/*! ../../../../common/extensions */ "./src/client/common/extensions.ts");
const arrayUtils_1 = __webpack_require__(/*! ../../../../common/utils/arrayUtils */ "./src/client/common/utils/arrayUtils.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const resourceBasedLocator_1 = __webpack_require__(/*! ../common/resourceBasedLocator */ "./src/client/pythonEnvironments/base/locators/common/resourceBasedLocator.ts");
async function getVirtualEnvDirs(root) {
    const envDirs = [path.join(root, poetry_1.localPoetryEnvDirName)];
    const poetry = await poetry_1.Poetry.getPoetry(root);
    const virtualenvs = await (poetry === null || poetry === void 0 ? void 0 : poetry.getEnvList());
    if (virtualenvs) {
        envDirs.push(...virtualenvs);
    }
    return (0, arrayUtils_1.asyncFilter)(envDirs, externalDependencies_1.pathExists);
}
async function getVirtualEnvKind(interpreterPath) {
    if (await (0, poetry_1.isPoetryEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Poetry;
    }
    return info_1.PythonEnvKind.Unknown;
}
class PoetryLocator extends resourceBasedLocator_1.LazyResourceBasedLocator {
    constructor(root) {
        super();
        this.root = root;
        this.providerId = 'poetry';
    }
    doIterEnvs() {
        async function* iterator(root) {
            const envDirs = await getVirtualEnvDirs(root);
            const envGenerators = envDirs.map((envDir) => {
                async function* generator() {
                    (0, logging_1.traceVerbose)(`Searching for poetry virtual envs in: ${envDir}`);
                    const filename = await (0, commonUtils_1.getInterpreterPathFromDir)(envDir);
                    if (filename !== undefined) {
                        const kind = await getVirtualEnvKind(filename);
                        try {
                            yield { executablePath: filename, kind };
                            (0, logging_1.traceVerbose)(`Poetry Virtual Environment: [added] ${filename}`);
                        }
                        catch (ex) {
                            (0, logging_1.traceError)(`Failed to process environment: ${filename}`, ex);
                        }
                    }
                }
                return generator();
            });
            yield* (0, async_1.iterable)((0, async_1.chain)(envGenerators));
            (0, logging_1.traceVerbose)(`Finished searching for poetry envs`);
        }
        return iterator(this.root);
    }
}
exports.PoetryLocator = PoetryLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/posixKnownPathsLocator.ts":
/*!****************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/posixKnownPathsLocator.ts ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PosixKnownPathsLocator = void 0;
const os = __webpack_require__(/*! os */ "os");
const semver_1 = __webpack_require__(/*! semver */ "./node_modules/semver/semver.js");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const locator_1 = __webpack_require__(/*! ../../locator */ "./src/client/pythonEnvironments/base/locator.ts");
const posixUtils_1 = __webpack_require__(/*! ../../../common/posixUtils */ "./src/client/pythonEnvironments/common/posixUtils.ts");
const pyenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
const platform_1 = __webpack_require__(/*! ../../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const macDefault_1 = __webpack_require__(/*! ../../../common/environmentManagers/macDefault */ "./src/client/pythonEnvironments/common/environmentManagers/macDefault.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
class PosixKnownPathsLocator extends locator_1.Locator {
    constructor() {
        super(...arguments);
        this.providerId = 'posixKnownPaths';
        this.kind = info_1.PythonEnvKind.OtherGlobal;
    }
    iterEnvs() {
        let isMacPython2Deprecated = false;
        if ((0, platform_1.getOSType)() === platform_1.OSType.OSX && (0, semver_1.gte)(os.release(), '21.0.0')) {
            isMacPython2Deprecated = true;
        }
        const iterator = async function* (kind) {
            (0, logging_1.traceVerbose)('Searching for interpreters in posix paths locator');
            try {
                const knownDirs = (await (0, posixUtils_1.commonPosixBinPaths)()).filter((dirname) => !(0, pyenv_1.isPyenvShimDir)(dirname));
                let pythonBinaries = await (0, posixUtils_1.getPythonBinFromPosixPaths)(knownDirs);
                (0, logging_1.traceVerbose)(`Found ${pythonBinaries.length} python binaries in posix paths`);
                if (isMacPython2Deprecated) {
                    pythonBinaries = pythonBinaries.filter((binary) => !(0, macDefault_1.isMacDefaultPythonPath)(binary));
                }
                for (const bin of pythonBinaries) {
                    try {
                        yield { executablePath: bin, kind, source: [info_1.PythonEnvSource.PathEnvVar] };
                    }
                    catch (ex) {
                        (0, logging_1.traceError)(`Failed to process environment: ${bin}`, ex);
                    }
                }
            }
            catch (ex) {
                (0, logging_1.traceError)('Failed to process posix paths', ex);
            }
            (0, logging_1.traceVerbose)('Finished searching for interpreters in posix paths locator');
        };
        return iterator(this.kind);
    }
}
exports.PosixKnownPathsLocator = PosixKnownPathsLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/pyenvLocator.ts":
/*!******************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/pyenvLocator.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PyenvLocator = void 0;
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const fsWatchingLocator_1 = __webpack_require__(/*! ./fsWatchingLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const pyenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
async function* getPyenvEnvironments() {
    (0, logging_1.traceVerbose)('Searching for pyenv environments');
    const pyenvVersionDir = (0, pyenv_1.getPyenvVersionsDir)();
    const subDirs = (0, externalDependencies_1.getSubDirs)(pyenvVersionDir, { resolveSymlinks: true });
    for await (const subDirPath of subDirs) {
        const interpreterPath = await (0, commonUtils_1.getInterpreterPathFromDir)(subDirPath);
        if (interpreterPath) {
            try {
                yield {
                    kind: info_1.PythonEnvKind.Pyenv,
                    executablePath: interpreterPath,
                };
            }
            catch (ex) {
                (0, logging_1.traceError)(`Failed to process environment: ${interpreterPath}`, ex);
            }
        }
    }
    (0, logging_1.traceVerbose)('Finished searching for pyenv environments');
}
class PyenvLocator extends fsWatchingLocator_1.FSWatchingLocator {
    constructor() {
        super(pyenv_1.getPyenvVersionsDir, async () => info_1.PythonEnvKind.Pyenv);
        this.providerId = 'pyenv';
    }
    doIterEnvs() {
        return getPyenvEnvironments();
    }
}
exports.PyenvLocator = PyenvLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/windowsKnownPathsLocator.ts":
/*!******************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/windowsKnownPathsLocator.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WindowsPathEnvVarLocator = void 0;
const exec_1 = __webpack_require__(/*! ../../../../common/utils/exec */ "./src/client/common/utils/exec.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../../../common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const pyenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
const microsoftStoreEnv_1 = __webpack_require__(/*! ../../../common/environmentManagers/microsoftStoreEnv */ "./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const locators_1 = __webpack_require__(/*! ../../locators */ "./src/client/pythonEnvironments/base/locators.ts");
const locatorUtils_1 = __webpack_require__(/*! ../../locatorUtils */ "./src/client/pythonEnvironments/base/locatorUtils.ts");
const filesLocator_1 = __webpack_require__(/*! ./filesLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/filesLocator.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
class WindowsPathEnvVarLocator {
    constructor() {
        this.providerId = 'windows-path-env-var-locator';
        this.disposables = new resourceLifecycle_1.Disposables();
        const dirLocators = (0, exec_1.getSearchPathEntries)()
            .filter((dirname) => !(0, microsoftStoreEnv_1.isMicrosoftStoreDir)(dirname) && !(0, pyenv_1.isPyenvShimDir)(dirname))
            .map((dirname) => getDirFilesLocator(dirname, info_1.PythonEnvKind.System, [info_1.PythonEnvSource.PathEnvVar]));
        this.disposables.push(...dirLocators);
        this.locators = new locators_1.Locators(dirLocators);
        this.onChanged = this.locators.onChanged;
    }
    async dispose() {
        this.locators.dispose();
        await this.disposables.dispose();
    }
    iterEnvs(query) {
        return this.locators.iterEnvs(query);
    }
}
exports.WindowsPathEnvVarLocator = WindowsPathEnvVarLocator;
async function* getExecutables(dirname) {
    for await (const entry of (0, commonUtils_1.iterPythonExecutablesInDir)(dirname)) {
        if (await (0, commonUtils_1.looksLikeBasicGlobalPython)(entry)) {
            yield entry.filename;
        }
    }
}
function getDirFilesLocator(dirname, kind, source) {
    const locator = new filesLocator_1.DirFilesLocator(dirname, kind, getExecutables, source);
    const dispose = async () => undefined;
    async function* iterEnvs(query) {
        (0, logging_1.traceVerbose)('Searching for windows path interpreters');
        yield* await (0, locatorUtils_1.getEnvs)(locator.iterEnvs(query)).then((res) => {
            (0, logging_1.traceVerbose)('Finished searching for windows path interpreters');
            return res;
        });
    }
    return {
        providerId: locator.providerId,
        iterEnvs,
        dispose,
        onChanged: locator.onChanged,
    };
}


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/windowsRegistryLocator.ts":
/*!****************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/windowsRegistryLocator.ts ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WindowsRegistryLocator = void 0;
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const locator_1 = __webpack_require__(/*! ../../locator */ "./src/client/pythonEnvironments/base/locator.ts");
const windowsUtils_1 = __webpack_require__(/*! ../../../common/windowsUtils */ "./src/client/pythonEnvironments/common/windowsUtils.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const microsoftStoreEnv_1 = __webpack_require__(/*! ../../../common/environmentManagers/microsoftStoreEnv */ "./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts");
class WindowsRegistryLocator extends locator_1.Locator {
    constructor() {
        super(...arguments);
        this.providerId = 'windows-registry';
    }
    iterEnvs() {
        const iterator = async function* () {
            (0, logging_1.traceVerbose)('Searching for windows registry interpreters');
            const interpreters = await (0, windowsUtils_1.getRegistryInterpreters)();
            for (const interpreter of interpreters) {
                try {
                    if ((0, microsoftStoreEnv_1.isMicrosoftStoreDir)(interpreter.interpreterPath)) {
                        continue;
                    }
                    const env = {
                        kind: info_1.PythonEnvKind.OtherGlobal,
                        executablePath: interpreter.interpreterPath,
                        source: [info_1.PythonEnvSource.WindowsRegistry],
                    };
                    yield env;
                }
                catch (ex) {
                    (0, logging_1.traceError)(`Failed to process environment: ${interpreter}`, ex);
                }
            }
            (0, logging_1.traceVerbose)('Finished searching for windows registry interpreters');
        };
        return iterator();
    }
}
exports.WindowsRegistryLocator = WindowsRegistryLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/lowLevel/workspaceVirtualEnvLocator.ts":
/*!********************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/lowLevel/workspaceVirtualEnvLocator.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceVirtualEnvironmentLocator = void 0;
const path = __webpack_require__(/*! path */ "path");
const async_1 = __webpack_require__(/*! ../../../../common/utils/async */ "./src/client/common/utils/async.ts");
const commonUtils_1 = __webpack_require__(/*! ../../../common/commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../../common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const pipenv_1 = __webpack_require__(/*! ../../../common/environmentManagers/pipenv */ "./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ../../../common/environmentManagers/simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/base/info/index.ts");
const fsWatchingLocator_1 = __webpack_require__(/*! ./fsWatchingLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/fsWatchingLocator.ts");
__webpack_require__(/*! ../../../../common/extensions */ "./src/client/common/extensions.ts");
const arrayUtils_1 = __webpack_require__(/*! ../../../../common/utils/arrayUtils */ "./src/client/common/utils/arrayUtils.ts");
const logging_1 = __webpack_require__(/*! ../../../../logging */ "./src/client/logging/index.ts");
const DEFAULT_SEARCH_DEPTH = 2;
function getWorkspaceVirtualEnvDirs(root) {
    return (0, arrayUtils_1.asyncFilter)([root, path.join(root, '.direnv')], externalDependencies_1.pathExists);
}
async function getVirtualEnvKind(interpreterPath) {
    if (await (0, pipenv_1.isPipenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Pipenv;
    }
    if (await (0, simplevirtualenvs_1.isVenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.Venv;
    }
    if (await (0, simplevirtualenvs_1.isVirtualenvEnvironment)(interpreterPath)) {
        return info_1.PythonEnvKind.VirtualEnv;
    }
    return info_1.PythonEnvKind.Unknown;
}
class WorkspaceVirtualEnvironmentLocator extends fsWatchingLocator_1.FSWatchingLocator {
    constructor(root) {
        super(() => getWorkspaceVirtualEnvDirs(this.root), getVirtualEnvKind, {
            delayOnCreated: 1000,
        }, fsWatchingLocator_1.FSWatcherKind.Workspace);
        this.root = root;
        this.providerId = 'workspaceVirtualEnvLocator';
    }
    doIterEnvs() {
        async function* iterator(root) {
            const envRootDirs = await getWorkspaceVirtualEnvDirs(root);
            const envGenerators = envRootDirs.map((envRootDir) => {
                async function* generator() {
                    (0, logging_1.traceVerbose)(`Searching for workspace virtual envs in: ${envRootDir}`);
                    const executables = (0, commonUtils_1.findInterpretersInDir)(envRootDir, DEFAULT_SEARCH_DEPTH);
                    for await (const entry of executables) {
                        const { filename } = entry;
                        if (await (0, commonUtils_1.looksLikeBasicVirtualPython)(entry)) {
                            const kind = await getVirtualEnvKind(filename);
                            yield { kind, executablePath: filename };
                            (0, logging_1.traceVerbose)(`Workspace Virtual Environment: [added] ${filename}`);
                        }
                        else {
                            (0, logging_1.traceVerbose)(`Workspace Virtual Environment: [skipped] ${filename}`);
                        }
                    }
                }
                return generator();
            });
            yield* (0, async_1.iterable)((0, async_1.chain)(envGenerators));
            (0, logging_1.traceVerbose)(`Finished searching for workspace virtual envs`);
        }
        return iterator(this.root);
    }
}
exports.WorkspaceVirtualEnvironmentLocator = WorkspaceVirtualEnvironmentLocator;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/locators/wrappers.ts":
/*!*****************************************************************!*\
  !*** ./src/client/pythonEnvironments/base/locators/wrappers.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceLocators = exports.ExtensionLocators = void 0;
const async_1 = __webpack_require__(/*! ../../../common/utils/async */ "./src/client/common/utils/async.ts");
const misc_1 = __webpack_require__(/*! ../../../common/utils/misc */ "./src/client/common/utils/misc.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../../common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const locators_1 = __webpack_require__(/*! ../locators */ "./src/client/pythonEnvironments/base/locators.ts");
const resourceBasedLocator_1 = __webpack_require__(/*! ./common/resourceBasedLocator */ "./src/client/pythonEnvironments/base/locators/common/resourceBasedLocator.ts");
class ExtensionLocators extends locators_1.Locators {
    constructor(nonWorkspace, workspace) {
        super([...nonWorkspace, workspace]);
        this.nonWorkspace = nonWorkspace;
        this.workspace = workspace;
    }
    iterEnvs(query) {
        var _a;
        const iterators = [this.workspace.iterEnvs(query)];
        if (!((_a = query === null || query === void 0 ? void 0 : query.searchLocations) === null || _a === void 0 ? void 0 : _a.doNotIncludeNonRooted)) {
            const nonWorkspace = (query === null || query === void 0 ? void 0 : query.providerId)
                ? this.nonWorkspace.filter((locator) => query.providerId === locator.providerId)
                : this.nonWorkspace;
            iterators.push(...nonWorkspace.map((loc) => loc.iterEnvs(query)));
        }
        return (0, locators_1.combineIterators)(iterators);
    }
}
exports.ExtensionLocators = ExtensionLocators;
class WorkspaceLocators extends resourceBasedLocator_1.LazyResourceBasedLocator {
    constructor(watchRoots, factories) {
        super();
        this.watchRoots = watchRoots;
        this.factories = factories;
        this.providerId = 'workspace-locators';
        this.locators = {};
        this.roots = {};
        this.activate().ignoreErrors();
    }
    async dispose() {
        await super.dispose();
        const roots = Object.keys(this.roots).map((key) => this.roots[key]);
        roots.forEach((root) => this.removeRoot(root));
    }
    doIterEnvs(query) {
        const iterators = Object.keys(this.locators).map((key) => {
            if ((query === null || query === void 0 ? void 0 : query.searchLocations) !== undefined) {
                const root = this.roots[key];
                const filter = (0, misc_1.getURIFilter)(root, { checkParent: true, checkChild: true });
                if (!query.searchLocations.roots.some(filter)) {
                    return (0, async_1.iterEmpty)();
                }
                if (query.providerId && query.providerId !== this.providerId) {
                    return (0, async_1.iterEmpty)();
                }
            }
            const [locator] = this.locators[key];
            return locator.iterEnvs(query);
        });
        return (0, locators_1.combineIterators)(iterators);
    }
    async initResources() {
        const disposable = this.watchRoots({
            initRoot: (root) => this.addRoot(root),
            addRoot: (root) => {
                this.removeRoot(root);
                this.addRoot(root);
                this.emitter.fire({ searchLocation: root });
            },
            removeRoot: (root) => {
                this.removeRoot(root);
                this.emitter.fire({ searchLocation: root });
            },
        });
        this.disposables.push(disposable);
    }
    addRoot(root) {
        const locators = [];
        const disposables = new resourceLifecycle_1.Disposables();
        this.factories.forEach((create) => {
            create(root).forEach((loc) => {
                locators.push(loc);
                if (loc.dispose !== undefined) {
                    disposables.push(loc);
                }
            });
        });
        const locator = new locators_1.Locators(locators);
        const key = root.toString();
        this.locators[key] = [locator, disposables];
        this.roots[key] = root;
        disposables.push(locator.onChanged((e) => {
            if (e.searchLocation === undefined) {
                e.searchLocation = root;
            }
            this.emitter.fire(e);
        }));
    }
    removeRoot(root) {
        const key = root.toString();
        const found = this.locators[key];
        if (found === undefined) {
            return;
        }
        const [, disposables] = found;
        delete this.locators[key];
        delete this.roots[key];
        disposables.dispose();
    }
}
exports.WorkspaceLocators = WorkspaceLocators;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/watcher.ts":
/*!*******************************************************!*\
  !*** ./src/client/pythonEnvironments/base/watcher.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonEnvsWatcher = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
class PythonEnvsWatcher {
    constructor() {
        this.didChange = new vscode_1.EventEmitter();
        this.onChanged = this.didChange.event;
    }
    fire(event) {
        this.didChange.fire(event);
    }
}
exports.PythonEnvsWatcher = PythonEnvsWatcher;


/***/ }),

/***/ "./src/client/pythonEnvironments/base/watchers.ts":
/*!********************************************************!*\
  !*** ./src/client/pythonEnvironments/base/watchers.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonEnvsWatchers = void 0;
const resourceLifecycle_1 = __webpack_require__(/*! ../../common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const watcher_1 = __webpack_require__(/*! ./watcher */ "./src/client/pythonEnvironments/base/watcher.ts");
class PythonEnvsWatchers {
    constructor(watchers) {
        this.watcher = new watcher_1.PythonEnvsWatcher();
        this.disposables = new resourceLifecycle_1.Disposables();
        this.onChanged = this.watcher.onChanged;
        watchers.forEach((w) => {
            const disposable = w.onChanged((e) => this.watcher.fire(e));
            this.disposables.push(disposable);
        });
    }
    async dispose() {
        await this.disposables.dispose();
    }
}
exports.PythonEnvsWatchers = PythonEnvsWatchers;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/commonUtils.ts":
/*!*************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/commonUtils.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnvironmentDirFromPath = exports.getInterpreterPathFromDir = exports.looksLikeBasicVirtualPython = exports.looksLikeBasicGlobalPython = exports.getPythonVersionFromPath = exports.iterPythonExecutablesInDir = exports.findInterpretersInDir = exports.isPythonExecutable = void 0;
const fs = __webpack_require__(/*! fs */ "fs");
const path = __webpack_require__(/*! path */ "path");
const filesystem_1 = __webpack_require__(/*! ../../common/utils/filesystem */ "./src/client/common/utils/filesystem.ts");
const platform_1 = __webpack_require__(/*! ../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../base/info */ "./src/client/pythonEnvironments/base/info/index.ts");
const env_1 = __webpack_require__(/*! ../base/info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const pythonVersion_1 = __webpack_require__(/*! ../base/info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const conda_1 = __webpack_require__(/*! ./environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ./environmentManagers/simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
const externalDependencies_1 = __webpack_require__(/*! ./externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const posix = __webpack_require__(/*! ./posixUtils */ "./src/client/pythonEnvironments/common/posixUtils.ts");
const windows = __webpack_require__(/*! ./windowsUtils */ "./src/client/pythonEnvironments/common/windowsUtils.ts");
const matchStandardPythonBinFilename = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? windows.matchPythonBinFilename : posix.matchPythonBinFilename;
async function isPythonExecutable(filePath) {
    const isMatch = matchStandardPythonBinFilename(filePath);
    if (isMatch && (0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        return true;
    }
    if (await (0, externalDependencies_1.isFile)(filePath)) {
        return true;
    }
    return false;
}
exports.isPythonExecutable = isPythonExecutable;
async function* findInterpretersInDir(root, recurseLevel, filterSubDir, ignoreErrors = true) {
    const checkBin = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? windows.matchPythonBinFilename : posix.matchPythonBinFilename;
    const cfg = {
        ignoreErrors,
        filterSubDir,
        filterFile: checkBin,
        maxDepth: recurseLevel || 0,
    };
    for await (const entry of walkSubTree(root, 1, cfg)) {
        const { filename, filetype } = entry;
        if (filetype === filesystem_1.FileType.File || filetype === filesystem_1.FileType.SymbolicLink) {
            if (matchFile(filename, checkBin, ignoreErrors)) {
                yield entry;
            }
        }
    }
}
exports.findInterpretersInDir = findInterpretersInDir;
async function* iterPythonExecutablesInDir(dirname, opts = { ignoreErrors: true }) {
    const readDirOpts = {
        ...opts,
        filterFile: matchStandardPythonBinFilename,
    };
    const entries = await readDirEntries(dirname, readDirOpts);
    for (const entry of entries) {
        const { filetype } = entry;
        if (filetype === filesystem_1.FileType.File || filetype === filesystem_1.FileType.SymbolicLink) {
            yield entry;
        }
    }
}
exports.iterPythonExecutablesInDir = iterPythonExecutablesInDir;
async function* walkSubTree(subRoot, currentDepth, cfg) {
    const entries = await readDirEntries(subRoot, cfg);
    for (const entry of entries) {
        yield entry;
        const { filename, filetype } = entry;
        if (filetype === filesystem_1.FileType.Directory) {
            if (cfg.maxDepth < 0 || currentDepth <= cfg.maxDepth) {
                if (matchFile(filename, cfg.filterSubDir, cfg.ignoreErrors)) {
                    yield* walkSubTree(filename, currentDepth + 1, cfg);
                }
            }
        }
    }
}
async function readDirEntries(dirname, opts = { ignoreErrors: true }) {
    const ignoreErrors = opts.ignoreErrors || false;
    if (opts.filterFilename && (0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        let basenames;
        try {
            basenames = await fs.promises.readdir(dirname);
        }
        catch (err) {
            const exception = err;
            if (exception.code === 'ENOENT') {
                return [];
            }
            if (ignoreErrors) {
                (0, logging_1.traceError)(`readdir() failed for "${dirname}" (${err})`);
                return [];
            }
            throw err;
        }
        const filenames = basenames
            .map((b) => path.join(dirname, b))
            .filter((f) => matchFile(f, opts.filterFilename, ignoreErrors));
        return Promise.all(filenames.map(async (filename) => {
            const filetype = (await (0, filesystem_1.getFileType)(filename, opts)) || filesystem_1.FileType.Unknown;
            return { filename, filetype };
        }));
    }
    let raw;
    try {
        raw = await fs.promises.readdir(dirname, { withFileTypes: true });
    }
    catch (err) {
        const exception = err;
        if (exception.code === 'ENOENT') {
            return [];
        }
        if (ignoreErrors) {
            (0, logging_1.traceError)(`readdir() failed for "${dirname}" (${err})`);
            return [];
        }
        throw err;
    }
    const entries = raw.map((entry) => {
        const filename = path.join(dirname, entry.name);
        const filetype = (0, filesystem_1.convertFileType)(entry);
        return { filename, filetype };
    });
    if (opts.filterFilename) {
        return entries.filter((e) => matchFile(e.filename, opts.filterFilename, ignoreErrors));
    }
    return entries;
}
function matchFile(filename, filterFile, ignoreErrors = true) {
    if (filterFile === undefined) {
        return true;
    }
    try {
        return filterFile(filename);
    }
    catch (err) {
        if (ignoreErrors) {
            (0, logging_1.traceError)(`filter failed for "${filename}" (${err})`);
            return false;
        }
        throw err;
    }
}
async function getPythonVersionFromNearByFiles(interpreterPath) {
    const root = path.dirname(interpreterPath);
    let version = info_1.UNKNOWN_PYTHON_VERSION;
    for await (const entry of findInterpretersInDir(root)) {
        const { filename } = entry;
        try {
            const curVersion = (0, pythonVersion_1.parseVersion)(path.basename(filename));
            if ((0, env_1.comparePythonVersionSpecificity)(curVersion, version) > 0) {
                version = curVersion;
            }
        }
        catch (ex) {
        }
    }
    return version;
}
async function getPythonVersionFromPath(interpreterPath, hint) {
    let versionA;
    try {
        versionA = hint ? (0, pythonVersion_1.parseVersion)(hint) : info_1.UNKNOWN_PYTHON_VERSION;
    }
    catch (ex) {
        versionA = info_1.UNKNOWN_PYTHON_VERSION;
    }
    const versionB = interpreterPath ? await getPythonVersionFromNearByFiles(interpreterPath) : info_1.UNKNOWN_PYTHON_VERSION;
    const versionC = interpreterPath ? await (0, simplevirtualenvs_1.getPythonVersionFromPyvenvCfg)(interpreterPath) : info_1.UNKNOWN_PYTHON_VERSION;
    const versionD = interpreterPath ? await (0, conda_1.getPythonVersionFromConda)(interpreterPath) : info_1.UNKNOWN_PYTHON_VERSION;
    let version = info_1.UNKNOWN_PYTHON_VERSION;
    for (const v of [versionA, versionB, versionC, versionD]) {
        version = (0, env_1.comparePythonVersionSpecificity)(version, v) > 0 ? version : v;
    }
    return version;
}
exports.getPythonVersionFromPath = getPythonVersionFromPath;
async function checkPythonExecutable(executable, opts) {
    const matchFilename = opts.matchFilename || matchStandardPythonBinFilename;
    const filename = typeof executable === 'string' ? executable : executable.filename;
    if (!matchFilename(filename)) {
        return false;
    }
    if (opts.filterFile && !(await opts.filterFile(executable))) {
        return false;
    }
    return true;
}
const filterGlobalExecutable = (0, filesystem_1.getFileFilter)({ ignoreFileType: filesystem_1.FileType.SymbolicLink });
async function looksLikeBasicGlobalPython(executable) {
    const matchBasic = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? windows.matchBasicPythonBinFilename : posix.matchBasicPythonBinFilename;
    const matchFilename = matchBasic;
    const filterFile = filterGlobalExecutable;
    return checkPythonExecutable(executable, { matchFilename, filterFile });
}
exports.looksLikeBasicGlobalPython = looksLikeBasicGlobalPython;
async function looksLikeBasicVirtualPython(executable) {
    const matchBasic = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? windows.matchBasicPythonBinFilename : posix.matchBasicPythonBinFilename;
    const matchFilename = matchBasic;
    const filterFile = undefined;
    return checkPythonExecutable(executable, { matchFilename, filterFile });
}
exports.looksLikeBasicVirtualPython = looksLikeBasicVirtualPython;
async function getInterpreterPathFromDir(envDir, opts = {}) {
    const recurseLevel = 2;
    function filterDir(dirname) {
        const lower = path.basename(dirname).toLowerCase();
        return ['bin', 'scripts'].includes(lower);
    }
    const matchExecutable = opts.global ? looksLikeBasicGlobalPython : looksLikeBasicVirtualPython;
    const executables = findInterpretersInDir(envDir, recurseLevel, filterDir, opts.ignoreErrors);
    for await (const entry of executables) {
        if (await matchExecutable(entry)) {
            return entry.filename;
        }
    }
    return undefined;
}
exports.getInterpreterPathFromDir = getInterpreterPathFromDir;
function getEnvironmentDirFromPath(interpreterPath) {
    const skipDirs = ['bin', 'scripts'];
    const dir = path.basename(path.dirname(interpreterPath));
    if (!skipDirs.map((e) => (0, externalDependencies_1.normCasePath)(e)).includes((0, externalDependencies_1.normCasePath)(dir))) {
        return path.dirname(interpreterPath);
    }
    return path.dirname(path.dirname(interpreterPath));
}
exports.getEnvironmentDirFromPath = getEnvironmentDirFromPath;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentIdentifier.ts":
/*!***********************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentIdentifier.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.identifyEnvironment = void 0;
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../base/info */ "./src/client/pythonEnvironments/base/info/index.ts");
const envKind_1 = __webpack_require__(/*! ../base/info/envKind */ "./src/client/pythonEnvironments/base/info/envKind.ts");
const conda_1 = __webpack_require__(/*! ./environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const globalInstalledEnvs_1 = __webpack_require__(/*! ./environmentManagers/globalInstalledEnvs */ "./src/client/pythonEnvironments/common/environmentManagers/globalInstalledEnvs.ts");
const pipenv_1 = __webpack_require__(/*! ./environmentManagers/pipenv */ "./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts");
const poetry_1 = __webpack_require__(/*! ./environmentManagers/poetry */ "./src/client/pythonEnvironments/common/environmentManagers/poetry.ts");
const pyenv_1 = __webpack_require__(/*! ./environmentManagers/pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ./environmentManagers/simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
const microsoftStoreEnv_1 = __webpack_require__(/*! ./environmentManagers/microsoftStoreEnv */ "./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts");
const activestate_1 = __webpack_require__(/*! ./environmentManagers/activestate */ "./src/client/pythonEnvironments/common/environmentManagers/activestate.ts");
function getIdentifiers() {
    const notImplemented = () => Promise.resolve(false);
    const defaultTrue = () => Promise.resolve(true);
    const identifier = new Map();
    Object.values(info_1.PythonEnvKind).forEach((k) => {
        identifier.set(k, notImplemented);
    });
    identifier.set(info_1.PythonEnvKind.Conda, conda_1.isCondaEnvironment);
    identifier.set(info_1.PythonEnvKind.MicrosoftStore, microsoftStoreEnv_1.isMicrosoftStoreEnvironment);
    identifier.set(info_1.PythonEnvKind.Pipenv, pipenv_1.isPipenvEnvironment);
    identifier.set(info_1.PythonEnvKind.Pyenv, pyenv_1.isPyenvEnvironment);
    identifier.set(info_1.PythonEnvKind.Poetry, poetry_1.isPoetryEnvironment);
    identifier.set(info_1.PythonEnvKind.Venv, simplevirtualenvs_1.isVenvEnvironment);
    identifier.set(info_1.PythonEnvKind.VirtualEnvWrapper, simplevirtualenvs_1.isVirtualenvwrapperEnvironment);
    identifier.set(info_1.PythonEnvKind.VirtualEnv, simplevirtualenvs_1.isVirtualenvEnvironment);
    identifier.set(info_1.PythonEnvKind.ActiveState, activestate_1.isActiveStateEnvironment);
    identifier.set(info_1.PythonEnvKind.Unknown, defaultTrue);
    identifier.set(info_1.PythonEnvKind.OtherGlobal, globalInstalledEnvs_1.isGloballyInstalledEnv);
    return identifier;
}
async function identifyEnvironment(path) {
    const identifiers = getIdentifiers();
    const prioritizedEnvTypes = (0, envKind_1.getPrioritizedEnvKinds)();
    for (const e of prioritizedEnvTypes) {
        const identifier = identifiers.get(e);
        if (identifier &&
            (await identifier(path).catch((ex) => {
                (0, logging_1.traceWarn)(`Identifier for ${e} failed to identify ${path}`, ex);
                return false;
            }))) {
            return e;
        }
    }
    return info_1.PythonEnvKind.Unknown;
}
exports.identifyEnvironment = identifyEnvironment;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/activestate.ts":
/*!*********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/activestate.ts ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isActiveStateEnvironmentForWorkspace = exports.ActiveState = exports.isActiveStateEnvironment = exports.ACTIVESTATETOOLPATH_SETTING_KEY = void 0;
const path = __webpack_require__(/*! path */ "path");
const path_1 = __webpack_require__(/*! path */ "path");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const decorators_1 = __webpack_require__(/*! ../../../common/utils/decorators */ "./src/client/common/utils/decorators.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
exports.ACTIVESTATETOOLPATH_SETTING_KEY = 'activeStateToolPath';
const STATE_GENERAL_TIMEOUT = 5000;
async function isActiveStateEnvironment(interpreterPath) {
    const execDir = path.dirname(interpreterPath);
    const runtimeDir = path.dirname(execDir);
    return (0, externalDependencies_1.pathExists)(path.join(runtimeDir, '_runtime_store'));
}
exports.isActiveStateEnvironment = isActiveStateEnvironment;
class ActiveState {
    constructor() {
        (0, externalDependencies_1.onDidChangePythonSetting)(exports.ACTIVESTATETOOLPATH_SETTING_KEY, () => {
            ActiveState.statePromise = undefined;
        });
    }
    static async getState() {
        if (ActiveState.statePromise === undefined) {
            ActiveState.statePromise = ActiveState.locate();
        }
        return ActiveState.statePromise;
    }
    static getStateToolDir() {
        const home = (0, platform_1.getUserHomeDir)();
        if (!home) {
            return undefined;
        }
        return (0, platform_1.getOSType)() === platform_1.OSType.Windows
            ? path.join(home, 'AppData', 'Local', 'ActiveState', 'StateTool')
            : path.join(home, '.local', 'ActiveState', 'StateTool');
    }
    static async locate() {
        var _a;
        const stateToolDir = this.getStateToolDir();
        const stateCommand = (_a = (0, externalDependencies_1.getPythonSetting)(exports.ACTIVESTATETOOLPATH_SETTING_KEY)) !== null && _a !== void 0 ? _a : ActiveState.defaultStateCommand;
        if (stateToolDir && ((await (0, externalDependencies_1.pathExists)(stateToolDir)) || stateCommand !== this.defaultStateCommand)) {
            return new ActiveState();
        }
        return undefined;
    }
    async getProjects() {
        return this.getProjectsCached();
    }
    async getProjectsCached() {
        var _a;
        try {
            const stateCommand = (_a = (0, externalDependencies_1.getPythonSetting)(exports.ACTIVESTATETOOLPATH_SETTING_KEY)) !== null && _a !== void 0 ? _a : ActiveState.defaultStateCommand;
            const result = await (0, externalDependencies_1.shellExecute)(`${stateCommand} projects -o editor`, {
                timeout: STATE_GENERAL_TIMEOUT,
            });
            if (!result) {
                return undefined;
            }
            let output = result.stdout.trimEnd();
            if (output[output.length - 1] === '\0') {
                output = output.substring(0, output.length - 1);
            }
            (0, logging_1.traceVerbose)(`${stateCommand} projects -o editor: ${output}`);
            const projects = JSON.parse(output);
            ActiveState.setCachedProjectInfo(projects);
            return projects;
        }
        catch (ex) {
            (0, logging_1.traceError)(ex);
            return undefined;
        }
    }
    static getCachedProjectInfo() {
        return this.cachedProjectInfo;
    }
    static setCachedProjectInfo(projects) {
        this.cachedProjectInfo = projects;
    }
}
ActiveState.defaultStateCommand = 'state';
ActiveState.cachedProjectInfo = [];
__decorate([
    (0, decorators_1.cache)(30000, true, 10000)
], ActiveState.prototype, "getProjectsCached", null);
exports.ActiveState = ActiveState;
function isActiveStateEnvironmentForWorkspace(interpreterPath, workspacePath) {
    const interpreterDir = (0, path_1.dirname)(interpreterPath);
    for (const project of ActiveState.getCachedProjectInfo()) {
        if (project.executables) {
            for (const [i, dir] of project.executables.entries()) {
                if ((0, externalDependencies_1.arePathsSame)(dir, interpreterDir) && (0, externalDependencies_1.arePathsSame)(workspacePath, project.local_checkouts[i])) {
                    return true;
                }
            }
        }
    }
    return false;
}
exports.isActiveStateEnvironmentForWorkspace = isActiveStateEnvironmentForWorkspace;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts":
/*!***************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/conda.ts ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Conda = exports.CONDA_ACTIVATION_TIMEOUT = exports.CONDA_RUN_VERSION = exports.getCondaInterpreterPath = exports.getPythonVersionFromConda = exports.getCondaEnvironmentsTxt = exports.isCondaEnvironment = exports.getCondaMetaPaths = exports.parseCondaInfo = exports.CONDAPATH_SETTING_KEY = exports.AnacondaCompanyName = void 0;
const fsapi = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const semver_1 = __webpack_require__(/*! semver */ "./node_modules/semver/semver.js");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const info_1 = __webpack_require__(/*! ../../base/info */ "./src/client/pythonEnvironments/base/info/index.ts");
const pythonVersion_1 = __webpack_require__(/*! ../../base/info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const windowsUtils_1 = __webpack_require__(/*! ../windowsUtils */ "./src/client/pythonEnvironments/common/windowsUtils.ts");
const info_2 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/info/index.ts");
const decorators_1 = __webpack_require__(/*! ../../../common/utils/decorators */ "./src/client/common/utils/decorators.ts");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const scripts_1 = __webpack_require__(/*! ../../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const stringUtils_1 = __webpack_require__(/*! ../../../common/stringUtils */ "./src/client/common/stringUtils.ts");
exports.AnacondaCompanyName = 'Anaconda, Inc.';
exports.CONDAPATH_SETTING_KEY = 'condaPath';
async function parseCondaInfo(info, getPythonPath, fileExists, getPythonInfo) {
    const envs = Array.isArray(info.envs) ? info.envs : [];
    if (info.default_prefix && info.default_prefix.length > 0) {
        envs.push(info.default_prefix);
    }
    const promises = envs.map(async (envPath) => {
        const pythonPath = getPythonPath(envPath);
        if (!(await fileExists(pythonPath))) {
            return undefined;
        }
        const details = await getPythonInfo(pythonPath);
        if (!details) {
            return undefined;
        }
        return {
            ...details,
            path: pythonPath,
            companyDisplayName: exports.AnacondaCompanyName,
            envType: info_2.EnvironmentType.Conda,
            envPath,
        };
    });
    return Promise.all(promises)
        .then((interpreters) => interpreters.filter((interpreter) => interpreter !== null && interpreter !== undefined))
        .then((interpreters) => interpreters.map((interpreter) => interpreter));
}
exports.parseCondaInfo = parseCondaInfo;
function getCondaMetaPaths(interpreterPathOrEnvPath) {
    const condaMetaDir = 'conda-meta';
    const condaEnvDir1 = path.join(path.dirname(interpreterPathOrEnvPath), condaMetaDir);
    const condaEnvDir2 = path.join(path.dirname(path.dirname(interpreterPathOrEnvPath)), condaMetaDir);
    const condaEnvDir3 = path.join(interpreterPathOrEnvPath, condaMetaDir);
    return [condaEnvDir1, condaEnvDir2, condaEnvDir3];
}
exports.getCondaMetaPaths = getCondaMetaPaths;
async function isCondaEnvironment(interpreterPathOrEnvPath) {
    const condaMetaPaths = getCondaMetaPaths(interpreterPathOrEnvPath);
    for (const condaMeta of condaMetaPaths) {
        if (await (0, externalDependencies_1.pathExists)(condaMeta)) {
            return true;
        }
    }
    return false;
}
exports.isCondaEnvironment = isCondaEnvironment;
async function getCondaEnvironmentsTxt() {
    const homeDir = (0, platform_1.getUserHomeDir)();
    if (!homeDir) {
        return [];
    }
    const environmentsTxt = path.join(homeDir, '.conda', 'environments.txt');
    return [environmentsTxt];
}
exports.getCondaEnvironmentsTxt = getCondaEnvironmentsTxt;
async function getPythonVersionFromConda(interpreterPath) {
    const configPaths = getCondaMetaPaths(interpreterPath).map((p) => path.join(p, 'history'));
    const pattern = /\:python-(([\d\.a-z]?)+)/;
    for (const configPath of configPaths) {
        if (await (0, externalDependencies_1.pathExists)(configPath)) {
            try {
                const lines = (0, stringUtils_1.splitLines)(await (0, externalDependencies_1.readFile)(configPath));
                const pythonVersionStrings = lines
                    .map((line) => {
                    const matches = pattern.exec(line);
                    return matches ? matches[1] : '';
                })
                    .filter((v) => v.length > 0);
                if (pythonVersionStrings.length > 0) {
                    const last = pythonVersionStrings.length - 1;
                    return (0, pythonVersion_1.parseVersion)(pythonVersionStrings[last].trim());
                }
            }
            catch (ex) {
                return info_1.UNKNOWN_PYTHON_VERSION;
            }
        }
    }
    return info_1.UNKNOWN_PYTHON_VERSION;
}
exports.getPythonVersionFromConda = getPythonVersionFromConda;
function getCondaInterpreterPath(condaEnvironmentPath) {
    const relativePath = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? 'python.exe' : path.join('bin', 'python');
    const filePath = path.join(condaEnvironmentPath, relativePath);
    return filePath;
}
exports.getCondaInterpreterPath = getCondaInterpreterPath;
exports.CONDA_RUN_VERSION = '4.9.0';
exports.CONDA_ACTIVATION_TIMEOUT = 45000;
const CONDA_GENERAL_TIMEOUT = 50000;
class Conda {
    constructor(command, shellCommand, shellPath) {
        this.command = command;
        this.shellPath = shellPath;
        this.condaInfoCached = new Map();
        this.shellCommand = shellCommand !== null && shellCommand !== void 0 ? shellCommand : command;
        (0, externalDependencies_1.onDidChangePythonSetting)(exports.CONDAPATH_SETTING_KEY, () => {
            Conda.condaPromise = new Map();
        });
    }
    static async getConda(shellPath) {
        if (Conda.condaPromise.get(shellPath) === undefined || (0, constants_1.isTestExecution)()) {
            Conda.condaPromise.set(shellPath, Conda.locate(shellPath));
        }
        return Conda.condaPromise.get(shellPath);
    }
    static async locate(shellPath) {
        (0, logging_1.traceVerbose)(`Searching for conda.`);
        const home = (0, platform_1.getUserHomeDir)();
        const customCondaPath = (0, externalDependencies_1.getPythonSetting)(exports.CONDAPATH_SETTING_KEY);
        const suffix = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? 'Scripts\\conda.exe' : 'bin/conda';
        async function* getCandidates() {
            if (customCondaPath && customCondaPath !== 'conda') {
                yield customCondaPath;
            }
            yield 'conda';
            if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
                yield* getCandidatesFromRegistry();
            }
            yield* getCandidatesFromKnownPaths();
            yield* getCandidatesFromEnvironmentsTxt();
        }
        async function* getCandidatesFromRegistry() {
            const interps = await (0, windowsUtils_1.getRegistryInterpreters)();
            const candidates = interps
                .filter((interp) => interp.interpreterPath && interp.distroOrgName === 'ContinuumAnalytics')
                .map((interp) => path.join(path.win32.dirname(interp.interpreterPath), suffix));
            yield* candidates;
        }
        async function* getCandidatesFromKnownPaths() {
            const prefixes = [];
            if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
                const programData = (0, platform_1.getEnvironmentVariable)('PROGRAMDATA') || 'C:\\ProgramData';
                prefixes.push(programData);
                if (home) {
                    const localAppData = (0, platform_1.getEnvironmentVariable)('LOCALAPPDATA') || path.join(home, 'AppData', 'Local');
                    prefixes.push(home, path.join(localAppData, 'Continuum'));
                }
            }
            else {
                prefixes.push('/usr/share', '/usr/local/share', '/opt');
                if (home) {
                    prefixes.push(home, path.join(home, 'opt'));
                }
            }
            for (const prefix of prefixes) {
                let items;
                try {
                    items = await fsapi.readdir(prefix);
                }
                catch (ex) {
                    items = undefined;
                }
                if (items !== undefined) {
                    yield* items
                        .filter((fileName) => fileName.toLowerCase().includes('conda'))
                        .map((fileName) => path.join(prefix, fileName, suffix));
                }
            }
        }
        async function* getCandidatesFromEnvironmentsTxt() {
            if (!home) {
                return;
            }
            let contents;
            try {
                contents = await fsapi.readFile(path.join(home, '.conda', 'environments.txt'), 'utf8');
            }
            catch (ex) {
                contents = '';
            }
            yield* contents
                .split(/\r?\n/g)
                .map((line) => line.trim())
                .filter((line) => line !== '' && !line.startsWith('#'))
                .map((line) => path.join(line, suffix));
        }
        async function getCondaBatFile(file) {
            const fileDir = path.dirname(file);
            const possibleBatch = path.join(fileDir, '..', 'condabin', 'conda.bat');
            if (await (0, externalDependencies_1.pathExists)(possibleBatch)) {
                return possibleBatch;
            }
            return undefined;
        }
        for await (const condaPath of getCandidates()) {
            (0, logging_1.traceVerbose)(`Probing conda binary: ${condaPath}`);
            let conda = new Conda(condaPath, undefined, shellPath);
            try {
                await conda.getInfo();
                if ((0, platform_1.getOSType)() === platform_1.OSType.Windows && ((0, constants_1.isTestExecution)() || condaPath !== customCondaPath)) {
                    const condaBatFile = await getCondaBatFile(condaPath);
                    try {
                        if (condaBatFile) {
                            const condaBat = new Conda(condaBatFile, undefined, shellPath);
                            await condaBat.getInfo();
                            conda = new Conda(condaPath, condaBatFile, shellPath);
                        }
                    }
                    catch (ex) {
                        (0, logging_1.traceVerbose)('Failed to spawn conda bat file', condaBatFile, ex);
                    }
                }
                (0, logging_1.traceVerbose)(`Found conda via filesystem probing: ${condaPath}`);
                return conda;
            }
            catch (ex) {
                (0, logging_1.traceVerbose)('Failed to spawn conda binary', condaPath, ex);
            }
        }
        (0, logging_1.traceVerbose)("Couldn't locate the conda binary.");
        return undefined;
    }
    async getInfo(useCache) {
        let condaInfoCached = this.condaInfoCached.get(this.shellPath);
        if (!useCache || !condaInfoCached) {
            condaInfoCached = this.getInfoImpl(this.command, this.shellPath);
            this.condaInfoCached.set(this.shellPath, condaInfoCached);
        }
        return condaInfoCached;
    }
    async getInfoImpl(command, shellPath) {
        const options = { timeout: CONDA_GENERAL_TIMEOUT };
        if (shellPath) {
            options.shell = shellPath;
        }
        const result = await (0, externalDependencies_1.exec)(command, ['info', '--json'], options);
        (0, logging_1.traceVerbose)(`${command} info --json: ${result.stdout}`);
        return JSON.parse(result.stdout);
    }
    async getEnvList() {
        const info = await this.getInfo();
        const { envs } = info;
        if (envs === undefined) {
            return [];
        }
        return Promise.all(envs.map(async (prefix) => ({
            prefix,
            name: await this.getName(prefix, info),
        })));
    }
    async getName(prefix, info) {
        info = info !== null && info !== void 0 ? info : (await this.getInfo(true));
        if (info.root_prefix && (0, externalDependencies_1.arePathsSame)(prefix, info.root_prefix)) {
            return 'base';
        }
        const parentDir = path.dirname(prefix);
        if (info.envs_dirs !== undefined) {
            for (const envsDir of info.envs_dirs) {
                if ((0, externalDependencies_1.arePathsSame)(parentDir, envsDir)) {
                    return path.basename(prefix);
                }
            }
        }
        return undefined;
    }
    async getCondaEnvironment(executableOrEnvPath) {
        const envList = await this.getEnvList();
        const condaEnv = envList.find((e) => (0, externalDependencies_1.arePathsSame)(executableOrEnvPath, e.prefix));
        if (condaEnv) {
            return condaEnv;
        }
        return envList.find((e) => (0, externalDependencies_1.isParentPath)(executableOrEnvPath, e.prefix));
    }
    async getInterpreterPathForEnvironment(condaEnv) {
        const executablePath = getCondaInterpreterPath(condaEnv.prefix);
        if (await (0, externalDependencies_1.pathExists)(executablePath)) {
            (0, logging_1.traceVerbose)('Found executable within conda env', JSON.stringify(condaEnv));
            return executablePath;
        }
        (0, logging_1.traceVerbose)('Executable does not exist within conda env, assume the executable to be `python`', JSON.stringify(condaEnv));
        return 'python';
    }
    async getRunPythonArgs(env, forShellExecution, isolatedFlag = false) {
        const condaVersion = await this.getCondaVersion();
        if (condaVersion && (0, semver_1.lt)(condaVersion, exports.CONDA_RUN_VERSION)) {
            (0, logging_1.traceError)('`conda run` is not supported for conda version', condaVersion.raw);
            return undefined;
        }
        const args = [];
        if (env.name) {
            args.push('-n', env.name);
        }
        else {
            args.push('-p', env.prefix);
        }
        const python = [
            forShellExecution ? this.shellCommand : this.command,
            'run',
            ...args,
            '--no-capture-output',
            'python',
        ];
        if (isolatedFlag) {
            python.push('-I');
        }
        return [...python, scripts_1.OUTPUT_MARKER_SCRIPT];
    }
    async getCondaVersion() {
        const info = await this.getInfo(true).catch(() => undefined);
        let versionString;
        if (info && info.conda_version) {
            versionString = info.conda_version;
        }
        else {
            const stdOut = await (0, externalDependencies_1.exec)(this.command, ['--version'], { timeout: CONDA_GENERAL_TIMEOUT })
                .then((result) => result.stdout.trim())
                .catch(() => undefined);
            versionString = stdOut && stdOut.startsWith('conda ') ? stdOut.substring('conda '.length).trim() : stdOut;
        }
        if (!versionString) {
            return undefined;
        }
        const pattern = /(?<major>\d+)\.(?<minor>\d+)\.(?<micro>\d+)(?:.*)?/;
        const match = versionString.match(pattern);
        if (match && match.groups) {
            const versionStringParsed = match.groups.major.concat('.', match.groups.minor, '.', match.groups.micro);
            const semVarVersion = new semver_1.SemVer(versionStringParsed);
            if (semVarVersion) {
                return semVarVersion;
            }
        }
        (0, logging_1.traceError)(`Unable to parse version of Conda, ${versionString}`);
        return new semver_1.SemVer('0.0.1');
    }
    async isCondaRunSupported() {
        const condaVersion = await this.getCondaVersion();
        if (condaVersion && (0, semver_1.lt)(condaVersion, exports.CONDA_RUN_VERSION)) {
            return false;
        }
        return true;
    }
}
Conda.condaPromise = new Map();
__decorate([
    (0, decorators_1.cache)(30000, true, 10000)
], Conda.prototype, "getInfoImpl", null);
__decorate([
    (0, decorators_1.cache)(30000, true, 10000)
], Conda.prototype, "getEnvList", null);
__decorate([
    (0, decorators_1.cache)(-1, true)
], Conda.prototype, "getCondaVersion", null);
exports.Conda = Conda;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/condaService.ts":
/*!**********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/condaService.ts ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CondaService = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const path = __webpack_require__(/*! path */ "path");
const types_1 = __webpack_require__(/*! ../../../common/platform/types */ "./src/client/common/platform/types.ts");
const decorators_1 = __webpack_require__(/*! ../../../common/utils/decorators */ "./src/client/common/utils/decorators.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const conda_1 = __webpack_require__(/*! ./conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
let CondaService = class CondaService {
    constructor(platform, fileSystem) {
        this.platform = platform;
        this.fileSystem = fileSystem;
    }
    async getActivationScriptFromInterpreter(interpreterPath, envName) {
        const condaPath = await this.getCondaFileFromInterpreter(interpreterPath, envName);
        const activatePath = (condaPath
            ? path.join(path.dirname(condaPath), 'activate')
            : 'activate').fileToCommandArgumentForPythonMgrExt();
        if (this.platform.isLinux || this.platform.isMac) {
            const condaInfo = await this.getCondaInfo();
            if (condaInfo === null || condaInfo === void 0 ? void 0 : condaInfo.root_prefix) {
                const globalActivatePath = path
                    .join(condaInfo.root_prefix, this.platform.virtualEnvBinName, 'activate')
                    .fileToCommandArgumentForPythonMgrExt();
                if (activatePath === globalActivatePath || !(await this.fileSystem.fileExists(activatePath))) {
                    return {
                        path: globalActivatePath,
                        type: 'global',
                    };
                }
            }
        }
        return { path: activatePath, type: 'local' };
    }
    async getCondaFile(forShellExecution) {
        return conda_1.Conda.getConda().then((conda) => {
            const command = forShellExecution ? conda === null || conda === void 0 ? void 0 : conda.shellCommand : conda === null || conda === void 0 ? void 0 : conda.command;
            return command !== null && command !== void 0 ? command : 'conda';
        });
    }
    async getInterpreterPathForEnvironment(condaEnv) {
        const conda = await conda_1.Conda.getConda();
        return conda === null || conda === void 0 ? void 0 : conda.getInterpreterPathForEnvironment({ name: condaEnv.name, prefix: condaEnv.path });
    }
    async isCondaAvailable() {
        if (typeof this.isAvailable === 'boolean') {
            return this.isAvailable;
        }
        return this.getCondaVersion()
            .then((version) => (this.isAvailable = version !== undefined))
            .catch(() => (this.isAvailable = false));
    }
    async getCondaVersion() {
        return conda_1.Conda.getConda().then((conda) => conda === null || conda === void 0 ? void 0 : conda.getCondaVersion());
    }
    async getCondaFileFromInterpreter(interpreterPath, envName) {
        const condaExe = this.platform.isWindows ? 'conda.exe' : 'conda';
        const scriptsDir = this.platform.isWindows ? 'Scripts' : 'bin';
        const interpreterDir = interpreterPath ? path.dirname(interpreterPath) : '';
        const envsPos = envName ? interpreterDir.indexOf(path.join('envs', envName)) : -1;
        if (envsPos > 0) {
            const originalPath = interpreterDir.slice(0, envsPos);
            let condaPath1 = path.join(originalPath, condaExe);
            if (await this.fileSystem.fileExists(condaPath1)) {
                return condaPath1;
            }
            condaPath1 = path.join(originalPath, scriptsDir, condaExe);
            if (await this.fileSystem.fileExists(condaPath1)) {
                return condaPath1;
            }
        }
        let condaPath2 = path.join(interpreterDir, condaExe);
        if (await this.fileSystem.fileExists(condaPath2)) {
            return condaPath2;
        }
        condaPath2 = path.join(interpreterDir, scriptsDir, condaExe);
        if (await this.fileSystem.fileExists(condaPath2)) {
            return condaPath2;
        }
        return this.getCondaFile();
    }
    async getCondaInfo() {
        const conda = await conda_1.Conda.getConda();
        return conda === null || conda === void 0 ? void 0 : conda.getInfo();
    }
};
__decorate([
    (0, logging_1.traceDecoratorVerbose)('Get Conda File from interpreter'),
    (0, decorators_1.cache)(120000)
], CondaService.prototype, "getCondaFileFromInterpreter", null);
__decorate([
    (0, decorators_1.cache)(60000)
], CondaService.prototype, "getCondaInfo", null);
CondaService = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(types_1.IPlatformService)),
    __param(1, (0, inversify_1.inject)(types_1.IFileSystem))
], CondaService);
exports.CondaService = CondaService;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/globalInstalledEnvs.ts":
/*!*****************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/globalInstalledEnvs.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isGloballyInstalledEnv = void 0;
const exec_1 = __webpack_require__(/*! ../../../common/utils/exec */ "./src/client/common/utils/exec.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const posixUtils_1 = __webpack_require__(/*! ../posixUtils */ "./src/client/pythonEnvironments/common/posixUtils.ts");
const pyenv_1 = __webpack_require__(/*! ./pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
async function isGloballyInstalledEnv(executablePath) {
    return isFoundInPathEnvVar(executablePath);
}
exports.isGloballyInstalledEnv = isGloballyInstalledEnv;
async function isFoundInPathEnvVar(executablePath) {
    let searchPathEntries = [];
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        searchPathEntries = (0, exec_1.getSearchPathEntries)();
    }
    else {
        searchPathEntries = await (0, posixUtils_1.commonPosixBinPaths)();
    }
    searchPathEntries = searchPathEntries.filter((dirname) => !(0, pyenv_1.isPyenvShimDir)(dirname));
    for (const searchPath of searchPathEntries) {
        if ((0, externalDependencies_1.isParentPath)(executablePath, searchPath)) {
            return true;
        }
    }
    return false;
}


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/macDefault.ts":
/*!********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/macDefault.ts ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isMacDefaultPythonPath = void 0;
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
function isMacDefaultPythonPath(pythonPath) {
    if ((0, platform_1.getOSType)() !== platform_1.OSType.OSX) {
        return false;
    }
    const defaultPaths = ['/usr/bin/python'];
    return defaultPaths.includes(pythonPath) || pythonPath.startsWith('/usr/bin/python2');
}
exports.isMacDefaultPythonPath = isMacDefaultPythonPath;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts":
/*!***************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isMicrosoftStoreEnvironment = exports.isStorePythonInstalled = exports.isMicrosoftStoreDir = exports.getMicrosoftStoreAppsRoot = void 0;
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
function getMicrosoftStoreAppsRoot() {
    const localAppData = (0, platform_1.getEnvironmentVariable)('LOCALAPPDATA') || '';
    return path.join(localAppData, 'Microsoft', 'WindowsApps');
}
exports.getMicrosoftStoreAppsRoot = getMicrosoftStoreAppsRoot;
function isForbiddenStorePath(absPath) {
    const programFilesStorePath = path
        .join((0, platform_1.getEnvironmentVariable)('ProgramFiles') || 'Program Files', 'WindowsApps')
        .normalize()
        .toUpperCase();
    return path.normalize(absPath).toUpperCase().includes(programFilesStorePath);
}
function isMicrosoftStoreDir(dirPath) {
    const storeRootPath = path.normalize(getMicrosoftStoreAppsRoot()).toUpperCase();
    return path.normalize(dirPath).toUpperCase().includes(storeRootPath) || isForbiddenStorePath(dirPath);
}
exports.isMicrosoftStoreDir = isMicrosoftStoreDir;
async function isStorePythonInstalled(interpreterPath) {
    let results = await Promise.all([
        (0, externalDependencies_1.pathExists)(path.join(getMicrosoftStoreAppsRoot(), 'idle.exe')),
        (0, externalDependencies_1.pathExists)(path.join(getMicrosoftStoreAppsRoot(), 'pip.exe')),
    ]);
    if (results.includes(true)) {
        return true;
    }
    if (interpreterPath) {
        results = await Promise.all([
            (0, externalDependencies_1.pathExists)(path.join(path.dirname(interpreterPath), 'idle.exe')),
            (0, externalDependencies_1.pathExists)(path.join(path.dirname(interpreterPath), 'pip.exe')),
        ]);
        return results.includes(true);
    }
    return false;
}
exports.isStorePythonInstalled = isStorePythonInstalled;
async function isMicrosoftStoreEnvironment(interpreterPath) {
    if (await isStorePythonInstalled(interpreterPath)) {
        const pythonPathToCompare = path.normalize(interpreterPath).toUpperCase();
        const localAppDataStorePath = path.normalize(getMicrosoftStoreAppsRoot()).toUpperCase();
        if (pythonPathToCompare.includes(localAppDataStorePath)) {
            return true;
        }
        if (isForbiddenStorePath(pythonPathToCompare)) {
            (0, logging_1.traceWarn)('isMicrosoftStoreEnvironment called with Program Files store path.');
            return true;
        }
    }
    return false;
}
exports.isMicrosoftStoreEnvironment = isMicrosoftStoreEnvironment;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts":
/*!****************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/pipenv.ts ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isPipenvEnvironmentRelatedToFolder = exports.isPipenvEnvironment = exports._getAssociatedPipfile = void 0;
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
function getSearchHeight() {
    const maxDepthStr = (0, platform_1.getEnvironmentVariable)('PIPENV_MAX_DEPTH');
    if (maxDepthStr === undefined) {
        return 3;
    }
    const maxDepth = parseInt(maxDepthStr, 10);
    if (isNaN(maxDepth)) {
        (0, logging_1.traceError)(`PIPENV_MAX_DEPTH is incorrectly set. Converting value '${maxDepthStr}' to number results in NaN`);
        return 1;
    }
    return maxDepth;
}
async function _getAssociatedPipfile(searchDir, options) {
    const pipFileName = (0, platform_1.getEnvironmentVariable)('PIPENV_PIPFILE') || 'Pipfile';
    let heightToSearch = options.lookIntoParentDirectories ? getSearchHeight() : 1;
    while (heightToSearch > 0 && !(0, externalDependencies_1.arePathsSame)(searchDir, path.dirname(searchDir))) {
        const pipFile = path.join(searchDir, pipFileName);
        if (await (0, externalDependencies_1.pathExists)(pipFile)) {
            return pipFile;
        }
        searchDir = path.dirname(searchDir);
        heightToSearch -= 1;
    }
    return undefined;
}
exports._getAssociatedPipfile = _getAssociatedPipfile;
async function getPipfileIfLocal(interpreterPath) {
    const venvFolder = path.dirname(path.dirname(interpreterPath));
    if (path.basename(venvFolder) !== '.venv') {
        return undefined;
    }
    const directoryWhereVenvResides = path.dirname(venvFolder);
    return _getAssociatedPipfile(directoryWhereVenvResides, { lookIntoParentDirectories: false });
}
async function getProjectDir(envFolder) {
    const dotProjectFile = path.join(envFolder, '.project');
    if (!(await (0, externalDependencies_1.pathExists)(dotProjectFile))) {
        return undefined;
    }
    const projectDir = (await (0, externalDependencies_1.readFile)(dotProjectFile)).trim();
    if (!(await (0, externalDependencies_1.pathExists)(projectDir))) {
        (0, logging_1.traceError)(`The .project file inside environment folder: ${envFolder} doesn't contain a valid path to the project`);
        return undefined;
    }
    return projectDir;
}
async function getPipfileIfGlobal(interpreterPath) {
    const envFolder = path.dirname(path.dirname(interpreterPath));
    const projectDir = await getProjectDir(envFolder);
    if (projectDir === undefined) {
        return undefined;
    }
    const envFolderName = path.basename((0, externalDependencies_1.normCasePath)(envFolder));
    if (!envFolderName.startsWith(`${path.basename((0, externalDependencies_1.normCasePath)(projectDir))}-`)) {
        return undefined;
    }
    return _getAssociatedPipfile(projectDir, { lookIntoParentDirectories: false });
}
async function isPipenvEnvironment(interpreterPath) {
    if (await getPipfileIfLocal(interpreterPath)) {
        return true;
    }
    if (await getPipfileIfGlobal(interpreterPath)) {
        return true;
    }
    return false;
}
exports.isPipenvEnvironment = isPipenvEnvironment;
async function isPipenvEnvironmentRelatedToFolder(interpreterPath, folder) {
    const pipFileAssociatedWithEnvironment = await getPipfileIfGlobal(interpreterPath);
    if (!pipFileAssociatedWithEnvironment) {
        return false;
    }
    const lookIntoParentDirectories = (0, platform_1.getEnvironmentVariable)('PIPENV_NO_INHERIT') === undefined;
    const pipFileAssociatedWithFolder = await _getAssociatedPipfile(folder, { lookIntoParentDirectories });
    if (!pipFileAssociatedWithFolder) {
        return false;
    }
    return (0, externalDependencies_1.arePathsSame)(pipFileAssociatedWithEnvironment, pipFileAssociatedWithFolder);
}
exports.isPipenvEnvironmentRelatedToFolder = isPipenvEnvironmentRelatedToFolder;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/poetry.ts":
/*!****************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/poetry.ts ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isPoetryEnvironmentRelatedToFolder = exports.Poetry = exports.isPoetryEnvironment = exports.localPoetryEnvDirName = void 0;
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const commonUtils_1 = __webpack_require__(/*! ../commonUtils */ "./src/client/pythonEnvironments/common/commonUtils.ts");
const simplevirtualenvs_1 = __webpack_require__(/*! ./simplevirtualenvs */ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts");
const stopWatch_1 = __webpack_require__(/*! ../../../common/utils/stopWatch */ "./src/client/common/utils/stopWatch.ts");
const decorators_1 = __webpack_require__(/*! ../../../common/utils/decorators */ "./src/client/common/utils/decorators.ts");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const stringUtils_1 = __webpack_require__(/*! ../../../common/stringUtils */ "./src/client/common/stringUtils.ts");
const globalPoetryEnvDirRegex = /^(.+)-(.+)-py(\d).(\d){1,2}$/;
async function isGlobalPoetryEnvironment(interpreterPath) {
    const envDir = (0, commonUtils_1.getEnvironmentDirFromPath)(interpreterPath);
    return globalPoetryEnvDirRegex.test(path.basename(envDir)) ? (0, simplevirtualenvs_1.isVirtualenvEnvironment)(interpreterPath) : false;
}
exports.localPoetryEnvDirName = '.venv';
async function isLocalPoetryEnvironment(interpreterPath) {
    const envDir = (0, commonUtils_1.getEnvironmentDirFromPath)(interpreterPath);
    if (path.basename(envDir) !== exports.localPoetryEnvDirName) {
        return false;
    }
    const project = path.dirname(envDir);
    if (!hasValidPyprojectToml(project)) {
        return false;
    }
    return true;
}
async function isPoetryEnvironment(interpreterPath) {
    if (await isGlobalPoetryEnvironment(interpreterPath)) {
        return true;
    }
    if (await isLocalPoetryEnvironment(interpreterPath)) {
        return true;
    }
    return false;
}
exports.isPoetryEnvironment = isPoetryEnvironment;
const POETRY_TIMEOUT = 50000;
class Poetry {
    constructor(command, cwd) {
        this.command = command;
        this.cwd = cwd;
        this.fixCwd();
    }
    static async getPoetry(cwd) {
        if (!hasValidPyprojectToml(cwd)) {
            return undefined;
        }
        if (Poetry.poetryPromise.get(cwd) === undefined || (0, constants_1.isTestExecution)()) {
            Poetry.poetryPromise.set(cwd, Poetry.locate(cwd));
        }
        return Poetry.poetryPromise.get(cwd);
    }
    static async locate(cwd) {
        (0, logging_1.traceVerbose)(`Getting poetry for cwd ${cwd}`);
        function* getCandidates() {
            try {
                const customPoetryPath = (0, externalDependencies_1.getPythonSetting)('poetryPath');
                if (customPoetryPath && customPoetryPath !== 'poetry') {
                    yield customPoetryPath;
                }
            }
            catch (ex) {
                (0, logging_1.traceError)(`Failed to get poetry setting`, ex);
            }
            yield 'poetry';
            const home = (0, platform_1.getUserHomeDir)();
            if (home) {
                const defaultPoetryPath = path.join(home, '.poetry', 'bin', 'poetry');
                if ((0, externalDependencies_1.pathExistsSync)(defaultPoetryPath)) {
                    yield defaultPoetryPath;
                }
            }
        }
        for (const poetryPath of getCandidates()) {
            (0, logging_1.traceVerbose)(`Probing poetry binary for ${cwd}: ${poetryPath}`);
            const poetry = new Poetry(poetryPath, cwd);
            const virtualenvs = await poetry.getEnvList();
            if (virtualenvs !== undefined) {
                (0, logging_1.traceVerbose)(`Found poetry via filesystem probing for ${cwd}: ${poetryPath}`);
                return poetry;
            }
            (0, logging_1.traceVerbose)(`Failed to find poetry for ${cwd}: ${poetryPath}`);
        }
        (0, logging_1.traceVerbose)(`No poetry binary found for ${cwd}`);
        return undefined;
    }
    static async getVersion(cwd) {
        (0, logging_1.traceVerbose)(`Getting poetry version`);
        function* getCandidates() {
            try {
                const customPoetryPath = (0, externalDependencies_1.getPythonSetting)('poetryPath');
                if (customPoetryPath && customPoetryPath !== 'poetry') {
                    yield customPoetryPath;
                }
            }
            catch (ex) {
                (0, logging_1.traceError)(`Failed to get poetry setting`, ex);
            }
            yield 'poetry';
            const home = (0, platform_1.getUserHomeDir)();
            if (home) {
                const defaultPoetryPath = path.join(home, '.poetry', 'bin', 'poetry');
                if ((0, externalDependencies_1.pathExistsSync)(defaultPoetryPath)) {
                    yield defaultPoetryPath;
                }
            }
        }
        for (const poetryPath of getCandidates()) {
            (0, logging_1.traceVerbose)(`Getting poetry version for ${poetryPath}`);
            const poetry = new Poetry(poetryPath, cwd);
            const version = await poetry.getVersionCached();
            if (version) {
                (0, logging_1.traceVerbose)(`Found version ${version} for ${poetryPath}`);
                return version;
            }
            (0, logging_1.traceVerbose)(`Failed to find poetry for ${poetryPath}`);
        }
        (0, logging_1.traceVerbose)(`No poetry binary found for ${cwd}`);
        return undefined;
    }
    async getVersionCached() {
        const result = await this.safeShellExecute(`${this.command} --version`);
        if (!result) {
            return undefined;
        }
        const lines = (0, stringUtils_1.splitLines)(result.stdout).map((line) => {
            if (line.startsWith('Poetry (version')) {
                line = line.substring('Poetry (version'.length).trim();
            }
            if (line.endsWith(')')) {
                line = line.substring(0, line.length - 1).trim();
            }
            return line;
        });
        return lines.length ? lines[0] : '';
    }
    async getEnvList() {
        return this.getEnvListCached(this.cwd);
    }
    async getEnvListCached(_cwd) {
        const result = await this.safeShellExecute(`${this.command} env list --full-path`);
        if (!result) {
            return undefined;
        }
        const activated = '(Activated)';
        const res = await Promise.all((0, stringUtils_1.splitLines)(result.stdout).map(async (line) => {
            if (line.endsWith(activated)) {
                line = line.slice(0, -activated.length);
            }
            const folder = line.trim();
            return (await (0, externalDependencies_1.pathExists)(folder)) ? folder : undefined;
        }));
        return res.filter((r) => r !== undefined).map((r) => r);
    }
    async getActiveEnvPath() {
        return this.getActiveEnvPathCached(this.cwd);
    }
    async getActiveEnvPathCached(_cwd) {
        const result = await this.safeShellExecute(`${this.command} env info -p`, true);
        if (!result) {
            return undefined;
        }
        return result.stdout.trim();
    }
    async getVirtualenvsPathSetting() {
        const result = await this.safeShellExecute(`${this.command} config virtualenvs.path`);
        if (!result) {
            return undefined;
        }
        return result.stdout.trim();
    }
    fixCwd() {
        if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
            if (/^[a-z]:/.test(this.cwd)) {
                const a = this.cwd.split(':');
                a[0] = a[0].toUpperCase();
                this.cwd = a.join(':');
            }
        }
    }
    async safeShellExecute(command, logVerbose = false) {
        const stopWatch = new stopWatch_1.StopWatch();
        const result = await (0, externalDependencies_1.shellExecute)(command, {
            cwd: this.cwd,
            throwOnStdErr: true,
            timeout: POETRY_TIMEOUT,
        }).catch((ex) => {
            if (logVerbose) {
                (0, logging_1.traceVerbose)(ex);
            }
            else {
                (0, logging_1.traceError)(ex);
            }
            return undefined;
        });
        (0, logging_1.traceVerbose)(`Time taken to run ${command} in ms`, stopWatch.elapsedTime);
        return result;
    }
}
Poetry.poetryPromise = new Map();
__decorate([
    (0, decorators_1.cache)(30000, true, 10000)
], Poetry.prototype, "getVersionCached", null);
__decorate([
    (0, decorators_1.cache)(30000, true, 10000)
], Poetry.prototype, "getEnvListCached", null);
__decorate([
    (0, decorators_1.cache)(20000, true, 10000)
], Poetry.prototype, "getActiveEnvPathCached", null);
exports.Poetry = Poetry;
async function isPoetryEnvironmentRelatedToFolder(interpreterPath, folder, poetryPath) {
    const poetry = poetryPath ? new Poetry(poetryPath, folder) : await Poetry.getPoetry(folder);
    const pathToEnv = await (poetry === null || poetry === void 0 ? void 0 : poetry.getActiveEnvPath());
    if (!pathToEnv) {
        return false;
    }
    return (0, externalDependencies_1.isParentPath)(interpreterPath, pathToEnv);
}
exports.isPoetryEnvironmentRelatedToFolder = isPoetryEnvironmentRelatedToFolder;
function hasValidPyprojectToml(folder) {
    const pyprojectToml = path.join(folder, 'pyproject.toml');
    if (!(0, externalDependencies_1.pathExistsSync)(pyprojectToml)) {
        return false;
    }
    const content = (0, externalDependencies_1.readFileSync)(pyprojectToml);
    if (!content.includes('[tool.poetry]')) {
        return false;
    }
    return true;
}


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts":
/*!***************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parsePyenvVersion = exports.isPyenvEnvironment = exports.isPyenvShimDir = exports.getPyenvVersionsDir = exports.getPyenvDir = void 0;
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
function getPyenvDir() {
    var _a;
    let pyenvDir = (_a = (0, platform_1.getEnvironmentVariable)('PYENV_ROOT')) !== null && _a !== void 0 ? _a : (0, platform_1.getEnvironmentVariable)('PYENV');
    if (!pyenvDir) {
        const homeDir = (0, platform_1.getUserHomeDir)() || '';
        pyenvDir =
            (0, platform_1.getOSType)() === platform_1.OSType.Windows ? path.join(homeDir, '.pyenv', 'pyenv-win') : path.join(homeDir, '.pyenv');
    }
    return pyenvDir;
}
exports.getPyenvDir = getPyenvDir;
function getPyenvVersionsDir() {
    return path.join(getPyenvDir(), 'versions');
}
exports.getPyenvVersionsDir = getPyenvVersionsDir;
function isPyenvShimDir(dirPath) {
    const shimPath = path.join(getPyenvDir(), 'shims');
    return (0, externalDependencies_1.arePathsSame)(shimPath, dirPath) || (0, externalDependencies_1.arePathsSame)(`${shimPath}${path.sep}`, dirPath);
}
exports.isPyenvShimDir = isPyenvShimDir;
async function isPyenvEnvironment(interpreterPath) {
    const pathToCheck = interpreterPath;
    const pyenvDir = getPyenvDir();
    if (!(await (0, externalDependencies_1.pathExists)(pyenvDir))) {
        return false;
    }
    return (0, externalDependencies_1.isParentPath)(pathToCheck, pyenvDir);
}
exports.isPyenvEnvironment = isPyenvEnvironment;
function getKnownPyenvVersionParsers() {
    function pythonOnly(str) {
        return {
            pythonVer: str,
            distro: undefined,
            distroVer: undefined,
        };
    }
    function distroOnly(str) {
        const parts = str.split('-');
        if (parts.length === 3) {
            return {
                pythonVer: undefined,
                distroVer: `${parts[1]}-${parts[2]}`,
                distro: parts[0],
            };
        }
        if (parts.length === 2) {
            return {
                pythonVer: undefined,
                distroVer: parts[1],
                distro: parts[0],
            };
        }
        return {
            pythonVer: undefined,
            distroVer: undefined,
            distro: str,
        };
    }
    function pypyParser(str) {
        const pattern = /[0-9\.]+/;
        const parts = str.split('-');
        const pythonVer = parts[0].search(pattern) > 0 ? parts[0].substr('pypy'.length) : undefined;
        if (parts.length === 2) {
            return {
                pythonVer,
                distroVer: parts[1],
                distro: 'pypy',
            };
        }
        if (parts.length === 3 &&
            (parts[2].startsWith('src') ||
                parts[2].startsWith('beta') ||
                parts[2].startsWith('alpha') ||
                parts[2].startsWith('win64'))) {
            const part1 = parts[1].startsWith('v') ? parts[1].substr(1) : parts[1];
            return {
                pythonVer,
                distroVer: `${part1}-${parts[2]}`,
                distro: 'pypy',
            };
        }
        if (parts.length === 3 && parts[1] === 'stm') {
            return {
                pythonVer,
                distroVer: parts[2],
                distro: `${parts[0]}-${parts[1]}`,
            };
        }
        if (parts.length === 4 && parts[1] === 'c') {
            return {
                pythonVer,
                distroVer: parts[3],
                distro: `pypy-${parts[1]}-${parts[2]}`,
            };
        }
        if (parts.length === 4 && parts[3].startsWith('src')) {
            return {
                pythonVer,
                distroVer: `${parts[1]}-${parts[2]}-${parts[3]}`,
                distro: 'pypy',
            };
        }
        return {
            pythonVer,
            distroVer: undefined,
            distro: 'pypy',
        };
    }
    const parsers = new Map();
    parsers.set('activepython', distroOnly);
    parsers.set('anaconda', distroOnly);
    parsers.set('graalpython', distroOnly);
    parsers.set('ironpython', distroOnly);
    parsers.set('jython', distroOnly);
    parsers.set('micropython', distroOnly);
    parsers.set('miniconda', distroOnly);
    parsers.set('miniforge', distroOnly);
    parsers.set('pypy', pypyParser);
    parsers.set('pyston', distroOnly);
    parsers.set('stackless', distroOnly);
    parsers.set('3', pythonOnly);
    parsers.set('2', pythonOnly);
    return parsers;
}
function parsePyenvVersion(str) {
    const allParsers = getKnownPyenvVersionParsers();
    const knownPrefixes = Array.from(allParsers.keys());
    const parsers = knownPrefixes
        .filter((k) => str.startsWith(k))
        .map((p) => allParsers.get(p))
        .filter((p) => p !== undefined);
    if (parsers.length > 0 && parsers[0]) {
        return parsers[0](str);
    }
    return undefined;
}
exports.parsePyenvVersion = parsePyenvVersion;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts":
/*!***************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/environmentManagers/simplevirtualenvs.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPythonVersionFromPyvenvCfg = exports.isVirtualenvwrapperEnvironment = exports.isVirtualenvEnvironment = exports.isVenvEnvironment = exports.isVirtualEnvironment = void 0;
const fsapi = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
__webpack_require__(/*! ../../../common/extensions */ "./src/client/common/extensions.ts");
const stringUtils_1 = __webpack_require__(/*! ../../../common/stringUtils */ "./src/client/common/stringUtils.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const info_1 = __webpack_require__(/*! ../../base/info */ "./src/client/pythonEnvironments/base/info/index.ts");
const env_1 = __webpack_require__(/*! ../../base/info/env */ "./src/client/pythonEnvironments/base/info/env.ts");
const pythonVersion_1 = __webpack_require__(/*! ../../base/info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const externalDependencies_1 = __webpack_require__(/*! ../externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
function getPyvenvConfigPathsFrom(interpreterPath) {
    const pyvenvConfigFile = 'pyvenv.cfg';
    const venvPath1 = path.join(path.dirname(path.dirname(interpreterPath)), pyvenvConfigFile);
    const venvPath2 = path.join(path.dirname(interpreterPath), pyvenvConfigFile);
    return [venvPath1, venvPath2];
}
async function isVirtualEnvironment(interpreterPath) {
    return isVenvEnvironment(interpreterPath);
}
exports.isVirtualEnvironment = isVirtualEnvironment;
async function isVenvEnvironment(interpreterPath) {
    const venvPaths = getPyvenvConfigPathsFrom(interpreterPath);
    for (const venvPath of venvPaths) {
        if (await (0, externalDependencies_1.pathExists)(venvPath)) {
            return true;
        }
    }
    return false;
}
exports.isVenvEnvironment = isVenvEnvironment;
async function isVirtualenvEnvironment(interpreterPath) {
    const directory = path.dirname(interpreterPath);
    const files = await fsapi.readdir(directory);
    const regex = /^activate(\.([A-z]|\d)+)?$/i;
    return files.find((file) => regex.test(file)) !== undefined;
}
exports.isVirtualenvEnvironment = isVirtualenvEnvironment;
async function getDefaultVirtualenvwrapperDir() {
    const homeDir = (0, platform_1.getUserHomeDir)() || '';
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        const envs = path.join(homeDir, 'Envs');
        if (await (0, externalDependencies_1.pathExists)(envs)) {
            return envs;
        }
    }
    return path.join(homeDir, '.virtualenvs');
}
function getWorkOnHome() {
    const workOnHome = (0, platform_1.getEnvironmentVariable)('WORKON_HOME');
    if (workOnHome) {
        return Promise.resolve(workOnHome);
    }
    return getDefaultVirtualenvwrapperDir();
}
async function isVirtualenvwrapperEnvironment(interpreterPath) {
    const workOnHomeDir = await getWorkOnHome();
    return ((await (0, externalDependencies_1.pathExists)(workOnHomeDir)) &&
        (0, externalDependencies_1.isParentPath)(interpreterPath, workOnHomeDir) &&
        isVirtualenvEnvironment(interpreterPath));
}
exports.isVirtualenvwrapperEnvironment = isVirtualenvwrapperEnvironment;
async function getPythonVersionFromPyvenvCfg(interpreterPath) {
    const configPaths = getPyvenvConfigPathsFrom(interpreterPath);
    let version = info_1.UNKNOWN_PYTHON_VERSION;
    for (const configPath of configPaths) {
        if (await (0, externalDependencies_1.pathExists)(configPath)) {
            try {
                const lines = (0, stringUtils_1.splitLines)(await (0, externalDependencies_1.readFile)(configPath));
                const pythonVersions = lines
                    .map((line) => {
                    const parts = line.split('=');
                    if (parts.length === 2) {
                        const name = parts[0].toLowerCase().trim();
                        const value = parts[1].trim();
                        if (name === 'version') {
                            try {
                                return (0, pythonVersion_1.parseVersion)(value);
                            }
                            catch (ex) {
                                return undefined;
                            }
                        }
                        else if (name === 'version_info') {
                            try {
                                return parseVersionInfo(value);
                            }
                            catch (ex) {
                                return undefined;
                            }
                        }
                    }
                    return undefined;
                })
                    .filter((v) => v !== undefined)
                    .map((v) => v);
                if (pythonVersions.length > 0) {
                    for (const v of pythonVersions) {
                        if ((0, env_1.comparePythonVersionSpecificity)(v, version) > 0) {
                            version = v;
                        }
                    }
                }
            }
            catch (ex) {
                return info_1.UNKNOWN_PYTHON_VERSION;
            }
        }
    }
    return version;
}
exports.getPythonVersionFromPyvenvCfg = getPythonVersionFromPyvenvCfg;
function parseVersionInfo(versionInfoStr) {
    let version;
    let after;
    try {
        [version, after] = (0, pythonVersion_1.parseBasicVersion)(versionInfoStr);
    }
    catch (_a) {
        return info_1.UNKNOWN_PYTHON_VERSION;
    }
    if (version.micro !== -1 && after.startsWith('.')) {
        [version.release] = (0, pythonVersion_1.parseRelease)(after);
    }
    return version;
}


/***/ }),

/***/ "./src/client/pythonEnvironments/common/externalDependencies.ts":
/*!**********************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/externalDependencies.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.onDidChangePythonSetting = exports.getPythonSetting = exports.getSubDirs = exports.isFile = exports.getFileInfo = exports.resolveSymbolicLink = exports.arePathsSame = exports.normCasePath = exports.resolvePath = exports.normalizePath = exports.isDirectory = exports.isParentPath = exports.untildify = exports.readFileSync = exports.readFile = exports.pathExistsSync = exports.pathExists = exports.isVirtualWorkspace = exports.exec = exports.shellExecute = exports.initializeExternalDependencies = void 0;
const fsapi = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const vscode = __webpack_require__(/*! vscode */ "vscode");
const types_1 = __webpack_require__(/*! ../../common/application/types */ "./src/client/common/application/types.ts");
const types_2 = __webpack_require__(/*! ../../common/process/types */ "./src/client/common/process/types.ts");
const types_3 = __webpack_require__(/*! ../../common/types */ "./src/client/common/types.ts");
const async_1 = __webpack_require__(/*! ../../common/utils/async */ "./src/client/common/utils/async.ts");
const platform_1 = __webpack_require__(/*! ../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
let internalServiceContainer;
function initializeExternalDependencies(serviceContainer) {
    internalServiceContainer = serviceContainer;
}
exports.initializeExternalDependencies = initializeExternalDependencies;
async function shellExecute(command, options = {}) {
    const service = await internalServiceContainer.get(types_2.IProcessServiceFactory).create();
    return service.shellExec(command, options);
}
exports.shellExecute = shellExecute;
async function exec(file, args, options = {}) {
    const service = await internalServiceContainer.get(types_2.IProcessServiceFactory).create();
    return service.exec(file, args, options);
}
exports.exec = exec;
function isVirtualWorkspace() {
    const service = internalServiceContainer.get(types_1.IWorkspaceService);
    return service.isVirtualWorkspace;
}
exports.isVirtualWorkspace = isVirtualWorkspace;
function pathExists(absPath) {
    return fsapi.pathExists(absPath);
}
exports.pathExists = pathExists;
function pathExistsSync(absPath) {
    return fsapi.pathExistsSync(absPath);
}
exports.pathExistsSync = pathExistsSync;
function readFile(filePath) {
    return fsapi.readFile(filePath, 'utf-8');
}
exports.readFile = readFile;
function readFileSync(filePath) {
    return fsapi.readFileSync(filePath, 'utf-8');
}
exports.readFileSync = readFileSync;
exports.untildify = __webpack_require__(/*! untildify */ "./node_modules/untildify/index.js");
function isParentPath(filePath, parentPath) {
    if (!parentPath.endsWith(path.sep)) {
        parentPath += path.sep;
    }
    if (!filePath.endsWith(path.sep)) {
        filePath += path.sep;
    }
    return normCasePath(filePath).startsWith(normCasePath(parentPath));
}
exports.isParentPath = isParentPath;
async function isDirectory(filename) {
    const stat = await fsapi.lstat(filename);
    return stat.isDirectory();
}
exports.isDirectory = isDirectory;
function normalizePath(filename) {
    return path.normalize(filename);
}
exports.normalizePath = normalizePath;
function resolvePath(filename) {
    return path.resolve(filename);
}
exports.resolvePath = resolvePath;
function normCasePath(filePath) {
    return (0, platform_1.getOSType)() === platform_1.OSType.Windows ? path.normalize(filePath).toUpperCase() : path.normalize(filePath);
}
exports.normCasePath = normCasePath;
function arePathsSame(path1, path2) {
    return normCasePath(path1) === normCasePath(path2);
}
exports.arePathsSame = arePathsSame;
async function resolveSymbolicLink(absPath, stats, count) {
    stats = stats !== null && stats !== void 0 ? stats : (await fsapi.lstat(absPath));
    if (stats.isSymbolicLink()) {
        if (count && count > 5) {
            (0, logging_1.traceError)(`Detected a potential symbolic link loop at ${absPath}, terminating resolution.`);
            return absPath;
        }
        const link = await fsapi.readlink(absPath);
        const absLinkPath = path.isAbsolute(link) ? link : path.resolve(path.dirname(absPath), link);
        count = count ? count + 1 : 1;
        return resolveSymbolicLink(absLinkPath, undefined, count);
    }
    return absPath;
}
exports.resolveSymbolicLink = resolveSymbolicLink;
async function getFileInfo(filePath) {
    try {
        const data = await fsapi.lstat(filePath);
        return {
            ctime: data.ctime.valueOf(),
            mtime: data.mtime.valueOf(),
        };
    }
    catch (ex) {
        (0, logging_1.traceVerbose)(`Failed to get file info for ${filePath}`, ex);
        return { ctime: -1, mtime: -1 };
    }
}
exports.getFileInfo = getFileInfo;
async function isFile(filePath) {
    const stats = await fsapi.lstat(filePath);
    if (stats.isSymbolicLink()) {
        const resolvedPath = await resolveSymbolicLink(filePath, stats);
        const resolvedStats = await fsapi.lstat(resolvedPath);
        return resolvedStats.isFile();
    }
    return stats.isFile();
}
exports.isFile = isFile;
async function* getSubDirs(root, options) {
    const dirContents = await fsapi.promises.readdir(root, { withFileTypes: true });
    const generators = dirContents.map((item) => {
        async function* generator() {
            const fullPath = path.join(root, item.name);
            if (item.isDirectory()) {
                yield fullPath;
            }
            else if ((options === null || options === void 0 ? void 0 : options.resolveSymlinks) && item.isSymbolicLink()) {
                const resolvedPath = await resolveSymbolicLink(fullPath);
                const resolvedPathStat = await fsapi.lstat(resolvedPath);
                if (resolvedPathStat.isDirectory()) {
                    yield resolvedPath;
                }
            }
        }
        return generator();
    });
    yield* (0, async_1.iterable)((0, async_1.chain)(generators));
}
exports.getSubDirs = getSubDirs;
function getPythonSetting(name) {
    const settings = internalServiceContainer.get(types_3.IConfigurationService).getSettings();
    return settings[name];
}
exports.getPythonSetting = getPythonSetting;
function onDidChangePythonSetting(name, callback) {
    return vscode.workspace.onDidChangeConfiguration((event) => {
        if (event.affectsConfiguration(`python.${name}`)) {
            callback();
        }
    });
}
exports.onDidChangePythonSetting = onDidChangePythonSetting;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/posixUtils.ts":
/*!************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/posixUtils.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPythonBinFromPosixPaths = exports.commonPosixBinPaths = exports.matchPythonBinFilename = exports.matchBasicPythonBinFilename = void 0;
const fs = __webpack_require__(/*! fs */ "fs");
const fsapi = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const exec_1 = __webpack_require__(/*! ../../common/utils/exec */ "./src/client/common/utils/exec.ts");
const externalDependencies_1 = __webpack_require__(/*! ./externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
function matchBasicPythonBinFilename(filename) {
    return path.basename(filename) === 'python';
}
exports.matchBasicPythonBinFilename = matchBasicPythonBinFilename;
function matchPythonBinFilename(filename) {
    const posixPythonBinPattern = /^python(\d+(\.\d+)?)?$/;
    return posixPythonBinPattern.test(path.basename(filename));
}
exports.matchPythonBinFilename = matchPythonBinFilename;
async function commonPosixBinPaths() {
    const searchPaths = (0, exec_1.getSearchPathEntries)();
    const paths = Array.from(new Set([
        '/bin',
        '/etc',
        '/lib',
        '/lib/x86_64-linux-gnu',
        '/lib64',
        '/sbin',
        '/snap/bin',
        '/usr/bin',
        '/usr/games',
        '/usr/include',
        '/usr/lib',
        '/usr/lib/x86_64-linux-gnu',
        '/usr/lib64',
        '/usr/libexec',
        '/usr/local',
        '/usr/local/bin',
        '/usr/local/etc',
        '/usr/local/games',
        '/usr/local/lib',
        '/usr/local/sbin',
        '/usr/sbin',
        '/usr/share',
        '~/.local/bin',
    ].concat(searchPaths)));
    const exists = await Promise.all(paths.map((p) => fsapi.pathExists(p)));
    return paths.filter((_, index) => exists[index]);
}
exports.commonPosixBinPaths = commonPosixBinPaths;
async function findPythonBinariesInDir(searchDir) {
    return (await fs.promises.readdir(searchDir, { withFileTypes: true }))
        .filter((dirent) => !dirent.isDirectory())
        .map((dirent) => path.join(searchDir, dirent.name))
        .filter(matchPythonBinFilename);
}
function pickShortestPath(pythonPaths) {
    let shortestLen = pythonPaths[0].length;
    let shortestPath = pythonPaths[0];
    for (const p of pythonPaths) {
        if (p.length <= shortestLen) {
            shortestLen = p.length;
            shortestPath = p;
        }
    }
    return shortestPath;
}
async function getPythonBinFromPosixPaths(searchDirs) {
    var _a;
    const binToLinkMap = new Map();
    for (const searchDir of searchDirs) {
        const paths = await findPythonBinariesInDir(searchDir).catch((ex) => {
            (0, logging_1.traceWarn)('Looking for python binaries within', searchDir, 'failed with', ex);
            return [];
        });
        for (const filepath of paths) {
            try {
                (0, logging_1.traceVerbose)(`Attempting to resolve symbolic link: ${filepath}`);
                const resolvedBin = await (0, externalDependencies_1.resolveSymbolicLink)(filepath);
                if (binToLinkMap.has(resolvedBin)) {
                    (_a = binToLinkMap.get(resolvedBin)) === null || _a === void 0 ? void 0 : _a.push(filepath);
                }
                else {
                    binToLinkMap.set(resolvedBin, [filepath]);
                }
                (0, logging_1.traceInfo)(`Found: ${filepath} --> ${resolvedBin}`);
            }
            catch (ex) {
                (0, logging_1.traceError)('Failed to resolve symbolic link: ', ex);
            }
        }
    }
    const keys = Array.from(binToLinkMap.keys());
    const pythonPaths = keys.map((key) => { var _a; return pickShortestPath([key, ...((_a = binToLinkMap.get(key)) !== null && _a !== void 0 ? _a : [])]); });
    return (0, lodash_1.uniq)(pythonPaths);
}
exports.getPythonBinFromPosixPaths = getPythonBinFromPosixPaths;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/pythonBinariesWatcher.ts":
/*!***********************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/pythonBinariesWatcher.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.resolvePythonExeGlobs = exports.PythonEnvStructure = exports.watchLocationForPythonBinaries = void 0;
const minimatch = __webpack_require__(/*! minimatch */ "./node_modules/minimatch/minimatch.js");
const path = __webpack_require__(/*! path */ "path");
const fileSystemWatcher_1 = __webpack_require__(/*! ../../common/platform/fileSystemWatcher */ "./src/client/common/platform/fileSystemWatcher.ts");
const platform_1 = __webpack_require__(/*! ../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const [executable, binName] = (0, platform_1.getOSType)() === platform_1.OSType.Windows ? ['python.exe', 'Scripts'] : ['python', 'bin'];
function watchLocationForPythonBinaries(baseDir, callback, executableGlob = executable) {
    const resolvedGlob = path.posix.normalize(executableGlob);
    const [baseGlob] = resolvedGlob.split('/').slice(-1);
    function callbackClosure(type, e) {
        (0, logging_1.traceVerbose)('Received event', type, JSON.stringify(e), 'for baseglob', baseGlob);
        const isMatch = minimatch(path.basename(e), baseGlob, { nocase: (0, platform_1.getOSType)() === platform_1.OSType.Windows });
        if (!isMatch) {
            return;
        }
        callback(type, e);
    }
    return (0, fileSystemWatcher_1.watchLocationForPattern)(baseDir, resolvedGlob, callbackClosure);
}
exports.watchLocationForPythonBinaries = watchLocationForPythonBinaries;
var PythonEnvStructure;
(function (PythonEnvStructure) {
    PythonEnvStructure["Standard"] = "standard";
    PythonEnvStructure["Flat"] = "flat";
})(PythonEnvStructure = exports.PythonEnvStructure || (exports.PythonEnvStructure = {}));
function resolvePythonExeGlobs(basenameGlob = executable, structure = PythonEnvStructure.Standard) {
    if (path.posix.normalize(basenameGlob).includes('/')) {
        throw Error(`invalid basename glob "${basenameGlob}"`);
    }
    const globs = [];
    if (structure === PythonEnvStructure.Standard) {
        globs.push(basenameGlob, `*/${basenameGlob}`, `*/${binName}/${basenameGlob}`);
    }
    else if (structure === PythonEnvStructure.Flat) {
        globs.push(basenameGlob);
    }
    return globs;
}
exports.resolvePythonExeGlobs = resolvePythonExeGlobs;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/windowsRegistry.ts":
/*!*****************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/windowsRegistry.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.readRegistryKeys = exports.readRegistryValues = exports.REG_SZ = exports.HKLM = exports.HKCU = void 0;
const winreg_1 = __webpack_require__(/*! winreg */ "./node_modules/winreg/lib/registry.js");
Object.defineProperty(exports, "HKCU", ({ enumerable: true, get: function () { return winreg_1.HKCU; } }));
Object.defineProperty(exports, "HKLM", ({ enumerable: true, get: function () { return winreg_1.HKLM; } }));
Object.defineProperty(exports, "REG_SZ", ({ enumerable: true, get: function () { return winreg_1.REG_SZ; } }));
const async_1 = __webpack_require__(/*! ../../common/utils/async */ "./src/client/common/utils/async.ts");
async function readRegistryValues(options) {
    const WinReg = __webpack_require__(/*! winreg */ "./node_modules/winreg/lib/registry.js");
    const regKey = new WinReg(options);
    const deferred = (0, async_1.createDeferred)();
    regKey.values((err, res) => {
        if (err) {
            deferred.reject(err);
        }
        deferred.resolve(res);
    });
    return deferred.promise;
}
exports.readRegistryValues = readRegistryValues;
async function readRegistryKeys(options) {
    const WinReg = __webpack_require__(/*! winreg */ "./node_modules/winreg/lib/registry.js");
    const regKey = new WinReg(options);
    const deferred = (0, async_1.createDeferred)();
    regKey.keys((err, res) => {
        if (err) {
            deferred.reject(err);
        }
        deferred.resolve(res);
    });
    return deferred.promise;
}
exports.readRegistryKeys = readRegistryKeys;


/***/ }),

/***/ "./src/client/pythonEnvironments/common/windowsUtils.ts":
/*!**************************************************************!*\
  !*** ./src/client/pythonEnvironments/common/windowsUtils.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getRegistryInterpreters = exports.getRegistryInterpretersSync = exports.getInterpreterDataFromRegistry = exports.matchPythonBinFilename = exports.matchBasicPythonBinFilename = void 0;
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const path = __webpack_require__(/*! path */ "path");
const constants_1 = __webpack_require__(/*! ../../common/constants */ "./src/client/common/constants.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const windowsRegistry_1 = __webpack_require__(/*! ./windowsRegistry */ "./src/client/pythonEnvironments/common/windowsRegistry.ts");
function matchBasicPythonBinFilename(filename) {
    return path.basename(filename).toLowerCase() === 'python.exe';
}
exports.matchBasicPythonBinFilename = matchBasicPythonBinFilename;
function matchPythonBinFilename(filename) {
    const windowsPythonExes = /^python(\d+(.\d+)?)?\.exe$/;
    return windowsPythonExes.test(path.basename(filename));
}
exports.matchPythonBinFilename = matchPythonBinFilename;
async function getInterpreterDataFromKey({ arch, hive, key }, distroOrgName) {
    const result = {
        interpreterPath: '',
        distroOrgName,
    };
    const values = await (0, windowsRegistry_1.readRegistryValues)({ arch, hive, key });
    for (const value of values) {
        switch (value.name) {
            case 'SysArchitecture':
                result.bitnessStr = value.value;
                break;
            case 'SysVersion':
                result.sysVersionStr = value.value;
                break;
            case 'Version':
                result.versionStr = value.value;
                break;
            case 'DisplayName':
                result.companyDisplayName = value.value;
                break;
            default:
                break;
        }
    }
    const subKeys = await (0, windowsRegistry_1.readRegistryKeys)({ arch, hive, key });
    const subKey = subKeys.map((s) => s.key).find((s) => s.endsWith('InstallPath'));
    if (subKey) {
        const subKeyValues = await (0, windowsRegistry_1.readRegistryValues)({ arch, hive, key: subKey });
        const value = subKeyValues.find((v) => v.name === 'ExecutablePath');
        if (value) {
            result.interpreterPath = value.value;
            if (value.type !== windowsRegistry_1.REG_SZ) {
                (0, logging_1.traceVerbose)(`Registry interpreter path type [${value.type}]: ${value.value}`);
            }
        }
    }
    if (result.interpreterPath.length > 0) {
        return result;
    }
    return undefined;
}
async function getInterpreterDataFromRegistry(arch, hive, key) {
    const subKeys = await (0, windowsRegistry_1.readRegistryKeys)({ arch, hive, key });
    const distroOrgName = key.substr(key.lastIndexOf('\\') + 1);
    const allData = await Promise.all(subKeys.map((subKey) => getInterpreterDataFromKey(subKey, distroOrgName)));
    return (allData.filter((data) => data !== undefined) || []);
}
exports.getInterpreterDataFromRegistry = getInterpreterDataFromRegistry;
let registryInterpretersCache;
function getRegistryInterpretersSync() {
    return !(0, constants_1.isTestExecution)() ? registryInterpretersCache : undefined;
}
exports.getRegistryInterpretersSync = getRegistryInterpretersSync;
let registryInterpretersPromise;
async function getRegistryInterpreters() {
    if (!(0, constants_1.isTestExecution)() && registryInterpretersPromise !== undefined) {
        return registryInterpretersPromise;
    }
    registryInterpretersPromise = getRegistryInterpretersImpl();
    return registryInterpretersPromise;
}
exports.getRegistryInterpreters = getRegistryInterpreters;
async function getRegistryInterpretersImpl() {
    let registryData = [];
    for (const arch of ['x64', 'x86']) {
        for (const hive of [windowsRegistry_1.HKLM, windowsRegistry_1.HKCU]) {
            const root = '\\SOFTWARE\\Python';
            let keys = [];
            try {
                keys = (await (0, windowsRegistry_1.readRegistryKeys)({ arch, hive, key: root })).map((k) => k.key);
            }
            catch (ex) {
                (0, logging_1.traceError)(`Failed to access Registry: ${arch}\\${hive}\\${root}`, ex);
            }
            for (const key of keys) {
                registryData = registryData.concat(await getInterpreterDataFromRegistry(arch, hive, key));
            }
        }
    }
    registryInterpretersCache = (0, lodash_1.uniqBy)(registryData, (r) => r.interpreterPath);
    return registryInterpretersCache;
}


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/common/commonUtils.ts":
/*!**********************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/common/commonUtils.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getVenvExecutable = exports.hasVenv = exports.getVenvPath = exports.showErrorMessageWithLogs = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const commandApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/commandApis */ "./src/client/common/vscodeApis/commandApis.ts");
const windowApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const platformService_1 = __webpack_require__(/*! ../../../common/platform/platformService */ "./src/client/common/platform/platformService.ts");
async function showErrorMessageWithLogs(message) {
    const result = await (0, windowApis_1.showErrorMessage)(message, localize_1.Common.openOutputPanel, localize_1.Common.selectPythonInterpreter);
    if (result === localize_1.Common.openOutputPanel) {
        await (0, commandApis_1.executeCommand)(constants_1.Commands.ViewOutput);
    }
    else if (result === localize_1.Common.selectPythonInterpreter) {
        await (0, commandApis_1.executeCommand)(constants_1.Commands.Set_Interpreter);
    }
}
exports.showErrorMessageWithLogs = showErrorMessageWithLogs;
function getVenvPath(workspaceFolder) {
    return path.join(workspaceFolder.uri.fsPath, '.venv');
}
exports.getVenvPath = getVenvPath;
async function hasVenv(workspaceFolder) {
    return fs.pathExists(getVenvPath(workspaceFolder));
}
exports.hasVenv = hasVenv;
function getVenvExecutable(workspaceFolder) {
    if ((0, platformService_1.isWindows)()) {
        return path.join(getVenvPath(workspaceFolder), 'Scripts', 'python.exe');
    }
    return path.join(getVenvPath(workspaceFolder), 'bin', 'python');
}
exports.getVenvExecutable = getVenvExecutable;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/common/workspaceSelection.ts":
/*!*****************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/common/workspaceSelection.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pickWorkspaceFolder = void 0;
const fsapi = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const windowApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const workspaceApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/workspaceApis */ "./src/client/common/vscodeApis/workspaceApis.ts");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const commandApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/commandApis */ "./src/client/common/vscodeApis/commandApis.ts");
function hasVirtualEnv(workspace) {
    return Promise.race([
        fsapi.pathExists(path.join(workspace.uri.fsPath, '.venv')),
        fsapi.pathExists(path.join(workspace.uri.fsPath, '.conda')),
    ]);
}
async function getWorkspacesForQuickPick(workspaces) {
    const items = [];
    for (const workspace of workspaces) {
        items.push({
            label: workspace.name,
            detail: workspace.uri.fsPath,
            description: (await hasVirtualEnv(workspace)) ? localize_1.CreateEnv.hasVirtualEnv : undefined,
        });
    }
    return items;
}
async function pickWorkspaceFolder(options, context) {
    const workspaces = (0, workspaceApis_1.getWorkspaceFolders)();
    if (!workspaces || workspaces.length === 0) {
        if (context === windowApis_1.MultiStepAction.Back) {
            throw windowApis_1.MultiStepAction.Back;
        }
        const result = await (0, windowApis_1.showErrorMessage)(localize_1.CreateEnv.noWorkspace, localize_1.Common.openFolder);
        if (result === localize_1.Common.openFolder) {
            await (0, commandApis_1.executeCommand)('vscode.openFolder');
        }
        return undefined;
    }
    if (workspaces.length === 1) {
        if (context === windowApis_1.MultiStepAction.Back) {
            throw windowApis_1.MultiStepAction.Back;
        }
        return workspaces[0];
    }
    const selected = await (0, windowApis_1.showQuickPickWithBack)(await getWorkspacesForQuickPick(workspaces), {
        placeHolder: localize_1.CreateEnv.pickWorkspacePlaceholder,
        ignoreFocusOut: true,
        canPickMany: options === null || options === void 0 ? void 0 : options.allowMultiSelect,
        matchOnDescription: true,
        matchOnDetail: true,
    }, options === null || options === void 0 ? void 0 : options.token);
    if (selected) {
        if (Array.isArray(selected)) {
            const details = selected.map((s) => s.detail).filter((s) => s !== undefined);
            return workspaces.filter((w) => details.includes(w.uri.fsPath));
        }
        return workspaces.filter((w) => w.uri.fsPath === selected.detail)[0];
    }
    return undefined;
}
exports.pickWorkspaceFolder = pickWorkspaceFolder;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/createEnvApi.ts":
/*!****************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/createEnvApi.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.buildEnvironmentCreationApi = exports.registerCreateEnvironmentFeatures = exports.isCreatingEnvironment = exports.onCreateEnvironmentExited = exports.onCreateEnvironmentStarted = exports.registerCreateEnvironmentProvider = exports._createEnvironmentProviders = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const constants_1 = __webpack_require__(/*! ../../common/constants */ "./src/client/common/constants.ts");
const commandApis_1 = __webpack_require__(/*! ../../common/vscodeApis/commandApis */ "./src/client/common/vscodeApis/commandApis.ts");
const createEnvironment_1 = __webpack_require__(/*! ./createEnvironment */ "./src/client/pythonEnvironments/creation/createEnvironment.ts");
const condaCreationProvider_1 = __webpack_require__(/*! ./provider/condaCreationProvider */ "./src/client/pythonEnvironments/creation/provider/condaCreationProvider.ts");
const venvCreationProvider_1 = __webpack_require__(/*! ./provider/venvCreationProvider */ "./src/client/pythonEnvironments/creation/provider/venvCreationProvider.ts");
const telemetry_1 = __webpack_require__(/*! ../../telemetry */ "./src/client/telemetry/index.ts");
const constants_2 = __webpack_require__(/*! ../../telemetry/constants */ "./src/client/telemetry/constants.ts");
class CreateEnvironmentProviders {
    constructor() {
        this._createEnvProviders = [];
        this._createEnvProviders = [];
    }
    add(provider) {
        if (this._createEnvProviders.filter((p) => p.id === provider.id).length > 0) {
            throw new Error(`Create Environment provider with id ${provider.id} already registered`);
        }
        this._createEnvProviders.push(provider);
    }
    remove(provider) {
        this._createEnvProviders = this._createEnvProviders.filter((p) => p !== provider);
    }
    getAll() {
        return this._createEnvProviders;
    }
}
exports._createEnvironmentProviders = new CreateEnvironmentProviders();
function registerCreateEnvironmentProvider(provider) {
    exports._createEnvironmentProviders.add(provider);
    return new vscode_1.Disposable(() => {
        exports._createEnvironmentProviders.remove(provider);
    });
}
exports.registerCreateEnvironmentProvider = registerCreateEnvironmentProvider;
_a = (0, createEnvironment_1.getCreationEvents)(), exports.onCreateEnvironmentStarted = _a.onCreateEnvironmentStarted, exports.onCreateEnvironmentExited = _a.onCreateEnvironmentExited, exports.isCreatingEnvironment = _a.isCreatingEnvironment;
function registerCreateEnvironmentFeatures(disposables, interpreterQuickPick) {
    disposables.push((0, commandApis_1.registerCommand)(constants_1.Commands.Create_Environment, (options) => {
        const providers = exports._createEnvironmentProviders.getAll();
        return (0, createEnvironment_1.handleCreateEnvironmentCommand)(providers, options);
    }), (0, commandApis_1.registerCommand)(constants_1.Commands.Create_Environment_Button, async () => {
        (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_BUTTON, undefined, undefined);
        await (0, commandApis_1.executeCommand)(constants_1.Commands.Create_Environment);
    }), registerCreateEnvironmentProvider(new venvCreationProvider_1.VenvCreationProvider(interpreterQuickPick)), registerCreateEnvironmentProvider((0, condaCreationProvider_1.condaCreationProvider)()));
}
exports.registerCreateEnvironmentFeatures = registerCreateEnvironmentFeatures;
function buildEnvironmentCreationApi() {
    return {
        onWillCreateEnvironment: exports.onCreateEnvironmentStarted,
        onDidCreateEnvironment: exports.onCreateEnvironmentExited,
        createEnvironment: async (options) => {
            const providers = exports._createEnvironmentProviders.getAll();
            try {
                return await (0, createEnvironment_1.handleCreateEnvironmentCommand)(providers, options);
            }
            catch (err) {
                return { path: undefined, workspaceFolder: undefined, action: undefined, error: err };
            }
        },
        registerCreateEnvironmentProvider: (provider) => registerCreateEnvironmentProvider(provider),
    };
}
exports.buildEnvironmentCreationApi = buildEnvironmentCreationApi;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/createEnvButtonContext.ts":
/*!**************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/createEnvButtonContext.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerCreateEnvironmentButtonFeatures = void 0;
const commandApis_1 = __webpack_require__(/*! ../../common/vscodeApis/commandApis */ "./src/client/common/vscodeApis/commandApis.ts");
const workspaceApis_1 = __webpack_require__(/*! ../../common/vscodeApis/workspaceApis */ "./src/client/common/vscodeApis/workspaceApis.ts");
async function setShowCreateEnvButtonContextKey() {
    const config = (0, workspaceApis_1.getConfiguration)('python');
    const showCreateEnvButton = config.get('createEnvironment.contentButton', 'show') === 'show';
    await (0, commandApis_1.executeCommand)('setContext', 'showCreateEnvButton', showCreateEnvButton);
}
function registerCreateEnvironmentButtonFeatures(disposables) {
    disposables.push((0, workspaceApis_1.onDidChangeConfiguration)(async () => {
        await setShowCreateEnvButtonContextKey();
    }));
    setShowCreateEnvButtonContextKey();
}
exports.registerCreateEnvironmentButtonFeatures = registerCreateEnvironmentButtonFeatures;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/createEnvironment.ts":
/*!*********************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/createEnvironment.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.handleCreateEnvironmentCommand = exports.getCreationEvents = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const localize_1 = __webpack_require__(/*! ../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const windowApis_1 = __webpack_require__(/*! ../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const onCreateEnvironmentStartedEvent = new vscode_1.EventEmitter();
const onCreateEnvironmentExitedEvent = new vscode_1.EventEmitter();
let startedEventCount = 0;
function isBusyCreatingEnvironment() {
    return startedEventCount > 0;
}
function fireStartedEvent(options) {
    onCreateEnvironmentStartedEvent.fire({ options });
    startedEventCount += 1;
}
function fireExitedEvent(result, options, error) {
    startedEventCount -= 1;
    if (result) {
        onCreateEnvironmentExitedEvent.fire({ options, ...result });
    }
    else if (error) {
        onCreateEnvironmentExitedEvent.fire({ options, error });
    }
}
function getCreationEvents() {
    return {
        onCreateEnvironmentStarted: onCreateEnvironmentStartedEvent.event,
        onCreateEnvironmentExited: onCreateEnvironmentExitedEvent.event,
        isCreatingEnvironment: isBusyCreatingEnvironment,
    };
}
exports.getCreationEvents = getCreationEvents;
async function createEnvironment(provider, options) {
    let result;
    let err;
    try {
        fireStartedEvent(options);
        result = await provider.createEnvironment(options);
    }
    catch (ex) {
        if (ex === vscode_1.QuickInputButtons.Back) {
            (0, logging_1.traceVerbose)('Create Env: User clicked back button during environment creation');
            if (!options.showBackButton) {
                return undefined;
            }
        }
        err = ex;
        throw err;
    }
    finally {
        fireExitedEvent(result, options, err);
    }
    return result;
}
async function showCreateEnvironmentQuickPick(providers, options) {
    const items = providers.map((p) => ({
        label: p.name,
        description: p.description,
        id: p.id,
    }));
    let selectedItem;
    if (options === null || options === void 0 ? void 0 : options.showBackButton) {
        selectedItem = await (0, windowApis_1.showQuickPickWithBack)(items, {
            placeHolder: localize_1.CreateEnv.providersQuickPickPlaceholder,
            matchOnDescription: true,
            ignoreFocusOut: true,
        });
    }
    else {
        selectedItem = await (0, windowApis_1.showQuickPick)(items, {
            placeHolder: localize_1.CreateEnv.providersQuickPickPlaceholder,
            matchOnDescription: true,
            ignoreFocusOut: true,
        });
    }
    if (selectedItem) {
        const selected = Array.isArray(selectedItem) ? selectedItem[0] : selectedItem;
        if (selected) {
            const selections = providers.filter((p) => p.id === selected.id);
            if (selections.length > 0) {
                return selections[0];
            }
        }
    }
    return undefined;
}
function getOptionsWithDefaults(options) {
    return {
        installPackages: true,
        ignoreSourceControl: true,
        showBackButton: false,
        selectEnvironment: true,
        ...options,
    };
}
async function handleCreateEnvironmentCommand(providers, options) {
    const optionsWithDefaults = getOptionsWithDefaults(options);
    if (!optionsWithDefaults.showBackButton && providers.length === 1) {
        optionsWithDefaults.showBackButton = false;
    }
    let selectedProvider = providers.length === 1 ? providers[0] : undefined;
    const envTypeStep = new windowApis_1.MultiStepNode(undefined, async (context) => {
        if (providers.length > 0) {
            try {
                selectedProvider = await showCreateEnvironmentQuickPick(providers, optionsWithDefaults);
            }
            catch (ex) {
                if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                    return ex;
                }
                throw ex;
            }
            if (!selectedProvider) {
                return windowApis_1.MultiStepAction.Cancel;
            }
        }
        else {
            (0, logging_1.traceError)('No Environment Creation providers were registered.');
            if (context === windowApis_1.MultiStepAction.Back) {
                return windowApis_1.MultiStepAction.Back;
            }
        }
        return windowApis_1.MultiStepAction.Continue;
    }, undefined);
    let result;
    const createStep = new windowApis_1.MultiStepNode(providers.length === 1 ? undefined : envTypeStep, async (context) => {
        if (context === windowApis_1.MultiStepAction.Back) {
            return windowApis_1.MultiStepAction.Back;
        }
        if (selectedProvider) {
            try {
                result = await createEnvironment(selectedProvider, optionsWithDefaults);
            }
            catch (ex) {
                if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                    return ex;
                }
                throw ex;
            }
        }
        return windowApis_1.MultiStepAction.Continue;
    }, undefined);
    envTypeStep.next = createStep;
    const action = await windowApis_1.MultiStepNode.run(providers.length === 1 ? createStep : envTypeStep);
    if (options === null || options === void 0 ? void 0 : options.showBackButton) {
        if (action === windowApis_1.MultiStepAction.Back || action === windowApis_1.MultiStepAction.Cancel) {
            result = { action, workspaceFolder: undefined, path: undefined, error: undefined };
        }
    }
    if (result) {
        return Object.freeze(result);
    }
    return undefined;
}
exports.handleCreateEnvironmentCommand = handleCreateEnvironmentCommand;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/condaCreationProvider.ts":
/*!**********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/condaCreationProvider.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.condaCreationProvider = void 0;
const fs_extra_1 = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const path = __webpack_require__(/*! path */ "path");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const workspaceSelection_1 = __webpack_require__(/*! ../common/workspaceSelection */ "./src/client/pythonEnvironments/creation/common/workspaceSelection.ts");
const rawProcessApis_1 = __webpack_require__(/*! ../../../common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const async_1 = __webpack_require__(/*! ../../../common/utils/async */ "./src/client/common/utils/async.ts");
const platform_1 = __webpack_require__(/*! ../../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const scripts_1 = __webpack_require__(/*! ../../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const condaUtils_1 = __webpack_require__(/*! ./condaUtils */ "./src/client/pythonEnvironments/creation/provider/condaUtils.ts");
const commonUtils_1 = __webpack_require__(/*! ../common/commonUtils */ "./src/client/pythonEnvironments/creation/common/commonUtils.ts");
const windowApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const constants_2 = __webpack_require__(/*! ../../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const telemetry_1 = __webpack_require__(/*! ../../../telemetry */ "./src/client/telemetry/index.ts");
const condaProgressAndTelemetry_1 = __webpack_require__(/*! ./condaProgressAndTelemetry */ "./src/client/pythonEnvironments/creation/provider/condaProgressAndTelemetry.ts");
const stringUtils_1 = __webpack_require__(/*! ../../../common/stringUtils */ "./src/client/common/stringUtils.ts");
function generateCommandArgs(version, options, name) {
    let addGitIgnore = true;
    let installPackages = true;
    if (options) {
        addGitIgnore = (options === null || options === void 0 ? void 0 : options.ignoreSourceControl) !== undefined ? options.ignoreSourceControl : true;
        installPackages = (options === null || options === void 0 ? void 0 : options.installPackages) !== undefined ? options.installPackages : true;
    }
    const command = [(0, scripts_1.createCondaScript)()];
    if (addGitIgnore) {
        command.push('--git-ignore');
    }
    if (name && (name || '').trim().length) {
        command.push('--name', name.toCommandArgumentForPythonMgrExt());
    }
    if (installPackages) {
        command.push('--install');
    }
    if (version) {
        command.push('--python');
        command.push(version);
    }
    return command;
}
function getCondaEnvFromOutput(output) {
    try {
        const envPath = output
            .split(/\r?\n/g)
            .map((s) => s.trim())
            .filter((s) => s.startsWith(condaProgressAndTelemetry_1.CONDA_ENV_CREATED_MARKER) || s.startsWith(condaProgressAndTelemetry_1.CONDA_ENV_EXISTING_MARKER))[0];
        if (envPath.includes(condaProgressAndTelemetry_1.CONDA_ENV_CREATED_MARKER)) {
            return envPath.substring(condaProgressAndTelemetry_1.CONDA_ENV_CREATED_MARKER.length);
        }
        return envPath.substring(condaProgressAndTelemetry_1.CONDA_ENV_EXISTING_MARKER.length);
    }
    catch (ex) {
        (0, logging_1.traceError)('Parsing out environment path failed.');
        return undefined;
    }
}
async function createCondaEnv(workspace, command, args, progress, token) {
    progress.report({
        message: localize_1.CreateEnv.Conda.creating,
    });
    const deferred = (0, async_1.createDeferred)();
    let pathEnv = (0, platform_1.getEnvironmentVariable)('PATH') || (0, platform_1.getEnvironmentVariable)('Path') || '';
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        const root = path.dirname(command);
        const libPath1 = path.join(root, 'Library', 'bin');
        const libPath2 = path.join(root, 'Library', 'mingw-w64', 'bin');
        const libPath3 = path.join(root, 'Library', 'usr', 'bin');
        const libPath4 = path.join(root, 'bin');
        const libPath5 = path.join(root, 'Scripts');
        const libPath = [libPath1, libPath2, libPath3, libPath4, libPath5].join(path.delimiter);
        pathEnv = `${libPath}${path.delimiter}${pathEnv}`;
    }
    (0, logging_1.traceLog)('Running Conda Env creation script: ', [command, ...args]);
    const { proc, out, dispose } = (0, rawProcessApis_1.execObservable)(command, args, {
        mergeStdOutErr: true,
        token,
        cwd: workspace.uri.fsPath,
        env: {
            PATH: pathEnv,
        },
    });
    const progressAndTelemetry = new condaProgressAndTelemetry_1.CondaProgressAndTelemetry(progress);
    let condaEnvPath;
    out.subscribe((value) => {
        const output = (0, stringUtils_1.splitLines)(value.out).join('\r\n');
        (0, logging_1.traceLog)(output);
        if (output.includes(condaProgressAndTelemetry_1.CONDA_ENV_CREATED_MARKER) || output.includes(condaProgressAndTelemetry_1.CONDA_ENV_EXISTING_MARKER)) {
            condaEnvPath = getCondaEnvFromOutput(output);
        }
        progressAndTelemetry.process(output);
    }, async (error) => {
        (0, logging_1.traceError)('Error while running conda env creation script: ', error);
        deferred.reject(error);
    }, () => {
        dispose();
        if ((proc === null || proc === void 0 ? void 0 : proc.exitCode) !== 0) {
            (0, logging_1.traceError)('Error while running venv creation script: ', progressAndTelemetry.getLastError());
            deferred.reject(progressAndTelemetry.getLastError() || `Conda env creation failed with exitCode: ${proc === null || proc === void 0 ? void 0 : proc.exitCode}`);
        }
        else {
            deferred.resolve(condaEnvPath);
        }
    });
    return deferred.promise;
}
function getExecutableCommand(condaBaseEnvPath) {
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        return path.join(condaBaseEnvPath, 'python.exe');
    }
    return path.join(condaBaseEnvPath, 'bin', 'python');
}
async function createEnvironment(options) {
    const conda = await (0, condaUtils_1.getCondaBaseEnv)();
    if (!conda) {
        return undefined;
    }
    let workspace;
    const workspaceStep = new windowApis_1.MultiStepNode(undefined, async (context) => {
        try {
            workspace = (await (0, workspaceSelection_1.pickWorkspaceFolder)(undefined, context));
        }
        catch (ex) {
            if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                return ex;
            }
            throw ex;
        }
        if (workspace === undefined) {
            (0, logging_1.traceError)('Workspace was not selected or found for creating conda environment.');
            return windowApis_1.MultiStepAction.Cancel;
        }
        (0, logging_1.traceInfo)(`Selected workspace ${workspace.uri.fsPath} for creating conda environment.`);
        return windowApis_1.MultiStepAction.Continue;
    }, undefined);
    let version;
    const versionStep = new windowApis_1.MultiStepNode(workspaceStep, async () => {
        try {
            version = await (0, condaUtils_1.pickPythonVersion)();
        }
        catch (ex) {
            if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                return ex;
            }
            throw ex;
        }
        if (version === undefined) {
            (0, logging_1.traceError)('Python version was not selected for creating conda environment.');
            return windowApis_1.MultiStepAction.Cancel;
        }
        (0, logging_1.traceInfo)(`Selected Python version ${version} for creating conda environment.`);
        return windowApis_1.MultiStepAction.Continue;
    }, undefined);
    workspaceStep.next = versionStep;
    let name = '.conda';
    const nameStep = new windowApis_1.MultiStepNode(versionStep, async () => new Promise((resolve) => {
        const input = vscode_1.window.createInputBox();
        input.title = 'Environment Name';
        input.value = '.conda';
        input.buttons = [vscode_1.QuickInputButtons.Back];
        input.onDidTriggerButton((e) => {
            if (e === vscode_1.QuickInputButtons.Back) {
                resolve(windowApis_1.MultiStepAction.Back);
                input.hide();
            }
        });
        input.onDidHide(() => {
            resolve(windowApis_1.MultiStepAction.Cancel);
            input.hide();
        });
        input.onDidAccept(async () => {
            const envName = input.value.trim();
            if (!envName.length) {
                input.validationMessage = 'Enter a valid name';
                return;
            }
            if (workspace) {
                const fullPath = vscode_1.Uri.joinPath(workspace.uri, envName);
                if (await (0, fs_extra_1.pathExists)(fullPath.fsPath)) {
                    input.validationMessage = 'Environment with the same name already exists';
                    return;
                }
            }
            name = envName;
            input.validationMessage = '';
            resolve(windowApis_1.MultiStepAction.Continue);
            input.hide();
        });
        input.show();
    }), undefined);
    versionStep.next = nameStep;
    const action = await windowApis_1.MultiStepNode.run(workspaceStep);
    if (action === windowApis_1.MultiStepAction.Back || action === windowApis_1.MultiStepAction.Cancel) {
        throw action;
    }
    return (0, windowApis_1.withProgress)({
        location: vscode_1.ProgressLocation.Notification,
        title: `${localize_1.CreateEnv.statusTitle} ([${localize_1.Common.showLogs}](command:${constants_1.Commands.ViewOutput}))`,
        cancellable: true,
    }, async (progress, token) => {
        progress.report({
            message: localize_1.CreateEnv.statusStarting,
        });
        let envPath;
        try {
            (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_CREATING, undefined, {
                environmentType: 'conda',
                pythonVersion: version,
            });
            if (workspace) {
                envPath = await createCondaEnv(workspace, getExecutableCommand(conda), generateCommandArgs(version, options, name), progress, token);
                if (envPath) {
                    return { path: envPath, workspaceFolder: workspace };
                }
                throw new Error('Failed to create conda environment. See Output > Python for more info.');
            }
            else {
                throw new Error('A workspace is needed to create conda environment');
            }
        }
        catch (ex) {
            (0, logging_1.traceError)(ex);
            (0, commonUtils_1.showErrorMessageWithLogs)(localize_1.CreateEnv.Conda.errorCreatingEnvironment);
            return { error: ex };
        }
    });
}
function condaCreationProvider() {
    return {
        createEnvironment,
        name: 'Conda',
        description: localize_1.CreateEnv.Conda.providerDescription,
        id: `${constants_1.PVSC_EXTENSION_ID}:conda`,
        tools: ['Conda'],
    };
}
exports.condaCreationProvider = condaCreationProvider;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/condaProgressAndTelemetry.ts":
/*!**************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/condaProgressAndTelemetry.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CondaProgressAndTelemetry = exports.CREATE_FAILED_INSTALL_YML = exports.CREATE_CONDA_INSTALLED_YML = exports.CREATE_CONDA_FAILED_MARKER = exports.CONDA_INSTALLING_YML = exports.CONDA_ENV_EXISTING_MARKER = exports.CONDA_ENV_CREATED_MARKER = void 0;
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const telemetry_1 = __webpack_require__(/*! ../../../telemetry */ "./src/client/telemetry/index.ts");
const constants_1 = __webpack_require__(/*! ../../../telemetry/constants */ "./src/client/telemetry/constants.ts");
exports.CONDA_ENV_CREATED_MARKER = 'CREATED_CONDA_ENV:';
exports.CONDA_ENV_EXISTING_MARKER = 'EXISTING_CONDA_ENV:';
exports.CONDA_INSTALLING_YML = 'CONDA_INSTALLING_YML:';
exports.CREATE_CONDA_FAILED_MARKER = 'CREATE_CONDA.ENV_FAILED_CREATION';
exports.CREATE_CONDA_INSTALLED_YML = 'CREATE_CONDA.INSTALLED_YML';
exports.CREATE_FAILED_INSTALL_YML = 'CREATE_CONDA.FAILED_INSTALL_YML';
class CondaProgressAndTelemetry {
    constructor(progress) {
        this.progress = progress;
        this.condaCreatedReported = false;
        this.condaFailedReported = false;
        this.condaInstallingPackagesReported = false;
        this.condaInstallingPackagesFailedReported = false;
        this.condaInstalledPackagesReported = false;
        this.lastError = undefined;
    }
    process(output) {
        if (!this.condaCreatedReported && output.includes(exports.CONDA_ENV_CREATED_MARKER)) {
            this.condaCreatedReported = true;
            this.progress.report({
                message: localize_1.CreateEnv.Conda.created,
            });
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVIRONMENT_CREATED, undefined, {
                environmentType: 'conda',
                reason: 'created',
            });
        }
        else if (!this.condaCreatedReported && output.includes(exports.CONDA_ENV_EXISTING_MARKER)) {
            this.condaCreatedReported = true;
            this.progress.report({
                message: localize_1.CreateEnv.Conda.created,
            });
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVIRONMENT_CREATED, undefined, {
                environmentType: 'conda',
                reason: 'existing',
            });
        }
        else if (!this.condaFailedReported && output.includes(exports.CREATE_CONDA_FAILED_MARKER)) {
            this.condaFailedReported = true;
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVIRONMENT_FAILED, undefined, {
                environmentType: 'conda',
                reason: 'other',
            });
            this.lastError = exports.CREATE_CONDA_FAILED_MARKER;
        }
        else if (!this.condaInstallingPackagesReported && output.includes(exports.CONDA_INSTALLING_YML)) {
            this.condaInstallingPackagesReported = true;
            this.progress.report({
                message: localize_1.CreateEnv.Conda.installingPackages,
            });
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVIRONMENT_INSTALLING_PACKAGES, undefined, {
                environmentType: 'conda',
                using: 'environment.yml',
            });
        }
        else if (!this.condaInstallingPackagesFailedReported && output.includes(exports.CREATE_FAILED_INSTALL_YML)) {
            this.condaInstallingPackagesFailedReported = true;
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVIRONMENT_INSTALLING_PACKAGES_FAILED, undefined, {
                environmentType: 'conda',
                using: 'environment.yml',
            });
            this.lastError = exports.CREATE_FAILED_INSTALL_YML;
        }
        else if (!this.condaInstalledPackagesReported && output.includes(exports.CREATE_CONDA_INSTALLED_YML)) {
            this.condaInstalledPackagesReported = true;
            (0, telemetry_1.sendTelemetryEvent)(constants_1.EventName.ENVIRONMENT_INSTALLED_PACKAGES, undefined, {
                environmentType: 'conda',
                using: 'environment.yml',
            });
        }
    }
    getLastError() {
        return this.lastError;
    }
}
exports.CondaProgressAndTelemetry = CondaProgressAndTelemetry;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/condaUtils.ts":
/*!***********************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/condaUtils.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pickPythonVersion = exports.getCondaBaseEnv = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const commandApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/commandApis */ "./src/client/common/vscodeApis/commandApis.ts");
const windowApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const conda_1 = __webpack_require__(/*! ../../common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const RECOMMENDED_CONDA_PYTHON = '3.10';
async function getCondaBaseEnv() {
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        const response = await (0, windowApis_1.showErrorMessage)(localize_1.CreateEnv.Conda.condaMissing, localize_1.Common.learnMore);
        if (response === localize_1.Common.learnMore) {
            await (0, commandApis_1.executeCommand)('vscode.open', vscode_1.Uri.parse('https://docs.anaconda.com/anaconda/install/'));
        }
        return undefined;
    }
    const envs = (await conda.getEnvList()).filter((e) => e.name === 'base');
    if (envs.length === 1) {
        return envs[0].prefix;
    }
    if (envs.length > 1) {
        (0, logging_1.traceLog)('Multiple conda base envs detected: ', envs.map((e) => e.prefix));
        return undefined;
    }
    return undefined;
}
exports.getCondaBaseEnv = getCondaBaseEnv;
async function pickPythonVersion(token) {
    const items = ['3.10', '3.11', '3.9', '3.8', '3.7'].map((v) => ({
        label: v === RECOMMENDED_CONDA_PYTHON ? `${constants_1.Octicons.Star} Python` : 'Python',
        description: v,
    }));
    const selection = await (0, windowApis_1.showQuickPickWithBack)(items, {
        placeHolder: localize_1.CreateEnv.Conda.selectPythonQuickPickPlaceholder,
        matchOnDescription: true,
        ignoreFocusOut: true,
    }, token);
    if (selection) {
        return selection.description;
    }
    return undefined;
}
exports.pickPythonVersion = pickPythonVersion;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/venvCreationProvider.ts":
/*!*********************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/venvCreationProvider.ts ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.canCreateVenv = exports.VenvCreationProvider = void 0;
const os = __webpack_require__(/*! os */ "os");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const scripts_1 = __webpack_require__(/*! ../../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const rawProcessApis_1 = __webpack_require__(/*! ../../../common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const async_1 = __webpack_require__(/*! ../../../common/utils/async */ "./src/client/common/utils/async.ts");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const workspaceSelection_1 = __webpack_require__(/*! ../common/workspaceSelection */ "./src/client/pythonEnvironments/creation/common/workspaceSelection.ts");
const info_1 = __webpack_require__(/*! ../../info */ "./src/client/pythonEnvironments/info/index.ts");
const windowApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const telemetry_1 = __webpack_require__(/*! ../../../telemetry */ "./src/client/telemetry/index.ts");
const constants_2 = __webpack_require__(/*! ../../../telemetry/constants */ "./src/client/telemetry/constants.ts");
const venvProgressAndTelemetry_1 = __webpack_require__(/*! ./venvProgressAndTelemetry */ "./src/client/pythonEnvironments/creation/provider/venvProgressAndTelemetry.ts");
const commonUtils_1 = __webpack_require__(/*! ../common/commonUtils */ "./src/client/pythonEnvironments/creation/common/commonUtils.ts");
const venvUtils_1 = __webpack_require__(/*! ./venvUtils */ "./src/client/pythonEnvironments/creation/provider/venvUtils.ts");
const multiStepInput_1 = __webpack_require__(/*! ../../../common/utils/multiStepInput */ "./src/client/common/utils/multiStepInput.ts");
const utils_1 = __webpack_require__(/*! ../../../../environments/utils */ "./src/environments/utils.ts");
function generateCommandArgs(installInfo, addGitIgnore) {
    var _a;
    const command = [(0, scripts_1.createVenvScript)()];
    if (addGitIgnore) {
        command.push('--git-ignore');
    }
    if (installInfo) {
        if (installInfo.some((i) => i.installType === 'toml')) {
            const source = (_a = installInfo.find((i) => i.installType === 'toml')) === null || _a === void 0 ? void 0 : _a.source;
            command.push('--toml', (source === null || source === void 0 ? void 0 : source.fileToCommandArgumentForPythonMgrExt()) || 'pyproject.toml');
        }
        const extras = installInfo.filter((i) => i.installType === 'toml').map((i) => i.installItem);
        extras.forEach((r) => {
            if (r) {
                command.push('--extras', r);
            }
        });
        const requirements = installInfo.filter((i) => i.installType === 'requirements').map((i) => i.installItem);
        requirements.forEach((r) => {
            if (r) {
                command.push('--requirements', r);
            }
        });
    }
    return command;
}
function getVenvFromOutput(output) {
    try {
        const envPath = output
            .split(/\r?\n/g)
            .map((s) => s.trim())
            .filter((s) => s.startsWith(venvProgressAndTelemetry_1.VENV_CREATED_MARKER) || s.startsWith(venvProgressAndTelemetry_1.VENV_EXISTING_MARKER))[0];
        if (envPath.includes(venvProgressAndTelemetry_1.VENV_CREATED_MARKER)) {
            return envPath.substring(venvProgressAndTelemetry_1.VENV_CREATED_MARKER.length);
        }
        return envPath.substring(venvProgressAndTelemetry_1.VENV_EXISTING_MARKER.length);
    }
    catch (ex) {
        (0, logging_1.traceError)('Parsing out environment path failed.');
        return undefined;
    }
}
async function createVenv(workspace, command, args, progress, token) {
    progress.report({
        message: localize_1.CreateEnv.Venv.creating,
    });
    (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_CREATING, undefined, {
        environmentType: 'venv',
        pythonVersion: undefined,
    });
    const deferred = (0, async_1.createDeferred)();
    (0, logging_1.traceLog)('Running Env creation script: ', [command, ...args]);
    const { proc, out, dispose } = (0, rawProcessApis_1.execObservable)(command, args, {
        mergeStdOutErr: true,
        token,
        cwd: workspace.uri.fsPath,
    });
    const progressAndTelemetry = new venvProgressAndTelemetry_1.VenvProgressAndTelemetry(progress);
    let venvPath;
    out.subscribe((value) => {
        const output = value.out.split(/\r?\n/g).join(os.EOL);
        (0, logging_1.traceLog)(output);
        if (output.includes(venvProgressAndTelemetry_1.VENV_CREATED_MARKER) || output.includes(venvProgressAndTelemetry_1.VENV_EXISTING_MARKER)) {
            venvPath = getVenvFromOutput(output);
        }
        progressAndTelemetry.process(output);
    }, (error) => {
        (0, logging_1.traceError)('Error while running venv creation script: ', error);
        deferred.reject(error);
    }, () => {
        dispose();
        if ((proc === null || proc === void 0 ? void 0 : proc.exitCode) !== 0) {
            (0, logging_1.traceError)('Error while running venv creation script: ', progressAndTelemetry.getLastError());
            deferred.reject(progressAndTelemetry.getLastError() ||
                `Failed to create virtual environment with exitCode: ${proc === null || proc === void 0 ? void 0 : proc.exitCode}`);
        }
        else {
            deferred.resolve(venvPath);
        }
    });
    return deferred.promise;
}
class VenvCreationProvider {
    constructor(interpreterQuickPick) {
        this.interpreterQuickPick = interpreterQuickPick;
        this.name = 'Venv';
        this.description = localize_1.CreateEnv.Venv.providerDescription;
        this.id = `${constants_1.PVSC_EXTENSION_ID}:venv`;
        this.tools = ['Venv'];
    }
    async createEnvironment(options) {
        let workspace;
        const workspaceStep = new windowApis_1.MultiStepNode(undefined, async (context) => {
            try {
                workspace = (await (0, workspaceSelection_1.pickWorkspaceFolder)(undefined, context));
            }
            catch (ex) {
                if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                    return ex;
                }
                throw ex;
            }
            if (workspace === undefined) {
                (0, logging_1.traceError)('Workspace was not selected or found for creating virtual environment.');
                return windowApis_1.MultiStepAction.Cancel;
            }
            (0, logging_1.traceInfo)(`Selected workspace ${workspace.uri.fsPath} for creating virtual environment.`);
            return windowApis_1.MultiStepAction.Continue;
        }, undefined);
        let existingVenvAction;
        const existingEnvStep = new windowApis_1.MultiStepNode(workspaceStep, async (context) => {
            if (workspace && context === windowApis_1.MultiStepAction.Continue) {
                try {
                    existingVenvAction = await (0, venvUtils_1.pickExistingVenvAction)(workspace);
                    return windowApis_1.MultiStepAction.Continue;
                }
                catch (ex) {
                    if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                        return ex;
                    }
                    throw ex;
                }
            }
            else if (context === windowApis_1.MultiStepAction.Back) {
                return windowApis_1.MultiStepAction.Back;
            }
            return windowApis_1.MultiStepAction.Continue;
        }, undefined);
        workspaceStep.next = existingEnvStep;
        let interpreter;
        const interpreterStep = new windowApis_1.MultiStepNode(existingEnvStep, async (context) => {
            if (workspace) {
                if (existingVenvAction === venvUtils_1.ExistingVenvAction.Recreate ||
                    existingVenvAction === venvUtils_1.ExistingVenvAction.Create) {
                    try {
                        interpreter = await this.interpreterQuickPick.getInterpreterViaQuickPick(workspace.uri, (i) => [
                            info_1.EnvironmentType.System,
                            info_1.EnvironmentType.MicrosoftStore,
                            info_1.EnvironmentType.Global,
                            info_1.EnvironmentType.Pyenv,
                            info_1.EnvironmentType.Unknown,
                        ].includes((0, utils_1.getEnvironmentType)(i)), {
                            skipRecommended: true,
                            showBackButton: true,
                            placeholder: localize_1.CreateEnv.Venv.selectPythonPlaceHolder,
                            title: null,
                        });
                    }
                    catch (ex) {
                        if (ex === multiStepInput_1.InputFlowAction.back) {
                            return windowApis_1.MultiStepAction.Back;
                        }
                        interpreter = undefined;
                    }
                }
                else if (existingVenvAction === venvUtils_1.ExistingVenvAction.UseExisting) {
                    if (context === windowApis_1.MultiStepAction.Back) {
                        return windowApis_1.MultiStepAction.Back;
                    }
                    interpreter = (0, commonUtils_1.getVenvExecutable)(workspace);
                }
            }
            if (!interpreter) {
                (0, logging_1.traceError)('Virtual env creation requires an interpreter.');
                return windowApis_1.MultiStepAction.Cancel;
            }
            (0, logging_1.traceInfo)(`Selected interpreter ${interpreter} for creating virtual environment.`);
            return windowApis_1.MultiStepAction.Continue;
        }, undefined);
        existingEnvStep.next = interpreterStep;
        let addGitIgnore = true;
        let installPackages = true;
        if (options) {
            addGitIgnore = (options === null || options === void 0 ? void 0 : options.ignoreSourceControl) !== undefined ? options.ignoreSourceControl : true;
            installPackages = (options === null || options === void 0 ? void 0 : options.installPackages) !== undefined ? options.installPackages : true;
        }
        let installInfo;
        const packagesStep = new windowApis_1.MultiStepNode(interpreterStep, async (context) => {
            if (workspace && installPackages) {
                if (existingVenvAction !== venvUtils_1.ExistingVenvAction.UseExisting) {
                    try {
                        installInfo = await (0, venvUtils_1.pickPackagesToInstall)(workspace);
                    }
                    catch (ex) {
                        if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                            return ex;
                        }
                        throw ex;
                    }
                    if (!installInfo) {
                        (0, logging_1.traceVerbose)('Virtual env creation exited during dependencies selection.');
                        return windowApis_1.MultiStepAction.Cancel;
                    }
                }
                else if (context === windowApis_1.MultiStepAction.Back) {
                    return windowApis_1.MultiStepAction.Back;
                }
            }
            return windowApis_1.MultiStepAction.Continue;
        }, undefined);
        interpreterStep.next = packagesStep;
        const action = await windowApis_1.MultiStepNode.run(workspaceStep);
        if (action === windowApis_1.MultiStepAction.Back || action === windowApis_1.MultiStepAction.Cancel) {
            throw action;
        }
        if (workspace) {
            if (existingVenvAction === venvUtils_1.ExistingVenvAction.Recreate) {
                (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_DELETE, undefined, {
                    environmentType: 'venv',
                    status: 'triggered',
                });
                if (await (0, venvUtils_1.deleteEnvironment)(workspace, interpreter)) {
                    (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_DELETE, undefined, {
                        environmentType: 'venv',
                        status: 'deleted',
                    });
                }
                else {
                    (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_DELETE, undefined, {
                        environmentType: 'venv',
                        status: 'failed',
                    });
                    throw windowApis_1.MultiStepAction.Cancel;
                }
            }
            else if (existingVenvAction === venvUtils_1.ExistingVenvAction.UseExisting) {
                (0, telemetry_1.sendTelemetryEvent)(constants_2.EventName.ENVIRONMENT_REUSE, undefined, {
                    environmentType: 'venv',
                });
                return { path: (0, commonUtils_1.getVenvExecutable)(workspace), workspaceFolder: workspace };
            }
        }
        const args = generateCommandArgs(installInfo, addGitIgnore);
        return (0, windowApis_1.withProgress)({
            location: vscode_1.ProgressLocation.Notification,
            title: `${localize_1.CreateEnv.statusTitle} ([${localize_1.Common.showLogs}](command:${constants_1.Commands.ViewOutput}))`,
            cancellable: true,
        }, async (progress, token) => {
            progress.report({
                message: localize_1.CreateEnv.statusStarting,
            });
            let envPath;
            try {
                if (interpreter && workspace) {
                    envPath = await createVenv(workspace, interpreter, args, progress, token);
                    if (envPath) {
                        return { path: envPath, workspaceFolder: workspace };
                    }
                    throw new Error('Failed to create virtual environment. See Output > Python for more info.');
                }
                throw new Error('Failed to create virtual environment. Either interpreter or workspace is undefined.');
            }
            catch (ex) {
                (0, logging_1.traceError)(ex);
                (0, commonUtils_1.showErrorMessageWithLogs)(localize_1.CreateEnv.Venv.errorCreatingEnvironment);
                return { error: ex };
            }
        });
    }
}
exports.VenvCreationProvider = VenvCreationProvider;
function canCreateVenv(environments) {
    return environments.some((i) => [
        info_1.EnvironmentType.System,
        info_1.EnvironmentType.MicrosoftStore,
        info_1.EnvironmentType.Global,
        info_1.EnvironmentType.Pyenv,
        info_1.EnvironmentType.Unknown,
    ].includes((0, utils_1.getEnvironmentType)(i)));
}
exports.canCreateVenv = canCreateVenv;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/venvDeleteUtils.ts":
/*!****************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/venvDeleteUtils.ts ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.deleteEnvironmentWindows = exports.deleteEnvironmentNonWindows = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const commonUtils_1 = __webpack_require__(/*! ../common/commonUtils */ "./src/client/pythonEnvironments/creation/common/commonUtils.ts");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const async_1 = __webpack_require__(/*! ../../../common/utils/async */ "./src/client/common/utils/async.ts");
const venvSwitchPython_1 = __webpack_require__(/*! ./venvSwitchPython */ "./src/client/pythonEnvironments/creation/provider/venvSwitchPython.ts");
async function tryDeleteFile(file) {
    try {
        if (!(await fs.pathExists(file))) {
            return true;
        }
        await fs.unlink(file);
        return true;
    }
    catch (err) {
        (0, logging_1.traceError)(`Failed to delete file [${file}]:`, err);
        return false;
    }
}
async function tryDeleteDir(dir) {
    try {
        if (!(await fs.pathExists(dir))) {
            return true;
        }
        await fs.rmdir(dir, {
            recursive: true,
            maxRetries: 10,
            retryDelay: 200,
        });
        return true;
    }
    catch (err) {
        (0, logging_1.traceError)(`Failed to delete directory [${dir}]:`, err);
        return false;
    }
}
async function deleteEnvironmentNonWindows(workspaceFolder) {
    const venvPath = (0, commonUtils_1.getVenvPath)(workspaceFolder);
    if (await tryDeleteDir(venvPath)) {
        (0, logging_1.traceInfo)(`Deleted venv dir: ${venvPath}`);
        return true;
    }
    (0, commonUtils_1.showErrorMessageWithLogs)(localize_1.CreateEnv.Venv.errorDeletingEnvironment);
    return false;
}
exports.deleteEnvironmentNonWindows = deleteEnvironmentNonWindows;
async function deleteEnvironmentWindows(workspaceFolder, interpreter) {
    const venvPath = (0, commonUtils_1.getVenvPath)(workspaceFolder);
    const venvPythonPath = path.join(venvPath, 'Scripts', 'python.exe');
    if (await tryDeleteFile(venvPythonPath)) {
        (0, logging_1.traceInfo)(`Deleted python executable: ${venvPythonPath}`);
        if (await tryDeleteDir(venvPath)) {
            (0, logging_1.traceInfo)(`Deleted ".venv" dir: ${venvPath}`);
            return true;
        }
        (0, logging_1.traceError)(`Failed to delete ".venv" dir: ${venvPath}`);
        (0, logging_1.traceError)('This happens if the virtual environment is still in use, or some binary in the venv is still running.');
        (0, logging_1.traceError)(`Please delete the ".venv" manually: [${venvPath}]`);
        (0, commonUtils_1.showErrorMessageWithLogs)(localize_1.CreateEnv.Venv.errorDeletingEnvironment);
        return false;
    }
    (0, logging_1.traceError)(`Failed to delete python executable: ${venvPythonPath}`);
    (0, logging_1.traceError)('This happens if the virtual environment is still in use.');
    if (interpreter) {
        (0, logging_1.traceError)('We will attempt to switch python temporarily to delete the ".venv"');
        await (0, venvSwitchPython_1.switchSelectedPython)(interpreter, workspaceFolder.uri, 'temporarily to delete the ".venv"');
        (0, logging_1.traceInfo)(`Attempting to delete ".venv" again: ${venvPath}`);
        const ms = 500;
        for (let i = 0; i < 5; i = i + 1) {
            (0, logging_1.traceInfo)(`Waiting for ${ms}ms to let processes exit, before a delete attempt.`);
            await (0, async_1.sleep)(ms);
            if (await tryDeleteDir(venvPath)) {
                (0, logging_1.traceInfo)(`Deleted ".venv" dir: ${venvPath}`);
                return true;
            }
            (0, logging_1.traceError)(`Failed to delete ".venv" dir [${venvPath}] (attempt ${i + 1}/5).`);
        }
    }
    else {
        (0, logging_1.traceError)(`Please delete the ".venv" dir manually: [${venvPath}]`);
    }
    (0, commonUtils_1.showErrorMessageWithLogs)(localize_1.CreateEnv.Venv.errorDeletingEnvironment);
    return false;
}
exports.deleteEnvironmentWindows = deleteEnvironmentWindows;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/venvProgressAndTelemetry.ts":
/*!*************************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/venvProgressAndTelemetry.ts ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VenvProgressAndTelemetry = exports.VENV_EXISTING_MARKER = exports.VENV_CREATED_MARKER = void 0;
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
exports.VENV_CREATED_MARKER = 'CREATED_VENV:';
exports.VENV_EXISTING_MARKER = 'EXISTING_VENV:';
const INSTALLING_REQUIREMENTS = 'VENV_INSTALLING_REQUIREMENTS:';
const INSTALLING_PYPROJECT = 'VENV_INSTALLING_PYPROJECT:';
const PIP_NOT_INSTALLED_MARKER = 'CREATE_VENV.PIP_NOT_FOUND';
const VENV_NOT_INSTALLED_MARKER = 'CREATE_VENV.VENV_NOT_FOUND';
const INSTALL_REQUIREMENTS_FAILED_MARKER = 'CREATE_VENV.PIP_FAILED_INSTALL_REQUIREMENTS';
const INSTALL_PYPROJECT_FAILED_MARKER = 'CREATE_VENV.PIP_FAILED_INSTALL_PYPROJECT';
const CREATE_VENV_FAILED_MARKER = 'CREATE_VENV.VENV_FAILED_CREATION';
const VENV_ALREADY_EXISTS_MARKER = 'CREATE_VENV.VENV_ALREADY_EXISTS';
const INSTALLED_REQUIREMENTS_MARKER = 'CREATE_VENV.PIP_INSTALLED_REQUIREMENTS';
const INSTALLED_PYPROJECT_MARKER = 'CREATE_VENV.PIP_INSTALLED_PYPROJECT';
const UPGRADE_PIP_FAILED_MARKER = 'CREATE_VENV.UPGRADE_PIP_FAILED';
const UPGRADING_PIP_MARKER = 'CREATE_VENV.UPGRADING_PIP';
const UPGRADED_PIP_MARKER = 'CREATE_VENV.UPGRADED_PIP';
const CREATING_MICROVENV_MARKER = 'CREATE_MICROVENV.CREATING_MICROVENV';
const CREATE_MICROVENV_FAILED_MARKER = 'CREATE_VENV.MICROVENV_FAILED_CREATION';
const CREATE_MICROVENV_FAILED_MARKER2 = 'CREATE_MICROVENV.MICROVENV_FAILED_CREATION';
const MICROVENV_CREATED_MARKER = 'CREATE_MICROVENV.CREATED_MICROVENV';
const INSTALLING_PIP_MARKER = 'CREATE_VENV.INSTALLING_PIP';
const INSTALL_PIP_FAILED_MARKER = 'CREATE_VENV.INSTALL_PIP_FAILED';
const DOWNLOADING_PIP_MARKER = 'CREATE_VENV.DOWNLOADING_PIP';
const DOWNLOAD_PIP_FAILED_MARKER = 'CREATE_VENV.DOWNLOAD_PIP_FAILED';
const DISTUTILS_NOT_INSTALLED_MARKER = 'CREATE_VENV.DISTUTILS_NOT_INSTALLED';
class VenvProgressAndTelemetry {
    constructor(progress) {
        this.progress = progress;
        this.processed = new Set();
        this.reportActions = new Map([
            [
                exports.VENV_CREATED_MARKER,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.created });
                    return undefined;
                },
            ],
            [
                exports.VENV_EXISTING_MARKER,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.existing });
                    return undefined;
                },
            ],
            [
                INSTALLING_REQUIREMENTS,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.installingPackages });
                    return undefined;
                },
            ],
            [
                INSTALLING_PYPROJECT,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.installingPackages });
                    return undefined;
                },
            ],
            [
                PIP_NOT_INSTALLED_MARKER,
                (_progress) => PIP_NOT_INSTALLED_MARKER,
            ],
            [
                DISTUTILS_NOT_INSTALLED_MARKER,
                (_progress) => VENV_NOT_INSTALLED_MARKER,
            ],
            [
                VENV_NOT_INSTALLED_MARKER,
                (_progress) => VENV_NOT_INSTALLED_MARKER,
            ],
            [
                INSTALL_REQUIREMENTS_FAILED_MARKER,
                (_progress) => INSTALL_REQUIREMENTS_FAILED_MARKER,
            ],
            [
                INSTALL_PYPROJECT_FAILED_MARKER,
                (_progress) => INSTALL_PYPROJECT_FAILED_MARKER,
            ],
            [
                CREATE_VENV_FAILED_MARKER,
                (_progress) => CREATE_VENV_FAILED_MARKER,
            ],
            [
                VENV_ALREADY_EXISTS_MARKER,
                (_progress) => undefined,
            ],
            [
                INSTALLED_REQUIREMENTS_MARKER,
                (_progress) => undefined,
            ],
            [
                INSTALLED_PYPROJECT_MARKER,
                (_progress) => undefined,
            ],
            [
                UPGRADED_PIP_MARKER,
                (_progress) => undefined,
            ],
            [
                UPGRADE_PIP_FAILED_MARKER,
                (_progress) => UPGRADE_PIP_FAILED_MARKER,
            ],
            [
                DOWNLOADING_PIP_MARKER,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.downloadingPip });
                    return undefined;
                },
            ],
            [
                DOWNLOAD_PIP_FAILED_MARKER,
                (_progress) => DOWNLOAD_PIP_FAILED_MARKER,
            ],
            [
                INSTALLING_PIP_MARKER,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.installingPip });
                    return undefined;
                },
            ],
            [
                INSTALL_PIP_FAILED_MARKER,
                (_progress) => INSTALL_PIP_FAILED_MARKER,
            ],
            [
                CREATING_MICROVENV_MARKER,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.creatingMicrovenv });
                    return undefined;
                },
            ],
            [
                CREATE_MICROVENV_FAILED_MARKER,
                (_progress) => CREATE_MICROVENV_FAILED_MARKER,
            ],
            [
                CREATE_MICROVENV_FAILED_MARKER2,
                (_progress) => CREATE_MICROVENV_FAILED_MARKER2,
            ],
            [
                MICROVENV_CREATED_MARKER,
                (_progress) => undefined,
            ],
            [
                UPGRADING_PIP_MARKER,
                (progress) => {
                    progress.report({ message: localize_1.CreateEnv.Venv.upgradingPip });
                    return undefined;
                },
            ],
        ]);
        this.lastError = undefined;
    }
    getLastError() {
        return this.lastError;
    }
    process(output) {
        const keys = Array.from(this.reportActions.keys());
        for (const key of keys) {
            if (output.includes(key) && !this.processed.has(key)) {
                const action = this.reportActions.get(key);
                if (action) {
                    const err = action(this.progress);
                    if (err) {
                        this.lastError = err;
                    }
                }
                this.processed.add(key);
            }
        }
    }
}
exports.VenvProgressAndTelemetry = VenvProgressAndTelemetry;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/venvSwitchPython.ts":
/*!*****************************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/venvSwitchPython.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.switchSelectedPython = void 0;
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const async_1 = __webpack_require__(/*! ../../../common/utils/async */ "./src/client/common/utils/async.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
async function switchSelectedPython(interpreter, uri, purpose) {
    var _a;
    let dispose;
    try {
        const deferred = (0, async_1.createDeferred)();
        const api = (_a = vscode_1.extensions.getExtension(python_extension_1.PVSC_EXTENSION_ID)) === null || _a === void 0 ? void 0 : _a.exports;
        if (!api) {
            throw new Error('Api not exported by Python extension');
        }
        dispose = api.environments.onDidChangeActiveEnvironmentPath(async (e) => {
            if (path.normalize(e.path) === path.normalize(interpreter)) {
                (0, logging_1.traceInfo)(`Switched to interpreter ${purpose}: ${interpreter}`);
                deferred.resolve();
            }
        });
        api.environments.updateActiveEnvironmentPath(interpreter, uri);
        (0, logging_1.traceInfo)(`Switching interpreter ${purpose}: ${interpreter}`);
        await deferred.promise;
    }
    finally {
        dispose === null || dispose === void 0 ? void 0 : dispose.dispose();
    }
}
exports.switchSelectedPython = switchSelectedPython;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/provider/venvUtils.ts":
/*!**********************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/provider/venvUtils.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pickExistingVenvAction = exports.ExistingVenvAction = exports.deleteEnvironment = exports.pickPackagesToInstall = exports.isPipInstallableToml = void 0;
const tomljs = __webpack_require__(/*! @iarna/toml */ "./node_modules/@iarna/toml/toml.js");
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const localize_1 = __webpack_require__(/*! ../../../common/utils/localize */ "./src/client/common/utils/localize.ts");
const windowApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/windowApis */ "./src/client/common/vscodeApis/windowApis.ts");
const workspaceApis_1 = __webpack_require__(/*! ../../../common/vscodeApis/workspaceApis */ "./src/client/common/vscodeApis/workspaceApis.ts");
const logging_1 = __webpack_require__(/*! ../../../logging */ "./src/client/logging/index.ts");
const constants_1 = __webpack_require__(/*! ../../../common/constants */ "./src/client/common/constants.ts");
const platformService_1 = __webpack_require__(/*! ../../../common/platform/platformService */ "./src/client/common/platform/platformService.ts");
const commonUtils_1 = __webpack_require__(/*! ../common/commonUtils */ "./src/client/pythonEnvironments/creation/common/commonUtils.ts");
const venvDeleteUtils_1 = __webpack_require__(/*! ./venvDeleteUtils */ "./src/client/pythonEnvironments/creation/provider/venvDeleteUtils.ts");
const exclude = '**/{.venv*,.git,.nox,.tox,.conda,site-packages,__pypackages__}/**';
async function getPipRequirementsFiles(workspaceFolder, token) {
    const files = (0, lodash_1.flatten)(await Promise.all([
        (0, workspaceApis_1.findFiles)(new vscode_1.RelativePattern(workspaceFolder, '**/*requirement*.txt'), exclude, undefined, token),
        (0, workspaceApis_1.findFiles)(new vscode_1.RelativePattern(workspaceFolder, '**/requirements/*.txt'), exclude, undefined, token),
    ])).map((u) => u.fsPath);
    return files;
}
function tomlParse(content) {
    try {
        return tomljs.parse(content);
    }
    catch (err) {
        (0, logging_1.traceError)('Failed to parse `pyproject.toml`:', err);
    }
    return {};
}
function tomlHasBuildSystem(toml) {
    return toml['build-system'] !== undefined;
}
function getTomlOptionalDeps(toml) {
    const extras = [];
    if (toml.project && toml.project['optional-dependencies']) {
        const deps = toml.project['optional-dependencies'];
        for (const key of Object.keys(deps)) {
            extras.push(key);
        }
    }
    return extras;
}
async function pickTomlExtras(extras, token) {
    const items = extras.map((e) => ({ label: e }));
    const selection = await (0, windowApis_1.showQuickPickWithBack)(items, {
        placeHolder: localize_1.CreateEnv.Venv.tomlExtrasQuickPickTitle,
        canPickMany: true,
        ignoreFocusOut: true,
    }, token);
    if (selection && (0, lodash_1.isArray)(selection)) {
        return selection.map((s) => s.label);
    }
    return undefined;
}
async function pickRequirementsFiles(files, token) {
    const items = files
        .sort((a, b) => {
        const al = a.split(/[\\\/]/).length;
        const bl = b.split(/[\\\/]/).length;
        if (al === bl) {
            if (a.length === b.length) {
                return a.localeCompare(b);
            }
            return a.length - b.length;
        }
        return al - bl;
    })
        .map((e) => ({ label: e }));
    const selection = await (0, windowApis_1.showQuickPickWithBack)(items, {
        placeHolder: localize_1.CreateEnv.Venv.requirementsQuickPickTitle,
        ignoreFocusOut: true,
        canPickMany: true,
    }, token);
    if (selection && (0, lodash_1.isArray)(selection)) {
        return selection.map((s) => s.label);
    }
    return undefined;
}
function isPipInstallableToml(tomlContent) {
    const toml = tomlParse(tomlContent);
    return tomlHasBuildSystem(toml);
}
exports.isPipInstallableToml = isPipInstallableToml;
async function pickPackagesToInstall(workspaceFolder, token) {
    const tomlPath = path.join(workspaceFolder.uri.fsPath, 'pyproject.toml');
    const packages = [];
    const tomlStep = new windowApis_1.MultiStepNode(undefined, async (context) => {
        (0, logging_1.traceVerbose)(`Looking for toml pyproject.toml with optional dependencies at: ${tomlPath}`);
        let extras = [];
        let hasBuildSystem = false;
        if (await fs.pathExists(tomlPath)) {
            const toml = tomlParse(await fs.readFile(tomlPath, 'utf-8'));
            extras = getTomlOptionalDeps(toml);
            hasBuildSystem = tomlHasBuildSystem(toml);
            if (!hasBuildSystem) {
                (0, logging_1.traceVerbose)('Create env: Found toml without build system. So we will not use editable install.');
            }
            if (extras.length === 0) {
                (0, logging_1.traceVerbose)('Create env: Found toml without optional dependencies.');
            }
        }
        else if (context === windowApis_1.MultiStepAction.Back) {
            return windowApis_1.MultiStepAction.Back;
        }
        if (hasBuildSystem) {
            if (extras.length > 0) {
                (0, logging_1.traceVerbose)('Create Env: Found toml with optional dependencies.');
                try {
                    const installList = await pickTomlExtras(extras, token);
                    if (installList) {
                        if (installList.length > 0) {
                            installList.forEach((i) => {
                                packages.push({ installType: 'toml', installItem: i, source: tomlPath });
                            });
                        }
                        packages.push({ installType: 'toml', source: tomlPath });
                    }
                    else {
                        return windowApis_1.MultiStepAction.Cancel;
                    }
                }
                catch (ex) {
                    if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                        return ex;
                    }
                    throw ex;
                }
            }
            else if (context === windowApis_1.MultiStepAction.Back) {
                return windowApis_1.MultiStepAction.Back;
            }
            else {
                packages.push({ installType: 'toml', source: tomlPath });
            }
        }
        else if (context === windowApis_1.MultiStepAction.Back) {
            return windowApis_1.MultiStepAction.Back;
        }
        return windowApis_1.MultiStepAction.Continue;
    }, undefined);
    const requirementsStep = new windowApis_1.MultiStepNode(tomlStep, async (context) => {
        var _a;
        (0, logging_1.traceVerbose)('Looking for pip requirements.');
        const requirementFiles = (_a = (await getPipRequirementsFiles(workspaceFolder, token))) === null || _a === void 0 ? void 0 : _a.map((p) => path.relative(workspaceFolder.uri.fsPath, p));
        if (requirementFiles && requirementFiles.length > 0) {
            (0, logging_1.traceVerbose)('Found pip requirements.');
            try {
                const result = await pickRequirementsFiles(requirementFiles, token);
                const installList = result === null || result === void 0 ? void 0 : result.map((p) => path.join(workspaceFolder.uri.fsPath, p));
                if (installList) {
                    installList.forEach((i) => {
                        packages.push({ installType: 'requirements', installItem: i });
                    });
                }
                else {
                    return windowApis_1.MultiStepAction.Cancel;
                }
            }
            catch (ex) {
                if (ex === windowApis_1.MultiStepAction.Back || ex === windowApis_1.MultiStepAction.Cancel) {
                    return ex;
                }
                throw ex;
            }
        }
        else if (context === windowApis_1.MultiStepAction.Back) {
            return windowApis_1.MultiStepAction.Back;
        }
        return windowApis_1.MultiStepAction.Continue;
    }, undefined);
    tomlStep.next = requirementsStep;
    const action = await windowApis_1.MultiStepNode.run(tomlStep);
    if (action === windowApis_1.MultiStepAction.Back || action === windowApis_1.MultiStepAction.Cancel) {
        throw action;
    }
    return packages;
}
exports.pickPackagesToInstall = pickPackagesToInstall;
async function deleteEnvironment(workspaceFolder, interpreter) {
    const venvPath = (0, commonUtils_1.getVenvPath)(workspaceFolder);
    return (0, windowApis_1.withProgress)({
        location: vscode_1.ProgressLocation.Notification,
        title: `${localize_1.CreateEnv.Venv.deletingEnvironmentProgress} ([${localize_1.Common.showLogs}](command:${constants_1.Commands.ViewOutput})): ${venvPath}`,
        cancellable: false,
    }, async () => {
        if ((0, platformService_1.isWindows)()) {
            return (0, venvDeleteUtils_1.deleteEnvironmentWindows)(workspaceFolder, interpreter);
        }
        return (0, venvDeleteUtils_1.deleteEnvironmentNonWindows)(workspaceFolder);
    });
}
exports.deleteEnvironment = deleteEnvironment;
var ExistingVenvAction;
(function (ExistingVenvAction) {
    ExistingVenvAction[ExistingVenvAction["Recreate"] = 0] = "Recreate";
    ExistingVenvAction[ExistingVenvAction["UseExisting"] = 1] = "UseExisting";
    ExistingVenvAction[ExistingVenvAction["Create"] = 2] = "Create";
})(ExistingVenvAction = exports.ExistingVenvAction || (exports.ExistingVenvAction = {}));
async function pickExistingVenvAction(workspaceFolder) {
    if (workspaceFolder) {
        if (await (0, commonUtils_1.hasVenv)(workspaceFolder)) {
            const items = [
                { label: localize_1.CreateEnv.Venv.recreate, description: localize_1.CreateEnv.Venv.recreateDescription },
                {
                    label: localize_1.CreateEnv.Venv.useExisting,
                    description: localize_1.CreateEnv.Venv.useExistingDescription,
                },
            ];
            const selection = (await (0, windowApis_1.showQuickPickWithBack)(items, {
                placeHolder: localize_1.CreateEnv.Venv.existingVenvQuickPickPlaceholder,
                ignoreFocusOut: true,
            }, undefined));
            if ((selection === null || selection === void 0 ? void 0 : selection.label) === localize_1.CreateEnv.Venv.recreate) {
                return ExistingVenvAction.Recreate;
            }
            if ((selection === null || selection === void 0 ? void 0 : selection.label) === localize_1.CreateEnv.Venv.useExisting) {
                return ExistingVenvAction.UseExisting;
            }
        }
        else {
            return ExistingVenvAction.Create;
        }
    }
    throw windowApis_1.MultiStepAction.Cancel;
}
exports.pickExistingVenvAction = pickExistingVenvAction;


/***/ }),

/***/ "./src/client/pythonEnvironments/creation/registrations.ts":
/*!*****************************************************************!*\
  !*** ./src/client/pythonEnvironments/creation/registrations.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerAllCreateEnvironmentFeatures = void 0;
const createEnvApi_1 = __webpack_require__(/*! ./createEnvApi */ "./src/client/pythonEnvironments/creation/createEnvApi.ts");
const createEnvButtonContext_1 = __webpack_require__(/*! ./createEnvButtonContext */ "./src/client/pythonEnvironments/creation/createEnvButtonContext.ts");
function registerAllCreateEnvironmentFeatures(disposables, interpreterQuickPick) {
    (0, createEnvApi_1.registerCreateEnvironmentFeatures)(disposables, interpreterQuickPick);
    (0, createEnvButtonContext_1.registerCreateEnvironmentButtonFeatures)(disposables);
}
exports.registerAllCreateEnvironmentFeatures = registerAllCreateEnvironmentFeatures;


/***/ }),

/***/ "./src/client/pythonEnvironments/exec.ts":
/*!***********************************************!*\
  !*** ./src/client/pythonEnvironments/exec.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.copyPythonExecInfo = exports.buildPythonExecInfo = void 0;
function buildPythonExecInfo(python, pythonArgs, pythonExecutable) {
    if (Array.isArray(python)) {
        const args = python.slice(1);
        if (pythonArgs) {
            args.push(...pythonArgs);
        }
        return {
            args,
            command: python[0],
            python: [...python],
            pythonExecutable: pythonExecutable !== null && pythonExecutable !== void 0 ? pythonExecutable : python[python.length - 1],
        };
    }
    return {
        command: python,
        args: pythonArgs || [],
        python: [python],
        pythonExecutable: python,
    };
}
exports.buildPythonExecInfo = buildPythonExecInfo;
function copyPythonExecInfo(orig, extraPythonArgs) {
    const info = {
        command: orig.command,
        args: [...orig.args],
        python: [...orig.python],
        pythonExecutable: orig.pythonExecutable,
    };
    if (extraPythonArgs) {
        info.args.push(...extraPythonArgs);
    }
    if (info.pythonExecutable === undefined) {
        info.pythonExecutable = info.python[info.python.length - 1];
    }
    return info;
}
exports.copyPythonExecInfo = copyPythonExecInfo;


/***/ }),

/***/ "./src/client/pythonEnvironments/index.ts":
/*!************************************************!*\
  !*** ./src/client/pythonEnvironments/index.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = exports.initialize = void 0;
const vscode = __webpack_require__(/*! vscode */ "vscode");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const persistentState_1 = __webpack_require__(/*! ../common/persistentState */ "./src/client/common/persistentState.ts");
const platform_1 = __webpack_require__(/*! ../common/utils/platform */ "./src/client/common/utils/platform.ts");
const envsReducer_1 = __webpack_require__(/*! ./base/locators/composite/envsReducer */ "./src/client/pythonEnvironments/base/locators/composite/envsReducer.ts");
const envsResolver_1 = __webpack_require__(/*! ./base/locators/composite/envsResolver */ "./src/client/pythonEnvironments/base/locators/composite/envsResolver.ts");
const windowsKnownPathsLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/windowsKnownPathsLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/windowsKnownPathsLocator.ts");
const workspaceVirtualEnvLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/workspaceVirtualEnvLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/workspaceVirtualEnvLocator.ts");
const externalDependencies_1 = __webpack_require__(/*! ./common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const wrappers_1 = __webpack_require__(/*! ./base/locators/wrappers */ "./src/client/pythonEnvironments/base/locators/wrappers.ts");
const customVirtualEnvLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/customVirtualEnvLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/customVirtualEnvLocator.ts");
const condaLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/condaLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/condaLocator.ts");
const globalVirtualEnvronmentLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/globalVirtualEnvronmentLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/globalVirtualEnvronmentLocator.ts");
const posixKnownPathsLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/posixKnownPathsLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/posixKnownPathsLocator.ts");
const pyenvLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/pyenvLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/pyenvLocator.ts");
const windowsRegistryLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/windowsRegistryLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/windowsRegistryLocator.ts");
const microsoftStoreLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/microsoftStoreLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/microsoftStoreLocator.ts");
const environmentInfoService_1 = __webpack_require__(/*! ./base/info/environmentInfoService */ "./src/client/pythonEnvironments/base/info/environmentInfoService.ts");
const legacyIOC_1 = __webpack_require__(/*! ./legacyIOC */ "./src/client/pythonEnvironments/legacyIOC.ts");
const poetryLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/poetryLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/poetryLocator.ts");
const api_1 = __webpack_require__(/*! ./api */ "./src/client/pythonEnvironments/api.ts");
const envsCollectionCache_1 = __webpack_require__(/*! ./base/locators/composite/envsCollectionCache */ "./src/client/pythonEnvironments/base/locators/composite/envsCollectionCache.ts");
const envsCollectionService_1 = __webpack_require__(/*! ./base/locators/composite/envsCollectionService */ "./src/client/pythonEnvironments/base/locators/composite/envsCollectionService.ts");
const logging_1 = __webpack_require__(/*! ../logging */ "./src/client/logging/index.ts");
const activeStateLocator_1 = __webpack_require__(/*! ./base/locators/lowLevel/activeStateLocator */ "./src/client/pythonEnvironments/base/locators/lowLevel/activeStateLocator.ts");
async function initialize(ext) {
    (0, externalDependencies_1.initializeExternalDependencies)(ext.legacyIOC.serviceContainer);
    const api = await (0, api_1.createPythonEnvironments)(() => createLocator(ext));
    (0, legacyIOC_1.registerNewDiscoveryForIOC)(ext.legacyIOC.serviceManager, api);
    return api;
}
exports.initialize = initialize;
async function activate(api, ext) {
    const folders = vscode.workspace.workspaceFolders;
    const wasTriggered = (0, persistentState_1.getGlobalStorage)(ext.context, 'PYTHON_ENV_INFO_CACHE', []).get().length > 0;
    if (!wasTriggered) {
        api.triggerRefresh().ignoreErrors();
        folders === null || folders === void 0 ? void 0 : folders.forEach(async (folder) => {
            const wasTriggeredForFolder = (0, persistentState_1.getGlobalStorage)(ext.context, `PYTHON_WAS_DISCOVERY_TRIGGERED_${(0, externalDependencies_1.normCasePath)(folder.uri.fsPath)}`, false);
            await wasTriggeredForFolder.set(true);
        });
    }
    else {
        folders === null || folders === void 0 ? void 0 : folders.forEach(async (folder) => {
            const wasTriggeredForFolder = (0, persistentState_1.getGlobalStorage)(ext.context, `PYTHON_WAS_DISCOVERY_TRIGGERED_${(0, externalDependencies_1.normCasePath)(folder.uri.fsPath)}`, false);
            if (!wasTriggeredForFolder.get()) {
                api.triggerRefresh({
                    searchLocations: { roots: [folder.uri], doNotIncludeNonRooted: true },
                }).ignoreErrors();
                await wasTriggeredForFolder.set(true);
            }
        });
    }
    return {
        fullyReady: Promise.resolve(),
    };
}
exports.activate = activate;
async function createLocator(ext) {
    const locators = new wrappers_1.ExtensionLocators(createNonWorkspaceLocators(ext), createWorkspaceLocator(ext));
    const envInfoService = (0, environmentInfoService_1.getEnvironmentInfoService)(ext.disposables);
    const reducer = new envsReducer_1.PythonEnvsReducer(locators);
    const resolvingLocator = new envsResolver_1.PythonEnvsResolver(reducer, envInfoService);
    const caching = new envsCollectionService_1.EnvsCollectionService(await createCollectionCache(ext), resolvingLocator);
    return caching;
}
function createNonWorkspaceLocators(ext) {
    const locators = [];
    locators.push(new pyenvLocator_1.PyenvLocator(), new condaLocator_1.CondaEnvironmentLocator(), new activeStateLocator_1.ActiveStateLocator(), new globalVirtualEnvronmentLocator_1.GlobalVirtualEnvironmentLocator(), new customVirtualEnvLocator_1.CustomVirtualEnvironmentLocator());
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        locators.push(new windowsRegistryLocator_1.WindowsRegistryLocator(), new microsoftStoreLocator_1.MicrosoftStoreLocator(), new windowsKnownPathsLocator_1.WindowsPathEnvVarLocator());
    }
    else {
        locators.push(new posixKnownPathsLocator_1.PosixKnownPathsLocator());
    }
    const disposables = locators.filter((d) => d.dispose !== undefined);
    ext.disposables.push(...disposables);
    return locators;
}
function watchRoots(args) {
    const { initRoot, addRoot, removeRoot } = args;
    const folders = vscode.workspace.workspaceFolders;
    if (folders) {
        folders.map((f) => f.uri).forEach(initRoot);
    }
    return vscode.workspace.onDidChangeWorkspaceFolders((event) => {
        for (const root of event.removed) {
            removeRoot(root.uri);
        }
        for (const root of event.added) {
            addRoot(root.uri);
        }
    });
}
function createWorkspaceLocator(ext) {
    const locators = new wrappers_1.WorkspaceLocators(watchRoots, [
        (root) => [new workspaceVirtualEnvLocator_1.WorkspaceVirtualEnvironmentLocator(root.fsPath), new poetryLocator_1.PoetryLocator(root.fsPath)],
    ]);
    ext.disposables.push(locators);
    return locators;
}
function getFromStorage(storage) {
    return storage.get().map((e) => {
        if (e.searchLocation) {
            if (typeof e.searchLocation === 'string') {
                e.searchLocation = vscode_1.Uri.parse(e.searchLocation);
            }
            else if ('scheme' in e.searchLocation && 'path' in e.searchLocation) {
                e.searchLocation = vscode_1.Uri.parse(`${e.searchLocation.scheme}://${e.searchLocation.path}`);
            }
            else {
                (0, logging_1.traceError)('Unexpected search location', JSON.stringify(e.searchLocation));
            }
        }
        return e;
    });
}
function putIntoStorage(storage, envs) {
    storage.set((0, lodash_1.cloneDeep)(envs).map((e) => {
        if (e.searchLocation) {
            e.searchLocation = e.searchLocation.toString();
        }
        return e;
    }));
    return Promise.resolve();
}
async function createCollectionCache(ext) {
    const storage = (0, persistentState_1.getGlobalStorage)(ext.context, 'PYTHON_ENV_INFO_CACHE', []);
    const cache = await (0, envsCollectionCache_1.createCollectionCache)({
        get: () => getFromStorage(storage),
        store: async (e) => putIntoStorage(storage, e),
    });
    return cache;
}


/***/ }),

/***/ "./src/client/pythonEnvironments/info/executable.ts":
/*!**********************************************************!*\
  !*** ./src/client/pythonEnvironments/info/executable.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getExecutablePath = void 0;
const python_1 = __webpack_require__(/*! ../../common/process/internal/python */ "./src/client/common/process/internal/python.ts");
const logging_1 = __webpack_require__(/*! ../../logging */ "./src/client/logging/index.ts");
const exec_1 = __webpack_require__(/*! ../exec */ "./src/client/pythonEnvironments/exec.ts");
async function getExecutablePath(python, shellExec) {
    try {
        const [args, parse] = (0, python_1.getExecutable)();
        const info = (0, exec_1.copyPythonExecInfo)(python, args);
        const argv = [info.command, ...info.args];
        const quoted = argv.reduce((p, c) => (p ? `${p} ${c.toCommandArgumentForPythonMgrExt()}` : `${c.toCommandArgumentForPythonMgrExt()}`), '');
        const result = await shellExec(quoted, { timeout: 15000 });
        const executable = parse(result.stdout.trim());
        if (executable === '') {
            throw new Error(`${quoted} resulted in empty stdout`);
        }
        return executable;
    }
    catch (ex) {
        (0, logging_1.traceError)(ex);
        return undefined;
    }
}
exports.getExecutablePath = getExecutablePath;


/***/ }),

/***/ "./src/client/pythonEnvironments/info/index.ts":
/*!*****************************************************!*\
  !*** ./src/client/pythonEnvironments/info/index.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnvironmentTypeName = exports.ModuleInstallerType = exports.virtualEnvTypes = exports.EnvironmentType = void 0;
var EnvironmentType;
(function (EnvironmentType) {
    EnvironmentType["Unknown"] = "Unknown";
    EnvironmentType["Conda"] = "Conda";
    EnvironmentType["VirtualEnv"] = "VirtualEnv";
    EnvironmentType["Pipenv"] = "PipEnv";
    EnvironmentType["Pyenv"] = "Pyenv";
    EnvironmentType["Venv"] = "Venv";
    EnvironmentType["MicrosoftStore"] = "MicrosoftStore";
    EnvironmentType["Poetry"] = "Poetry";
    EnvironmentType["VirtualEnvWrapper"] = "VirtualEnvWrapper";
    EnvironmentType["ActiveState"] = "ActiveState";
    EnvironmentType["Global"] = "Global";
    EnvironmentType["System"] = "System";
})(EnvironmentType = exports.EnvironmentType || (exports.EnvironmentType = {}));
exports.virtualEnvTypes = [
    EnvironmentType.Poetry,
    EnvironmentType.Pipenv,
    EnvironmentType.Venv,
    EnvironmentType.VirtualEnvWrapper,
    EnvironmentType.Conda,
    EnvironmentType.VirtualEnv,
];
var ModuleInstallerType;
(function (ModuleInstallerType) {
    ModuleInstallerType["Unknown"] = "Unknown";
    ModuleInstallerType["Conda"] = "Conda";
    ModuleInstallerType["Pip"] = "Pip";
    ModuleInstallerType["Poetry"] = "Poetry";
    ModuleInstallerType["Pipenv"] = "Pipenv";
})(ModuleInstallerType = exports.ModuleInstallerType || (exports.ModuleInstallerType = {}));
function getEnvironmentTypeName(environmentType) {
    switch (environmentType) {
        case EnvironmentType.Conda: {
            return 'conda';
        }
        case EnvironmentType.Pipenv: {
            return 'pipenv';
        }
        case EnvironmentType.Pyenv: {
            return 'pyenv';
        }
        case EnvironmentType.Venv: {
            return 'venv';
        }
        case EnvironmentType.VirtualEnv: {
            return 'virtualenv';
        }
        case EnvironmentType.MicrosoftStore: {
            return 'microsoft store';
        }
        case EnvironmentType.Poetry: {
            return 'poetry';
        }
        case EnvironmentType.VirtualEnvWrapper: {
            return 'virtualenvwrapper';
        }
        case EnvironmentType.ActiveState: {
            return 'activestate';
        }
        default: {
            return '';
        }
    }
}
exports.getEnvironmentTypeName = getEnvironmentTypeName;


/***/ }),

/***/ "./src/client/pythonEnvironments/info/interpreter.ts":
/*!***********************************************************!*\
  !*** ./src/client/pythonEnvironments/info/interpreter.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getInterpreterInfo = void 0;
const semver_1 = __webpack_require__(/*! semver */ "./node_modules/semver/semver.js");
const scripts_1 = __webpack_require__(/*! ../../common/process/internal/scripts */ "./src/client/common/process/internal/scripts/index.ts");
const stringUtils_1 = __webpack_require__(/*! ../../common/stringUtils */ "./src/client/common/stringUtils.ts");
const platform_1 = __webpack_require__(/*! ../../common/utils/platform */ "./src/client/common/utils/platform.ts");
const exec_1 = __webpack_require__(/*! ../exec */ "./src/client/pythonEnvironments/exec.ts");
function extractInterpreterInfo(python, raw) {
    let rawVersion = `${raw.versionInfo.slice(0, 3).join('.')}`;
    if (raw.versionInfo[3] !== undefined && ['alpha', 'beta', 'candidate'].includes(raw.versionInfo[3])) {
        rawVersion = `${rawVersion}-${raw.versionInfo[3]}`;
        if (raw.versionInfo[4] !== undefined) {
            let serial = -1;
            try {
                serial = parseInt(`${raw.versionInfo[4]}`, 10);
            }
            catch (ex) {
                serial = -1;
            }
            rawVersion = serial >= 0 ? `${rawVersion}${serial}` : rawVersion;
        }
    }
    return {
        architecture: raw.is64Bit ? platform_1.Architecture.x64 : platform_1.Architecture.x86,
        path: python,
        version: new semver_1.SemVer(rawVersion),
        sysVersion: raw.sysVersion,
        sysPrefix: raw.sysPrefix,
    };
}
async function getInterpreterInfo(python, shellExec, logger) {
    const [args, parse] = (0, scripts_1.interpreterInfo)();
    const info = (0, exec_1.copyPythonExecInfo)(python, args);
    const argv = [info.command, ...info.args];
    const quoted = argv.reduce((p, c) => (p ? `${p} "${c}"` : `"${(0, stringUtils_1.replaceAll)(c, '\\', '\\\\')}"`), '');
    const result = await shellExec(quoted, { timeout: 15000 });
    if (result.stderr) {
        if (logger) {
            logger.error(`Failed to parse interpreter information for ${argv} stderr: ${result.stderr}`);
        }
    }
    const json = parse(result.stdout);
    if (logger) {
        logger.verbose(`Found interpreter for ${argv}`);
    }
    if (!json) {
        return undefined;
    }
    return extractInterpreterInfo(python.pythonExecutable, json);
}
exports.getInterpreterInfo = getInterpreterInfo;


/***/ }),

/***/ "./src/client/pythonEnvironments/legacyIOC.ts":
/*!****************************************************!*\
  !*** ./src/client/pythonEnvironments/legacyIOC.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerNewDiscoveryForIOC = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const lodash_1 = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
const vscode = __webpack_require__(/*! vscode */ "vscode");
const fileSystemWatcher_1 = __webpack_require__(/*! ../common/platform/fileSystemWatcher */ "./src/client/common/platform/fileSystemWatcher.ts");
const contracts_1 = __webpack_require__(/*! ../interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const info_1 = __webpack_require__(/*! ./base/info */ "./src/client/pythonEnvironments/base/info/index.ts");
const macDefault_1 = __webpack_require__(/*! ./common/environmentManagers/macDefault */ "./src/client/pythonEnvironments/common/environmentManagers/macDefault.ts");
const externalDependencies_1 = __webpack_require__(/*! ./common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const info_2 = __webpack_require__(/*! ./info */ "./src/client/pythonEnvironments/info/index.ts");
const pythonVersion_1 = __webpack_require__(/*! ./base/info/pythonVersion */ "./src/client/pythonEnvironments/base/info/pythonVersion.ts");
const async_1 = __webpack_require__(/*! ../common/utils/async */ "./src/client/common/utils/async.ts");
const arrayUtils_1 = __webpack_require__(/*! ../common/utils/arrayUtils */ "./src/client/common/utils/arrayUtils.ts");
const conda_1 = __webpack_require__(/*! ./common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const microsoftStoreEnv_1 = __webpack_require__(/*! ./common/environmentManagers/microsoftStoreEnv */ "./src/client/pythonEnvironments/common/environmentManagers/microsoftStoreEnv.ts");
const condaService_1 = __webpack_require__(/*! ./common/environmentManagers/condaService */ "./src/client/pythonEnvironments/common/environmentManagers/condaService.ts");
const logging_1 = __webpack_require__(/*! ../logging */ "./src/client/logging/index.ts");
const convertedKinds = new Map(Object.entries({
    [info_1.PythonEnvKind.OtherGlobal]: info_2.EnvironmentType.Global,
    [info_1.PythonEnvKind.System]: info_2.EnvironmentType.System,
    [info_1.PythonEnvKind.MicrosoftStore]: info_2.EnvironmentType.MicrosoftStore,
    [info_1.PythonEnvKind.Pyenv]: info_2.EnvironmentType.Pyenv,
    [info_1.PythonEnvKind.Conda]: info_2.EnvironmentType.Conda,
    [info_1.PythonEnvKind.VirtualEnv]: info_2.EnvironmentType.VirtualEnv,
    [info_1.PythonEnvKind.Pipenv]: info_2.EnvironmentType.Pipenv,
    [info_1.PythonEnvKind.Poetry]: info_2.EnvironmentType.Poetry,
    [info_1.PythonEnvKind.Venv]: info_2.EnvironmentType.Venv,
    [info_1.PythonEnvKind.VirtualEnvWrapper]: info_2.EnvironmentType.VirtualEnvWrapper,
    [info_1.PythonEnvKind.ActiveState]: info_2.EnvironmentType.ActiveState,
}));
function convertEnvInfo(info) {
    const { name, location, executable, arch, kind, version, distro, id } = info;
    const { filename, sysPrefix } = executable;
    const env = {
        id,
        sysPrefix,
        envType: info_2.EnvironmentType.Unknown,
        envName: name,
        envPath: location,
        path: filename,
        architecture: arch,
    };
    const envType = convertedKinds.get(kind);
    if (envType !== undefined) {
        env.envType = envType;
    }
    if (version !== undefined) {
        const { release, sysVersion } = version;
        if (release === undefined) {
            env.sysVersion = '';
        }
        else {
            env.sysVersion = sysVersion;
        }
        const semverLikeVersion = (0, pythonVersion_1.toSemverLikeVersion)(version);
        env.version = semverLikeVersion;
    }
    if (distro !== undefined && distro.org !== '') {
        env.companyDisplayName = distro.org;
    }
    env.displayName = info.display;
    env.detailedDisplayName = info.detailedDisplayName;
    env.type = info.type;
    return env;
}
let ComponentAdapter = class ComponentAdapter {
    constructor(api) {
        this.api = api;
        this.changed = new vscode.EventEmitter();
        this.api.onChanged((event) => {
            this.changed.fire({
                type: event.type,
                new: event.new ? convertEnvInfo(event.new) : undefined,
                old: event.old ? convertEnvInfo(event.old) : undefined,
                resource: event.searchLocation,
            });
        });
    }
    triggerRefresh(query, options) {
        return this.api.triggerRefresh(query, options);
    }
    getRefreshPromise() {
        return this.api.getRefreshPromise();
    }
    get onProgress() {
        return this.api.onProgress;
    }
    get onChanged() {
        return this.changed.event;
    }
    onDidCreate(resource, callback) {
        const workspaceFolder = resource ? vscode.workspace.getWorkspaceFolder(resource) : undefined;
        return this.api.onChanged((e) => {
            if (!workspaceFolder || !e.searchLocation) {
                return;
            }
            (0, logging_1.traceVerbose)(`Received event ${JSON.stringify(e)} file change event`);
            if (e.type === fileSystemWatcher_1.FileChangeType.Created &&
                (0, externalDependencies_1.isParentPath)(e.searchLocation.fsPath, workspaceFolder.uri.fsPath)) {
                callback();
            }
        });
    }
    async getInterpreterInformation(pythonPath) {
        const env = await this.api.resolveEnv(pythonPath);
        return env ? convertEnvInfo(env) : undefined;
    }
    async isMacDefaultPythonPath(pythonPath) {
        return (0, macDefault_1.isMacDefaultPythonPath)(pythonPath);
    }
    async getInterpreterDetails(pythonPath) {
        const env = await this.api.resolveEnv(pythonPath);
        if (!env) {
            return undefined;
        }
        return convertEnvInfo(env);
    }
    async isCondaEnvironment(interpreterPath) {
        return (0, conda_1.isCondaEnvironment)(interpreterPath);
    }
    async getCondaEnvironment(interpreterPath) {
        if (!(await (0, conda_1.isCondaEnvironment)(interpreterPath))) {
            return undefined;
        }
        const env = await this.api.resolveEnv(interpreterPath);
        if (!env) {
            return undefined;
        }
        return { name: env.name, path: env.location };
    }
    async isMicrosoftStoreInterpreter(pythonPath) {
        return (0, microsoftStoreEnv_1.isMicrosoftStoreEnvironment)(pythonPath);
    }
    async hasInterpreters(filter = async () => true) {
        const onAddedToCollection = (0, async_1.createDeferred)();
        this.api.onChanged(async (e) => {
            if (e.new) {
                if (await filter(convertEnvInfo(e.new))) {
                    onAddedToCollection.resolve();
                }
            }
        });
        const initialEnvs = await (0, arrayUtils_1.asyncFilter)(this.api.getEnvs(), (e) => filter(convertEnvInfo(e)));
        if (initialEnvs.length > 0) {
            return true;
        }
        await Promise.race([onAddedToCollection.promise, this.api.getRefreshPromise()]);
        const envs = await (0, arrayUtils_1.asyncFilter)(this.api.getEnvs(), (e) => filter(convertEnvInfo(e)));
        return envs.length > 0;
    }
    getInterpreters(resource, source) {
        const query = {};
        let roots = [];
        let wsFolder;
        if (resource !== undefined) {
            wsFolder = vscode.workspace.getWorkspaceFolder(resource);
            if (wsFolder) {
                roots = [wsFolder.uri];
            }
        }
        if (!wsFolder &&
            vscode.workspace.workspaceFolders &&
            vscode.workspace.workspaceFolders.length > 0 &&
            (!resource || resource.scheme === 'untitled')) {
            roots = vscode.workspace.workspaceFolders.map((w) => w.uri);
        }
        query.searchLocations = {
            roots,
        };
        let envs = this.api.getEnvs(query);
        if (source) {
            envs = envs.filter((env) => (0, lodash_1.intersection)(source, env.source).length > 0);
        }
        return envs.map(convertEnvInfo);
    }
    async getWorkspaceVirtualEnvInterpreters(resource, options) {
        const workspaceFolder = vscode.workspace.getWorkspaceFolder(resource);
        if (!workspaceFolder) {
            return [];
        }
        const query = {
            searchLocations: {
                roots: [workspaceFolder.uri],
                doNotIncludeNonRooted: true,
            },
        };
        if (options === null || options === void 0 ? void 0 : options.ignoreCache) {
            await this.api.triggerRefresh(query);
        }
        await this.api.getRefreshPromise();
        const envs = this.api.getEnvs(query);
        return envs.map(convertEnvInfo);
    }
};
ComponentAdapter = __decorate([
    (0, inversify_1.injectable)()
], ComponentAdapter);
function registerNewDiscoveryForIOC(serviceManager, api) {
    serviceManager.addSingleton(contracts_1.ICondaService, condaService_1.CondaService);
    serviceManager.addSingletonInstance(contracts_1.IComponentAdapter, new ComponentAdapter(api));
}
exports.registerNewDiscoveryForIOC = registerNewDiscoveryForIOC;


/***/ }),

/***/ "./src/client/telemetry/constants.ts":
/*!*******************************************!*\
  !*** ./src/client/telemetry/constants.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PlatformErrors = exports.EventName = void 0;
var EventName;
(function (EventName) {
    EventName["EDITOR_LOAD"] = "EDITOR.LOAD";
    EventName["REPL"] = "REPL";
    EventName["CREATE_NEW_FILE_COMMAND"] = "CREATE_NEW_FILE_COMMAND";
    EventName["SELECT_INTERPRETER"] = "SELECT_INTERPRETER";
    EventName["PYTHON_INTERPRETER"] = "PYTHON_INTERPRETER";
    EventName["PYTHON_INSTALL_PACKAGE"] = "PYTHON_INSTALL_PACKAGE";
    EventName["ENVIRONMENT_WITHOUT_PYTHON_SELECTED"] = "ENVIRONMENT_WITHOUT_PYTHON_SELECTED";
    EventName["PYTHON_ENVIRONMENTS_API"] = "PYTHON_ENVIRONMENTS_API";
    EventName["PYTHON_INTERPRETER_DISCOVERY"] = "PYTHON_INTERPRETER_DISCOVERY";
    EventName["PYTHON_INTERPRETER_AUTO_SELECTION"] = "PYTHON_INTERPRETER_AUTO_SELECTION";
    EventName["PYTHON_INTERPRETER_ACTIVATION_ENVIRONMENT_VARIABLES"] = "PYTHON_INTERPRETER.ACTIVATION_ENVIRONMENT_VARIABLES";
    EventName["PYTHON_INTERPRETER_ACTIVATION_FOR_RUNNING_CODE"] = "PYTHON_INTERPRETER_ACTIVATION_FOR_RUNNING_CODE";
    EventName["PYTHON_INTERPRETER_ACTIVATION_FOR_TERMINAL"] = "PYTHON_INTERPRETER_ACTIVATION_FOR_TERMINAL";
    EventName["TERMINAL_SHELL_IDENTIFICATION"] = "TERMINAL_SHELL_IDENTIFICATION";
    EventName["PYTHON_INTERPRETER_ACTIVATE_ENVIRONMENT_PROMPT"] = "PYTHON_INTERPRETER_ACTIVATE_ENVIRONMENT_PROMPT";
    EventName["PYTHON_NOT_INSTALLED_PROMPT"] = "PYTHON_NOT_INSTALLED_PROMPT";
    EventName["CONDA_INHERIT_ENV_PROMPT"] = "CONDA_INHERIT_ENV_PROMPT";
    EventName["REQUIRE_JUPYTER_PROMPT"] = "REQUIRE_JUPYTER_PROMPT";
    EventName["ACTIVATED_CONDA_ENV_LAUNCH"] = "ACTIVATED_CONDA_ENV_LAUNCH";
    EventName["ENVFILE_VARIABLE_SUBSTITUTION"] = "ENVFILE_VARIABLE_SUBSTITUTION";
    EventName["ENVFILE_WORKSPACE"] = "ENVFILE_WORKSPACE";
    EventName["EXECUTION_CODE"] = "EXECUTION_CODE";
    EventName["EXECUTION_DJANGO"] = "EXECUTION_DJANGO";
    EventName["DEBUG_IN_TERMINAL_BUTTON"] = "DEBUG.IN_TERMINAL";
    EventName["DEBUG_ADAPTER_USING_WHEELS_PATH"] = "DEBUG_ADAPTER.USING_WHEELS_PATH";
    EventName["DEBUG_SESSION_ERROR"] = "DEBUG_SESSION.ERROR";
    EventName["DEBUG_SESSION_START"] = "DEBUG_SESSION.START";
    EventName["DEBUG_SESSION_STOP"] = "DEBUG_SESSION.STOP";
    EventName["DEBUG_SESSION_USER_CODE_RUNNING"] = "DEBUG_SESSION.USER_CODE_RUNNING";
    EventName["DEBUGGER"] = "DEBUGGER";
    EventName["DEBUGGER_ATTACH_TO_CHILD_PROCESS"] = "DEBUGGER.ATTACH_TO_CHILD_PROCESS";
    EventName["DEBUGGER_ATTACH_TO_LOCAL_PROCESS"] = "DEBUGGER.ATTACH_TO_LOCAL_PROCESS";
    EventName["DEBUGGER_CONFIGURATION_PROMPTS"] = "DEBUGGER.CONFIGURATION.PROMPTS";
    EventName["DEBUGGER_CONFIGURATION_PROMPTS_IN_LAUNCH_JSON"] = "DEBUGGER.CONFIGURATION.PROMPTS.IN.LAUNCH.JSON";
    EventName["UNITTEST_CONFIGURING"] = "UNITTEST.CONFIGURING";
    EventName["UNITTEST_CONFIGURE"] = "UNITTEST.CONFIGURE";
    EventName["UNITTEST_DISCOVERY_TRIGGER"] = "UNITTEST.DISCOVERY.TRIGGER";
    EventName["UNITTEST_DISCOVERING"] = "UNITTEST.DISCOVERING";
    EventName["UNITTEST_DISCOVERING_STOP"] = "UNITTEST.DISCOVERY.STOP";
    EventName["UNITTEST_DISCOVERY_DONE"] = "UNITTEST.DISCOVERY.DONE";
    EventName["UNITTEST_RUN_STOP"] = "UNITTEST.RUN.STOP";
    EventName["UNITTEST_RUN"] = "UNITTEST.RUN";
    EventName["UNITTEST_RUN_ALL_FAILED"] = "UNITTEST.RUN_ALL_FAILED";
    EventName["UNITTEST_DISABLED"] = "UNITTEST.DISABLED";
    EventName["PYTHON_EXPERIMENTS_INIT_PERFORMANCE"] = "PYTHON_EXPERIMENTS_INIT_PERFORMANCE";
    EventName["PYTHON_EXPERIMENTS_LSP_NOTEBOOKS"] = "PYTHON_EXPERIMENTS_LSP_NOTEBOOKS";
    EventName["PYTHON_EXPERIMENTS_OPT_IN_OPT_OUT_SETTINGS"] = "PYTHON_EXPERIMENTS_OPT_IN_OPT_OUT_SETTINGS";
    EventName["EXTENSION_SURVEY_PROMPT"] = "EXTENSION_SURVEY_PROMPT";
    EventName["LANGUAGE_SERVER_ENABLED"] = "LANGUAGE_SERVER.ENABLED";
    EventName["LANGUAGE_SERVER_STARTUP"] = "LANGUAGE_SERVER.STARTUP";
    EventName["LANGUAGE_SERVER_READY"] = "LANGUAGE_SERVER.READY";
    EventName["LANGUAGE_SERVER_TELEMETRY"] = "LANGUAGE_SERVER.EVENT";
    EventName["LANGUAGE_SERVER_REQUEST"] = "LANGUAGE_SERVER.REQUEST";
    EventName["LANGUAGE_SERVER_RESTART"] = "LANGUAGE_SERVER.RESTART";
    EventName["TERMINAL_CREATE"] = "TERMINAL.CREATE";
    EventName["ACTIVATE_ENV_IN_CURRENT_TERMINAL"] = "ACTIVATE_ENV_IN_CURRENT_TERMINAL";
    EventName["ACTIVATE_ENV_TO_GET_ENV_VARS_FAILED"] = "ACTIVATE_ENV_TO_GET_ENV_VARS_FAILED";
    EventName["DIAGNOSTICS_ACTION"] = "DIAGNOSTICS.ACTION";
    EventName["PLATFORM_INFO"] = "PLATFORM.INFO";
    EventName["DIAGNOSTICS_MESSAGE"] = "DIAGNOSTICS.MESSAGE";
    EventName["SELECT_LINTER"] = "LINTING.SELECT";
    EventName["USE_REPORT_ISSUE_COMMAND"] = "USE_REPORT_ISSUE_COMMAND";
    EventName["LINTER_NOT_INSTALLED_PROMPT"] = "LINTER_NOT_INSTALLED_PROMPT";
    EventName["HASHED_PACKAGE_NAME"] = "HASHED_PACKAGE_NAME";
    EventName["JEDI_LANGUAGE_SERVER_ENABLED"] = "JEDI_LANGUAGE_SERVER.ENABLED";
    EventName["JEDI_LANGUAGE_SERVER_STARTUP"] = "JEDI_LANGUAGE_SERVER.STARTUP";
    EventName["JEDI_LANGUAGE_SERVER_READY"] = "JEDI_LANGUAGE_SERVER.READY";
    EventName["JEDI_LANGUAGE_SERVER_REQUEST"] = "JEDI_LANGUAGE_SERVER.REQUEST";
    EventName["TENSORBOARD_SESSION_LAUNCH"] = "TENSORBOARD.SESSION_LAUNCH";
    EventName["TENSORBOARD_SESSION_DURATION"] = "TENSORBOARD.SESSION_DURATION";
    EventName["TENSORBOARD_SESSION_DAEMON_STARTUP_DURATION"] = "TENSORBOARD.SESSION_DAEMON_STARTUP_DURATION";
    EventName["TENSORBOARD_LAUNCH_PROMPT_SELECTION"] = "TENSORBOARD.LAUNCH_PROMPT_SELECTION";
    EventName["TENSORBOARD_SESSION_E2E_STARTUP_DURATION"] = "TENSORBOARD.SESSION_E2E_STARTUP_DURATION";
    EventName["TENSORBOARD_ENTRYPOINT_SHOWN"] = "TENSORBOARD.ENTRYPOINT_SHOWN";
    EventName["TENSORBOARD_INSTALL_PROMPT_SHOWN"] = "TENSORBOARD.INSTALL_PROMPT_SHOWN";
    EventName["TENSORBOARD_INSTALL_PROMPT_SELECTION"] = "TENSORBOARD.INSTALL_PROMPT_SELECTION";
    EventName["TENSORBOARD_DETECTED_IN_INTEGRATED_TERMINAL"] = "TENSORBOARD_DETECTED_IN_INTEGRATED_TERMINAL";
    EventName["TENSORBOARD_PACKAGE_INSTALL_RESULT"] = "TENSORBOARD.PACKAGE_INSTALL_RESULT";
    EventName["TENSORBOARD_TORCH_PROFILER_IMPORT"] = "TENSORBOARD.TORCH_PROFILER_IMPORT";
    EventName["TENSORBOARD_JUMP_TO_SOURCE_REQUEST"] = "TENSORBOARD_JUMP_TO_SOURCE_REQUEST";
    EventName["TENSORBOARD_JUMP_TO_SOURCE_FILE_NOT_FOUND"] = "TENSORBOARD_JUMP_TO_SOURCE_FILE_NOT_FOUND";
    EventName["ENVIRONMENT_CREATING"] = "ENVIRONMENT.CREATING";
    EventName["ENVIRONMENT_CREATED"] = "ENVIRONMENT.CREATED";
    EventName["ENVIRONMENT_FAILED"] = "ENVIRONMENT.FAILED";
    EventName["ENVIRONMENT_INSTALLING_PACKAGES"] = "ENVIRONMENT.INSTALLING_PACKAGES";
    EventName["ENVIRONMENT_INSTALLED_PACKAGES"] = "ENVIRONMENT.INSTALLED_PACKAGES";
    EventName["ENVIRONMENT_INSTALLING_PACKAGES_FAILED"] = "ENVIRONMENT.INSTALLING_PACKAGES_FAILED";
    EventName["ENVIRONMENT_BUTTON"] = "ENVIRONMENT.BUTTON";
    EventName["ENVIRONMENT_DELETE"] = "ENVIRONMENT.DELETE";
    EventName["ENVIRONMENT_REUSE"] = "ENVIRONMENT.REUSE";
    EventName["TOOLS_EXTENSIONS_ALREADY_INSTALLED"] = "TOOLS_EXTENSIONS.ALREADY_INSTALLED";
    EventName["TOOLS_EXTENSIONS_PROMPT_SHOWN"] = "TOOLS_EXTENSIONS.PROMPT_SHOWN";
    EventName["TOOLS_EXTENSIONS_INSTALL_SELECTED"] = "TOOLS_EXTENSIONS.INSTALL_SELECTED";
    EventName["TOOLS_EXTENSIONS_PROMPT_DISMISSED"] = "TOOLS_EXTENSIONS.PROMPT_DISMISSED";
    EventName["SELECT_INTERPRETER_ENTERED_EXISTS"] = "SELECT_INTERPRETER_ENTERED_EXISTS";
    EventName["SELECT_INTERPRETER_ENTER_CHOICE"] = "SELECT_INTERPRETER_ENTER_CHOICE";
    EventName["SELECT_INTERPRETER_SELECTED"] = "SELECT_INTERPRETER_SELECTED";
    EventName["SELECT_INTERPRETER_ENTER_OR_FIND"] = "SELECT_INTERPRETER_ENTER_OR_FIND";
})(EventName = exports.EventName || (exports.EventName = {}));
var PlatformErrors;
(function (PlatformErrors) {
    PlatformErrors["FailedToParseVersion"] = "FailedToParseVersion";
    PlatformErrors["FailedToDetermineOS"] = "FailedToDetermineOS";
})(PlatformErrors = exports.PlatformErrors || (exports.PlatformErrors = {}));


/***/ }),

/***/ "./src/client/telemetry/index.ts":
/*!***************************************!*\
  !*** ./src/client/telemetry/index.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.sendTelemetryEvent = exports._resetSharedProperties = exports.setSharedProperty = exports.isTelemetryDisabled = void 0;
function isTelemetryDisabled() {
    return true;
}
exports.isTelemetryDisabled = isTelemetryDisabled;
const sharedProperties = {};
function setSharedProperty(_name, _value) {
}
exports.setSharedProperty = setSharedProperty;
function _resetSharedProperties() {
    for (const key of Object.keys(sharedProperties)) {
        delete sharedProperties[key];
    }
}
exports._resetSharedProperties = _resetSharedProperties;
function sendTelemetryEvent(_eventName, _measuresOrDurationMs, _properties, _ex) {
}
exports.sendTelemetryEvent = sendTelemetryEvent;


/***/ }),

/***/ "./src/environments/activeInterpreter.ts":
/*!***********************************************!*\
  !*** ./src/environments/activeInterpreter.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const misc_1 = __webpack_require__(/*! ../client/common/utils/misc */ "./src/client/common/utils/misc.ts");
function activate(context) {
    context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.setAsActiveInterpreter', async (item) => {
        const api = await python_extension_1.PythonExtension.api();
        const env = 'env' in item ? item.env : api.environments.known.find((e) => e.id === item.id);
        if (!env) {
            return;
        }
        let folder;
        if ('owningFolder' in item && item.owningFolder) {
            folder = item.owningFolder;
        }
        else if (Array.isArray(vscode_1.workspace.workspaceFolders) && vscode_1.workspace.workspaceFolders.length > 0) {
            folder =
                vscode_1.workspace.workspaceFolders.length === 1
                    ? vscode_1.workspace.workspaceFolders[0]
                    : await vscode_1.window.showWorkspaceFolderPick({
                        placeHolder: 'Select folder to change active Python Environment',
                    });
        }
        if (folder) {
            api.environments.updateActiveEnvironmentPath(env, folder.uri).catch(misc_1.noop);
        }
        else {
            vscode_1.commands.executeCommand('python.setInterpreter').then(misc_1.noop, misc_1.noop);
        }
    }));
}
exports.activate = activate;


/***/ }),

/***/ "./src/environments/cache.ts":
/*!***********************************!*\
  !*** ./src/environments/cache.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.clearCacheIfNewVersionInstalled = exports.EnvironmentsCacheMementoKey = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const LastExtensionVersionKey = 'LAST_EXTENSION_VERSION';
exports.EnvironmentsCacheMementoKey = 'PYTHON:PACKAGE_MANAGER:ENVS_CACHE';
let cacheClearedOnce = false;
async function clearCacheIfNewVersionInstalled(context, clearEnvCache = false) {
    var _a, _b;
    const shouldRefresh = context.extensionMode === vscode_1.ExtensionMode.Development;
    if (!shouldRefresh && (cacheClearedOnce || context.globalState.get(LastExtensionVersionKey, '') === ((_b = (_a = context.extension) === null || _a === void 0 ? void 0 : _a.packageJSON) === null || _b === void 0 ? void 0 : _b.version))) {
        return;
    }
    cacheClearedOnce = true;
    let venvEnvs = [];
    if (!clearEnvCache) {
        venvEnvs = context.globalState.get(exports.EnvironmentsCacheMementoKey, []);
    }
    await Promise.all([
        vscode_1.commands.executeCommand('python.envManager.clearPersistentStorage'),
        context.globalState.keys().filter(key => key !== LastExtensionVersionKey).map(key => context.globalState.update(key, undefined)),
        context.workspaceState.keys().map(key => context.workspaceState.update(key, undefined))
    ]);
    await context.globalState.update(LastExtensionVersionKey, context.extension.packageJSON.version);
    if (!clearEnvCache && Array.isArray(venvEnvs)) {
        await context.globalState.update(exports.EnvironmentsCacheMementoKey, venvEnvs);
    }
}
exports.clearCacheIfNewVersionInstalled = clearCacheIfNewVersionInstalled;


/***/ }),

/***/ "./src/environments/constants.ts":
/*!***************************************!*\
  !*** ./src/environments/constants.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.loggingOutputChannel = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
exports.loggingOutputChannel = vscode_1.window.createOutputChannel('Python Environments (logging)');


/***/ }),

/***/ "./src/environments/envCreation.ts":
/*!*****************************************!*\
  !*** ./src/environments/envCreation.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = exports.canEnvBeCreated = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../client/logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const createEnvApi_1 = __webpack_require__(/*! ../client/pythonEnvironments/creation/createEnvApi */ "./src/client/pythonEnvironments/creation/createEnvApi.ts");
const createEnvironment_1 = __webpack_require__(/*! ../client/pythonEnvironments/creation/createEnvironment */ "./src/client/pythonEnvironments/creation/createEnvironment.ts");
function canEnvBeCreated(envType) {
    switch (envType) {
        case info_1.EnvironmentType.Conda:
        case info_1.EnvironmentType.Venv:
        case info_1.EnvironmentType.Pyenv:
            return true;
        case info_1.EnvironmentType.VirtualEnv:
        case info_1.EnvironmentType.VirtualEnvWrapper:
        case info_1.EnvironmentType.Pipenv:
        case info_1.EnvironmentType.Poetry:
        case info_1.EnvironmentType.System:
        case info_1.EnvironmentType.Unknown:
            return false;
        default:
            return false;
    }
}
exports.canEnvBeCreated = canEnvBeCreated;
function activate(context) {
    context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.create', async (type) => {
        if (!type) {
            await vscode_1.commands.executeCommand('python.createEnvironment');
            return vscode_1.commands.executeCommand('python.envManager.refresh');
        }
        if (!canEnvBeCreated(type)) {
            (0, logging_1.traceError)(`Environment '${type}' cannot be created`);
            return;
        }
        const provider = createEnvApi_1._createEnvironmentProviders.getAll().find((e) => e.tools.includes(type));
        if (!provider) {
            return;
        }
        try {
            await (0, createEnvironment_1.handleCreateEnvironmentCommand)([provider], {});
        }
        catch (err) {
            console.error('Failed to create the environment', err);
        }
    }));
}
exports.activate = activate;


/***/ }),

/***/ "./src/environments/envDeletion.ts":
/*!*****************************************!*\
  !*** ./src/environments/envDeletion.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = exports.canEnvBeDeleted = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../client/logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const helpers_1 = __webpack_require__(/*! ./helpers */ "./src/environments/helpers.ts");
const conda_1 = __webpack_require__(/*! ./tools/conda */ "./src/environments/tools/conda.ts");
const venv_1 = __webpack_require__(/*! ./tools/venv */ "./src/environments/tools/venv.ts");
const poetry_1 = __webpack_require__(/*! ./tools/poetry */ "./src/environments/tools/poetry.ts");
const utils_1 = __webpack_require__(/*! ./utils */ "./src/environments/utils.ts");
const foldersTreeDataProvider_1 = __webpack_require__(/*! ./view/foldersTreeDataProvider */ "./src/environments/view/foldersTreeDataProvider.ts");
function canEnvBeDeleted(envType) {
    switch (envType) {
        case info_1.EnvironmentType.Conda:
        case info_1.EnvironmentType.Venv:
        case info_1.EnvironmentType.VirtualEnv:
        case info_1.EnvironmentType.VirtualEnvWrapper:
            return true;
        case info_1.EnvironmentType.Poetry:
            return true;
        case info_1.EnvironmentType.Pipenv:
        case info_1.EnvironmentType.Pyenv:
        case info_1.EnvironmentType.System:
        case info_1.EnvironmentType.Unknown:
            return false;
        default:
            return false;
    }
}
exports.canEnvBeDeleted = canEnvBeDeleted;
function activate(context) {
    context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.delete', async (options) => {
        var _a;
        let id = '';
        if (options instanceof foldersTreeDataProvider_1.ActiveWorkspaceEnvironment) {
            id = ((_a = options.asNode()) === null || _a === void 0 ? void 0 : _a.env.id) || '';
        }
        else {
            id = options.id;
        }
        const api = await python_extension_1.PythonExtension.api();
        const env = api.environments.known.find((e) => e.id === id);
        if (!env) {
            return;
        }
        if (!canEnvBeDeleted((0, utils_1.getEnvironmentType)(env))) {
            (0, logging_1.traceError)(`Environment '${(0, helpers_1.getEnvLoggingInfo)(env)}' cannot be deleted`);
            return;
        }
        const message = `Are you sure you want to delete the environment '${(0, helpers_1.getEnvDisplayInfo)(env)}'?`;
        const detail = `This will result in deleting the folder '${(0, helpers_1.getDisplayPath)(env.path)}'.`;
        if ((await vscode_1.window.showInformationMessage(message, { modal: true, detail }, 'Yes')) !== 'Yes') {
            return;
        }
        try {
            await vscode_1.window.withProgress({
                location: vscode_1.ProgressLocation.Notification,
                title: `Deleting environment ${(0, helpers_1.getEnvDisplayInfo)(env)}`,
            }, async (progress, _token) => {
                switch ((0, utils_1.getEnvironmentType)(env)) {
                    case info_1.EnvironmentType.Conda:
                        return (0, conda_1.deleteEnv)(env, progress);
                    case info_1.EnvironmentType.Poetry:
                        return (0, poetry_1.deleteEnv)(env, progress);
                    default:
                        return (0, venv_1.deleteEnv)(env);
                }
            });
            return vscode_1.commands.executeCommand('python.envManager.refresh', true);
        }
        catch (ex) {
            (0, logging_1.traceError)(`Failed to delete environment ${(0, helpers_1.getEnvLoggingInfo)(env)}`, ex);
            return vscode_1.window.showErrorMessage(`Failed to delete environment ${(0, helpers_1.getEnvDisplayInfo)(env)}, ${ex}`);
        }
    }));
}
exports.activate = activate;


/***/ }),

/***/ "./src/environments/helpers.ts":
/*!*************************************!*\
  !*** ./src/environments/helpers.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.reportStdOutProgress = exports.getEnvDisplayInfo = exports.getEnvLoggingInfo = exports.createTempFile = exports.getDisplayPath = exports.home = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const path = __webpack_require__(/*! path */ "path");
const tmp = __webpack_require__(/*! tmp */ "./node_modules/tmp/lib/tmp.js");
const utils_1 = __webpack_require__(/*! ./utils */ "./src/environments/utils.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../client/common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/environments/constants.ts");
const logging_1 = __webpack_require__(/*! ../client/logging */ "./src/client/logging/index.ts");
const rawProcessApis_1 = __webpack_require__(/*! ../client/common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const untildify = __webpack_require__(/*! untildify */ "./node_modules/untildify/index.js");
exports.home = untildify('~');
function getDisplayPath(value) {
    if (!value) {
        return '';
    }
    value = vscode_1.workspace.asRelativePath(value, (vscode_1.workspace.workspaceFolders || []).length > 1);
    return value.startsWith(exports.home) ? `~${path.sep}${path.relative(exports.home, value)}` : value;
}
exports.getDisplayPath = getDisplayPath;
function createTempFile(extension = '.txt') {
    return new Promise((resolve, reject) => {
        tmp.file({ postfix: extension }, (err, filename, _fd, cleanUp) => {
            if (err) {
                return reject(err);
            }
            resolve({
                filePath: filename,
                dispose: cleanUp,
            });
        });
    });
}
exports.createTempFile = createTempFile;
function getEnvLoggingInfo(env) {
    var _a;
    return `${(0, utils_1.getEnvironmentType)(env)}:(${((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name) || env.path},${getDisplayPath(env.path)})`;
}
exports.getEnvLoggingInfo = getEnvLoggingInfo;
function getEnvDisplayInfo(env) {
    var _a, _b;
    return ((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name) || ((_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri)
        ? getDisplayPath(env.environment.folderUri.fsPath)
        : getDisplayPath(env.path);
}
exports.getEnvDisplayInfo = getEnvDisplayInfo;
async function reportStdOutProgress(title, argsForExecution, progress, token) {
    (0, logging_1.traceVerbose)(title);
    constants_1.loggingOutputChannel.appendLine('>>>>>>>>>>>>>>>>>>>>>>>');
    constants_1.loggingOutputChannel.appendLine(title);
    constants_1.loggingOutputChannel.appendLine('');
    const result = await (0, rawProcessApis_1.execObservable)(...argsForExecution);
    const disposables = [];
    token.onCancellationRequested(() => { var _a; return (_a = result.proc) === null || _a === void 0 ? void 0 : _a.kill(); }, undefined, disposables);
    const ticker = ['.', '..', '...'];
    let counter = 0;
    await new Promise((resolve) => {
        const subscription = result.out.subscribe({
            next: (output) => {
                const suffix = ticker[counter % 3];
                const trimmedOutput = output.out.trim();
                counter += 1;
                const message = trimmedOutput.length > 28 ? `${trimmedOutput.substring(0, 28)}${suffix}` : trimmedOutput;
                progress.report({ message });
            },
            complete: () => resolve(),
        });
        disposables.push({
            dispose: () => {
                try {
                    subscription.unsubscribe();
                    constants_1.loggingOutputChannel.appendLine('<<<<<<<<<<<<<<<<<<<<<<<');
                    constants_1.loggingOutputChannel.appendLine('');
                }
                catch (_a) {
                }
            },
        });
    }).finally(() => (0, resourceLifecycle_1.disposeAll)(disposables));
}
exports.reportStdOutProgress = reportStdOutProgress;


/***/ }),

/***/ "./src/environments/installPython.ts":
/*!*******************************************!*\
  !*** ./src/environments/installPython.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const misc_1 = __webpack_require__(/*! ../client/common/utils/misc */ "./src/client/common/utils/misc.ts");
const conda_1 = __webpack_require__(/*! ./tools/conda */ "./src/environments/tools/conda.ts");
const helpers_1 = __webpack_require__(/*! ./helpers */ "./src/environments/helpers.ts");
const constants_1 = __webpack_require__(/*! ./micromamba/constants */ "./src/environments/micromamba/constants.ts");
const install_1 = __webpack_require__(/*! ./micromamba/install */ "./src/environments/micromamba/install.ts");
const environmentsTreeDataProvider_1 = __webpack_require__(/*! ./view/environmentsTreeDataProvider */ "./src/environments/view/environmentsTreeDataProvider.ts");
function activate(context) {
    context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.installPython', async () => {
        if (await fs.pathExists(constants_1.MICROMAMBA_EXE)) {
            const message = [
                `Python is already setup via Micromamba. Please use Micromamba found here ${(0, helpers_1.getDisplayPath)(constants_1.MICROMAMBA_EXE)}.`,
                `If it does not worker, then initialize your shell using the command '${(0, helpers_1.getDisplayPath)(constants_1.MICROMAMBA_EXE)} shell init -s bash|zsh|cmd.exe|powershell|fish|xonsh -p ~/micromamba'.`,
            ];
            void vscode_1.window.showInformationMessage(message.join(' \n'));
            return;
        }
        const moreInfo = 'More info';
        const detail = `Micromamba will downloaded into ${(0, helpers_1.getDisplayPath)(constants_1.MICROMAMBA_DIR)} \n& Shell scripts will be updated to put Micromamba into the current path.`;
        const selection = await vscode_1.window.showInformationMessage('Do you want to download and setup Python via Micromamba?', { modal: true, detail }, 'Yes', moreInfo);
        switch (selection) {
            case moreInfo:
                void vscode_1.env.openExternal(vscode_1.Uri.parse('https://mamba.readthedocs.io/en/latest/user_guide/micromamba.html'));
                break;
            case 'Yes':
                await (0, install_1.installMicromamba)(environmentsTreeDataProvider_1.refreshUntilNewEnvIsAvailable);
                await createInstallContext();
                break;
            default:
                break;
        }
    }));
    void createInstallContext();
}
exports.activate = activate;
async function createInstallContext() {
    const [condaVersion, installed] = await Promise.all([(0, conda_1.getCondaVersion)().catch(misc_1.noop), fs.pathExists(constants_1.MICROMAMBA_EXE)]);
    void vscode_1.commands.executeCommand('setContext', 'python.envManager.pythonIsNotInstalled', !installed && !condaVersion);
}


/***/ }),

/***/ "./src/environments/micromamba/base.ts":
/*!*********************************************!*\
  !*** ./src/environments/micromamba/base.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createBaseEnv = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const rawProcessApis_1 = __webpack_require__(/*! ../../client/common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const conda_1 = __webpack_require__(/*! ../tools/conda */ "./src/environments/tools/conda.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/environments/micromamba/constants.ts");
async function createBaseEnv(progress, token, refreshUntilAvailable, pythonVersion = '3.9') {
    var _a;
    try {
        progress.report({ message: `Creating Python ${pythonVersion} environment` });
        (0, logging_1.traceInfo)(`Creating environment with Python ${pythonVersion}`);
        const args = [
            'install',
            `python=${pythonVersion || '3.9'}`,
            'conda',
            '-c',
            'conda-forge',
            '-y',
            '-p',
            constants_1.MICROMAMBA_ROOTPREFIX,
        ];
        (0, logging_1.traceInfo)([constants_1.MICROMAMBA_EXE].concat(args).join(' '));
        const result = await (0, rawProcessApis_1.execObservable)(constants_1.MICROMAMBA_EXE, args, {
            timeout: 120000,
            token,
            shell: true,
            env: {
                ...process.env,
                TARGET_PREFIX: constants_1.MICROMAMBA_ROOTPREFIX,
                ROOT_PREFIX: constants_1.MICROMAMBA_ROOTPREFIX,
                MAMBA_ROOT_PREFIX: constants_1.MICROMAMBA_ROOTPREFIX,
                MAMBA_EXE: constants_1.MICROMAMBA_EXE,
            },
        });
        (_a = result.proc) === null || _a === void 0 ? void 0 : _a.on('error', (ex) => console.error(`Conda create exited with an error`, ex));
        await new Promise((resolve, reject) => {
            result.out.subscribe({
                next: (output) => {
                    if (output.out.trim().length) {
                        progress.report({ message: output.out });
                    }
                    (0, logging_1.traceInfo)(output.out);
                },
                complete: () => resolve(),
                error: (ex) => reject(ex),
            });
        });
        if (!(await fs.pathExists(constants_1.BASE_MICROMAMBA_PYTHON_EXE))) {
            throw new Error(`Please try running the following command in the terminal "${[constants_1.MICROMAMBA_EXE].concat(args).join(' ')}"`);
        }
        await (0, conda_1.updateEnvironmentsTxt)(constants_1.MICROMAMBA_ROOTPREFIX).catch((ex) => (0, logging_1.traceError)('Failed to update environments.txt', ex));
        progress.report({ message: 'Waiting for environment to be detected' });
        await refreshUntilAvailable({ path: constants_1.BASE_MICROMAMBA_PYTHON_EXE, type: info_1.EnvironmentType.Conda });
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to create environment`, ex);
        vscode_1.window.showErrorMessage(`Failed to create environment ${constants_1.MICROMAMBA_ROOTPREFIX}, ${ex}`);
    }
}
exports.createBaseEnv = createBaseEnv;


/***/ }),

/***/ "./src/environments/micromamba/constants.ts":
/*!**************************************************!*\
  !*** ./src/environments/micromamba/constants.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BASE_MICROMAMBA_PYTHON_EXE = exports.MICROMAMBA_EXE = exports.CONDA_EXE = exports.MICROMAMBA_BASE_ENV_NAME = exports.MICROMAMBA_DIR = exports.MICROMAMBA_ROOTPREFIX = void 0;
const path = __webpack_require__(/*! path */ "path");
const platform_1 = __webpack_require__(/*! ../../client/common/utils/platform */ "./src/client/common/utils/platform.ts");
const helpers_1 = __webpack_require__(/*! ../helpers */ "./src/environments/helpers.ts");
exports.MICROMAMBA_ROOTPREFIX = path.join((0, platform_1.getUserHomeDir)() || helpers_1.home, 'micromamba');
exports.MICROMAMBA_DIR = path.join((0, platform_1.getUserHomeDir)() || helpers_1.home, '.micromamba');
exports.MICROMAMBA_BASE_ENV_NAME = 'micromambaBase';
exports.CONDA_EXE = path.join(exports.MICROMAMBA_ROOTPREFIX, 'condabin', (0, platform_1.getOSType)() === platform_1.OSType.Windows ? 'conda.exe' : 'conda');
exports.MICROMAMBA_EXE = path.join(exports.MICROMAMBA_DIR, 'bin', (0, platform_1.getOSType)() === platform_1.OSType.Windows ? 'micromamba.exe' : 'micromamba');
exports.BASE_MICROMAMBA_PYTHON_EXE = path.join(exports.MICROMAMBA_ROOTPREFIX, (0, platform_1.getOSType)() === platform_1.OSType.Windows ? 'Scripts' : 'bin', (0, platform_1.getOSType)() === platform_1.OSType.Windows ? 'python.exe' : 'python');


/***/ }),

/***/ "./src/environments/micromamba/downloader.ts":
/*!***************************************************!*\
  !*** ./src/environments/micromamba/downloader.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isMicroMambaInstalled = exports.downloadMamba = exports.activate = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const tar = __webpack_require__(/*! tar */ "./node_modules/tar/index.js");
const request = __webpack_require__(/*! request */ "./node_modules/request/index.js");
const platform_1 = __webpack_require__(/*! ../../client/common/utils/platform */ "./src/client/common/utils/platform.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/environments/micromamba/constants.ts");
const bz2 = __webpack_require__(/*! unbzip2-stream */ "./node_modules/unbzip2-stream/index.js");
const progress = __webpack_require__(/*! request-progress */ "./node_modules/request-progress/index.js");
function activate(_context) {
}
exports.activate = activate;
function getUrl() {
    switch ((0, platform_1.getOSType)()) {
        case platform_1.OSType.Windows:
            return 'https://micro.mamba.pm/api/micromamba/win-64/latest';
        case platform_1.OSType.OSX:
            return process.arch === 'arm64' ? 'https://micro.mamba.pm/api/micromamba/osx-arm64/latest' : 'https://micro.mamba.pm/api/micromamba/osx-64/latest';
        case platform_1.OSType.Linux:
        default:
            return 'https://micro.mamba.pm/api/micromamba/linux-64/latest';
    }
}
async function getDestinationDirectory() {
    await fs.ensureDir(constants_1.MICROMAMBA_DIR);
    return constants_1.MICROMAMBA_DIR;
}
const MB = 1024 * 1024;
async function downloadMamba(uiProgress, token) {
    const [url, downloadDir] = await Promise.all([getUrl(), getDestinationDirectory()]);
    await new Promise((resolve, reject) => {
        const result = request(url);
        token.onCancellationRequested(() => {
            result.abort();
        });
        progress(result, {})
            .on('progress', (state) => {
            var _a;
            const message = `Downloading Micromamba ${(state.percent * 100).toFixed(0)}% (${(state.size.transferred / MB).toFixed(2)} of ${(state.size.total / MB).toFixed(2)}MB).`;
            const suffix = ((_a = state.time) === null || _a === void 0 ? void 0 : _a.remaining) ? ` \nRemaining ${(state.time.remaining).toFixed(0)}s` : '';
            uiProgress.report({ message: `${message}${suffix}` });
            console.log('progress', state);
        })
            .on('error', (err) => reject(err))
            .pipe(bz2())
            .pipe(tar.extract({ cwd: downloadDir }))
            .on('error', (err) => reject(err))
            .on('end', () => resolve());
    });
    return downloadDir;
}
exports.downloadMamba = downloadMamba;
async function isMicroMambaInstalled() {
    return fs.pathExists(constants_1.MICROMAMBA_EXE);
}
exports.isMicroMambaInstalled = isMicroMambaInstalled;


/***/ }),

/***/ "./src/environments/micromamba/install.ts":
/*!************************************************!*\
  !*** ./src/environments/micromamba/install.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.installMicromamba = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/environments/micromamba/constants.ts");
const base_1 = __webpack_require__(/*! ./base */ "./src/environments/micromamba/base.ts");
const shells_1 = __webpack_require__(/*! ./shells */ "./src/environments/micromamba/shells.ts");
const downloader_1 = __webpack_require__(/*! ./downloader */ "./src/environments/micromamba/downloader.ts");
async function installMicromamba(refreshUntilAvailable) {
    if (!await fs.pathExists(constants_1.MICROMAMBA_EXE)) {
        await vscode_1.window.withProgress({ location: vscode_1.ProgressLocation.Notification, cancellable: true, title: 'Setting up Python' }, async (uiProgress, token) => {
            try {
                await (0, downloader_1.downloadMamba)(uiProgress, token);
                uiProgress.report({ message: 'Configuring Micromamba Shells' });
                await (0, shells_1.initializeMicromambaShells)();
                await (0, base_1.createBaseEnv)(uiProgress, token, refreshUntilAvailable);
                uiProgress.report({ message: 'Configuring Conda Shells' });
                await (0, shells_1.initializeCondaShells)();
                uiProgress.report({ message: 'Updating user .vscode settings' });
                await updatePythonSettings();
            }
            catch (ex) {
                (0, logging_1.traceError)(`Failed to create Python environment`);
                vscode_1.window.showErrorMessage(`Failed to setup Python, see logs for more information. \n ${ex.toString()}`);
            }
        });
    }
    (0, logging_1.traceInfo)(`Mamba file loaded at ${constants_1.MICROMAMBA_EXE}`);
}
exports.installMicromamba = installMicromamba;
async function updatePythonSettings() {
    var _a, _b;
    const settings = vscode_1.workspace.getConfiguration('python', undefined);
    if (!((_a = settings.inspect('condaPath')) === null || _a === void 0 ? void 0 : _a.globalValue)) {
        if (!((_b = settings.inspect('condaPath')) === null || _b === void 0 ? void 0 : _b.globalValue)) {
            void settings.update('condaPath', constants_1.CONDA_EXE, vscode_1.ConfigurationTarget.Global);
        }
    }
}


/***/ }),

/***/ "./src/environments/micromamba/shells.ts":
/*!***********************************************!*\
  !*** ./src/environments/micromamba/shells.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.initializeCondaShells = exports.initializeMicromambaShells = void 0;
const platform_1 = __webpack_require__(/*! ../../client/common/utils/platform */ "./src/client/common/utils/platform.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../client/pythonEnvironments/common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
__webpack_require__(/*! ../../client/common/extensions */ "./src/client/common/extensions.ts");
const constants_1 = __webpack_require__(/*! ./constants */ "./src/environments/micromamba/constants.ts");
async function initializeMicromambaShells() {
    if ((0, platform_1.getOSType)() === platform_1.OSType.Windows) {
        await Promise.all([
            (0, externalDependencies_1.exec)(constants_1.MICROMAMBA_EXE, ['shell', 'init', '-s', 'cmd.exe', '-p', constants_1.MICROMAMBA_ROOTPREFIX.fileToCommandArgumentForPythonMgrExt()]),
            (0, externalDependencies_1.exec)(constants_1.MICROMAMBA_EXE, ['shell', 'init', '-s', 'powershell', '-p', constants_1.MICROMAMBA_ROOTPREFIX.fileToCommandArgumentForPythonMgrExt()])
        ]);
    }
    else {
        const results = await Promise.all([
            (0, externalDependencies_1.exec)(constants_1.MICROMAMBA_EXE, ['shell', 'init', '-s', 'bash', '-p', constants_1.MICROMAMBA_ROOTPREFIX.fileToCommandArgumentForPythonMgrExt()]),
            (0, externalDependencies_1.exec)(constants_1.MICROMAMBA_EXE, ['shell', 'init', '-s', 'fish', '-p', constants_1.MICROMAMBA_ROOTPREFIX.fileToCommandArgumentForPythonMgrExt()]),
            (0, externalDependencies_1.exec)(constants_1.MICROMAMBA_EXE, ['shell', 'init', '-s', 'xonsh', '-p', constants_1.MICROMAMBA_ROOTPREFIX.fileToCommandArgumentForPythonMgrExt()]),
            (0, externalDependencies_1.exec)(constants_1.MICROMAMBA_EXE, ['shell', 'init', '-s', 'zsh', '-p', constants_1.MICROMAMBA_ROOTPREFIX.fileToCommandArgumentForPythonMgrExt()])
        ]);
        console.log(results);
    }
}
exports.initializeMicromambaShells = initializeMicromambaShells;
async function initializeCondaShells() {
    const result = await (0, externalDependencies_1.exec)(constants_1.CONDA_EXE, ['init', '--all'], { shell: true });
    console.log(result);
}
exports.initializeCondaShells = initializeCondaShells;


/***/ }),

/***/ "./src/environments/packageSearch.ts":
/*!*******************************************!*\
  !*** ./src/environments/packageSearch.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.searchPackageWithProvider = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
async function searchPackageWithProvider(searchProvider, env) {
    const quickPick = vscode_1.window.createQuickPick();
    quickPick.placeholder = 'Enter package name to search';
    quickPick.canSelectMany = false;
    quickPick.show();
    let progressCounter = 0;
    const searchAndUpdate = async (value, token) => {
        if (!value.trim()) {
            quickPick.items = [];
            return;
        }
        quickPick.busy = true;
        progressCounter += 1;
        const packages = await searchProvider(value, env, token);
        progressCounter -= 1;
        if (!progressCounter) {
            quickPick.busy = false;
        }
        if (token.isCancellationRequested) {
            return;
        }
        quickPick.items = packages;
    };
    let token;
    quickPick.onDidChangeValue(async (value) => {
        if (token) {
            token.cancel();
            token.dispose();
        }
        token = new vscode_1.CancellationTokenSource();
        searchAndUpdate(value, token.token);
    });
    return new Promise((resolve) => {
        quickPick.onDidHide(() => {
            if (token) {
                token.cancel();
                token.dispose();
            }
            resolve(undefined);
            quickPick.dispose();
        });
        quickPick.onDidAccept(async () => {
            if (!quickPick.selectedItems.length) {
                return;
            }
            resolve('item' in quickPick.selectedItems[0] ? quickPick.selectedItems[0].item : undefined);
            quickPick.hide();
        });
    });
}
exports.searchPackageWithProvider = searchPackageWithProvider;


/***/ }),

/***/ "./src/environments/packages.ts":
/*!**************************************!*\
  !*** ./src/environments/packages.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.installPackage = exports.searchPackage = exports.exportPackages = exports.uninstallPackage = exports.updatePackages = exports.updatePackage = exports.getOutdatedPackages = exports.getPackages = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const logging_1 = __webpack_require__(/*! ../client/logging */ "./src/client/logging/index.ts");
const pip_1 = __webpack_require__(/*! ./tools/pip */ "./src/environments/tools/pip.ts");
const conda_1 = __webpack_require__(/*! ./tools/conda */ "./src/environments/tools/conda.ts");
const utils_1 = __webpack_require__(/*! ./utils */ "./src/environments/utils.ts");
const info_1 = __webpack_require__(/*! ../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const poetry_1 = __webpack_require__(/*! ./tools/poetry */ "./src/environments/tools/poetry.ts");
const helpers_1 = __webpack_require__(/*! ./helpers */ "./src/environments/helpers.ts");
const packageSearch_1 = __webpack_require__(/*! ./packageSearch */ "./src/environments/packageSearch.ts");
async function getPackages(env) {
    try {
        const [pipPackages, condaPackages] = await Promise.all([(0, pip_1.getPipPackages)(env), (0, conda_1.getCondaPackages)(env)]);
        const packages = new Map();
        (pipPackages || []).forEach((pkg) => packages.set(pkg.name, pkg));
        (condaPackages || []).forEach((pkg) => packages.set(pkg.name, pkg));
        return Array.from(packages.values()).sort((a, b) => a.name.toLocaleLowerCase().localeCompare(b.name.toLocaleLowerCase()));
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to get package information for ${env.id})`, ex);
        return [];
    }
}
exports.getPackages = getPackages;
async function getOutdatedPackages(env) {
    try {
        const [pipPackages, condaPackages] = await Promise.all([
            (0, pip_1.getOutdatedPipPackages)(env),
            (0, conda_1.getOutdatedCondaPackages)(env),
        ]);
        return condaPackages || pipPackages || new Map();
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to get latest package information for ${env.id})`, ex);
        return new Map();
    }
}
exports.getOutdatedPackages = getOutdatedPackages;
async function updatePackage(env, pkg) {
    try {
        if ((0, utils_1.isCondaEnvironment)(env)) {
            await (0, conda_1.updateCondaPackage)(env, pkg);
        }
        else {
            await (0, pip_1.updatePipPackage)(env, pkg);
        }
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to update package ${pkg.name} in ${env.id})`, ex);
        return [];
    }
}
exports.updatePackage = updatePackage;
async function updatePackages(env) {
    try {
        if ((0, utils_1.isCondaEnvironment)(env)) {
            await (0, conda_1.updateCondaPackages)(env);
        }
        else if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Poetry) {
            await (0, poetry_1.updatePoetryPackages)(env);
        }
        else {
            await (0, pip_1.updatePipPackages)(env);
        }
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to update packages in ${env.id})`, ex);
        return [];
    }
}
exports.updatePackages = updatePackages;
async function uninstallPackage(env, pkg) {
    await vscode_1.window.withProgress({ location: vscode_1.ProgressLocation.Notification, cancellable: true, title: `Uninstalling ${pkg.name}` }, async (progress, token) => {
        let result;
        try {
            if ((0, utils_1.isCondaEnvironment)(env)) {
                result = await (0, conda_1.getUninstallCondaPackageSpawnOptions)(env, pkg, token);
            }
            else if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Poetry) {
                result = await (0, poetry_1.getUninstallPoetryPackageSpawnOptions)(env, pkg.name, token);
            }
            else {
                result = await (0, pip_1.getUninstallPipPackageSpawnOptions)(env, pkg, token);
            }
            const message = `Uninstalling package ${pkg.name} from ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[
                result.command,
                ...result.args,
            ]}]}`;
            await (0, helpers_1.reportStdOutProgress)(message, [result.command, result.args, { timeout: 60000, ...(result.options || {}) }], progress, token);
        }
        catch (ex) {
            (0, logging_1.traceError)(`Failed to uninstall package ${pkg.name} in ${env.id})`, ex);
            return [];
        }
    });
}
exports.uninstallPackage = uninstallPackage;
async function exportPackages(env) {
    try {
        if ((0, utils_1.isCondaEnvironment)(env)) {
            return (0, conda_1.exportCondaPackages)(env);
        }
        if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Poetry) {
            return (0, poetry_1.exportPoetryPackages)(env);
        }
        return (0, pip_1.exportPipPackages)(env);
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to export environment ${env.id}`, ex);
    }
}
exports.exportPackages = exportPackages;
async function searchPackage(env) {
    try {
        if ((0, utils_1.isCondaEnvironment)(env)) {
            const result = await (0, packageSearch_1.searchPackageWithProvider)(conda_1.searchCondaPackage, env);
            if (!result) {
                throw new vscode_1.CancellationError();
            }
            return { conda: result };
        }
        if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Poetry) {
            const result = await (0, packageSearch_1.searchPackageWithProvider)(poetry_1.searchPoetryPackage, env);
            if (!result) {
                throw new vscode_1.CancellationError();
            }
            return { poetry: result };
        }
        const result = await (0, packageSearch_1.searchPackageWithProvider)(pip_1.searchPipPackage, env);
        if (!result) {
            throw new vscode_1.CancellationError();
        }
        return { pip: result };
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to install a package in ${env.id})`, ex);
        throw ex;
    }
}
exports.searchPackage = searchPackage;
async function installPackage(env, packageInfo) {
    let packageName = '';
    if ('conda' in packageInfo && packageInfo.conda) {
        packageName = packageInfo.conda.name;
    }
    else if ('poetry' in packageInfo && packageInfo.poetry) {
        packageName = packageInfo.poetry;
    }
    else if ('pip' in packageInfo && packageInfo.pip) {
        packageName = packageInfo.pip.name;
    }
    else {
        throw new Error('Not supported');
    }
    await vscode_1.window.withProgress({ location: vscode_1.ProgressLocation.Notification, cancellable: true, title: `Installing ${packageName}` }, async (progress, token) => {
        let result;
        try {
            if ('conda' in packageInfo && packageInfo.conda) {
                result = await (0, conda_1.getCondaPackageInstallSpawnOptions)(env, packageInfo.conda, token);
            }
            else if ('poetry' in packageInfo && packageInfo.poetry) {
                result = await (0, poetry_1.getPoetryPackageInstallSpawnOptions)(env, packageInfo.poetry, token);
            }
            else if ('pip' in packageInfo && packageInfo.pip) {
                result = await (0, pip_1.getInstallPipPackageSpawnOptions)(env, packageInfo.pip, token);
            }
            else {
                throw new Error('Not supported');
            }
            const message = `Installing package ${packageName} into ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[
                result.command,
                ...result.args,
            ]}]}`;
            await (0, helpers_1.reportStdOutProgress)(message, [result.command, result.args, { timeout: 60000, ...(result.options || {}) }], progress, token);
        }
        catch (ex) {
            (0, logging_1.traceError)(`Failed to install package ${packageName} into ${(0, helpers_1.getEnvLoggingInfo)(env)})`, ex);
        }
    });
}
exports.installPackage = installPackage;


/***/ }),

/***/ "./src/environments/serviceRegistry.ts":
/*!*********************************************!*\
  !*** ./src/environments/serviceRegistry.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerTypes = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const terminal_1 = __webpack_require__(/*! ./terminal */ "./src/environments/terminal.ts");
const downloader_1 = __webpack_require__(/*! ./micromamba/downloader */ "./src/environments/micromamba/downloader.ts");
const installPython_1 = __webpack_require__(/*! ./installPython */ "./src/environments/installPython.ts");
const envDeletion_1 = __webpack_require__(/*! ./envDeletion */ "./src/environments/envDeletion.ts");
const envCreation_1 = __webpack_require__(/*! ./envCreation */ "./src/environments/envCreation.ts");
const activeInterpreter_1 = __webpack_require__(/*! ./activeInterpreter */ "./src/environments/activeInterpreter.ts");
const environmentsTreeDataProvider_1 = __webpack_require__(/*! ./view/environmentsTreeDataProvider */ "./src/environments/view/environmentsTreeDataProvider.ts");
const foldersTreeDataProvider_1 = __webpack_require__(/*! ./view/foldersTreeDataProvider */ "./src/environments/view/foldersTreeDataProvider.ts");
const commands_1 = __webpack_require__(/*! ./view/commands */ "./src/environments/view/commands.ts");
function registerTypes(serviceManager, context) {
    python_extension_1.PythonExtension.api().then((api) => {
        const treeDataProvider = new environmentsTreeDataProvider_1.PythonEnvironmentsTreeDataProvider(context, api, serviceManager);
        context.subscriptions.push(treeDataProvider);
        vscode_1.window.createTreeView('pythonEnvironments', { treeDataProvider });
        const workspaceFoldersTreeDataProvider = new foldersTreeDataProvider_1.WorkspaceFoldersTreeDataProvider(context, api, envDeletion_1.canEnvBeDeleted);
        context.subscriptions.push(workspaceFoldersTreeDataProvider);
        vscode_1.window.createTreeView('workspaceEnvironments', { treeDataProvider: workspaceFoldersTreeDataProvider });
        context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.refresh', (forceRefresh = true) => {
            treeDataProvider.refresh(forceRefresh);
            workspaceFoldersTreeDataProvider.refresh(forceRefresh);
        }));
        context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.refreshing', (forceRefresh = true) => {
            treeDataProvider.refresh(forceRefresh);
            workspaceFoldersTreeDataProvider.refresh(forceRefresh);
        }));
    });
    (0, terminal_1.activate)(context, serviceManager);
    (0, downloader_1.activate)(context);
    (0, commands_1.registerCommands)(context);
    (0, installPython_1.activate)(context);
    (0, envCreation_1.activate)(context);
    (0, envDeletion_1.activate)(context);
    (0, activeInterpreter_1.activate)(context);
}
exports.registerTypes = registerTypes;


/***/ }),

/***/ "./src/environments/sillyDI.ts":
/*!*************************************!*\
  !*** ./src/environments/sillyDI.ts ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Dummy = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
let Dummy = class Dummy {
    constructor() {
        this.supportedWorkspaceTypes = { untrustedWorkspace: false, virtualWorkspace: false };
    }
    async activate(_resource) {
    }
};
Dummy = __decorate([
    (0, inversify_1.injectable)()
], Dummy);
exports.Dummy = Dummy;


/***/ }),

/***/ "./src/environments/terminal.ts":
/*!**************************************!*\
  !*** ./src/environments/terminal.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getActivatedEnvVariables = exports.getTerminalEnvVariables = exports.activate = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const path = __webpack_require__(/*! path */ "path");
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const isWsl = __webpack_require__(/*! is-wsl */ "./node_modules/is-wsl/index.js");
const types_1 = __webpack_require__(/*! ../client/common/terminal/types */ "./src/client/common/terminal/types.ts");
const async_1 = __webpack_require__(/*! ../client/common/utils/async */ "./src/client/common/utils/async.ts");
const constants_1 = __webpack_require__(/*! ../client/common/process/internal/scripts/constants */ "./src/client/common/process/internal/scripts/constants.ts");
const stopWatch_1 = __webpack_require__(/*! ../client/common/utils/stopWatch */ "./src/client/common/utils/stopWatch.ts");
const fileSystem_1 = __webpack_require__(/*! ../client/common/platform/fileSystem */ "./src/client/common/platform/fileSystem.ts");
const helpers_1 = __webpack_require__(/*! ./helpers */ "./src/environments/helpers.ts");
const logging_1 = __webpack_require__(/*! ../client/logging */ "./src/client/logging/index.ts");
const contracts_1 = __webpack_require__(/*! ../client/interpreter/contracts */ "./src/client/interpreter/contracts.ts");
const utils_1 = __webpack_require__(/*! ./utils */ "./src/environments/utils.ts");
const foldersTreeDataProvider_1 = __webpack_require__(/*! ./view/foldersTreeDataProvider */ "./src/environments/view/foldersTreeDataProvider.ts");
const defaultEnvVars = new Map();
function activate(context, iocContainer) {
    vscode_1.workspace.onDidChangeConfiguration(() => {
        defaultEnvVars.clear();
    }, undefined, context.subscriptions);
    let api;
    context.subscriptions.push(vscode_1.commands.registerCommand('python.envManager.openInTerminal', async (options) => {
        var _a, _b, _c, _d;
        let id = '';
        if (options instanceof foldersTreeDataProvider_1.ActiveWorkspaceEnvironment) {
            id = ((_a = options.asNode()) === null || _a === void 0 ? void 0 : _a.env.id) || '';
        }
        else {
            id = options.id;
        }
        const helper = iocContainer.get(types_1.ITerminalHelper);
        const pyenvs = iocContainer.get(contracts_1.IComponentAdapter);
        api = api || (await python_extension_1.PythonExtension.api());
        const env = api.environments.known.find((e) => e.id === id);
        if (!env) {
            return;
        }
        const interpreter = await pyenvs.getInterpreterDetails(env.path);
        if (!interpreter || (!(interpreter === null || interpreter === void 0 ? void 0 : interpreter.sysPrefix) && (0, utils_1.isNonPythonCondaEnvironment)(env))) {
            return;
        }
        const cwd = await pickFolder();
        const name = ((_b = env.environment) === null || _b === void 0 ? void 0 : _b.name)
            ? `Python ${env.environment.name}`
            : (0, helpers_1.getDisplayPath)(path.dirname(((_d = (_c = env.environment) === null || _c === void 0 ? void 0 : _c.folderUri) === null || _d === void 0 ? void 0 : _d.fsPath) || env.path));
        let terminal = vscode_1.window.createTerminal({ hideFromUser: true, name, cwd });
        const shell = helper.identifyTerminalShell(terminal);
        const activationCommands = await helper.getEnvironmentActivationCommands(shell, cwd, interpreter);
        if (Array.isArray(activationCommands) && activationCommands.length > 0) {
            terminal.show(false);
            for (const command of activationCommands || []) {
                terminal.sendText(command);
                if (activationCommands.length > 1) {
                    await (0, async_1.sleep)(1000);
                }
            }
            return;
        }
        if (isWsl) {
            const exportScript = await getPathScript(shell, env.path, context);
            terminal.dispose();
            terminal = vscode_1.window.createTerminal({
                hideFromUser: true,
                name,
                cwd,
            });
            if (exportScript) {
                terminal.sendText(exportScript);
                await (0, async_1.sleep)(1000);
            }
            terminal.show(false);
            return;
        }
        try {
            const [baseEnvVars, symlinkDir] = await Promise.all([
                getEmptyTerminalVariables(terminal, shell, cwd === null || cwd === void 0 ? void 0 : cwd.fsPath),
                createSymlink(shell, env.path, context),
            ]);
            terminal.dispose();
            const envVars = { ...baseEnvVars };
            ['Path', 'PATH'].forEach((pathVarName) => {
                if (typeof envVars[pathVarName] === 'string') {
                    envVars[pathVarName] = `${symlinkDir}${path.delimiter}${envVars[pathVarName]}`;
                }
            });
            const terminalCustomEnvVars = vscode_1.window.createTerminal({
                hideFromUser: false,
                name,
                cwd,
                env: envVars,
                strictEnv: true,
            });
            terminalCustomEnvVars.show(false);
        }
        catch (ex) {
            console.error(`Failed to create terminal for ${(0, utils_1.getEnvironmentType)(env)}:${env.path}`, ex);
        }
    }));
}
exports.activate = activate;
let cachedEnvVariables;
async function getTerminalEnvVariables(iocContainer) {
    if (cachedEnvVariables) {
        return cachedEnvVariables;
    }
    cachedEnvVariables = (async () => {
        const helper = iocContainer.get(types_1.ITerminalHelper);
        const terminal = vscode_1.window.createTerminal({ hideFromUser: true, name: 'hidden' });
        const shell = helper.identifyTerminalShell(terminal);
        try {
            return await getEmptyTerminalVariables(terminal, shell);
        }
        catch (ex) {
            return undefined;
        }
        finally {
            terminal.dispose();
        }
    })();
    return cachedEnvVariables;
}
exports.getTerminalEnvVariables = getTerminalEnvVariables;
async function getEmptyTerminalVariables(terminal, shell, workspaceFolderUri = '') {
    if (defaultEnvVars.has(workspaceFolderUri)) {
        return defaultEnvVars.get(workspaceFolderUri);
    }
    const envFile = await (0, helpers_1.createTempFile)();
    const cmd = getEnvDumpCommand(shell, envFile.filePath);
    try {
        terminal.sendText(cmd.command);
        const stopWatch = new stopWatch_1.StopWatch();
        while (stopWatch.elapsedTime < 5000) {
            if (await fs.pathExists(envFile.filePath)) {
                const contents = await fs.readFile(envFile.filePath, 'utf8');
                if (contents.length > 0) {
                    const envVars = cmd.parser(contents);
                    defaultEnvVars.set(workspaceFolderUri, envVars);
                    defaultEnvVars.set(workspaceFolderUri, envVars);
                    return envVars;
                }
            }
            await (0, async_1.sleep)(100);
        }
        (0, logging_1.traceError)(`Env vars file not created command ${cmd.command}`);
        return;
    }
    catch (ex) {
        (0, logging_1.traceError)(`Env vars file not created command ${cmd.command}`, ex);
        return;
    }
    finally {
        envFile.dispose();
    }
}
function getEnvDumpCommand(shell, envFile) {
    switch (shell) {
        case types_1.TerminalShellType.commandPrompt: {
            const parser = (output) => {
                const dict = {};
                output.split(/\r?\n/).forEach((line) => {
                    if (line.indexOf('=') === -1) {
                        return;
                    }
                    const key = line.substring(0, line.indexOf('=')).trim();
                    const value = line.substring(line.indexOf('=') + 1).trim();
                    dict[key] = value;
                });
                return dict;
            };
            return { command: `set > "${envFile}"`, parser };
        }
        case types_1.TerminalShellType.powershell:
        case types_1.TerminalShellType.powershellCore: {
            const parser = (output) => {
                const dict = {};
                let startProcessing = false;
                output.split(/\r?\n/).forEach((line) => {
                    if (line.startsWith('----')) {
                        startProcessing = true;
                        return;
                    }
                    if (!startProcessing) {
                        return;
                    }
                    const key = line.substring(0, line.indexOf(' ')).trim();
                    const value = line.substring(line.indexOf(' ') + 1).trim();
                    dict[key] = value;
                });
                return dict;
            };
            return { command: `Get-ChildItem env: | Out-File "${envFile}"`, parser };
        }
        default: {
            const parser = (output) => {
                const dict = {};
                output.split(/\r?\n/).forEach((line) => {
                    if (line.indexOf('=') === -1) {
                        return;
                    }
                    const key = line.substring(0, line.indexOf('=')).trim();
                    const value = line.substring(line.indexOf('=') + 1).trim();
                    dict[key] = value;
                });
                return dict;
            };
            return { command: `printenv > "${envFile.replace(/\\/g, '/')}"`, parser };
        }
    }
}
async function createSymlink(shell, pythonPath, context) {
    const hash = (0, fileSystem_1.getHashString)(pythonPath);
    const script = createShellScript(shell, pythonPath);
    const symlinkDir = path.join(context.globalStorageUri.fsPath, 'symlinksV1', `python_${hash}`);
    const symlinkPythonFile = path.join(symlinkDir, `python${script.extension}`);
    const symlinkPipFile = path.join(symlinkDir, `pip${script.extension}`);
    if (await fs.pathExists(symlinkPythonFile)) {
        return symlinkDir;
    }
    await fs.ensureDir(symlinkDir);
    await Promise.all([fs.writeFile(symlinkPythonFile, script.python), fs.writeFile(symlinkPipFile, script.pip)]);
    await Promise.all([fs.chmod(symlinkPythonFile, 0o777), fs.chmod(symlinkPipFile, 0o777)]);
    return symlinkDir;
}
async function pickFolder() {
    if (!vscode_1.workspace.workspaceFolders || vscode_1.workspace.workspaceFolders.length === 0) {
        return;
    }
    if (vscode_1.workspace.workspaceFolders.length === 1) {
        return vscode_1.workspace.workspaceFolders[0].uri;
    }
    return vscode_1.window.showWorkspaceFolderPick({ placeHolder: 'Select cwd for terminal' }).then((folder) => folder === null || folder === void 0 ? void 0 : folder.uri);
}
const envVariables = new Map();
async function getActivatedEnvVariables(helper, shell, terminal, pythonPath) {
    if (envVariables.has(pythonPath)) {
        return envVariables.get(pythonPath);
    }
    const promise = (async () => {
        const tmpFile = await (0, helpers_1.createTempFile)();
        tmpFile.dispose();
        const args = helper.buildCommandForTerminal(shell, pythonPath, [
            path.join(constants_1._SCRIPTS_DIR, 'printEnvVariablesToFile.py'),
            tmpFile.filePath,
        ]);
        terminal.sendText(args);
        const stopWatch = new stopWatch_1.StopWatch();
        while (stopWatch.elapsedTime < 5000) {
            if (await fs.pathExists(tmpFile.filePath)) {
                break;
            }
            await (0, async_1.sleep)(100);
        }
        if (await fs.pathExists(tmpFile.filePath)) {
            try {
                return JSON.parse(await fs.readFile(tmpFile.filePath, 'utf8'));
            }
            catch (ex) {
                console.error(`Failed to parse activated env vars for ${pythonPath}, with command ${args}`, ex);
                throw new Error(`Failed to parse activated env vars for ${pythonPath}, with command ${args}`);
            }
        }
        else {
            throw new Error(`Failed to generate env vars for ${pythonPath}, with command ${args}`);
        }
    })();
    envVariables.set(pythonPath, promise);
    promise.finally(() => envVariables.delete(pythonPath));
    return promise;
}
exports.getActivatedEnvVariables = getActivatedEnvVariables;
function createShellScript(shellType, realPath) {
    switch (shellType) {
        case types_1.TerminalShellType.commandPrompt:
        case types_1.TerminalShellType.powershell:
        case types_1.TerminalShellType.powershellCore:
            return {
                python: `
@ECHO off
"${realPath}"  %*
`,
                pip: `
@ECHO off
"${realPath}" -m pip  %*
`,
                extension: '.cmd',
            };
        default:
            return {
                python: `#!/usr/bin/env bash
"${realPath}"   "$@"
ret=$?
exit $ret
`,
                pip: `#!/usr/bin/env bash
"${realPath}" -m pip   "$@"
ret=$?
exit $ret
`,
                extension: '',
            };
    }
}
async function getPathScript(shell, pythonPath, context) {
    const symlinkFolder = await createSymlink(shell, pythonPath, context);
    switch (shell) {
        case types_1.TerminalShellType.commandPrompt:
        case types_1.TerminalShellType.powershell:
        case types_1.TerminalShellType.powershellCore:
            return;
        default: {
            return `export "PATH=${symlinkFolder}${path.delimiter}$PATH" && clear`;
        }
    }
}


/***/ }),

/***/ "./src/environments/tools/conda.ts":
/*!*****************************************!*\
  !*** ./src/environments/tools/conda.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.searchCondaPackage = exports.getCondaPackageInstallSpawnOptions = exports.exportCondaPackages = exports.updateEnvironmentsTxt = exports.createEnv = exports.getCondaVersion = exports.deleteEnv = exports.updateCondaPackage = exports.getUninstallCondaPackageSpawnOptions = exports.updateCondaPackages = exports.getOutdatedCondaPackages = exports.getCondaPackages = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const os_1 = __webpack_require__(/*! os */ "os");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const applicationShell_1 = __webpack_require__(/*! ../../client/common/application/applicationShell */ "./src/client/common/application/applicationShell.ts");
const rawProcessApis_1 = __webpack_require__(/*! ../../client/common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const multiStepInput_1 = __webpack_require__(/*! ../../client/common/utils/multiStepInput */ "./src/client/common/utils/multiStepInput.ts");
const platform_1 = __webpack_require__(/*! ../../client/common/utils/platform */ "./src/client/common/utils/platform.ts");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const conda_1 = __webpack_require__(/*! ../../client/pythonEnvironments/common/environmentManagers/conda */ "./src/client/pythonEnvironments/common/environmentManagers/conda.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../client/pythonEnvironments/common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const helpers_1 = __webpack_require__(/*! ../helpers */ "./src/environments/helpers.ts");
const constants_1 = __webpack_require__(/*! ../micromamba/constants */ "./src/environments/micromamba/constants.ts");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
async function getCondaPackages(env) {
    var _a, _b, _c;
    if (!(0, utils_1.isCondaEnvironment)(env) || !env.executable.uri) {
        return;
    }
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        return;
    }
    const args = ['list'].concat(((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name)
        ? ['-n', env.environment.name]
        : ['-p', ((_c = (_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri) === null || _c === void 0 ? void 0 : _c.fsPath) || path.dirname(env.path)]);
    const result = await (0, externalDependencies_1.exec)(conda.command, args.concat(['--json']), { timeout: 60000 });
    const stdout = result.stdout.trim();
    (0, logging_1.traceVerbose)(`conda info --json: ${result.stdout}`);
    const packages = stdout ? JSON.parse(result.stdout) : [];
    return packages;
}
exports.getCondaPackages = getCondaPackages;
async function getOutdatedCondaPackages(env) {
    var _a, _b, _c;
    if (!(0, utils_1.isCondaEnvironment)(env) || !env.executable.uri) {
        return;
    }
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        return;
    }
    const args = ['update', '--all', '-d'].concat(((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name)
        ? ['-n', env.environment.name]
        : ['-p', ((_c = (_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri) === null || _c === void 0 ? void 0 : _c.fsPath) || path.dirname(env.path)]);
    const result = await (0, externalDependencies_1.exec)(conda.command, args.concat(['--json']), { timeout: 60000 });
    const stdout = result.stdout.trim();
    (0, logging_1.traceVerbose)(`conda ${args.join(' ')} --json: ${result.stdout}`);
    if (!stdout) {
        return;
    }
    const map = new Map();
    const unlink = new Set();
    const { actions } = JSON.parse(result.stdout);
    actions.UNLINK.forEach((pkg) => unlink.add(pkg.name));
    actions.LINK.forEach((pkg) => {
        if (unlink.has(pkg.name)) {
            map.set(pkg.name, pkg.version);
        }
    });
    return map;
}
exports.getOutdatedCondaPackages = getOutdatedCondaPackages;
async function updateCondaPackages(env) {
    var _a, _b, _c;
    if (!(0, utils_1.isCondaEnvironment)(env) || !env.executable.uri) {
        return;
    }
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        return;
    }
    const args = ['update', '--all'].concat(((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name)
        ? ['-n', env.environment.name]
        : ['-p', ((_c = (_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri) === null || _c === void 0 ? void 0 : _c.fsPath) || path.dirname(env.path)]);
    await (0, externalDependencies_1.exec)(conda.command, args, { timeout: 60000 });
}
exports.updateCondaPackages = updateCondaPackages;
async function getUninstallCondaPackageSpawnOptions(env, pkg, _token) {
    var _a, _b, _c;
    if (!(0, utils_1.isCondaEnvironment)(env) || !env.executable.uri) {
        throw new Error('Not Supported');
    }
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        throw new Error('Not Supported');
    }
    const args = ['remove', pkg.name, '-y'].concat(((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name)
        ? ['-n', env.environment.name]
        : ['-p', ((_c = (_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri) === null || _c === void 0 ? void 0 : _c.fsPath) || path.dirname(env.path)]);
    return { command: conda.command, args };
}
exports.getUninstallCondaPackageSpawnOptions = getUninstallCondaPackageSpawnOptions;
async function updateCondaPackage(env, pkg) {
    var _a, _b, _c;
    if (!(0, utils_1.isCondaEnvironment)(env) || !env.executable.uri) {
        return;
    }
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        return;
    }
    const args = ['update', pkg.name, '-y'].concat(((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name)
        ? ['-n', env.environment.name]
        : ['-p', ((_c = (_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri) === null || _c === void 0 ? void 0 : _c.fsPath) || path.dirname(env.path)]);
    await (0, externalDependencies_1.exec)(conda.command, args, { timeout: 60000 });
}
exports.updateCondaPackage = updateCondaPackage;
async function deleteEnv(env, progress) {
    var _a, _b, _c;
    if (!(0, utils_1.isCondaEnvironment)(env)) {
        (0, logging_1.traceError)(`Cannot delete as its not a conda environment or no name/path for ${(0, helpers_1.getEnvLoggingInfo)(env)}`);
        return;
    }
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        return;
    }
    const args = ((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name)
        ? ['-n', env.environment.name]
        : ['-p', ((_c = (_b = env.environment) === null || _b === void 0 ? void 0 : _b.folderUri) === null || _c === void 0 ? void 0 : _c.fsPath) || env.path];
    const message = `Deleting conda environment ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[
        conda.command,
        'env',
        'remove',
    ]
        .concat(args)
        .join(' ')}`;
    (0, logging_1.traceVerbose)(message);
    progress.report({ message });
    const result = await (0, rawProcessApis_1.execObservable)(conda.command, ['env', 'remove'].concat(args), { timeout: 60000 });
    await new Promise((resolve) => {
        result.out.subscribe({
            next: (output) => progress.report({ message: output.out }),
            complete: () => resolve(),
        });
    });
    if (await fs.pathExists(env.path)) {
        throw new Error(`Failed to delete conda environment ${(0, helpers_1.getEnvDisplayInfo)(env)}, folder still exists ${(0, helpers_1.getDisplayPath)(env.path)} `);
    }
}
exports.deleteEnv = deleteEnv;
async function getCondaVersion() {
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        return;
    }
    return conda.getInfo().catch((ex) => (0, logging_1.traceError)('Failed to get conda info', ex));
}
exports.getCondaVersion = getCondaVersion;
function getLatestCondaPythonVersion(environments) {
    let maxMajorVersion = 3;
    let maxMinorVersion = 9;
    environments
        .filter((env) => (0, utils_1.isCondaEnvironment)(env))
        .forEach((env) => {
        var _a, _b, _c, _d, _e, _f, _g;
        if (!((_a = env.version) === null || _a === void 0 ? void 0 : _a.major) || ((_b = env.version) === null || _b === void 0 ? void 0 : _b.major) < maxMajorVersion) {
        }
        else if (((_c = env.version) === null || _c === void 0 ? void 0 : _c.major) > maxMajorVersion) {
            maxMajorVersion = (_d = env.version) === null || _d === void 0 ? void 0 : _d.major;
            maxMinorVersion = ((_e = env.version) === null || _e === void 0 ? void 0 : _e.minor) || 0;
        }
        else if ((((_f = env.version) === null || _f === void 0 ? void 0 : _f.minor) || 0) > maxMinorVersion) {
            maxMinorVersion = ((_g = env.version) === null || _g === void 0 ? void 0 : _g.minor) || 0;
        }
    });
    return `${maxMajorVersion}.${maxMinorVersion}`;
}
async function createEnv() {
    const api = await python_extension_1.PythonExtension.api();
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        (0, logging_1.traceError)(`Conda not found`);
        return;
    }
    const initialState = { name: '' };
    const availableMaxPythonVersion = getLatestCondaPythonVersion(api.environments.known);
    const selectVersion = async (input, state) => {
        const version = await input.showInputBox({
            title: 'Select Python Version',
            validate: async (value) => {
                if (!value.trim().length) {
                    return 'Enter a Python version such as 3.9';
                }
            },
            placeholder: '3.7, 3.8, 3.9, 3.10, etc',
            prompt: 'Python Version',
            value: availableMaxPythonVersion,
        });
        state.pythonVersion = version === null || version === void 0 ? void 0 : version.trim();
    };
    const specifyName = async (input, state) => {
        const name = await input.showInputBox({
            title: 'Enter the name of the virtual environment',
            value: '.venv',
            step: 1,
            totalSteps: 3,
            prompt: 'Name',
            validate: async (value) => {
                if (!value) {
                    return 'Enter a name';
                }
            },
        });
        if (name) {
            state.name = name.trim();
            return selectVersion(input, state);
        }
    };
    const multistepInput = new multiStepInput_1.MultiStepInput(new applicationShell_1.ApplicationShell());
    await multistepInput.run(specifyName, initialState);
    if (!initialState.name.trim() || !initialState.pythonVersion) {
        return;
    }
    await vscode_1.window.withProgress({
        location: vscode_1.ProgressLocation.Notification,
        cancellable: true,
        title: `Creating environment '${initialState.name.trim()}'`,
    }, async (uiProgress, token) => {
        await createEnvWithInfo(uiProgress, token, initialState.name.trim(), conda.command, initialState.pythonVersion);
    });
}
exports.createEnv = createEnv;
async function createEnvWithInfo(progress, token, name, condaFile, pythonVersion = '3.9') {
    var _a;
    try {
        const isMicroMamba = condaFile.includes('.micromamba');
        progress.report({ message: `Creating environment ${name}` });
        (0, logging_1.traceInfo)(`Creating conda environment ${name} with python version ${pythonVersion}`);
        const extraCreationArgs = isMicroMamba ? ['-c', 'conda-forge'] : [];
        const args = ['create', `-n`, `${name.trim()}`, `python=${pythonVersion || '3.9'}`]
            .concat(extraCreationArgs)
            .concat(['-y']);
        (0, logging_1.traceInfo)([condaFile].concat(args).join(' '));
        const result = await (0, rawProcessApis_1.execObservable)(condaFile, args, {
            timeout: 120000,
            token,
        });
        (_a = result.proc) === null || _a === void 0 ? void 0 : _a.on('error', (ex) => console.error(`Conda create exited with an error`, ex));
        await new Promise((resolve, reject) => {
            result.out.subscribe({
                next: (output) => {
                    if (output.out.trim().length) {
                        progress.report({ message: output.out });
                    }
                    (0, logging_1.traceInfo)(output.out);
                },
                complete: () => resolve(),
                error: (ex) => reject(ex),
            });
        });
        if (isMicroMamba) {
            await updateEnvironmentsTxt(path.join(constants_1.MICROMAMBA_ROOTPREFIX, name.trim())).catch((ex) => (0, logging_1.traceError)('Failed to update environments.txt', ex));
        }
        progress.report({ message: 'Waiting for environment to be detected' });
        const api = await python_extension_1.PythonExtension.api();
        await api.environments.refreshEnvironments();
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to create environment`, ex);
        vscode_1.window.showErrorMessage(`Failed to create environment ${name}, ${ex}`);
    }
}
async function updateEnvironmentsTxt(envFolder) {
    const txtFile = path.join((0, platform_1.getUserHomeDir)() || helpers_1.home, '.conda', 'environments.txt');
    const contents = await fs.readFile(txtFile, 'utf-8');
    if (contents.includes(envFolder)) {
        return;
    }
    await fs.writeFile(txtFile, `${contents.trim()}${os_1.EOL}${envFolder}${os_1.EOL}`);
}
exports.updateEnvironmentsTxt = updateEnvironmentsTxt;
async function exportCondaPackages(env) {
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        (0, logging_1.traceError)(`Conda not found`);
        return;
    }
    if (!env.executable.sysPrefix) {
        return;
    }
    const result = await (0, externalDependencies_1.exec)(conda.command, ['env', 'export', '-p', env.executable.sysPrefix.fileToCommandArgumentForPythonMgrExt()], { timeout: 60000 });
    return { contents: result.stdout, language: 'yaml', file: 'environment.yml' };
}
exports.exportCondaPackages = exportCondaPackages;
async function getCondaPackageInstallSpawnOptions(env, packageInfo, _token) {
    const conda = await conda_1.Conda.getConda();
    if (!conda) {
        throw new Error(`Conda not found`);
    }
    if (!env.executable.sysPrefix) {
        throw new Error(`Invalid Conda Env`);
    }
    const args = ['install'];
    if (packageInfo.channel) {
        args.push('-c', packageInfo.channel);
    }
    args.push(`${packageInfo.name}==${packageInfo.version}`);
    args.push('-p', env.executable.sysPrefix.fileToCommandArgumentForPythonMgrExt(), '-y');
    return { command: conda.command, args };
}
exports.getCondaPackageInstallSpawnOptions = getCondaPackageInstallSpawnOptions;
async function searchCondaPackage(value, _env, token) {
    try {
        const conda = await conda_1.Conda.getConda();
        if (!conda) {
            (0, logging_1.traceError)(`Conda not found`);
            return [];
        }
        const message = `Searching for Conda packages with command ${[
            conda.command,
            'search',
            '-f',
            value,
        ]}]}`;
        (0, logging_1.traceVerbose)(message);
        const result = await (0, externalDependencies_1.exec)(conda.command, ['search', '-f', value], { timeout: 60000, token });
        const lines = result.stdout
            .split(/\r?\n/g)
            .filter((line) => line.trim().length)
            .filter((line) => !line.startsWith('Loading channels: done'))
            .filter((line) => !line.startsWith('# Name'));
        if (lines.length === 0) {
            return [];
        }
        const items = [];
        const addedItems = new Set();
        lines.forEach((line) => {
            const parts = line
                .split(' ')
                .map((p) => p.trim())
                .filter((p) => p.length);
            if (parts.length !== 4) {
                return;
            }
            const key = `${parts[0]}-${parts[1]}-${parts[3]}`;
            if (addedItems.has(key)) {
                return;
            }
            addedItems.add(key);
            const item = { name: parts[0], version: parts[1], channel: parts[3] };
            items.push({ label: item.name, description: `${item.version} (${item.channel})`, item });
        });
        return items.reverse();
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to search for package`, ex);
        return [];
    }
}
exports.searchCondaPackage = searchCondaPackage;


/***/ }),

/***/ "./src/environments/tools/pip.ts":
/*!***************************************!*\
  !*** ./src/environments/tools/pip.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.searchPipPackage = exports.exportPipPackages = exports.getInstallPipPackageSpawnOptions = exports.getUninstallPipPackageSpawnOptions = exports.updatePipPackages = exports.updatePipPackage = exports.getOutdatedPipPackages = exports.getPipPackages = void 0;
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const externalDependencies_1 = __webpack_require__(/*! ../../client/pythonEnvironments/common/externalDependencies */ "./src/client/pythonEnvironments/common/externalDependencies.ts");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
async function getPipPackages(env) {
    if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Conda) {
        return;
    }
    const result = await (0, externalDependencies_1.exec)(env.path, ['-m', 'pip', 'list', '--format', 'json'], { timeout: 60000 });
    (0, logging_1.traceVerbose)(`python -m pip list --format --json: ${result.stdout}`);
    const stdout = result.stdout.trim();
    const packages = stdout ? JSON.parse(result.stdout) : [];
    return packages;
}
exports.getPipPackages = getPipPackages;
async function getOutdatedPipPackages(env) {
    if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Conda) {
        return;
    }
    const result = await (0, externalDependencies_1.exec)(env.path, ['-m', 'pip', 'list', '--outdated', '--format', 'json'], { timeout: 60000 });
    (0, logging_1.traceVerbose)(`python -m pip list --format --json: ${result.stdout}`);
    const stdout = result.stdout.trim();
    if (!stdout) {
        return;
    }
    const map = new Map();
    JSON.parse(result.stdout).forEach((pkg) => map.set(pkg.name, pkg.latest_version));
    return map;
}
exports.getOutdatedPipPackages = getOutdatedPipPackages;
async function updatePipPackage(env, pkg) {
    if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Conda) {
        return [];
    }
    await (0, externalDependencies_1.exec)(env.path, ['-m', 'pip', 'install', '-U', pkg.name], { timeout: 60000 });
}
exports.updatePipPackage = updatePipPackage;
async function updatePipPackages(env) {
    if ((0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Conda) {
        return [];
    }
    const outdatedPackages = await getOutdatedPipPackages(env);
    const packages = outdatedPackages ? Array.from(outdatedPackages === null || outdatedPackages === void 0 ? void 0 : outdatedPackages.values()) : [];
    if (packages.length === 0) {
        (0, logging_1.traceError)(`No outdated packages found for ${env.id}`);
    }
    await (0, externalDependencies_1.exec)(env.path, ['-m', 'pip', 'install', '-U', ...packages], { timeout: 60000 });
}
exports.updatePipPackages = updatePipPackages;
async function getUninstallPipPackageSpawnOptions(env, pkg, _token) {
    return { command: env.path, args: ['-m', 'pip', 'uninstall', '-y', pkg.name] };
}
exports.getUninstallPipPackageSpawnOptions = getUninstallPipPackageSpawnOptions;
async function getInstallPipPackageSpawnOptions(env, pkg, _token) {
    return { command: env.path, args: ['-m', 'pip', 'install', pkg.name, '-q'] };
}
exports.getInstallPipPackageSpawnOptions = getInstallPipPackageSpawnOptions;
async function exportPipPackages(env) {
    const result = await (0, externalDependencies_1.exec)(env.path, ['-m', 'pip', 'freeze'], { timeout: 60000 });
    return { contents: result === null || result === void 0 ? void 0 : result.stdout, language: 'pip-requirements', file: 'requirements.txt' };
}
exports.exportPipPackages = exportPipPackages;
async function searchPipPackage(value, _env, token) {
    const [page1Results, page2Results, page3Results] = await Promise.all([
        searchPackageByPage(value, 1, token),
        searchPackageByPage(value, 2, token),
        searchPackageByPage(value, 3, token),
    ]);
    const items = [...page1Results, ...page2Results, ...page3Results];
    return items.map(p => {
        const description = p.version ? `${p.version} ${p.updated ? `(${p.updated})` : ''}` : '';
        return { label: p.name, description, detail: p.description, item: p, alwaysShow: true };
    });
}
exports.searchPipPackage = searchPipPackage;
async function searchPackageByPage(value, page, token) {
    const pageQuery = page === 1 ? '' : `&page=${page}`;
    const response = await fetch(`https://pypi.org/search/?q=${encodeURIComponent(value)}${pageQuery}`);
    if (token.isCancellationRequested) {
        return [];
    }
    if (response.status !== 200) {
        return [];
    }
    const html = await response.text();
    const results = html.substring(html.indexOf(' <ul class="unstyled" aria-label="Search results">'));
    const packages = [];
    results
        .substring(0, results.indexOf('</ul>'))
        .split('<li>')
        .forEach((item) => {
        let name = '';
        if (item.indexOf('<span class="package-snippet__name">')) {
            name = item.substring(item.indexOf('<span class="package-snippet__name">') +
                '<span class="package-snippet__name">'.length);
            name = name.substring(0, name.indexOf('</span>')).trim();
        }
        let version = '';
        if (item.indexOf('<span class="package-snippet__version">')) {
            version = item.substring(item.indexOf('<span class="package-snippet__version">') +
                '<span class="package-snippet__version">'.length);
            version = version.substring(0, version.indexOf('</span>')).trim();
        }
        let desc = '';
        if (item.indexOf('<p class="package-snippet__description">')) {
            desc = item.substring(item.indexOf('<p class="package-snippet__description">') +
                '<p class="package-snippet__description">'.length);
            desc = desc.substring(0, desc.indexOf('</p>')).trim();
        }
        let updated = '';
        if (item.indexOf('<span class="package-snippet__created">')) {
            updated = item.substring(item.indexOf('<span class="package-snippet__created">') +
                '<span class="package-snippet__created">'.length);
            updated = updated.substring(0, updated.indexOf('</time>'));
            updated = updated.substring(updated.indexOf('>') + 1).trim();
        }
        if (name && version) {
            packages.push({ name, version, description: desc, updated });
        }
    });
    return packages;
}


/***/ }),

/***/ "./src/environments/tools/poetry.ts":
/*!******************************************!*\
  !*** ./src/environments/tools/poetry.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.searchPoetryPackage = exports.exportPoetryPackages = exports.getPoetryPackageInstallSpawnOptions = exports.getUninstallPoetryPackageSpawnOptions = exports.updatePoetryPackages = exports.deleteEnv = exports.hasPoetryEnvs = exports.getPoetryEnvironments = exports.getPoetryVersion = void 0;
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const poetry_1 = __webpack_require__(/*! ../../client/pythonEnvironments/common/environmentManagers/poetry */ "./src/client/pythonEnvironments/common/environmentManagers/poetry.ts");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const helpers_1 = __webpack_require__(/*! ../helpers */ "./src/environments/helpers.ts");
const rawProcessApis_1 = __webpack_require__(/*! ../../client/common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const misc_1 = __webpack_require__(/*! ../../client/common/utils/misc */ "./src/client/common/utils/misc.ts");
const folderMappings = new Map();
async function getPoetryVersion() {
    const cwd = !vscode_1.workspace.workspaceFolders || vscode_1.workspace.workspaceFolders.length <= 1
        ? __dirname
        : vscode_1.workspace.workspaceFolders[0].uri.fsPath;
    return poetry_1.Poetry.getVersion(cwd).catch(misc_1.noop);
}
exports.getPoetryVersion = getPoetryVersion;
async function getPoetryEnvironments(workspaceFolder, envs) {
    if (!vscode_1.workspace.workspaceFolders || vscode_1.workspace.workspaceFolders.length <= 1) {
        const poetryEnvs = envs.filter((e) => (0, utils_1.getEnvironmentType)(e) === info_1.EnvironmentType.Poetry);
        folderMappings.set(workspaceFolder.uri.fsPath, poetryEnvs.map((e) => e.path));
        return poetryEnvs;
    }
    const poetry = await poetry_1.Poetry.getPoetry(workspaceFolder.uri.fsPath);
    if (!poetry) {
        return [];
    }
    const envPaths = await poetry.getEnvList();
    if (!envPaths || !Array.isArray(envPaths)) {
        return [];
    }
    folderMappings.set(workspaceFolder.uri.fsPath, envPaths);
    return envs
        .filter((e) => envPaths.includes(e.path))
        .filter((e) => (0, utils_1.getEnvironmentType)(e) === info_1.EnvironmentType.Poetry);
}
exports.getPoetryEnvironments = getPoetryEnvironments;
function hasPoetryEnvs(envs) {
    return envs.some((e) => (0, utils_1.getEnvironmentType)(e) === info_1.EnvironmentType.Poetry);
}
exports.hasPoetryEnvs = hasPoetryEnvs;
function getMatchingWorkspaceFolder(env) {
    var _a;
    if ((0, utils_1.getEnvironmentType)(env) !== info_1.EnvironmentType.Poetry) {
        (0, logging_1.traceError)(`Cannot delete as its not a Poetry environment ${(0, helpers_1.getEnvLoggingInfo)(env)}`);
        return;
    }
    let workspaceFolderPath;
    folderMappings.forEach((envPaths, folder) => {
        if (envPaths.some((e) => env.path.includes(e))) {
            workspaceFolderPath = folder;
        }
    });
    if (!workspaceFolderPath) {
        (0, logging_1.traceError)(`Cannot delete as its not a belong to any workspace folder we know of ${(0, helpers_1.getEnvLoggingInfo)(env)}`);
    }
    return (_a = vscode_1.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.find((w) => w.uri.fsPath === workspaceFolderPath);
}
async function getPoetry(env) {
    const workspaceFolder = getMatchingWorkspaceFolder(env);
    if (!workspaceFolder) {
        return { workspaceFolder: undefined, poetry: undefined };
    }
    const poetry = await poetry_1.Poetry.getPoetry(workspaceFolder.uri.fsPath);
    return { workspaceFolder, poetry };
}
async function deleteEnv(env, progress) {
    const { poetry, workspaceFolder } = await getPoetry(env);
    if (!poetry) {
        return [];
    }
    const args = [env.path.fileToCommandArgumentForPythonMgrExt()];
    const message = `Deleting Poetry environment ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[
        poetry.command,
        'env',
        env.path,
    ]
        .concat(args)
        .join(' ')}`;
    (0, logging_1.traceVerbose)(message);
    progress.report({ message });
    const result = await (0, rawProcessApis_1.execObservable)(poetry.command, ['env', 'remove'].concat(args), {
        timeout: 60000,
        cwd: workspaceFolder.uri.fsPath,
    });
    await new Promise((resolve) => {
        result.out.subscribe({
            next: (output) => progress.report({ message: output.out }),
            complete: () => resolve(),
        });
    });
    if (await fs.pathExists(env.path)) {
        throw new Error(`Failed to delete Poetry environment ${(0, helpers_1.getEnvDisplayInfo)(env)}, folder still exists ${(0, helpers_1.getDisplayPath)(env.path)} `);
    }
}
exports.deleteEnv = deleteEnv;
async function updatePoetryPackages(env) {
    const { poetry, workspaceFolder } = await getPoetry(env);
    if (!poetry) {
        return [];
    }
    const message = `Updating Poetry environment ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[poetry.command, 'update']}`;
    (0, logging_1.traceVerbose)(message);
    const result = await (0, rawProcessApis_1.execObservable)(poetry.command, ['update'], {
        timeout: 60000,
        cwd: workspaceFolder.uri.fsPath,
    });
    await new Promise((resolve) => {
        result.out.subscribe({
            complete: () => resolve(),
        });
    });
}
exports.updatePoetryPackages = updatePoetryPackages;
async function getUninstallPoetryPackageSpawnOptions(env, packageName, _token) {
    const { poetry, workspaceFolder } = await getPoetry(env);
    if (!poetry) {
        throw new Error('Not Supported');
    }
    return { command: poetry.command, args: ['remove', packageName], options: { cwd: workspaceFolder.uri.fsPath } };
}
exports.getUninstallPoetryPackageSpawnOptions = getUninstallPoetryPackageSpawnOptions;
async function getPoetryPackageInstallSpawnOptions(env, packageName, _token) {
    const { poetry, workspaceFolder } = await getPoetry(env);
    if (!poetry) {
        throw new Error('Not Supported');
    }
    return { command: poetry.command, args: ['add', packageName], options: { cwd: workspaceFolder.uri.fsPath } };
}
exports.getPoetryPackageInstallSpawnOptions = getPoetryPackageInstallSpawnOptions;
async function exportPoetryPackages(env) {
    const { poetry, workspaceFolder } = await getPoetry(env);
    if (!poetry) {
        return;
    }
    const message = `Exporting Poetry package from ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[
        poetry.command,
        'export',
        '-f',
        'requirements.txt',
    ]}]}`;
    (0, logging_1.traceVerbose)(message);
    const result = await (0, rawProcessApis_1.shellExec)(`${poetry.command.fileToCommandArgumentForPythonMgrExt()} export -f requirements.txt`, {
        timeout: 60000,
        cwd: workspaceFolder.uri.fsPath,
        throwOnStdErr: true,
    }).catch((ex) => (0, logging_1.traceError)(`Failed to export packages from ${(0, helpers_1.getEnvLoggingInfo)(env)}`, ex));
    return { contents: result === null || result === void 0 ? void 0 : result.stdout, language: 'pip-requirements', file: 'requirements.txt' };
}
exports.exportPoetryPackages = exportPoetryPackages;
async function searchPoetryPackage(value, env, token) {
    const { poetry, workspaceFolder } = await getPoetry(env);
    if (!poetry) {
        return [];
    }
    const message = `Searching for Poetry packages from ${(0, helpers_1.getEnvLoggingInfo)(env)} with command ${[
        poetry.command,
        'search',
        value,
        '-n',
        '--no-ansi',
    ]}]}`;
    (0, logging_1.traceVerbose)(message);
    const result = await (0, rawProcessApis_1.shellExec)(`${poetry.command.fileToCommandArgumentForPythonMgrExt()} search ${value}`, {
        timeout: 60000,
        cwd: workspaceFolder.uri.fsPath,
        throwOnStdErr: true,
    }).catch(misc_1.noop);
    if (!result) {
        return [];
    }
    const items = [];
    let label = '';
    let description = '';
    let detail = '';
    result.stdout.split(/\r?\n/g).forEach((line) => {
        if (!label && !line.trim().length) {
            return;
        }
        if (!label && line.trim().startsWith(line.charAt(0))) {
            label = line.trim();
            if (label.includes('(') && label.endsWith(')')) {
                description = label.substring(label.lastIndexOf('(') + 1, label.lastIndexOf(')'));
                label = label.substring(0, label.lastIndexOf('(')).trim();
            }
            detail = '';
            return;
        }
        if (label) {
            detail = line.trim();
            items.push({ label, detail, description, item: label });
            label = '';
            detail = '';
        }
    });
    if (token.isCancellationRequested) {
        return [];
    }
    return items;
}
exports.searchPoetryPackage = searchPoetryPackage;


/***/ }),

/***/ "./src/environments/tools/pyenv.ts":
/*!*****************************************!*\
  !*** ./src/environments/tools/pyenv.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getPyEnvVersion = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const child_process_1 = __webpack_require__(/*! child_process */ "child_process");
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const pyenv_1 = __webpack_require__(/*! ../../client/pythonEnvironments/common/environmentManagers/pyenv */ "./src/client/pythonEnvironments/common/environmentManagers/pyenv.ts");
const terminal_1 = __webpack_require__(/*! ../terminal */ "./src/environments/terminal.ts");
const async_1 = __webpack_require__(/*! ../../client/common/utils/async */ "./src/client/common/utils/async.ts");
const createEnvApi_1 = __webpack_require__(/*! ../../client/pythonEnvironments/creation/createEnvApi */ "./src/client/pythonEnvironments/creation/createEnvApi.ts");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const stringUtils_1 = __webpack_require__(/*! ../../client/common/stringUtils */ "./src/client/common/stringUtils.ts");
const pyEnvEnvVars = (0, async_1.createDeferred)();
pyEnvEnvVars.promise.then(() => {
    (0, createEnvApi_1.registerCreateEnvironmentProvider)({
        createEnvironment: async () => new Promise(async (resolve) => {
            const input = vscode_1.window.createQuickPick();
            input.title = 'Select Python Version to Install';
            input.busy = true;
            input.ignoreFocusOut = false;
            input.matchOnDescription = true;
            ;
            input.matchOnDetail = true;
            ;
            input.onDidHide(() => { resolve({ action: 'Cancel', error: undefined, path: undefined, workspaceFolder: undefined }); input.hide(); });
            input.show();
            input.onDidAccept(async () => {
                const version = input.selectedItems[0].label;
                input.enabled = false;
                input.busy = true;
                installPython(version).finally(() => { input.hide(); resolve({ action: 'Cancel', error: undefined, path: undefined, workspaceFolder: undefined }); });
            });
            const [installedVersions, allVersions] = await Promise.all([getInstalledPythonVersions(), getPythonVersions()]);
            input.busy = false;
            input.items = allVersions.filter(v => !installedVersions.includes(v)).map(v => ({ label: v }));
        }),
        description: "PyEnv",
        id: 'pyenv',
        name: 'PyEnv',
        tools: [info_1.EnvironmentType.Pyenv]
    });
});
async function getPyEnvVersion(iocContainer) {
    const dir = (0, pyenv_1.getPyenvDir)();
    const changelogFile = path.join(dir, 'CHANGELOG.md');
    try {
        if (await fs.pathExists(changelogFile)) {
            const textFile = await fs.readFile(changelogFile, 'utf-8');
            const versionStart = textFile.indexOf('## Release ');
            if (versionStart === -1) {
                (0, logging_1.traceError)(`Failed to identify pyenv version from ${changelogFile}, with text ${textFile.substring(0, 100)} `);
                return;
            }
            const start = versionStart + '## Release '.length;
            const verionLines = (0, stringUtils_1.splitLines)(textFile
                .substring(start, start + 20))
                .map((line) => line.trim())
                .filter((line) => line.length);
            return verionLines.length === 0 ? '' : verionLines[0];
        }
        return Promise.race([
            getPyEnvVersionFromSpawn(process.env),
            new Promise((resolve) => (0, terminal_1.getTerminalEnvVariables)(iocContainer).then(env => env ? getPyEnvVersionFromSpawn(env).then(resolve) : undefined))
        ]).catch(() => '');
    }
    catch (ex) {
        (0, logging_1.traceError)('Failed to get pyenv version', ex);
    }
}
exports.getPyEnvVersion = getPyEnvVersion;
async function getPythonVersions() {
    return pyEnvEnvVars.promise.then(env => new Promise(resolve => {
        const proc = (0, child_process_1.spawn)('pyenv', ['install', '-l'], { env });
        let output = '';
        proc.stdout.on('data', data => {
            output += data.toString();
        });
        proc.on('close', () => {
            const versions = output.trim().split(/\r?\n/g);
            resolve(versions.map(v => v.trim()).filter(v => v.length && v.trim() !== 'Available versions:'));
        });
    }));
}
async function getInstalledPythonVersions() {
    return pyEnvEnvVars.promise.then(env => new Promise(resolve => {
        const proc = (0, child_process_1.spawn)('pyenv', ['version', '--bare'], { env });
        let output = '';
        proc.stdout.on('data', data => {
            output += data.toString();
        });
        proc.on('close', () => {
            const versions = output.trim().split(/\r?\n/g);
            resolve(versions.map(v => v.trim()).filter(v => v.length));
        });
    }));
}
async function installPython(version) {
    return vscode_1.window.withProgress({ location: vscode_1.ProgressLocation.Notification, cancellable: true, title: `Installing Python ${version}` }, (progress, token) => pyEnvEnvVars.promise.then(env => new Promise((resolve, reject) => {
        const proc = (0, child_process_1.spawn)('pyenv', ['install', version], { env });
        let stdErr = '';
        let failureError;
        const ticker = ['.', '..', '...'];
        let counter = 0;
        const reportProgress = (data) => {
            if (token.isCancellationRequested) {
                return;
            }
            const suffix = ticker[counter % 3];
            const trimmedOutput = data.toString().trim();
            counter += 1;
            const message = trimmedOutput.length > 28 ? `${trimmedOutput.substring(0, 28)}${suffix}` : trimmedOutput;
            progress.report({ message });
        };
        proc.stdout.on('data', data => {
            stdErr += data.toString();
            reportProgress(data.toString());
        });
        proc.stderr.on('data', data => {
            stdErr += data.toString();
            reportProgress(data.toString());
        });
        proc.on('error', err => {
            console.error(`Failed to install Python ${version} via PyEnv`, err);
            failureError = err;
            stdErr += err.toString();
        });
        proc.on('close', (code) => {
            if (code) {
                vscode_1.window.showErrorMessage(`Failed to install Python ${version}, via PyEnv`);
                reject(failureError || new Error(stdErr));
            }
            else {
                resolve();
            }
        });
        token.onCancellationRequested(() => proc.kill());
    })));
}
async function getPyEnvVersionFromSpawn(env) {
    return new Promise(resolve => {
        const proc = (0, child_process_1.spawn)('pyenv', ['--version'], { env });
        let output = '';
        proc.stdout.on('data', data => {
            output += data.toString();
        });
        proc.on('close', () => {
            const version = output.toString().trim().replace('pyenv', '').trim();
            if (version) {
                pyEnvEnvVars.resolve(env);
                resolve(version);
            }
        });
    });
}


/***/ }),

/***/ "./src/environments/tools/venv.ts":
/*!****************************************!*\
  !*** ./src/environments/tools/venv.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createEnvOld = exports.canCreateVirtualEnv = exports.deleteEnv = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const fs = __webpack_require__(/*! fs-extra */ "./node_modules/fs-extra/lib/index.js");
const path = __webpack_require__(/*! path */ "path");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const applicationShell_1 = __webpack_require__(/*! ../../client/common/application/applicationShell */ "./src/client/common/application/applicationShell.ts");
const rawProcessApis_1 = __webpack_require__(/*! ../../client/common/process/rawProcessApis */ "./src/client/common/process/rawProcessApis.ts");
const multiStepInput_1 = __webpack_require__(/*! ../../client/common/utils/multiStepInput */ "./src/client/common/utils/multiStepInput.ts");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const helpers_1 = __webpack_require__(/*! ../helpers */ "./src/environments/helpers.ts");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
async function deleteEnv(env) {
    var _a, _b;
    const envType = (0, utils_1.getEnvironmentType)(env);
    if (envType !== info_1.EnvironmentType.Venv &&
        envType !== info_1.EnvironmentType.VirtualEnv &&
        envType !== info_1.EnvironmentType.VirtualEnvWrapper) {
        (0, logging_1.traceError)(`Cannot delete as its not a virtual environment ${(0, helpers_1.getEnvLoggingInfo)(env)}`);
        return;
    }
    const baseDir = path.dirname(env.path);
    if (!baseDir.toLowerCase().endsWith('scripts') && !baseDir.toLowerCase().endsWith('bin')) {
        (0, logging_1.traceError)(`Cannot delete as its not a virtual environment with script/bin directory ${(0, helpers_1.getEnvLoggingInfo)(env)}`);
        return;
    }
    const dirToDelete = ((_b = (_a = env.environment) === null || _a === void 0 ? void 0 : _a.folderUri) === null || _b === void 0 ? void 0 : _b.fsPath) || path.dirname(path.dirname(env.path));
    (0, logging_1.traceVerbose)(`Deleting virtual environment ${(0, helpers_1.getEnvLoggingInfo)(env)}`);
    await fs.remove(dirToDelete);
}
exports.deleteEnv = deleteEnv;
function getSortedEnvsFromWhichWeCanCreateVenvEnv(environments) {
    return environments
        .filter((env) => {
        switch ((0, utils_1.getEnvironmentType)(env)) {
            case info_1.EnvironmentType.Global:
            case info_1.EnvironmentType.System:
            case info_1.EnvironmentType.Venv:
            case info_1.EnvironmentType.VirtualEnv:
            case info_1.EnvironmentType.VirtualEnvWrapper:
                return true;
            default:
                return false;
        }
    })
        .sort((a, b) => {
        const v1 = a.version;
        const v2 = b.version;
        if (v1 && v2) {
            if (v1.major === v2.major) {
                if (v1.minor === v2.minor) {
                    if (v1.micro === v2.micro) {
                        return 0;
                    }
                    return (v1.micro || 0) > (v2.minor || 0) ? -1 : 1;
                }
                return (v1.minor || 0) > (v2.minor || 0) ? -1 : 1;
            }
            return (v1.major || 0) > (v2.major || 0) ? -1 : 1;
        }
        if (v1 && !v2) {
            return 1;
        }
        if (!v1 && v2) {
            return -1;
        }
        return 0;
    });
}
function canCreateVirtualEnv(environments) {
    return getSortedEnvsFromWhichWeCanCreateVenvEnv(environments).length;
}
exports.canCreateVirtualEnv = canCreateVirtualEnv;
async function createEnvOld() {
    var _a;
    const api = await python_extension_1.PythonExtension.api();
    const templateEnvs = getSortedEnvsFromWhichWeCanCreateVenvEnv(api.environments.known);
    if (templateEnvs.length === 0) {
        (0, logging_1.traceError)(`Cannot create a venv without an existing Python environment`);
        return;
    }
    const latestGlobal = templateEnvs.filter((env) => (0, utils_1.getEnvironmentType)(env) === info_1.EnvironmentType.Global);
    const currentWorkspaceUri = ((_a = vscode_1.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) ? vscode_1.workspace.workspaceFolders[0].uri : undefined;
    const templateEnvironment = latestGlobal.length ? latestGlobal[0] : templateEnvs[0];
    const initialState = { dir: '', name: '', templateEnvironment: undefined };
    const selectTemplateEnv = async (input, state) => {
        const quickPickItems = templateEnvs.map((env) => ({
            label: (0, helpers_1.getEnvDisplayInfo)(env),
            pythonEnvironment: env,
            picked: env === templateEnvironment,
            description: (0, helpers_1.getDisplayPath)(env.path),
        }));
        const templateEnv = (await input.showQuickPick({
            title: 'Select Python Environment to be used as a template for Virtual Environment',
            placeholder: 'Select Python Environment',
            acceptFilterBoxTextAsSelection: false,
            canGoBack: false,
            matchOnDescription: true,
            matchOnDetail: true,
            sortByLabel: false,
            step: 3,
            totalSteps: 3,
            items: quickPickItems,
        }));
        state.templateEnvironment = templateEnv === null || templateEnv === void 0 ? void 0 : templateEnv.pythonEnvironment;
    };
    const specifyDirectory = async (input, state) => {
        const browseButton = {
            iconPath: new vscode_1.ThemeIcon('folder'),
            tooltip: 'Select a folder',
        };
        let selectDirectory = true;
        while (selectDirectory) {
            const enterDirectoryPrompt = () => input.showInputBox({
                title: 'Enter fully qualified path to where the venv would be created',
                value: (currentWorkspaceUri === null || currentWorkspaceUri === void 0 ? void 0 : currentWorkspaceUri.fsPath) || '',
                step: 2,
                totalSteps: 3,
                prompt: 'Directory',
                validate: async (value) => {
                    if (!value && !currentWorkspaceUri) {
                        return 'Please specify a directory or click the browse button';
                    }
                    if (!value) {
                        return 'Enter a name';
                    }
                    if (!(await fs.pathExists(value))) {
                        return 'Invalid directory';
                    }
                    const targetVenvDir = path.join(value, state.name);
                    if (await fs.pathExists(targetVenvDir)) {
                        return `Virtual folder '${(0, helpers_1.getDisplayPath)(targetVenvDir)}' already exists`;
                    }
                },
                buttons: [browseButton],
            });
            const directory = await enterDirectoryPrompt();
            if (directory === browseButton) {
                const dir = await vscode_1.window.showOpenDialog({
                    canSelectFiles: false,
                    canSelectFolders: true,
                    canSelectMany: false,
                    defaultUri: currentWorkspaceUri,
                    openLabel: 'Select Folder',
                    title: 'Select destination for Virtual Environment',
                });
                if (Array.isArray(dir) && dir.length) {
                    const targetVenvDir = path.join(dir[0].fsPath, state.name);
                    if (await fs.pathExists(targetVenvDir)) {
                        void vscode_1.window.showErrorMessage('A folder with the same name already exists', {
                            modal: true,
                            detail: targetVenvDir,
                        });
                    }
                    else {
                        state.dir = dir[0].fsPath;
                        selectDirectory = false;
                        return selectTemplateEnv(input, state);
                    }
                }
            }
            else if (typeof directory === 'string') {
                selectDirectory = false;
                const targetVenvDir = path.join(directory.trim(), state.name);
                if (!(await fs.pathExists(directory.trim()))) {
                    void vscode_1.window.showErrorMessage('Invalid target directory for a Virtual Environment', {
                        modal: true,
                        detail: directory,
                    });
                }
                else if (await fs.pathExists(targetVenvDir)) {
                    void vscode_1.window.showErrorMessage('A folder with the same name already exists', {
                        modal: true,
                        detail: targetVenvDir,
                    });
                }
                else {
                    state.dir = directory.trim();
                    selectDirectory = false;
                    return selectTemplateEnv(input, state);
                }
            }
            else {
                selectDirectory = false;
            }
        }
    };
    const specifyName = async (input, state) => {
        const name = await input.showInputBox({
            title: 'Enter the name of the virtual environment',
            value: '.venv',
            step: 1,
            totalSteps: 3,
            prompt: 'Name',
            validate: async (value) => {
                if (!value) {
                    return 'Enter a name';
                }
            },
        });
        if (name) {
            state.name = name.trim();
            return specifyDirectory(input, state);
        }
    };
    const multistepInput = new multiStepInput_1.MultiStepInput(new applicationShell_1.ApplicationShell());
    await multistepInput.run(specifyName, initialState);
    if (!initialState.dir.trim() || !initialState.name.trim() || !initialState.templateEnvironment) {
        return;
    }
    if (!(await fs.pathExists(initialState.dir))) {
        return;
    }
    if (await fs.pathExists(path.join(initialState.dir, initialState.name))) {
        return;
    }
    try {
        await vscode_1.window.withProgress({
            location: vscode_1.ProgressLocation.Notification,
            title: `Creating environment ${initialState.name}`,
            cancellable: true,
        }, async (progress, token) => {
            (0, logging_1.traceInfo)(`Creating environment ${initialState.name}`);
            (0, logging_1.traceInfo)([initialState.templateEnvironment.path, '-m', 'venv', initialState.name].join(' '));
            const result = await (0, rawProcessApis_1.execObservable)(initialState.templateEnvironment.path, ['-m', 'venv', initialState.name], {
                timeout: 60000,
                cwd: initialState.dir,
                token,
            });
            await new Promise((resolve) => {
                result.out.subscribe({
                    next: (output) => {
                        (0, logging_1.traceInfo)(output.out);
                        progress.report({ message: output.out });
                    },
                    complete: () => resolve(),
                });
            });
        });
        void vscode_1.commands.executeCommand('python.envManager.refresh', false);
    }
    catch (ex) {
        (0, logging_1.traceError)(`Failed to create environment`, ex);
        vscode_1.window.showErrorMessage(`Failed to create environment ${initialState.name}, ${ex}`);
    }
}
exports.createEnvOld = createEnvOld;


/***/ }),

/***/ "./src/environments/utils.ts":
/*!***********************************!*\
  !*** ./src/environments/utils.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnvironmentType = exports.isNonPythonCondaEnvironment = exports.isCondaEnvironment = exports.getInterpreterDetailsFromExecPath = exports.getResolvedActiveInterpreter = void 0;
const python_extension_1 = __webpack_require__(/*! @vscode/python-extension */ "./node_modules/@vscode/python-extension/out/main.js");
const info_1 = __webpack_require__(/*! ../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
async function getResolvedActiveInterpreter(resource) {
    const api = await python_extension_1.PythonExtension.api();
    const activeEnv = api.environments.getActiveEnvironmentPath(resource);
    return activeEnv ? api.environments.resolveEnvironment(activeEnv) : undefined;
}
exports.getResolvedActiveInterpreter = getResolvedActiveInterpreter;
async function getInterpreterDetailsFromExecPath(execPath) {
    const api = await python_extension_1.PythonExtension.api();
    return api.environments.resolveEnvironment(execPath);
}
exports.getInterpreterDetailsFromExecPath = getInterpreterDetailsFromExecPath;
const KnownEnvironmentToolsToEnvironmentTypeMapping = new Map([
    ['Conda', info_1.EnvironmentType.Conda],
    ['Pipenv', info_1.EnvironmentType.Pipenv],
    ['Poetry', info_1.EnvironmentType.Poetry],
    ['Pyenv', info_1.EnvironmentType.Pyenv],
    ['Unknown', info_1.EnvironmentType.Unknown],
    ['Venv', info_1.EnvironmentType.Venv],
    ['VirtualEnv', info_1.EnvironmentType.VirtualEnv],
    ['VirtualEnvWrapper', info_1.EnvironmentType.VirtualEnvWrapper],
]);
function isCondaEnvironment(env) {
    return getEnvironmentType(env) === info_1.EnvironmentType.Conda;
}
exports.isCondaEnvironment = isCondaEnvironment;
function isNonPythonCondaEnvironment(env) {
    return getEnvironmentType(env) === info_1.EnvironmentType.Conda && !env.executable.uri;
}
exports.isNonPythonCondaEnvironment = isNonPythonCondaEnvironment;
function getEnvironmentType({ tools }) {
    tools = tools.map((tool) => tool.toLowerCase());
    for (const tool of tools) {
        if (tool === info_1.EnvironmentType.Conda.toLowerCase()) {
            return info_1.EnvironmentType.Conda;
        }
        if (tool === info_1.EnvironmentType.Venv.toLowerCase()) {
            return info_1.EnvironmentType.Venv;
        }
        if (tool === info_1.EnvironmentType.VirtualEnv.toLowerCase()) {
            return info_1.EnvironmentType.VirtualEnv;
        }
        if (tool === info_1.EnvironmentType.VirtualEnvWrapper.toLowerCase()) {
            return info_1.EnvironmentType.VirtualEnvWrapper;
        }
        if (tool === info_1.EnvironmentType.Poetry.toLowerCase()) {
            return info_1.EnvironmentType.Poetry;
        }
        if (tool === info_1.EnvironmentType.Pipenv.toLowerCase()) {
            return info_1.EnvironmentType.Pipenv;
        }
        if (tool === info_1.EnvironmentType.Pyenv.toLowerCase()) {
            return info_1.EnvironmentType.Pyenv;
        }
        if (KnownEnvironmentToolsToEnvironmentTypeMapping.has(tool)) {
            return KnownEnvironmentToolsToEnvironmentTypeMapping.get(tool);
        }
    }
    return info_1.EnvironmentType.Unknown;
}
exports.getEnvironmentType = getEnvironmentType;


/***/ }),

/***/ "./src/environments/view/commands.ts":
/*!*******************************************!*\
  !*** ./src/environments/view/commands.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.registerCommands = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const packages_1 = __webpack_require__(/*! ../packages */ "./src/environments/packages.ts");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/environments/view/types.ts");
const foldersTreeDataProvider_1 = __webpack_require__(/*! ./foldersTreeDataProvider */ "./src/environments/view/foldersTreeDataProvider.ts");
const environmentsTreeDataProvider_1 = __webpack_require__(/*! ./environmentsTreeDataProvider */ "./src/environments/view/environmentsTreeDataProvider.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../client/common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const async_1 = __webpack_require__(/*! ../../client/common/utils/async */ "./src/client/common/utils/async.ts");
function triggerChanges(item) {
    foldersTreeDataProvider_1.WorkspaceFoldersTreeDataProvider.instance.triggerChanges(item);
    environmentsTreeDataProvider_1.PythonEnvironmentsTreeDataProvider.instance.triggerChanges(item);
}
function registerCommands(context) {
    const disposables = [];
    disposables.push(vscode_1.commands.registerCommand('python.envManager.updatePackage', async (pkg) => {
        const yes = await vscode_1.window.showWarningMessage(`Are you sure you want to update the package '${pkg.pkg.name} to the latest version ${pkg.latestVersion}?`, { modal: true }, 'Yes', 'No');
        if (!yes || yes === 'No') {
            return;
        }
        pkg.status = 'DetectingLatestVersion';
        triggerChanges(pkg);
        await (0, packages_1.updatePackage)(pkg.env, pkg.pkg).catch((ex) => (0, logging_1.traceError)(`Failed to update package ${pkg.pkg.name} in ${pkg.env.id}`, ex));
        pkg.status = undefined;
        triggerChanges(pkg.parent);
    }));
    disposables.push(vscode_1.commands.registerCommand('python.envManager.uninstallPackage', async (pkg) => {
        const yes = await vscode_1.window.showWarningMessage(`Are you sure you want to uninstall the package '${pkg.pkg.name}'?`, { modal: true }, 'Yes', 'No');
        if (yes === 'No') {
            return;
        }
        pkg.status = 'UnInstalling';
        triggerChanges(pkg);
        (0, packages_1.uninstallPackage)(pkg.env, pkg.pkg);
        pkg.status = undefined;
        triggerChanges(pkg.parent);
        await (0, async_1.sleep)(1000);
        triggerChanges(pkg.parent);
    }));
    disposables.push(vscode_1.commands.registerCommand('python.envManager.searchAndInstallPackage', async (pkg) => {
        const result = await (0, packages_1.searchPackage)(pkg.env).catch((ex) => (0, logging_1.traceError)(`Failed to install a package in ${pkg.env.id}`, ex));
        if (!result) {
            return;
        }
        await (0, packages_1.installPackage)(pkg.env, result);
        triggerChanges(pkg);
    }));
    disposables.push(vscode_1.commands.registerCommand('python.envManager.exportEnvironment', async (options) => {
        var _a;
        const env = options instanceof types_1.EnvironmentWrapper ? options.env : (_a = options.asNode()) === null || _a === void 0 ? void 0 : _a.env;
        if (!env) {
            return;
        }
        const exportedData = await (0, packages_1.exportPackages)(env).catch((ex) => (0, logging_1.traceError)(`Failed to export env ${env.id}`, ex));
        if (!exportedData) {
            return;
        }
        const doc = await vscode_1.workspace.openTextDocument({
            content: `# ${exportedData.file}\n\n${exportedData.contents}`,
            language: exportedData.language,
        });
        vscode_1.window.showTextDocument(doc);
    }));
    disposables.push(vscode_1.commands.registerCommand('python.envManager.updateAllPackages', async (pkg) => {
        const yes = await vscode_1.window.showWarningMessage(`Are you sure you want to update all the packages?`, { modal: true }, 'Yes', 'No');
        if (yes === 'No') {
            return;
        }
        pkg.packages.forEach((e) => {
            e.status = 'UpdatingToLatest';
            triggerChanges(e);
        });
        await (0, packages_1.updatePackages)(pkg.env);
        triggerChanges(pkg);
    }));
    disposables.push(vscode_1.commands.registerCommand('python.envManager.refreshPackages', async (pkg) => triggerChanges(pkg)));
    context.subscriptions.push(new vscode_1.Disposable(() => (0, resourceLifecycle_1.disposeAll)(disposables)));
}
exports.registerCommands = registerCommands;


/***/ }),

/***/ "./src/environments/view/envTreeDataProvider.ts":
/*!******************************************************!*\
  !*** ./src/environments/view/envTreeDataProvider.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PythonEnvironmentTreeDataProvider = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const async_1 = __webpack_require__(/*! ../../client/common/utils/async */ "./src/client/common/utils/async.ts");
const packages_1 = __webpack_require__(/*! ../packages */ "./src/environments/packages.ts");
const envCreation_1 = __webpack_require__(/*! ../envCreation */ "./src/environments/envCreation.ts");
const logging_1 = __webpack_require__(/*! ../../client/logging */ "./src/client/logging/index.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/environments/view/types.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../client/common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
let PythonEnvironmentTreeDataProvider = class PythonEnvironmentTreeDataProvider {
    constructor(api) {
        this.api = api;
        this.disposables = [];
        this.outdatedPackages = new Map();
        this._changeTreeData = new vscode_1.EventEmitter();
        this.onDidChangeTreeData = this._changeTreeData.event;
    }
    dispose() {
        this._changeTreeData.dispose();
        (0, resourceLifecycle_1.disposeAll)(this.disposables);
    }
    async getTreeItem(element, defaultState = vscode_1.TreeItemCollapsibleState.Collapsed) {
        if (element instanceof types_1.EnvironmentWrapper) {
            return element.asTreeItem(this.api, defaultState);
        }
        if (element instanceof types_1.EnvironmentInformationWrapper) {
            const tree = new vscode_1.TreeItem('Info', defaultState);
            tree.contextValue = 'envInfo';
            tree.iconPath = new vscode_1.ThemeIcon('info');
            return tree;
        }
        if (element instanceof types_1.Package) {
            return element.asTreeItem();
        }
        if (element instanceof types_1.PackageWrapper) {
            return element.asTreeItem(defaultState);
        }
        if (element instanceof types_1.EnvironmentInfo) {
            const tree = new vscode_1.TreeItem(element.label);
            tree.description = element.value;
            tree.contextValue = 'info';
            tree.tooltip = element.value;
            return tree;
        }
        const tree = new vscode_1.TreeItem(element, defaultState);
        const createContext = (0, envCreation_1.canEnvBeCreated)(element) ? 'canCreate' : 'cannotCreate';
        tree.contextValue = `envType:${createContext}:${element} `;
        if (element === info_1.EnvironmentType.Conda && this.condaInfo) {
            tree.description = this.condaInfo.conda_version;
        }
        else if (element === info_1.EnvironmentType.Pyenv && this.pyEnvVersion) {
            tree.description = this.pyEnvVersion;
        }
        tree.iconPath = new vscode_1.ThemeIcon('folder-library');
        return tree;
    }
    async getChildren(element) {
        if (!element) {
            return [];
        }
        if (element instanceof types_1.Package) {
            return [];
        }
        if (element instanceof types_1.EnvironmentInformationWrapper) {
            return (0, types_1.getEnvironmentInfo)({ api: this.api, id: element.env.id });
        }
        if (element instanceof types_1.EnvironmentInfo) {
            return [];
        }
        if (element instanceof types_1.EnvironmentWrapper) {
            if ((0, utils_1.isNonPythonCondaEnvironment)(element.env)) {
                return [new types_1.EnvironmentInformationWrapper(element.env)];
            }
            return [
                new types_1.EnvironmentInformationWrapper(element.env),
                new types_1.PackageWrapper(element.env, element.owningFolder),
            ];
        }
        if (element instanceof types_1.PackageWrapper) {
            const env = this.api.environments.known.find((e) => e.id === element.env.id);
            if (!env) {
                return [];
            }
            const packagesByEnv = new Map();
            const completedPackages = (0, async_1.createDeferred)();
            (0, packages_1.getOutdatedPackages)(env)
                .then((outdatedPackages) => completedPackages.promise.then((installedPackages) => {
                this.outdatedPackages.set(env.id, outdatedPackages);
                for (const [pkgId, installedPackage] of installedPackages) {
                    installedPackage.latestVersion = outdatedPackages.get(pkgId);
                    installedPackage.status = undefined;
                    this._changeTreeData.fire(installedPackage);
                }
            }))
                .catch((ex) => (0, logging_1.traceError)(`Failed to get outdated packages for ${env.id}`, ex));
            return (0, packages_1.getPackages)(env).then((pkgs) => {
                const packages = pkgs.map((pkg) => {
                    const item = new types_1.Package(element, env, pkg, element.owningFolder);
                    const packagesMap = packagesByEnv.get(env.id) || new Map();
                    packagesByEnv.set(env.id, packagesMap);
                    packagesMap.set(pkg.name, item);
                    return item;
                });
                completedPackages.resolve(packagesByEnv.get(env.id) || new Map());
                return packages;
            });
        }
        return [];
    }
};
PythonEnvironmentTreeDataProvider = __decorate([
    (0, inversify_1.injectable)()
], PythonEnvironmentTreeDataProvider);
exports.PythonEnvironmentTreeDataProvider = PythonEnvironmentTreeDataProvider;


/***/ }),

/***/ "./src/environments/view/environmentsTreeDataProvider.ts":
/*!***************************************************************!*\
  !*** ./src/environments/view/environmentsTreeDataProvider.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var PythonEnvironmentsTreeDataProvider_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.refreshUntilNewEnvIsAvailable = exports.PythonEnvironmentsTreeDataProvider = void 0;
const inversify_1 = __webpack_require__(/*! inversify */ "./node_modules/inversify/lib/inversify.js");
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const info_1 = __webpack_require__(/*! ../../client/pythonEnvironments/info */ "./src/client/pythonEnvironments/info/index.ts");
const conda_1 = __webpack_require__(/*! ../tools/conda */ "./src/environments/tools/conda.ts");
const misc_1 = __webpack_require__(/*! ../../client/common/utils/misc */ "./src/client/common/utils/misc.ts");
const cache_1 = __webpack_require__(/*! ../cache */ "./src/environments/cache.ts");
const async_1 = __webpack_require__(/*! ../../client/common/utils/async */ "./src/client/common/utils/async.ts");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
const pyenv_1 = __webpack_require__(/*! ../tools/pyenv */ "./src/environments/tools/pyenv.ts");
const envCreation_1 = __webpack_require__(/*! ../envCreation */ "./src/environments/envCreation.ts");
const types_1 = __webpack_require__(/*! ./types */ "./src/environments/view/types.ts");
const envTreeDataProvider_1 = __webpack_require__(/*! ./envTreeDataProvider */ "./src/environments/view/envTreeDataProvider.ts");
const venvCreationProvider_1 = __webpack_require__(/*! ../../client/pythonEnvironments/creation/provider/venvCreationProvider */ "./src/client/pythonEnvironments/creation/provider/venvCreationProvider.ts");
const envDeletion_1 = __webpack_require__(/*! ../envDeletion */ "./src/environments/envDeletion.ts");
const poetry_1 = __webpack_require__(/*! ../tools/poetry */ "./src/environments/tools/poetry.ts");
let PythonEnvironmentsTreeDataProvider = PythonEnvironmentsTreeDataProvider_1 = class PythonEnvironmentsTreeDataProvider {
    constructor(context, api, iocContainer) {
        this.context = context;
        this.api = api;
        this.iocContainer = iocContainer;
        this.interpreterInfo = new Map();
        this.disposables = [];
        this.environmentTypes = new Map();
        this._changeTreeData = new vscode_1.EventEmitter();
        this.onDidChangeTreeData = this._changeTreeData.event;
        this.refreshing = false;
        this.envTreeDataProvider = new envTreeDataProvider_1.PythonEnvironmentTreeDataProvider(api);
        this.envTreeDataProvider.onDidChangeTreeData((e) => this._changeTreeData.fire(e), this, this.disposables);
        PythonEnvironmentsTreeDataProvider_1.instance = this;
        this.refresh(false);
        api.environments.onDidChangeEnvironments(this.rebuildEnvironmentTypesIfRequired, this, this.disposables);
        api.environments.onDidChangeEnvironments((e) => {
            if (e.type === 'add' || e.type === 'remove') {
                const envType = (0, utils_1.getEnvironmentType)(e.env);
                if (this.environmentTypes.has(envType)) {
                    this._changeTreeData.fire(envType);
                }
                else {
                    this._changeTreeData.fire();
                }
            }
            else if (e.type === 'update' && this.interpreterInfo.get(e.env.id)) {
                this._changeTreeData.fire(this.interpreterInfo.get(e.env.id));
                const envType = (0, utils_1.getEnvironmentType)(e.env);
                if (!this.environmentTypes.has(envType)) {
                    this._changeTreeData.fire();
                }
            }
        }, this, this.disposables);
        this.rebuildEnvironmentTypesIfRequired();
    }
    triggerChanges(node) {
        this._changeTreeData.fire(node);
    }
    dispose() {
        this._changeTreeData.dispose();
        this.envTreeDataProvider.dispose();
    }
    rebuildEnvironmentTypesIfRequired() {
        const envs = new Set(this.api.environments.known.map((item) => (0, utils_1.getEnvironmentType)(item)));
        if (envs.size !== this.environmentTypes.size) {
            if (!envs.has(info_1.EnvironmentType.Venv) &&
                !this.environmentTypes.has(info_1.EnvironmentType.Venv) &&
                (0, venvCreationProvider_1.canCreateVenv)(this.api.environments.known)) {
                envs.add(info_1.EnvironmentType.Venv);
            }
            Array.from(envs)
                .filter((type) => !this.environmentTypes.has(type))
                .forEach((type) => this.environmentTypes.set(type, new types_1.EnvironmentTypeWrapper(type)));
            this._changeTreeData.fire();
        }
    }
    changeTreeData(item) {
        this._changeTreeData.fire(item);
    }
    async getTreeItem(element) {
        if (typeof element === 'string') {
            const tree = new vscode_1.TreeItem(element === info_1.EnvironmentType.Unknown ? 'Global' : element, vscode_1.TreeItemCollapsibleState.Collapsed);
            const createContext = (0, envCreation_1.canEnvBeCreated)(element) ? 'canCreate' : 'cannotCreate';
            tree.contextValue = `envType:${createContext}:${element} `;
            if (element === info_1.EnvironmentType.Conda && this.condaInfo) {
                tree.description = this.condaInfo.conda_version;
            }
            else if (element === info_1.EnvironmentType.Pyenv && this.pyEnvVersion) {
                tree.description = this.pyEnvVersion;
            }
            else if (element === info_1.EnvironmentType.Poetry && this.poetryVersion) {
                tree.description = this.poetryVersion;
            }
            tree.iconPath = new vscode_1.ThemeIcon('folder-library');
            return tree;
        }
        return this.envTreeDataProvider.getTreeItem(element);
    }
    async getChildren(element) {
        if (!element) {
            return Array.from(this.environmentTypes.keys()).sort();
        }
        if (typeof element !== 'string') {
            return this.envTreeDataProvider.getChildren(element);
        }
        return this.api.environments.known
            .filter((env) => (0, utils_1.getEnvironmentType)(env) === element)
            .sort((a, b) => (0, types_1.getEnvLabel)(a).localeCompare((0, types_1.getEnvLabel)(b)))
            .map((env) => {
            if (!this.interpreterInfo.has(env.id)) {
                this.interpreterInfo.set(env.id, new types_1.EnvironmentWrapper(env, envDeletion_1.canEnvBeDeleted));
            }
            return this.interpreterInfo.get(env.id);
        })
            .sort((a, b) => {
            if ((0, utils_1.isNonPythonCondaEnvironment)(a.env) && !(0, utils_1.isNonPythonCondaEnvironment)(b.env)) {
                return 1;
            }
            if (!(0, utils_1.isNonPythonCondaEnvironment)(a.env) && (0, utils_1.isNonPythonCondaEnvironment)(b.env)) {
                return -1;
            }
            return (a.asTreeItem(this.api).label || '')
                .toString()
                .localeCompare((b.asTreeItem(this.api).label || '').toString());
        });
    }
    async refresh(clearCache = false) {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        vscode_1.commands.executeCommand('setContext', 'isRefreshingPythonEnvironments', true);
        try {
            this.refreshToolVersions();
            const refreshPromise = this.api.environments.refreshEnvironments({ forceRefresh: clearCache });
            await (0, cache_1.clearCacheIfNewVersionInstalled)(this.context, clearCache).then(misc_1.noop, misc_1.noop);
            await refreshPromise.catch(misc_1.noop);
            this._changeTreeData.fire();
            this.refreshToolVersions();
        }
        finally {
            this.refreshing = false;
            vscode_1.commands.executeCommand('setContext', 'isRefreshingPythonEnvironments', false).then(misc_1.noop, misc_1.noop);
        }
    }
    refreshToolVersions() {
        (0, conda_1.getCondaVersion)()
            .then((info) => {
            if (info) {
                this.condaInfo = info;
                if (this.environmentTypes.has(info_1.EnvironmentType.Conda)) {
                    this._changeTreeData.fire(info_1.EnvironmentType.Conda);
                }
            }
        })
            .catch(misc_1.noop);
        (0, pyenv_1.getPyEnvVersion)(this.iocContainer)
            .then((version) => {
            if (version) {
                this.pyEnvVersion = version;
                if (this.environmentTypes.has(info_1.EnvironmentType.Pyenv)) {
                    this._changeTreeData.fire(info_1.EnvironmentType.Pyenv);
                }
            }
        })
            .catch(misc_1.noop);
        (0, poetry_1.getPoetryVersion)()
            .then((version) => {
            if (version) {
                this.poetryVersion = version;
                if (this.environmentTypes.has(info_1.EnvironmentType.Poetry)) {
                    this._changeTreeData.fire(info_1.EnvironmentType.Poetry);
                }
            }
        })
            .catch(misc_1.noop);
    }
};
PythonEnvironmentsTreeDataProvider = PythonEnvironmentsTreeDataProvider_1 = __decorate([
    (0, inversify_1.injectable)()
], PythonEnvironmentsTreeDataProvider);
exports.PythonEnvironmentsTreeDataProvider = PythonEnvironmentsTreeDataProvider;
async function refreshUntilNewEnvIsAvailable(expectedEnvInfo) {
    const initialEnvCount = PythonEnvironmentsTreeDataProvider.environments.length;
    const isEnvAvailable = () => {
        if (!expectedEnvInfo.path && !expectedEnvInfo.name) {
            return true;
        }
        if (PythonEnvironmentsTreeDataProvider.environments.length > initialEnvCount) {
            return true;
        }
        return PythonEnvironmentsTreeDataProvider.environments.some((env) => {
            var _a;
            if (expectedEnvInfo.type !== (0, utils_1.getEnvironmentType)(env)) {
                return;
            }
            if (expectedEnvInfo.name && ((_a = env.environment) === null || _a === void 0 ? void 0 : _a.name) && env.environment.name.includes(expectedEnvInfo.name)) {
                return true;
            }
            if (expectedEnvInfo.path && env.path.includes(expectedEnvInfo.path)) {
                return true;
            }
            return false;
        });
    };
    for (let index = 0; index < 5; index += 1) {
        await PythonEnvironmentsTreeDataProvider.instance.refresh();
        if (isEnvAvailable()) {
            return;
        }
        (0, async_1.sleep)(2000);
    }
}
exports.refreshUntilNewEnvIsAvailable = refreshUntilNewEnvIsAvailable;


/***/ }),

/***/ "./src/environments/view/foldersTreeDataProvider.ts":
/*!**********************************************************!*\
  !*** ./src/environments/view/foldersTreeDataProvider.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceFoldersTreeDataProvider = exports.WorkspaceFolderEnvironments = exports.WorkspaceFolderWrapper = exports.ActiveWorkspaceEnvironment = void 0;
const vscode_1 = __webpack_require__(/*! vscode */ "vscode");
const types_1 = __webpack_require__(/*! ./types */ "./src/environments/view/types.ts");
const envTreeDataProvider_1 = __webpack_require__(/*! ./envTreeDataProvider */ "./src/environments/view/envTreeDataProvider.ts");
const resourceLifecycle_1 = __webpack_require__(/*! ../../client/common/utils/resourceLifecycle */ "./src/client/common/utils/resourceLifecycle.ts");
const cache_1 = __webpack_require__(/*! ../cache */ "./src/environments/cache.ts");
const misc_1 = __webpack_require__(/*! ../../client/common/utils/misc */ "./src/client/common/utils/misc.ts");
const poetry_1 = __webpack_require__(/*! ../tools/poetry */ "./src/environments/tools/poetry.ts");
const utils_1 = __webpack_require__(/*! ../utils */ "./src/environments/utils.ts");
class ActiveWorkspaceEnvironment {
    constructor(folder, api, canEnvBeDeleted) {
        this.folder = folder;
        this.api = api;
        this.canEnvBeDeleted = canEnvBeDeleted;
    }
    asNode(api = this.api) {
        const envPath = api.environments.getActiveEnvironmentPath(this.folder.uri);
        const env = envPath ? api.environments.known.find((e) => e.id === envPath.id) : undefined;
        if (env) {
            return new types_1.EnvironmentWrapper(env, this.canEnvBeDeleted, true, this.folder);
        }
    }
    asTreeItem(api, envTreeProvider) {
        var _a;
        const env = this.asNode(api);
        if (env) {
            return envTreeProvider.getTreeItem(env, vscode_1.TreeItemCollapsibleState.Expanded);
        }
        const label = (((_a = vscode_1.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) || 0) > 1
            ? `No Active Environment for ${this.folder.name}`
            : `No Active Environment`;
        const tree = new vscode_1.TreeItem(label, vscode_1.TreeItemCollapsibleState.Collapsed);
        tree.iconPath = new vscode_1.ThemeIcon('folder');
        return tree;
    }
}
exports.ActiveWorkspaceEnvironment = ActiveWorkspaceEnvironment;
class WorkspaceFolderWrapper {
    constructor(folder, canEnvBeDeleted) {
        this.folder = folder;
        this.canEnvBeDeleted = canEnvBeDeleted;
    }
    asTreeItem(api) {
        var _a;
        if (((_a = vscode_1.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) === 1) {
            const envPath = api.environments.getActiveEnvironmentPath(this.folder.uri);
            const env = envPath ? api.environments.known.find((e) => e.id === envPath.id) : undefined;
            if (env) {
                return new types_1.EnvironmentWrapper(env, this.canEnvBeDeleted).asTreeItem(api);
            }
        }
        const tree = new vscode_1.TreeItem(this.folder.name, vscode_1.TreeItemCollapsibleState.Expanded);
        tree.iconPath = new vscode_1.ThemeIcon('folder');
        return tree;
    }
}
exports.WorkspaceFolderWrapper = WorkspaceFolderWrapper;
class WorkspaceFolderEnvironments {
    constructor(folder) {
        this.folder = folder;
    }
    asTreeItem() {
        const tree = new vscode_1.TreeItem('Workspace Envs', vscode_1.TreeItemCollapsibleState.Expanded);
        tree.iconPath = new vscode_1.ThemeIcon('folder');
        return tree;
    }
}
exports.WorkspaceFolderEnvironments = WorkspaceFolderEnvironments;
class WorkspaceFoldersTreeDataProvider {
    constructor(context, api, canEnvBeDeleted) {
        this.context = context;
        this.api = api;
        this.canEnvBeDeleted = canEnvBeDeleted;
        this._changeTreeData = new vscode_1.EventEmitter();
        this.onDidChangeTreeData = this._changeTreeData.event;
        this.disposables = [];
        this.activeWorkspaceEnvs = new Map();
        this.refreshing = false;
        WorkspaceFoldersTreeDataProvider.instance = this;
        this.envTreeDataProvider = new envTreeDataProvider_1.PythonEnvironmentTreeDataProvider(api);
        this.envTreeDataProvider.onDidChangeTreeData((e) => this._changeTreeData.fire(e), this, this.disposables);
        api.environments.onDidChangeActiveEnvironmentPath((e) => {
            if (!Array.isArray(vscode_1.workspace.workspaceFolders) || vscode_1.workspace.workspaceFolders.length <= 1) {
                this._changeTreeData.fire();
            }
            else {
                const node = e.resource && this.activeWorkspaceEnvs.get(e.resource.uri.toString());
                if (node) {
                    this._changeTreeData.fire(node);
                }
            }
        });
        api.environments.onDidChangeEnvironments((e) => {
            var _a;
            if ((e.type === 'add' || e.type !== 'update') && !((_a = e.env.environment) === null || _a === void 0 ? void 0 : _a.workspaceFolder)) {
                this._changeTreeData.fire();
            }
        });
    }
    triggerChanges(node) {
        this._changeTreeData.fire(node);
    }
    async refresh(clearCache = false) {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        vscode_1.commands.executeCommand('setContext', 'isRefreshingPythonEnvironments', true);
        try {
            const refreshPromise = this.api.environments.refreshEnvironments({ forceRefresh: clearCache });
            await (0, cache_1.clearCacheIfNewVersionInstalled)(this.context, clearCache).then(misc_1.noop, misc_1.noop);
            await refreshPromise.catch(misc_1.noop);
            this._changeTreeData.fire();
            this.refreshToolVersions();
        }
        finally {
            this.refreshing = false;
            vscode_1.commands.executeCommand('setContext', 'isRefreshingPythonEnvironments', false).then(misc_1.noop, misc_1.noop);
        }
    }
    refreshToolVersions() {
        throw new Error('Method not implemented.');
    }
    dispose() {
        (0, resourceLifecycle_1.disposeAll)(this.disposables);
    }
    async getTreeItem(element) {
        if (element instanceof WorkspaceFolderWrapper ||
            element instanceof WorkspaceFolderEnvironments ||
            element instanceof ActiveWorkspaceEnvironment) {
            return element.asTreeItem(this.api, this.envTreeDataProvider);
        }
        return this.envTreeDataProvider.getTreeItem(element);
    }
    getWorkspaceActiveEnv(folder) {
        const item = this.activeWorkspaceEnvs.get(folder.uri.toString()) ||
            new ActiveWorkspaceEnvironment(folder, this.api, this.canEnvBeDeleted);
        this.activeWorkspaceEnvs.set(folder.uri.toString(), item);
        return item;
    }
    async getChildren(element) {
        if (!element) {
            if (!Array.isArray(vscode_1.workspace.workspaceFolders) || !vscode_1.workspace.workspaceFolders.length) {
                return [];
            }
            if (Array.isArray(vscode_1.workspace.workspaceFolders) && vscode_1.workspace.workspaceFolders.length > 1) {
                return vscode_1.workspace.workspaceFolders.map((e) => new WorkspaceFolderWrapper(e, this.canEnvBeDeleted));
            }
            const folderUri = vscode_1.workspace.workspaceFolders[0];
            const workspaceEnvs = await getAllEnvsBelongingToWorkspaceFolder(folderUri, this.api, this.canEnvBeDeleted);
            const items = [this.getWorkspaceActiveEnv(folderUri)];
            if (workspaceEnvs.length > 1) {
                items.push(new WorkspaceFolderEnvironments(folderUri));
            }
            else if (workspaceEnvs.length === 1) {
                const activeEnv = this.api.environments.getActiveEnvironmentPath(folderUri.uri);
                if (activeEnv.id !== workspaceEnvs[0].id) {
                    items.push(new WorkspaceFolderEnvironments(folderUri));
                }
            }
            return items;
        }
        if (element instanceof WorkspaceFolderEnvironments) {
            return getAllEnvsBelongingToWorkspaceFolder(element.folder, this.api, this.canEnvBeDeleted);
        }
        if (element instanceof ActiveWorkspaceEnvironment) {
            const env = element.asNode(this.api);
            return env ? this.envTreeDataProvider.getChildren(env) : [];
        }
        if (element instanceof WorkspaceFolderWrapper) {
            const items = [this.getWorkspaceActiveEnv(element.folder)];
            const workspaceEnvs = await getAllEnvsBelongingToWorkspaceFolder(element.folder, this.api, this.canEnvBeDeleted);
            if (workspaceEnvs.length) {
                items.push(new WorkspaceFolderEnvironments(element.folder));
            }
            return items;
        }
        return this.envTreeDataProvider.getChildren(element);
    }
}
exports.WorkspaceFoldersTreeDataProvider = WorkspaceFoldersTreeDataProvider;
async function getAllEnvsBelongingToWorkspaceFolder(folder, api, canEnvBeDeleted) {
    const envs = api.environments.known
        .filter((e) => {
        var _a;
        if (!((_a = e.environment) === null || _a === void 0 ? void 0 : _a.folderUri)) {
            return false;
        }
        return e.environment.folderUri.fsPath.toLowerCase().startsWith(folder.uri.fsPath.toLowerCase());
    })
        .map((e) => new types_1.