// Generated by CoffeeScript 1.3.3
var camelize, capitalize, dasherize, decapitalize, humanize, inflections, ordinalize, parameterize, pluralize, singularize, titleize, underscore;

inflections = require('../inflect').inflections;

camelize = function(lower_case_and_underscored_word, first_letter_in_uppercase) {
  var rest;
  if (first_letter_in_uppercase == null) {
    first_letter_in_uppercase = true;
  }
  rest = lower_case_and_underscored_word.replace(/_./g, function(val) {
    return val.slice(1).toUpperCase();
  });
  if (first_letter_in_uppercase) {
    return lower_case_and_underscored_word[0].toUpperCase() + rest.slice(1);
  } else {
    return lower_case_and_underscored_word[0].toLowerCase() + rest.slice(1);
  }
};

underscore = function(camel_cased_word) {
  var word;
  word = camel_cased_word.toString();
  word = word.replace(/([A-Z]+)([A-Z][a-z])/g, '$1_$2');
  word = word.replace(/([a-z\d])([A-Z])/g, '$1_$2');
  word = word.replace(/-/g, '_');
  word = word.toLowerCase();
  return word;
};

dasherize = function(underscored_word) {
  return underscored_word.replace(/_/g, '-');
};

titleize = function(word) {
  return humanize(underscore(word)).replace(/\b('?[a-z])/g, function(val) {
    return capitalize(val);
  });
};

capitalize = function(word) {
  return (word[0] || '').toUpperCase() + (word.slice(1) || '').toLowerCase();
};

decapitalize = function(word) {
  return (word[0] || '').toLowerCase() + (word.slice(1) || '');
};

pluralize = function(word) {
  var plural, replacement, result, rule, _i, _len, _ref;
  result = word.toString();
  if (word.length === 0 || inflections().uncountables.indexOf(result.toLowerCase()) !== -1) {
    return result;
  } else {
    _ref = inflections().plurals;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      plural = _ref[_i];
      rule = plural[0];
      replacement = plural[1];
      if (result.search(rule) !== -1) {
        result = result.replace(rule, replacement);
        break;
      }
    }
    return result;
  }
};

singularize = function(word) {
  var inflection, replacement, result, rule, singular, uncountable, _i, _j, _len, _len1, _ref, _ref1;
  result = word.toString();
  uncountable = false;
  _ref = inflections().uncountables;
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    inflection = _ref[_i];
    if (result.search(new RegExp("\\b" + inflection + "$", 'i')) !== -1) {
      uncountable = true;
      break;
    }
  }
  if (word.length === 0 || uncountable) {
    return result;
  } else {
    _ref1 = inflections().singulars;
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      singular = _ref1[_j];
      rule = singular[0];
      replacement = singular[1];
      if (result.search(rule) !== -1) {
        result = result.replace(rule, replacement);
        break;
      }
    }
    return result;
  }
};

humanize = function(lower_case_and_underscored_word) {
  var human, replacement, result, rule, _i, _len, _ref;
  result = lower_case_and_underscored_word.toString();
  _ref = inflections().humans;
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    human = _ref[_i];
    rule = human[0];
    replacement = human[1];
    if (result.search(rule) !== -1) {
      result = result.replace(rule, replacement);
      break;
    }
  }
  return capitalize(result.replace(/_id$/, '').replace(/_/g, ' '));
};

ordinalize = function(number) {
  var number_int;
  number_int = parseInt(number, 10);
  if ([11, 12, 13].indexOf(number_int % 100) !== -1) {
    return "" + number + "th";
  } else {
    switch (number_int % 10) {
      case 1:
        return "" + number + "st";
      case 2:
        return "" + number + "nd";
      case 3:
        return "" + number + "rd";
      default:
        return "" + number + "th";
    }
  }
};

parameterize = function(string, sep) {
  var parameterized_string;
  if (sep == null) {
    sep = '-';
  }
  parameterized_string = string.toString();
  parameterized_string = parameterized_string.replace(/[^a-z0-9\-_]+/gi, sep);
  if (sep != null) {
    parameterized_string = parameterized_string.replace(new RegExp("" + sep + "{2,}", 'g'), sep);
    parameterized_string = parameterized_string.replace(new RegExp("^" + sep + "|" + sep + "$", 'gi'), '');
  }
  return parameterized_string.toLowerCase();
};

exports.camelize = camelize;

exports.underscore = underscore;

exports.dasherize = dasherize;

exports.titleize = titleize;

exports.capitalize = capitalize;

exports.decapitalize = decapitalize;

exports.pluralize = pluralize;

exports.singularize = singularize;

exports.humanize = humanize;

exports.ordinalize = ordinalize;

exports.parameterize = parameterize;
