import json
from os.path import abspath, dirname, join
from datetime import datetime
import tomlkit

SYNTAX_DIR = abspath(dirname(join("syntaxes", __name__)))
SYNTAXES = ["django-html", "django-txt"]


def load(path):
    with open(path) as f:
        return tomlkit.loads(f.read())


tomlkit.load = load


def build_file(syntax):

    data = tomlkit.load(join(SYNTAX_DIR, f"{syntax}.toml"))
    data.add("_comment", "Generated by: poetry run syntax")

    for name in data["repositories"]:
        repo = tomlkit.load(join(SYNTAX_DIR, "repositories", f"{name}.toml"))
        data["repository"][name] = repo

    data.remove("repositories")

    with open(f"syntaxes/{syntax}.tmLanguage.json", "w") as f:
        json.dump(data, f, indent=2)


def main():
    for syntax in SYNTAXES:
        build_file(syntax)
