/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.quarkus;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.metadata.ConverterKind;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;

public class JDTQuarkusUtils {
    private static final Logger LOGGER = Logger.getLogger(JDTQuarkusUtils.class.getName());
    private static final List<ConverterKind> DEFAULT_QUARKUS_CONVERTERS = Arrays.asList(ConverterKind.KEBAB_CASE, ConverterKind.VERBATIM);

    public static String getExtensionName(String location) {
        if (location == null) {
            return null;
        }
        if (!location.endsWith(".jar")) {
            return null;
        }
        int start = location.lastIndexOf(47);
        if (start == -1) {
            return null;
        }
        ++start;
        int end = location.lastIndexOf(45);
        if (end == -1) {
            end = location.lastIndexOf(46);
        }
        if (end < start) {
            return null;
        }
        String extensionName = location.substring(start, end);
        if (extensionName.endsWith("-deployment")) {
            extensionName = extensionName.substring(0, extensionName.length() - "-deployment".length());
        }
        return extensionName;
    }

    public static boolean isQuarkusProject(IJavaProject javaProject) {
        try {
            return javaProject.findType("io.quarkus.runtime.LaunchMode") != null;
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.INFO, "Current Java project is not a Quarkus project", e);
            return false;
        }
    }

    public static void updateConverterKinds(ItemMetadata metadata, IMember member, IType enclosedType) throws JavaModelException {
        if (enclosedType == null || !enclosedType.isEnum()) {
            return;
        }
        metadata.setConverterKinds(DEFAULT_QUARKUS_CONVERTERS);
    }

    public static boolean isSupportNamingStrategy(IJavaProject javaProject) {
        try {
            return javaProject.findType("io.quarkus.arc.config.ConfigProperties.NamingStrategy") != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

