/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.utils;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlUtils {
    private YamlUtils() {
    }

    public static Properties loadYamlAsProperties(InputStream input) {
        Properties properties = new Properties();
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Object yamlDocument = yaml.load(input);
        if (yamlDocument != null) {
            Map<String, Object> yamlMap = YamlUtils.toMap(yamlDocument);
            properties.putAll(YamlUtils.flattenMap(yamlMap));
        }
        return properties;
    }

    private static Map<String, Object> toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    private static Map<String, String> flattenMap(Map<String, Object> sourceMap) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> sourceMapEntry : sourceMap.entrySet()) {
            String key = sourceMapEntry.getKey();
            Object value = sourceMapEntry.getValue();
            if (value instanceof Map) {
                Map<String, String> valueMap = YamlUtils.flattenMap((Map)value);
                for (Map.Entry<String, String> valueMapEntry : valueMap.entrySet()) {
                    String subKey = valueMapEntry.getKey();
                    String subValue = valueMapEntry.getValue();
                    resultMap.put((String)(subKey != null ? key + "." + subKey : key), subValue);
                }
                continue;
            }
            if (value instanceof Collection) {
                StringBuilder joiner = new StringBuilder();
                String separator = "";
                for (Object element : (Collection)value) {
                    Map<String, String> subMap = YamlUtils.flattenMap(Collections.singletonMap(key, element));
                    joiner.append(separator).append(subMap.entrySet().iterator().next().getValue().toString());
                    separator = ",";
                }
                resultMap.put(key, joiner.toString());
                continue;
            }
            resultMap.put(key, value != null ? value.toString() : "");
        }
        return resultMap;
    }
}

