/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.scheduler.properties;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusScheduledPropertiesProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.scheduler.Scheduled"};
    private static Pattern PROP_PATTERN = Pattern.compile("\\{(.*)\\}");

    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    protected void processAnnotation(IJavaElement javaElement, IAnnotation configPropertyAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() == 9) {
            String extensionName = null;
            IPropertiesCollector collector = context.getCollector();
            String description = null;
            String sourceMethod = JDTTypeUtils.getSourceMethod((IMethod)((IMethod)javaElement));
            String sourceType = JDTTypeUtils.getSourceType((IJavaElement)javaElement);
            boolean binary = JDTTypeUtils.isBinary((IJavaElement)javaElement);
            IMemberValuePair[] iMemberValuePairArray = configPropertyAnnotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher m;
                IMemberValuePair mvp = iMemberValuePairArray[n2];
                String name = mvp.getValue().toString();
                if (mvp.getValueKind() == 9 && name != null && !name.isEmpty() && (m = PROP_PATTERN.matcher(name)).matches()) {
                    name = m.group(1);
                    this.addItemMetadata(collector, name, "java.lang.String", description, sourceType, null, sourceMethod, null, extensionName, binary);
                }
                ++n2;
            }
        }
    }
}

