/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.scheduler.java;

import com.redhat.microprofile.jdt.internal.quarkus.scheduler.SchedulerErrorCodes;
import com.redhat.microprofile.jdt.internal.quarkus.scheduler.SchedulerUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusSchedulerASTVisitor
extends JavaASTValidator {
    private static Logger LOGGER = Logger.getLogger(QuarkusSchedulerASTVisitor.class.getName());

    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType((IJavaProject)javaProject, (String)"io.quarkus.scheduler.Scheduled") != null;
    }

    public boolean visit(MethodDeclaration node) {
        try {
            List modifiers = node.modifiers();
            for (Object modifier : modifiers) {
                Annotation annotation;
                if (!(modifier instanceof Annotation) || !AnnotationUtils.isMatchAnnotation((Annotation)(annotation = (Annotation)modifier), (String)"io.quarkus.scheduler.Scheduled")) continue;
                try {
                    this.validateScheduledAnnotation(node, (NormalAnnotation)annotation);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (JavaModelException javaModelException) {
            LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the annotation marked method");
        }
        super.visit(node);
        return true;
    }

    private void validateScheduledAnnotation(MethodDeclaration node, NormalAnnotation annotation) throws JavaModelException {
        Expression delayedExpr;
        Expression everyExpr;
        SchedulerErrorCodes cronPartFault;
        String cronValue;
        Expression cronExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, (String)"cron");
        if (cronExpr != null && cronExpr.resolveConstantExpressionValue() != null && !this.malformedEnvDiagnostic(cronExpr, cronValue = (String)cronExpr.resolveConstantExpressionValue()) && (cronPartFault = SchedulerUtils.validateCronPattern(cronValue)) != null) {
            super.addDiagnostic(cronPartFault.getErrorMessage(), "quarkus", (ASTNode)cronExpr, (IJavaErrorCode)cronPartFault, DiagnosticSeverity.Warning);
        }
        if ((everyExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, (String)"every")) != null && everyExpr.resolveConstantExpressionValue() != null) {
            this.durationParseDiagnostics(everyExpr);
        }
        if ((delayedExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, (String)"delayed")) != null && delayedExpr.resolveConstantExpressionValue() != null) {
            this.durationParseDiagnostics(delayedExpr);
        }
    }

    private void durationParseDiagnostics(Expression expr) {
        SchedulerErrorCodes memberFault;
        String value = (String)expr.resolveConstantExpressionValue();
        if (!this.malformedEnvDiagnostic(expr, value) && (memberFault = SchedulerUtils.validateDurationParse(value)) != null) {
            super.addDiagnostic(memberFault.getErrorMessage(), "quarkus", (ASTNode)expr, (IJavaErrorCode)memberFault, DiagnosticSeverity.Warning);
        }
    }

    private boolean malformedEnvDiagnostic(Expression expr, String memberValue) {
        SchedulerErrorCodes malformedEnvFault = SchedulerUtils.matchEnvMember(memberValue);
        if (malformedEnvFault != null) {
            if (malformedEnvFault == SchedulerErrorCodes.INVALID_CHAR_IN_EXPRESSION) {
                super.addDiagnostic(malformedEnvFault.getErrorMessage(), "quarkus", (ASTNode)expr, (IJavaErrorCode)malformedEnvFault, DiagnosticSeverity.Warning);
            }
            return true;
        }
        return false;
    }
}

