/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.scheduler;

import com.redhat.microprofile.jdt.internal.quarkus.scheduler.SchedulerErrorCodes;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public class SchedulerUtils {
    private static final String SECOND_MINUTE_RANGE = "([1-5]?[0-9])";
    private static final String HOUR_RANGE = "(2[0-3]|1?[0-9])";
    private static final String DAY_OF_MONTH_RANGE = "(3[01]|[12][0-9]|[1-9])";
    private static final String MONTH_RANGE = "(JAN|FEB|MA[RY]|APR|JU[NL]|AUG|SEP|OCT|NOV|DEC|1[0-2]|[1-9])";
    private static final String DAY_OF_WEEK_RANGE = "(MON|TUE|WED|THU|FRI|SAT|SUN|[1-7])";
    private static final String YEAR_RANGE = "(19[7-9][0-9]|20[0-9][0-9])";
    private static final String CRON_SPECIAL_CHARACTERS = "|\\*|\\?|^\\*\\/\\d+";
    private static final String BASE_CRON_PATTERN = "(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)";
    private static final Pattern[] CRON_PATTERNS = new Pattern[]{Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "([1-5]?[0-9])", "|\\*|\\?|^\\*\\/\\d+")), Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "([1-5]?[0-9])", "|\\*|\\?|^\\*\\/\\d+")), Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "(2[0-3]|1?[0-9])", "|\\*|\\?|^\\*\\/\\d+")), Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "(3[01]|[12][0-9]|[1-9])", "|\\*|\\?|^\\*\\/\\d+")), Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "(JAN|FEB|MA[RY]|APR|JU[NL]|AUG|SEP|OCT|NOV|DEC|1[0-2]|[1-9])", "|\\*|\\?|^\\*\\/\\d+"), 2), Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "(MON|TUE|WED|THU|FRI|SAT|SUN|[1-7])", "|\\*|\\?|^\\*\\/\\d+"), 2), Pattern.compile(String.format("(%1$s(?:,%1$s)*|%1$s\\-%1$s|%2$s)", "(19[7-9][0-9]|20[0-9][0-9])", "|\\*|\\?|^\\*\\/\\d+"))};
    private static final Pattern TIME_PERIOD_PATTERN = Pattern.compile("\\d+[smhSMH]$");
    private static final Pattern ENV_PATTERN = Pattern.compile("^\\$?\\{[0-9a-zA-Z.:]*\\}$");
    private static final Pattern LOOSE_ENV_PATTERN = Pattern.compile("^.*\\$?\\{.*\\}.*$");

    private SchedulerUtils() {
    }

    public static SchedulerErrorCodes validateCronPattern(String cronString) {
        String[] cronParts = cronString.split("\\s+");
        if (cronParts.length < 6 || cronParts.length > 7) {
            return SchedulerErrorCodes.INVALID_CRON_LENGTH;
        }
        SchedulerErrorCodes[] errorCodes = SchedulerErrorCodes.values();
        int i = 0;
        while (i < cronParts.length) {
            if (!CRON_PATTERNS[i].matcher(cronParts[i]).matches()) {
                return errorCodes[i];
            }
            ++i;
        }
        return null;
    }

    public static SchedulerErrorCodes validateDurationParse(String timePattern) {
        if (!TIME_PERIOD_PATTERN.matcher(timePattern).matches()) {
            try {
                Duration.parse(timePattern);
            }
            catch (DateTimeParseException dateTimeParseException) {
                return SchedulerErrorCodes.INVALID_DURATION_PARSE_PATTERN;
            }
        }
        return null;
    }

    public static SchedulerErrorCodes matchEnvMember(String memberValue) {
        return SchedulerUtils.checkLooseEnvPattern(memberValue) ? (SchedulerUtils.checkEnvPattern(memberValue) ? SchedulerErrorCodes.VALID_EXPRESSION : SchedulerErrorCodes.INVALID_CHAR_IN_EXPRESSION) : null;
    }

    private static boolean checkEnvPattern(String memberValue) {
        return ENV_PATTERN.matcher(memberValue).matches();
    }

    private static boolean checkLooseEnvPattern(String memberValue) {
        return LOOSE_ENV_PATTERN.matcher(memberValue).matches();
    }
}

