/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.route.java;

import com.redhat.microprofile.jdt.internal.quarkus.route.java.ReactiveRouteUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.jaxrs.HttpMethod;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsMethodInfo;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class ReactiveRouteJaxRsInfoProvider
implements IJaxRsInfoProvider {
    private static final Logger LOGGER = Logger.getLogger(ReactiveRouteJaxRsInfoProvider.class.getName());

    public boolean canProvideJaxRsMethodInfoForClass(ITypeRoot typeRoot, IProgressMonitor monitor) {
        return JDTTypeUtils.findType((IJavaProject)typeRoot.getJavaProject(), (String)"io.quarkus.vertx.web.Route") != null;
    }

    public Set<ITypeRoot> getAllJaxRsClasses(IJavaProject javaProject, IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    public List<JaxRsMethodInfo> getJaxRsMethodInfo(ITypeRoot typeRoot, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) {
        try {
            IType type = typeRoot.findPrimaryType();
            if (type == null) {
                return Collections.emptyList();
            }
            IAnnotation routeBaseAnnotation = ReactiveRouteUtils.getRouteBaseAnnotation((IAnnotatable)type);
            String pathSegment = routeBaseAnnotation != null ? ReactiveRouteUtils.getRouteBasePath(routeBaseAnnotation) : null;
            ArrayList<JaxRsMethodInfo> methodInfos = new ArrayList<JaxRsMethodInfo>();
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!method.isConstructor() && !utils.isHiddenGeneratedElement((IJavaElement)method) && !JDTTypeUtils.overlaps((ISourceRange)type.getNameRange(), (ISourceRange)method.getNameRange()) && ReactiveRouteUtils.isReactiveRoute(method)) {
                    List<IAnnotation> routeAnnotations = ReactiveRouteUtils.getRouteAnnotations((IAnnotatable)method);
                    for (IAnnotation routeAnnotation : routeAnnotations) {
                        String methodSegment = ReactiveRouteUtils.getRoutePath(routeAnnotation);
                        if (methodSegment == null) {
                            methodSegment = method.getElementName();
                        }
                        String path = pathSegment == null ? methodSegment : JaxRsUtils.buildURL((String[])new String[]{pathSegment, methodSegment});
                        String url = JaxRsUtils.buildURL((String[])new String[]{jaxrsContext.getLocalBaseURL(), path});
                        JaxRsMethodInfo methodInfo = ReactiveRouteJaxRsInfoProvider.createMethodInfo(method, routeAnnotation, url);
                        if (methodInfo == null) continue;
                        methodInfos.add(methodInfo);
                    }
                }
                ++n2;
            }
            return methodInfos;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while collecting JAX-RS methods for Reactive @Route", e);
            return Collections.emptyList();
        }
    }

    private IType findFirstClass(IType typeRoot) throws JavaModelException {
        IJavaElement[] iJavaElementArray = typeRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof IType) {
                return (IType)element;
            }
            ++n2;
        }
        return null;
    }

    private static JaxRsMethodInfo createMethodInfo(IMethod method, IAnnotation routeAnnotation, String url) throws JavaModelException {
        IResource resource = method.getResource();
        if (resource == null) {
            return null;
        }
        String documentUri = resource.getLocationURI().toString();
        String httpMethodName = ReactiveRouteUtils.getRouteHttpMethodName(routeAnnotation);
        HttpMethod httpMethod = ReactiveRouteUtils.getHttpMethodForAnnotation(httpMethodName);
        return new JaxRsMethodInfo(url, httpMethod, method, documentUri);
    }
}

