/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.renarde.java;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class RenardeUtils {
    private RenardeUtils() {
    }

    public static boolean isControllerClass(IJavaProject project, ITypeRoot typeRoot, IProgressMonitor monitor) {
        ITypeHierarchy hierarchy;
        if (JDTTypeUtils.findType((IJavaProject)project, (String)"io.quarkiverse.renarde.Controller") == null) {
            return false;
        }
        IType type = typeRoot.findPrimaryType();
        try {
            if (type == null || !type.isClass()) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        try {
            hierarchy = type.newSupertypeHierarchy(monitor);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        boolean isControllerSubtype = Stream.of(hierarchy.getAllClasses()).anyMatch(supertype -> "io.quarkiverse.renarde.Controller".equals(supertype.getFullyQualifiedName()));
        return isControllerSubtype;
    }

    public static Set<ITypeRoot> getAllControllerClasses(IJavaProject project, IProgressMonitor monitor) {
        ITypeHierarchy hierarchy;
        IType controllerType = JDTTypeUtils.findType((IJavaProject)project, (String)"io.quarkiverse.renarde.Controller");
        if (controllerType == null) {
            return Collections.emptySet();
        }
        try {
            hierarchy = controllerType.newTypeHierarchy(monitor);
        }
        catch (JavaModelException javaModelException) {
            return Collections.emptySet();
        }
        return Stream.of(hierarchy.getAllSubtypes(controllerType)).map(subType -> subType.getTypeRoot()).collect(Collectors.toSet());
    }
}

