/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.providers;

import com.redhat.microprofile.jdt.internal.quarkus.providers.YamlConfigSource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSourceProvider;
import org.eclipse.lsp4mp.jdt.core.project.PropertiesConfigSource;

public class QuarkusConfigSourceProvider
implements IConfigSourceProvider {
    public static final String APPLICATION_PROPERTIES_FILE = "application.properties";
    public static final String APPLICATION_YAML_FILE = "application.yaml";
    public static final String APPLICATION_YML_FILE = "application.yml";
    private static final Pattern PER_PROFILE_FILE_NAME_PTN = Pattern.compile("application-([A-Za-z]+)\\.properties");

    public List<IConfigSource> getConfigSources(IJavaProject javaProject, File outputFolder) {
        ArrayList<IConfigSource> configSources = new ArrayList<IConfigSource>();
        File[] fileArray = outputFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            IConfigSource configSource;
            File file = fileArray[n2];
            if (file.isFile() && (configSource = QuarkusConfigSourceProvider.createConfigSource(fileName = file.getName(), javaProject)) != null) {
                configSources.add(configSource);
            }
            ++n2;
        }
        return configSources;
    }

    private static IConfigSource createConfigSource(String fileName, IJavaProject javaProject) {
        if (APPLICATION_PROPERTIES_FILE.equals(fileName)) {
            return new PropertiesConfigSource(fileName, 250, javaProject);
        }
        if (APPLICATION_YAML_FILE.equals(fileName) || APPLICATION_YML_FILE.equals(fileName)) {
            return new YamlConfigSource(fileName, javaProject);
        }
        Matcher m = PER_PROFILE_FILE_NAME_PTN.matcher(fileName);
        if (m.matches()) {
            return new PropertiesConfigSource(fileName, m.group(1), 261, javaProject);
        }
        return null;
    }

    public boolean isConfigSource(String fileName) {
        return APPLICATION_PROPERTIES_FILE.equals(fileName) || APPLICATION_YAML_FILE.equals(fileName) || APPLICATION_YML_FILE.equals(fileName) || PER_PROFILE_FILE_NAME_PTN.matcher(fileName).matches();
    }
}

