/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.core.properties;

import com.redhat.microprofile.jdt.internal.quarkus.core.properties.ConfigPhase;
import com.redhat.microprofile.jdt.internal.quarkus.providers.QuarkusContext;
import com.redhat.microprofile.jdt.internal.quarkus.providers.QuarkusSearchContext;
import com.redhat.microprofile.jdt.quarkus.JDTQuarkusUtils;
import io.quarkus.runtime.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.ArtifactResolver;
import org.eclipse.lsp4mp.jdt.core.BuildingScopeContext;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusConfigRootProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(QuarkusConfigRootProvider.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.runtime.annotations.ConfigRoot"};
    private static final String JAVADOC_CACHE_KEY = QuarkusConfigRootProvider.class.getName() + "#javadoc";

    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    public void contributeToClasspath(BuildingScopeContext context, IProgressMonitor monitor) throws JavaModelException {
        QuarkusContext quarkusContext = QuarkusContext.getQuarkusContext(context);
        QuarkusConfigRootProvider.contributeToClasspath(context.getJavaProject(), context.getResolvedClasspath(), context.isExcludeTestCode(), context.getScopes(), context.getArtifactResolver(), context.getSearchClassPathEntries(), quarkusContext, monitor);
    }

    private static void contributeToClasspath(IJavaProject project, IClasspathEntry[] resolvedClasspath, boolean excludeTestCode, List<MicroProfilePropertiesScope> scopes, ArtifactResolver artifactResolver, List<IClasspathEntry> searchJarEntries, QuarkusContext quarkusContext, IProgressMonitor monitor) throws JavaModelException {
        if (MicroProfilePropertiesScope.isOnlySources(scopes)) {
            return;
        }
        List<String> existingJars = Stream.of(resolvedClasspath).filter(entry -> entry.getEntryKind() == 1).filter(entry -> !excludeTestCode || excludeTestCode && !entry.isTest()).map(entry -> entry.getPath().lastSegment()).collect(Collectors.toList());
        ArrayList<ArtifactResolver.Artifact> deploymentArtifacts = new ArrayList<ArtifactResolver.Artifact>();
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry2 = iClasspathEntryArray[n2];
            if (!excludeTestCode || !entry2.isTest()) {
                switch (entry2.getEntryKind()) {
                    case 1: {
                        ArtifactResolver.Artifact deploymentArtifact;
                        String jarPath = entry2.getPath().toOSString();
                        IPackageFragmentRoot root = project.getPackageFragmentRoot(jarPath);
                        if (root == null || !root.exists() || (deploymentArtifact = QuarkusConfigRootProvider.getDeploymentArtifact(root)) == null) break;
                        deploymentArtifacts.add(deploymentArtifact);
                    }
                }
            }
            ++n2;
        }
        SubMonitor mainMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading Quarkus deployment dependencies", (int)deploymentArtifacts.size());
        try {
            for (ArtifactResolver.Artifact deploymentArtifact : deploymentArtifacts) {
                mainMonitor.subTask("Loading Quarkus deployment '" + deploymentArtifact.getGroupId() + deploymentArtifact.getArtifactId() + deploymentArtifact.getVersion() + "' and their dependencies...");
                SubMonitor m = mainMonitor.split(1);
                if (!QuarkusConfigRootProvider.addArtifactInClasspath(deploymentArtifact, existingJars, searchJarEntries, artifactResolver, (IProgressMonitor)m) || !quarkusContext.isCollectDependenciesFor(deploymentArtifact.getArtifactId())) continue;
                Set dependencies = artifactResolver.getDependencies(deploymentArtifact, (IProgressMonitor)m);
                for (ArtifactResolver.Artifact dependency : dependencies) {
                    QuarkusConfigRootProvider.addArtifactInClasspath(dependency, existingJars, searchJarEntries, artifactResolver, (IProgressMonitor)m);
                }
            }
        }
        finally {
            mainMonitor.done();
        }
    }

    private static boolean addArtifactInClasspath(ArtifactResolver.Artifact deploymentArtifact, List<String> existingJars, List<IClasspathEntry> deploymentJarEntries, ArtifactResolver artifactResolver, IProgressMonitor monitor) {
        IPath deploymentJarFilePath;
        String deploymentJarName;
        String deploymentJarFile = artifactResolver.getArtifact(deploymentArtifact, monitor);
        if (deploymentJarFile != null && !existingJars.contains(deploymentJarName = (deploymentJarFilePath = Path.fromOSString((String)deploymentJarFile)).lastSegment())) {
            existingJars.add(deploymentJarName);
            IPath sourceAttachmentPath = null;
            ArtifactResolver.Artifact sourceArtifact = new ArtifactResolver.Artifact(deploymentArtifact.getGroupId(), deploymentArtifact.getArtifactId(), deploymentArtifact.getVersion(), "sources");
            String sourceJarFile = artifactResolver.getArtifact(sourceArtifact, monitor);
            if (sourceJarFile != null) {
                sourceAttachmentPath = Path.fromOSString((String)sourceJarFile);
            }
            deploymentJarEntries.add(JavaCore.newLibraryEntry((IPath)deploymentJarFilePath, (IPath)sourceAttachmentPath, null));
            return true;
        }
        return false;
    }

    private static ArtifactResolver.Artifact getDeploymentArtifact(IPackageFragmentRoot root) {
        IJarEntryResource resource;
        block3: {
            try {
                resource = JDTTypeUtils.findPropertiesResource((IPackageFragmentRoot)root, (String)"quarkus-extension.properties");
                if (resource != null) break block3;
                return null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while downloading deployment JAR '" + root.getElementName() + "'.", e);
                return null;
            }
        }
        Properties properties = new Properties();
        properties.load(resource.getContents());
        String deploymentArtifact = properties.getProperty("deployment-artifact");
        String[] result = deploymentArtifact.split(":");
        String groupId = result[0];
        String artifactId = result[1];
        String version = result[2];
        return new ArtifactResolver.Artifact(groupId, artifactId, version);
    }

    public void beginSearch(SearchContext context, IProgressMonitor monitor) {
        HashMap javadocCache = new HashMap();
        context.put(JAVADOC_CACHE_KEY, javadocCache);
    }

    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        Map javadocCache = (Map)context.get(JAVADOC_CACHE_KEY);
        QuarkusSearchContext quarkusContext = QuarkusSearchContext.getQuarkusContext(context);
        this.processConfigRoot(javaElement, annotation, javadocCache, quarkusContext, context.getCollector(), monitor);
    }

    private void processConfigRoot(IJavaElement javaElement, IAnnotation configRootAnnotation, Map<IPackageFragmentRoot, Properties> javadocCache, QuarkusSearchContext quarkusContext, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        ConfigPhase configPhase = QuarkusConfigRootProvider.getConfigPhase(configRootAnnotation);
        String configRootAnnotationName = QuarkusConfigRootProvider.getConfigRootName(configRootAnnotation);
        String extension = QuarkusConfigRootProvider.getExtensionName(QuarkusConfigRootProvider.getSimpleName(javaElement), configRootAnnotationName, configPhase);
        if (extension == null) {
            return;
        }
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)javaElement.getAncestor(3);
        String location = packageRoot.getPath().toString();
        String extensionName = JDTQuarkusUtils.getExtensionName(location);
        Object baseKey = extension.isEmpty() ? "quarkus" : "quarkus." + extension;
        this.processConfigGroup(extensionName, javaElement, (String)baseKey, configPhase, javadocCache, quarkusContext, collector, monitor);
    }

    private static ConfigPhase getConfigPhase(IAnnotation configRootAnnotation) throws JavaModelException {
        String phase = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configRootAnnotation, (String)"phase");
        if (phase != null) {
            try {
                return ConfigPhase.valueOf(phase.toUpperCase());
            }
            catch (Exception exception) {}
        }
        return ConfigPhase.BUILD_TIME;
    }

    private static String getConfigRootName(IAnnotation configRootAnnotation) throws JavaModelException {
        String value = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configRootAnnotation, (String)"name");
        if (value != null) {
            return value;
        }
        return "<<hyphenated element name>>";
    }

    private static String getSimpleName(IJavaElement javaElement) {
        String elementName = javaElement.getElementName();
        int index = elementName.lastIndexOf(46);
        return index != -1 ? elementName.substring(index + 1, elementName.length()) : elementName;
    }

    private static String getExtensionName(String configRootClassSimpleName, String configRootAnnotationName, ConfigPhase configPhase) {
        String rootName = configRootAnnotationName;
        List segments = StringUtil.toList((Iterator)StringUtil.camelHumpsIterator((String)configRootClassSimpleName));
        List trimmedSegments = configPhase == ConfigPhase.RUN_TIME ? StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)segments, (Object[])new String[]{"Runtime", "Configuration"}), (Object[])new String[]{"Runtime", "Config"}), (Object[])new String[]{"Run", "Time", "Configuration"}), (Object[])new String[]{"Run", "Time", "Config"}), (Object[])new String[]{"Configuration"}), (Object[])new String[]{"Config"}) : (configPhase == ConfigPhase.BOOTSTRAP ? StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)segments, (Object[])new String[]{"Bootstrap", "Configuration"}), (Object[])new String[]{"Bootstrap", "Config"}), (Object[])new String[]{"Configuration"}), (Object[])new String[]{"Config"}) : StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)StringUtil.withoutSuffix((List)segments, (Object[])new String[]{"Build", "Time", "Configuration"}), (Object[])new String[]{"Build", "Time", "Config"}), (Object[])new String[]{"Configuration"}), (Object[])new String[]{"Config"}));
        if (rootName.equals("<<parent>>")) {
            rootName = "";
        } else if (rootName.equals("<<element name>>")) {
            rootName = String.join((CharSequence)"", () -> StringUtil.lowerCaseFirst(trimmedSegments.iterator()));
        } else if (rootName.equals("<<hyphenated element name>>")) {
            rootName = String.join((CharSequence)"-", () -> StringUtil.lowerCase(trimmedSegments.iterator()));
        }
        return rootName;
    }

    private void processConfigGroup(String extensionName, IJavaElement javaElement, String baseKey, ConfigPhase configPhase, Map<IPackageFragmentRoot, Properties> javadocCache, QuarkusSearchContext quarkusContext, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            IJavaElement[] elements;
            IJavaElement[] iJavaElementArray = elements = ((IType)javaElement).getChildren();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IField field;
                IJavaElement child = iJavaElementArray[n2];
                if (child.getElementType() == 8 && QuarkusConfigRootProvider.canProcess(field = (IField)child)) {
                    String name;
                    IAnnotation configItemAnnotation = AnnotationUtils.getFirstAnnotation((IAnnotatable)field, (String[])new String[]{"io.quarkus.runtime.annotations.ConfigItem"});
                    String string = name = configItemAnnotation == null ? StringUtil.hyphenate((String)field.getElementName()) : AnnotationUtils.getAnnotationMemberValue((IAnnotation)configItemAnnotation, (String)"name");
                    if (name == null) {
                        name = "<<hyphenated element name>>";
                    }
                    Object subKey = name.equals("<<parent>>") ? baseKey : (name.equals("<<element name>>") ? baseKey + "." + field.getElementName() : (name.equals("<<hyphenated element name>>") ? baseKey + "." + StringUtil.hyphenate((String)field.getElementName()) : baseKey + "." + name));
                    String defaultValue = configItemAnnotation == null ? "<<no default>>" : AnnotationUtils.getAnnotationMemberValue((IAnnotation)configItemAnnotation, (String)"defaultValue");
                    String fieldTypeName = JDTTypeUtils.getResolvedTypeName((IField)field);
                    IType fieldClass = JDTTypeUtils.findType((IJavaProject)field.getJavaProject(), (String)fieldTypeName);
                    IAnnotation configGroupAnnotation = AnnotationUtils.getFirstAnnotation((IAnnotatable)fieldClass, (String[])new String[]{"io.quarkus.runtime.annotations.ConfigGroup"});
                    if (configGroupAnnotation != null) {
                        this.processConfigGroup(extensionName, (IJavaElement)fieldClass, (String)subKey, configPhase, javadocCache, quarkusContext, collector, monitor);
                    } else {
                        this.addItemMetadata(extensionName, field, fieldTypeName, fieldClass, (String)subKey, defaultValue, javadocCache, configPhase, quarkusContext, collector, monitor);
                    }
                }
                ++n2;
            }
        }
    }

    private static boolean canProcess(IField field) throws JavaModelException {
        int flags = field.getFlags();
        return !Flags.isStatic((int)flags) && !Flags.isPrivate((int)flags);
    }

    private void addItemMetadata(String extensionName, IField field, String fieldTypeName, IType fieldClass, String name, String defaultValue, Map<IPackageFragmentRoot, Properties> javadocCache, ConfigPhase configPhase, QuarkusSearchContext quarkusContext, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        String type = JDTTypeUtils.getPropertyType((IType)fieldClass, (String)fieldTypeName);
        String description = QuarkusConfigRootProvider.getJavadoc(field, javadocCache, monitor);
        String sourceType = JDTTypeUtils.getSourceType((IMember)field);
        String sourceField = JDTTypeUtils.getSourceField((IJavaElement)field);
        IType enclosedType = JDTTypeUtils.getEnclosedType((IType)fieldClass, (String)type, (IJavaProject)field.getJavaProject());
        super.updateHint(collector, enclosedType);
        ItemMetadata item = null;
        if (JDTTypeUtils.isPrimitiveBoolean((String)fieldTypeName)) {
            item = super.addItemMetadata(collector, name, type, description, sourceType, sourceField, null, defaultValue == null || "<<no default>>".equals(defaultValue) ? "false" : defaultValue, extensionName, field.isBinary());
        } else if (JDTTypeUtils.isNumber((String)fieldTypeName)) {
            item = super.addItemMetadata(collector, name, type, description, sourceType, sourceField, null, defaultValue == null || "<<no default>>".equals(defaultValue) ? "0" : defaultValue, extensionName, field.isBinary());
        } else if (JDTTypeUtils.isMap((String)fieldTypeName)) {
            String[] rawTypeParameters = QuarkusConfigRootProvider.getRawTypeParameters(fieldTypeName);
            if (rawTypeParameters[0].trim().equals("java.lang.String")) {
                this.processMap(field, name, rawTypeParameters[1], description, extensionName, sourceType, configPhase, javadocCache, 0, quarkusContext, collector, monitor);
            }
        } else if (JDTTypeUtils.isList((String)fieldTypeName)) {
            item = super.addItemMetadata(collector, name, type, description, sourceType, sourceField, null, defaultValue, extensionName, field.isBinary());
        } else if (JDTTypeUtils.isOptional((String)fieldTypeName)) {
            item = super.addItemMetadata(collector, name, type, description, sourceType, sourceField, null, defaultValue, extensionName, field.isBinary());
            item.setRequired(false);
        } else {
            if ("<<no default>>".equals(defaultValue)) {
                defaultValue = null;
            }
            item = super.addItemMetadata(collector, name, type, description, sourceType, sourceField, null, defaultValue, extensionName, field.isBinary());
        }
        if (item != null) {
            item.setPhase(QuarkusConfigRootProvider.getPhase(configPhase));
        }
        JDTQuarkusUtils.updateConverterKinds(item, (IMember)field, enclosedType);
    }

    private static String[] getRawTypeParameters(String fieldTypeName) {
        int start = fieldTypeName.indexOf("<") + 1;
        int end = fieldTypeName.lastIndexOf(">");
        String keyValue = fieldTypeName.substring(start, end);
        int index = keyValue.indexOf(44);
        return new String[]{keyValue.substring(0, index), keyValue.substring(index + 1, keyValue.length())};
    }

    private void processMap(IField field, String baseKey, String mapValueClass, String docs, String extensionName, String source, ConfigPhase configPhase, Map<IPackageFragmentRoot, Properties> javadocCache, int keyIndex, QuarkusSearchContext quarkusContext, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        String subKey = baseKey + "." + quarkusContext.getPropertyMapKey(extensionName, baseKey, keyIndex);
        if (!"java.util.Map".equals(mapValueClass)) {
            if (JDTTypeUtils.isMap((String)mapValueClass)) {
                String[] rawTypeParameters = QuarkusConfigRootProvider.getRawTypeParameters(mapValueClass);
                this.processMap(field, subKey, rawTypeParameters[1], docs, extensionName, source, configPhase, javadocCache, keyIndex + 1, quarkusContext, collector, monitor);
            } else if (!JDTTypeUtils.isOptional((String)mapValueClass)) {
                IType type = JDTTypeUtils.findType((IJavaProject)field.getJavaProject(), (String)mapValueClass);
                if (type == null || JDTTypeUtils.isPrimitiveType((String)mapValueClass)) {
                    this.addItemMetadata(extensionName, field, mapValueClass, null, subKey, null, javadocCache, configPhase, quarkusContext, collector, monitor);
                } else {
                    this.processConfigGroup(extensionName, (IJavaElement)type, subKey, configPhase, javadocCache, quarkusContext, collector, monitor);
                }
            }
        }
    }

    private static String getJavadoc(IField field, Map<IPackageFragmentRoot, Properties> javadocCache, IProgressMonitor monitor) throws JavaModelException {
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)field.getAncestor(3);
        Properties properties = javadocCache.get(packageRoot);
        if (properties == null) {
            properties = new Properties();
            javadocCache.put(packageRoot, properties);
            IJarEntryResource quarkusJavadocResource = QuarkusConfigRootProvider.findJavadocFromQuakusJavadocProperties(packageRoot);
            if (quarkusJavadocResource != null) {
                try {
                    properties.load(quarkusJavadocResource.getContents());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (properties.isEmpty()) {
            return null;
        }
        Object fieldKey = field.getDeclaringType().getFullyQualifiedName() + "." + field.getElementName();
        fieldKey = ((String)fieldKey).replace('$', '.');
        return properties.getProperty((String)fieldKey);
    }

    private static IJarEntryResource findJavadocFromQuakusJavadocProperties(IPackageFragmentRoot packageRoot) throws JavaModelException {
        return JDTTypeUtils.findPropertiesResource((IPackageFragmentRoot)packageRoot, (String)"quarkus-javadoc.properties");
    }

    private static int getPhase(ConfigPhase configPhase) {
        switch (configPhase) {
            case BUILD_TIME: {
                return 1;
            }
            case BUILD_AND_RUN_TIME_FIXED: {
                return 2;
            }
            case BOOTSTRAP: {
                return 3;
            }
            case RUN_TIME: {
                return 4;
            }
        }
        return 1;
    }
}

