/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.core.properties;

import com.redhat.microprofile.jdt.internal.quarkus.core.properties.ConfigProperties;
import com.redhat.microprofile.jdt.quarkus.JDTQuarkusUtils;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.runtime.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusConfigPropertiesProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(QuarkusConfigPropertiesProvider.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.arc.config.ConfigProperties"};
    private static final String CONFIG_PROPERTIES_CONTEXT_KEY = QuarkusConfigPropertiesProvider.class.getName() + "#ConfigPropertiesContext";

    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    public void beginSearch(SearchContext context, IProgressMonitor monitor) {
        context.put(CONFIG_PROPERTIES_CONTEXT_KEY, (Object)new ConfigPropertiesContext(context));
    }

    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        ConfigPropertiesContext configPropertiesContext = (ConfigPropertiesContext)context.get(CONFIG_PROPERTIES_CONTEXT_KEY);
        this.processConfigProperties(javaElement, annotation, configPropertiesContext, context.getCollector(), monitor);
    }

    private void processConfigProperties(IJavaElement javaElement, IAnnotation configPropertiesAnnotation, ConfigPropertiesContext configPropertiesContext, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() != 7) {
            return;
        }
        IType configPropertiesType = (IType)javaElement;
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)javaElement.getAncestor(3);
        String location = packageRoot.getPath().toString();
        String extensionName = JDTQuarkusUtils.getExtensionName(location);
        String prefix = QuarkusConfigPropertiesProvider.determinePrefix(configPropertiesType, configPropertiesAnnotation);
        if (configPropertiesType.isInterface()) {
            ArrayList<IType> allInterfaces = new ArrayList<IType>(Arrays.asList(QuarkusConfigPropertiesProvider.findInterfaces(configPropertiesType, monitor)));
            allInterfaces.add(0, configPropertiesType);
            for (IType configPropertiesInterface : allInterfaces) {
                IJavaElement[] elements;
                IJavaElement[] iJavaElementArray = elements = configPropertiesInterface.getChildren();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method;
                    IJavaElement child = iJavaElementArray[n2];
                    if (child.getElementType() == 9 && !Flags.isDefaultMethod((int)(method = (IMethod)child).getFlags())) {
                        if (method.getNumberOfParameters() > 0) {
                            LOGGER.log(Level.INFO, "Method " + method.getElementName() + " of interface " + method.getDeclaringType().getFullyQualifiedName() + " is not a getter method since it defined parameters");
                        } else if (JDTTypeUtils.isVoidReturnType((IMethod)method)) {
                            LOGGER.log(Level.INFO, "Method " + method.getElementName() + " of interface " + method.getDeclaringType().getFullyQualifiedName() + " is not a getter method since it returns void");
                        } else {
                            String name = null;
                            String defaultValue = null;
                            IAnnotation configPropertyAnnotation = AnnotationUtils.getFirstAnnotation((IAnnotatable)method, (String[])new String[]{"org.eclipse.microprofile.config.inject.ConfigProperty"});
                            if (configPropertyAnnotation != null) {
                                name = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configPropertyAnnotation, (String)"name");
                                defaultValue = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configPropertyAnnotation, (String)"defaultValue");
                            }
                            if (name == null) {
                                name = QuarkusConfigPropertiesProvider.getPropertyNameFromMethodName(method);
                            }
                            if (name != null) {
                                String propertyName = prefix + "." + QuarkusConfigPropertiesProvider.convertName(name, (IMember)method, configPropertiesAnnotation, configPropertiesContext);
                                String methodResultTypeName = JDTTypeUtils.getResolvedResultTypeName((IMethod)method);
                                IType returnType = JDTTypeUtils.findType((IJavaProject)method.getJavaProject(), (String)methodResultTypeName);
                                String type = JDTTypeUtils.getPropertyType((IType)returnType, (String)methodResultTypeName);
                                String description = null;
                                String sourceType = JDTTypeUtils.getSourceType((IMember)method);
                                String sourceMethod = JDTTypeUtils.getSourceMethod((IMethod)method);
                                IType enclosedType = JDTTypeUtils.getEnclosedType((IType)returnType, (String)methodResultTypeName, (IJavaProject)method.getJavaProject());
                                super.updateHint(collector, enclosedType);
                                if (JDTTypeUtils.isSimpleFieldType((IType)returnType, (String)methodResultTypeName)) {
                                    ItemMetadata metadata = super.addItemMetadata(collector, propertyName, type, description, sourceType, null, sourceMethod, defaultValue, extensionName, method.isBinary());
                                    JDTQuarkusUtils.updateConverterKinds(metadata, (IMember)method, enclosedType);
                                } else {
                                    this.populateConfigObject(returnType, propertyName, extensionName, new HashSet<IType>(), configPropertiesAnnotation, configPropertiesContext, collector, monitor);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
        } else {
            this.populateConfigObject(configPropertiesType, prefix, extensionName, new HashSet<IType>(), configPropertiesAnnotation, configPropertiesContext, collector, monitor);
        }
    }

    private static IType[] findInterfaces(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
        return typeHierarchy.getAllSuperInterfaces(type);
    }

    /*
     * Unable to fully structure code
     */
    private void populateConfigObject(IType configPropertiesType, String prefixStr, String extensionName, Set<IType> typesAlreadyProcessed, IAnnotation configPropertiesAnnotation, ConfigPropertiesContext configPropertiesContext, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        if (typesAlreadyProcessed.contains(configPropertiesType)) {
            return;
        }
        typesAlreadyProcessed.add(configPropertiesType);
        var13_10 = elements = configPropertiesType.getChildren();
        var12_11 = elements.length;
        var11_12 = 0;
        while (var11_12 < var12_11) {
            block8: {
                child = var13_10[var11_12];
                if (child.getElementType() != 8) break block8;
                field = (IField)child;
                useFieldAccess = false;
                setterName = JavaBeanUtil.getSetterName(field.getElementName());
                configClassInfo = configPropertiesType.getFullyQualifiedName();
                setter = QuarkusConfigPropertiesProvider.findMethod(configPropertiesType, setterName, field.getTypeSignature());
                if (setter != null) ** GOTO lbl21
                if (!Flags.isPublic((int)field.getFlags()) || Flags.isFinal((int)field.getFlags())) {
                    QuarkusConfigPropertiesProvider.LOGGER.log(Level.INFO, "Configuration properties class " + configClassInfo + " does not have a setter for field " + String.valueOf(field) + " nor is the field a public non-final field");
                } else {
                    useFieldAccess = true;
lbl21:
                    // 2 sources

                    if (!useFieldAccess && !Flags.isPublic((int)setter.getFlags())) {
                        QuarkusConfigPropertiesProvider.LOGGER.log(Level.INFO, "Setter " + setterName + " of class " + configClassInfo + " must be public");
                    } else {
                        name = field.getElementName();
                        defaultValue = null;
                        propertyName = prefixStr + "." + QuarkusConfigPropertiesProvider.convertName(name, (IMember)field, configPropertiesAnnotation, configPropertiesContext);
                        fieldTypeName = JDTTypeUtils.getResolvedTypeName((IField)field);
                        fieldClass = JDTTypeUtils.findType((IJavaProject)field.getJavaProject(), (String)fieldTypeName);
                        if (JDTTypeUtils.isSimpleFieldType((IType)fieldClass, (String)fieldTypeName)) {
                            type = JDTTypeUtils.getPropertyType((IType)fieldClass, (String)fieldTypeName);
                            description = null;
                            sourceType = JDTTypeUtils.getSourceType((IMember)field);
                            sourceField = JDTTypeUtils.getSourceField((IJavaElement)field);
                            enclosedType = JDTTypeUtils.getEnclosedType((IType)fieldClass, (String)type, (IJavaProject)field.getJavaProject());
                            super.updateHint(collector, enclosedType);
                            metadata = super.addItemMetadata(collector, propertyName, type, description, sourceType, sourceField, null, defaultValue, extensionName, field.isBinary());
                            JDTQuarkusUtils.updateConverterKinds(metadata, (IMember)field, enclosedType);
                        } else {
                            this.populateConfigObject(fieldClass, propertyName, extensionName, typesAlreadyProcessed, configPropertiesAnnotation, configPropertiesContext, collector, monitor);
                        }
                    }
                }
            }
            ++var11_12;
        }
    }

    private static String convertName(String name, IMember member, IAnnotation configPropertiesAnnotation, ConfigPropertiesContext configPropertiesContext) throws JavaModelException {
        if (!configPropertiesContext.isSupportNamingStrategy()) {
            return name;
        }
        ConfigProperties.NamingStrategy namingStrategy = QuarkusConfigPropertiesProvider.getNamingStrategy(configPropertiesAnnotation);
        if (namingStrategy != null) {
            switch (namingStrategy) {
                case FROM_CONFIG: {
                    return QuarkusConfigPropertiesProvider.convertDefaultName(name, configPropertiesContext);
                }
                case VERBATIM: {
                    return name;
                }
                case KEBAB_CASE: {
                    return StringUtil.hyphenate((String)name);
                }
            }
        }
        return QuarkusConfigPropertiesProvider.convertDefaultName(name, configPropertiesContext);
    }

    private static String convertDefaultName(String name, ConfigPropertiesContext configPropertiesContext) throws JavaModelException {
        ConfigProperties.NamingStrategy namingStrategy = QuarkusConfigPropertiesProvider.getNamingStrategy(configPropertiesContext.getDefaultNamingStrategy());
        if (namingStrategy != null && namingStrategy == ConfigProperties.NamingStrategy.VERBATIM) {
            return name;
        }
        return StringUtil.hyphenate((String)name);
    }

    private static String getPropertyNameFromMethodName(IMethod method) {
        try {
            return JavaBeanUtil.getPropertyNameFromGetter(method.getElementName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.INFO, "Method " + method.getElementName() + " of interface " + method.getDeclaringType().getElementName() + " is not a getter method. Either rename the method to follow getter name conventions or annotate the method with @ConfigProperty");
            return null;
        }
    }

    private static IMethod findMethod(IType configPropertiesType, String setterName, String fieldTypeSignature) {
        IMethod method = configPropertiesType.getMethod(setterName, new String[]{fieldTypeSignature});
        return method.exists() ? method : null;
    }

    private static String determinePrefix(IType configPropertiesType, IAnnotation configPropertiesAnnotation) throws JavaModelException {
        String fromAnnotation = QuarkusConfigPropertiesProvider.getPrefixFromAnnotation(configPropertiesAnnotation);
        if (fromAnnotation != null) {
            return fromAnnotation;
        }
        return QuarkusConfigPropertiesProvider.getPrefixFromClassName(configPropertiesType);
    }

    private static String getPrefixFromAnnotation(IAnnotation configPropertiesAnnotation) throws JavaModelException {
        String value = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configPropertiesAnnotation, (String)"prefix");
        if (value == null) {
            return null;
        }
        if ("<< unset >>".equals(value) || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private static String getPrefixFromClassName(IType className) {
        String simpleName = className.getElementName();
        return StringUtil.join((String)"-", (Iterator)StringUtil.withoutSuffix((Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)simpleName)), (String[])new String[]{"config", "configuration", "properties", "props"}));
    }

    private static ConfigProperties.NamingStrategy getNamingStrategy(IAnnotation configPropertiesAnnotation) throws JavaModelException {
        String namingStrategy = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configPropertiesAnnotation, (String)"namingStrategy");
        return QuarkusConfigPropertiesProvider.getNamingStrategy(namingStrategy);
    }

    private static ConfigProperties.NamingStrategy getNamingStrategy(String namingStrategy) {
        if (namingStrategy != null && !namingStrategy.isEmpty()) {
            try {
                return ConfigProperties.NamingStrategy.valueOf(namingStrategy.toUpperCase());
            }
            catch (Exception exception) {}
        }
        return null;
    }

    static class ConfigPropertiesContext {
        private final IJavaProject javaProject;
        private final boolean supportNamingStrategy;
        private String defaultNamingStrategy;

        public ConfigPropertiesContext(SearchContext context) {
            this.javaProject = context.getJavaProject();
            this.supportNamingStrategy = JDTQuarkusUtils.isSupportNamingStrategy(context.getJavaProject());
        }

        public boolean isSupportNamingStrategy() {
            return this.supportNamingStrategy;
        }

        public String getDefaultNamingStrategy() throws JavaModelException {
            if (this.defaultNamingStrategy == null) {
                this.defaultNamingStrategy = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(this.javaProject).getProperty("quarkus.arc.config-properties-default-naming-strategy", null);
                this.defaultNamingStrategy = this.defaultNamingStrategy != null ? this.defaultNamingStrategy.trim().toUpperCase() : "";
            }
            return this.defaultNamingStrategy;
        }
    }
}

