/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.PrimeNumberSequenceGenerator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected static final int TABLE_SIZE = 101;
    protected static final int MAX_HASH_COLLISIONS = 40;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected static final int SIZE_LIMIT = 20;
    protected boolean fNamespaces = true;
    protected int fLargeCount = 1;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Attribute[] fAttributeTableView;
    protected int[] fAttributeTableViewChainState;
    protected int fTableViewBuckets;
    protected boolean fIsTableViewConsistent;
    protected int[] fHashMultipliers;

    public XMLAttributesImpl() {
        this(101);
    }

    public XMLAttributesImpl(int n2) {
        this.fTableViewBuckets = n2;
        for (int i2 = 0; i2 < this.fAttributes.length; ++i2) {
            this.fAttributes[i2] = new Attribute();
        }
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    @Override
    public int addAttribute(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n2;
        if (this.fLength < 20) {
            int n3 = n2 = qName.uri != null && qName.uri.length() != 0 ? this.getIndexFast(qName.uri, qName.localpart) : this.getIndexFast(qName.rawname);
            if (n2 == -1) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    attributeArray = new Attribute[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                    for (int i2 = this.fAttributes.length; i2 < attributeArray.length; ++i2) {
                        attributeArray[i2] = new Attribute();
                    }
                    this.fAttributes = attributeArray;
                }
            }
        } else if (qName.uri == null || qName.uri.length() == 0 || (n2 = this.getIndexFast(qName.uri, qName.localpart)) == -1) {
            int n4;
            if (!this.fIsTableViewConsistent || this.fLength == 20 || this.fLength > 20 && this.fLength > this.fTableViewBuckets) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[n4 = this.getTableViewBucket(qName.rawname)] != this.fLargeCount) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributeArray2 = new Attribute[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributeArray2, 0, this.fAttributes.length);
                    for (int i3 = this.fAttributes.length; i3 < attributeArray2.length; ++i3) {
                        attributeArray2[i3] = new Attribute();
                    }
                    this.fAttributes = attributeArray2;
                }
                this.fAttributeTableViewChainState[n4] = this.fLargeCount;
                this.fAttributes[n2].next = null;
                this.fAttributeTableView[n4] = this.fAttributes[n2];
            } else {
                int n5 = 0;
                Attribute attribute = this.fAttributeTableView[n4];
                while (attribute != null && attribute.name.rawname != qName.rawname) {
                    attribute = attribute.next;
                    ++n5;
                }
                if (attribute == null) {
                    n2 = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        Attribute[] attributeArray3 = new Attribute[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributeArray3, 0, this.fAttributes.length);
                        for (int i4 = this.fAttributes.length; i4 < attributeArray3.length; ++i4) {
                            attributeArray3[i4] = new Attribute();
                        }
                        this.fAttributes = attributeArray3;
                    }
                    if (n5 >= 40) {
                        this.fAttributes[n2].name.setValues(qName);
                        this.rebalanceTableView(this.fLength);
                    } else {
                        this.fAttributes[n2].next = this.fAttributeTableView[n4];
                        this.fAttributeTableView[n4] = this.fAttributes[n2];
                    }
                } else {
                    n2 = this.getIndexFast(qName.rawname);
                }
            }
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
        return n2;
    }

    @Override
    public void removeAllAttributes() {
        this.fLength = 0;
    }

    @Override
    public void removeAttributeAt(int n2) {
        this.fIsTableViewConsistent = false;
        if (n2 < this.fLength - 1) {
            Attribute attribute = this.fAttributes[n2];
            System.arraycopy(this.fAttributes, n2 + 1, this.fAttributes, n2, this.fLength - n2 - 1);
            this.fAttributes[this.fLength - 1] = attribute;
        }
        --this.fLength;
    }

    @Override
    public void setName(int n2, QName qName) {
        this.fAttributes[n2].name.setValues(qName);
    }

    @Override
    public void getName(int n2, QName qName) {
        qName.setValues(this.fAttributes[n2].name);
    }

    @Override
    public void setType(int n2, String string) {
        this.fAttributes[n2].type = string;
    }

    @Override
    public void setValue(int n2, String string) {
        Attribute attribute = this.fAttributes[n2];
        attribute.value = string;
        attribute.nonNormalizedValue = string;
    }

    @Override
    public void setNonNormalizedValue(int n2, String string) {
        if (string == null) {
            string = this.fAttributes[n2].value;
        }
        this.fAttributes[n2].nonNormalizedValue = string;
    }

    @Override
    public String getNonNormalizedValue(int n2) {
        String string = this.fAttributes[n2].nonNormalizedValue;
        return string;
    }

    @Override
    public void setSpecified(int n2, boolean bl) {
        this.fAttributes[n2].specified = bl;
    }

    @Override
    public boolean isSpecified(int n2) {
        return this.fAttributes[n2].specified;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public String getType(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.getReportableType(this.fAttributes[n2].type);
    }

    @Override
    public String getType(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    @Override
    public String getValue(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].value;
    }

    @Override
    public String getValue(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].value : null;
    }

    public String getName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.rawname;
    }

    @Override
    public int getIndex(String string) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.rawname == null || !attribute.name.rawname.equals(string)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getIndex(String string, String string2) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.localpart == null || !attribute.name.localpart.equals(string2) || string != attribute.name.uri && (string == null || attribute.name.uri == null || !attribute.name.uri.equals(string))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String getLocalName(int n2) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.localpart;
    }

    @Override
    public String getQName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.rawname;
        return string != null ? string : "";
    }

    @Override
    public String getType(String string, String string2) {
        if (!this.fNamespaces) {
            return null;
        }
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    @Override
    public String getPrefix(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.prefix;
        return string != null ? string : "";
    }

    @Override
    public String getURI(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.uri;
        return string;
    }

    @Override
    public String getValue(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.getValue(n2) : null;
    }

    @Override
    public Augmentations getAugmentations(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    @Override
    public Augmentations getAugmentations(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    @Override
    public Augmentations getAugmentations(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].augs;
    }

    @Override
    public void setAugmentations(int n2, Augmentations augmentations) {
        this.fAttributes[n2].augs = augmentations;
    }

    public void setURI(int n2, String string) {
        this.fAttributes[n2].name.uri = string;
    }

    public int getIndexFast(String string) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.rawname != string) continue;
            return i2;
        }
        return -1;
    }

    public void addAttributeNS(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n2 = this.fLength;
        if (this.fLength++ == this.fAttributes.length) {
            attributeArray = this.fLength < 20 ? new Attribute[this.fAttributes.length + 4] : new Attribute[this.fAttributes.length << 1];
            System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
            for (int i2 = this.fAttributes.length; i2 < attributeArray.length; ++i2) {
                attributeArray[i2] = new Attribute();
            }
            this.fAttributes = attributeArray;
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
    }

    public QName checkDuplicatesNS() {
        int n2 = this.fLength;
        if (n2 <= 20) {
            Attribute[] attributeArray = this.fAttributes;
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                Attribute attribute = attributeArray[i2];
                for (int i3 = i2 + 1; i3 < n2; ++i3) {
                    Attribute attribute2 = attributeArray[i3];
                    if (attribute.name.localpart != attribute2.name.localpart || attribute.name.uri != attribute2.name.uri) continue;
                    return attribute2.name;
                }
            }
            return null;
        }
        return this.checkManyDuplicatesNS();
    }

    private QName checkManyDuplicatesNS() {
        this.fIsTableViewConsistent = false;
        this.prepareTableView();
        int n2 = this.fLength;
        Attribute[] attributeArray = this.fAttributes;
        Attribute[] attributeArray2 = this.fAttributeTableView;
        int[] nArray = this.fAttributeTableViewChainState;
        int n3 = this.fLargeCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = attributeArray[i2];
            int n4 = this.getTableViewBucket(attribute.name.localpart, attribute.name.uri);
            if (nArray[n4] != n3) {
                nArray[n4] = n3;
                attribute.next = null;
                attributeArray2[n4] = attribute;
                continue;
            }
            int n5 = 0;
            Attribute attribute2 = attributeArray2[n4];
            while (attribute2 != null) {
                if (attribute2.name.localpart == attribute.name.localpart && attribute2.name.uri == attribute.name.uri) {
                    return attribute.name;
                }
                attribute2 = attribute2.next;
                ++n5;
            }
            if (n5 >= 40) {
                this.rebalanceTableViewNS(i2 + 1);
                n3 = this.fLargeCount;
                continue;
            }
            attribute.next = attributeArray2[n4];
            attributeArray2[n4] = attribute;
        }
        return null;
    }

    public int getIndexFast(String string, String string2) {
        for (int i2 = 0; i2 < this.fLength; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            if (attribute.name.localpart != string2 || attribute.name.uri != string) continue;
            return i2;
        }
        return -1;
    }

    private String getReportableType(String string) {
        if (string.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return string;
    }

    protected int getTableViewBucket(String string) {
        return (this.hash(string) & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected int getTableViewBucket(String string, String string2) {
        if (string2 == null) {
            return (this.hash(string) & Integer.MAX_VALUE) % this.fTableViewBuckets;
        }
        return (this.hash(string, string2) & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    private int hash(String string) {
        if (this.fHashMultipliers == null) {
            return string.hashCode();
        }
        return this.hash0(string);
    }

    private int hash(String string, String string2) {
        if (this.fHashMultipliers == null) {
            return string.hashCode() + string2.hashCode() * 31;
        }
        return this.hash0(string) + this.hash0(string2) * this.fHashMultipliers[32];
    }

    private int hash0(String string) {
        int n2 = 0;
        int n3 = string.length();
        int[] nArray = this.fHashMultipliers;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * nArray[i2 & 0x1F] + string.charAt(i2);
        }
        return n2;
    }

    protected void cleanTableView() {
        if (++this.fLargeCount < 0) {
            if (this.fAttributeTableViewChainState != null) {
                for (int i2 = this.fTableViewBuckets - 1; i2 >= 0; --i2) {
                    this.fAttributeTableViewChainState[i2] = 0;
                }
            }
            this.fLargeCount = 1;
        }
    }

    private void growTableView() {
        int n2 = this.fLength;
        int n3 = this.fTableViewBuckets;
        do {
            if ((n3 = (n3 << 1) + 1) >= 0) continue;
            n3 = Integer.MAX_VALUE;
            break;
        } while (n2 > n3);
        this.fTableViewBuckets = n3;
        this.fAttributeTableView = null;
        this.fLargeCount = 1;
    }

    protected void prepareTableView() {
        if (this.fLength > this.fTableViewBuckets) {
            this.growTableView();
        }
        if (this.fAttributeTableView == null) {
            this.fAttributeTableView = new Attribute[this.fTableViewBuckets];
            this.fAttributeTableViewChainState = new int[this.fTableViewBuckets];
        } else {
            this.cleanTableView();
        }
    }

    protected void prepareAndPopulateTableView() {
        this.prepareAndPopulateTableView(this.fLength);
    }

    private void prepareAndPopulateTableView(int n2) {
        this.prepareTableView();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            int n3 = this.getTableViewBucket(attribute.name.rawname);
            if (this.fAttributeTableViewChainState[n3] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n3] = this.fLargeCount;
                attribute.next = null;
                this.fAttributeTableView[n3] = attribute;
                continue;
            }
            attribute.next = this.fAttributeTableView[n3];
            this.fAttributeTableView[n3] = attribute;
        }
    }

    private void prepareAndPopulateTableViewNS(int n2) {
        this.prepareTableView();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = this.fAttributes[i2];
            int n3 = this.getTableViewBucket(attribute.name.localpart, attribute.name.uri);
            if (this.fAttributeTableViewChainState[n3] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n3] = this.fLargeCount;
                attribute.next = null;
                this.fAttributeTableView[n3] = attribute;
                continue;
            }
            attribute.next = this.fAttributeTableView[n3];
            this.fAttributeTableView[n3] = attribute;
        }
    }

    private void rebalanceTableView(int n2) {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[33];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.prepareAndPopulateTableView(n2);
    }

    private void rebalanceTableViewNS(int n2) {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[33];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.prepareAndPopulateTableViewNS(n2);
    }

    static class Attribute {
        public final QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public Augmentations augs = new AugmentationsImpl();
        public Attribute next;

        Attribute() {
        }
    }
}

