/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.PrimeNumberSequenceGenerator;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected static final int MAX_HASH_COLLISIONS = 40;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected Entry[] fBuckets = null;
    protected int fTableSize;
    protected transient int fCount;
    protected int fThreshold;
    protected float fLoadFactor;
    protected final int fCollisionThreshold;
    protected int[] fHashMultipliers;

    public SymbolTable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.fLoadFactor = f2;
        this.fTableSize = n2;
        this.fBuckets = new Entry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * f2);
        this.fCollisionThreshold = (int)(40.0f * f2);
        this.fCount = 0;
    }

    public SymbolTable(int n2) {
        this(n2, 0.75f);
    }

    public SymbolTable() {
        this(101, 0.75f);
    }

    public String addSymbol(String string) {
        int n2 = 0;
        int n3 = this.hash(string) % this.fTableSize;
        Entry entry = this.fBuckets[n3];
        while (entry != null) {
            if (entry.symbol.equals(string)) {
                return entry.symbol;
            }
            ++n2;
            entry = entry.next;
        }
        return this.addSymbol0(string, n3, n2);
    }

    private String addSymbol0(String string, int n2, int n3) {
        Entry entry;
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n2 = this.hash(string) % this.fTableSize;
        } else if (n3 >= this.fCollisionThreshold) {
            this.rebalance();
            n2 = this.hash(string) % this.fTableSize;
        }
        this.fBuckets[n2] = entry = new Entry(string, this.fBuckets[n2]);
        ++this.fCount;
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n5];
        while (entry != null) {
            block3: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (cArray[n2 + i2] == entry.characters[i2]) continue;
                        ++n4;
                        break block3;
                    }
                    return entry.symbol;
                }
                ++n4;
            }
            entry = entry.next;
        }
        return this.addSymbol0(cArray, n2, n3, n5, n4);
    }

    private String addSymbol0(char[] cArray, int n2, int n3, int n4, int n5) {
        Entry entry;
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        } else if (n5 >= this.fCollisionThreshold) {
            this.rebalance();
            n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        }
        this.fBuckets[n4] = entry = new Entry(cArray, n2, n3, this.fBuckets[n4]);
        ++this.fCount;
        return entry.symbol;
    }

    public int hash(String string) {
        if (this.fHashMultipliers == null) {
            return string.hashCode() & Integer.MAX_VALUE;
        }
        return this.hash0(string);
    }

    private int hash0(String string) {
        int n2 = 0;
        int n3 = string.length();
        int[] nArray = this.fHashMultipliers;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = n2 * nArray[i2 & 0x1F] + string.charAt(i2);
        }
        return n2 & Integer.MAX_VALUE;
    }

    public int hash(char[] cArray, int n2, int n3) {
        if (this.fHashMultipliers == null) {
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                n4 = n4 * 31 + cArray[n2 + i2];
            }
            return n4 & Integer.MAX_VALUE;
        }
        return this.hash0(cArray, n2, n3);
    }

    private int hash0(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int[] nArray = this.fHashMultipliers;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = n4 * nArray[i2 & 0x1F] + cArray[n2 + i2];
        }
        return n4 & Integer.MAX_VALUE;
    }

    protected void rehash() {
        this.rehashCommon(this.fBuckets.length * 2 + 1);
    }

    protected void rebalance() {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[32];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.rehashCommon(this.fBuckets.length);
    }

    private void rehashCommon(int n2) {
        int n3 = this.fBuckets.length;
        Entry[] entryArray = this.fBuckets;
        Entry[] entryArray2 = new Entry[n2];
        this.fThreshold = (int)((float)n2 * this.fLoadFactor);
        this.fBuckets = entryArray2;
        this.fTableSize = this.fBuckets.length;
        int n4 = n3;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = this.hash(entry2.symbol) % n2;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public boolean containsSymbol(String string) {
        int n2 = this.hash(string) % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (string.charAt(i2) == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (cArray[n2 + i2] == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public final String symbol;
        public final char[] characters;
        public Entry next;

        public Entry(String string, Entry entry) {
            this.symbol = string.intern();
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n2, int n3, Entry entry) {
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

