/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.HashMap;
import java.util.Vector;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMRepeatingLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int[] fElemMapId = null;
    private int fElemMapSize = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private Occurence[] fCountingStates = null;
    private int fTransTableSize = 0;
    private boolean fIsCompactedForUPA;
    private static long time = 0L;

    public XSDFACM(CMNode cMNode, int n2) {
        this.fLeafCount = n2;
        this.fIsCompactedForUPA = cMNode.isCompactedForUPA();
        this.buildDFA(cMNode);
    }

    public boolean isFinalState(int n2) {
        return n2 < 0 ? false : this.fFinalStateFlags[n2];
    }

    @Override
    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        int n2;
        int n3 = nArray[0];
        if (n3 == -1 || n3 == -2) {
            if (n3 == -1) {
                nArray[0] = -2;
            }
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        int n4 = 0;
        Object object = null;
        for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
            n4 = this.fTransTable[n3][n2];
            if (n4 == -1) continue;
            int n5 = this.fElemMapType[n2];
            if (n5 == 1) {
                object = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n2]);
                if (object == null) continue;
                break;
            }
            if (n5 != 2 || !((XSWildcardDecl)this.fElemMap[n2]).allowNamespace(qName.uri)) continue;
            object = this.fElemMap[n2];
            break;
        }
        if (n2 == this.fElemMapSize) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        if (this.fCountingStates != null) {
            Occurence occurence = this.fCountingStates[n3];
            if (occurence != null) {
                if (n3 == n4) {
                    nArray[2] = nArray[2] + 1;
                    if (nArray[2] > occurence.maxOccurs && occurence.maxOccurs != -1) {
                        return this.findMatchingDecl(qName, nArray, substitutionGroupHandler, n2);
                    }
                } else {
                    if (nArray[2] < occurence.minOccurs) {
                        nArray[1] = nArray[0];
                        nArray[0] = -1;
                        return this.findMatchingDecl(qName, substitutionGroupHandler);
                    }
                    occurence = this.fCountingStates[n4];
                    if (occurence != null) {
                        nArray[2] = n2 == occurence.elemIndex ? 1 : 0;
                    }
                }
            } else {
                occurence = this.fCountingStates[n4];
                if (occurence != null) {
                    nArray[2] = n2 == occurence.elemIndex ? 1 : 0;
                }
            }
        }
        nArray[0] = n4;
        return object;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            int n2 = this.fElemMapType[i2];
            if (n2 == 1) {
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[i2]);
                if (xSElementDecl == null) continue;
                return xSElementDecl;
            }
            if (n2 != 2 || !((XSWildcardDecl)this.fElemMap[i2]).allowNamespace(qName.uri)) continue;
            return this.fElemMap[i2];
        }
        return null;
    }

    Object findMatchingDecl(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler, int n2) {
        int n3 = nArray[0];
        int n4 = 0;
        Object object = null;
        while (++n2 < this.fElemMapSize) {
            n4 = this.fTransTable[n3][n2];
            if (n4 == -1) continue;
            int n5 = this.fElemMapType[n2];
            if (n5 == 1) {
                object = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n2]);
                if (object == null) continue;
                break;
            }
            if (n5 != 2 || !((XSWildcardDecl)this.fElemMap[n2]).allowNamespace(qName.uri)) continue;
            object = this.fElemMap[n2];
            break;
        }
        if (n2 == this.fElemMapSize) {
            nArray[1] = nArray[0];
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = n4;
        Occurence occurence = this.fCountingStates[n4];
        if (occurence != null) {
            nArray[2] = n2 == occurence.elemIndex ? 1 : 0;
        }
        return object;
    }

    @Override
    public int[] startContentModel() {
        return new int[3];
    }

    @Override
    public boolean endContentModel(int[] nArray) {
        int n2 = nArray[0];
        if (this.fFinalStateFlags[n2]) {
            Occurence occurence;
            return this.fCountingStates == null || (occurence = this.fCountingStates[n2]) == null || nArray[2] >= occurence.minOccurs;
        }
        return false;
    }

    private void buildDFA(CMNode cMNode) {
        int n2;
        Object object;
        int n3;
        int n4;
        int n5 = this.fLeafCount;
        XSCMLeaf xSCMLeaf = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, cMNode, xSCMLeaf);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (int i2 = 0; i2 < this.fLeafCount; ++i2) {
            this.fFollowList[i2] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapId = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        Occurence[] occurenceArray = null;
        for (int i3 = 0; i3 < this.fLeafCount; ++i3) {
            this.fElemMap[i3] = null;
            n4 = this.fLeafList[i3].getParticleId();
            for (n3 = 0; n3 < this.fElemMapSize && n4 != this.fElemMapId[n3]; ++n3) {
            }
            if (n3 != this.fElemMapSize) continue;
            XSCMLeaf xSCMLeaf2 = this.fLeafList[i3];
            this.fElemMap[this.fElemMapSize] = xSCMLeaf2.getLeaf();
            if (xSCMLeaf2 instanceof XSCMRepeatingLeaf) {
                if (occurenceArray == null) {
                    occurenceArray = new Occurence[this.fLeafCount];
                }
                occurenceArray[this.fElemMapSize] = new Occurence((XSCMRepeatingLeaf)xSCMLeaf2, this.fElemMapSize);
            }
            this.fElemMapType[this.fElemMapSize] = this.fLeafListType[i3];
            this.fElemMapId[this.fElemMapSize] = n4;
            ++this.fElemMapSize;
        }
        --this.fElemMapSize;
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        n3 = 0;
        for (n4 = 0; n4 < this.fElemMapSize; ++n4) {
            int n6 = this.fElemMapId[n4];
            for (int i4 = 0; i4 < this.fLeafCount; ++i4) {
                if (n6 != this.fLeafList[i4].getParticleId()) continue;
                nArray[n3++] = i4;
            }
            nArray[n3++] = -1;
        }
        n4 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n4];
        this.fFinalStateFlags = new boolean[n4];
        this.fTransTable = new int[n4][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n7 = 0;
        int n8 = 0;
        this.fTransTable[n8] = this.makeDefStateList();
        cMStateSetArray[n8] = cMStateSet;
        ++n8;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        while (n7 < n8) {
            cMStateSet = cMStateSetArray[n7];
            int[] nArray2 = this.fTransTable[n7];
            this.fFinalStateFlags[n7] = cMStateSet.getBit(n5);
            ++n7;
            object = null;
            n2 = 0;
            for (int i5 = 0; i5 < this.fElemMapSize; ++i5) {
                int n9;
                if (object == null) {
                    object = new CMStateSet(this.fLeafCount);
                } else {
                    ((CMStateSet)object).zeroBits();
                }
                int n10 = nArray[n2++];
                while (n10 != -1) {
                    if (cMStateSet.getBit(n10)) {
                        ((CMStateSet)object).union(this.fFollowList[n10]);
                    }
                    n10 = nArray[n2++];
                }
                if (((CMStateSet)object).isEmpty()) continue;
                Integer n11 = (Integer)hashMap.get(object);
                int n12 = n9 = n11 == null ? n8 : n11;
                if (n9 == n8) {
                    cMStateSetArray[n8] = object;
                    this.fTransTable[n8] = this.makeDefStateList();
                    hashMap.put(object, new Integer(n8));
                    ++n8;
                    object = null;
                }
                nArray2[i5] = n9;
                if (n8 != n4) continue;
                int n13 = (int)((double)n4 * 1.5);
                CMStateSet[] cMStateSetArray2 = new CMStateSet[n13];
                boolean[] blArray = new boolean[n13];
                int[][] nArrayArray = new int[n13][];
                System.arraycopy(cMStateSetArray, 0, cMStateSetArray2, 0, n4);
                System.arraycopy(this.fFinalStateFlags, 0, blArray, 0, n4);
                System.arraycopy(this.fTransTable, 0, nArrayArray, 0, n4);
                n4 = n13;
                cMStateSetArray = cMStateSetArray2;
                this.fFinalStateFlags = blArray;
                this.fTransTable = nArrayArray;
            }
        }
        if (occurenceArray != null) {
            this.fCountingStates = new Occurence[n8];
            block8: for (int i6 = 0; i6 < n8; ++i6) {
                object = this.fTransTable[i6];
                for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                    if (i6 != object[n2]) continue;
                    this.fCountingStates[i6] = occurenceArray[n2];
                    continue block8;
                }
            }
        }
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        this.fElemMapId = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 101) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 102) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((XSCMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((XSCMBinOp)cMNode).getRight().firstPos();
            for (int i2 = 0; i2 < this.fLeafCount; ++i2) {
                if (!cMStateSet.getBit(i2)) continue;
                this.fFollowList[i2].union(cMStateSet2);
            }
        } else if (cMNode.type() == 4 || cMNode.type() == 6) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            for (int i3 = 0; i3 < this.fLeafCount; ++i3) {
                if (!cMStateSet3.getBit(i3)) continue;
                this.fFollowList[i3].union(cMStateSet);
            }
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("   ");
        }
        n3 = cMNode.type();
        switch (n3) {
            case 101: 
            case 102: {
                if (n3 == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMBinOp)cMNode).getLeft(), n2 + 1);
                this.dumpTree(((XSCMBinOp)cMNode).getRight(), n2 + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMUniOp)cMNode).getChild(), n2 + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)cMNode).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)cMNode).getLeaf() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            nArray[i2] = -1;
        }
        return nArray;
    }

    private void postTreeBuildInit(CMNode cMNode) throws RuntimeException {
        cMNode.setMaxStates(this.fLeafCount);
        XSCMLeaf xSCMLeaf = null;
        int n2 = 0;
        if (cMNode.type() == 2) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n2 = xSCMLeaf.getPosition();
            this.fLeafList[n2] = xSCMLeaf;
            this.fLeafListType[n2] = 2;
        } else if (cMNode.type() == 101 || cMNode.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 4 || cMNode.type() == 6 || cMNode.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)cMNode).getChild());
        } else if (cMNode.type() == 1) {
            xSCMLeaf = (XSCMLeaf)cMNode;
            n2 = xSCMLeaf.getPosition();
            this.fLeafList[n2] = xSCMLeaf;
            this.fLeafListType[n2] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n2;
        int n3;
        byte[][] byArray = new byte[this.fElemMapSize][this.fElemMapSize];
        for (n3 = 0; n3 < this.fTransTable.length && this.fTransTable[n3] != null; ++n3) {
            for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
                for (int i2 = n2 + 1; i2 < this.fElemMapSize; ++i2) {
                    if (this.fTransTable[n3][n2] == -1 || this.fTransTable[n3][i2] == -1 || byArray[n2][i2] != 0) continue;
                    if (XSConstraints.overlapUPA(this.fElemMap[n2], this.fElemMap[i2], substitutionGroupHandler)) {
                        Occurence occurence;
                        if (this.fCountingStates != null && (occurence = this.fCountingStates[n3]) != null && this.fTransTable[n3][n2] == n3 ^ this.fTransTable[n3][i2] == n3 && occurence.minOccurs == occurence.maxOccurs) {
                            byArray[n2][i2] = -1;
                            continue;
                        }
                        byArray[n2][i2] = 1;
                        continue;
                    }
                    byArray[n2][i2] = -1;
                }
            }
        }
        for (n3 = 0; n3 < this.fElemMapSize; ++n3) {
            for (n2 = 0; n2 < this.fElemMapSize; ++n2) {
                if (byArray[n3][n2] != 1) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[n3].toString(), this.fElemMap[n2].toString()});
            }
        }
        for (n3 = 0; n3 < this.fElemMapSize; ++n3) {
            if (this.fElemMapType[n3] != 2) continue;
            XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)this.fElemMap[n3];
            if (xSWildcardDecl.fType != 3 && xSWildcardDecl.fType != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] nArray) {
        int n2 = nArray[0];
        if (n2 < 0) {
            n2 = nArray[1];
        }
        Occurence occurence = this.fCountingStates != null ? this.fCountingStates[n2] : null;
        int n3 = nArray[2];
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 0; i2 < this.fElemMapSize; ++i2) {
            int n4 = this.fTransTable[n2][i2];
            if (n4 == -1 || occurence != null && (n2 == n4 ? n3 >= occurence.maxOccurs && occurence.maxOccurs != -1 : n3 < occurence.minOccurs)) continue;
            vector.addElement(this.fElemMap[i2]);
        }
        return vector;
    }

    @Override
    public int[] occurenceInfo(int[] nArray) {
        if (this.fCountingStates != null) {
            Occurence occurence;
            int n2 = nArray[0];
            if (n2 < 0) {
                n2 = nArray[1];
            }
            if ((occurence = this.fCountingStates[n2]) != null) {
                int[] nArray2 = new int[]{occurence.minOccurs, occurence.maxOccurs, nArray[2], occurence.elemIndex};
                return nArray2;
            }
        }
        return null;
    }

    @Override
    public String getTermName(int n2) {
        Object object = this.fElemMap[n2];
        return object != null ? object.toString() : null;
    }

    @Override
    public boolean isCompactedForUPA() {
        return this.fIsCompactedForUPA;
    }

    static final class Occurence {
        final int minOccurs;
        final int maxOccurs;
        final int elemIndex;

        public Occurence(XSCMRepeatingLeaf xSCMRepeatingLeaf, int n2) {
            this.minOccurs = xSCMRepeatingLeaf.getMinOccurs();
            this.maxOccurs = xSCMRepeatingLeaf.getMaxOccurs();
            this.elemIndex = n2;
        }

        public String toString() {
            return "minOccurs=" + this.minOccurs + ";maxOccurs=" + (this.maxOccurs != -1 ? Integer.toString(this.maxOccurs) : "unbounded");
        }
    }
}

