/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.util.ShortListImpl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class Field {
    protected final XPath fXPath;
    protected final IdentityConstraint fIdentityConstraint;

    public Field(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(ValueStore valueStore) {
        return new Matcher(this.fXPath, valueStore);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected final ValueStore fStore;
        protected boolean fMayMatch;

        public Matcher(XPath xPath, ValueStore valueStore) {
            super(xPath);
            this.fMayMatch = true;
            this.fStore = valueStore;
        }

        @Override
        protected void matched(Object object, short s2, ShortList shortList, boolean bl) {
            super.matched(object, s2, shortList, bl);
            if (bl && Field.this.fIdentityConstraint.getCategory() == 1) {
                String string = "KeyMatchesNillable";
                this.fStore.reportError(string, new Object[]{Field.this.fIdentityConstraint.getElementName(), Field.this.fIdentityConstraint.getIdentityConstraintName()});
            }
            this.fStore.addValue(Field.this, this.fMayMatch, object, this.convertToPrimitiveKind(s2), this.convertToPrimitiveKind(shortList));
            this.fMayMatch = false;
        }

        private short convertToPrimitiveKind(short s2) {
            if (s2 <= 20) {
                return s2;
            }
            if (s2 <= 29) {
                return 2;
            }
            if (s2 <= 42) {
                return 4;
            }
            return s2;
        }

        private ShortList convertToPrimitiveKind(ShortList shortList) {
            if (shortList != null) {
                short s2;
                int n2;
                int n3 = shortList.getLength();
                for (n2 = 0; n2 < n3 && (s2 = shortList.item(n2)) == this.convertToPrimitiveKind(s2); ++n2) {
                }
                if (n2 != n3) {
                    short[] sArray = new short[n3];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        sArray[i2] = shortList.item(i2);
                    }
                    while (n2 < n3) {
                        sArray[n2] = this.convertToPrimitiveKind(shortList.item(n2));
                        ++n2;
                    }
                    return new ShortListImpl(sArray, sArray.length);
                }
            }
            return shortList;
        }

        @Override
        protected void handleContent(XSTypeDefinition xSTypeDefinition, boolean bl, Object object, short s2, ShortList shortList) {
            if (xSTypeDefinition == null || xSTypeDefinition.getTypeCategory() == 15 && ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() != 1) {
                this.fStore.reportError("cvc-id.3", new Object[]{Field.this.fIdentityConstraint.getName(), Field.this.fIdentityConstraint.getElementName()});
            }
            this.fMatchedString = object;
            this.matched(this.fMatchedString, s2, shortList, bl);
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String string, SymbolTable symbolTable, NamespaceContext namespaceContext) throws XPathException {
            super(XPath.fixupXPath(string), symbolTable, namespaceContext);
            for (int i2 = 0; i2 < this.fLocationPaths.length; ++i2) {
                for (int i3 = 0; i3 < this.fLocationPaths[i2].steps.length; ++i3) {
                    XPath.Axis axis = this.fLocationPaths[i2].steps[i3].axis;
                    if (axis.type != 2 || i3 >= this.fLocationPaths[i2].steps.length - 1) continue;
                    throw new XPathException("c-fields-xpaths");
                }
            }
        }

        private static String fixupXPath(String string) {
            int n2 = string.length();
            boolean bl = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (bl) {
                    if (XMLChar.isSpace(c2)) continue;
                    if (c2 == '.' || c2 == '/') {
                        bl = false;
                        continue;
                    }
                    if (c2 == '|') continue;
                    return XPath.fixupXPath2(string, i2, n2);
                }
                if (c2 != '|') continue;
                bl = true;
            }
            return string;
        }

        private static String fixupXPath2(String string, int n2, int n3) {
            int n4;
            StringBuffer stringBuffer = new StringBuffer(n3 + 2);
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuffer.append(string.charAt(n4));
            }
            stringBuffer.append("./");
            n4 = 0;
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (n4 != 0) {
                    if (!XMLChar.isSpace(c2)) {
                        if (c2 == '.' || c2 == '/') {
                            n4 = 0;
                        } else if (c2 != '|') {
                            stringBuffer.append("./");
                            n4 = 0;
                        }
                    }
                } else if (c2 == '|') {
                    n4 = 1;
                }
                stringBuffer.append(c2);
                ++n2;
            }
            return stringBuffer.toString();
        }
    }
}

