/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.File;
import java.io.UnsupportedEncodingException;

final class FilePathToURI {
    private static boolean[] gNeedEscaping = new boolean[128];
    private static char[] gAfterEscaping1 = new char[128];
    private static char[] gAfterEscaping2 = new char[128];
    private static char[] gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private FilePathToURI() {
    }

    public static String filepath2URI(String string) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        char c2 = File.separatorChar;
        string = string.replace(c2, '/');
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n4 * 3);
        stringBuffer.append("file://");
        if (n4 >= 2 && string.charAt(1) == ':' && (n3 = Character.toUpperCase(string.charAt(0))) >= 65 && n3 <= 90) {
            stringBuffer.append('/');
        }
        for (n2 = 0; n2 < n4 && (n3 = string.charAt(n2)) < 128; ++n2) {
            if (gNeedEscaping[n3]) {
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[n3]);
                stringBuffer.append(gAfterEscaping2[n3]);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        if (n2 < n4) {
            byte[] byArray = null;
            try {
                byArray = string.substring(n2).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            for (byte by : byArray) {
                if (by < 0) {
                    n3 = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n3 >> 4]);
                    stringBuffer.append(gHexChs[n3 & 0xF]);
                    continue;
                }
                if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                    continue;
                }
                stringBuffer.append((char)by);
            }
        }
        return stringBuffer.toString();
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            FilePathToURI.gNeedEscaping[i2] = true;
            FilePathToURI.gAfterEscaping1[i2] = gHexChs[i2 >> 4];
            FilePathToURI.gAfterEscaping2[i2] = gHexChs[i2 & 0xF];
        }
        FilePathToURI.gNeedEscaping[127] = true;
        FilePathToURI.gAfterEscaping1[127] = 55;
        FilePathToURI.gAfterEscaping2[127] = 70;
        for (char c2 : new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            FilePathToURI.gNeedEscaping[c2] = true;
            FilePathToURI.gAfterEscaping1[c2] = gHexChs[c2 >> 4];
            FilePathToURI.gAfterEscaping2[c2] = gHexChs[c2 & 0xF];
        }
    }
}

