/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.io.Serializable;
import java.text.CharacterIterator;
import java.util.Locale;
import java.util.Stack;
import org.apache.xerces.impl.xpath.regex.BMPattern;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.Op;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.ParserForXMLSchema;
import org.apache.xerces.impl.xpath.regex.REUtil;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegexParser;
import org.apache.xerces.impl.xpath.regex.Token;
import org.apache.xerces.util.IntStack;

public class RegularExpression
implements Serializable {
    private static final long serialVersionUID = 6242499334195006401L;
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token, null, false);
    }

    private Op compile(Token token, Op op, boolean bl) {
        Op op2;
        switch (token.type) {
            case 11: {
                op2 = Op.createDot();
                op2.next = op;
                break;
            }
            case 0: {
                op2 = Op.createChar(token.getChar());
                op2.next = op;
                break;
            }
            case 8: {
                op2 = Op.createAnchor(token.getChar());
                op2.next = op;
                break;
            }
            case 4: 
            case 5: {
                op2 = Op.createRange(token);
                op2.next = op;
                break;
            }
            case 1: {
                op2 = op;
                if (!bl) {
                    for (int i2 = token.size() - 1; i2 >= 0; --i2) {
                        op2 = this.compile(token.getChild(i2), op2, false);
                    }
                } else {
                    for (int i3 = 0; i3 < token.size(); ++i3) {
                        op2 = this.compile(token.getChild(i3), op2, true);
                    }
                }
                break;
            }
            case 2: {
                Op.UnionOp unionOp = Op.createUnion(token.size());
                for (int i4 = 0; i4 < token.size(); ++i4) {
                    unionOp.addElement(this.compile(token.getChild(i4), op, bl));
                }
                op2 = unionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token2 = token.getChild(0);
                int n2 = token.getMin();
                int n3 = token.getMax();
                if (n2 >= 0 && n2 == n3) {
                    op2 = op;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        op2 = this.compile(token2, op2, bl);
                    }
                } else {
                    if (n2 > 0 && n3 > 0) {
                        n3 -= n2;
                    }
                    if (n3 > 0) {
                        op2 = op;
                        for (int i6 = 0; i6 < n3; ++i6) {
                            Op.ChildOp childOp = Op.createQuestion(token.type == 9);
                            childOp.next = op;
                            childOp.setChild(this.compile(token2, op2, bl));
                            op2 = childOp;
                        }
                    } else {
                        Op.ChildOp childOp = token.type == 9 ? Op.createNonGreedyClosure() : Op.createClosure(this.numberOfClosures++);
                        childOp.next = op;
                        childOp.setChild(this.compile(token2, childOp, bl));
                        op2 = childOp;
                    }
                    if (n2 <= 0) break;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        op2 = this.compile(token2, op2, bl);
                    }
                }
                break;
            }
            case 7: {
                op2 = op;
                break;
            }
            case 10: {
                op2 = Op.createString(token.getString());
                op2.next = op;
                break;
            }
            case 12: {
                op2 = Op.createBackReference(token.getReferenceNumber());
                op2.next = op;
                break;
            }
            case 6: {
                if (token.getParenNumber() == 0) {
                    op2 = this.compile(token.getChild(0), op, bl);
                    break;
                }
                if (bl) {
                    op = Op.createCapture(token.getParenNumber(), op);
                    op = this.compile(token.getChild(0), op, bl);
                    op2 = Op.createCapture(-token.getParenNumber(), op);
                    break;
                }
                op = Op.createCapture(-token.getParenNumber(), op);
                op = this.compile(token.getChild(0), op, bl);
                op2 = Op.createCapture(token.getParenNumber(), op);
                break;
            }
            case 20: {
                op2 = Op.createLook(20, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 21: {
                op2 = Op.createLook(21, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 22: {
                op2 = Op.createLook(22, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 23: {
                op2 = Op.createLook(23, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 24: {
                op2 = Op.createIndependent(op, this.compile(token.getChild(0), null, bl));
                break;
            }
            case 25: {
                op2 = Op.createModifier(op, this.compile(token.getChild(0), null, bl), ((Token.ModifierToken)token).getOptions(), ((Token.ModifierToken)token).getOptionsMask());
                break;
            }
            case 26: {
                Token.ConditionToken conditionToken = (Token.ConditionToken)token;
                int n4 = conditionToken.refNumber;
                Op op3 = conditionToken.condition == null ? null : this.compile(conditionToken.condition, null, bl);
                Op op4 = this.compile(conditionToken.yes, op, bl);
                Op op5 = conditionToken.no == null ? null : this.compile(conditionToken.no, op, bl);
                op2 = Op.createCondition(op, n4, op3, op4, op5);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token.type);
            }
        }
        return op2;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, (Match)null);
    }

    public boolean matches(char[] cArray, int n2, int n3) {
        return this.matches(cArray, n2, n3, (Match)null);
    }

    public boolean matches(char[] cArray, Match match) {
        return this.matches(cArray, 0, cArray.length, match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(char[] cArray, int n2, int n3, Match match) {
        int n4;
        int n5;
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object = null;
        Context context = this.context;
        synchronized (context) {
            object = this.context.inuse ? new Context() : this.context;
            ((Context)object).reset(cArray, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(cArray);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.match((Context)object, this.operations, ((Context)object).start, 1, this.options);
            if (n6 == ((Context)object).limit) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, ((Context)object).start);
                    ((Context)object).match.setEnd(0, n6);
                }
                ((Context)object).setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(cArray, ((Context)object).start, ((Context)object).limit);
            if (n7 >= 0) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, n7);
                    ((Context)object).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((Context)object).setInUse(false);
                return true;
            }
            ((Context)object).setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(cArray, ((Context)object).start, ((Context)object).limit)) < 0) {
            ((Context)object).setInUse(false);
            return false;
        }
        int n8 = ((Context)object).limit - this.minlength;
        int n9 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = ((Context)object).start;
                n9 = this.match((Context)object, this.operations, ((Context)object).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n4 = ((Context)object).start; n4 <= n8; ++n4) {
                    char c2 = cArray[n4];
                    if (RegularExpression.isEOLChar(c2)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n9 = this.match((Context)object, this.operations, n4, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            for (n4 = ((Context)object).start; n4 <= n8; ++n4) {
                int n10 = cArray[n4];
                if (REUtil.isHighSurrogate(n10) && n4 + 1 < ((Context)object).limit) {
                    n10 = REUtil.composeFromSurrogates(n10, cArray[n4 + 1]);
                }
                if (!rangeToken.match(n10) || 0 > (n9 = this.match((Context)object, this.operations, n4, 1, this.options))) {
                    continue;
                }
                break;
            }
        } else {
            for (n4 = ((Context)object).start; n4 <= n8 && 0 > (n9 = this.match((Context)object, this.operations, n4, 1, this.options)); ++n4) {
            }
        }
        if (n9 >= 0) {
            if (((Context)object).match != null) {
                ((Context)object).match.setBeginning(0, n4);
                ((Context)object).match.setEnd(0, n9);
            }
            ((Context)object).setInUse(false);
            return true;
        }
        ((Context)object).setInUse(false);
        return false;
    }

    public boolean matches(String string) {
        return this.matches(string, 0, string.length(), (Match)null);
    }

    public boolean matches(String string, int n2, int n3) {
        return this.matches(string, n2, n3, (Match)null);
    }

    public boolean matches(String string, Match match) {
        return this.matches(string, 0, string.length(), match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(String string, int n2, int n3, Match match) {
        int n4;
        int n5;
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object = null;
        Context context = this.context;
        synchronized (context) {
            object = this.context.inuse ? new Context() : this.context;
            ((Context)object).reset(string, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(string);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.match((Context)object, this.operations, ((Context)object).start, 1, this.options);
            if (n6 == ((Context)object).limit) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, ((Context)object).start);
                    ((Context)object).match.setEnd(0, n6);
                }
                ((Context)object).setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(string, ((Context)object).start, ((Context)object).limit);
            if (n7 >= 0) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, n7);
                    ((Context)object).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((Context)object).setInUse(false);
                return true;
            }
            ((Context)object).setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(string, ((Context)object).start, ((Context)object).limit)) < 0) {
            ((Context)object).setInUse(false);
            return false;
        }
        int n8 = ((Context)object).limit - this.minlength;
        int n9 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = ((Context)object).start;
                n9 = this.match((Context)object, this.operations, ((Context)object).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n4 = ((Context)object).start; n4 <= n8; ++n4) {
                    char c2 = string.charAt(n4);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n9 = this.match((Context)object, this.operations, n4, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            for (n4 = ((Context)object).start; n4 <= n8; ++n4) {
                int n10 = string.charAt(n4);
                if (REUtil.isHighSurrogate(n10) && n4 + 1 < ((Context)object).limit) {
                    n10 = REUtil.composeFromSurrogates(n10, string.charAt(n4 + 1));
                }
                if (!rangeToken.match(n10) || 0 > (n9 = this.match((Context)object, this.operations, n4, 1, this.options))) {
                    continue;
                }
                break;
            }
        } else {
            for (n4 = ((Context)object).start; n4 <= n8 && 0 > (n9 = this.match((Context)object, this.operations, n4, 1, this.options)); ++n4) {
            }
        }
        if (n9 >= 0) {
            if (((Context)object).match != null) {
                ((Context)object).match.setBeginning(0, n4);
                ((Context)object).match.setEnd(0, n9);
            }
            ((Context)object).setInUse(false);
            return true;
        }
        ((Context)object).setInUse(false);
        return false;
    }

    private int match(Context context, Op op, int n2, int n3, int n4) {
        ExpressionTarget expressionTarget = context.target;
        Stack<Op> stack = new Stack<Op>();
        IntStack intStack = new IntStack();
        boolean bl = RegularExpression.isSet(n4, 2);
        int n5 = -1;
        boolean bl2 = false;
        block28: while (true) {
            Object object;
            int n6;
            if (op == null || n2 > context.limit || n2 < context.start) {
                n5 = op == null ? (RegularExpression.isSet(n4, 512) && n2 != context.limit ? -1 : n2) : -1;
                bl2 = true;
            } else {
                n5 = -1;
                switch (op.type) {
                    case 1: {
                        int n7;
                        int n8 = n7 = n3 > 0 ? n2 : n2 - 1;
                        if (n7 >= context.limit || n7 < 0 || !this.matchChar(op.getData(), expressionTarget.charAt(n7), bl)) {
                            bl2 = true;
                            break;
                        }
                        n2 += n3;
                        op = op.next;
                        break;
                    }
                    case 0: {
                        int n9;
                        int n10 = n9 = n3 > 0 ? n2 : n2 - 1;
                        if (n9 >= context.limit || n9 < 0) {
                            bl2 = true;
                            break;
                        }
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(expressionTarget.charAt(n9)) && n9 + n3 >= 0 && n9 + n3 < context.limit) {
                                n9 += n3;
                            }
                        } else {
                            n6 = expressionTarget.charAt(n9);
                            if (REUtil.isHighSurrogate(n6) && n9 + n3 >= 0 && n9 + n3 < context.limit) {
                                n6 = REUtil.composeFromSurrogates(n6, expressionTarget.charAt(n9 += n3));
                            }
                            if (RegularExpression.isEOLChar(n6)) {
                                bl2 = true;
                                break;
                            }
                        }
                        n2 = n3 > 0 ? n9 + 1 : n9;
                        op = op.next;
                        break;
                    }
                    case 3: 
                    case 4: {
                        int n11;
                        int n12 = n11 = n3 > 0 ? n2 : n2 - 1;
                        if (n11 >= context.limit || n11 < 0) {
                            bl2 = true;
                            break;
                        }
                        n6 = expressionTarget.charAt(n2);
                        if (REUtil.isHighSurrogate(n6) && n11 + n3 < context.limit && n11 + n3 >= 0) {
                            n6 = REUtil.composeFromSurrogates(n6, expressionTarget.charAt(n11 += n3));
                        }
                        if (!((RangeToken)(object = op.getToken())).match(n6)) {
                            bl2 = true;
                            break;
                        }
                        n2 = n3 > 0 ? n11 + 1 : n11;
                        op = op.next;
                        break;
                    }
                    case 5: {
                        if (!this.matchAnchor(expressionTarget, op, context, n2, n4)) {
                            bl2 = true;
                            break;
                        }
                        op = op.next;
                        break;
                    }
                    case 16: {
                        int n13 = op.getData();
                        if (n13 <= 0 || n13 >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                        }
                        if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                            bl2 = true;
                            break;
                        }
                        n6 = context.match.getBeginning(n13);
                        int n14 = context.match.getEnd(n13) - n6;
                        if (n3 > 0) {
                            if (!expressionTarget.regionMatches(bl, n2, context.limit, n6, n14)) {
                                bl2 = true;
                                break;
                            }
                            n2 += n14;
                        } else {
                            if (!expressionTarget.regionMatches(bl, n2 - n14, context.limit, n6, n14)) {
                                bl2 = true;
                                break;
                            }
                            n2 -= n14;
                        }
                        op = op.next;
                        break;
                    }
                    case 6: {
                        String string = op.getString();
                        n6 = string.length();
                        if (n3 > 0) {
                            if (!expressionTarget.regionMatches(bl, n2, context.limit, string, n6)) {
                                bl2 = true;
                                break;
                            }
                            n2 += n6;
                        } else {
                            if (!expressionTarget.regionMatches(bl, n2 - n6, context.limit, string, n6)) {
                                bl2 = true;
                                break;
                            }
                            n2 -= n6;
                        }
                        op = op.next;
                        break;
                    }
                    case 7: {
                        int n15 = op.getData();
                        if (context.closureContexts[n15].contains(n2)) {
                            bl2 = true;
                            break;
                        }
                        context.closureContexts[n15].addOffset(n2);
                    }
                    case 9: {
                        stack.push(op);
                        intStack.push(n2);
                        op = op.getChild();
                        break;
                    }
                    case 8: 
                    case 10: {
                        stack.push(op);
                        intStack.push(n2);
                        op = op.next;
                        break;
                    }
                    case 11: {
                        if (op.size() == 0) {
                            bl2 = true;
                            break;
                        }
                        stack.push(op);
                        intStack.push(0);
                        intStack.push(n2);
                        op = op.elementAt(0);
                        break;
                    }
                    case 15: {
                        int n16 = op.getData();
                        if (context.match != null) {
                            if (n16 > 0) {
                                intStack.push(context.match.getBeginning(n16));
                                context.match.setBeginning(n16, n2);
                            } else {
                                n6 = -n16;
                                intStack.push(context.match.getEnd(n6));
                                context.match.setEnd(n6, n2);
                            }
                            stack.push(op);
                            intStack.push(n2);
                        }
                        op = op.next;
                        break;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        stack.push(op);
                        intStack.push(n3);
                        intStack.push(n2);
                        n3 = op.type == 20 || op.type == 21 ? 1 : -1;
                        op = op.getChild();
                        break;
                    }
                    case 24: {
                        stack.push(op);
                        intStack.push(n2);
                        op = op.getChild();
                        break;
                    }
                    case 25: {
                        int n17 = n4;
                        n17 |= op.getData();
                        stack.push(op);
                        intStack.push(n4);
                        intStack.push(n2);
                        n4 = n17 &= ~op.getData2();
                        op = op.getChild();
                        break;
                    }
                    case 26: {
                        Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                        if (conditionOp.refNumber > 0) {
                            if (conditionOp.refNumber >= this.nofparen) {
                                throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                            }
                            if (context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0) {
                                op = conditionOp.yes;
                                break;
                            }
                            if (conditionOp.no != null) {
                                op = conditionOp.no;
                                break;
                            }
                            op = conditionOp.next;
                            break;
                        }
                        stack.push(op);
                        intStack.push(n2);
                        op = conditionOp.condition;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown operation type: " + op.type);
                    }
                }
            }
            block29: while (true) {
                if (!bl2) continue block28;
                if (stack.isEmpty()) {
                    return n5;
                }
                op = (Op)stack.pop();
                n2 = intStack.pop();
                switch (op.type) {
                    case 7: 
                    case 9: {
                        if (n5 >= 0) break;
                        op = op.next;
                        bl2 = false;
                        break;
                    }
                    case 8: 
                    case 10: {
                        if (n5 >= 0) break;
                        op = op.getChild();
                        bl2 = false;
                        break;
                    }
                    case 11: {
                        int n18 = intStack.pop();
                        if (n5 >= 0) continue block29;
                        if (++n18 < op.size()) {
                            stack.push(op);
                            intStack.push(n18);
                            intStack.push(n2);
                            op = op.elementAt(n18);
                            bl2 = false;
                            break;
                        }
                        n5 = -1;
                        break;
                    }
                    case 15: {
                        int n19 = op.getData();
                        n6 = intStack.pop();
                        if (n5 >= 0) break;
                        if (n19 > 0) {
                            context.match.setBeginning(n19, n6);
                            break;
                        }
                        context.match.setEnd(-n19, n6);
                        break;
                    }
                    case 20: 
                    case 22: {
                        n3 = intStack.pop();
                        if (0 <= n5) {
                            op = op.next;
                            bl2 = false;
                        }
                        n5 = -1;
                        break;
                    }
                    case 21: 
                    case 23: {
                        n3 = intStack.pop();
                        if (0 > n5) {
                            op = op.next;
                            bl2 = false;
                        }
                        n5 = -1;
                        break;
                    }
                    case 25: {
                        n4 = intStack.pop();
                    }
                    case 24: {
                        if (n5 < 0) break;
                        n2 = n5;
                        op = op.next;
                        bl2 = false;
                        break;
                    }
                    case 26: {
                        object = (Op.ConditionOp)op;
                        op = 0 <= n5 ? ((Op.ConditionOp)object).yes : (((Op.ConditionOp)object).no != null ? ((Op.ConditionOp)object).no : ((Op.ConditionOp)object).next);
                        bl2 = false;
                        break;
                    }
                }
            }
            break;
        }
    }

    private boolean matchChar(int n2, int n3, boolean bl) {
        return bl ? RegularExpression.matchIgnoreCase(n2, n3) : n2 == n3;
    }

    boolean matchAnchor(ExpressionTarget expressionTarget, Op op, Context context, int n2, int n3) {
        boolean bl = false;
        switch (op.getData()) {
            case 94: {
                if (!(RegularExpression.isSet(n3, 8) ? n2 != context.start && (n2 <= context.start || n2 >= context.limit || !RegularExpression.isEOLChar(expressionTarget.charAt(n2 - 1))) : n2 != context.start)) break;
                return false;
            }
            case 64: {
                if (n2 == context.start || n2 > context.start && RegularExpression.isEOLChar(expressionTarget.charAt(n2 - 1))) break;
                return false;
            }
            case 36: {
                if (!(RegularExpression.isSet(n3, 8) ? n2 != context.limit && (n2 >= context.limit || !RegularExpression.isEOLChar(expressionTarget.charAt(n2))) : !(n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(expressionTarget.charAt(n2)) || n2 + 2 == context.limit && expressionTarget.charAt(n2) == '\r' && expressionTarget.charAt(n2 + 1) == '\n'))) break;
                return false;
            }
            case 65: {
                if (n2 == context.start) break;
                return false;
            }
            case 90: {
                if (n2 == context.limit || n2 + 1 == context.limit && RegularExpression.isEOLChar(expressionTarget.charAt(n2)) || n2 + 2 == context.limit && expressionTarget.charAt(n2) == '\r' && expressionTarget.charAt(n2 + 1) == '\n') break;
                return false;
            }
            case 122: {
                if (n2 == context.limit) break;
                return false;
            }
            case 98: {
                if (context.length == 0) {
                    return false;
                }
                int n4 = RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3);
                if (n4 == 0) {
                    return false;
                }
                int n5 = RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3);
                if (n4 != n5) break;
                return false;
            }
            case 66: {
                if (context.length == 0) {
                    bl = true;
                } else {
                    int n6 = RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3);
                    boolean bl2 = bl = n6 == 0 || n6 == RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3);
                }
                if (bl) break;
                return false;
            }
            case 60: {
                if (context.length == 0 || n2 == context.limit) {
                    return false;
                }
                if (RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3) == 1 && RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3) == 2) break;
                return false;
            }
            case 62: {
                if (context.length == 0 || n2 == context.start) {
                    return false;
                }
                if (RegularExpression.getWordType(expressionTarget, context.start, context.limit, n2, n3) == 2 && RegularExpression.getPreviousWordType(expressionTarget, context.start, context.limit, n2, n3) == 1) break;
                return false;
            }
        }
        return true;
    }

    private static final int getPreviousWordType(ExpressionTarget expressionTarget, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(expressionTarget, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(expressionTarget, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(ExpressionTarget expressionTarget, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(expressionTarget.charAt(n4), n5);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, (Match)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(CharacterIterator characterIterator, Match match) {
        int n2;
        int n3;
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object = null;
        Context context = this.context;
        synchronized (context) {
            object = this.context.inuse ? new Context() : this.context;
            ((Context)object).reset(characterIterator, n4, n5, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.match((Context)object, this.operations, ((Context)object).start, 1, this.options);
            if (n6 == ((Context)object).limit) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, ((Context)object).start);
                    ((Context)object).match.setEnd(0, n6);
                }
                ((Context)object).setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(characterIterator, ((Context)object).start, ((Context)object).limit);
            if (n7 >= 0) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, n7);
                    ((Context)object).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((Context)object).setInUse(false);
                return true;
            }
            ((Context)object).setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n3 = this.fixedStringTable.matches(characterIterator, ((Context)object).start, ((Context)object).limit)) < 0) {
            ((Context)object).setInUse(false);
            return false;
        }
        int n8 = ((Context)object).limit - this.minlength;
        int n9 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = ((Context)object).start;
                n9 = this.match((Context)object, this.operations, ((Context)object).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n2 = ((Context)object).start; n2 <= n8; ++n2) {
                    char c2 = characterIterator.setIndex(n2);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n9 = this.match((Context)object, this.operations, n2, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            for (n2 = ((Context)object).start; n2 <= n8; ++n2) {
                int n10 = characterIterator.setIndex(n2);
                if (REUtil.isHighSurrogate(n10) && n2 + 1 < ((Context)object).limit) {
                    n10 = REUtil.composeFromSurrogates(n10, characterIterator.setIndex(n2 + 1));
                }
                if (!rangeToken.match(n10) || 0 > (n9 = this.match((Context)object, this.operations, n2, 1, this.options))) {
                    continue;
                }
                break;
            }
        } else {
            for (n2 = ((Context)object).start; n2 <= n8 && 0 > (n9 = this.match((Context)object, this.operations, n2, 1, this.options)); ++n2) {
            }
        }
        if (n9 >= 0) {
            if (((Context)object).match != null) {
                ((Context)object).match.setBeginning(0, n2);
                ((Context)object).match.setEnd(0, n9);
            }
            ((Context)object).setInUse(false);
            return true;
        }
        ((Context)object).setInUse(false);
        return false;
    }

    void prepare() {
        Object object;
        int n2;
        this.compile(this.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n2 = this.tokentree.analyzeFirstCharacter((RangeToken)(object = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object).compactRanges();
            this.firstChar = object;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                object = new char[1];
                object[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
        } else if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object = new Token.FixedStringContainer();
            this.tokentree.findFixedString((Token.FixedStringContainer)object, this.options);
            this.fixedString = ((Token.FixedStringContainer)object).token == null ? null : ((Token.FixedStringContainer)object).token.getString();
            this.fixedStringOptions = ((Token.FixedStringContainer)object).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n2, int n3) {
        return (n2 & n3) == n3;
    }

    public RegularExpression(String string) throws ParseException {
        this(string, null);
    }

    public RegularExpression(String string, String string2) throws ParseException {
        this.setPattern(string, string2);
    }

    public RegularExpression(String string, String string2, Locale locale) throws ParseException {
        this.setPattern(string, string2, locale);
    }

    RegularExpression(String string, Token token, int n2, boolean bl, int n3) {
        this.regex = string;
        this.tokentree = token;
        this.nofparen = n2;
        this.options = n3;
        this.hasBackReferences = bl;
    }

    public void setPattern(String string) throws ParseException {
        this.setPattern(string, Locale.getDefault());
    }

    public void setPattern(String string, Locale locale) throws ParseException {
        this.setPattern(string, this.options, locale);
    }

    private void setPattern(String string, int n2, Locale locale) throws ParseException {
        this.regex = string;
        this.options = n2;
        RegexParser regexParser = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema(locale) : new RegexParser(locale);
        this.tokentree = regexParser.parse(this.regex, this.options);
        this.nofparen = regexParser.parennumber;
        this.hasBackReferences = regexParser.hasBackReferences;
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string, String string2) throws ParseException {
        this.setPattern(string, string2, Locale.getDefault());
    }

    public void setPattern(String string, String string2, Locale locale) throws ParseException {
        this.setPattern(string, REUtil.parseOptions(string2), locale);
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object;
        return this.regex.equals(regularExpression.regex) && this.options == regularExpression.options;
    }

    boolean equals(String string, int n2) {
        return this.regex.equals(string) && this.options == n2;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    private static final int getWordType0(char c2, int n2) {
        if (!RegularExpression.isSet(n2, 64)) {
            if (RegularExpression.isSet(n2, 32)) {
                return Token.getRange("IsWord", true).match(c2) ? 1 : 2;
            }
            return RegularExpression.isWordChar(c2) ? 1 : 2;
        }
        switch (Character.getType(c2)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n2) {
        return n2 == 10 || n2 == 13 || n2 == 8232 || n2 == 8233;
    }

    private static final boolean isWordChar(int n2) {
        if (n2 == 95) {
            return true;
        }
        if (n2 < 48) {
            return false;
        }
        if (n2 > 122) {
            return false;
        }
        if (n2 <= 57) {
            return true;
        }
        if (n2 < 65) {
            return false;
        }
        if (n2 <= 90) {
            return true;
        }
        return n2 >= 97;
    }

    private static final boolean matchIgnoreCase(int n2, int n3) {
        char c2;
        if (n2 == n3) {
            return true;
        }
        if (n2 > 65535 || n3 > 65535) {
            return false;
        }
        char c3 = Character.toUpperCase((char)n2);
        if (c3 == (c2 = Character.toUpperCase((char)n3))) {
            return true;
        }
        return Character.toLowerCase(c3) == Character.toLowerCase(c2);
    }

    static final class Context {
        int start;
        int limit;
        int length;
        Match match;
        boolean inuse = false;
        ClosureContext[] closureContexts;
        private StringTarget stringTarget;
        private CharArrayTarget charArrayTarget;
        private CharacterIteratorTarget characterIteratorTarget;
        ExpressionTarget target;

        Context() {
        }

        private void resetCommon(int n2) {
            this.length = this.limit - this.start;
            this.setInUse(true);
            this.match = null;
            if (this.closureContexts == null || this.closureContexts.length != n2) {
                this.closureContexts = new ClosureContext[n2];
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.closureContexts[i2] == null) {
                    this.closureContexts[i2] = new ClosureContext();
                    continue;
                }
                this.closureContexts[i2].reset();
            }
        }

        void reset(CharacterIterator characterIterator, int n2, int n3, int n4) {
            if (this.characterIteratorTarget == null) {
                this.characterIteratorTarget = new CharacterIteratorTarget(characterIterator);
            } else {
                this.characterIteratorTarget.resetTarget(characterIterator);
            }
            this.target = this.characterIteratorTarget;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(String string, int n2, int n3, int n4) {
            if (this.stringTarget == null) {
                this.stringTarget = new StringTarget(string);
            } else {
                this.stringTarget.resetTarget(string);
            }
            this.target = this.stringTarget;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(char[] cArray, int n2, int n3, int n4) {
            if (this.charArrayTarget == null) {
                this.charArrayTarget = new CharArrayTarget(cArray);
            } else {
                this.charArrayTarget.resetTarget(cArray);
            }
            this.target = this.charArrayTarget;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        synchronized void setInUse(boolean bl) {
            this.inuse = bl;
        }
    }

    static final class ClosureContext {
        int[] offsets = new int[4];
        int currentIndex = 0;

        ClosureContext() {
        }

        boolean contains(int n2) {
            for (int i2 = 0; i2 < this.currentIndex; ++i2) {
                if (this.offsets[i2] != n2) continue;
                return true;
            }
            return false;
        }

        void reset() {
            this.currentIndex = 0;
        }

        void addOffset(int n2) {
            if (this.currentIndex == this.offsets.length) {
                this.offsets = this.expandOffsets();
            }
            this.offsets[this.currentIndex++] = n2;
        }

        private int[] expandOffsets() {
            int n2 = this.offsets.length;
            int n3 = n2 << 1;
            int[] nArray = new int[n3];
            System.arraycopy(this.offsets, 0, nArray, 0, this.currentIndex);
            return nArray;
        }
    }

    static final class CharacterIteratorTarget
    extends ExpressionTarget {
        CharacterIterator target;

        CharacterIteratorTarget(CharacterIterator characterIterator) {
            this.target = characterIterator;
        }

        final void resetTarget(CharacterIterator characterIterator) {
            this.target = characterIterator;
        }

        @Override
        final char charAt(int n2) {
            return this.target.setIndex(n2);
        }

        @Override
        final boolean regionMatches(boolean bl, int n2, int n3, String string, int n4) {
            if (n2 < 0 || n3 - n2 < n4) {
                return false;
            }
            return bl ? this.regionMatchesIgnoreCase(n2, n3, string, n4) : this.regionMatches(n2, n3, string, n4);
        }

        private final boolean regionMatches(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                if (this.target.setIndex(n2++) == string.charAt(n5++)) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target.setIndex(n2++)) == (c4 = string.charAt(n5++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }

        @Override
        final boolean regionMatches(boolean bl, int n2, int n3, int n4, int n5) {
            if (n2 < 0 || n3 - n2 < n5) {
                return false;
            }
            return bl ? this.regionMatchesIgnoreCase(n2, n3, n4, n5) : this.regionMatches(n2, n3, n4, n5);
        }

        private final boolean regionMatches(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                if (this.target.setIndex(n2++) == this.target.setIndex(n6++)) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target.setIndex(n2++)) == (c4 = this.target.setIndex(n6++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
    }

    static final class CharArrayTarget
    extends ExpressionTarget {
        char[] target;

        CharArrayTarget(char[] cArray) {
            this.target = cArray;
        }

        final void resetTarget(char[] cArray) {
            this.target = cArray;
        }

        @Override
        char charAt(int n2) {
            return this.target[n2];
        }

        @Override
        final boolean regionMatches(boolean bl, int n2, int n3, String string, int n4) {
            if (n2 < 0 || n3 - n2 < n4) {
                return false;
            }
            return bl ? this.regionMatchesIgnoreCase(n2, n3, string, n4) : this.regionMatches(n2, n3, string, n4);
        }

        private final boolean regionMatches(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                if (this.target[n2++] == string.charAt(n5++)) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, String string, int n4) {
            int n5 = 0;
            while (n4-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target[n2++]) == (c4 = string.charAt(n5++)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }

        @Override
        final boolean regionMatches(boolean bl, int n2, int n3, int n4, int n5) {
            if (n2 < 0 || n3 - n2 < n5) {
                return false;
            }
            return bl ? this.regionMatchesIgnoreCase(n2, n3, n4, n5) : this.regionMatches(n2, n3, n4, n5);
        }

        private final boolean regionMatches(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                if (this.target[n2++] == this.target[n6++]) continue;
                return false;
            }
            return true;
        }

        private final boolean regionMatchesIgnoreCase(int n2, int n3, int n4, int n5) {
            int n6 = n4;
            while (n5-- > 0) {
                char c2;
                char c3;
                char c4;
                char c5;
                if ((c5 = this.target[n2++]) == (c4 = this.target[n6++]) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
    }

    static final class StringTarget
    extends ExpressionTarget {
        private String target;

        StringTarget(String string) {
            this.target = string;
        }

        final void resetTarget(String string) {
            this.target = string;
        }

        @Override
        final char charAt(int n2) {
            return this.target.charAt(n2);
        }

        @Override
        final boolean regionMatches(boolean bl, int n2, int n3, String string, int n4) {
            if (n3 - n2 < n4) {
                return false;
            }
            return bl ? this.target.regionMatches(true, n2, string, 0, n4) : this.target.regionMatches(n2, string, 0, n4);
        }

        @Override
        final boolean regionMatches(boolean bl, int n2, int n3, int n4, int n5) {
            if (n3 - n2 < n5) {
                return false;
            }
            return bl ? this.target.regionMatches(true, n2, this.target, n4, n5) : this.target.regionMatches(n2, this.target, n4, n5);
        }
    }

    static abstract class ExpressionTarget {
        ExpressionTarget() {
        }

        abstract char charAt(int var1);

        abstract boolean regionMatches(boolean var1, int var2, int var3, String var4, int var5);

        abstract boolean regionMatches(boolean var1, int var2, int var3, int var4, int var5);
    }
}

