/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.text.CharacterIterator;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.RegularExpression;

public final class REUtil {
    static final int CACHESIZE = 20;
    static final RegularExpression[] regexCache = new RegularExpression[20];

    private REUtil() {
    }

    static final int composeFromSurrogates(int n2, int n3) {
        return 65536 + (n2 - 55296 << 10) + n3 - 56320;
    }

    static final boolean isLowSurrogate(int n2) {
        return (n2 & 0xFC00) == 56320;
    }

    static final boolean isHighSurrogate(int n2) {
        return (n2 & 0xFC00) == 55296;
    }

    static final String decomposeToSurrogates(int n2) {
        char[] cArray = new char[]{(char)(((n2 -= 65536) >> 10) + 55296), (char)((n2 & 0x3FF) + 56320)};
        return new String(cArray);
    }

    static final String substring(CharacterIterator characterIterator, int n2, int n3) {
        char[] cArray = new char[n3 - n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = characterIterator.setIndex(i2 + n2);
        }
        return new String(cArray);
    }

    static final int getOptionValue(int n2) {
        int n3 = 0;
        switch (n2) {
            case 105: {
                n3 = 2;
                break;
            }
            case 109: {
                n3 = 8;
                break;
            }
            case 115: {
                n3 = 4;
                break;
            }
            case 120: {
                n3 = 16;
                break;
            }
            case 117: {
                n3 = 32;
                break;
            }
            case 119: {
                n3 = 64;
                break;
            }
            case 70: {
                n3 = 256;
                break;
            }
            case 72: {
                n3 = 128;
                break;
            }
            case 88: {
                n3 = 512;
                break;
            }
            case 44: {
                n3 = 1024;
                break;
            }
        }
        return n3;
    }

    static final int parseOptions(String string) throws ParseException {
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = REUtil.getOptionValue(string.charAt(i2));
            if (n3 == 0) {
                throw new ParseException("Unknown Option: " + string.substring(i2), -1);
            }
            n2 |= n3;
        }
        return n2;
    }

    static final String createOptionString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(9);
        if ((n2 & 0x100) != 0) {
            stringBuffer.append('F');
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append('H');
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append('X');
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append('m');
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append('u');
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append('w');
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append('x');
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append(',');
        }
        return stringBuffer.toString().intern();
    }

    static String stripExtendedComment(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            char c2;
            char c3;
            if ((c3 = string.charAt(n3++)) == '\t' || c3 == '\n' || c3 == '\f' || c3 == '\r' || c3 == ' ') {
                if (n4 <= 0) continue;
                stringBuffer.append(c3);
                continue;
            }
            if (c3 == '#') {
                while (n3 < n2 && (c3 = string.charAt(n3++)) != '\r' && c3 != '\n') {
                }
                continue;
            }
            if (c3 == '\\' && n3 < n2) {
                c2 = string.charAt(n3);
                if (c2 == '#' || c2 == '\t' || c2 == '\n' || c2 == '\f' || c2 == '\r' || c2 == ' ') {
                    stringBuffer.append(c2);
                    ++n3;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                ++n3;
                continue;
            }
            if (c3 == '[') {
                ++n4;
                stringBuffer.append(c3);
                if (n3 >= n2) continue;
                c2 = string.charAt(n3);
                if (c2 == '[' || c2 == ']') {
                    stringBuffer.append(c2);
                    ++n3;
                    continue;
                }
                if (c2 != '^' || n3 + 1 >= n2 || (c2 = string.charAt(n3 + 1)) != '[' && c2 != ']') continue;
                stringBuffer.append('^');
                stringBuffer.append(c2);
                n3 += 2;
                continue;
            }
            if (n4 > 0 && c3 == ']') {
                --n4;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = null;
        try {
            String string2 = "";
            String string3 = null;
            if (stringArray.length == 0) {
                System.out.println("Error:Usage: java REUtil -i|-m|-s|-u|-w|-X regularExpression String");
                System.exit(0);
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].length() == 0 || stringArray[i2].charAt(0) != '-') {
                    if (string == null) {
                        string = stringArray[i2];
                        continue;
                    }
                    if (string3 == null) {
                        string3 = stringArray[i2];
                        continue;
                    }
                    System.err.println("Unnecessary: " + stringArray[i2]);
                    continue;
                }
                if (stringArray[i2].equals("-i")) {
                    string2 = string2 + "i";
                    continue;
                }
                if (stringArray[i2].equals("-m")) {
                    string2 = string2 + "m";
                    continue;
                }
                if (stringArray[i2].equals("-s")) {
                    string2 = string2 + "s";
                    continue;
                }
                if (stringArray[i2].equals("-u")) {
                    string2 = string2 + "u";
                    continue;
                }
                if (stringArray[i2].equals("-w")) {
                    string2 = string2 + "w";
                    continue;
                }
                if (stringArray[i2].equals("-X")) {
                    string2 = string2 + "X";
                    continue;
                }
                System.err.println("Unknown option: " + stringArray[i2]);
            }
            RegularExpression regularExpression = new RegularExpression(string, string2);
            System.out.println("RegularExpression: " + regularExpression);
            Match match = new Match();
            regularExpression.matches(string3, match);
            for (int i3 = 0; i3 < match.getNumberOfGroups(); ++i3) {
                if (i3 == 0) {
                    System.out.print("Matched range for the whole pattern: ");
                } else {
                    System.out.print("[" + i3 + "]: ");
                }
                if (match.getBeginning(i3) < 0) {
                    System.out.println("-1");
                    continue;
                }
                System.out.print(match.getBeginning(i3) + ", " + match.getEnd(i3) + ", ");
                System.out.println("\"" + match.getCapturedText(i3) + "\"");
            }
        }
        catch (ParseException parseException) {
            if (string == null) {
                parseException.printStackTrace();
            } else {
                System.err.println("org.apache.xerces.utils.regex.ParseException: " + parseException.getMessage());
                String string4 = "        ";
                System.err.println(string4 + string);
                int n2 = parseException.getLocation();
                if (n2 >= 0) {
                    System.err.print(string4);
                    for (int i4 = 0; i4 < n2; ++i4) {
                        System.err.print("-");
                    }
                    System.err.println("^");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegularExpression createRegex(String string, String string2) throws ParseException {
        RegularExpression regularExpression = null;
        int n2 = REUtil.parseOptions(string2);
        RegularExpression[] regularExpressionArray = regexCache;
        synchronized (regexCache) {
            int n3;
            for (n3 = 0; n3 < 20; ++n3) {
                RegularExpression regularExpression2 = regexCache[n3];
                if (regularExpression2 == null) {
                    n3 = -1;
                    break;
                }
                if (!regularExpression2.equals(string, n2)) continue;
                regularExpression = regularExpression2;
                break;
            }
            if (regularExpression != null) {
                if (n3 != 0) {
                    System.arraycopy(regexCache, 0, regexCache, 1, n3);
                    REUtil.regexCache[0] = regularExpression;
                }
            } else {
                regularExpression = new RegularExpression(string, string2);
                System.arraycopy(regexCache, 0, regexCache, 1, 19);
                REUtil.regexCache[0] = regularExpression;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return regularExpression;
        }
    }

    public static boolean matches(String string, String string2) throws ParseException {
        return REUtil.createRegex(string, null).matches(string2);
    }

    public static boolean matches(String string, String string2, String string3) throws ParseException {
        return REUtil.createRegex(string, string2).matches(string3);
    }

    public static String quoteMeta(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (".*+?{[()|\\^$".indexOf(c2) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(i2 + (n2 - i2) * 2);
                    if (i2 > 0) {
                        stringBuffer.append(string.substring(0, i2));
                    }
                }
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    static void dumpString(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            System.out.print(Integer.toHexString(string.charAt(i2)));
            System.out.print(" ");
        }
        System.out.println();
    }
}

